<?php
class studentsSolutionsBox extends box {
	
	public function display(){
		$coursesTermsTable = new coursesTermsTable;
		$setsTable = new setsTable;
		$egTable = new excerciseGroupsTable;
		if($_GET['course_id'])
			$loaded = $coursesTermsTable->load($_GET['course_id']);
		else
			$loaded = $coursesTermsTable->loadDefault($this->page->user);

		//ZMENA PREDMETU
		if($_POST['submit_course']){
			$url = new url(array('course_id'=>$_POST['course_term']));
			$url->deleteParam("message_id");
			$this->page->redirect($url->makeUrl());
		}
		if($loaded){
			$actions = "<a href='index.php?page=evaluate&solution_id={id}' class='button'>hodnoť</a>";
			$actions .= "<a href='{file_name}' class='button'>riešenie</a>";
			$list = new listing("SELECT ss.*,student_name, student_surname, day, time, place, sets.name as \"set\" FROM students_solutions AS ss " .
								"INNER JOIN (SELECT * FROM students_groups_view WHERE course_term_id=".$coursesTermsTable->get('id').") AS sgv ON ss.student_id=sgv.student_id " .
								"INNER JOIN sets ON ss.set_id = sets.id",
								"students_solution_listing");
			$list->perPage = 50;
			$list->setNoResultMessage("Žiadne riešenie sa nenašlo.");
			$list->sortEnabled = false;
			$list->setOrderBy("submit_time","desc");
			$list->addFilter("sets.course_term_id=".$coursesTermsTable->get('id'));
			$list->boxPosition = "tab1";
			$list->execute();
			$list->displayColumn('student_surname','priezvisko');
			$list->displayColumn('student_name','meno');
			$list->displayColumn('day','skupina');
			$list->displayColumn('set','zostava');
			$list->displayColumn('submit_time','odoslané');
			$list->displayColumn('ip_address','IP');
			$list->displayColumn('id','akcia','',$actions);
			$list->numberingCharacter = "#";
	
			$stylizer1 = new listingStylizer; 
			$stylizer1->addFormatting(array("function",array("dateFormat","submit_time","to_display_with_time"),"submit_time"));
			$stylizer1->addFormatting(array("function",array("studentsSolutionsBox::formatGroup","day","time","place"),"day"));
			$stylizer1->addCondition(array("1","==","1"));

			$ldf = new listingDataFormatting;
			$ldf->addStylizer($stylizer1);
			$list->renderer->setLDF($ldf);
			if($_GET['ajax']){
				echo $list->toHtml();
				exit;
			}
			$this->add("list",$list);
		}
		
		$this->add("loaded",$loaded);
		$this->add("courseName",$coursesTermsTable->getName($this->page->user));
		$this->add("message",$this->getMessage($_GET['message_id']));
		$this->add("coursesCombo",$coursesTermsTable->getCoursesCombo("course_term",$_GET['course_id'],$this->page->user));
		$this->add("courseTerm",$coursesTermsTable);
		$this->add("groupsCombo",$egTable->getCombo('{day} {time} {place}',"id","course_term_id=".$coursesTermsTable->get("id"),"day",true,"onchange='filterGroup(\"".$list->name."\",\"".$list->boxPosition."\",this.value)'"));
		$this->add("setsCombo",$setsTable->getCombo("name","id","course_term_id=".$coursesTermsTable->get('id'),"name",true," onchange='filterSet(\"".$list->name."\",\"".$list->boxPosition."\",this.value)'"));
		parent::display();
	}	
	
	//vracia text spravy po vykonani danej akcie
	public function getMessage($message_id){
		switch($message_id){
			case '1':
				$message = array("text"=>"",'type'=>"success");
			break;	
		}
		return $message;		
	}	
		
	public function formatGroup($day,$time,$place){
		if($day==0)
			return "";
		else	
			return dayOfWeek($day)." ".substr($time,0,-3)." ".$place;
	}
	
	public function setTitle(){
		return "Hodnotenie študentov";
	}
}
?>