<?php
class viewAssignmentBox extends box {
	
	public function display(){
		$student = new studentsTable; 
		$set = new setsTable;
		$courseTerm = new coursesTermsTable;
		$setTypes = new setTypesTable;
		$studentSolution = new studentsSolutionsTable;
		
		//loadneme studenta podla toho, aky user je prihlaseny
		if(!$student->loadWhere("auth_id=".$this->page->user->get("id")))
			return false;
		
		//stranka pozaduje parameter assignment_id 
		//ten musi byt ID z tabulky zostav (sets)
		//zostava s tymto ID musi byt zostava na predmet, ktory je aktiny, na ktory je student zapisany a je potvrdeny ucitelom
		if((!$id = $_GET['assignment_id']) || !$set->load($id) || !$courseTerm->load($set->get('course_term_id')) || !$courseTerm->getBool('is_active') || !$student->isMyCourse($set->get('course_term_id')))
			return false;
		
		if(!$set->isReadable($student->get("id"))){
			return "<h2>".$set->get('name')."</h2>V tomto čase sú tieto úlohy neprístupné.";
		}
		$save_mode = $this->page->user->getSetting("multi_submitting_solution");
		$solution_exists = $studentSolution->loadWhere("student_id=".$student->get('id')." AND set_id=".$set->get('id'));
		
		if($_POST['submit']){
		
			$max_file_size = $this->page->user->getSetting('max_file_size')*1024*1024;
			$allowed_types = explode(",",$this->page->user->getSetting('allowed_file_types'));
			$upload_dir = "files/solutions/".$courseTerm->course->get("short_name").safeFilename($courseTerm->get('year'))."/".safeFilename($set->get('name'));
			if($_FILES['solution']['error']!=0){ //ci sa subor podarilo uploadnut
				$url = new url(array('message_id'=>3));
				$this->page->redirect($url->makeUrl());	
			}
			elseif($_FILES['solution']['size']>$max_file_size){ //ci nie je vacsi ako povolena vekost
				$url = new url(array('message_id'=>1));
				$this->page->redirect($url->makeUrl());	
			}
			elseif(!in_array($_FILES['solution']['type'],$allowed_types)){ //ci nie je ineho typu ako povolene typy
				$url = new url(array('message_id'=>2));
				$this->page->redirect($url->makeUrl());	
			}
			else{
				if($solution_exists && $save_mode == 'disabled'){ //ak nie je dovolene viac krat odoslat riesenie a uz sme raz odovzdali, tak skoncime
					$url = new url(array('message_id'=>5));
					$this->page->redirect($url->makeUrl());
				}
				else{
					$ext = strrchr($_FILES['solution']['name'],'.');				
					$file_name = safeFilename($student->get('surname').$student->get('name')).$ext;
					if($save_mode == 'multiple'){ //ak je nastavena moznost odoslat viackrat bez prepisovania, najdeme este nepouzite meno pre subor
						$file_name = findUnusedFilename($upload_dir,$file_name); 
					}
					if(!is_dir($upload_dir))
						mkdir($upload_dir,0777,true);
					if(!move_uploaded_file($_FILES['solution']['tmp_name'],"$upload_dir/$file_name")){
						$url = new url(array('message_id'=>4));
						$this->page->redirect($url->makeUrl());
					}
					else{
						$studentSolution->set('student_id',$student->get('id'));
						$studentSolution->set('set_id',$set->get('id'));
						$studentSolution->set('submit_time',"NOW()",false,false);
						$studentSolution->set('file_name',"$upload_dir/$file_name");
						$studentSolution->set('ip_address',$_SERVER['REMOTE_ADDR']);
						if($solution_exists && $save_mode=='rewrite')
							$message_id = $studentSolution->save()?6:7;
						else
							$message_id = $studentSolution->add()?6:7;
							
						if($message_id == 7) //ak sa nam nepodarilo ulozit do databazy, tak vymazeme subor, nech je zachovana konzistencia
							unlink("$upload_dir/$file_name");
						$url = new url(array('message_id'=>$message_id));
						$this->page->redirect($url->makeUrl());
					}
				}
			}
		}
		
		$tasksInSetsTable = new tasksInSetsTable;
		$tasksInSet = $tasksInSetsTable->getMyRows("set_id=".$set->get('id'),"order");
		$this->add("tasksInSet",$tasksInSet);
		$this->add("set",$set);	
		$this->add("message",$this->getMessage($_GET['message_id']));
		$this->add("displayForm",!$solution_exists || $save_mode!='disabled');
		parent::display();
	}	

	//vracia text spravy po vykonani danej akcie
	public function getMessage($message_id){
		switch($message_id){
			case '1':
				$message = array("text"=>"Riešenie sa nepodarilo uložiť. Súbor s riešením je príliš veľký.",'type'=>"error");
			break;	
			case '2':
				$message = array("text"=>"Riešenie sa nepodarilo uložiť. Typ súboru nie je podporovaný.",'type'=>"error");
			break;	
			case '3':
				$message = array("text"=>"Riešenie sa nepodarilo uložiť. Chyba pri nahrávaní súboru na server.",'type'=>"error");
			break;
			case '4':
				$message = array("text"=>"Riešenie sa nepodarilo uložiť. Chyba pri ukladaní súboru na server.",'type'=>"error");
			break;				
			case '5':
				$message = array("text"=>"Už ste raz riešenie odoslali. Nie je možné odoslať riešenie znovu.",'type'=>"error");
			break;				
			case '6':
				$message = array("text"=>"Vaše riešenie bolo úspešne odoslané.",'type'=>"success");
			break;				
			case '7':
				$message = array("text"=>"Riešenie sa nepodarilo uložiť.",'type'=>"error");
			break;				
		}
		return $message;		
	}

}
?>