<?php
class taskUsesBox extends box {
	
	public function display(){
		$coursesTermsTable = new coursesTermsTable;
		$course_name_mode = $this->page->user->getSetting('display_course_name_mode');
		$term_str = $this->page->user->getSetting('display_terms')?"|| ' ' || ct.term ":"";
		$open_set = $this->page->user->getSetting('open_set_id');
		$list = new listing("SELECT sets.*,c.name AS course_full, c.short_name AS course_short, ct.year $term_str AS term, ct.id as term_id 
							 FROM tasks_in_sets AS ts 
							 INNER JOIN sets ON sets.id = ts.set_id
							 INNER JOIN courses_terms AS ct ON sets.course_term_id=ct.id
							 INNER JOIN courses AS c ON c.id=ct.course_id",
							"set_basic_listing");
		$list->addFilter("ts.task_id = $_GET[task_id]");
		$list->setOrderBy("date_from","desc");
		$list->perPage = 10;
		$list->sortEnabled = false;
		$list->setNoResultMessage("Žiadna zostava úloh sa nenašla.");
		$list->execute();
		$list->displayColumn('name','názov','name','<a href="index.php?page=set_edit&set_id={id}&tab=2">{name}</a>');
		$list->displayColumn('course','predmet','',"{course_$course_name_mode}");
		$list->displayColumn('term','semester');
		$list->displayColumn('date_from','zverejnené&nbsp;od');
		$list->displayColumn('date_to','zverejnené&nbsp;do');
		$list->numberingCharacter = "#";

		$stylizer1 = new listingStylizer; 
		$stylizer1->addFormatting(array("function",array("dateFormat","date_from","to_display_with_time"),"date_from"));
		$stylizer1->addFormatting(array("function",array("dateFormat","date_to","to_display_with_time"),"date_to"));
		$stylizer1->addCondition(array("1","==","1"));

		$stylizer2 = new listingStylizer; 
		$stylizer2->addFormatting(array("css","background-color: #dfa699","all"));
		$stylizer2->addCondition(array("id","==",$open_set));

		
		$ldf = new listingDataFormatting;
		$ldf->addStylizer($stylizer1);
		$ldf->addStylizer($stylizer2);
		$list->renderer->setLDF($ldf);
		
		if($_GET['ajax']){
			echo $list->toHtml();
			exit;
		}
		$this->add("listing",$list);				
		parent::display();
	}
}
?>