<?php

require("config.inc.php");
require("Database.class.php");

class Data {

	var $db = null;

	public function __construct() {
		global $config;
		$this->db = new Database($config['server'], $config['user'], $config['pass'], $config['database'], $config['tablePrefix']);
		$this->db->connect();	
	}
	
	public function __destruct() {		
		$this->db->close();
		$this->db = null;
	}
	
	public function addUser($data) {			
		$this->db->query_insert('users', $data);		
	}
			
	public function existingUser($username) {
		$query = "SELECT username FROM users WHERE username='". $username ."'";		
		$user = $this->db->query_first($query);			
		if (empty($user)) {
			return false;
		} else {
			return true;
		}		
	}
	
	public function authUser($username, $password) {
		$query = "SELECT id_user, username, type, name, surname, email FROM users WHERE username='". $username ."' AND password='". md5($password) ."'"; 
		return $this->db->fetch_array($this->db->query($query));		
	}
	
	public function existingOrg($org) {
		$query = "SELECT login FROM organizations WHERE login='". $org ."'";		
		$res = $this->db->query_first($query);			
		if (empty($res)) {
			return false;
		} else {
			return true;
		}		
	} 
	
	public function addOrg($data) {			
		$this->db->query_insert('organizations', $data);		
	}	
	
	public function authOrg($login, $password) {
 		$query = "SELECT id_org, login, name, about, contact, accepted FROM organizations WHERE login='". $login ."' AND password='". md5($password) ."'"; 
		return $this->db->fetch_array($this->db->query($query));		
	}
	
	public function getOrganizationIds() {
		$query = "SELECT id_org, name FROM organizations";
		return $this->db->fetch_all_array($query);
	}	
	
	public function getOrganization($id) {
		$query = "SELECT id_org, login, name, about, contact, accepted FROM organizations WHERE id_org='". $id ."'"; 
		return $this->db->fetch_array($this->db->query($query));
	}
	
	public function changeOrgAcceptance($acc, $id_org) {		
		$query = "UPDATE organizations SET accepted='". $acc ."' WHERE id_org='". $id_org ."'";
		$this->db->query($query);
	}
	
	public function addEvent($data) {
		$this->db->query_insert('events', $data);
	}
	
	public function getGenres(){
		$query = "SELECT DISTINCT genre FROM events";
		return $this->db->fetch_all_array($query);	
	}
	
	public function getOrganizationNames() {
		$query = "SELECT id_org, name FROM organizations";
		return $this->db->fetch_all_array($query);
	}
	
	public function addNotification($id_user, $cond) {
		$data['user'] = $id_user;
		$data['condition'] = $cond;
		$this->db->query_insert('notifications', $data);			
	}
	
	public function getNotifications($id_user) {
		$query = "SELECT * FROM notifications WHERE user='". $id_user ."'";
		return $this->db->fetch_all_array($query);	
	}
	
	public function deleteNotification($id_n, $id_u) {
		$query = "DELETE FROM notifications WHERE id_notification='". $id_n ."' AND user='". $id_u ."'";
		$this->db->query($query);
	}
	
	public function sendNotificationEmails() {
		$query = "SELECT MAX(id_event) FROM events";
		$tmp =  $this->db->query_first($query);
		$max  = $tmp['MAX(id_event)'];
		$query = "SELECT * FROM notifications";
		$notifications = $this->db->fetch_all_array($query);
		$file = "out/notification.xml";
		$fh = fopen($file, 'a') or die("can't open file");
		foreach ($notifications as $one) {
			$query = "SELECT * FROM events WHERE id_event='". $max ."' AND ". $one['condition'] ."";
			$tmp =  $this->db->query_first($query);
			if (!empty($tmp)) {
				$stringToFile = "<email>\n" .
								  "\t<date>" . date(DATE_ATOM). "</date>\n" .
								  "\t<sender>" . "admin@localhost.loc" . "</sender>\n" .
								  "\t<receiver>" . $one["user"] . "</receiver>\n" .
								  "\t<message>\n" .
								  	"\t\t<eventId>" . $tmp["id_event"] . "<eventId>\n" .
								  	"\t\t<eventName>" . $tmp["name"] . "<eventName>\n" . 
								  "\t</message>\n" .
							  "</email>\n";						   
				fwrite($fh, $stringToFile);				
			}
		}
		fclose($fh);				
	}
	
	public function getEvents($cond) {
		if ($cond != '0=1') { $cond = substr($cond, 7);}
		$query = "SELECT id_event, name FROM events WHERE ". $cond ."";
		return $this->db->fetch_all_array($query);	
	}
	
	public function getLatestEvents() {
		$query = "SELECT id_event, name FROM events ORDER BY id_event DESC LIMIT 5";
		return $this->db->fetch_all_array($query);
	}
	
	public function getAllEvents() {
		$query = "SELECT id_event, name, organization, city, date FROM events ORDER BY id_event DESC";
		return $this->db->fetch_all_array($query);	
	}
	
	public function getEvent($id) {
		$query = "SELECT events.id_event, events.name as eventName, organizations.Name as orgName, events.organization, events.date, events.city, events.address, events.genre, events.price, events.tickets, events.about FROM events, organizations WHERE organizations.id_org = events.organization AND events.id_event='". $id ."' LIMIT 1";
		return $this->db->query_first($query);
	}
	
	public function sellTicket($id_user, $id_event, $tickets, $address, $account, $ticketCount, $price) {
		if (isset($id_user)) {
			$query = "SELECT id_user FROM users WHERE id_user='". $id_user ."'";
			$user = $this->db->query_first($query);
		} else {
			$user['id_user'] = 'unregistered user';
		}
		$tickets -= $ticketCount;
		$query = "UPDATE events SET tickets='". $tickets ."' WHERE id_event='". $id_event ."'";
		$this->db->query($query);
		$fh = fopen('out/order.xml', 'a') or die("can't open file");
		$stringToFile = "<order>\n\t<id_user>". $user['id_user'] ."</id_user>\n\t<id_event>". $id_event ."</id_event>\n\t<ticketCount>". $ticketCount ."</ticketCount>\n\t<address>". $address ."</address>\n\t<account>". $account ."</account>\n\t<price>". $price ."</price>\n</order>\n";
		fwrite($fh, $stringToFile);	
		fclose($fh);
		
	}
	
}

?>