<?php

//helping functions
require('config.inc.php');
global $config;
require('functions.php');
require('classes/Data.class.php');

//smarty template engine initialization
require($config['smartyPath']);
$smarty = new Smarty();
$smarty->template_dir = 'smarty/templates';
$smarty->compile_dir = 'smarty/templates_c';
$smarty->cache_dir = 'smarty/cache';
$smarty->config_dir = 'smarty/configs';

//session initialization
session_name('session'); 
session_start();
$smarty->assign('session', $_SESSION);

//latest added events
$data = new Data();
$latestEvents = $data->getLatestEvents();
unset($data);
$smarty->assign('latestEvents', $latestEvents);

 	
	//controler switch	
	switch ($_GET['type']) {
	
		case 'logout':
		{
			$_SESSION = array();				
			$_SESSION['isLogged'] = false;
			$_SESSION['type'] = unregisteredUser;				
			header('Location: .');
			break;		
		}
		case 'userRegistration':
		{	
			if (isset($_POST['userRegistration'])) {
				
				$failure = false;
					
 				if (isset($_POST['username'], $_POST['password1'], $_POST['password2'], $_POST['name'], $_POST['surname'], $_POST['email']) &&  
			         areNotEmpty(array($_POST['username'], $_POST['password1'], $_POST['password2'], $_POST['name'], $_POST['surname'], $_POST['email']))) {
				
					if ($_POST['password1'] == $_POST['password2']) {
				
						if (validEmail($_POST['email'])) {
					
							if ((strlen($_POST['password1']) >= 8) && (strlen($_POST['password1']) <= 12)) {							
								$data = new Data();																	
								if (!$data->existingUser($_POST['username'])) {
																										
									$user['username'] = $_POST['username'];
									$user['password'] = md5($_POST['password1']);
									$user['type'] = 'registeredUser';								
									$user['name'] = $_POST['name'];								
									$user['surname'] = $_POST['surname'];
									$user['email'] = $_POST['email'];					
									$data->addUser($user);
									
									$announcements['publish'] = true;
									$announcements['message'] = 'You have been succesfully registered.';
									$smarty->assign('announcements', $announcements);
									$smarty->assign('rightView','userRegistration');
																			
								} else {
									$error['description'] = 'Specified username already exists.';
									$failure = true;								
								}													
								unset($data);																														
							} else {																								
								$error['description'] = 'The password have to be 8-12 characters long.';
								$failure = true;															
							}					
						} else {
							$error['description'] = 'Given email is not a valid email address.';
							$failure = true;
						}
				
					} else {
						$error['description'] = 'Given passwords are not equal.';
						$failure = true;									
					} 					   
				} else {					
					$error['description'] = 'All input fields have to be filled.';
					$failure = true;			
				}
				if ($failure) {
					$error['id'] = 'userRegistrationError';
					$error['username'] = $_POST['username']; 
					$error['name'] = $_POST['name']; 
					$error['surname'] = $_POST['surname']; 
					$error['email'] = $_POST['email'];   								
					$smarty->assign('error', $error);															
					$smarty->assign('rightView','userRegistration');			
				}
			} else {	
				$smarty->assign('rightView','userRegistration');
			}		
			$smarty->display('index.tpl');	
			break;	
		}
		case 'orgRegistration':
		{		
			if (isset($_POST['orgRegistration'])) {
			
				$failure = false;
				
				if (isset($_POST['login'], $_POST['password1'], $_POST['password2'], $_POST['name'], $_POST['about'], $_POST['contact']) &&  
			         areNotEmpty(array($_POST['login'], $_POST['password1'], $_POST['password2'], $_POST['name'], $_POST['about'], $_POST['contact']))) {
				
					if ($_POST['password1'] == $_POST['password2']) {
										
						if ((strlen($_POST['password1']) >= 8) && (strlen($_POST['password1']) <= 12)) {							
							$data = new Data();																	
							if (!$data->existingOrg($_POST['login'])) {
																								
								$org['login'] = $_POST['login'];
								$org['password'] = md5($_POST['password1']);
								$org['name'] = $_POST['name'];
								$org['about'] = $_POST['about'];
								$org['contact'] = $_POST['contact'];					
								$data->addOrg($org);
													
								$announcements['publish'] = true;
								$announcements['message'] = 'You have been succesfully registered.';
								$smarty->assign('announcements', $announcements);
								$smarty->assign('rightView','orgRegistration');
												
							} else {
								$error['description'] = 'Specified login is already in use.';
								$failure = true;					
							}													
							unset($data);																															
						} else {													
							$error['description'] = 'The password have to be 8-12 characters long.';
							$failure = true;
						}									
				
					} else {			
						$error['description'] = 'Given passwords are not equal.';
						$failure = true;	
					} 	
				   
				} else {									
					$error['description'] = 'All input fields have to be filled.';
					$failure = true;	 					
				}
				if ($failure) {
					$error['id'] = 'orgRegistrationError';				
					$error['login'] = $_POST['login'];
 					$error['name'] = $_POST['name'];
					$error['about'] = $_POST['about'];
					$error['contact'] = $_POST['contact'];
					$smarty->assign('error', $error);
					$smarty->assign('rightView','orgRegistration');
				}
														
			} else {	
				$smarty->assign('rightView','orgRegistration');								
			}						
			$smarty->display('index.tpl');
			break;	
		}		
		case 'orgApproval': 
		{
			if ($_SESSION['type'] == 'administrator') {
				$data = new Data();
				if (isset($_POST['cancel'])) {
					$data->changeOrgAcceptance(0, $_POST['id_org']);	
				} else if (isset($_POST['accept'])) {
					$data->changeOrgAcceptance(1, $_POST['id_org']);
				}				
				
				if (isset($_GET['id']) && $_GET['id'] != '') {
					$details = $data->getOrganization($_GET['id']);
					$smarty->assign('rightView','orgApproval');
					$smarty->assign('view', 'detail');
					$smarty->assign('details', $details);
					$smarty->display('index.tpl');			
				} else {
					$ids = $data->getOrganizationIds();
					$smarty->assign('rightView','orgApproval');
					$smarty->assign('view', 'list');
					$smarty->assign('ids', $ids);
					$smarty->display('index.tpl');
				}
				unset($data);
			} else {
				$smarty->display('index.tpl');
			}
			break;
		}	
		case 'addEvent':
		{
			if ($_SESSION['type'] == 'organization') {
				
				if (isset($_POST['addEvent'])) {
				
				$failure = false;
				
				if (isset($_POST['name'], $_POST['city'], $_POST['address'], $_POST['day'], $_POST['month'], $_POST['year'], $_POST['hour'], $_POST['minute'], $_POST['genre'], $_POST['price'], $_POST['tickets'], $_POST['about']) &&
					areNotEmpty(array($_POST['name'], $_POST['city'], $_POST['address'], $_POST['day'], $_POST['month'], $_POST['year'], $_POST['hour'], $_POST['minute'], $_POST['genre'], $_POST['price'], $_POST['tickets'], $_POST['about']))) {
				
					if (ctype_digit($_POST['tickets']) && ctype_digit($_POST['price'])) {
					
						if (ctype_digit($_POST['day']) && ctype_digit($_POST['month']) && ctype_digit($_POST['year']) && ctype_digit($_POST['hour'])  && ctype_digit($_POST['minute'])) {
						
							$data = new Data();
							$event['name'] = $_POST['name'];
							$event['organization'] = $_SESSION['id_org'];
							$event['date'] = makeDatetime($_POST['year'], $_POST['month'], $_POST['day'], $_POST['hour'], $_POST['minute']);
							$event['city'] = strtolower($_POST['city']);
							$event['address'] = $_POST['address'];
							$event['genre'] = $_POST['genre'];
							$event['price'] = $_POST['price'];
							$event['tickets'] = $_POST['tickets'];
							$event['about'] = $_POST['about'];
							$data->addEvent($event);
							$data->sendNotificationEmails();
							unset($data);
							$announcements['publish'] = true;
							$announcements['message'] = 'Event has been succesfully added.';
							$smarty->assign('announcements', $announcements);	
							$smarty->assign('rightView','addEvent');
						
						} else {
							$failure = true;
							$error['description'] = 'Date expects an integer as an input.';
						}
					
					} else {
						$failure = true;
						$error['description'] = 'Both number of tickets and price have to be an integer.';
					} 
				 
				} else{
					$failure = true;
					$error['description'] = 'All input fields have to be filled.';
				} 		
				
				if ($failure) {
					$error['id'] = 'addEventError';				
 					$error['name'] = $_POST['name'];
					$error['day'] = $_POST['day'];
					$error['month'] = $_POST['month'];
					$error['year'] = $_POST['year'];
					$error['hour'] = $_POST['hour'];
					$error['minute'] = $_POST['minute'];
					$error['city'] = $_POST['city'];
					$error['address'] = $_POST['address'];
					$error['genre'] = $_POST['genre'];
					$error['about'] = $_POST['about'];
					$error['price'] = $_POST['price'];
					$error['tickets'] = $_POST['tickets'];
					$smarty->assign('error', $error);
					$smarty->assign('rightView','addEvent');
				}				
				
				} else {
					$smarty->assign('rightView','addEvent');
				}									
			} 
			$smarty->display('index.tpl');			
			break;	
		}
		case 'emailNotification':
		{
			if ($_SESSION['type'] == 'registeredUser') {						
				
				if (isset($_POST['emailNotification'])) {
													
					$failure = false;
					$condition = '0=0'; 
					
					if ($_POST['orgNameCheck'] == 'yes') {
					
						if(isset($_POST['orgName']) && $_POST['orgName'] != '') {						
							$condition .= " AND organization='". $_POST['orgName'] ."'";						
						} else {
							$failure = true;
							$error['description'] = 'All checked conditions have to be properly specified.';
						}
					}
					
					if ($_POST['genreCheck'] == 'yes') {
						if(isset($_POST['genre']) && $_POST['genre'] != '') {						
							$condition .= " AND genre='". $_POST['genre'] ."'";						
						} else {
							$failure = true;
							$error['description'] = 'All checked conditions have to be properly specified.';
						}
					}
					
					if ($_POST['cityCheck'] == 'yes') {	
						if(isset($_POST['city']) && $_POST['city'] != '') {						
							$condition .= " AND city='". strtolower($_POST['city']) ."'";						
						} else {
							$failure = true;
							$error['description'] = 'All checked conditions have to be properly specified.';
						}					
					}
					
					if ($_POST['dateCheck'] == 'yes') {	
						if(isset($_POST['day1'], $_POST['day2'], $_POST['month1'], $_POST['month2'], $_POST['year1'], $_POST['year2']) && 
						   ctype_digit($_POST['day1']) && ctype_digit($_POST['day2']) &&  ctype_digit($_POST['month1']) && ctype_digit($_POST['month2']) && ctype_digit($_POST['year1']) && ctype_digit($_POST['year2'])) {						
							
							$min = makeDatetime($_POST['year1'], $_POST['month1'], $_POST['day1'], 0, 0);
							$max = makeDatetime($_POST['year2'], $_POST['month2'], $_POST['day2'], 0, 0);
							$condition .= " AND date >= '". $min ."' AND date <= '". $max ."'";
													
						} else {
							$failure = true;
							$error['description'] = 'All checked conditions have to be properly specified. All date input is expected to be represented as an integer.';
						}					
					}
					
					if ($_POST['priceCheck'] == 'yes') {	
						if(isset($_POST['price1'], $_POST['price2']) && ctype_digit($_POST['price1']) && ctype_digit($_POST['price2'])) {						
							
							$condition .= " AND price >= '". $_POST['price1'] ."' AND price <= '". $_POST['price2'] ."'";
													
						} else {
							$failure = true;
							$error['description'] = 'All checked conditions have to be properly specified. Both price input is expected to be represented as an integer.';
						}					
					}
					
					if ($failure) {
					$error['id'] = 'emailNotificationError';
					$error['orgNameCheck'] = $_POST['orgNameCheck'];
					$error['genreCheck'] = $_POST['genreCheck'];
					$error['cityCheck'] = $_POST['cityCheck'];
					$error['dateCheck'] = $_POST['dateCheck'];
					$error['priceCheck'] = $_POST['priceCheck'];
					$error['orgName'] = $_POST['orgName'];									
					$error['day1'] = $_POST['day1'];
					$error['month1'] = $_POST['month1'];
					$error['year1'] = $_POST['year1'];
					$error['day2'] = $_POST['day2'];
					$error['month2'] = $_POST['month2'];
					$error['year2'] = $_POST['year2'];					
					$error['city'] = strtolower($_POST['city']);	
					$error['genre'] = $_POST['genre'];									
					$error['price1'] = $_POST['price1'];
					$error['price2'] = $_POST['price2'];
					$smarty->assign('error', $error);
					$smarty->assign('rightView','emailNotification');
					} else {
					
						$data = new Data();
						$data->addNotification($_SESSION['id_user'], $condition);
						unset($data);

						$announcements['publish'] = true;
						$announcements['message'] = 'Email notification has been succesfully added.';
						$smarty->assign('announcements', $announcements);
					}		
																							
				} else if (isset($_POST['editEmailNotification'])) {
				
					$data = new Data();
					$data->deleteNotification($_POST['id_notification'], $_SESSION['id_user']);
					unset($data);
					
					$announcements['publish'] = true;
					$announcements['message'] = 'Email notification has been succesfully deleted.';
					$smarty->assign('announcements', $announcements);	
					
				}
				$data = new Data();
				$genres = $data->getGenres();
				$orgNames = $data->getOrganizationNames();	
				$notifications = $data->getNotifications($_SESSION['id_user']);						
				unset($data);
				if (!empty($notifications)) {
					$smarty->assign('notificationState', true);
					$smarty->assign('notifications', $notifications);
				}				
				$smarty->assign('genres', $genres);
				$smarty->assign('orgNames', $orgNames);
				$smarty->assign('rightView','emailNotification');			
			}			
			$smarty->display('index.tpl');			
			break;
		}
		case 'searchEvents' :		
		{
			if (isset($_POST['searchEvents'])) {
													
				$failure = false;
				$condition = '0=1'; 
					
				if ($_POST['orgNameCheck'] == 'yes') {
				
					if(isset($_POST['orgName']) && $_POST['orgName'] != '') {						
						$condition .= " AND organization='". $_POST['orgName'] ."'";						
					} else {
						$failure = true;
						$error['description'] = 'All checked conditions have to be properly specified.';
					}
				}
					
				if ($_POST['genreCheck'] == 'yes') {
					if(isset($_POST['genre']) && $_POST['genre'] != '') {						
						$condition .= " AND genre='". $_POST['genre'] ."'";						
					} else {
						$failure = true;
						$error['description'] = 'All checked conditions have to be properly specified.';
					}
				}
					
				if ($_POST['cityCheck'] == 'yes') {	
					if(isset($_POST['city']) && $_POST['city'] != '') {						
						$condition .= " AND city='". strtolower($_POST['city']) ."'";						
					} else {
						$failure = true;
						$error['description'] = 'All checked conditions have to be properly specified.';
					}					
				}
					
				if ($_POST['dateCheck'] == 'yes') {	
					if(isset($_POST['day1'], $_POST['day2'], $_POST['month1'], $_POST['month2'], $_POST['year1'], $_POST['year2']) && 
					   ctype_digit($_POST['day1']) && ctype_digit($_POST['day2']) &&  ctype_digit($_POST['month1']) && ctype_digit($_POST['month2']) && ctype_digit($_POST['year1']) && ctype_digit($_POST['year2'])) {						
						
						$min = makeDatetime($_POST['year1'], $_POST['month1'], $_POST['day1'], 0, 0);
						$max = makeDatetime($_POST['year2'], $_POST['month2'], $_POST['day2'], 0, 0);
						$condition .= " AND date >= '". $min ."' AND date <= '". $max ."'";
												
					} else {
						$failure = true;
						$error['description'] = 'All checked conditions have to be properly specified. All date input is expected to be represented as an integer.';
					}					
				}
					
				if ($_POST['priceCheck'] == 'yes') {	
					if(isset($_POST['price1'], $_POST['price2']) && ctype_digit($_POST['price1']) && ctype_digit($_POST['price2'])) {						
						
						$condition .= " AND price >= '". $_POST['price1'] ."' AND price <= '". $_POST['price2'] ."'";
												
					} else {
						$failure = true;
						$error['description'] = 'All checked conditions have to be properly specified. Both price input is expected to be represented as an integer.';
					}					
				}
				if (!$failure) {	
					
					$data = new Data();
					$events = $data->getEvents($condition);
					unset($data);
					
					if (!empty($events)) {
						$smarty->assign('eventsState', true);
						$smarty->assign('events', $events);
						$announcements['publish'] = true;
						$announcements['message'] = 'Events found.';
						$smarty->assign('announcements', $announcements);
					} else {
						$failure = true;
						$error['description'] = 'None of the events matches with specified conditions.';	
					}
				}
				if ($failure) {
					$error['id'] = 'searchEventsError';
					$error['orgNameCheck'] = $_POST['orgNameCheck'];
					$error['genreCheck'] = $_POST['genreCheck'];
					$error['cityCheck'] = $_POST['cityCheck'];
					$error['dateCheck'] = $_POST['dateCheck'];
					$error['priceCheck'] = $_POST['priceCheck'];
					$error['orgName'] = $_POST['orgName'];									
					$error['day1'] = $_POST['day1'];
					$error['month1'] = $_POST['month1'];
					$error['year1'] = $_POST['year1'];
					$error['day2'] = $_POST['day2'];
					$error['month2'] = $_POST['month2'];
					$error['year2'] = $_POST['year2'];					
					$error['city'] = strtolower($_POST['city']);	
					$error['genre'] = $_POST['genre'];									
					$error['price1'] = $_POST['price1'];
					$error['price2'] = $_POST['price2'];
					$smarty->assign('error', $error);
					$smarty->assign('rightView','searchEvents');
				} 	
																							
			}
			$data = new Data();
			$genres = $data->getGenres();
			$orgNames = $data->getOrganizationNames();	
			$smarty->assign('genres', $genres);
			$smarty->assign('orgNames', $orgNames);
			$smarty->assign('rightView','searchEvents');		
			$smarty->display('index.tpl');
			break;			
		}
		case 'viewEvent':
		{
			$data = new Data();
			$event = $data->getEvent($_GET['id']);
			unset($data);
			$smarty->assign('event', $event);
			$smarty->assign('rightView','viewEvent');
			$smarty->display('index.tpl');
			break;
		}		
		case 'viewOrg':
		{
			$data = new Data();
			$org = $data->getOrganization($_GET['id']);
			unset($data);
			$smarty->assign('org', $org);
			$smarty->assign('rightView','viewOrg');
			$smarty->display('index.tpl');
			break;
		}
		case 'buyTicket':
		{
			if (($_SESSION['isLogged'] == false || $_SESSION['type'] == 'registeredUser') && isset($_GET['id']) && $_GET['id'] != '') {
				
				$data = new Data();
				$event = $data->getEvent($_GET['id']);
				unset($data);
				$smarty->assign('event', $event);									
				
				if (isset($_POST['buyTicket'])) {
					
					$failure = false;
					
					if (isset($_POST['address'], $_POST['account'], $_POST['ticketCount']) && 
						areNotEmpty(array($_POST['address'], $_POST['account'], $_POST['ticketCount']))) {						
							
						if ($event['tickets'] - $_POST['ticketCount'] > -1) {
							$data = new Data();
							$data->sellTicket($_SESSION['id_user'], $_GET['id'], $event['tickets'], $_POST['address'], $_POST['account'], $_POST['ticketCount'], $event['price']*$_POST['ticketCount']);
							unset($data);
							$announcements['publish'] = true;
							$announcements['message'] = 'Tickets have been bought.';
							$smarty->assign('announcements', $announcements);	
						} else {
							$failure = true;
							$error['description'] = 'Not enough free tickets to buy.';								
						}
					} else {
						
						$failure = true;
						$error['description'] = 'All fields have to be filled.';
					}
		
					if ($failure) {
						$error['id'] = 'buyTicketError';
						$error['address'] = $_POST['address']; 
						$error['account'] = $_POST['account'];
						$smarty->assign('error', $error);	
						$smarty->assign('rightView', 'buyTicket');
						$smarty->display('index.tpl');
						break;
					}
				} else {
				
					$smarty->assign('rightView', 'buyTicket');
					$smarty->display('index.tpl');
					break;
				
				}
			}
		}
		default: 
		{	
			if (isset($_POST['login']))	{
				
				if (isset($_POST['username'], $_POST['password']) && !empty($_POST['username']) && !empty($_POST['password'])) {
					$data = new Data();
					$user = $data->authUser($_POST['username'], $_POST['password']);
					$org  = $data->authOrg($_POST['username'], $_POST['password']);
										
					if (!empty($user)) {					
						$_SESSION['isLogged'] = true;
						$_SESSION['id_user'] = $user['id_user'];
						$_SESSION['username'] = $user['username'];
						$_SESSION['type'] = $user['type'];   					
						$_SESSION['name'] = $user['name'];
						$_SESSION['surname'] = $user['surname'];
						$_SESSION['email'] = $user['email']; 
						
						header('Location: .');
															
					} else if (!empty($org)) {
					
						if ($org['accepted'] == -1) {   					
							$_SESSION['isLogged'] = false;  
							$error['id'] = 'loginError';
							$error['description'] = 'Your registration has not been accepted yet.';
							$error['username'] = $_POST['username'];
							$smarty->assign('error', $error);
	
						} else if ($org['accepted'] == 0) {   					
							$_SESSION['isLogged'] = false;   						
							$error['id'] = 'loginError';
							$error['description'] = 'Your registration has been not accepted.';
							$error['username'] = $_POST['username'];
							$smarty->assign('error', $error);  	
	
						} else {
							$_SESSION['isLogged'] = true;
							$_SESSION['id_org'] = $org['id_org'];
							$_SESSION['login'] = $org['login']; 
							$_SESSION['type'] = 'organization';
							$_SESSION['name'] = $org['name'];
							$_SESSION['about'] = $org['about'];
							$_SESSION['contact'] = $org['contact']; 
						
							header('Location: .');				
						}
						
					} else {
						$_SESSION['isLogged'] = false;						
						$error['id'] = 'loginError';
						$error['description'] = 'Wrong username or password.';
						$error['username'] = $_POST['username'];
						$smarty->assign('error', $error);
	
					}
					unset($data);
				} else {
					$_SESSION['isLogged'] = false;	
					
					$error['id'] = 'loginError';
					$error['description'] = 'All fields have to be filled.';
					$error['username'] = $_POST['username'];
					$smarty->assign('error', $error);				
								
				}
				 				
			}
			$smarty->assign('session', $_SESSION);			
			
			$data = new Data();
			$events = $data->getAllEvents();			
			unset($data);	  			
			$pages = count($events);
			if ($pages % 3 == 0) {
				$pages /= 3;
			} else {
				$pages = $pages / 3 + 1;
			}
			if (isset($_GET['page'])) {
				$page = $_GET['page'];
			} else {
				$page = 1;
			}			
			$smarty->assign('events', $events);
			$smarty->assign('pages', $pages);
			$smarty->assign('page', $page);
			$smarty->display('index.tpl');	
		}	
	}	

?>