﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AUDIOTEKA
{
    public partial class AddGenre : System.Web.UI.UserControl
    {
        DataClassesDataContext _db = new DataClassesDataContext();
        IEnumerable<Genre> _data;

        protected void LoadData()
        {
            _data = from genre in _db.Genres
                    orderby genre.GenreName ascending
                    select genre;
        }

        protected void Page_Load(object sender, EventArgs e)
        {

            LabelSuccess.Visible = false;
            Label_GenreExists.Visible = false;

        }
        protected void AddGenreButton_Click(object sender, EventArgs e)
        {

            if (GenreBox.Text != "")
            {

                Genre newGenre;
                int gcount = (from g in _db.Genres
                              where g.GenreName == GenreBox.Text
                              select g).Count();

                if (gcount == 0)
                {
                    newGenre = new Genre();
                    newGenre.GenreName = GenreBox.Text;

                    _db.Genres.InsertOnSubmit(newGenre);
                    _db.SubmitChanges();

                    LoadData();

                    GenreBox.Text = "";
                    LabelSuccess.Visible = true;

                }
                else
                {
                    Label_GenreExists.Visible = true;
                }
            }
        }
    }
}