﻿<%@ Page Title="" Language="C#" MasterPageFile="~/MasterDesign.Master" AutoEventWireup="true"
    CodeBehind="AlbumPage.aspx.cs" Inherits="AUDIOTEKA.AlbumPage" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainPlaceHolder" runat="server">
    <h2>
        Zoznam albumov
    </h2>
    <asp:Label ID="LabelSuccess" ForeColor="Red" runat="server" Text="Album bol úspešne pridaný do osobného zoznamu!"></asp:Label>
    <asp:Label ID="LabelAlready" ForeColor="Red" runat="server" Text="Album sa už nachádza v osobnom zozname!"></asp:Label>
    <asp:Label ID="LabelMissing" ForeColor="Red" runat="server" Text="Album neexistuje!"></asp:Label>
    <br />
    <b>Hladať: </b>
    <asp:TextBox ID="SearchTextBox" runat="server" />
    &nbsp;
    <asp:Button ID="SearchButton" runat="server" Text="Hľadať" />
    <br />
    <br />
    <b>Zobraziť: </b>
    <asp:DropDownList ID="ArtistDDList" runat="server" AppendDataBoundItems="true" AutoPostBack="true">
        <asp:ListItem Text="- Všetkých autorov -" Value="-1" Selected="True" />
    </asp:DropDownList>
    <asp:DropDownList ID="GenreDDList" runat="server" AppendDataBoundItems="true" AutoPostBack="true">
        <asp:ListItem Text="- Všetky žánre -" Value="-1" Selected="True" />
    </asp:DropDownList>
    <br />
    <br />
    <asp:GridView ID="AlbumsGridView" DataSourceID="AlbumsDataSource" AllowPaging="true"
        AllowSorting="true" PageSize="15" DataKeyNames="AlbumId" runat="server" AutoGenerateColumns="false"
        OnSelectedIndexChanging="GridView_RowSelect">
        <RowStyle CssClass="rowA" />
        <AlternatingRowStyle CssClass="rowB" />
        <HeaderStyle CssClass="rowH" BorderColor="Black" ForeColor="White" Font-Underline="false" />
        <Columns>
            <asp:HyperLinkField ItemStyle-BorderColor="black" HeaderText="Autor" DataNavigateUrlFormatString="~/ArtistDetail.aspx?artid={0}"
                DataNavigateUrlFields="ArtistId" DataTextField="ArtistName" SortExpression="ArtistName" />
            <%-- <asp:BoundField ItemStyle-BorderColor="black" DataField="ArtistName" HeaderText="Autor"
                SortExpression="ArtistName" />--%>
            <asp:BoundField ItemStyle-BorderColor="black" DataField="Year" HeaderText="Rok vydania"
                SortExpression="Year" />
            <asp:HyperLinkField ItemStyle-BorderColor="black" HeaderText="Album" DataNavigateUrlFormatString="~/AlbumDetail.aspx?albid={0}"
                DataNavigateUrlFields="AlbumId" DataTextField="AlbumName" SortExpression="AlbumName" />
            <%--    <asp:BoundField ItemStyle-BorderColor="black" DataField="AlbumName" HeaderText="Album"
                SortExpression="AlbumName" />--%>
            <asp:BoundField ItemStyle-BorderColor="black" DataField="GenreName" HeaderText="Žáner"
                SortExpression="GenreName" />
            <asp:CommandField ShowSelectButton="true" SelectText="Pridať" ItemStyle-HorizontalAlign="Center"
                ItemStyle-BorderColor="black" HeaderText="Môj zoznam" />
        </Columns>
        <PagerStyle BorderStyle="Solid" BorderWidth="1px" BorderColor="white" />
    </asp:GridView>
    <asp:ObjectDataSource SortParameterName="SortExpression" TypeName="AUDIOTEKA.AlbumItems"
        SelectMethod="SelectPage" SelectCountMethod="SelectCount" ID="AlbumsDataSource"
        runat="server" EnablePaging="true">
        <SelectParameters>
            <asp:ControlParameter ControlID="ArtistDDList" PropertyName="SelectedValue" DefaultValue="null"
                Name="FilterArtistId" Type="Int32" />
            <asp:ControlParameter ControlID="GenreDDList" PropertyName="SelectedValue" DefaultValue="null"
                Name="FilterGenreId" Type="Int32" />
            <asp:ControlParameter ControlID="SearchTextBox" PropertyName="Text" Name="Search"
                Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="LeftPlaceHolder" runat="server">
</asp:Content>
