﻿<%@ Page Title="" Language="C#" MasterPageFile="~/MasterDesign.Master" AutoEventWireup="true"
    CodeBehind="ManageAlbums.aspx.cs" Inherits="AUDIOTEKA.ManageAlbums" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainPlaceHolder" runat="server">
    <h2>
        Správa Albumov
    </h2>
    Pridať <a href="NewAlbum.aspx" title="Pridanie nového autora.">nový album</a>.
    <br />
    <br />
    <asp:PlaceHolder ID="EditPlaceHolder" runat="server">
        <h3 id="EditNadpis" runat="server">
        </h3>
        <table>
            <tr>
                <td>
                    <asp:Label AssociatedControlID="EditArtistDDList" ID="Label1" runat="server" Text="Label">Autor: </asp:Label>
                </td>
                <td>
                    <asp:DropDownList ID="EditArtistDDList" runat="server">
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label AssociatedControlID="EditAlbumNameTextBox" ID="EditAlbumNameLabel" runat="server"
                        Text="Label">Názov albumu: </asp:Label>
                </td>
                <td>
                    <asp:TextBox ID="EditAlbumNameTextBox" runat="server" MaxLength="256">
                    </asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label AssociatedControlID="EditYearTextBox" ID="EditYearLabel" runat="server"
                        Text="Label">Rok: </asp:Label>
                </td>
                <td>
                    <asp:TextBox ID="EditYearTextBox" runat="server" MaxLength="10">
                    </asp:TextBox><br />
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label AssociatedControlID="EditGenreDDList" ID="EditGenreLabel" runat="server"
                        Text="Label">Žáner: </asp:Label>
                </td>
                <td>
                    <asp:DropDownList ID="EditGenreDDList" runat="server">
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td colspan="2" align="center">
                    <asp:Button ID="EditAlbumButton" runat="server" Text="Uložiť zmeny" OnClick="EditAlbumButton_Click" />
                    <br />
                    <asp:Label runat="server" ID="SuccessLabel" Text="Album bol úspešne upravený" ForeColor="Red" />
                    <asp:Label ID="FalseLabel" runat="server" ForeColor="Red" Text="Skontrolujte zadané údaje!" />
                    <asp:Label ID="RequiredLabel" runat="server" ForeColor="Red" Text="Je nutné vyplniť aspoň to čo treba vyplniť :)  teda meno albumu" />
                    <asp:HiddenField ID="EditHiddenField" runat="server" />
                </td>
            </tr>
        </table>
        <br />
    </asp:PlaceHolder>
    <b>Filter: </b>
    <br />
    Autor:&nbsp;
    <asp:DropDownList ID="ArtistDDList" runat="server" AppendDataBoundItems="true" AutoPostBack="true">
        <asp:ListItem Text="- Všetkých autorov -" Value="-1" Selected="True" />
    </asp:DropDownList>
    &nbsp;&nbsp; Žáner: &nbsp;
    <asp:DropDownList ID="GenreDDList" runat="server" AppendDataBoundItems="true" AutoPostBack="true">
        <asp:ListItem Text="- Všetky žánre -" Value="-1" Selected="True" />
    </asp:DropDownList>
    <br />
    <br />
    <asp:GridView AllowPaging="true" PageSize="10" DataSourceID="AlbumsDataSource" ID="AlbumsGridView"
        DataKeyNames="AlbumId" runat="server" AllowSorting="true" AutoGenerateColumns="false"
        OnSelectedIndexChanging="AlbumGridView_RowEdit" OnRowDeleting="AlbumGridView_RowDelete">
        <RowStyle CssClass="rowA" />
        <AlternatingRowStyle CssClass="rowB" />
        <HeaderStyle CssClass="rowH" BorderColor="Black" ForeColor="White" Font-Underline="false" />
        <Columns>
            <asp:BoundField ItemStyle-BorderColor="black" DataField="ArtistName" HeaderText="Autor"
                SortExpression="ArtistName" />
            <asp:BoundField ItemStyle-BorderColor="black" DataField="Year" HeaderText="Rok"
                SortExpression="Year" />
            <asp:BoundField ItemStyle-BorderColor="black" DataField="AlbumName" HeaderText="Album"
                SortExpression="AlbumName" />
            <asp:BoundField ItemStyle-BorderColor="black" DataField="GenreName" HeaderText="Žáner"
                SortExpression="GenreName" />
            <asp:CommandField HeaderText="Akcia" ItemStyle-BorderColor="Black" ShowSelectButton="true"
                ShowDeleteButton="true" DeleteText="Zmazať" SelectText="Upraviť" />
        </Columns>
        <PagerStyle BorderStyle="Solid" BorderWidth="1px" BorderColor="white" />
    </asp:GridView>
    <asp:ObjectDataSource SortParameterName="SortExpression" TypeName="AUDIOTEKA.AlbumItems"
        SelectMethod="SelectPage" SelectCountMethod="SelectCount" ID="AlbumsDataSource"
        OnDeleting="ObjectDataSource_DeleteMethod" runat="server" EnablePaging="true"
        DeleteMethod="DeleteAlbum">
        <DeleteParameters>
            <asp:Parameter Name="AlbId" Type="Int32" />
        </DeleteParameters>
        <SelectParameters>
            <asp:ControlParameter ControlID="ArtistDDList" PropertyName="SelectedValue" DefaultValue="null"
                Name="FilterArtistId" Type="Int32" />
            <asp:ControlParameter ControlID="GenreDDList" PropertyName="SelectedValue" DefaultValue="null"
                Name="FilterGenreId" Type="Int32" />
            <asp:Parameter DefaultValue="" Type="String" Name="Search" />
        </SelectParameters>
    </asp:ObjectDataSource>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="LeftPlaceHolder" runat="server">
</asp:Content>
