﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.Security;

namespace AUDIOTEKA
{
    public partial class ManageUsers : System.Web.UI.Page
    {
        MembershipUserCollection _Users;

        protected void Page_Load(object sender, EventArgs e)
        {
            _Users = Membership.GetAllUsers();
            UserGridView.DataSource = _Users;

            if (!Page.IsPostBack)
            {
                UserGridView.DataBind();
            }
        }
        protected void Users_DeleteUser(object sender, GridViewDeleteEventArgs e)
        {
            string UserToDelete = UserGridView.DataKeys[e.RowIndex].Value.ToString();

            if (UserToDelete == User.Identity.Name)
            {
                FormsAuthentication.SignOut();
            }

            Membership.DeleteUser(UserToDelete);

            _Users = Membership.GetAllUsers();
            UserGridView.DataSource = _Users;
            UserGridView.DataBind();
        }
    }
}
