﻿<%@ Page Title="" Language="C#" MasterPageFile="~/MasterDesign.Master" AutoEventWireup="true"
    CodeBehind="MyAlbumPage.aspx.cs" Inherits="AUDIOTEKA.MyAlbumPage" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainPlaceHolder" runat="server">
    <h2>
        Súkromný zoznam albumov
    </h2>
    <br />
    <asp:PlaceHolder ID="EditPlaceHolder" runat="server">
        <h3 id="EditNadpis" runat="server">
            Úprava informácií o albume
        </h3>
        <asp:Label ID="EditQualityLabel" runat="server" Text="Kvalita: " AssociatedControlID="EditQualityTextBox" />
        <asp:TextBox ID="EditQualityTextBox" runat="server" />
        &nbsp;
        <asp:Label ID="Label1" runat="server" ToolTip="1 - najhorsie, 5 - najlepsie" Text="Hodnotenie: "
            AssociatedControlID="EditDropDownList" />
        <asp:DropDownList Width="3em" ToolTip="Cim viac, tym lepsie" ID="EditDropDownList"
            runat="server">
            <asp:ListItem Text="1" Value="1" />
            <asp:ListItem Text="2" Value="2" />
            <asp:ListItem Text="3" Value="3" />
            <asp:ListItem Text="4" Value="4" />
            <asp:ListItem Text="5" Value="5" />
        </asp:DropDownList>
        &nbsp;
        <asp:Label AssociatedControlID="EditStorageTextBox" ID="EditStorageLabel" runat="server"
            Text="Storage: " />
        <asp:TextBox ID="EditStorageTextBox" runat="server" />&nbsp;&nbsp;
        <asp:Button ID="Button1" runat="server" Text="Uprav" OnClick="EditButton_Click" />
        <asp:HiddenField ID="EditHiddenField" runat="server" />
        <br />
        <asp:Label ID="EditAlbumExistsLabel" ForeColor="Red" runat="server" Text="Album neexistuje!"></asp:Label>
        <br />
        <br />
    </asp:PlaceHolder>
        <br />
    <b>Hladať: </b>
    <asp:TextBox ID="SearchTextBox" runat="server" />
    &nbsp;
    <asp:Button ID="SearchButton" runat="server" Text="Hľadať" />
    <br />
    <br />
    
    <b>Filter: </b>
    <br />
    Autor:&nbsp;
    <asp:DropDownList ID="ArtistDDList" runat="server" AppendDataBoundItems="true" AutoPostBack="true">
        <%-- <asp:ListItem Text="- Všetkých autorov -" Value="-1" Selected="True" />--%>
    </asp:DropDownList>
    &nbsp;&nbsp; Žáner: &nbsp;
    <asp:DropDownList ID="GenreDDList" runat="server" AppendDataBoundItems="true" AutoPostBack="true">
        <%-- <asp:ListItem Text="- Všetky žánre -" Value="-1" Selected="True" />--%>
    </asp:DropDownList>
    &nbsp;&nbsp; Úložné médium: &nbsp;
    <asp:DropDownList ID="StorageDDList" runat="server" AppendDataBoundItems="true" AutoPostBack="true">
    </asp:DropDownList>
    <br />
    <br />
    <asp:GridView ID="MyAlbumsGridView" DataSourceID="MyAlbumsDataSource" AllowPaging="true"
        AllowSorting="true" PageSize="15" DataKeyNames="AlbumId" runat="server" AutoGenerateColumns="false"
        OnRowDeleting="GridView_RowDeleting" OnSelectedIndexChanging="GridView_RowEdit">
        <RowStyle CssClass="rowA" />
        <AlternatingRowStyle CssClass="rowB" />
        <HeaderStyle CssClass="rowH" BorderColor="Black" ForeColor="White" Font-Underline="false" />
        <Columns>
            <asp:BoundField ItemStyle-BorderColor="black" DataField="ArtistName" HeaderText="Autor"
                SortExpression="ArtistName" />
            <asp:BoundField ItemStyle-BorderColor="black" DataField="Year" HeaderText="Rok" SortExpression="Year" />
            <asp:BoundField ItemStyle-BorderColor="black" DataField="AlbumName" HeaderText="Album"
                SortExpression="AlbumName" />
            <asp:BoundField ItemStyle-BorderColor="black" DataField="GenreName" HeaderText="Žáner"
                SortExpression="GenreName" />
            <asp:BoundField ItemStyle-BorderColor="black" DataField="Quality" HeaderText="Kvalita"
                SortExpression="Quality" />
            <asp:BoundField ItemStyle-BorderColor="black" DataField="Rating" HeaderText="Hodnotenie"
                SortExpression="Rating" />
            <asp:BoundField ItemStyle-BorderColor="black" DataField="StorageMedium" HeaderText="Úložné médium"
                SortExpression="StorageMedium" />
            <asp:CommandField ItemStyle-BorderColor="black" ShowSelectButton="true" ShowDeleteButton="true"
                SelectText="Uprav" DeleteText="Zmaž" HeaderText="Akcia" />
        </Columns>
        <PagerStyle BorderStyle="Solid" BorderWidth="1px" BorderColor="white" />
    </asp:GridView>
    <asp:ObjectDataSource TypeName="AUDIOTEKA.MyAlbumItems" SelectMethod="SelectPage"
        SortParameterName="SortExpression" SelectCountMethod="SelectCount" ID="MyAlbumsDataSource"
        runat="server" EnablePaging="true" OnDeleting="ObjectDataSource_DeleteMethod"
        DeleteMethod="DeleteAlbum">
        <DeleteParameters>
            <asp:Parameter Name="AlbId" Type="Int32" />
        </DeleteParameters>
        <SelectParameters>
            <asp:ControlParameter ControlID="ArtistDDList" PropertyName="SelectedValue" DefaultValue="null"
                Name="FilterArtistId" Type="Int32" />
            <asp:ControlParameter ControlID="GenreDDList" PropertyName="SelectedValue" DefaultValue="null"
                Name="FilterGenreId" Type="Int32" />
            <asp:ControlParameter ControlID="StorageDDList" PropertyName="SelectedValue" DefaultValue=""
                Name="FilterStorage" Type="String" />
            <asp:ControlParameter ControlID="SearchTextBox" PropertyName="Text" Name="Search"
                Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="LeftPlaceHolder" runat="server">
</asp:Content>
