﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections;
using System.Web.Security;

namespace AUDIOTEKA
{
    public partial class MyAlbumPage : System.Web.UI.Page
    {
        DataClassesDataContext _db = new DataClassesDataContext();
        IEnumerable<Artist> _Artists;
        IEnumerable<Genre> _Genres;
        IEnumerable<string> _Storages;
        ListItem LItem;

        protected void initDDLists()
        {

            ArtistDDList.Items.Clear();
            GenreDDList.Items.Clear();
            StorageDDList.Items.Clear();

            LItem = new ListItem();
            LItem.Text = "- Všetkých autorov -";
            LItem.Value = "-1";
            LItem.Selected = true;

            ArtistDDList.Items.Add(LItem);
            ArtistDDList.DataSource = _Artists;
            ArtistDDList.DataValueField = "ArtistId";
            ArtistDDList.DataTextField = "LastName";
            ArtistDDList.DataBind();

            LItem = new ListItem();
            LItem.Text = "- Všetky žánre -";
            LItem.Value = "-1";
            LItem.Selected = true;

            GenreDDList.Items.Add(LItem);
            GenreDDList.DataSource = _Genres;
            GenreDDList.DataValueField = "GenreId";
            GenreDDList.DataTextField = "GenreName";
            GenreDDList.DataBind();

            LItem = new ListItem();
            LItem.Text = "- Všetky médiá -";
            LItem.Value = "";
            LItem.Selected = true;
            StorageDDList.Items.Add(LItem);

            foreach (string item in _Storages)
            {
                LItem = new ListItem();
                LItem.Text = item;
                LItem.Value = item;
                LItem.Selected = false;
                StorageDDList.Items.Add(LItem);
            }
        }

        protected void Page_Load(object sender, EventArgs e)
        {
            _Artists = from art in _db.Artists
                       orderby art.LastName ascending
                       select art;

            _Genres = from g in _db.Genres
                      orderby g.GenreName ascending
                      select g;

            _Storages = (from alb in _db.PersonalAlbums
                         orderby alb.StorageMedium ascending
                         where alb.StorageMedium != "" & alb.StorageMedium != null
                         select alb.StorageMedium).Distinct();

            // _Storages = _Storages.Distinct();
            if (!Page.IsPostBack)
            {
                initDDLists();
            }

            EditPlaceHolder.Visible = false;
            EditAlbumExistsLabel.Visible = false;
        }

        protected void ObjectDataSource_DeleteMethod(object sender, ObjectDataSourceMethodEventArgs e)
        {
            IDictionary paramsFromPage = e.InputParameters;

            paramsFromPage.Remove("AlbId");
            paramsFromPage.Add("AlbId", (int)paramsFromPage["AlbumId"]);
            paramsFromPage.Remove("AlbumId");

        }

        protected void GridView_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            PersonalAlbum AlbumToDelete = null;
            int AlbumToDeleteId = (int)MyAlbumsGridView.DataKeys[e.RowIndex].Value;

            MembershipUser myUser = Membership.GetUser();
            Guid UserID = (Guid)myUser.ProviderUserKey;

            try
            {
                AlbumToDelete = (from alb in _db.PersonalAlbums
                                 where alb.AlbumId == AlbumToDeleteId & alb.UserId == UserID
                                 select alb).First();
            }
            catch (Exception)
            {
                AlbumToDelete = null;
            }

            if (AlbumToDelete != null)
            {
                _db.PersonalAlbums.DeleteOnSubmit(AlbumToDelete);
                _db.SubmitChanges();
            }

        }
        protected void GridView_RowEdit(object sender, GridViewSelectEventArgs e)
        {
            EditHiddenField.Value = "";

            int AlbumId = (int)MyAlbumsGridView.DataKeys[e.NewSelectedIndex].Value;

            MembershipUser myUser = Membership.GetUser();
            Guid UserID = (Guid)myUser.ProviderUserKey;

            PersonalAlbum PAlbumToEdit = null;
            string AlbumName = null;

            try
            {
                PAlbumToEdit = (from pa in _db.PersonalAlbums
                                where pa.AlbumId == AlbumId & pa.UserId == UserID
                                select pa).First();

                AlbumName = (from a in _db.Albums
                             where a.AlbumId == AlbumId
                             select a.AlbumName).First();
            }
            catch (Exception)
            {
                PAlbumToEdit = null;
                AlbumName = "";
            }



            if (PAlbumToEdit != null)
            {
                EditPlaceHolder.Visible = true;
                EditNadpis.InnerText = "Úprava informácií k albumu: " + AlbumName;
                EditHiddenField.Value = AlbumId.ToString();
                EditQualityTextBox.Text = PAlbumToEdit.Quality;
                EditStorageTextBox.Text = PAlbumToEdit.StorageMedium;
                EditDropDownList.SelectedIndex = Convert.ToInt32(PAlbumToEdit.Rating) - 1;
            }
        }
        protected void EditButton_Click(object sender, EventArgs e)
        {
            MembershipUser myUser = Membership.GetUser();
            Guid UserID = (Guid)myUser.ProviderUserKey;

            int albumcount = (from pa in _db.PersonalAlbums
                              where pa.AlbumId.ToString() == EditHiddenField.Value.ToString() & pa.UserId == UserID
                              select pa).Count();

            if (albumcount == 1)
            {
                PersonalAlbum AlbumToEdit = null;

                try
                {
                    AlbumToEdit = (from pa in _db.PersonalAlbums
                                   where pa.AlbumId.ToString() == EditHiddenField.Value.ToString() & pa.UserId == UserID
                                   select pa).First();
                }
                catch (Exception)
                {
                    AlbumToEdit = null;
                }

                if (AlbumToEdit != null)
                {
                    AlbumToEdit.Quality = EditQualityTextBox.Text;
                    AlbumToEdit.StorageMedium = EditStorageTextBox.Text;
                    AlbumToEdit.Rating = EditDropDownList.SelectedValue;

                    _db.SubmitChanges();

                    EditPlaceHolder.Visible = false;
                    MyAlbumsDataSource.DataBind();
                    MyAlbumsGridView.DataBind();

                }

                EditPlaceHolder.Visible = false;
            }
            else
            {
                EditAlbumExistsLabel.Visible = true;
            }

        }
    }
}
