package mildo.wiwo.action;

import com.webobjects.appserver.WOComponent;
import com.webobjects.eocontrol.EOEnterpriseObject;

import mildo.wiwo.Session;
import mildo.wiwo.components.EditKeywordComp;
import mildo.wiwo.components.EditNamespaceComp;
import mildo.wiwo.components.EditUserComp;
import mildo.wiwo.components.descriptors.IActionDescriptor;
import mildo.wiwo.data.WiwoKeyword;
import mildo.wiwo.data.WiwoNamespace;
import mildo.wiwo.data.WiwoUser;

public class EditAction 
	implements IActionDescriptor
{

	public EditAction() {
	}
	
	private Session session;
	private WOComponent parent;
	private String actionName = "Edit";
	private EOEnterpriseObject object;
	
	public String getActionName() {
		return actionName;
	}

	public EOEnterpriseObject getObject() {
		return object;
	}

	public WOComponent performAction() {
		if (object instanceof WiwoNamespace) {
			EditNamespaceComp theEditComp = (EditNamespaceComp) parent.pageWithName(EditNamespaceComp.class.getName());
			theEditComp.setNamespace((WiwoNamespace)object);
			return theEditComp;
		}
		if (object instanceof WiwoUser) {
			EditUserComp theEditComp = (EditUserComp) parent.pageWithName(EditUserComp.class.getName());
			theEditComp.setUser2Edit((WiwoUser)object);
			return theEditComp;
		}
		if (object instanceof WiwoKeyword) {
			EditKeywordComp theEditComp = (EditKeywordComp) parent.pageWithName(EditKeywordComp.class.getName());
			theEditComp.setKeyword((WiwoKeyword)object);
			return theEditComp;
		}
		return null;
	}

	public void setActionName(String value) {
		actionName = value;
	}

	public void setObject(EOEnterpriseObject value) {
		object = value;
	}

	public Session getSession() {
		return session;
	}
	
	public WOComponent getParent() {
		return parent;
	}

	public void setComponent(WOComponent value) {
		parent = value;
	}

	public void setSession(Session aSession) {
		session = aSession;
	}
	
}
