package mildo.wiwo.action;

import mildo.wiwo.Session;
import mildo.wiwo.components.descriptors.IActionDescriptor;
import mildo.wiwo.helpers.URLBuilder;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WORedirect;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSMutableDictionary;

public class ShowWiwoPageAction 
	implements IActionDescriptor
{

	public ShowWiwoPageAction() {
	}
	
	private WOComponent parent;
	private Session session;
	private String actionName = "Show page";
	private EOEnterpriseObject object;
	
	public String getActionName() {
		return actionName;
	}

	public EOEnterpriseObject getObject() {
		return object;
	}

	public WOComponent performAction() {
		String theUrl = URLBuilder.getShowPageURL((String) object.valueForKey("name"), parent.context());
		WORedirect theRedirect = new WORedirect(parent.context());
		theRedirect.setUrl(theUrl);
		return theRedirect;
	}

	public void setActionName(String value) {
		actionName = value;
	}

	public void setObject(EOEnterpriseObject value) {
		object = value;
	}

	public Session getSession() {
		return session;
	}
	
	public WOComponent getParent() {
		return parent;
	}

	public void setComponent(WOComponent value) {
		parent = value;
	}

	public void setSession(Session aSession) {
		session = aSession;
	}
	
}
