package mildo.wiwo.components;

import java.util.LinkedList;
import java.util.List;

import mildo.wiwo.compare.GoogleCompare;
import mildo.wiwo.compare.GoogleDifference;
import mildo.wiwo.data.WiwoPage;
import mildo.wiwo.persistence.PersistHelper;

import and.wo.eof.SortOrderingKeyHelper;

import com.webobjects.appserver.*;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;

// Generated by the WOLips Templateengine Plug-in at Apr 20, 2009 10:19:16 PM
public class CompareWiwoPageComp 
	extends mildo.wiwo.components.BaseComp 
{
    
	public CompareWiwoPageComp(WOContext context) {
        super(context);
    }
	
	private WiwoPage page2Compare;
	
	public void setPage2Compare(WiwoPage aValue) {
		page2Compare = aValue;
	}
	
	public WiwoPage getPage2Compare() {
		return page2Compare;
	}
	
	// --------------
	
	public NSArray fetchPages2Compare() {
		if (getPage2Compare() != null) {
			NSArray ret = null;
			ret = WiwoPage.fetchWiwoPages(session().defaultEditingContext(), PersistHelper.makeEqQualifier("name", page2Compare.name()), 
					SortOrderingKeyHelper.sortOrderingsFor("versionTag"));
			return ret;
		} else {
			return new NSArray();
		}
	}
	
	// -------------
	
	private WiwoPage currentItem;
	
	public void setCurrentItem(WiwoPage aValue) {
		currentItem = aValue;
	}
	
	public WiwoPage getCurrentItem() {
		return currentItem;
	}
	
	// -----------------
	
	public String getItemText() {
		return currentItem.name() + " " + currentItem.versionTag() + " " + currentItem.versionDate();
	}
	
	// -----------------
	
	private WiwoPage firstSelectedItem;
	
	public void setFirstSelectedItem(WiwoPage aValue) {
		firstSelectedItem = aValue;
	}
	
	public WiwoPage getFirstSelectedItem() {
		return firstSelectedItem;
	}
	
	// -------------------
	
	private WiwoPage secondSelectedItem;
	
	public void setSecondSelectedItem(WiwoPage aValue) {
		secondSelectedItem = aValue;
	}
	
	public WiwoPage getSecondSelectedItem() {
		return secondSelectedItem;
	}
	
	// -------------------
	
	public WOComponent comparePages() {
		System.out.println(firstSelectedItem.versionTag());
		System.out.println(secondSelectedItem.versionTag());
		GoogleCompare theComparer = new GoogleCompare();
		if (theComparer.canComparePages(firstSelectedItem, secondSelectedItem)) {
			theComparer.comparePageVersions(firstSelectedItem, secondSelectedItem);
			differences = theComparer.listOfDifference();
		}
		return null;
	}
	
	// ----------------
	
	private List differences;
	
	public void setDifferences(List aValue) {
		differences = aValue;
	}
	
	public List getDifferences() {
		return differences;
	}
	
	// -----------------
	
	private GoogleDifference difference;
	
	public void setDifference(GoogleDifference aValue) {
		difference = aValue;
	}
	
	public GoogleDifference getDifference() {
		return difference;
	}
	
	// -----------------
	
	public WOComponent chooseVersions() {
		setDifferences(null);
		return null;
	}
	
	// ------------
	
	public boolean showChooseVersions() {
		return getDifferences() == null;
	}
	
	public String getDifferenceText() {
		String ret = "";
		if (difference.wasAdded()) {
			ret += "ADDED :";
		}
		if (difference.wasDeleted()) {
			ret += "DELETED :";
		}
		if (difference.noDifference()) {
			ret += "SAME :";
		}
		return ret + difference.difference();
	}
	
}