package mildo.wiwo.user;

import mildo.wiwo.data.WiwoUser;

/**
 * Each Session in an application has to implement this interface in order to use user-log-in-features.
 * 
 */
public interface SessionWithUser {


	// ----

	/**
 	 * Gets actualSessionUser
	 * @return GenericUser - actualSessionUser
	 */
	public WiwoUser getActualSessionUser();
	
	/**
	 * Sets new value aValue to actualSessionUser
	 * @param aValue 
	 */
	public void setActualSessionUser(WiwoUser aValue);

	// ----

	/**
 	 * Gets actualSessionUserLoggedIn
	 * @return boolean - actualSessionUserLoggedIn - true if the user is logged in, can be implemented by actualSessionUser != null
	 */
	public boolean isActualSessionUserLoggedIn();

}