DROP TABLE wiwo_keyword CASCADE;

DROP TABLE wiwo_keyword_2_object CASCADE;

DROP TABLE wiwo_name_space CASCADE;

DROP TABLE wiwo_name_space_2_wiwo_user CASCADE;

DROP TABLE wiwo_page CASCADE;

DROP TABLE wiwo_user CASCADE;

CREATE SEQUENCE wiwo_name_space_seq_id;
CREATE TABLE wiwo_name_space (CODE varchar NOT NULL, DESCRIPTION varchar NOT NULL, ID int4 NOT NULL);

CREATE SEQUENCE wiwo_name_space_2_wiwo_user_seq_id;
CREATE TABLE wiwo_name_space_2_wiwo_user (wiwo_name_space_id int4 NOT NULL, wiwo_user_id int4 NOT NULL);

CREATE SEQUENCE wiwo_keyword_seq_id;
CREATE TABLE wiwo_keyword (DESCRIPTION varchar NOT NULL, ID int4 NOT NULL, KEY varchar NOT NULL, NAMESPACE_ID int4 NOT NULL);

CREATE SEQUENCE wiwo_page_seq_id;
CREATE TABLE wiwo_page (ID int4 NOT NULL, NAME varchar(50) NOT NULL, PREVIOUS_VERSION_ID int4, USER_ID int4 NOT NULL, VERSION_DATE date NOT NULL, VERSION_TAG int4 NOT NULL, WIKI_MARKUP varchar NOT NULL);

CREATE SEQUENCE wiwo_user_seq_id;
CREATE TABLE wiwo_user (ID int4 NOT NULL, LAST_LOGIN date, LOGIN varchar NOT NULL, PASSWORD varchar NOT NULL, USER_ROLE varchar NOT NULL);

CREATE TABLE wiwo_keyword_2_object (GENERIC_KEYWORD_ID int4 NOT NULL, OBJECT_ID int4 NOT NULL);

ALTER TABLE wiwo_keyword ADD PRIMARY KEY (ID);

ALTER TABLE wiwo_keyword_2_object ADD PRIMARY KEY (GENERIC_KEYWORD_ID, OBJECT_ID);

ALTER TABLE wiwo_name_space ADD PRIMARY KEY (ID);

ALTER TABLE wiwo_name_space_2_wiwo_user ADD PRIMARY KEY (wiwo_name_space_id, wiwo_user_id);

ALTER TABLE wiwo_page ADD PRIMARY KEY (ID);

ALTER TABLE wiwo_user ADD PRIMARY KEY (ID);

ALTER TABLE wiwo_name_space_2_wiwo_user ADD CONSTRAINT wiwo_name_space_2_wiwo_user_wiwoUser_FK FOREIGN KEY (wiwo_user_id) REFERENCES wiwo_user (ID) INITIALLY DEFERRED;

ALTER TABLE wiwo_name_space_2_wiwo_user ADD CONSTRAINT wiwo_name_space_2_wiwo_user_wiwoNameSpace_FK FOREIGN KEY (wiwo_name_space_id) REFERENCES wiwo_name_space (ID) INITIALLY DEFERRED;

ALTER TABLE wiwo_page ADD CONSTRAINT wiwo_page_user_FK FOREIGN KEY (USER_ID) REFERENCES wiwo_user (ID) INITIALLY DEFERRED;

ALTER TABLE wiwo_page ADD CONSTRAINT wiwo_page_previousVersion_FK FOREIGN KEY (PREVIOUS_VERSION_ID) REFERENCES wiwo_page (ID) INITIALLY DEFERRED;

ALTER TABLE wiwo_keyword ADD CONSTRAINT wiwo_keyword_namespace_FK FOREIGN KEY (NAMESPACE_ID) REFERENCES wiwo_name_space (ID) INITIALLY DEFERRED;

insert into wiwo_user values (nextval('wiwo_user_seq_id'), null, 'wiwo', 'wiwo', 'MASTER');