package wo.keyword.manager;

import java.util.Enumeration;

import wo.keyword.data.GenericKeyword;
import wo.keyword.data.GenericKeyword2Object;
import wo.keyword.data.GenericNamespace;

import and.wo.eof.EOFHelper;

import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOOrQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;

public class KeywordManager {

	public KeywordManager(EOEditingContext aCtx) {
		editingContext = aCtx;
		eofHelper = new EOFHelper(editingContext());
	}
	
	public KeywordManager(EOEditingContext aCtx, String anObjectEntityName) {
		this(aCtx);
		objectEntityName = anObjectEntityName;
		
	}
	
	// ---------------
	
	private EOFHelper eofHelper;
	
	public EOFHelper eofHelper() {
		return eofHelper;
	}
	
	// --------------
	
	private EOEditingContext editingContext;
	
	public EOEditingContext editingContext() {
		return editingContext;
	}
	
	public void setEditingContext(EOEditingContext aValue) {
		editingContext = aValue;
	}
	
	// --------------
	
	/**
	 * Object entity name. Object entity name that is linked to keywords.
	 */
	private String objectEntityName;
	
	public void setObjectEntityName(String aValue) {
		objectEntityName = aValue;
	}
	
	public String getObjectEntityName() {
		return objectEntityName;
	}
	
	// -----------------
	
	private String objectPrimaryKeyAttributeName = "id";
	
	public void setObjectPrimaryKeyAttributeName(String aValue) {
		objectPrimaryKeyAttributeName = aValue;
	}
	
	public String getObjectPrimaryKeyAttributeName() {
		return objectPrimaryKeyAttributeName;
	}
	
	// ------------------
	
	private String namespaceEntityName = "GenericNameSpace";
	
	public void setNamespaceEntityName(String aValue) {
		namespaceEntityName = aValue;
	}
	
	public String getNamespaceEntityName() {
		return namespaceEntityName;
	}
	
	// --------------
	
	private String keywordEntityName = "GenericKeyword";
	
	public void setKeywordEntityName(String aValue) {
		keywordEntityName = aValue;
	}
	
	public String getKeywordEntityName() {
		return keywordEntityName;
	}
	
	// ---------------
	
	private String keyword2ObjectEntityName = "GenericKeyword2Object";
	
	public void setKeyword2ObjectEntityName(String aValue) {
		keyword2ObjectEntityName = aValue;
	}
	
	public String getKeyword2ObjectEntityName() {
		return keyword2ObjectEntityName;
	}
	
	//----Creating stuff------
	
	/**
	 * Creates new GenericNamespace with given code. If the namespace with given code already exists returns null.
	 * @return GenericNamespace
	 */
	public GenericNamespace createNamespace(String aCode) {
		if (canCreateNamespace(aCode)) {
			GenericNamespace ret = (GenericNamespace) EOUtilities.createAndInsertInstance(editingContext(), getNamespaceEntityName());
			ret.setCode(aCode);
			return ret;
		} else {
			return null;
		}
	}
	
	/**
	 * Returns true if can create namespace.
	 * @param aCode
	 * @return
	 */
	public boolean canCreateNamespace(String aCode) {
		GenericNamespace theNamespace = fetchNamespace(EOFHelper.makeEqQualifier("code", aCode));
		if (theNamespace == null) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	 * Creates new GenericKeyword in given namespace
	 * @param aKey - key for keyword
	 * @param aNSpace - Namespace to be created in.
	 * @return GenericKeyword
	 */
	public GenericKeyword createKeyword(String aKey, GenericNamespace aNSpace) {
		GenericKeyword ret = (GenericKeyword) EOUtilities.createAndInsertInstance(editingContext(), getKeywordEntityName());
		ret.setKey(aKey);
		ret.setNamespace(aNSpace);
		return ret;
	}
	
	// ---------------
	
	/**
	 * Returns true if keyword with given key already exists in namespace.
	 */
	public boolean hasKeywordWithKey(String aKey, GenericNamespace aNamespace) {
		NSMutableArray theQs = new NSMutableArray();
		theQs.addObject(EOFHelper.makeEqQualifier("nameSpaceId", aNamespace.id()));
		theQs.addObject(EOFHelper.makeEqQualifier("key", aKey));
		GenericKeyword ret = (GenericKeyword) eofHelper().fetchObject(getKeywordEntityName(), new EOAndQualifier(theQs));
		return (ret != null);
	}
	
	/**
	 * Adds given keyword to namespace
	 */
	public void addKeyword2Namespace(GenericKeyword aKeyword, GenericNamespace aNamespace) {
		if (!hasKeywordWithKey(aKeyword.key(), aNamespace)) {
			aKeyword.setNamespace(aNamespace);
		}	
	}
	
	/**
	 * Adds given keywords to namespaces
	 * @param aKeywords - NSArray of Keyword objects
	 * @param aNamespace
	 */
	public void addKeywords2Namespace(NSArray aKeywords, GenericNamespace aNamespace) {
		Enumeration theEnum = aKeywords.objectEnumerator();
		while (theEnum.hasMoreElements()) {
			GenericKeyword theKey = (GenericKeyword) theEnum.nextElement();
			addKeyword2Namespace(theKey, aNamespace);
		}
	}
	
	// -----------------
	
	/**
	 * Gets keyword for object.
	 */
	public NSArray getObjectKeywords(EOEnterpriseObject anObject, NSArray aSortOrderings) {
		//Gets id for object
		Number theId = (Number) anObject.valueForKey(getObjectPrimaryKeyAttributeName());
		NSArray ret = new NSArray();
		//Fetches all GenericKeyword2Object objects with the id
		EOQualifier theQual = EOFHelper.makeEqQualifier("objectId", theId);
		NSArray theKeywordsIds = eofHelper().fetchObjects(getKeyword2ObjectEntityName(), theQual, null);
		//Makes NSArray of keyword ids
		theKeywordsIds = EOFHelper.makeArrayOfAttributeValuesFromObjectArray(theKeywordsIds, "genericKeywordId");
		//If there is at least one id then fetches the keywords
		if (!theKeywordsIds.isEmpty()) {
			theQual = new EOOrQualifier(theKeywordsIds);
			ret = eofHelper().fetchObjects(getKeywordEntityName(), theQual, aSortOrderings);
		}
		return ret;
	}
	
	// ---------------------
	
	public NSArray getObjects4Keyword(GenericKeyword aKeyword, NSArray aSortOrderings) {
		//Gets keyword id
		Number theId = (Number) aKeyword.valueForKey("id");
		NSArray ret = new NSArray();
		EOQualifier theQual = EOFHelper.makeEqQualifier("genericKeywordId", theId);
		NSArray theObjectsIds = eofHelper().fetchObjects(getKeyword2ObjectEntityName(), theQual, null);
		//Makes NSArray of objects ids
		theObjectsIds = EOFHelper.makeArrayOfAttributeValuesFromObjectArray(theObjectsIds, "objectId");
		//If there is at least one id then fetches the objects
		if (!theObjectsIds.isEmpty()) {
			theQual = new EOOrQualifier(theObjectsIds);
			ret = eofHelper().fetchObjects(getKeywordEntityName(), theQual, aSortOrderings);
		}
		return ret;
	}
	
	/**
	 * Gets objects for given keyword
	 * @param aKey String
	 * @param aSortOrderings
	 * @return
	 */
	public NSArray getObjects4Keyword(String aKey, NSArray aSortOrderings) {
		//Gets keyword id
		GenericKeyword theKeyword = fetchKeyword(EOFHelper.makeEqQualifier("key", aKey));
		if (theKeyword != null) {
			return getObjects4Keyword(theKeyword, aSortOrderings);
		} else {
			return new NSArray();
		}
	}
	
	// ------------------
	
	/**
	 * Returns true if given objects has given keyword
	 */
	public boolean hasKeyword(GenericKeyword aKeyword, EOEnterpriseObject anObject) {
		NSMutableArray theQs = new NSMutableArray();
		theQs.addObject(EOFHelper.makeEqQualifier("genericKeywordId", (Number)aKeyword.valueForKey("id")));
		theQs.addObject(EOFHelper.makeEqQualifier("objectId", (Number)anObject.valueForKey(getObjectPrimaryKeyAttributeName())));
		GenericKeyword2Object theG2K = fetchKeyword2Object(new EOAndQualifier(theQs));
		return (theG2K != null);
	}
	
	/**
	 * Adds given keyword 2 given object
	 * @param aKeyword GenericKeyword
	 * @param anObject 
	 */
	public void addKeyword2Object(GenericKeyword aKeyword, EOEnterpriseObject anObject) {
		if (!hasKeyword(aKeyword, anObject)) {
			GenericKeyword2Object theKey2Obj = (GenericKeyword2Object) EOUtilities.createAndInsertInstance(editingContext(), getKeyword2ObjectEntityName());
			theKey2Obj.setGenericKeywordId((Number)aKeyword.valueForKey("id"));
			theKey2Obj.setObjectId((Number)anObject.valueForKey(getObjectPrimaryKeyAttributeName()));
		}
	}
	
	/**
	 * Adds given keyword 2 given object
	 * @param aKeyword String
	 * @param anObject 
	 */
	public void addKeyword2Object(String aKey, EOEnterpriseObject anObject) {
		GenericKeyword theKeyword = fetchKeyword(EOFHelper.makeEqQualifier("key", aKey));
		if (theKeyword != null) {
			addKeyword2Object(theKeyword, anObject);
		}
	}
	
	/**
	 * Adds given keywords 2 given object
	 * @param aKeyword NSArray
	 * @param anObject 
	 */
	public void addKeywords2Object(NSArray aKeywords, EOEnterpriseObject anObject) {
		Enumeration theEnum = aKeywords.objectEnumerator();
		while (theEnum.hasMoreElements()) {
			GenericKeyword theKeyword = (GenericKeyword) theEnum.nextElement();
			addKeyword2Object(theKeyword, anObject);
		}
	}
	
	/**
	 * Adds given keywords 2 given object
	 * @param aKeyword String[]
	 * @param anObject 
	 */
	public void addKeywords2Object(String[] aKeys, EOEnterpriseObject anObject) {
		for (int i = 0; i < aKeys.length; i++) {
			addKeyword2Object(aKeys[i], anObject);
		}
	}
	
	/**
	 * Removes given keyword from given object
	 * @param aKeyword GenericKeyword
	 * @param anObject 
	 */
	public void removeKeywordFromObject(GenericKeyword aKeyword, EOEnterpriseObject anObject) {
		if (hasKeyword(aKeyword, anObject)) {
			NSMutableArray theQs = new NSMutableArray();
			theQs.addObject(EOFHelper.makeEqQualifier("genericKeywordId", (Number)aKeyword.valueForKey("id")));
			theQs.addObject(EOFHelper.makeEqQualifier("objectId", (Number)anObject.valueForKey(getObjectPrimaryKeyAttributeName())));
			GenericKeyword2Object theG2K = fetchKeyword2Object(new EOAndQualifier(theQs));
			eofHelper().editingContext().deleteObject(theG2K);
		}
	}
	
	/**
	 * Removes given keywords from given object
	 * @param aKeyword NSArray
	 * @param anObject 
	 */
	public void removeKeywordsFromObject(NSArray aKeywords, EOEnterpriseObject anObject) {
		Enumeration theEnum = aKeywords.objectEnumerator();
		while (theEnum.hasMoreElements()) {
			GenericKeyword theKeyword = (GenericKeyword) theEnum.nextElement();
			removeKeywordFromObject(theKeyword, anObject);
		}
	}
	
	// --------------- Fetching -----------------
	
	/**
	 * Fetch namespaces
	 * @return NSArray of Namespaces
	 */
	public NSArray fetchNamespaces(EOQualifier aQual, NSArray aSorts) {
		return eofHelper().fetchObjects(getNamespaceEntityName(), aQual, aSorts);
	}
	
	/**
	 * Fetch namespace
	 * @param aQual
	 * @return
	 */
	public GenericNamespace fetchNamespace(EOQualifier aQual) {
		return (GenericNamespace) eofHelper().fetchObject(getNamespaceEntityName(), aQual);
	}
	
	/**
	 * Fetch keyword
	 * @return NSArray of Keyword
	 */
	public NSArray fetchKeywords(EOQualifier aQual, NSArray aSorts) {
		return eofHelper().fetchObjects(getKeywordEntityName(), aQual, aSorts);
	}
	
	/**
	 * Fetch keyword
	 * @param aQual
	 * @return
	 */
	public GenericKeyword fetchKeyword(EOQualifier aQual) {
		return (GenericKeyword) eofHelper().fetchObject(getKeywordEntityName(), aQual);
	}
	
	/**
	 * Fetch keyword
	 * @return NSArray of Keyword
	 */
	public NSArray fetchKeyword2Objects(EOQualifier aQual, NSArray aSorts) {
		return eofHelper().fetchObjects(getKeyword2ObjectEntityName(), aQual, aSorts);
	}
	
	/**
	 * Fetch keyword
	 * @param aQual
	 * @return
	 */
	public GenericKeyword2Object fetchKeyword2Object(EOQualifier aQual) {
		return (GenericKeyword2Object) eofHelper().fetchObject(getKeyword2ObjectEntityName(), aQual);
	}
	
	public NSArray fetchKeywords4Namespace(GenericNamespace aNamespace, NSArray aSorts) {
		EOQualifier theQual = EOFHelper.makeEqQualifier("nameSpaceId", aNamespace.id());
		return eofHelper().fetchObjects(getKeywordEntityName(), theQual, aSorts);
	}
	
	public NSArray fetchKeywords4Object(EOEnterpriseObject anObject, NSArray aSorts) {
		NSArray theKeywordObjectArr = fetchKeyword2Objects(EOFHelper.makeEqQualifier("objectId", (Integer)anObject.valueForKey(getObjectPrimaryKeyAttributeName())), null);
		NSArray theKeyIds = EOFHelper.makeArrayOfAttributeValuesFromObjectArray(theKeywordObjectArr, "genericKeywordId");
		if (!theKeyIds.isEmpty()) {
			NSMutableArray theQs = new NSMutableArray();
			Enumeration theEnum = theKeyIds.objectEnumerator();
			while (theEnum.hasMoreElements()) {
				theQs.add(EOFHelper.makeEqQualifier("id", (Integer) theEnum.nextElement()));
			}
			return fetchKeywords(new EOOrQualifier(theQs), aSorts);
		}
		return new NSArray();
	}
	
}
