package mildo.wiwo.compare;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import mildo.wiwo.compare.GoogleDiff.Diff;
import mildo.wiwo.data.WiwoPage;

public class GoogleCompare 
	implements IVersionCompare
{

	public boolean canComparePages(WiwoPage firstVerPage, WiwoPage secondVerPage) {
		if (firstVerPage.versionTag().intValue() != secondVerPage.versionTag().intValue()) {
			return true;
		}
		return false;
	}

	public void comparePageVersions(WiwoPage firstVerPage,
			WiwoPage secondVerPage) {
		GoogleDiff theDiff = new GoogleDiff();
		LinkedList theDifferences = theDiff.diff_main(firstVerPage.wikiMarkup(), secondVerPage.wikiMarkup());
		Iterator theIter = theDifferences.iterator();
		listOfDifference = new LinkedList();
		while (theIter.hasNext()) {
			listOfDifference.add(new GoogleDifference((Diff) theIter.next()));
		}
	}

	private LinkedList listOfDifference;
	
	public List listOfDifference() {
		return listOfDifference;
	}

}
