package mildo.wiwo.components.descriptors;

import mildo.wiwo.Session;

import com.apple.component.Component;
import com.webobjects.appserver.WOComponent;
import com.webobjects.eocontrol.EOEnterpriseObject;

public interface IActionDescriptor {

	
	/**
	 * Sets object on which the action will be performed
	 * @param aValue
	 */
	public void setObject(EOEnterpriseObject aValue);
	
	/**
	 * Gets object
	 * @return
	 */
	public EOEnterpriseObject getObject();
	
	/**
	 * Action performed.
	 * @return
	 */
	public WOComponent performAction();
	
	/**
	 * Action name that will be displayed when and where needed
	 * @return
	 */
	public String getActionName();
	
	public void setActionName(String aValue);
	
	public Session getSession();
	
	public void setSession(Session aSession);
	
	public WOComponent getParent();
	
	public void setComponent(WOComponent aValue);
	
}
