package mildo.wiwo.persistence;

import java.util.HashMap;

import mildo.wiwo.data.WiwoNamespace;
import mildo.wiwo.data.WiwoPage;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;

import and.wo.eof.EOFHelper;
import and.wo.eof.SortOrderingKeyHelper;

public class PersistHelper 
	extends EOFHelper
{

	public PersistHelper(EOEditingContext aCtx) {
		super(aCtx);
	}
	
	public NSArray fetchPages4Name(String aName, WiwoNamespace aNSpace, NSArray aSortOrder) {
		return WiwoPage.fetchWiwoPages(editingContext, PersistHelper.makeFullLikeQualifier("name", aName), aSortOrder);
	}
	
	/**
	 * Fetch last added pages.
	 * @param aPageCount count of last added pages to fetch
	 * @return
	 */
	public NSArray fetchLastAddedPages(int aPageCount) {
		NSArray theSorts = SortOrderingKeyHelper.sortOrderingsFor("-versionDate");
		NSArray thePages = WiwoPage.fetchWiwoPages(editingContext, null, theSorts);
		HashMap theResult = new HashMap();
		NSMutableArray ret = new NSMutableArray();
		for (int i = 0; i < thePages.count(); i++) {
			WiwoPage thePage = (WiwoPage) thePages.objectAtIndex(i);
			if (!theResult.containsKey(thePage.name())) {
				theResult.put(thePage.name(), thePage);
			}
			if (theResult.values().size() == aPageCount) {
				break;
			}
		}
		ret.addAll(theResult.values());
		PersistHelper.sortMutableArrayOfObjects(ret, "-versionDate");
		return ret;
	}
	
}
