<?php

class sklad {
	public $karty = array();
	public $akcie = array(); //skladove prijemky a vydajky
	public $faktury = array();
	
	public function __construct() {
		$db = db::getInstance();
		
		$d = "SELECT id, kod, nazov, cena, jednotka FROM ".TABLE_STORE." WHERE aktivna = 1";
		$db->query($d);
		$this->karty = array();
		while ($row = $db->getRow()) {
			$this->karty[] = $row;
		}
		
		$d = "SELECT a.id, k.kod, k.nazov AS tovar, a.cena, a.kusy, DATE_FORMAT(a.datum, '%e.%c.%Y') as datum, 
			a.pozn, a.meno, a.ulica, a.mesto, a.psc, a.stat 
			FROM ".TABLE_STORE_ACT." a
			INNER JOIN ".TABLE_STORE." k ON a.id_sklad_karta = k.id";
		$db->query($d);
		$this->akcie = array();
		while ($row = $db->getRow()) {
			$this->akcie[] = $row;
		}
		
		$d = "SELECT f.id, f.cislo_faktury, DATE_FORMAT(f.datum_splatnosti, '%e.%c.%Y') as datum_splatnosti, 
			f.dosla, f.d_meno as meno, u.login AS vystavil
			FROM ".TABLE_INV." f
			LEFT JOIN ".TABLE_USERS." u ON f.vystavil = u.id_uziv";
		$db->query($d);
		$this->faktury = array();
		while ($row = $db->getRow()) {
			$d = "SELECT SUM(ABS(kusy)*cena) AS suma FROM ".TABLE_STORE_ACT." 
				WHERE id_faktury = ".$row['id']."
				GROUP BY id_faktury";
			$db->query($d, 1);
			$row1 = $db->getRow(1);
			$this->faktury[$row['id']] = $row;
			$this->faktury[$row['id']]['suma'] = $row1['suma'];
		}
	}
	
	public static function uprav_kartu($id, $kod, $nazov, $cena, $jednotka) {
		$d = "UPDATE ".TABLE_STORE." SET kod=$kod, nazov=$nazov, cena=$cena,
			jednotka=$jednotka WHERE id = $id";
		db::getInstance()->query($d);
	}
	
	public static function vloz_kartu($kod, $nazov, $cena, $jednotka) {
		$d = "INSERT INTO ".TABLE_STORE." (kod, nazov, cena, jednotka) VALUES 
			($kod, $nazov, $cena, $jednotka)";
		db::getInstance()->query($d);
	}
	
	public static function get_info($id) {
		$karta = array();
		$db = db::getInstance();
		$d = "SELECT * FROM ".TABLE_STORE." WHERE id = $id";
		$db->query($d);
		if ($db->getNumRows()) {
			$karta = $db->getRow();
		}
		return $karta;
	}

	public static function deaktivovat($id) {
		$d = "UPDATE ".TABLE_STORE." SET aktivna = 0 WHERE id = $id LIMIT 1";
		db::getInstance()->query($d);
	}
	
	public static function uprav_pv($id, $id_sklad_karta, $prijemka, $datum, $kusy, $pozn, $meno, $ulica, $mesto, $psc, $stat, $faktura = 'NULL') {
		if (!$prijemka) $kusy = -$kusy;
		$d = "SELECT cena FROM ".TABLE_STORE." WHERE id = $id_sklad_karta";
		db::getInstance()->query($d);
		if (db::getInstance()->getNumRows()) {
			$cena = db::getInstance()->getRow();
			$d = "UPDATE ".TABLE_STORE_ACT." SET id_sklad_karta=$id_sklad_karta, cena={$cena['cena']}, 
				datum=$datum, kusy=$kusy, pozn=$pozn, meno=$meno, ulica=$ulica, 
				mesto=$mesto, psc=$psc, stat=$stat, id_faktury=$faktura 
			 	WHERE id = $id";
			db::getInstance()->query($d);
		}
	}
	
	//vlozi prijemku/vydajku
	public static function vloz_pv($id_sklad_karta, $prijemka, $datum, $cena, $kusy, $pozn, $meno, $ulica, $mesto, $psc, $stat, $faktura = 'NULL') {
		if (!$prijemka) $kusy = -$kusy;
		//$d = "SELECT cena FROM ".TABLE_STORE." WHERE id = $id_sklad_karta";
		//db::getInstance()->query($d);
		//if (db::getInstance()->getNumRows()) {
			//$cena = db::getInstance()->getRow();
			$d = "INSERT INTO ".TABLE_STORE_ACT." (id_sklad_karta, cena, datum, kusy, pozn, meno, ulica, 
				mesto, psc, stat, id_faktury) 
				VALUES ($id_sklad_karta, $cena, $datum, $kusy, $pozn, $meno, $ulica, $mesto, 
				$psc, $stat, $faktura)";
			db::getInstance()->query($d);
		//}
	}
	
	//vrati info o prijemke/vydajke
	public static function get_info_pv($id) {
		$pv = array();
		$db = db::getInstance();
		$d = "SELECT id, id_sklad_karta, cena, DATE_FORMAT(datum, '%e.%c.%Y') as datum, kusy, pozn,
			meno, ulica, mesto, psc, stat FROM ".TABLE_STORE_ACT." WHERE id = $id";
		$db->query($d);
		if ($db->getNumRows()) {
			$pv = $db->getRow();
		}
		return $pv;
	}
	
	//zmazat prijemku/vydajku
	public static function zmazat_pv($id) {
		$d = "DELETE FROM ".TABLE_STORE_ACT." WHERE id = $id LIMIT 1";
		db::getInstance()->query($d);
	}
	
	//zmaze prijemky a vydajky k danej fakture
	public static function zmazat_vydajky_k_fakture($id_f) {
		$d = "DELETE FROM ".TABLE_STORE_ACT." WHERE id_faktury = $id_f";
		db::getInstance()->query($d);
	}
	
	public static function uprav_fakturu($id, $dosla, $cislo_faktury, $cislo_uctu, $ks, $datum_dodania, $datum_vystavenia, $datum_splatnosti, $forma_uhrady, $d_id_kontakt, $d_meno, $d_ulica, $d_mesto, $d_psc, $d_stat, $tovary, $banka, $b_ulica, $b_mesto, $b_krajina, $iban, $swift, $vystavil, $pozn) {
		$d = "UPDATE ".TABLE_INV." SET cislo_faktury=$cislo_faktury, v_symbol=$cislo_faktury, 
			k_symbol = $ks, datum_dodania=$datum_dodania, datum_vystavenia=$datum_vystavenia, 
			datum_splatnosti=ADDDATE($datum_vystavenia, INTERVAL $datum_splatnosti DAY),
			forma_uhrady=$forma_uhrady, dosla=$dosla, d_id_kontakt=$d_id_kontakt, d_meno=$d_meno, 
			d_ulica=$d_ulica, d_mesto=$d_mesto, d_psc=$d_psc, d_stat=$d_stat, c_uctu = $cislo_uctu, 
			banka=$banka, b_ulica=$b_ulica, b_mesto=$b_mesto, b_krajina=$b_krajina, iban=$iban, 
			swift=$swift, vystavil=$vystavil, pozn=$pozn
			WHERE id = $id";
		db::getInstance()->query($d);
		self::zmazat_vydajky_k_fakture($id);
		if (is_array($tovary)) {
			foreach ($tovary as $id_karty => $tovar_info) {
				self::vloz_pv($id_karty, $dosla, $datum_vystavenia, $tovar_info['jcena'], $tovar_info['kusy'], 'NULL', $d_meno, $d_ulica, $d_mesto, $d_psc, $d_stat, $id);
			}
		}
	}
	
	public static function vloz_fakturu($dosla, $cislo_faktury, $cislo_uctu, $ks, $datum_dodania, $datum_vystavenia, $datum_splatnosti, $forma_uhrady, $d_id_kontakt, $d_meno, $d_ulica, $d_mesto, $d_psc, $d_stat, $tovary, $banka, $b_ulica, $b_mesto, $b_krajina, $iban, $swift, $vystavil, $pozn) {
		$d = "INSERT INTO ".TABLE_INV." (cislo_faktury, v_symbol, k_symbol, datum_dodania,
			datum_vystavenia, datum_splatnosti, forma_uhrady, dosla, d_id_kontakt, d_meno,
			d_ulica, d_mesto, d_psc, d_stat, c_uctu, banka, b_ulica, b_mesto, b_krajina, iban, swift,
			vystavil, pozn) 
			VALUES ($cislo_faktury, $cislo_faktury, $ks, $datum_dodania, $datum_vystavenia, 
			ADDDATE($datum_vystavenia, INTERVAL $datum_splatnosti DAY), $forma_uhrady, $dosla,
			$d_id_kontakt, $d_meno, $d_ulica, $d_mesto, $d_psc, $d_stat, $cislo_uctu, $banka,
			$b_ulica, $b_mesto, $b_krajina, $iban, $swift, $vystavil, $pozn)";
		db::getInstance()->query($d);
		$id_faktury = db::getInstance()->getInsertId();
		if (is_array($tovary)) {
			foreach ($tovary as $id_karty => $tovar_info) {
				self::vloz_pv($id_karty, $dosla, $datum_vystavenia, $tovar_info['jcena'], $tovar_info['kusy'], 'NULL', $d_meno, $d_ulica, $d_mesto, $d_psc, $d_stat, $id_faktury);
			}
		}
	}
	
	//vrati info o fakture
	public static function get_info_faktura($id) {
		$fa = array();
		$db = db::getInstance();
		$d = "SELECT id, cislo_faktury, k_symbol as ks, DATE_FORMAT(datum_dodania, '%e.%c.%Y') as datum_dodania,
			DATE_FORMAT(datum_vystavenia, '%e.%c.%Y') as datum_vystavenia, 
			TO_DAYS(datum_splatnosti)-TO_DAYS(datum_vystavenia) as datum_splatnosti,
			forma_uhrady, dosla, d_id_kontakt,
			d_meno, d_ulica, d_mesto, d_psc, d_stat, c_uctu AS cislo_uctu, banka, b_ulica, b_mesto,
			b_krajina, iban, swift, pozn, vystavil
			FROM ".TABLE_INV." WHERE id = $id";
		$db->query($d);
		if ($db->getNumRows()) {
			$fa = $db->getRow();
			if ($fa['dosla']) {
				$fa['d_cislo_uctu'] = $fa['cislo_uctu'];
				unset($fa['cislo_uctu']);
				$fa['d_banka'] = $fa['banka'];
				unset($fa['banka']);
				$fa['d_b_ulica'] = $fa['b_ulica'];
				unset($fa['b_ulica']);
				$fa['d_b_mesto'] = $fa['b_mesto'];
				unset($fa['b_mesto']);
				$fa['d_b_krajina'] = $fa['b_krajina'];
				unset($fa['b_krajina']);
				$fa['d_iban'] = $fa['iban'];
				unset($fa['iban']);
				$fa['d_swift'] = $fa['swift'];
				unset($fa['swift']);
			}
		}
		$d = "SELECT id_sklad_karta, kusy, cena FROM ".TABLE_STORE_ACT." WHERE id_faktury = $id";
		$db->query($d);
		$i = 0;
		while ($row = $db->getRow()) {
			$i++;
			$fa['id_sklad_karta'.$i] = $row['id_sklad_karta'];
			$fa['kusy'.$i] = $row['kusy'];
			$fa['jcena'.$i] = $row['cena'];
		}
		return $fa;
	}
	
	//zmazat fakturu
	public static function zmazat_fakturu($id) {
		$d = "DELETE FROM ".TABLE_INV." WHERE id = $id LIMIT 1";
		db::getInstance()->query($d);
		self::zmazat_vydajky_k_fakture($id);
	}
	
	public static function prehlad($datum) {
		$db = db::getInstance();
		$prehlad = array();
		$d = "SELECT id, kod, nazov, cena, jednotka FROM ".TABLE_STORE." WHERE aktivna = 1";
		$db->query($d);
		while ($row = $db->getRow()) {
			$d = "SELECT SUM(kusy) as pocet FROM ".TABLE_STORE_ACT."
				WHERE datum <= $datum
				GROUP BY id_sklad_karta HAVING id_sklad_karta = {$row['id']}";
			$db->query($d, 1);
			if ($pocet = $db->getRow(1)) {
				$row['pocet'] = $pocet['pocet'];
			} else {
				$row['pocet'] = 0;
			}
			$prehlad[$row['id']] = $row;
		}
		$db->unsetResult(1);
		return $prehlad;
	}
	
	public static function info_karty() {
		$karty = array();
		$db = db::getInstance();
		$d = "SELECT id, kod, nazov, cena, jednotka FROM ".TABLE_STORE." WHERE aktivna = 1";
		$db->query($d);
		while ($row = $db->getRow()) {
			$karty[$row['id']] = $row;
		}
		return $karty;
	}
}

?>