<?php

class eshop {
	private $request;
	private $uzivatel;
	private $spracuj;
	private static $instance;
	protected $uzivatelia = array();
	
	public static function nl2br2($string) { 
		$string = str_replace(array("\r\n", "\r", "\n"), "<br />", $string); 
		return $string; 
	}
	
	private function __construct() {
		$db = db::getInstance();
		
		$this->uzivatelia = array();
		$d = "SELECT id_uziv, login FROM ".TABLE_USERS." ORDER BY login";
		$db->query($d);
		if ($db->getNumRows()) {
			while ($row = $db->getRow()) {
				$this->uzivatelia[$row['id_uziv']] = $row['login'];
			}
		}
	}
	
	private function osetri_vstup($vstup = '') {
		if (ini_get('magic_quotes_gpc')) {
    		$vstup = stripslashes($vstup);
  		}
  		return mysql_real_escape_string(strip_tags(trim($vstup)), db::getInstance()->getConn());
	}
	
	public static function getInstance() {
    	if (is_null(self::$instance)) { 
	    	self::$instance = new eshop();
		}
		return self::$instance;
	}
	
	public function run() {
		$this->request = request::getInstance();

		if ($this->request->getParameter('mode') == 'zmaz') {
			$_SESSION = array();
		}
		
		if (isset($_SESSION['uzivatel'])) {
			$this->uzivatel = unserialize($_SESSION['uzivatel']);
		} else {
			$this->uzivatel = new uzivatel();
		}
		
		if (!isset($_SESSION['zoradit'])) { $_SESSION['zoradit'] = 'id'; }
		if (!isset($_SESSION['sposob'])) { $_SESSION['sposob'] = 'asc'; }
		
		if (($this->request->getParameter('zoradit') != '') && ($this->request->getParameter('sposob') != '')) {
			$_SESSION['zoradit'] = $this->osetri_vstup($this->request->getParameter('zoradit'));
			$_SESSION['sposob'] = $this->osetri_vstup($this->request->getParameter('sposob'));
			header("Location: http://".$_SESSION['lasturl']);
		}
		
		$this->spracuj = new form_spracuj($this->request, $this->uzivatel, $this);
		if ($this->request->getParameter('spracuj') != '') {
			$this->spracuj->spracuj();
		}
		$_SESSION['lasturl'] = $_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];

		$metoda = $this->request->getParameter('akcia');
		if (method_exists($this, $metoda)) {
			 $this->$metoda();
		} else {
			//$this->spracuj->chyba .= '<span class="chyba">Nedefinovaná funkcia</span><br/>';
			$this->index();
		}

		$_SESSION['uzivatel'] = serialize($this->uzivatel);
	}
	
	private function zmena_udajov() {
		if (is_numeric($this->request->getParameter('id_uziv')) && $this->uzivatel->prava['uziv-pisat'] && $this->uzivatel->je_spravne_prihlaseny()) {
			$user = new uzivatel();
			$user->nahraj_udaje($this->request->getParameter('id_uziv'));
			$this->request->merge($user->vlastnosti);
		} else {
			$this->request->merge($this->uzivatel->vlastnosti);	
		}
		//include(dirname(__FILE__).'/../registracia.php');
		$this->registracia();
	}
	
	private function registracia() {
		if (isset($this->uzivatel->prava['registracia'])) {
			include(dirname(__FILE__).'/../registracia.php');
		} else {
			$this->spracuj->chyba .= '<span class="chyba">Nemáte oprávnenie na registráciu nového užívateľa</span><br/>';
			$this->index();
		}
	}
	
	private function zoznam_skupin() {
		if (isset($this->uzivatel->prava['skupiny-citat'])) {
			$admin_doplnky = new admin_doplnky();
			if (isset($this->uzivatel->prava['skupiny-pisat'])) {
				include(dirname(__FILE__).'/../admin_zoznam_skupin.php');
			} else {
				include(dirname(__FILE__).'/../zoznam_skupin.php');
			}
		} else {
			$this->spracuj->chyba .= '<span class="chyba">Nemáte oprávnenie prezerať skupiny užívateľov</span><br/>';
			$this->index();
		}
	}
	
	private function zoznam_uziv() {
		if (isset($this->uzivatel->prava['uziv-citat'])) {
			$admin_doplnky = new admin_doplnky();
			if (isset($this->uzivatel->prava['uziv-pisat'])) {
				include(dirname(__FILE__).'/../admin_zoznam_uziv.php');
			} else {
				include(dirname(__FILE__).'/../zoznam_uziv.php');
			}
		} else {
			$this->spracuj->chyba .= '<span class="chyba">Nemáte oprávnenie prezerať zoznam užívateľov</span><br/>';
			$this->index();
		}
	}
	
	public function index() {
		include(dirname(__FILE__).'/../index.php');
	}
	
	private function zabudnute_heslo() {
		include(dirname(__FILE__).'/../zabudnute_heslo.php');
	}

	private function adresar_kontaktov() {
		if (isset($this->uzivatel->prava['adresar-citat'])) {
			$adresar = new adresar_kontaktov();
			include(dirname(__FILE__).'/../posta/adresar_kontaktov.php');
		} else {
			$this->spracuj->chyba .= '<span class="chyba">Nemáte oprávnenie prezerať adresár kontaktov</span><br/>';
			$this->index();
		}
	}
	
	private function pridat_kontakt() {
		if (isset($this->uzivatel->prava['adresar-pisat'])) {
			if (is_numeric($_GET['id'])) {
				$vybrany_kontakt = kontakt::get_info($_GET['id']);
				$this->request->merge($vybrany_kontakt);	
			}
			include(dirname(__FILE__).'/../posta/pridat_kontakt.php');
		} else {
			$this->spracuj->chyba .= '<span class="chyba">Nemáte oprávnenie na pridávanie kontaktov</span><br/>';
			$this->index();
		}
	}
	
	private function posta() {
		if (isset($this->uzivatel->prava['posta-citat'])) {
			$posta = new evid_posty();
			include(dirname(__FILE__).'/../posta/posta.php');
		} else {
			$this->spracuj->chyba .= '<span class="chyba">Nemáte oprávnenie prezerať evidenciu pošty</span><br/>';
			$this->index();
		}
	}
	
	private function pridat_postu() {
		if (isset($this->uzivatel->prava['posta-pisat'])) {
			if (is_numeric($_GET['id'])) {
				$posta = evid_posty::get_info($_GET['id']);
				$this->request->merge($posta);	
			}
			include(dirname(__FILE__).'/../posta/pridat_postu.php');
		} else {
			$this->spracuj->chyba .= '<span class="chyba">Nemáte oprávnenie na pridávanie pošty</span><br/>';
			$this->index();
		}
	}
	
	//pre ajax
	private function kontakt_detaily() {
		if (is_numeric($_GET['id'])) {
			$kontakt = kontakt::get_info($_GET['id']);
			$ucty = kontakt::get_info_acc($_GET['id']);
			if ($_GET['typ'] == 'f') { //vratit fakturacne udaje
				if (($kontakt['fa_meno'] != '') || ($kontakt['fa_ulica'] != '') || ($kontakt['fa_mesto'] != '') || ($kontakt['fa_psc'] != '') || ($kontakt['fa_stat'] != '')) {
					echo $kontakt['fa_meno'].';'.$kontakt['fa_ulica'].';'.$kontakt['fa_mesto'].';'.$kontakt['fa_psc'].';'.$kontakt['fa_stat'];
				} else {
					echo $kontakt['da_meno'].';'.$kontakt['da_ulica'].';'.$kontakt['da_mesto'].';'.$kontakt['da_psc'].';'.$kontakt['da_stat'];
				}
			} else {
				echo $kontakt['da_meno'].';'.$kontakt['da_ulica'].';'.$kontakt['da_mesto'].';'.$kontakt['da_psc'].';'.$kontakt['da_stat'];
			}
			if (count($ucty)) echo ';';
			foreach ($ucty as $id => $c_uctu) {
				echo $id.'.'.$c_uctu.',';
			}
		}
	}
	
	//pre ajax
	private function vrat_cenu() {
		if (is_numeric($_GET['id_sklad_karty'])) {
			$sklad = sklad::get_info($_GET['id_sklad_karty']);
			echo $sklad['cena'];
		}
	}
	
	//ajax
	private function ucet_detaily() {
		if (is_numeric($_GET['id'])) {
			$ucet = bankove_ucty::get_info($_GET['id']);
			echo $ucet['cislo_uctu'].';'.$ucet['banka'].';'.$ucet['ulica'].';'.$ucet['mesto'].';'.$ucet['krajina'].';'.$ucet['iban'].';'.$ucet['swift'];
		}
	}
	
	private function sklad() {
		if (isset($this->uzivatel->prava['sklad-citat'])) {
			$sklad = new sklad();
			include(dirname(__FILE__).'/../posta/sklad.php');
		} else {
			$this->spracuj->chyba .= '<span class="chyba">Nemáte oprávnenie prezerať skladové karty</span><br/>';
			$this->index();
		}
	}
	
	private function pridat_kartu() {
		if (isset($this->uzivatel->prava['sklad-pisat'])) {
			if (is_numeric($_GET['id'])) {
				$karta = sklad::get_info($_GET['id']);
				$this->request->merge($karta);	
			}
			include(dirname(__FILE__).'/../posta/pridat_kartu.php');
		} else {
			$this->spracuj->chyba .= '<span class="chyba">Nemáte oprávnenie na pridanie skladovej karty</span><br/>';
			$this->index();
		}
	}
	
	private function prijem_vydaj() {
		if (isset($this->uzivatel->prava['pv-citat'])) {
			$sklad = new sklad(); 
			include(dirname(__FILE__).'/../posta/prijem_vydaj.php');
		} else {
			$this->spracuj->chyba .= '<span class="chyba">Nemáte oprávnenie prezerať sklad</span><br/>';
			$this->index();
		}
	}
	
	private function pridat_prijem_vydaj() {
		if (isset($this->uzivatel->prava['pv-pisat'])) {
			if (is_numeric($_GET['id'])) {
				$pv = sklad::get_info_pv($_GET['id']);
				if ($pv['kusy'] > 0) $pv['prijemka'] = 1; else $pv['prijemka'] = 0;
				$pv['kusy'] = abs($pv['kusy']);
				$this->request->merge($pv);	
			}
			$sklad = new sklad();
			include(dirname(__FILE__).'/../posta/pridat_prijem_vydaj.php');
		} else {
			$this->spracuj->chyba .= '<span class="chyba">Nemáte oprávnenie na pridanie príjemky/výdajky</span><br/>';
			$this->index();
		}
	}
	
	private function faktury() {
		if (isset($this->uzivatel->prava['pv-citat'])) {
			$sklad = new sklad(); 
			include(dirname(__FILE__).'/../posta/faktury.php');
		} else {
			$this->spracuj->chyba .= '<span class="chyba">Nemáte oprávnenie prezerať sklad</span><br/>';
			$this->index();
		}
	}
	
	private function pridat_fakturu() {
		if (isset($this->uzivatel->prava['pv-pisat'])) {
			if (is_numeric($_GET['id'])) {
				$faktura = sklad::get_info_faktura($_GET['id']);
				$this->request->merge($faktura);	
			}
			$sklad = new sklad();
			include(dirname(__FILE__).'/../posta/pridat_fakturu.php');
		} else {
			$this->spracuj->chyba .= '<span class="chyba">Nemáte oprávnenie na pridanie faktúry</span><br/>';
			$this->index();
		}
	}
	
	private function prehlad_skladu() {
		if (isset($this->uzivatel->prava['prehlad-skladu'])) {
			$prehlad = array();
			$datum = "'".date("Y-m-d")."'";
			$datum_z = date("j.n.Y");
			if (strlen(trim($this->request->getParameter('datum'))) > 0) {
				if (strlen(trim($this->request->getParameter('datum'))) <= 10) {
					$datum_z = $this->request->getParameter('datum');
					$datum = explode('.',$this->request->getParameter('datum'));
					if (is_numeric($datum[0]) && is_numeric($datum[1]) && is_numeric($datum[2])
						&& ($datum[0] < 32) && ($datum[1] < 13) && ($datum[2] < 2100)) {
						$den = ($datum[0] < 10) ? '0'.$datum[0] : $datum[0];
						$mesiac = ($datum[1] < 10) ? '0'.$datum[1] : $datum[1];
						$datum = "'".$datum[2].'-'.$mesiac.'-'.$den."'";
					} else {
						$this->chyba .= '<span class="chyba">Dátum je v nesprávnom formáte!</span><br/>';
					}
				} else {
					$this->chyba .= '<span class="chyba">Dátum je príliš dlhý</span><br/>';
				}
			}
			$this->request->setParameter('datum', $datum_z);
			$prehlad = sklad::prehlad($datum);
			include(dirname(__FILE__).'/../posta/prehlad_skladu.php');
		} else {
			$this->spracuj->chyba .= '<span class="chyba">Nemáte oprávnenie prezerať sklad</span><br/>';
			$this->index();
		}
	}
	
	private function bankove_ucty() {
		if (isset($this->uzivatel->prava['ucty-pisat'])) {
			$ucty = new bankove_ucty(); 
			include(dirname(__FILE__).'/../posta/ucty.php');
		} else {
			$this->spracuj->chyba .= '<span class="chyba">Nemáte oprávnenie prezerať bankové účty</span><br/>';
			$this->index();
		}
	}
	
	private function pridat_ucet() {
		if (isset($this->uzivatel->prava['ucty-pisat'])) {
			if (is_numeric($_GET['id'])) {
				$ucet = bankove_ucty::get_info($_GET['id']);
				$this->request->merge($ucet);	
			}
			$zoznam_kontaktov = kontakt::zoznam_kontaktov();
			include(dirname(__FILE__).'/../posta/pridat_ucet.php');
		} else {
			$this->spracuj->chyba .= '<span class="chyba">Nemáte oprávnenie na pridanie účtu</span><br/>';
			$this->index();
		}
	}
	
	private function zobrazit_fakturu() {
		if (isset($this->uzivatel->prava['pv-citat'])) {
			if (is_numeric($this->request->getParameter('id'))) {
				$karty = sklad::info_karty();
				$faktura = sklad::get_info_faktura($this->request->getParameter('id'));
				include(dirname(__FILE__).'/../posta/faktura.php');
			} else {
				$this->spracuj->chyba .= '<span class="chyba">Nie je vybraná faktúra</span><br/>';
				$this->index();
			}
		} else {
			$this->spracuj->chyba .= '<span class="chyba">Nemáte oprávnenie na prezeranie faktúry</span><br/>';
			$this->index();
		}
	}
}

?>