<?php

class form_spracuj {
	public $chyba = '';
	private $request;
	private $db;
	private $uzivatel;
	private $eshop;
	
	public function __construct(request $request, uzivatel $uzivatel, eshop $eshop) {
		$this->chyba = '';
		$this->request = $request;
		$this->db = db::getInstance();
		$this->uzivatel = $uzivatel;
		$this->eshop = $eshop;
	}
		
	public function spracuj() {
		$metoda = $this->request->getParameter('spracuj');
		if (method_exists($this, $metoda)) {
			 $this->$metoda();
		} else {
			$this->chyba .= '<span class="chyba">Nedefinovaná funkcia</span><br/>';
			$this->request->setParameter('akcia', '');
		}
	}
	
	//osetrenie vstupu z formularov, ktory ide do databazy
	private function osetri_vstup($vstup = '') {
		if (ini_get('magic_quotes_gpc')) {
    		$vstup = stripslashes($vstup);
  		}
  		return mysql_real_escape_string(strip_tags(trim($vstup)), db::getInstance()->getConn());
	}
	
	private function prihlas() {
		if (strlen(trim($this->request->getParameter('login'))) > 0) {
			if (strlen(trim($this->request->getParameter('login'))) <= 20) {
				$login = "'".$this->osetri_vstup($this->request->getParameter('login'))."'";
			} else {
				$login = FALSE;
				$this->chyba .= '<span class="chyba">Príliš dlhý login!</span><br/>';
			}
		} else {
			$login = FALSE;
			$this->chyba .= '<span class="chyba">Nezadali ste login!</span><br/>';
		}
		if (strlen(trim($this->request->getParameter('heslo'))) > 0) {
			if (strlen(trim($this->request->getParameter('heslo'))) <= 50) {
				$heslo = $this->osetri_vstup($this->request->getParameter('heslo'));
			} else {
				$heslo = FALSE;
				$this->chyba .= '<span class="chyba">Príliš dlhé heslo!</span><br/>';
			}
		} else {
			$heslo = FALSE;
			$this->chyba .= '<span class="chyba">Nezadali ste heslo!</span><br/>';
		}
		if ($login && $heslo) {
			$d = "SELECT id_uziv FROM ".TABLE_USERS." WHERE login = $login
				AND heslo = SHA1(CONCAT('$heslo', salt))";
			$this->db->query($d);
			if ($this->db->getNumRows()) {
				$u = $this->db->getRow();
				$this->uzivatel->prihlas($u['id_uziv']);
				$this->request->unsetParameter('login');
			} else {
				$this->chyba .= '<span class="chyba">Meno a heslo nesúhlasia!</span><br/>';
			}
		}
	}
	
	private function odhlas() {
		$this->uzivatel->odhlas();
		header("Location: http://".$_SESSION['lasturl']);
	}
	
	private function zmazat_uziv() {
		if (isset($this->uzivatel->prava['uziv-pisat']) && $this->uzivatel->je_spravne_prihlaseny()) {
			$id_uziv = $this->request->getParameter('id_uziv');
			$d = "SELECT id_uziv FROM ".TABLE_USERS." WHERE id_uziv = $id_uziv";
			db::getInstance()->query($d);
			if (db::getInstance()->getNumRows()) {
				uzivatel::zmaz_uziv($id_uziv);
				//zmazat aj objednavky?
				$this->chyba = '<span class="uspesne">Užívateľ bol úspešne vymazaný.</span><br/>';
			} else {
				$this->chyba = '<span class="chyba">Užívateľ neexistuje.</span><br/>';
			}
			$this->request->setParameter('akcia', 'zoznam_uziv');
		} else {
			$this->chyba .= '<span class="chyba">Nemáte oprávnenie upravovať užívateľov.</span><br/>';
		}
	}
	
	private function zmazat_skup() {
		if (isset($this->uzivatel->prava['skupiny-pisat']) && $this->uzivatel->je_spravne_prihlaseny()) {
			$id_skupiny = $this->request->getParameter('id_skup');
			if (($id_skupiny != NEREG_USER) && ($id_skupiny != REG_USER) && ($id_skupiny != ADMIN)) {
				$d = "SELECT id_skupiny FROM ".TABLE_GROUPS." WHERE id_skupiny = $id_skupiny";
				db::getInstance()->query($d);
				if (db::getInstance()->getNumRows()) {
					$d = "DELETE FROM ".TABLE_GROUPS." WHERE id_skupiny = $id_skupiny LIMIT 1";
					db::getInstance()->query($d);
					$d = "DELETE FROM ".TABLE_PRIV_GROUPS." WHERE id_skupiny = $id_skupiny";
					db::getInstance()->query($d);
					$this->chyba = '<span class="uspesne">Skupina bola úspešne vymazaná.</span><br/>';
				} else {
					$this->chyba = '<span class="chyba">Skupina neexistuje.</span><br/>';
				}
			} else {
				$this->chyba = '<span class="chyba">Skupina pre registrovaných a neregistrovaných užívateľov a administrátor nemôže byť zmazaná.</span><br/>';
			}
			$this->request->setParameter('akcia', 'zoznam_skupin');
		} else {
			$this->chyba .= '<span class="chyba">Nemáte oprávnenie upravovať skupiny užívateľov.</span><br/>';
		}
	}
	
	private function registruj() {
		if (is_numeric($this->request->getParameter('id_uziv'))) {
			if (($this->request->getParameter('id_uziv') != $this->uzivatel->getParameter('id_uziv'))) {
			 	if ($this->uzivatel->prava['uziv-pisat']) {
					$id_uziv = $this->request->getParameter('id_uziv');
			 	} else {
			 		$id_uziv = FALSE;
			 		$this->chyba .= '<span class="chyba">Nemáte oprávnenie meniť údaje užívateľov!</span><br/>';
			 	}
			} else {
				$id_uziv = $this->request->getParameter('id_uziv');
			}
		} else {
			$id_uziv = FALSE;
		}
		
		if (strlen(trim($this->request->getParameter('login'))) > 0) {
			if (strlen(trim($this->request->getParameter('login'))) <= 20) {
				$login = $this->request->getParameter('login');
				if (eregi("^[a-zA-Z0-9_]{1,20}$", $login)) {
					$login = "'".$this->osetri_vstup($login)."'";
				} else {
					$login = FALSE;
					$this->chyba .= '<span class="chyba">Login obsahuje nepovolené znaky!</span><br/>';
				}
			} else {
				$login = FALSE;
				$this->chyba .= '<span class="chyba">Príliš dlhý login!</span><br/>';
			}
		} else {
			$login = FALSE;
			if (!is_numeric($id_uziv)) {
				$this->chyba .= '<span class="chyba">Nezadali ste login!</span><br/>';
			}
		}
		
		if (strlen(trim($this->request->getParameter('heslo1'))) > 0) {
			if (strlen(trim($this->request->getParameter('heslo1'))) <= 50) {
				$heslo1 = $this->osetri_vstup($this->request->getParameter('heslo1'));
			} else {
				$heslo1 = FALSE;
				$this->chyba .= '<span class="chyba">Príliš dlhé 1. heslo!</span><br/>';
			}
		} else {
			$heslo1 = FALSE;
			if (!is_numeric($id_uziv)) {
				$this->chyba .= '<span class="chyba">Nezadali ste 1. heslo!</span><br/>';
			}
		}

		if (strlen(trim($this->request->getParameter('heslo2'))) > 0) {
			if (strlen(trim($this->request->getParameter('heslo2'))) <= 50) {
				$heslo2 = $this->osetri_vstup($this->request->getParameter('heslo2'));
				if ($heslo1 == $heslo2) {
					$heslo = $heslo1;
				} else {
					$heslo = FALSE;
					$this->chyba .= '<span class="chyba">Zadané heslá nesúhlasia!</span><br/>';
				}
			} else {
				$heslo = FALSE;
				$this->chyba .= '<span class="chyba">Príliš dlhé 2. heslo!</span><br/>';
			}
		} else {
			$heslo = FALSE;
			if (!is_numeric($id_uziv)) {
				$this->chyba .= '<span class="chyba">Nezopakovali ste heslo!</span><br/>';
			}
		}
		

		if (strlen(trim($this->request->getParameter('da_meno_priezv'))) > 0) {
			if (strlen(trim($this->request->getParameter('da_meno_priezv'))) <= 40) {
				$da_meno_priezv = "'".$this->osetri_vstup($this->request->getParameter('da_meno_priezv'))."'";
			} else {
				$da_meno_priezv = 'NULL';
				$this->chyba .= '<span class="warning">Príliš dlhé doručovacie meno!</span><br/>';
			}
		} else {
			$da_meno_priezv = 'NULL';
			//$this->chyba .= '<span class="warning">Nezadali ste doručovacie meno!</span><br/>';
		}

		if (strlen(trim($this->request->getParameter('da_ulica'))) > 0) {
			if (strlen(trim($this->request->getParameter('da_ulica'))) <= 50) {
				$da_ulica = "'".$this->osetri_vstup($this->request->getParameter('da_ulica'))."'";
			} else {
				$da_ulica = 'NULL';
				$this->chyba .= '<span class="warning">Príliš dlhá doručovacia ulica!</span><br/>';
			}
		} else {
			$da_ulica = 'NULL';
			//$this->chyba .= '<span class="warning">Nezadali ste doručovaciu ulicu</span><br/>';
		}

		if (strlen(trim($this->request->getParameter('da_mesto'))) > 0) {
			if (strlen(trim($this->request->getParameter('da_mesto'))) <= 50) {
				$da_mesto = "'".$this->osetri_vstup($this->request->getParameter('da_mesto'))."'";
			} else {
				$da_mesto = 'NULL';
				$this->chyba .= '<span class="warning">Príliš dlhé doručovacie mesto!</span><br/>';
			}
		} else {
			$da_mesto = 'NULL';
			//$this->chyba .= '<span class="warning">Nezadali ste doručovacie mesto</span><br/>';
		}

		if (strlen(trim($this->request->getParameter('da_psc'))) > 0) {
			if (strlen(trim($this->request->getParameter('da_psc'))) <= 10) {
				$da_psc = "'".$this->osetri_vstup($this->request->getParameter('da_psc'))."'";
			} else {
				$da_psc = 'NULL';
				$this->chyba .= '<span class="warning">Príliš dlhé doručovacie PSČ!</span><br/>';
			}
		} else {
			$da_psc = 'NULL';
			//$this->chyba .= '<span class="warning">Nezadali ste doručovacie PSČ</span><br/>';
		}
		
		if (is_numeric($this->request->getParameter('da_krajina'))) {
			$da_krajina = $this->request->getParameter('da_krajina');
		} else {
			$da_krajina = 'NULL';
			//$this->chyba .= '<span class="warning">Nevybrali ste doručovaciu krajinu</span><br/>';
		}

		if (strlen(trim($this->request->getParameter('da_email'))) > 0) {
			if (strlen(trim($this->request->getParameter('da_email'))) <= 40) {
				$da_email = "'".$this->osetri_vstup($this->request->getParameter('da_email'))."'";
			} else {
				$da_email = 'NULL';
				$this->chyba .= '<span class="chyba">Príliš dlhý e-mail!</span><br/>';
			}
		} else {
			$da_email = 'NULL';
			$this->chyba .= '<span class="chyba">Nezadali ste e-mail</span><br/>';
		}

		if (strlen(trim($this->request->getParameter('da_tel'))) > 0) {
			if (strlen(trim($this->request->getParameter('da_tel'))) <= 20) {
				$da_tel = "'".$this->osetri_vstup($this->request->getParameter('da_tel'))."'";
			} else {
				$da_tel = 'NULL';
				$this->chyba .= '<span class="warning">Príliš dlhý telefón!</span><br/>';
			}
		} else {
			$da_tel = 'NULL';
			//$this->chyba .= '<span class="warning">Nezadali ste telefón</span><br/>';
		}
		
		if (strlen(trim($this->request->getParameter('da_fax'))) > 0) {
			if (strlen(trim($this->request->getParameter('da_fax'))) <= 20) {
				$da_fax = "'".$this->osetri_vstup($this->request->getParameter('da_fax'))."'";
			} else {
				$da_fax = 'NULL';
				$this->chyba .= '<span class="warning">Príliš dlhý fax!</span><br/>';
			}
		} else {
			$da_fax = 'NULL';
			//$this->chyba .= '<span class="warning">Nezadali ste fax</span><br/>';
		}
		
		if (strlen(trim($this->request->getParameter('da_nazov_firmy'))) > 0) {
			if (strlen(trim($this->request->getParameter('da_nazov_firmy'))) <= 50) {
				$da_nazov_firmy = "'".$this->osetri_vstup($this->request->getParameter('da_nazov_firmy'))."'";
			} else {
				$da_nazov_firmy = 'NULL';
				$this->chyba .= '<span class="warning">Príliš dlhý názov doručovacej firmy!</span><br/>';
			}
		} else {
			$da_nazov_firmy = 'NULL';
			//$this->chyba .= '<span class="warning">Nezadali ste názov doručovacej firmy</span><br/>';
		}
		
		if (strlen(trim($this->request->getParameter('da_ico'))) > 0) {
			if (strlen(trim($this->request->getParameter('da_ico'))) <= 40) {
				$da_ico = "'".$this->osetri_vstup($this->request->getParameter('da_ico'))."'";
			} else {
				$da_ico = 'NULL';
				$this->chyba .= '<span class="warning">Príliš dlhé doručovacie IČO!</span><br/>';
			}
		} else {
			$da_ico = 'NULL';
			//$this->chyba .= '<span class="warning">Nezadali ste doručovacie IČO</span><br/>';
		}
		
		if (strlen(trim($this->request->getParameter('da_dic'))) > 0) {
			if (strlen(trim($this->request->getParameter('da_dic'))) <= 40) {
				$da_dic = "'".$this->osetri_vstup($this->request->getParameter('da_dic'))."'";
			} else {
				$da_dic = 'NULL';
				$this->chyba .= '<span class="warning">Príliš dlhé doručovacie DIČ!</span><br/>';
			}
		} else {
			$da_dic = 'NULL';
			//$this->chyba .= '<span class="warning">Nezadali ste doručovacie DIČ</span><br/>';
		}
		
		if (strlen(trim($this->request->getParameter('fa_meno_priezv'))) > 0) {
			if (strlen(trim($this->request->getParameter('fa_meno_priezv'))) <= 40) {
				$fa_meno_priezv = "'".$this->osetri_vstup($this->request->getParameter('fa_meno_priezv'))."'";
			} else {
				$fa_meno_priezv = 'NULL';
				$this->chyba .= '<span class="warning">Príliš dlhé fakturačné meno!</span><br/>';
			}
		} else {
			$fa_meno_priezv = 'NULL';
			//$this->chyba .= '<span class="warning">Nezadali ste fakturačné meno!</span><br/>';
		}

		if (strlen(trim($this->request->getParameter('fa_ulica'))) > 0) {
			if (strlen(trim($this->request->getParameter('fa_ulica'))) <= 50) {
				$fa_ulica = "'".$this->osetri_vstup($this->request->getParameter('fa_ulica'))."'";
			} else {
				$fa_ulica = 'NULL';
				$this->chyba .= '<span class="warning">Príliš dlhá fakturačná ulica!</span><br/>';
			}
		} else {
			$fa_ulica = 'NULL';
			//$this->chyba .= '<span class="warning">Nezadali ste fakturačnú ulicu</span><br/>';
		}

		if (strlen(trim($this->request->getParameter('fa_mesto'))) > 0) {
			if (strlen(trim($this->request->getParameter('fa_mesto'))) <= 50) {
				$fa_mesto = "'".$this->osetri_vstup($this->request->getParameter('fa_mesto'))."'";
			} else {
				$fa_mesto = 'NULL';
				$this->chyba .= '<span class="warning">Príliš dlhé fakturačné mesto!</span><br/>';
			}
		} else {
			$fa_mesto = 'NULL';
			//$this->chyba .= '<span class="warning">Nezadali ste fakturačné mesto</span><br/>';
		}

		if (strlen(trim($this->request->getParameter('fa_psc'))) > 0) {
			if (strlen(trim($this->request->getParameter('fa_psc'))) <= 10) {
				$fa_psc = "'".$this->osetri_vstup($this->request->getParameter('fa_psc'))."'";
			} else {
				$fa_psc = 'NULL';
				$this->chyba .= '<span class="warning">Príliš dlhé fakturačné PSČ!</span><br/>';
			}
		} else {
			$fa_psc = 'NULL';
			//$this->chyba .= '<span class="warning">Nezadali ste fakturačné PSČ</span><br/>';
		}
		
		if (is_numeric($this->request->getParameter('fa_krajina'))) {
			$fa_krajina = $this->request->getParameter('fa_krajina');
		} else {
			$fa_krajina = 'NULL';
			//$this->chyba .= '<span class="warning">Nevybrali ste fakturačnú krajinu</span><br/>';
		}
		
		if (strlen(trim($this->request->getParameter('fa_nazov_firmy'))) > 0) {
			if (strlen(trim($this->request->getParameter('fa_nazov_firmy'))) <= 50) {
				$fa_nazov_firmy = "'".$this->osetri_vstup($this->request->getParameter('fa_nazov_firmy'))."'";
			} else {
				$fa_nazov_firmy = 'NULL';
				$this->chyba .= '<span class="warning">Príliš dlhý názov fakturačnej firmy!</span><br/>';
			}
		} else {
			$fa_nazov_firmy = 'NULL';
			//$this->chyba .= '<span class="warning">Nezadali ste názov fakturačnej firmy</span><br/>';
		}
		
		if (strlen(trim($this->request->getParameter('fa_ico'))) > 0) {
			if (strlen(trim($this->request->getParameter('fa_ico'))) <= 40) {
				$fa_ico = "'".$this->osetri_vstup($this->request->getParameter('fa_ico'))."'";
			} else {
				$fa_ico = 'NULL';
				$this->chyba .= '<span class="warning">Príliš dlhé fakturačné IČO!</span><br/>';
			}
		} else {
			$fa_ico = 'NULL';
			//$this->chyba .= '<span class="warning">Nezadali ste fakturačné IČO</span><br/>';
		}
		
		if (strlen(trim($this->request->getParameter('fa_dic'))) > 0) {
			if (strlen(trim($this->request->getParameter('fa_dic'))) <= 40) {
				$fa_dic = "'".$this->osetri_vstup($this->request->getParameter('fa_dic'))."'";
			} else {
				$fa_dic = 'NULL';
				$this->chyba .= '<span class="warning">Príliš dlhé fakturačné DIČ!</span><br/>';
			}
		} else {
			$fa_dic = 'NULL';
			//$this->chyba .= '<span class="warning">Nezadali ste fakturačné DIČ</span><br/>';
		}
		
		if ($this->request->getParameter('spravodaj') != '') {
			$spravodaj = 1;
		} else {
			$spravodaj = 0;
		}
		
		if ($id_uziv && $da_email) {
			$this->uzivatel->zmen_udaje($id_uziv, $heslo, $da_meno_priezv, $da_ulica, $da_mesto, $da_psc, $da_email, $da_tel, $da_fax, $da_krajina, $da_nazov_firmy, $da_ico, $da_dic, $fa_meno_priezv, $fa_ulica, $fa_mesto, $fa_psc, $fa_krajina, $fa_nazov_firmy, $fa_ico, $fa_dic, $spravodaj);
			$this->uzivatel->nahraj_udaje($this->uzivatel->getParameter('id_uziv'));
			$this->chyba .= '<span class="uspesne">Vaše údaje boli úspešne upravené.</span><br/>';
			$this->request->setParameter('akcia', 'zmena_udajov');
		} else if ($login && $heslo && $da_email) {
			$d = "SELECT id_uziv FROM ".TABLE_USERS." WHERE login = $login";
			db::getInstance()->query($d);
			if (db::getInstance()->getNumRows() == 0) {
				uzivatel::registruj($login, $heslo, $da_meno_priezv, $da_ulica, $da_mesto, $da_psc, $da_email, $da_tel, $da_fax, $da_krajina, $da_nazov_firmy, $da_ico, $da_dic, $fa_meno_priezv, $fa_ulica, $fa_mesto, $fa_psc, $fa_krajina, $fa_nazov_firmy, $fa_ico, $fa_dic, $spravodaj);
				$this->request->unsetAll();
				$this->chyba .= '<span class="uspesne">Registrácia prebehla úspešne.</span><br/>';
			} else {
				$this->chyba .= '<span class="chyba">Zvolené užívateľské meno je obsadené, zvoľte si iné.</span><br/>';
			}
			//$this->request->setParameter('akcia', 'registracia');
		} else {
			if ($id_uziv) { $this->request->setParameter('akcia', 'zmena_udajov'); }
			//else { $this->request->setParameter('akcia', 'registracia'); }
		}
	}
	
	private function uprav_uziv() {
		if (isset($this->uzivatel->prava['uziv-pisat']) && $this->uzivatel->je_spravne_prihlaseny()) {
			if (is_numeric($this->request->getParameter('id_uziv'))) {
				$id_uziv = $this->request->getParameter('id_uziv');
			} else {
				$id_uziv = FALSE;
				$this->chyba .= '<span class="chyba">Nie je zvolený užívateľ.</span><br/>';
			}
			if (is_numeric($this->request->getParameter('id_skupiny'))) {
				$id_skupiny = $this->request->getParameter('id_skupiny');
			} else {
				$id_skupiny = FALSE;
				$this->chyba .= '<span class="chyba">Nie je zvolená skupina.</span><br/>';
			}
			if ($this->request->getParameter('platca_dph') != '') {
				$platca_dph = 1;
			} else {
				$platca_dph = 0;
			}
			if ($id_uziv && $id_skupiny) {
				$d = "SELECT id_uziv FROM ".TABLE_USERS." WHERE id_uziv = $id_uziv";
				db::getInstance()->query($d);
				if (db::getInstance()->getNumRows()) {
					$d = "SELECT id_skupiny FROM ".TABLE_GROUPS." WHERE id_skupiny = $id_skupiny";
					db::getInstance()->query($d);
					if (db::getInstance()->getNumRows()) {
						$d = "UPDATE ".TABLE_USERS." SET id_skupiny = $id_skupiny, platca_dph = $platca_dph
								WHERE id_uziv = $id_uziv LIMIT 1";
						db::getInstance()->query($d);
						if ($id_uziv == $this->uzivatel->getParameter('id_uziv')) {
							$this->uzivatel->nahraj_udaje($id_uziv);
						}
						$this->chyba .= '<span class="uspesne">Užívateľ bol úspešne upravený.</span><br/>';
					} else {
						$this->chyba .= '<span class="chyba">Zvolená skupina neexistuje.</span><br/>';
					}
				} else {
					$this->chyba .= '<span class="chyba">Zvolený užívateľ neexistuje.</span><br/>';
				}
			}
			$this->request->setParameter('akcia', 'zoznam_uziv');
		} else {
			$this->chyba .= '<span class="chyba">Nemáte oprávnenie upravovať užívateľov.</span><br/>';
		}
	}
	
	private function zmen_prava() {
		if (isset($this->uzivatel->prava['skupiny-pisat']) && $this->uzivatel->je_spravne_prihlaseny()) {
			if (is_numeric($this->request->getParameter('id_skupiny'))) {
				$id_skupiny = $this->request->getParameter('id_skupiny');
			} else {
				$id_skupiny = FALSE;
				$this->chyba .= '<span class="chyba">Nie je zvolená skupina.</span><br/>';
			}
			if ($id_skupiny) {
				if ($id_skupiny != ADMIN) {
					$d = "DELETE FROM ".TABLE_PRIV_GROUPS." WHERE id_skupiny = $id_skupiny";
					db::getInstance()->query($d);
					if (is_array($this->request->getParameter('prava'))) {
						foreach ($this->request->getParameter('prava') as $hodnota) {
							$d = "INSERT INTO ".TABLE_PRIV_GROUPS." (id_skupiny, id_prava)
								VALUES ($id_skupiny, $hodnota)";
							db::getInstance()->query($d);
						}
					}
					$this->uzivatel->nahraj_udaje($this->uzivatel->vlastnosti['id_uziv']);
					$this->chyba .= '<span class="uspesne">Skupina bola úspešne upravená.</span><br/>';
				} else {
					$this->chyba .= '<span class="chyba">Skupina "Administrátor" nemôže byť upravená</span><br/>';
				}
			}
			//$this->request->setParameter('akcia', 'zoznam_skupin');
		} else {
			$this->chyba .= '<span class="chyba">Nemáte oprávnenie upravovať skupiny užívateľov.</span><br/>';
		}
	}
	
	private function pridaj_skupinu() {
		if (isset($this->uzivatel->prava['skupiny-pisat']) && $this->uzivatel->je_spravne_prihlaseny()) {
			if (strlen(trim($this->request->getParameter('nazov'))) > 0) {
				if (strlen(trim($this->request->getParameter('nazov'))) <= 30) {
					$nazov = "'".$this->osetri_vstup($this->request->getParameter('nazov'))."'";
					$d = "SELECT id_skupiny FROM ".TABLE_GROUPS." WHERE nazov = $nazov";
					db::getInstance()->query($d);
					if (db::getInstance()->getNumRows() == 0) {
						$d = "INSERT INTO ".TABLE_GROUPS." (nazov) VALUES ($nazov)";
						db::getInstance()->query($d);
						$this->chyba .= '<span class="uspesne">Nová skupina bola úspešne pridaná.</span><br/>';
					} else {
						$this->chyba .= '<span class="chyba">Skupina '.$nazov.' už existuje, zvoľte si iný názov!</span><br/>';
					}
				} else {
					$nazov = FALSE;
					$this->chyba .= '<span class="chyba">Nový názov je príliš dlhý!</span><br/>';
				}
			} else {
				$nazov = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste názov!</span><br/>';
			}
			$this->request->setParameter('akcia', 'zoznam_skupin');
		} else {
			$this->chyba .= '<span class="chyba">Nemáte oprávnenie upravovať skupiny užívateľov.</span><br/>';
		}
	}

	private function zabudnute_heslo() {
		if (strlen(trim($this->request->getParameter('login'))) > 0) {
			if (strlen(trim($this->request->getParameter('login'))) <= 20) {
				$login = $this->osetri_vstup($this->request->getParameter('login'));
			} else {
				$login = FALSE;
				$this->chyba .= '<span class="chyba">Login je príliš dlhý!</span><br/>';
			}
		} else {
			$login = FALSE;
			$this->chyba .= '<span class="chyba">Nie je vyplnený login</span><br/>';
		}
		if (strlen(trim($this->request->getParameter('email'))) > 0) {
			if (strlen(trim($this->request->getParameter('email'))) <= 40) {
				$email = $this->osetri_vstup($this->request->getParameter('email'));
			} else {
				$email = FALSE;
				$this->chyba .= '<span class="chyba">E-mail je príliš dlhý!</span><br/>';
			}
		} else {
			$email = FALSE;
			$this->chyba .= '<span class="chyba">Nie je vyplnený e-mail</span><br/>';
		}
		if ($login && $email) {
			$this->chyba .= uzivatel::obnov_heslo($login, $email);
		}
	}

	private function spracuj_kontakt() {
		if ($this->uzivatel->prava['adresar-pisat']) {
			if (is_numeric($this->request->getParameter('id'))) {
				$id = $this->request->getParameter('id');
			 } else {
			 	$id = FALSE;
			 }
			 
			if (strlen(trim($this->request->getParameter('da_meno'))) > 0) {
				if (strlen(trim($this->request->getParameter('da_meno'))) <= 100) {
					$da_meno = "'".$this->osetri_vstup($this->request->getParameter('da_meno'))."'";
				} else {
					$da_meno = FALSE;
					$this->chyba .= '<span class="chyba">Príliš dlhé doručovacie meno!</span><br/>';
				}
			} else {
				$da_meno = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste meno doručovacej adresy</span><br/>';
			}

			if (strlen(trim($this->request->getParameter('da_ulica'))) > 0) {
				if (strlen(trim($this->request->getParameter('da_ulica'))) <= 50) {
					$da_ulica = "'".$this->osetri_vstup($this->request->getParameter('da_ulica'))."'";
				} else {
					$da_ulica = FALSE;
					$this->chyba .= '<span class="chyba">Príliš dlhá doručovacia ulica!</span><br/>';
				}
			} else {
				$da_ulica = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste ulicu doručovacej adresy</span><br/>';
			}

			if (strlen(trim($this->request->getParameter('da_mesto'))) > 0) {
				if (strlen(trim($this->request->getParameter('da_mesto'))) <= 50) {
					$da_mesto = "'".$this->osetri_vstup($this->request->getParameter('da_mesto'))."'";
				} else {
					$da_mesto = FALSE;
					$this->chyba .= '<span class="chyba">Príliš dlhé doručovacie mesto!</span><br/>';
				}
			} else {
				$da_mesto = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste mesto doručovacej adresy</span><br/>';
			}

			if (strlen(trim($this->request->getParameter('da_psc'))) > 0) {
				if (strlen(trim($this->request->getParameter('da_psc'))) <= 10) {
					$da_psc = "'".$this->osetri_vstup($this->request->getParameter('da_psc'))."'";
				} else {
					$da_psc = FALSE;
					$this->chyba .= '<span class="chyba">Príliš dlhé doručovacie PSČ!</span><br/>';
				}
			} else {
				$da_psc = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste PSČ doručovacej adresy</span><br/>';
			}
		
			if (strlen(trim($this->request->getParameter('da_stat'))) > 0) {
				if (strlen(trim($this->request->getParameter('da_stat'))) <= 100) {
					$da_stat = "'".$this->osetri_vstup($this->request->getParameter('da_stat'))."'";
				} else {
					$da_stat = FALSE;
					$this->chyba .= '<span class="chyba">Príliš dlhý doručovací štát!</span><br/>';
				}
			} else {
				$da_stat = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste štát doručovacej adresy</span><br/>';
			}
			
			if (strlen(trim($this->request->getParameter('fa_meno'))) > 0) {
				if (strlen(trim($this->request->getParameter('fa_meno'))) <= 100) {
					$fa_meno = "'".$this->osetri_vstup($this->request->getParameter('fa_meno'))."'";
				} else {
					$fa_meno = 'NULL';
					$this->chyba .= '<span class="chyba">Príliš dlhé fakturačné meno!</span><br/>';
				}
			} else {
				$fa_meno = 'NULL';
			}

			if (strlen(trim($this->request->getParameter('fa_ulica'))) > 0) {
				if (strlen(trim($this->request->getParameter('fa_ulica'))) <= 50) {
					$fa_ulica = "'".$this->osetri_vstup($this->request->getParameter('fa_ulica'))."'";
				} else {
					$fa_ulica = 'NULL';
					$this->chyba .= '<span class="chyba">Príliš dlhá fakturačná ulica!</span><br/>';
				}
			} else {
				$fa_ulica = 'NULL';
			}

			if (strlen(trim($this->request->getParameter('fa_mesto'))) > 0) {
				if (strlen(trim($this->request->getParameter('fa_mesto'))) <= 50) {
					$fa_mesto = "'".$this->osetri_vstup($this->request->getParameter('fa_mesto'))."'";
				} else {
					$fa_mesto = 'NULL';
					$this->chyba .= '<span class="chyba">Príliš dlhé fakturačné mesto!</span><br/>';
				}
			} else {
				$fa_mesto = 'NULL';
			}

			if (strlen(trim($this->request->getParameter('fa_psc'))) > 0) {
				if (strlen(trim($this->request->getParameter('fa_psc'))) <= 10) {
					$fa_psc = "'".$this->osetri_vstup($this->request->getParameter('fa_psc'))."'";
				} else {
					$fa_psc = 'NULL';
					$this->chyba .= '<span class="chyba">Príliš dlhé fakturačné PSČ!</span><br/>';
				}
			} else {
				$fa_psc = 'NULL';
			}
		
			if (strlen(trim($this->request->getParameter('fa_stat'))) > 0) {
				if (strlen(trim($this->request->getParameter('fa_stat'))) <= 100) {
					$fa_stat = "'".$this->osetri_vstup($this->request->getParameter('fa_stat'))."'";
				} else {
					$fa_stat = 'NULL';
					$this->chyba .= '<span class="chyba">Príliš dlhý fakturačný štát!</span><br/>';
				}
			} else {
				$fa_stat = 'NULL';
			}

			if (strlen(trim($this->request->getParameter('email'))) > 0) {
				if (strlen(trim($this->request->getParameter('email'))) <= 50) {
					$email = "'".$this->osetri_vstup($this->request->getParameter('email'))."'";
				} else {
					$email = 'NULL';
					$this->chyba .= '<span class="chyba">Príliš dlhý e-mail!</span><br/>';
				}
			} else {
				$email = 'NULL';
			}

			if (strlen(trim($this->request->getParameter('telefon'))) > 0) {
				if (strlen(trim($this->request->getParameter('telefon'))) <= 30) {
					$telefon = "'".$this->osetri_vstup($this->request->getParameter('telefon'))."'";
				} else {
					$telefon = 'NULL';
					$this->chyba .= '<span class="chyba">Príliš dlhý telefón!</span><br/>';
				}
			} else {
				$telefon = 'NULL';
			}
		
			if (strlen(trim($this->request->getParameter('fax'))) > 0) {
				if (strlen(trim($this->request->getParameter('fax'))) <= 30) {
					$fax = "'".$this->osetri_vstup($this->request->getParameter('fax'))."'";
				} else {
					$fax = 'NULL';
					$this->chyba .= '<span class="chyba">Príliš dlhý fax!</span><br/>';
				}
			} else {
				$fax = 'NULL';
			}
			
			if ($da_meno && $da_ulica && $da_mesto && $da_psc && $da_stat) {
				if ($id) {
					kontakt::uprav_kontakt($id, $da_meno, $da_ulica, $da_mesto, $da_psc, $da_stat, $fa_meno, $fa_ulica, $fa_mesto, $fa_psc, $fa_stat, $email, $telefon, $fax);
					$this->chyba .= '<span class="uspesne">Kontakt bol úspešne upravený.</span><br/>';
				} else {
					kontakt::vloz_kontakt($da_meno, $da_ulica, $da_mesto, $da_psc, $da_stat, $fa_meno, $fa_ulica, $fa_mesto, $fa_psc, $fa_stat, $email, $telefon, $fax);
					$this->chyba .= '<span class="uspesne">Kontakt bol úspešne pridaný.</span><br/>';
				}
				$this->request->setParameter('akcia', 'adresar_kontaktov');
			}
		} else {
			$this->request->setParameter('akcia', 'index');
			$this->spracuj->chyba .= '<span class="chyba">Nemáte oprávnenie na upravovanie kontaktov</span><br/>';
		}
	}
	
	private function zmazat_kontakt() {
		if ($this->uzivatel->prava['adresar-pisat']) {
			if (is_numeric($this->request->getParameter('id'))) {
				kontakt::zmazat_kontakt($this->request->getParameter('id'));
				$this->chyba .= '<span class="uspesne">Kontakt bol vymazaný</span><br/>';
			} else {
				$this->chyba .= '<span class="chyba">Nieje vybraný kontakt</span><br/>';
			}
		} else {
			$this->chyba .= '<span class="chyba">Nemáte oprávnenie na zmazanie kontaktu</span><br/>';
		}
		$this->request->setParameter('akcia', 'adresar_kontaktov');
	}
	
	private function spracuj_postu() {
		if (isset($this->uzivatel->prava['posta-pisat'])) {
			if (is_numeric($this->request->getParameter('id'))) {
				$id = $this->request->getParameter('id');
			} else {
				$id = FALSE;
			}
			 
			if (strlen(trim($this->request->getParameter('datum'))) > 0) {
				if (strlen(trim($this->request->getParameter('datum'))) <= 10) {
					$datum = explode('.',$this->request->getParameter('datum'));
					if (is_numeric($datum[0]) && is_numeric($datum[1]) && is_numeric($datum[2])
						&& ($datum[0] < 32) && ($datum[1] < 13) && ($datum[2] < 2100)) {
						$den = ($datum[0] < 10) ? '0'.$datum[0] : $datum[0];
						$mesiac = ($datum[1] < 10) ? '0'.$datum[1] : $datum[1];
						$datum = "'".$datum[2].'-'.$mesiac.'-'.$den."'";
					} else {
						$datum = FALSE;
						$this->chyba .= '<span class="chyba">Dátum je v nesprávnom formáte!</span><br/>';
					}
				} else {
					$datum = FALSE;
					$this->chyba .= '<span class="chyba">Dátum je príliš dlhý</span><br/>';
				}
			} else {
				$datum = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste dátum</span><br/>';
			}
			
			if (strlen(trim($this->request->getParameter('meno'))) > 0) {
				if (strlen(trim($this->request->getParameter('meno'))) <= 100) {
					$meno = "'".$this->osetri_vstup($this->request->getParameter('meno'))."'";
				} else {
					$meno = FALSE;
					$this->chyba .= '<span class="chyba">Príliš dlhé meno!</span><br/>';
				}
			} else {
				$meno = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste meno</span><br/>';
			}

			if (strlen(trim($this->request->getParameter('ulica'))) > 0) {
				if (strlen(trim($this->request->getParameter('ulica'))) <= 50) {
					$ulica = "'".$this->osetri_vstup($this->request->getParameter('ulica'))."'";
				} else {
					$ulica = FALSE;
					$this->chyba .= '<span class="chyba">Príliš dlhá ulica!</span><br/>';
				}
			} else {
				$ulica = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste ulicu</span><br/>';
			}

			if (strlen(trim($this->request->getParameter('mesto'))) > 0) {
				if (strlen(trim($this->request->getParameter('mesto'))) <= 50) {
					$mesto = "'".$this->osetri_vstup($this->request->getParameter('mesto'))."'";
				} else {
					$mesto = FALSE;
					$this->chyba .= '<span class="chyba">Príliš dlhé mesto!</span><br/>';
				}
			} else {
				$mesto = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste mesto</span><br/>';
			}

			if (strlen(trim($this->request->getParameter('psc'))) > 0) {
				if (strlen(trim($this->request->getParameter('psc'))) <= 10) {
					$psc = "'".$this->osetri_vstup($this->request->getParameter('psc'))."'";
				} else {
					$psc = FALSE;
					$this->chyba .= '<span class="chyba">Príliš dlhé PSČ!</span><br/>';
				}
			} else {
				$psc = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste PSČ</span><br/>';
			}
		
			if (strlen(trim($this->request->getParameter('stat'))) > 0) {
				if (strlen(trim($this->request->getParameter('stat'))) <= 100) {
					$stat = "'".$this->osetri_vstup($this->request->getParameter('stat'))."'";
				} else {
					$stat = FALSE;
					$this->chyba .= '<span class="chyba">Príliš dlhý!</span><br/>';
				}
			} else {
				$stat = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste štát</span><br/>';
			}
			
			if ($this->request->getParameter('dorucena')) {
				$dorucena = 1;
			} else {
				$dorucena = 0;
			}
		
			if (strlen(trim($this->request->getParameter('popis'))) > 0) {
				if (strlen(trim($this->request->getParameter('popis'))) <= 255) {
					$popis = "'".$this->osetri_vstup($this->request->getParameter('popis'))."'";
				} else {
					$popis = 'NULL';
					$this->chyba .= '<span class="chyba">Príliš dlhý popis!</span><br/>';
				}
			} else {
				$popis = 'NULL';
			}
			
			if (strlen(trim($this->request->getParameter('odoslane'))) > 0) {
				if (strlen(trim($this->request->getParameter('odoslane'))) <= 10) {
					$odoslane = explode('.',$this->request->getParameter('odoslane'));
					if (is_numeric($odoslane[0]) && is_numeric($odoslane[1]) && is_numeric($odoslane[2])
						&& ($odoslane[0] < 32) && ($odoslane[1] < 13) && ($odoslane[2] < 2100)) {
						$den = ($odoslane[0] < 10) ? '0'.$odoslane[0] : $odoslane[0];
						$mesiac = ($odoslane[1] < 10) ? '0'.$odoslane[1] : $odoslane[1];
						$odoslane = "'".$odoslane[2].'-'.$mesiac.'-'.$den."'";
					} else {
						$odoslane = 'NULL';
						$this->chyba .= '<span class="chyba">Dátum odoslania je v nesprávnom formáte!</span><br/>';
					}
				} else {
					$odoslane = 'NULL';
					$this->chyba .= '<span class="chyba">Dátum odoslania je príliš dlhý!</span><br/>';
				}
			} else {
				$odoslane = 'NULL';
			}
			
			if (strlen(trim($this->request->getParameter('typ'))) > 0) {
				if (strlen(trim($this->request->getParameter('typ'))) <= 20) {
					$typ = "'".$this->osetri_vstup($this->request->getParameter('typ'))."'";
				} else {
					$typ = 'NULL';
					$this->chyba .= '<span class="chyba">Príliš dlhý typ!</span><br/>';
				}
			} else {
				$typ = 'NULL';
			}
			
			if (strlen(trim($this->request->getParameter('postovne'))) > 0) {
				if (strlen(trim($this->request->getParameter('postovne'))) <= 20) {
					$postovne = "'".$this->osetri_vstup($this->request->getParameter('postovne'))."'";
				} else {
					$postovne = 'NULL';
					$this->chyba .= '<span class="chyba">Príliš dlhé poštovné!</span><br/>';
				}
			} else {
				$postovne = 'NULL';
			}
			
			if ($datum && $meno && $ulica && $mesto && $psc && $stat) {
				if ($id) {
					evid_posty::uprav_zaznam($id, $datum, $meno, $ulica, $mesto, $psc, $stat, $dorucena, $popis, $odoslane, $typ, $postovne);
					$this->chyba .= '<span class="uspesne">Záznam bol úspešne upravený.</span><br/>';
				} else {
					evid_posty::vloz_zaznam($datum, $meno, $ulica, $mesto, $psc, $stat, $dorucena, $popis, $odoslane, $typ, $postovne);
					$this->chyba .= '<span class="uspesne">Záznam bol úspešne pridaný.</span><br/>';
				}
				$this->request->setParameter('akcia', 'posta');
			}
		} else {
			$this->request->setParameter('akcia', 'index');
			$this->spracuj->chyba .= '<span class="chyba">Nemáte oprávnenie na upravovanie evidencie pošty</span><br/>';
		}
	}
	
	private function zmazat_postu() {
		if ($this->uzivatel->prava['posta-pisat']) {
			if (is_numeric($this->request->getParameter('id'))) {
				evid_posty::zmazat_postu($this->request->getParameter('id'));
				$this->chyba .= '<span class="uspesne">Pošta bola vymazaná z evidencie</span><br/>';
			} else {
				$this->chyba .= '<span class="chyba">Nieje vybraná pošta</span><br/>';
			}
		} else {
			$this->chyba .= '<span class="chyba">Nemáte oprávnenie na zmazanie pošty</span><br/>';
		}
		$this->request->setParameter('akcia', 'posta');
	}
	
	private function spracuj_kartu() {
		if (isset($this->uzivatel->prava['sklad-pisat'])) {
			if (is_numeric($this->request->getParameter('id'))) {
				$id = $this->request->getParameter('id');
			} else {
				$id = FALSE;
			}
			
			if (strlen(trim($this->request->getParameter('kod'))) > 0) {
				if (strlen(trim($this->request->getParameter('kod'))) <= 20) {
					$kod = "'".$this->osetri_vstup($this->request->getParameter('kod'))."'";
				} else {
					$kod = FALSE;
					$this->chyba .= '<span class="chyba">Príliš dlhý kód!</span><br/>';
				}
			} else {
				$kod = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste kód</span><br/>';
			}
			
			if (strlen(trim($this->request->getParameter('nazov'))) > 0) {
				if (strlen(trim($this->request->getParameter('nazov'))) <= 100) {
					$nazov = "'".$this->osetri_vstup($this->request->getParameter('nazov'))."'";
				} else {
					$nazov = FALSE;
					$this->chyba .= '<span class="chyba">Príliš dlhý názov!</span><br/>';
				}
			} else {
				$nazov = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste názov</span><br/>';
			}
			
			if (is_numeric(str_replace(',', '.', $this->request->getParameter('cena')))) {
				$cena = str_replace(',', '.', $this->request->getParameter('cena')); 
			} else {
				$cena = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste cenu</span><br/>';
			}
			
			if (strlen(trim($this->request->getParameter('jednotka'))) > 0) {
				if (strlen(trim($this->request->getParameter('jednotka'))) <= 10) {
					$jednotka = "'".$this->osetri_vstup($this->request->getParameter('jednotka'))."'";
				} else {
					$jednotka = FALSE;
					$this->chyba .= '<span class="chyba">Príliš dlhá množstevná jednotka!</span><br/>';
				}
			} else {
				$jednotka = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste množstevnú jednotku</span><br/>';
			}
			
			if ($kod && $nazov && $cena && $jednotka) {
				if ($id) {
					sklad::uprav_kartu($id, $kod, $nazov, $cena, $jednotka);
					$this->chyba .= '<span class="uspesne">Karta bola úspešne upravená.</span><br/>';
				} else {
					sklad::vloz_kartu($kod, $nazov, $cena, $jednotka);
					$this->chyba .= '<span class="uspesne">Karta bola úspešne pridaná.</span><br/>';
				}
				$this->request->setParameter('akcia', 'sklad');
			}
		} else {
			$this->request->setParameter('akcia', 'index');
			$this->spracuj->chyba .= '<span class="chyba">Nemáte oprávnenie na upravovanie skladu</span><br/>';
		}
	}
	
	private function deaktivovat_kartu() {
		if ($this->uzivatel->prava['sklad-pisat']) {
			if (is_numeric($this->request->getParameter('id'))) {
				sklad::deaktivovat($this->request->getParameter('id'));
				$this->chyba .= '<span class="uspesne">Karta bola deaktivovaná</span><br/>';
			} else {
				$this->chyba .= '<span class="chyba">Nieje vybraná karta</span><br/>';
			}
		} else {
			$this->chyba .= '<span class="chyba">Nemáte oprávnenie na deaktivovanie karty</span><br/>';
		}
		$this->request->setParameter('akcia', 'sklad');
	}
	
	private function spracuj_pv() {
		if (isset($this->uzivatel->prava['pv-pisat'])) {
			if (is_numeric($this->request->getParameter('id'))) {
				$id = $this->request->getParameter('id');
			} else {
				$id = FALSE;
			}
			
			if (is_numeric($this->request->getParameter('id_sklad_karta'))) {
				$id_sklad_karta = $this->request->getParameter('id_sklad_karta');
			} else {
				$id_sklad_karta = FALSE;
				$this->chyba .= '<span class="chyba">Nevybrali ste tovar</span><br/>';
			}
			
			if ($this->request->getParameter('prijemka')) {
				$prijemka = 1;
			} else {
				$prijemka = 0;
			}
			
			if (strlen(trim($this->request->getParameter('datum'))) > 0) {
				if (strlen(trim($this->request->getParameter('datum'))) <= 10) {
					$datum = explode('.',$this->request->getParameter('datum'));
					if (is_numeric($datum[0]) && is_numeric($datum[1]) && is_numeric($datum[2])
						&& ($datum[0] < 32) && ($datum[1] < 13) && ($datum[2] < 2100)) {
						$den = ($datum[0] < 10) ? '0'.$datum[0] : $datum[0];
						$mesiac = ($datum[1] < 10) ? '0'.$datum[1] : $datum[1];
						$datum = "'".$datum[2].'-'.$mesiac.'-'.$den."'";
					} else {
						$datum = FALSE;
						$this->chyba .= '<span class="chyba">Dátum je v nesprávnom formáte!</span><br/>';
					}
				} else {
					$datum = FALSE;
					$this->chyba .= '<span class="chyba">Dátum je príliš dlhý</span><br/>';
				}
			} else {
				$datum = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste dátum</span><br/>';
			}
			
			if (is_numeric($this->request->getParameter('kusy'))) {
				$kusy = $this->request->getParameter('kusy');
			} else {
				$kusy = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste kusy</span><br/>';
			}
			
			if (strlen(trim($this->request->getParameter('pozn'))) > 0) {
				if (strlen(trim($this->request->getParameter('pozn'))) <= 255) {
					$pozn = "'".$this->osetri_vstup($this->request->getParameter('pozn'))."'";
				} else {
					$pozn = 'NULL';
					$this->chyba .= '<span class="chyba">Príliš dlhá poznámka!</span><br/>';
				}
			} else {
				$pozn = 'NULL';
			}
			
			if (strlen(trim($this->request->getParameter('meno'))) > 0) {
				if (strlen(trim($this->request->getParameter('meno'))) <= 100) {
					$meno = "'".$this->osetri_vstup($this->request->getParameter('meno'))."'";
				} else {
					$meno = FALSE;
					$this->chyba .= '<span class="chyba">Príliš dlhé meno!</span><br/>';
				}
			} else {
				$meno = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste meno</span><br/>';
			}

			if (strlen(trim($this->request->getParameter('ulica'))) > 0) {
				if (strlen(trim($this->request->getParameter('ulica'))) <= 50) {
					$ulica = "'".$this->osetri_vstup($this->request->getParameter('ulica'))."'";
				} else {
					$ulica = FALSE;
					$this->chyba .= '<span class="chyba">Príliš dlhá ulica!</span><br/>';
				}
			} else {
				$ulica = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste ulicu</span><br/>';
			}

			if (strlen(trim($this->request->getParameter('mesto'))) > 0) {
				if (strlen(trim($this->request->getParameter('mesto'))) <= 50) {
					$mesto = "'".$this->osetri_vstup($this->request->getParameter('mesto'))."'";
				} else {
					$mesto = FALSE;
					$this->chyba .= '<span class="chyba">Príliš dlhé mesto!</span><br/>';
				}
			} else {
				$mesto = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste mesto</span><br/>';
			}

			if (strlen(trim($this->request->getParameter('psc'))) > 0) {
				if (strlen(trim($this->request->getParameter('psc'))) <= 10) {
					$psc = "'".$this->osetri_vstup($this->request->getParameter('psc'))."'";
				} else {
					$psc = FALSE;
					$this->chyba .= '<span class="chyba">Príliš dlhé PSČ!</span><br/>';
				}
			} else {
				$psc = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste PSČ</span><br/>';
			}
		
			if (strlen(trim($this->request->getParameter('stat'))) > 0) {
				if (strlen(trim($this->request->getParameter('stat'))) <= 100) {
					$stat = "'".$this->osetri_vstup($this->request->getParameter('stat'))."'";
				} else {
					$stat = FALSE;
					$this->chyba .= '<span class="chyba">Príliš dlhý!</span><br/>';
				}
			} else {
				$stat = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste štát</span><br/>';
			}
			
			if ($id_sklad_karta && $datum && $kusy && $meno && $ulica && $mesto && $psc && $stat) {
				if ($id) {
					sklad::uprav_pv($id, $id_sklad_karta, $prijemka, $datum, $kusy, $pozn, $meno, $ulica, $mesto, $psc, $stat);
					if ($prijemka) {
						$this->chyba .= '<span class="uspesne">Príjemka bola úspešne upravená.</span><br/>';
					} else {
						$this->chyba .= '<span class="uspesne">Výdajka bola úspešne upravená.</span><br/>';
					}
				} else {
					sklad::vloz_pv($id_sklad_karta, $prijemka, $datum, $kusy, $pozn, $meno, $ulica, $mesto, $psc, $stat);
					if ($prijemka) {
						$this->chyba .= '<span class="uspesne">Príjemka bola úspešne pridaná.</span><br/>';
					} else {
						$this->chyba .= '<span class="uspesne">Výdajka bola úspešne pridaná.</span><br/>';
					}
				}
				$this->request->setParameter('akcia', 'prijem_vydaj');
			}
		} else {
			$this->request->setParameter('akcia', 'index');
			$this->spracuj->chyba .= '<span class="chyba">Nemáte oprávnenie na upravovanie skladu</span><br/>';
		}
	}
	
	private function zmazat_pv() {
		if ($this->uzivatel->prava['pv-pisat']) {
			if (is_numeric($this->request->getParameter('id'))) {
				sklad::zmazat_pv($this->request->getParameter('id'));
				$this->chyba .= '<span class="uspesne">Príjemka/výdajka bola vymazaná</span><br/>';
			} else {
				$this->chyba .= '<span class="chyba">Nieje vybraná príjemka/výdajka</span><br/>';
			}
		} else {
			$this->chyba .= '<span class="chyba">Nemáte oprávnenie na príjemky/výdajky</span><br/>';
		}
		$this->request->setParameter('akcia', 'prijem_vydaj');
	}
	
	private function spracuj_fakturu() {
		if (isset($this->uzivatel->prava['pv-pisat'])) {
			if (is_numeric($this->request->getParameter('id'))) {
				$id = $this->request->getParameter('id');
			} else {
				$id = FALSE;
			}
			
			if ($this->request->getParameter('dosla')) {
				$dosla = 1;
			} else {
				$dosla = 0;
			}
			
			if ($dosla) {
				if (strlen(trim($this->request->getParameter('cislo_faktury'))) > 0) {
					if (strlen(trim($this->request->getParameter('cislo_faktury'))) <= 15) {
						$cislo_faktury = "'".$this->osetri_vstup($this->request->getParameter('cislo_faktury'))."'";
					} else {
						$cislo_faktury = FALSE;
						$this->chyba .= '<span class="chyba">Príliš dlhé číslo došlej faktúry!</span><br/>';
					}
				} else {
					$cislo_faktury = FALSE;
					$this->chyba .= '<span class="chyba">Nezadali ste číslo došlej faktúry</span><br/>';
				}
			} else { //vygenerovat cislo faktury
				$d = "SELECT cislo_faktury FROM ".TABLE_INV." 
					WHERE dosla = 0 ORDER BY cislo_faktury DESC LIMIT 1";
				db::getInstance()->query($d);
				if (db::getInstance()->getNumRows()) {
					$posl_fakt = db::getInstance()->getRow();
					$rok_fakt = substr($posl_fakt['cislo_faktury'], 0, 4);
					if ($rok_fakt == date("Y")) {
						$cislo_faktury = substr($posl_fakt['cislo_faktury'], 4);
						$cislo_faktury++;
					} else {
						$cislo_faktury = 1;
					}
				} else {
					$cislo_faktury = 1;
				}
				$cislo_faktury = date("Y").substr('10000', strlen($cislo_faktury)-1).$cislo_faktury;
				
				//spracovat cislo uctu
				if (strlen(trim($this->request->getParameter('cislo_uctu'))) > 0) {
					if (strlen(trim($this->request->getParameter('cislo_uctu'))) <= 100) {
						$cislo_uctu = "'".$this->osetri_vstup($this->request->getParameter('cislo_uctu'))."'";
					} else {
						$cislo_uctu = FALSE;
						$this->chyba .= '<span class="chyba">Príliš dlhé číslo účtu!</span><br/>';
					}
				} else {
					$cislo_uctu = FALSE;
					$this->chyba .= '<span class="chyba">Nezadali ste číslo účtu</span><br/>';
				}
				
				if (strlen(trim($this->request->getParameter('banka'))) > 0) {
					if (strlen(trim($this->request->getParameter('banka'))) <= 50) {
						$banka = "'".$this->osetri_vstup($this->request->getParameter('banka'))."'";
					} else {
						$banka = 'NULL';
						$this->chyba .= '<span class="chyba">Príliš dlhý názov banky!</span><br/>';
					}
				} else {
					$banka = 'NULL';
				}
				
				if (strlen(trim($this->request->getParameter('b_ulica'))) > 0) {
					if (strlen(trim($this->request->getParameter('b_ulica'))) <= 50) {
						$b_ulica = "'".$this->osetri_vstup($this->request->getParameter('b_ulica'))."'";
					} else {
						$b_ulica = 'NULL';
						$this->chyba .= '<span class="chyba">Príliš dlhá ulica banky!</span><br/>';
					}
				} else {
					$b_ulica = 'NULL';
				}
				
				if (strlen(trim($this->request->getParameter('b_mesto'))) > 0) {
					if (strlen(trim($this->request->getParameter('b_mesto'))) <= 50) {
						$b_mesto = "'".$this->osetri_vstup($this->request->getParameter('b_mesto'))."'";
					} else {
						$b_mesto = 'NULL';
						$this->chyba .= '<span class="chyba">Príliš dlhé mesto banky!</span><br/>';
					}
				} else {
					$b_mesto = 'NULL';
				}
				
				if (strlen(trim($this->request->getParameter('b_krajina'))) > 0) {
					if (strlen(trim($this->request->getParameter('b_krajina'))) <= 50) {
						$b_krajina = "'".$this->osetri_vstup($this->request->getParameter('b_krajina'))."'";
					} else {
						$b_krajina = 'NULL';
						$this->chyba .= '<span class="chyba">Príliš dlhá krajina banky!</span><br/>';
					}
				} else {
					$b_krajina = 'NULL';
				}
				
				if (strlen(trim($this->request->getParameter('iban'))) > 0) {
					if (strlen(trim($this->request->getParameter('iban'))) <= 50) {
						$iban = "'".$this->osetri_vstup($this->request->getParameter('iban'))."'";
					} else {
						$iban = 'NULL';
						$this->chyba .= '<span class="chyba">Príliš dlhý IBAN!</span><br/>';
					}
				} else {
					$iban = 'NULL';
				}
				
				if (strlen(trim($this->request->getParameter('swift'))) > 0) {
					if (strlen(trim($this->request->getParameter('swift'))) <= 50) {
						$swift = "'".$this->osetri_vstup($this->request->getParameter('swift'))."'";
					} else {
						$swift = 'NULL';
						$this->chyba .= '<span class="chyba">Príliš dlhý SWIFT!</span><br/>';
					}
				} else {
					$swift = 'NULL';
				}
			}
			
			$tovary = array();
			for ($i = 1; $i <= 10; $i++) {
				if (is_numeric($this->request->getParameter('id_sklad_karta'.$i))) {
					$id_sklad_karta = $this->request->getParameter('id_sklad_karta'.$i);
					if (is_numeric($this->request->getParameter('kusy'.$i))) {
						if (is_numeric($this->request->getParameter('jcena'.$i))) {
							$kusy = $this->request->getParameter('kusy'.$i);
							$jcena = $this->request->getParameter('jcena'.$i);
							$tovary[$id_sklad_karta]['kusy'] = $kusy;
							$tovary[$id_sklad_karta]['jcena'] = $jcena;
						} else {
							$this->chyba .= '<span class="chyba">Nezadali ste jednotkovú cenu</span><br/>';
						}
					} else {
						$this->chyba .= '<span class="chyba">Nezadali ste kusy</span><br/>';
					}
				} 
			}
			if (count($tovary)==0) {
				$this->chyba .= '<span class="chyba">Aspoň jeden tovar musí byť vybratý</span><br/>';
			}
			
			if (strlen(trim($this->request->getParameter('ks'))) > 0) {
				if (strlen(trim($this->request->getParameter('ks'))) <= 10) {
					$ks = "'".$this->osetri_vstup($this->request->getParameter('ks'))."'";
				} else {
					$ks = FALSE;
					$this->chyba .= '<span class="chyba">Príliš dlhý konštantný symbol!</span><br/>';
				}
			} else {
				$ks = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste konštantný symbol</span><br/>';
			}
			
			if (strlen(trim($this->request->getParameter('datum_dodania'))) > 0) {
				if (strlen(trim($this->request->getParameter('datum_dodania'))) <= 10) {
					$datum_dodania = explode('.',$this->request->getParameter('datum_dodania'));
					if (is_numeric($datum_dodania[0]) && is_numeric($datum_dodania[1]) && is_numeric($datum_dodania[2])
						&& ($datum_dodania[0] < 32) && ($datum_dodania[1] < 13) && ($datum_dodania[2] < 2100)) {
						$den = ($datum_dodania[0] < 10) ? '0'.$datum_dodania[0] : $datum_dodania[0];
						$mesiac = ($datum_dodania[1] < 10) ? '0'.$datum_dodania[1] : $datum_dodania[1];
						$datum_dodania = "'".$datum_dodania[2].'-'.$mesiac.'-'.$den."'";
					} else {
						$datum_dodania = FALSE;
						$this->chyba .= '<span class="chyba">Dátum dodania je v nesprávnom formáte!</span><br/>';
					}
				} else {
					$datum_dodania = FALSE;
					$this->chyba .= '<span class="chyba">Dátum dodania je príliš dlhý</span><br/>';
				}
			} else {
				$datum_dodania = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste dátum dodania</span><br/>';
			}
			
			if (strlen(trim($this->request->getParameter('datum_vystavenia'))) > 0) {
				if (strlen(trim($this->request->getParameter('datum_vystavenia'))) <= 10) {
					$datum_vystavenia = explode('.',$this->request->getParameter('datum_vystavenia'));
					if (is_numeric($datum_vystavenia[0]) && is_numeric($datum_vystavenia[1]) && is_numeric($datum_vystavenia[2])
						&& ($datum_vystavenia[0] < 32) && ($datum_vystavenia[1] < 13) && ($datum_vystavenia[2] < 2100)) {
						$den = ($datum_vystavenia[0] < 10) ? '0'.$datum_vystavenia[0] : $datum_vystavenia[0];
						$mesiac = ($datum_vystavenia[1] < 10) ? '0'.$datum_vystavenia[1] : $datum_vystavenia[1];
						$datum_vystavenia = "'".$datum_vystavenia[2].'-'.$mesiac.'-'.$den."'";
					} else {
						$datum_vystavenia = FALSE;
						$this->chyba .= '<span class="chyba">Dátum vystavenia je v nesprávnom formáte!</span><br/>';
					}
				} else {
					$datum_vystavenia = FALSE;
					$this->chyba .= '<span class="chyba">Dátum vystavenia je príliš dlhý</span><br/>';
				}
			} else {
				$datum_vystavenia = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste dátum vystavenia</span><br/>';
			}
			
			if (is_numeric($this->request->getParameter('datum_splatnosti'))) {
				$datum_splatnosti = $this->request->getParameter('datum_splatnosti');
			} else {
				$datum_splatnosti = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste dátum splatnosti</span><br/>';
			}
			
			if (strlen(trim($this->request->getParameter('forma_uhrady'))) > 0) {
				if (strlen(trim($this->request->getParameter('forma_uhrady'))) <= 10) {
					$forma_uhrady = "'".$this->osetri_vstup($this->request->getParameter('forma_uhrady'))."'";
				} else {
					$forma_uhrady = FALSE;
					$this->chyba .= '<span class="chyba">Príliš dlh8 forma úhrady!</span><br/>';
				}
			} else {
				$forma_uhrady = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste formu úhrady</span><br/>';
			}
			
			if (strlen(trim($this->request->getParameter('pozn'))) > 0) {
				if (strlen(trim($this->request->getParameter('pozn'))) <= 255) {
					$pozn = "'".$this->osetri_vstup($this->request->getParameter('pozn'))."'";
				} else {
					$pozn = 'NULL';
					$this->chyba .= '<span class="chyba">Príliš dlhá forma úhrady!</span><br/>';
				}
			} else {
				$pozn = 'NULL';
			}
			
			if (is_numeric($this->request->getParameter('vystavil'))) {
				$vystavil = $this->request->getParameter('vystavil');
			} else {
				$vystavil = FALSE;
				$this->chyba .= '<span class="chyba">Nieje vybraný užívateľ, ktorý vystavil faktúru</span><br/>';
			}
			
			if (is_numeric($this->request->getParameter('d_id_kontakt'))) {
				$d_id_kontakt = $this->request->getParameter('d_id_kontakt');
			} else {
				$d_id_kontakt = FALSE;
				$this->chyba .= '<span class="chyba">Nieje vybraný dodávateľ zo zoznamu</span><br/>';
			}
			
			if (strlen(trim($this->request->getParameter('d_meno'))) > 0) {
				if (strlen(trim($this->request->getParameter('d_meno'))) <= 100) {
					$d_meno = "'".$this->osetri_vstup($this->request->getParameter('d_meno'))."'";
				} else {
					$d_meno = FALSE;
					$this->chyba .= '<span class="chyba">Príliš dlhé meno dodávateľa!</span><br/>';
				}
			} else {
				$d_meno = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste meno dodávateľa</span><br/>';
			}

			if (strlen(trim($this->request->getParameter('d_ulica'))) > 0) {
				if (strlen(trim($this->request->getParameter('d_ulica'))) <= 50) {
					$d_ulica = "'".$this->osetri_vstup($this->request->getParameter('d_ulica'))."'";
				} else {
					$d_ulica = FALSE;
					$this->chyba .= '<span class="chyba">Príliš dlhá ulica dodávateľa!</span><br/>';
				}
			} else {
				$d_ulica = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste ulicu dodávateľa</span><br/>';
			}

			if (strlen(trim($this->request->getParameter('d_mesto'))) > 0) {
				if (strlen(trim($this->request->getParameter('d_mesto'))) <= 50) {
					$d_mesto = "'".$this->osetri_vstup($this->request->getParameter('d_mesto'))."'";
				} else {
					$d_mesto = FALSE;
					$this->chyba .= '<span class="chyba">Príliš dlhé mesto dodávateľa!</span><br/>';
				}
			} else {
				$d_mesto = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste mesto dodávateľa</span><br/>';
			}

			if (strlen(trim($this->request->getParameter('d_psc'))) > 0) {
				if (strlen(trim($this->request->getParameter('d_psc'))) <= 10) {
					$d_psc = "'".$this->osetri_vstup($this->request->getParameter('d_psc'))."'";
				} else {
					$d_psc = FALSE;
					$this->chyba .= '<span class="chyba">Príliš dlhé PSČ dodávateľa!</span><br/>';
				}
			} else {
				$d_psc = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste PSČ dodávateľa</span><br/>';
			}
		
			if (strlen(trim($this->request->getParameter('d_stat'))) > 0) {
				if (strlen(trim($this->request->getParameter('d_stat'))) <= 100) {
					$d_stat = "'".$this->osetri_vstup($this->request->getParameter('d_stat'))."'";
				} else {
					$d_stat = FALSE;
					$this->chyba .= '<span class="chyba">Príliš dlhý štát dodávateľa!</span><br/>';
				}
			} else {
				$d_stat = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste štát dodávateľa</span><br/>';
			}
			
			if ($dosla) {
				if (strlen(trim($this->request->getParameter('d_cislo_uctu'))) > 0) {
					if (strlen(trim($this->request->getParameter('d_cislo_uctu'))) <= 100) {
						$cislo_uctu = "'".$this->osetri_vstup($this->request->getParameter('d_cislo_uctu'))."'";
					} else {
						$cislo_uctu = FALSE;
						$this->chyba .= '<span class="chyba">Príliš dlhé číslo účtu dodávateľa!</span><br/>';
					}
				} else {
					$cislo_uctu = FALSE;
					$this->chyba .= '<span class="chyba">Nezadali ste číslo účtu dodávateľa</span><br/>';
				}
				
				if (strlen(trim($this->request->getParameter('d_banka'))) > 0) {
					if (strlen(trim($this->request->getParameter('d_banka'))) <= 50) {
						$banka = "'".$this->osetri_vstup($this->request->getParameter('d_banka'))."'";
					} else {
						$banka = 'NULL';
						$this->chyba .= '<span class="chyba">Príliš dlhý názov banky dodávateľa!</span><br/>';
					}
				} else {
					$banka = 'NULL';
				}
				
				if (strlen(trim($this->request->getParameter('d_b_ulica'))) > 0) {
					if (strlen(trim($this->request->getParameter('d_b_ulica'))) <= 50) {
						$b_ulica = "'".$this->osetri_vstup($this->request->getParameter('d_b_ulica'))."'";
					} else {
						$b_ulica = 'NULL';
						$this->chyba .= '<span class="chyba">Príliš dlhá ulica banky dodávateľa!</span><br/>';
					}
				} else {
					$b_ulica = 'NULL';
				}
				
				if (strlen(trim($this->request->getParameter('d_b_mesto'))) > 0) {
					if (strlen(trim($this->request->getParameter('d_b_mesto'))) <= 50) {
						$b_mesto = "'".$this->osetri_vstup($this->request->getParameter('d_b_mesto'))."'";
					} else {
						$b_mesto = 'NULL';
						$this->chyba .= '<span class="chyba">Príliš dlhé mesto banky dodávateľa!</span><br/>';
					}
				} else {
					$b_mesto = 'NULL';
				}
				
				if (strlen(trim($this->request->getParameter('d_b_krajina'))) > 0) {
					if (strlen(trim($this->request->getParameter('d_b_krajina'))) <= 50) {
						$b_krajina = "'".$this->osetri_vstup($this->request->getParameter('d_b_krajina'))."'";
					} else {
						$b_krajina = 'NULL';
						$this->chyba .= '<span class="chyba">Príliš dlhá krajina banky dodávateľa!</span><br/>';
					}
				} else {
					$b_krajina = 'NULL';
				}
				
				if (strlen(trim($this->request->getParameter('d_iban'))) > 0) {
					if (strlen(trim($this->request->getParameter('d_iban'))) <= 50) {
						$iban = "'".$this->osetri_vstup($this->request->getParameter('d_iban'))."'";
					} else {
						$iban = 'NULL';
						$this->chyba .= '<span class="chyba">Príliš dlhý IBAN dodávateľa!</span><br/>';
					}
				} else {
					$iban = 'NULL';
				}
				
				if (strlen(trim($this->request->getParameter('d_swift'))) > 0) {
					if (strlen(trim($this->request->getParameter('d_swift'))) <= 50) {
						$swift = "'".$this->osetri_vstup($this->request->getParameter('d_swift'))."'";
					} else {
						$swift = 'NULL';
						$this->chyba .= '<span class="chyba">Príliš dlhý SWIFT dodávateľa!</span><br/>';
					}
				} else {
					$swift = 'NULL';
				}
			}
			
			if (count($tovary) && $cislo_faktury && $cislo_uctu && $ks && $datum_dodania && $datum_vystavenia
				&& $datum_splatnosti && $forma_uhrady && $d_id_kontakt && $d_meno && $d_ulica && $d_mesto
				&& $d_psc && $d_stat && $vystavil) {
				if ($id) {
					sklad::uprav_fakturu($id, $dosla, $cislo_faktury, $cislo_uctu, $ks, $datum_dodania, $datum_vystavenia, $datum_splatnosti, $forma_uhrady, $d_id_kontakt, $d_meno, $d_ulica, $d_mesto, $d_psc, $d_stat, $tovary, $banka, $b_ulica, $b_mesto, $b_krajina, $iban, $swift, $vystavil, $pozn);
					$this->chyba .= '<span class="uspesne">Faktúra bola úspešne upravená.</span><br/>';
				} else {
					sklad::vloz_fakturu($dosla, $cislo_faktury, $cislo_uctu, $ks, $datum_dodania, $datum_vystavenia, $datum_splatnosti, $forma_uhrady, $d_id_kontakt, $d_meno, $d_ulica, $d_mesto, $d_psc, $d_stat, $tovary, $banka, $b_ulica, $b_mesto, $b_krajina, $iban, $swift, $vystavil, $pozn);
					$this->chyba .= '<span class="uspesne">Faktúra bola úspešne pridaná.</span><br/>';

				}
				$this->request->setParameter('akcia', 'faktury');
			}
		} else {
			$this->request->setParameter('akcia', 'index');
			$this->spracuj->chyba .= '<span class="chyba">Nemáte oprávnenie na upravovanie faktúr</span><br/>';
		}
	}
	
	private function zmazat_fakturu() {
		if ($this->uzivatel->prava['pv-pisat']) {
			if (is_numeric($this->request->getParameter('id'))) {
				sklad::zmazat_fakturu($this->request->getParameter('id'));
				$this->chyba .= '<span class="uspesne">Faktúra bola vymazaná</span><br/>';
			} else {
				$this->chyba .= '<span class="chyba">Nieje vybraná faktúra</span><br/>';
			}
		} else {
			$this->chyba .= '<span class="chyba">Nemáte oprávnenie na zmazanie faktúry</span><br/>';
		}
		$this->request->setParameter('akcia', 'faktury');
	}
	
	private function spracuj_ucet() {
		if ($this->uzivatel->prava['ucty-pisat']) {
			if (is_numeric($this->request->getParameter('id'))) {
				$id = $this->request->getParameter('id');
			} else {
			 	$id = FALSE;
			}
			 
			if (is_numeric($this->request->getParameter('kontakt'))) {
				$kontakt = $this->request->getParameter('kontakt');
			} else {
			 	$kontakt = FALSE;
			 	$this->chyba .= '<span class="chyba">Nevybrali ste kontakt</span><br/>';
			}
			 
			if (strlen(trim($this->request->getParameter('cislo_uctu'))) > 0) {
				if (strlen(trim($this->request->getParameter('cislo_uctu'))) <= 50) {
					$cislo_uctu = "'".$this->osetri_vstup($this->request->getParameter('cislo_uctu'))."'";
				} else {
					$cislo_uctu = FALSE;
					$this->chyba .= '<span class="chyba">Príliš dlhé číslo účtu</span><br/>';
				}
			} else {
				$cislo_uctu = FALSE;
				$this->chyba .= '<span class="chyba">Nezadali ste číslo účtu</span><br/>';
			}

			if (strlen(trim($this->request->getParameter('banka'))) > 0) {
				if (strlen(trim($this->request->getParameter('banka'))) <= 50) {
					$banka = "'".$this->osetri_vstup($this->request->getParameter('banka'))."'";
				} else {
					$banka = 'NULL';
					$this->chyba .= '<span class="chyba">Príliš dlhý názov banky!</span><br/>';
				}
			} else {
				$banka = 'NULL';
			}

			if (strlen(trim($this->request->getParameter('ulica'))) > 0) {
				if (strlen(trim($this->request->getParameter('ulica'))) <= 50) {
					$ulica = "'".$this->osetri_vstup($this->request->getParameter('ulica'))."'";
				} else {
					$ulica = 'NULL';
					$this->chyba .= '<span class="chyba">Príliš dlhá ulica!</span><br/>';
				}
			} else {
				$ulica = 'NULL';
			}

			if (strlen(trim($this->request->getParameter('mesto'))) > 0) {
				if (strlen(trim($this->request->getParameter('mesto'))) <= 50) {
					$mesto = "'".$this->osetri_vstup($this->request->getParameter('mesto'))."'";
				} else {
					$mesto = 'NULL';
					$this->chyba .= '<span class="chyba">Príliš dlhé mesto!</span><br/>';
				}
			} else {
				$mesto = 'NULL';
			}
			
			if (strlen(trim($this->request->getParameter('krajina'))) > 0) {
				if (strlen(trim($this->request->getParameter('krajina'))) <= 50) {
					$krajina = "'".$this->osetri_vstup($this->request->getParameter('krajina'))."'";
				} else {
					$krajina = 'NULL';
					$this->chyba .= '<span class="chyba">Príliš dlhá krajina!</span><br/>';
				}
			} else {
				$krajina = 'NULL';
			}
			
			if (strlen(trim($this->request->getParameter('iban'))) > 0) {
				if (strlen(trim($this->request->getParameter('iban'))) <= 50) {
					$iban = "'".$this->osetri_vstup($this->request->getParameter('iban'))."'";
				} else {
					$iban = 'NULL';
					$this->chyba .= '<span class="chyba">Príliš dlhý IBAN!</span><br/>';
				}
			} else {
				$iban = 'NULL';
			}
			
			if (strlen(trim($this->request->getParameter('swift'))) > 0) {
				if (strlen(trim($this->request->getParameter('swift'))) <= 50) {
					$swift = "'".$this->osetri_vstup($this->request->getParameter('swift'))."'";
				} else {
					$swift = 'NULL';
					$this->chyba .= '<span class="chyba">Príliš dlhý SWIFT!</span><br/>';
				}
			} else {
				$swift = 'NULL';
			}
			
			if ($kontakt && $cislo_uctu) {
				if ($id) {
					bankove_ucty::uprav_ucet($id, $kontakt, $cislo_uctu, $banka, $ulica, $mesto, $krajina, $iban, $swift);
					$this->chyba .= '<span class="uspesne">Účet bol úspešne upravený.</span><br/>';
				} else {
					bankove_ucty::vloz_ucet($kontakt, $cislo_uctu, $banka, $ulica, $mesto, $krajina, $iban, $swift);
					$this->chyba .= '<span class="uspesne">Účet bol úspešne pridaný.</span><br/>';
				}
				$this->request->setParameter('akcia', 'bankove_ucty');
			}
		} else {
			$this->request->setParameter('akcia', 'index');
			$this->spracuj->chyba .= '<span class="chyba">Nemáte oprávnenie na upravovanie bankových účtov</span><br/>';
		}
	}
	
	private function zmazat_ucet() {
		if ($this->uzivatel->prava['ucty-pisat']) {
			if (is_numeric($this->request->getParameter('id'))) {
				bankove_ucty::zmazat_ucet($this->request->getParameter('id'));
				$this->chyba .= '<span class="uspesne">Bankový účet bol vymazaný</span><br/>';
			} else {
				$this->chyba .= '<span class="chyba">Nieje vybraný účet</span><br/>';
			}
		} else {
			$this->chyba .= '<span class="chyba">Nemáte oprávnenie na zmazanie účtu</span><br/>';
		}
		$this->request->setParameter('akcia', 'bankove_ucty');
	}
}

?>