using System;
using System.Data;
using System.Data.Linq;
using System.Linq;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class registration : System.Web.UI.Page
{

    private NorthwindDataContext db = new NorthwindDataContext();
    private Table<photo> fotky = null;

    protected void Page_Load(object sender, EventArgs e) {
        fotky = db.GetTable<photo>();

    }

    protected void zaregistruj(object sender, EventArgs e)
    {
        MembershipCreateStatus newStatus;
        string error = "";
        string save_location;
        try
        {
            //try register new user
            MembershipUser newUser = Membership.CreateUser(reg_name_input.Text,
                reg_password_input.Text, reg_email_input.Text,
                reg_question_input.Text, reg_answer_input.Text,
                true, out newStatus);
            if (newUser == null)
            {
                error = getStatusMessage(newStatus);
            }
            else
            {
                reg_status.Text = "registracia uspesna :)";
            }
            //try upload file
            if ((FileUpload1.PostedFile != null) && (FileUpload1.PostedFile.ContentLength > 0))
            {
                photo nova_fotka = new photo();
                nova_fotka.name = System.IO.Path.GetFileNameWithoutExtension(FileUpload1.PostedFile.FileName);
                nova_fotka.type = System.IO.Path.GetExtension(FileUpload1.PostedFile.FileName);
                nova_fotka.user_name = newUser.UserName;
                nova_fotka.path = @"~/data/" 
                    + System.IO.Path.GetFileName(FileUpload1.PostedFile.FileName);
                this.fotky.InsertOnSubmit(nova_fotka);
                this.db.SubmitChanges();
                //zmen rozmery obrazka
                save_location = Server.MapPath(@"~/data/")
                    + System.IO.Path.GetFileName(FileUpload1.PostedFile.FileName); 
                FileUpload1.PostedFile.SaveAs(save_location);
                reg_status.Text += "\nFOTO UPLOADED!";
            }
            else
            {
                //please select file to upload !
            }
            //string redirect = Server.MapPath("main") + "\\main.aspx";
            Response.Redirect(@"~/main/main.aspx", false);

        }
        catch (MembershipCreateUserException err)
        {
            error = err.Message.ToString();
        }
        catch (HttpException err)
        {
            error = err.Message.ToString();
        }
        catch (Exception err)
        {
            error = err.Message.ToString();
        }
        finally
        {
            if (error != null)
            {
                //reg_status.Text += "\n" + error;
            }
            
        }
    }

    private string getStatusMessage(MembershipCreateStatus status)
    {
        switch (status)
        {
            case MembershipCreateStatus.DuplicateUserName:
                return "rovnake mena";
            case MembershipCreateStatus.DuplicateEmail:
                return "rovnaky email";
            case MembershipCreateStatus.InvalidPassword:
                return "zle heslo";
            case MembershipCreateStatus.InvalidEmail:
                return "zly email";
            case MembershipCreateStatus.InvalidAnswer:
                return "neplatna otazka pre obnovenie hesla";
            case MembershipCreateStatus.InvalidQuestion:
                return "zle odpoved na pomocnu otazku";
            case MembershipCreateStatus.InvalidUserName:
                return "zle uzivatelske meno";
            case MembershipCreateStatus.ProviderError:
                return "chyba pri vytvarani uctu, kontaktuj admina";
            case MembershipCreateStatus.UserRejected:
                return "chyba pri vytvarani uctu, kontaktuj admina 2";
            default:
                return "daka ina chyba pri registracii";
        }
    }
}
