using System;
using System.Data;
using System.Data.Linq;
using System.Data.SqlClient;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Linq;

public partial class main_clanky : System.Web.UI.Page {

    private NorthwindDataContext db = new NorthwindDataContext();
    private Table<article> clanky = null;
    private Table<CategoryArticleRelation> kat_clanky_relacie = null;
    private Table<category> kategorie = null;
    private Table<aspnet_User> uzivatelia = null;

    protected void Page_Init(object sender, EventArgs e) {
        //adding CSS style file
        HtmlLink newCSS = new HtmlLink();
        newCSS.Href = "~/css/clanky_style.css";
        newCSS.Attributes.Add("type", "text/css");
        newCSS.Attributes.Add("rel", "Stylesheet");
        Page.Header.Controls.Add(newCSS);
        //add tables 
        this.clanky = db.GetTable<article>();
        this.kategorie = db.GetTable<category>();
        this.kat_clanky_relacie = db.GetTable<CategoryArticleRelation>();
        this.uzivatelia = db.GetTable<aspnet_User>();
    }

    protected void Page_Load(object sender, EventArgs e) {
        if (!Page.IsPostBack) {
            
            //vypln clanky
            var out_list =
                from c in this.clanky
                let link = "~/main/clanok.aspx?id=" + c.article_id
                select new { link = link, title = c.title, text = c.text };
            clanky_list.DataSource = out_list;
            clanky_list.DataBind();
            
            // kategorie_select
            var out_kat =
                from c in this.kategorie
                from kc in this.kat_clanky_relacie
                where c.category_id == kc.category_id
                select c.title;
            category_select.DataSource = out_kat;
            category_select.DataBind();
            category_select.Items.Add("vetky");
            category_select.SelectedValue = "vetky";
            
            // user_select
            var out_clanky =
                from c in this.clanky
                select c.user_name;
            user_select.DataSource = out_clanky;
            user_select.DataBind();
            user_select.Items.Add("vetci");
            user_select.SelectedValue = "vetci";
        }
    }

    private void applyArticleFilter() {
        IEnumerable<article> clanky_out_pom = this.clanky.AsEnumerable<article>();
        IEnumerable<article> clanky_out;
        string category_selected = category_select.SelectedValue;
        string user_selected = user_select.SelectedValue;
        if (category_selected != "vetky") {
            clanky_out =
                from kat in this.kategorie
                where kat.title == category_selected
                from rel in this.kat_clanky_relacie
                where rel.category_id == kat.category_id
                from cl in clanky_out_pom
                where cl.article_id == rel.article_id
                select cl;
            clanky_out_pom = clanky_out.ToList<article>();
        }
        if (user_selected != "vetci") {
            clanky_out =
                from c in clanky_out_pom
                where c.user_name == user_selected
                select c;
            clanky_out_pom = null;
            clanky_out_pom = clanky_out.ToList<article>();
        }
        var clanky_out_link =
            from c in clanky_out_pom
            let link = "~/main/clanok.aspx?id=" + c.article_id
            select new { link = link, title = c.title, text = c.text };
        clanky_list.DataSource = clanky_out_link;
        clanky_list.DataBind();
    }

    protected void category_select_SelectedIndexChanged(object sender, EventArgs e) {
        applyArticleFilter();
    }
    
    protected void user_select_SelectedIndexChanged(object sender, EventArgs e) {
       applyArticleFilter();
    }

}
