<?php
/**
 * @author Ivan
 */
class Engine extends Controller
{

    public function show_list()
    {
        $tpl['selected'] = $brand_id = filter_input( INPUT_POST, 'brand', FILTER_SANITIZE_NUMBER_INT);
        $tpl['brands'] = Models\Brand::all();
        $tpl['show_list'] = $this->loop_url_back_to_controller(__FUNCTION__);

        $contents = array(
            load_viewer( 'engine/engine_main.tpl.php', $tpl ),
            'Pomocka'
        );

        $selecting_form = LayoutHelpers\get_contents_tab( 'brand_form', array('Content', 'Help'), $contents, 'Výber značky' );

        $adding_form = $this->get_adding_form( $brand_id );

        $tpl['link_delete'] = has_user_rights_for( $this->user, __CLASS__, 'delete_engine' ) ? $this->loop_url_back_to_controller( 'delete_engine', 'engine_id=' ) : '';

        $tpl['engines'] = Models\Engine::find_all_by_brand_id( $brand_id );
        $list = intval($brand_id) ? load_viewer('engine/engine_list.tpl.php', $tpl) : '';

        return $selecting_form . $adding_form . $list;
    }

    private function get_adding_form( $brand_id )
    {
        if ( has_user_rights_for( $this->user, __CLASS__, 'add_engine' ) && intval( $brand_id ) ) {

            $tpl['link_add'] = has_user_rights_for( $this->user, __CLASS__, 'add_engine' ) ? $this->loop_url_back_to_controller( 'add_engine' ) : '';
            $tpl['brand_id'] = $brand_id;

            $contents = array(
                load_viewer( 'engine/engine_form.tpl.php', $tpl ),
                'Pomocka'
            );

            $result = LayoutHelpers\get_contents_tab( 'engine_form', array('Content', 'Help'), $contents, 'Vkladanie nového motora pre príslušnú značku' );

        }

        return $result ?: '';
    }

    public function add_engine()
    {
        $brand_id = filter_input( INPUT_POST, 'brand_id',  FILTER_SANITIZE_NUMBER_INT);
        $engine   = filter_input( INPUT_POST, 'engine', FILTER_SANITIZE_STRING);

        try {

            $engines = Models\Engine::find_all_by_name( $engine );

            if ( ! empty( $engines ) ) {

                return LayoutHelpers\get_notification_error( 'Pridávaný typ motora už existuje. Nieje možné pridávať duplicitné záznamy !' ) . $this->show_list();

            }

        } catch (Exception $e) {
            SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
            throw $e;
        }

        try {

            Models\Engine::create( array( 'brand_id' => $brand_id, 'name' => $engine ) );

        } catch (Exception $e) {
            SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
            throw $e;
        }

        $output = LayoutHelpers\get_notification_succes('Nový typ motora úspešne zaregistrovaný');

        $output .= LayoutHelpers\get_anchor( $this->loop_url_back_to_controller( 'show_list' ), 'Späť na výpis správu motorov', 'spat na vypis', true);

        return $output;

    }

    public function delete_engine()
    {
        $engine_id = filter_input( INPUT_GET, 'engine_id', FILTER_SANITIZE_NUMBER_INT);

        try {

            $engine = Models\Engine::find( $engine_id );
            $engine->delete();

        } catch (Exception $e) {
            SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
            throw $e;
        }

        $this->redirect_loop_back( 'show_list' );
    }


}

?>
