<?php
/**
 * @author Ivan
 */
class Subcategory extends Controller
{

    public function show_list( $category_input = null )
    {
        $tpl['selected'] = $category_id = $category_input ?: filter_input( INPUT_POST, 'category', FILTER_SANITIZE_NUMBER_INT);
        $tpl['categorys'] = Models\Category::all();
        $tpl['show_list'] = $this->loop_url_back_to_controller(__FUNCTION__);

        $contents = array(
            load_viewer( 'subcategorys/subcategory_main.tpl.php', $tpl ),
            'Pomocka'
        );

        $selecting_form = LayoutHelpers\get_contents_tab( 'category_form', array('Content', 'Help'), $contents, 'Výber kategórie' );

        $adding_form = $this->get_adding_form( $category_id );

        $tpl['link_delete'] = has_user_rights_for( $this->user, __CLASS__, 'delete_subcategory' ) ? $this->loop_url_back_to_controller( 'delete_subcategory', 'subcategory_id=' ) : '';

        $tpl['subcategorys'] = Models\Subcategory::find_all_by_category_id( $category_id );

        $list = intval($category_id) ? load_viewer('subcategorys/subcategory_list.tpl.php', $tpl) : '';

        return $selecting_form . $adding_form . $list;
    }

    private function get_adding_form( $category_id )
    {
        if ( has_user_rights_for( $this->user, __CLASS__, 'add_subcategory' ) && intval( $category_id ) ) {

            $tpl['link_add'] = $this->loop_url_back_to_controller( 'add_subcategory' );
            $tpl['category_id']  = $category_id;

            $contents = array(
                load_viewer( 'subcategorys/subcategory_form.tpl.php', $tpl ),
                'Pomocka'
            );

            $result = LayoutHelpers\get_contents_tab( 'subcategory_form', array('Content', 'Help'), $contents, 'Zaregistrovanie novej podkategórie' );

        }

        return $result ?: '';
    }

    public function add_subcategory()
    {
        $category_id = filter_input( INPUT_POST, 'category_id',  FILTER_SANITIZE_NUMBER_INT);
        $subcategory   = filter_input( INPUT_POST, 'subcategory', FILTER_SANITIZE_STRING);

        try {

            $subcategorys = Models\Subcategory::find_all_by_name_and_category_id( $subcategory, $category_id );

            if ( ! empty( $subcategorys ) ) {

                return LayoutHelpers\get_notification_error( 'Pridávaná podkategória už existuje. Nieje možné pridávať duplicitné záznamy !' ) . $this->show_list();

            }

        } catch (Exception $e) {
            SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
            throw $e;
        }

        try {

            Models\Subcategory::create( array( 'category_id' => $category_id, 'name' => $subcategory ) );

        } catch (Exception $e) {
            SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
            throw $e;
        }

        $output = LayoutHelpers\get_notification_succes('Nová podkategória úspešne zaregistrovaná');

      //  $output .= LayoutHelpers\get_anchor( $this->loop_url_back_to_controller( 'show_list' ), 'Späť na výpis správy typov', 'spat na vypis', true);

        return $output . $this->show_list( $category_id );

    }

    public function delete_subcategory()
    {
        $subcategory_id = filter_input( INPUT_GET, 'subcategory_id', FILTER_SANITIZE_NUMBER_INT);

        try {

            $subcategory = Models\Subcategory::find( $subcategory_id );
            $subcategory->delete();

        } catch (Exception $e) {
            SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
            throw $e;
        }

        $this->redirect_loop_back( 'show_list' );
    }


}

?>
