<?php
/**
 * @author Ivan
 */
class Type extends Controller
{

    public function show_list()
    {
        $tpl['selected'] = $brand_id = filter_input( INPUT_POST, 'brand', FILTER_SANITIZE_NUMBER_INT);
        $tpl['brands'] = Models\Brand::all();
        $tpl['show_list'] = $this->loop_url_back_to_controller(__FUNCTION__);

        $contents = array(
            load_viewer( 'types/type_main.tpl.php', $tpl ),
            'Pomocka'
        );

        $selecting_form = LayoutHelpers\get_contents_tab( 'brand_form', array('Content', 'Help'), $contents, 'Výber značky' );

        $adding_form = $this->get_adding_form( $brand_id );

        $tpl['link_delete'] = has_user_rights_for( $this->user, __CLASS__, 'delete_type' ) ? $this->loop_url_back_to_controller( 'delete_type', 'type_id=' ) : '';

        $tpl['types'] = Models\Type::find_all_by_brand_id( $brand_id );
        $list = intval($brand_id) ? load_viewer('types/type_list.tpl.php', $tpl) : '';

        return $selecting_form . $adding_form . $list;
    }

    private function get_adding_form( $brand_id )
    {
        if ( has_user_rights_for( $this->user, __CLASS__, 'add_type' ) && intval( $brand_id ) ) {

            $tpl['link_add'] = $this->loop_url_back_to_controller( 'add_type' );
            $tpl['brand_id']  = $brand_id;

            $contents = array(
                load_viewer( 'types/type_form.tpl.php', $tpl ),
                'Pomocka'
            );

            $result = LayoutHelpers\get_contents_tab( 'type_form', array('Content', 'Help'), $contents, 'Vkladanie nového motora pre príslušnú značku' );

        }

        return $result ?: '';
    }

    public function add_type()
    {
        $brand_id = filter_input( INPUT_POST, 'brand_id',  FILTER_SANITIZE_NUMBER_INT);
        $type   = filter_input( INPUT_POST, 'type', FILTER_SANITIZE_STRING);

        try {

            $types = Models\Type::find_all_by_name( $type );

            if ( ! empty( $types ) ) {

                return LayoutHelpers\get_notification_error( 'Pridávaný typ už existuje. Nieje možné pridávať duplicitné záznamy !' ) . $this->show_list();

            }

        } catch (Exception $e) {
            SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
            throw $e;
        }

        try {

            Models\Type::create( array( 'brand_id' => $brand_id, 'name' => $type ) );

        } catch (Exception $e) {
            SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
            throw $e;
        }

        $output = LayoutHelpers\get_notification_succes('Nový typ úspešne zaregistrovaný');

        $output .= LayoutHelpers\get_anchor( $this->loop_url_back_to_controller( 'show_list' ), 'Späť na výpis správy typov', 'spat na vypis', true);

        return $output;

    }

    public function delete_type()
    {
        $type_id = filter_input( INPUT_GET, 'type_id', FILTER_SANITIZE_NUMBER_INT);

        try {

            $type = Models\Type::find( $type_id );
            $type->delete();

        } catch (Exception $e) {
            SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
            throw $e;
        }

        $this->redirect_loop_back( 'show_list' );
    }


}

?>
