<?php
/**
 * @author Ivan
 */
class Brand extends Controller
{

    public function show_list()
    {
        $tpl['link_add'] = $this->loop_url_back_to_controller( 'add_brand' );
        $tpl['link_delete'] = has_user_rights_for( $this->user, __CLASS__, 'delete_brand' ) ? $this->loop_url_back_to_controller( 'delete_brand', 'brand_id=' ) : '';

        $contents = array(
            load_viewer( 'brand/brand_form.tpl.php', $tpl ),
            'no content'
        );

        $adding_form = LayoutHelpers\get_contents_tab( 'brand_form', array('Content', 'Help'), $contents, 'Zaregistrovanie novej značky' );

        $tpl['brands'] = Models\Brand::all();

        return $adding_form . load_viewer('brand/brand_list.tpl.php', $tpl);
    }

    public function add_brand()
    {
        $brand_name = filter_input(INPUT_POST, 'brand_name', FILTER_SANITIZE_STRING);

        try {

            $brands = Models\Brand::find_all_by_name( $brand_name );

            if ( ! empty( $brands ) ) {

                return LayoutHelpers\get_notification_error( 'Pridávaná značka už existuje. Nieje možné pridávať duplicitné záznamy !' ) . $this->show_list();

            }

        } catch (Exception $e) {
            SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
            throw $e;
        }
        

        try {

            Models\Brand::create( array( 'name' => $brand_name ) );

        } catch (Exception $e) {
            SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
            throw $e;
        }

        $output = LayoutHelpers\get_notification_succes('Nová značka úspešne zaregistrovaná');

        $output .= LayoutHelpers\get_anchor( $this->loop_url_back_to_controller( 'show_list' ), 'Späť na výpis značiek', 'spat na vypis', true);

        return $output;

    }

    public function delete_brand()
    {
        $brand_id = filter_input( INPUT_GET, 'brand_id', FILTER_SANITIZE_NUMBER_INT);

        try {

            $brand = Models\Brand::find( $brand_id );
            $brand->delete();

        } catch (Exception $e) {
            SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
            throw $e;
        }
        
        $this->redirect_loop_back( 'show_list' );
    }

}

?>
