<?php
/**
 * @author Ivan
 */
class Category extends Controller
{

    public function show_list()
    {
        $tpl['link_add'] = $this->loop_url_back_to_controller( 'add_category' );
        $tpl['link_delete'] = has_user_rights_for( $this->user, __CLASS__, 'delete_category' ) ? $this->loop_url_back_to_controller( 'delete_category', 'category_id=' ) : '';
        $tpl['link_edit']   = has_user_rights_for( $this->user, __CLASS__, 'edit_category' )   ? $this->loop_url_back_to_controller( 'edit_category'  , 'category_id=' ) : '';

        $contents = array(
            load_viewer( 'category/category_form.tpl.php', $tpl ),
            'no content'
        );

        $adding_form = LayoutHelpers\get_contents_tab( 'category_form', array('Content', 'Help'), $contents, 'Zaregistrovanie novej kategórie' );

        $tpl['categorys'] = Models\Category::all();

        return $adding_form . load_viewer('category/category_list.tpl.php', $tpl);
    }

    public function add_category()
    {
        $category_name = filter_input(INPUT_POST, 'category_name', FILTER_SANITIZE_STRING);

        try {

            $categorys = Models\Category::find_all_by_name( $category_name );

            if ( ! empty( $categorys ) ) {

                return LayoutHelpers\get_notification_error( 'Pridávaná kategória už existuje. Nieje možné pridávať duplicitné záznamy !' ) . $this->show_list();

            }

        } catch (Exception $e) {
            SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
            throw $e;
        }
        

        try {

            Models\Category::create( array( 'name' => $category_name ) );

        } catch (Exception $e) {
            SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
            throw $e;
        }

        $output = LayoutHelpers\get_notification_succes('Nová kategória úspešne zaregistrovaná');

//        $output .= LayoutHelpers\get_anchor( $this->loop_url_back_to_controller( 'show_list' ), 'Späť na pridávanie kategórií', 'spat na vypis', true);

        return $output . $this->show_list();

    }

    public function edit_category()
    {
        $category_id = filter_input( INPUT_GET, 'category_id', FILTER_SANITIZE_NUMBER_INT);

        try {

            $category = Models\Category::find( $category_id );

        } catch (Exception $e) {
            SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
            throw $e;
        }

        if ( isset( $_POST['save_category'] ) && $_POST['save_category'] == 1 ) {

            $category->name = filter_input( INPUT_POST, 'category_name', FILTER_SANITIZE_STRING);

            try {

                $category->save();
                
            } catch (Exception $e) {
                SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
                throw $e;
            }

            $this->redirect_loop_back( 'show_list' );
            exit();
        }

        $tpl['category'] = $category;
        
        $contents = array(
            load_viewer('category/category_edit.tpl.php', $tpl),
            'no content'
        );

        $output = LayoutHelpers\get_contents_tab( 'category_form', array('Content', 'Help'), $contents, 'Zmena názvu kategórie' );

        return $output;

    }

    public function delete_category()
    {
        $category_id = filter_input( INPUT_GET, 'category_id', FILTER_SANITIZE_NUMBER_INT);

        try {

            $category = Models\Category::find( $category_id );

            if ( is_object( $category->subcategories[0] ) ) {

                foreach ( $category->subcategories as $subcategory ) {

                    if ( is_object($subcategory->parts[0]) ) {

                        foreach ( $subcategory->parts as $part ) {

                            $part->delete();

                        }

                    }

                    $subcategory->delete();

                }

            }

            $category->delete();

        } catch (Exception $e) {
            SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
            throw $e;
        }
        
        $this->redirect_loop_back( 'show_list' );
    }

}

?>
