<?php
/**
 * @author Ivan
 */
class Owner extends Controller
{

    public function show_list()
    {
        $tpl['link_add'] = $this->loop_url_back_to_controller( 'add_owner' );
        $tpl['link_delete'] = has_user_rights_for( $this->user, __CLASS__, 'delete_owner' ) ? $this->loop_url_back_to_controller( 'delete_owner', 'owner_id=' ) : '';

        $contents = array(
            load_viewer( 'owner/owner_form.tpl.php', $tpl ),
            'no content'
        );

        $adding_form = LayoutHelpers\get_contents_tab( 'owner_form', array('Content', 'Help'), $contents, 'Zaregistrovanie novej spoločnosti / majiteľa' );

        $tpl['owners'] = Models\Owner::all();

        return $adding_form . load_viewer('owner/owner_list.tpl.php', $tpl);
    }

    public function add_owner()
    {
        $owner_name = filter_input(INPUT_POST, 'owner_name', FILTER_SANITIZE_STRING);

        try {

            $owners = Models\Owner::find_all_by_name( $owner_name );

            if ( ! empty( $owners ) ) {

                return LayoutHelpers\get_notification_error( 'Pridávaný záznam už existuje. Nieje možné pridávať duplicitné záznamy !' ) . $this->show_list();

            }

        } catch (Exception $e) {
            SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
            throw $e;
        }
        

        try {

            Models\Owner::create( array( 'name' => $owner_name ) );

        } catch (Exception $e) {
            SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
            throw $e;
        }

        $output = LayoutHelpers\get_notification_succes('Nový majiteľ / spoločnosť úspešne zaregistrovaná');

        $output .= LayoutHelpers\get_anchor( $this->loop_url_back_to_controller( 'show_list' ), 'Späť na výpis značiek', 'spat na vypis', true);

        return $output;

    }

    public function delete_owner()
    {
        $owner_id = filter_input( INPUT_GET, 'owner_id', FILTER_SANITIZE_NUMBER_INT);

        try {

            $owner = Models\Owner::find( $owner_id );
            $owner->delete();

        } catch (Exception $e) {
            SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
            throw $e;
        }
        
        $this->redirect_loop_back( 'show_list' );
    }

}

?>
