<?php
/**
 * @author Ivan
 */
class Register extends Controller
{

    public function show_list()
    {
        try {

            $tpl['brands'] = Models\Brand::all();
            $tpl['owners'] = Models\Owner::all();
            
        } catch (Exception $e) {
            SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
            throw $e;
        }

        $tpl['link_add']    = $this->loop_url_back_to_controller( 'add_record'      );
        $tpl['link_type']   = $this->loop_url_back_to_controller( 'get_types'       );
        $tpl['link_engine'] = $this->loop_url_back_to_controller( 'get_engines'     );
        $tpl['link_combos'] = $this->loop_url_back_to_controller( 'get_combos_data' );

        $contents = array(
            load_viewer( 'register/add_record.tpl.php', $tpl ),
            'Pomocka'
        );

        return LayoutHelpers\get_contents_tab( 'adding_form', array('Content', 'Help'), $contents, 'Pridanie nového záznamu' );

    }

    public function get_combos_data()
    {
        $brand_id = filter_input( INPUT_POST, 'brand_id', FILTER_SANITIZE_NUMBER_INT);

        $tpl['content'] = Models\Engine::find_all_by_brand_id( $brand_id );
        $engines =  load_viewer( 'register/option.tpl.php', $tpl);

        $tpl['content'] = Models\Type::find_all_by_brand_id( $brand_id );
        $types =  load_viewer( 'register/option.tpl.php', $tpl);

        $content = array( 'engines' => $engines,
                          'types'   => $types );

        echo json_encode( $content );
        exit();
    }

    public function add_record()
    {
        $params = array(
            'brand_id'  => filter_input( INPUT_POST, 'brand',   FILTER_SANITIZE_NUMBER_INT),
            'type_id'   => filter_input( INPUT_POST, 'type',    FILTER_SANITIZE_NUMBER_INT),
            'engine_id' => filter_input( INPUT_POST, 'engine',  FILTER_SANITIZE_NUMBER_INT),
            'owner_id'  => filter_input( INPUT_POST, 'owner',   FILTER_SANITIZE_NUMBER_INT),
            'spz'       => filter_input( INPUT_POST, 'spz',     FILTER_SANITIZE_STRING),
            'note'      => filter_input( INPUT_POST, 'note',    FILTER_SANITIZE_STRING),
            'vin'       => filter_input( INPUT_POST, 'vin',     FILTER_SANITIZE_STRING)
        );

        try {

            Models\Register::create( $params );

        } catch (Exception $e) {
            SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
            throw $e;
        }

        return LayoutHelpers\get_notification_succes( 'Záznam úspešne pridaný' ) . $this->show_list();

    }
    
}

?>
