/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

CREATE SEQUENCE "comments_id_seq"  START WITH 1 ;

CREATE TABLE  "comments" (
   "id" integer DEFAULT nextval('"comments_id_seq"') NOT NULL,
   "author"   int NOT NULL, 
   "time"   timestamp without time zone NOT NULL, 
   "text"   varchar(1000) NOT NULL, 
   "placemark"   int NOT NULL, 
   primary key ("id")
)     ;
CREATE INDEX "comments_1_idx" ON "comments" USING btree ("author", "placemark");
CREATE INDEX "comments_placemark_idx" ON "comments" USING btree ("placemark");

CREATE SEQUENCE "country_enumerator_id_seq"  START WITH 194 ;

CREATE TABLE  "country_enumerator" (
   "id" integer DEFAULT nextval('"country_enumerator_id_seq"') NOT NULL,
   "name"   varchar(255) NOT NULL, 
   primary key ("id")
)      ;

INSERT INTO "country_enumerator" ("id", "name") VALUES  
(1, 'Afghanistan'),
(2, 'Albania'),
(3, 'Algeria'),
(4, 'Andorra'),
(5, 'Angola'),
(6, 'Antigua and Barbuda'),
(7, 'Argentina'),
(8, 'Armenia'),
(9, 'Australia'),
(10, 'Austria'),
(11, 'Azerbaijan'),
(12, 'Bahamas'),
(13, 'Bahrain'),
(14, 'Bangladesh'),
(15, 'Barbados'),
(16, 'Belarus'),
(17, 'Belgium'),
(18, 'Belize'),
(19, 'Benin'),
(20, 'Bhutan'),
(21, 'Bolivia'),
(22, 'Bosnia and Herzegovina'),
(23, 'Botswana'),
(24, 'Brazil'),
(25, 'Brunei'),
(26, 'Bulgaria'),
(27, 'Burkina Faso'),
(28, 'Burundi'),
(29, 'Cambodia'),
(30, 'Cameroon'),
(31, 'Canada'),
(32, 'Cape Verde'),
(33, 'Central African Republic'),
(34, 'Chad'),
(35, 'Chile'),
(36, 'China'),
(37, 'Colombi'),
(38, 'Comoros'),
(39, 'Congo (Brazzaville)'),
(40, 'Congo'),
(41, 'Costa Rica'),
(42, 'Cote d''Ivoire'),
(43, 'Croatia'),
(44, 'Cuba'),
(45, 'Cyprus'),
(46, 'Czech Republic'),
(47, 'Denmark'),
(48, 'Djibouti'),
(49, 'Dominica'),
(50, 'Dominican Republic'),
(51, 'East Timor (Timor Timur)'),
(52, 'Ecuador'),
(53, 'Egypt'),
(54, 'El Salvador'),
(55, 'Equatorial Guinea'),
(56, 'Eritrea'),
(57, 'Estonia'),
(58, 'Ethiopia'),
(59, 'Fiji'),
(60, 'Finland'),
(61, 'France'),
(62, 'Gabon'),
(63, 'Gambia, The'),
(64, 'Georgia'),
(65, 'Germany'),
(66, 'Ghana'),
(67, 'Greece'),
(68, 'Grenada'),
(69, 'Guatemala'),
(70, 'Guinea'),
(71, 'Guinea-Bissau'),
(72, 'Guyana'),
(73, 'Haiti'),
(74, 'Honduras'),
(75, 'Hungary'),
(76, 'Iceland'),
(77, 'India'),
(78, 'Indonesia'),
(79, 'Iran'),
(80, 'Iraq'),
(81, 'Ireland'),
(82, 'Israel'),
(83, 'Italy'),
(84, 'Jamaica'),
(85, 'Japan'),
(86, 'Jordan'),
(87, 'Kazakhstan'),
(88, 'Kenya'),
(89, 'Kiribati'),
(90, 'Korea, North'),
(91, 'Korea, South'),
(92, 'Kuwait'),
(93, 'Kyrgyzstan'),
(94, 'Laos'),
(95, 'Latvia'),
(96, 'Lebanon'),
(97, 'Lesotho'),
(98, 'Liberia'),
(99, 'Libya'),
(100, 'Liechtenstein'),
(101, 'Lithuania'),
(102, 'Luxembourg'),
(103, 'Macedonia'),
(104, 'Madagascar'),
(105, 'Malawi'),
(106, 'Malaysia'),
(107, 'Maldives'),
(108, 'Mali'),
(109, 'Malta'),
(110, 'Marshall Islands'),
(111, 'Mauritania'),
(112, 'Mauritius'),
(113, 'Mexico'),
(114, 'Micronesia'),
(115, 'Moldova'),
(116, 'Monaco'),
(117, 'Mongolia'),
(118, 'Morocco'),
(119, 'Mozambique'),
(120, 'Myanmar'),
(121, 'Namibia'),
(122, 'Nauru'),
(123, 'Nepal'),
(124, 'Netherlands'),
(125, 'New Zealand'),
(126, 'Nicaragua'),
(127, 'Niger'),
(128, 'Nigeria'),
(129, 'Norway'),
(130, 'Oman'),
(131, 'Pakistan'),
(132, 'Palau'),
(133, 'Panama'),
(134, 'Papua New Guinea'),
(135, 'Paraguay'),
(136, 'Peru'),
(137, 'Philippines'),
(138, 'Poland'),
(139, 'Portugal'),
(140, 'Qatar'),
(141, 'Romania'),
(142, 'Russia'),
(143, 'Rwanda'),
(144, 'Saint Kitts and Nevis'),
(145, 'Saint Lucia'),
(146, 'Saint Vincent'),
(147, 'Samoa'),
(148, 'San Marino'),
(149, 'Sao Tome and Principe'),
(150, 'Saudi Arabia'),
(151, 'Senegal'),
(152, 'Serbia and Montenegro'),
(153, 'Seychelles'),
(154, 'Sierra Leone'),
(155, 'Singapore'),
(156, 'Slovakia'),
(157, 'Slovenia'),
(158, 'Solomon Islands'),
(159, 'Somalia'),
(160, 'South Africa'),
(161, 'Spain'),
(162, 'Sri Lanka'),
(163, 'Sudan'),
(164, 'Suriname'),
(165, 'Swaziland'),
(166, 'Sweden'),
(167, 'Switzerland'),
(168, 'Syria'),
(169, 'Taiwan'),
(170, 'Tajikistan'),
(171, 'Tanzania'),
(172, 'Thailand'),
(173, 'Togo'),
(174, 'Tonga'),
(175, 'Trinidad and Tobago'),
(176, 'Tunisia'),
(177, 'Turkey'),
(178, 'Turkmenistan'),
(179, 'Tuvalu'),
(180, 'Uganda'),
(181, 'Ukraine'),
(182, 'United Arab Emirates'),
(183, 'United Kingdom'),
(184, 'United States'),
(185, 'Uruguay'),
(186, 'Uzbekistan'),
(187, 'Vanuatu'),
(188, 'Vatican City'),
(189, 'Venezuela'),
(190, 'Vietnam'),
(191, 'Yemen'),
(192, 'Zambia'),
(193, 'Zimbabwe');

CREATE SEQUENCE "news_id_seq"  START WITH 1 ;

CREATE TABLE  "news" (
   "id" integer DEFAULT nextval('"news_id_seq"') NOT NULL,
   "author"   int NOT NULL, 
   "time"   timestamp without time zone NOT NULL, 
   "text"   varchar(1000) NOT NULL, 
   primary key ("id")
)      ;


CREATE INDEX "news_author_idx" ON "news" USING btree ("author");

CREATE SEQUENCE "placemarks_id_seq"  START WITH 1 ;

CREATE TABLE  "placemarks" (
   "id" integer DEFAULT nextval('"placemarks_id_seq"') NOT NULL,
   "name"   varchar(255) NOT NULL, 
   "type"   int NOT NULL, 
   "gps_longitude"   double precision NOT NULL, 
   "gps_latitude"   double precision NOT NULL, 
   "gps_altitude"   double precision default NULL, 
   "place_country"   varchar(255) NOT NULL, 
   "place_state"   int NOT NULL, 
   "author"   int NOT NULL, 
   primary key ("id")
)      ;

CREATE INDEX "placemarks_1_idx" ON "placemarks" USING btree ("type", "place_country", "author");
CREATE INDEX "placemarks_author_idx" ON "placemarks" USING btree ("author");
CREATE INDEX "placemarks_place_state_idx" ON "placemarks" USING btree ("place_state");


CREATE SEQUENCE "placemark_type_enumerator_id_seq"  START WITH 2 ;

CREATE TABLE  "placemark_type_enumerator" (
   "id" integer DEFAULT nextval('"placemark_type_enumerator_id_seq"') NOT NULL,
   "name"   varchar(255) NOT NULL, 
   primary key ("id")
)      ;


INSERT INTO "placemark_type_enumerator" ("id", "name") VALUES  
(1, 'In');

CREATE SEQUENCE "users_id_seq"  START WITH 2 ;

CREATE TABLE  "users" (
   "id" integer DEFAULT nextval('"users_id_seq"') NOT NULL,
   "login"   varchar(32) NOT NULL, 
   "password"   varchar(255) NOT NULL, 
   "type"    smallint NOT NULL, 
   "ip_address"   varchar(15) default NULL, 
   "session_id"   varchar(64) default NULL, 
   "email"   varchar(255) NOT NULL, 
   "state" integer NOT NULL,
   primary key ("id"),
 unique ("login") 
)      ;

INSERT INTO "users" ("id", "login", "password", "type", "ip_address", "session_id", "email", "state") VALUES  
(1, 'admin', 'a94a8fe5ccb19ba61c4c0873d391e987982fbbd3', 1, '', '', 'mail@mail.sk',156);
ALTER TABLE comments
  ADD CONSTRAINT comments_ibfk_1 FOREIGN KEY (author) REFERENCES users (id) ON UPDATE NO ACTION,
  ADD CONSTRAINT comments_ibfk_2 FOREIGN KEY (placemark) REFERENCES placemarks (id) ON DELETE NO ACTION;
ALTER TABLE news
  ADD CONSTRAINT news_ibfk_1 FOREIGN KEY (author) REFERENCES users (id) ON DELETE CASCADE;
ALTER TABLE placemarks
  ADD CONSTRAINT placemarks_ibfk_3 FOREIGN KEY (type) REFERENCES placemark_type_enumerator (id) ON UPDATE NO ACTION,
  ADD CONSTRAINT placemarks_ibfk_4 FOREIGN KEY (place_state) REFERENCES country_enumerator (id) ON UPDATE NO ACTION,
  ADD CONSTRAINT placemarks_ibfk_5 FOREIGN KEY (author) REFERENCES users (id) ON UPDATE NO ACTION;
ALTER TABLE users
  ADD CONSTRAINT users_state_fkey FOREIGN KEY (state) REFERENCES country_enumerator(id) ON DELETE RESTRICT;
