﻿using System;
using System.Data;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class customControls_FilterTests : System.Web.UI.UserControl {


    private NorthwindDataContext db = new NorthwindDataContext();
    private string _DataListID = null;

    public string DataListID {
        get { return _DataListID; }
        set { _DataListID = value; }
    }

    protected void Page_Load(object sender, EventArgs e) {
        if (!Page.IsPostBack) {
            Load_All_Checkboxes();
            Load_Test();
        }
    }

    private void Load_All_Checkboxes() {
        chb_user_all.Text = "všetci";
        chb_user_all.Checked = true;
        chb_user_all.EnableViewState = true;
        chb_cat_all.Text = "všetky";
        chb_cat_all.EnableViewState = true;
        chb_cat_all.Checked = true;
    }

    private void Load_Test() {
        var users =
            (from t in db.tests
             select new {
                 user_name = t.user_name
             }).Distinct();
        chb_user.DataSource = users;
        chb_user.DataTextField = "user_name";
        chb_user.DataValueField = "user_name";
        chb_user.DataBind();
        var cats =
            (from t in db.tests
             from rel in db.CategoryTestRelations
             where t.test_id == rel.test_id
             select new {
                 cat_title = rel.category.title,
                 cat_id = rel.category_id
             }).Distinct();
        chb_cat.DataSource = cats;
        chb_cat.DataTextField = "cat_title";
        chb_cat.DataValueField = "cat_id";
        chb_cat.DataBind();
        //zaskrtni vsetky
        for (int i = 0; i < chb_user.Items.Count; i++) {
            chb_user.Items[i].Selected = true;
        }
        for (int i = 0; i < chb_cat.Items.Count; i++) {
            chb_cat.Items[i].Selected = true;
        }
    }

    private void setCheckedAll(CheckBoxList _list, bool _checked) {
        for (int i = 0; i < _list.Items.Count; i++) {
            _list.Items[i].Selected = _checked;
        }
    }

    protected void chb_user_all_Changed(object sender, EventArgs e) {
        if (chb_user_all.Checked) {
            setCheckedAll(this.chb_user, true);
        }
        else {
            setCheckedAll(this.chb_user, false);
        }
        applyArticleFilters();
    }

    protected void chb_cat_all_CheckedChanged(object sender, EventArgs e) {
        if (chb_cat_all.Checked) {
            setCheckedAll(this.chb_cat, true);
        }
        else {
            setCheckedAll(this.chb_cat, false);
        }
        applyArticleFilters();
    }

    protected void chb_user_SelectedIndexChanged(object sender, EventArgs e) {
        bool vsetky = true;
        foreach (ListItem c in chb_user.Items) {
            if (c.Selected) {
                //este neviem co
            }
            else {
                vsetky = false;
            }
        }
        chb_user_all.Checked = vsetky;
        applyArticleFilters();
    }

    protected void chb_cat_SelectedIndexChanged(object sender, EventArgs e) {
        bool vsetky = true;
        foreach (ListItem c in chb_cat.Items) {
            if (c.Selected) {
                //nieco
            }
            else {
                vsetky = false;
            }
        }
        chb_cat_all.Checked = vsetky;
        applyArticleFilters();
    }

    private void applyArticleFilters() {
        List<string> user_list = new List<string>();
        foreach (ListItem item in chb_user.Items) {
            if (item.Selected) {
                user_list.Add(item.Value);
            }
        }
        List<string> cat_list = new List<string>();
        foreach (ListItem item in chb_cat.Items) {
            if (item.Selected) {
                cat_list.Add(item.Value);
            }
        }
        List<test> pom =
            (from t in db.tests
             select t).ToList();
        List<test> pom_out = new List<test>();
        foreach (test t in pom) {
            if (userListContainsIt(user_list, t.user_name) &&
                atLeastOneCategory(cat_list, t.test_id)) {
                pom_out.Add(t);
            }
        }
        List<TestUkazka> final_list =
            (from a in pom_out
            from p in db.photos
            where p.user_name == a.user_name
            let link = "~/main/test.aspx?id=" + a.test_id
            select new TestUkazka(link, a.title, a.description, p.path)).ToList();
        Control obsah = Page.Master.FindControl("obsah");
        ListView dl = (ListView)obsah.FindControl(DataListID);
        dl.DataSource = final_list;
        dl.DataBind();
    }

    private bool userListContainsIt(List<string> list, string s) {
        if (!chb_user_all.Checked && !list.Contains(s)) {
            return false;
        }
        return true;
    }

    private bool atLeastOneCategory(List<string> list, int test_id) {
        if (chb_cat_all.Checked) {
            return true;
        }
        List<category> all =
            (from rel in db.CategoryTestRelations
             where rel.test_id == test_id
             select rel.category).ToList();
        List<category> list_out = new List<category>();
        foreach (category c in all) {
            if (catListContainsIt(list, c.category_id)) {
                list_out.Add(c);
            }
        }
        if (list_out.Count > 0) {
            return true;
        }
        return false;
    }

    private bool catListContainsIt(List<string> list, int id) {
        if (!chb_cat_all.Checked && !list.Contains(id.ToString())) {
            return false;
        }
        return true;
    }

}

public class TestUkazka {

    private string _url;
    private string _title;
    private string _description;
    private string _path;

    public string url {
        get { return _url; }
        set { _url = value; }
    }

    public string title {
        get { return _title; }
        set { _title = value; }
    }

    public string description {
        get { return _description; }
        set { _description = value; }
    }

    public string path {
        get { return _path; }
        set { _path = value; }
    }

    public TestUkazka(string u, string t, string d, string p) {
        this._url = u;
        this._title = t;
        this._description = d; 
        this._path = p;
    }

}

