﻿using System;
using System.Data;
using System.Data.Linq;
using System.Collections.Generic;
using System.Linq;
using System.Security.Principal;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class TeacherVoteButton : System.Web.UI.UserControl {

    private NorthwindDataContext db = new NorthwindDataContext();
    private Table<vote> tbl_votes = null;
    private Table<ClassVoteRelation> tbl_cvrel = null;
    private string POVOLENE_STYLE = "color: #000000; background-color: #00FF00;";
    private string ZAKAZANE_STYLE = "color: #FFFFFF; background-color: #FF0000;";

    /*
     * vote_type 2 = zakazene hlasovanie
     * vote_type 3 = povolene hlasovanie
     */

    private vote vote = null;
    private int _button_id = 0; //identifikator v tabulke
    private bool _zakazane;
    private int _class_id; 

    public int button_id {
        get { return _button_id; }
        set { _button_id = value; }
    }
    
    public bool zakazane {
        get { return _zakazane; }
        set { _zakazane = value; }
    }

    public int class_id {
        get { return _class_id; }
        set { _class_id = value; }
    }

    protected void Page_Load(object sender, EventArgs e) {
        Control obsah = Page.Master.FindControl("obsah");
        this.class_id = int.Parse(((DropDownList)obsah.FindControl("ddl_class")).SelectedValue);
        tbl_votes = db.votes;
        tbl_cvrel = db.ClassVoteRelations;
        this.vote =
            (from v in tbl_votes
             where v.ClassVoteRelation.class_id == this.class_id
             where v.button_id == this.button_id
             where v.teachers == true
             select v).SingleOrDefault();
        if (this.vote == null) {
            //vytvor prvotny hlas
            this.vote = new vote();
            this.vote.button_id = this.button_id;
            this.vote.comment = null;
            this.vote.teachers = true;
            this.vote.user_name = Page.User.Identity.Name;
            this.vote.vote_type = 3;
            tbl_votes.InsertOnSubmit(this.vote);
            db.SubmitChanges();
            //teraz relation
            ClassVoteRelation cvrel = new ClassVoteRelation();
            cvrel.class_id = this.class_id;
            cvrel.vote_id = this.vote.vote_id;
            tbl_cvrel.InsertOnSubmit(cvrel);
            db.SubmitChanges();
            setNewStyle(false);
        }
        else {
            if (this.vote.vote_type == 2) {
                zakazane = true;
                setNewStyle(true);
            }
            else {
                zakazane = false;
                setNewStyle(false);
            }
        }
    }

    private void setNewStyle(bool zakazane) {
        _zakazane = zakazane;
        if (_zakazane) {
            vote_button.Text = "zakázané";
            vote_button.Attributes.Add("style", ZAKAZANE_STYLE);
        }
        else {
            vote_button.Text = "povolené";
            vote_button.Attributes.Add("style", POVOLENE_STYLE);
        }
    }

    private void setOpositeStyle() {
        if (_zakazane) {
            setNewStyle(false);
        }
        else {
            setNewStyle(true);
        }
    }

    protected void vote_button_Click(Object sender, EventArgs e) {
        setOpositeStyle();
        this.vote.vote_type = (_zakazane) ? 2 : 3;
        db.SubmitChanges();
    }

}
