﻿using System;
using System.Collections.Generic;
using System.Data.Linq;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class main_admin_timetable : System.Web.UI.Page
{

    private NorthwindDataContext db = new NorthwindDataContext();
    private Table<@class> tbl_class = null;
    private int class_selected = 0;
    
    protected void Page_Init(object sender, EventArgs e) {
        //adding CSS style file
        HtmlLink newCSS = new HtmlLink();
        newCSS.Href = "~/css/timetable_style.css";
        newCSS.Attributes.Add("type", "text/css");
        newCSS.Attributes.Add("rel", "Stylesheet");
        Page.Header.Controls.Add(newCSS);
    }

    protected void Page_Load(object sender, EventArgs e) {
        tbl_class = db.classes;
        if (!Page.IsPostBack) {
            var ddl_out =
                from c in tbl_class
                let popis = c.class_name + " " + c.description
                select new { id = c.class_id, popis = popis };
            ddl_class.DataSource = ddl_out;
            ddl_class.DataTextField = "popis";
            ddl_class.DataValueField = "id";
            ddl_class.DataBind();
        }
        this.class_selected = int.Parse(ddl_class.SelectedValue.ToString());
        try {
            DateTime start =
                (from c in tbl_class
                 where c.class_id == this.class_selected
                 select c.voting_start).Single().Value;
            Label1.Text = "Dátum spustenia hlasovania je " + start.Date.ToString();
        }
        catch (InvalidOperationException ex) {
            Label1.Text = "Nie je nastavený dátum spustenia hlasovania !";
        }
        try{
            DateTime end =
                (from c in tbl_class
                 where c.class_id == this.class_selected
                 select c.voting_end).Single().Value;
            Label2.Text = "Dátum ukončenia hlasovania je " + end.Date.ToString();
        }
        catch (InvalidOperationException ex) {
            Label2.Text = "Nie je nastavený dátum ukončenia hlasovania !";
        }
    }

    protected void set_datetime_Click(object sender, EventArgs e) {
        int id = int.Parse(ddl_class.SelectedValue.ToString());
        @class trieda =
            (from c in tbl_class
             where c.class_id == id
             select c).SingleOrDefault();
        if (trieda == null) {
            //TODO niečo veľmi zle, prečo nesedi class_id v dropdownliste?
        }
        else {
            int value = int.Parse(rbl_timedate.SelectedValue.ToString());
            if (value == 0) {
                trieda.voting_start = Calendar1.SelectedDate.Date;
                db.SubmitChanges();
                if (trieda.voting_start < DateTime.Now) {
                    Label1.Text = "Hlasovanie za rozvrh už prebieha.";
                }
                else {
                    Label1.Text = "Hlasovanie za rozvrh začne: " + trieda.voting_start.Value.Date.ToString();
                }

            }
            else {
                trieda.voting_end = Calendar1.SelectedDate.Date;
                db.SubmitChanges();
                if (trieda.voting_end < DateTime.Now) {
                    Label2.Text = "Hlasovanie za rozvrh bolo ukočené.";
                }
                else {
                    Label2.Text = "Hlasovanie za rozvrh bude ukončené dňa " + trieda.voting_end.Value.Date.ToString();
                }
            }
        }
    }
}
