﻿using System;
using System.Data;
using System.Data.Linq;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class main_admin_timetable_result : System.Web.UI.Page
{

    private NorthwindDataContext db = new NorthwindDataContext();
    private Table<@class> tbl_class = null;
    private Table<vote> tbl_vote = null;

    private int selected_class = 0;
    private int max_hlasov = -1;

    private Label[] policka = new Label[71];
    private TableCell[] policka_td = new TableCell[71];
    private int[] pocet_hlasov = new int[71];
    private static string STYLE_1 = "background-color: #00ff0c; ";
    private static string STYLE_2 = "background-color: #ff6200; ";
    private static string STYLE_3 = "background-color: #ffa800; ";
    private static string STYLE_4 = "background-color: #fff500; ";
    private static string STYLE_5 = "background-color: #beff00; ";
    private static string STYLE_6 = "background-color: #78ff00; ";
    private static string STYLE_7 = "background-color: #00ff00; ";
    private string[] farby = new string[7]{STYLE_1, STYLE_2, STYLE_3,
                                 STYLE_4, STYLE_5, STYLE_6, STYLE_7};

    protected void Page_Init(object sender, EventArgs e) {
        //adding CSS style file
        HtmlLink newCSS = new HtmlLink();
        newCSS.Href = "~/css/timetable_style.css";
        newCSS.Attributes.Add("type", "text/css");
        newCSS.Attributes.Add("rel", "Stylesheet");
        Page.Header.Controls.Add(newCSS);
    }

    protected void Page_Load(object sender, EventArgs e) {
        this.tbl_class = db.classes;
        this.tbl_vote = db.votes;
        if (!Page.IsPostBack) {
            var ddl_out =
                from c in this.tbl_class
                let popis = c.class_name + " " + c.description
                select new { id = c.class_id, popis = popis };
            ddl_class.DataSource = ddl_out;
            ddl_class.DataTextField = "popis";
            ddl_class.DataValueField = "id";
            ddl_class.DataBind();
        }
        this.selected_class = int.Parse(ddl_class.SelectedValue);
        Control obsah = Master.FindControl("obsah");
        Control table = obsah.FindControl("timetable_table");
        string lbl = "Label";
        string cell = "TableCell";
        for (int i = 1; i <= 70; i++) {
            policka[i] = (Label)obsah.FindControl(lbl + i.ToString());
            policka_td[i] = (TableCell)table.FindControl(cell + i.ToString());
            pocet_hlasov[i] = 0;
        }
        //vsetky "mozem" hlasy k danemu rozvrhu
        var hlasy =
            from v in tbl_vote
            where v.ClassVoteRelation.class_id == this.selected_class
            where v.vote_type == 0
            select v;
        foreach (vote v in hlasy) {
            pocet_hlasov[v.button_id] += 1;
            if (pocet_hlasov[v.button_id] > this.max_hlasov) {
                this.max_hlasov = pocet_hlasov[v.button_id];
            }
        }
        for (int i = 1; i <= 70; i++) {
            policka[i].Text = pocet_hlasov[i].ToString();
            //float f = (float)pocet_hlasov[i] / (float)this.max_hlasov;
            float f = (float)pocet_hlasov[i] / (float)3;
            f *= 100;
            policka[i].Text = String.Format("{0:0.00}", f);
            int pom = (int)f / 15;
            policka_td[i].Attributes["style"] = farby[pom + 1];
        }
    }
}
