﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Collections.Generic;
using System.Data.Linq;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class main_edit_article_edit : System.Web.UI.Page
{

    private int article_id = 0;
    private NorthwindDataContext db = new NorthwindDataContext();
    private Table<article> tbl_clanky = null;
    private article clanok = null;

    protected void Page_Init(object sender, EventArgs e) {
        //adding CSS style file
        HtmlLink newCSS = new HtmlLink();
        newCSS.Href = "~/css/edit_style.css";
        newCSS.Attributes.Add("type", "text/css");
        newCSS.Attributes.Add("rel", "Stylesheet");
        Page.Header.Controls.Add(newCSS);
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack) {
            try {
                this.article_id = int.Parse(Request.QueryString["id"].ToString());
                ViewState["clanok_id"] = this.article_id;
                tbl_clanky = db.articles;
                this.clanok =
                    (from c in tbl_clanky
                    where c.article_id == this.article_id
                    select c).SingleOrDefault();
            }
            catch (Exception ex) {
                //
            }
            //ide sa editovat
            if (clanok != null) {
                tb_title.Text = clanok.title;
                tb_text.Text = clanok.text;
            }
        }
        if (ViewState["article_id"] != null) {
            try {
                this.article_id = int.Parse(ViewState["article_id"].ToString());
                this.clanok =
                    (from c in tbl_clanky
                    where c.article_id == this.article_id
                    select c).SingleOrDefault();
            }
            catch (Exception ex) {
                //TODO hmm
            }
        }
    }

    protected void btn_uloz_Click(object sender, EventArgs e) {
        if (this.clanok != null) {
            clanok.title = tb_title.Text;
            clanok.text = tb_text.Text;
        }
        else {
            this.clanok = new article();
            this.clanok.title = tb_title.Text;
            this.clanok.text = tb_text.Text;
            this.clanok.user_name = User.Identity.Name;
            this.clanok.description = tb_desc.Text;
            if (this.clanok.link != "") {
                this.clanok.link = tb_zdroj.Text;
            }
            else {
                this.clanok.link = "výtvor autora";
            }
            tbl_clanky = db.articles;
            tbl_clanky.InsertOnSubmit(this.clanok);
        }
        try {
            db.SubmitChanges();
        }
        catch (SqlException ex) {
            //TODO niezo zle s ukladanim clanku
        }
    }
}
