﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Linq;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class main_rozvrh : System.Web.UI.Page
{

    private NorthwindDataContext db = new NorthwindDataContext();
    private Table<@class> tbl_class = null;
    private int selected_class = 0;

    protected void Page_Init(object sender, EventArgs e) {
        //adding CSS style file
        HtmlLink newCSS = new HtmlLink();
        newCSS.Href = "~/css/timetable_style.css";
        newCSS.Attributes.Add("type", "text/css");
        newCSS.Attributes.Add("rel", "Stylesheet");
        Page.Header.Controls.Add(newCSS);
        //tables
        this.tbl_class = db.classes;
    }

    protected void Page_Load(object sender, EventArgs e) {
        if (!Page.IsPostBack) {
            var ddl_out =
                from c in db.classes
                where c.ClassUserRelation.user_name == User.Identity.Name
                let popis = c.class_name + " " + c.description
                select new { id = c.class_id, popis = popis };
            ddl_class.DataSource = ddl_out;
            ddl_class.DataTextField = "popis";
            ddl_class.DataValueField = "id";
            ddl_class.DataBind();
            ddl_class.SelectedIndex = 1;
        }
        this.selected_class = int.Parse(ddl_class.SelectedValue.ToString());
        Nullable<DateTime> start =
            (from c in this.tbl_class
             where c.class_id == this.selected_class
             select c.voting_start).SingleOrDefault();
        Nullable<DateTime> end =
            (from c in this.tbl_class
             where c.class_id == this.selected_class
             select c.voting_end).SingleOrDefault();
        rozhodniCiHlasovat(start, end);
    }

    private void rozhodniCiHlasovat(Nullable<DateTime> s, Nullable<DateTime> e) {
        DateTime teraz = DateTime.Now;
        if (s == null) {
            Label1.Enabled = true;
            Label1.Visible = true;
            Label1.Text = "Zatiaľ nie je možné hlasovať. Prosím počkajte kým učiteľ špecifikuje obdobie hlasovania.";
            Panel1.Enabled = false;
            Panel1.Visible = false;
            return;
        }
        // s != null
        if (e == null) {
            if (s <= teraz) {
                Label1.Enabled = false;
                Label1.Visible = false;
                Panel1.Enabled = true;
                Panel1.Visible = true;
                return;
            }
        }
        else {
            if (s <= teraz && e > teraz) {
                Label1.Enabled = false;
                Label1.Visible = false;
                Panel1.Enabled = true;
                Panel1.Visible = true;
                return;
            }
        }
        Label1.Enabled = true;
        Label1.Visible = true;
        Label1.Text = "Nie je možné hlasovať mimo obdobia hlasovania.";
        Panel1.Enabled = false;
        Panel1.Visible = false;
    }
}
