﻿using System;
using System.Data;
using System.Data.Linq;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class VoteButton : System.Web.UI.UserControl
{
    private NorthwindDataContext db = new NorthwindDataContext();
    
    //private string MOZEM_STYLE = "color: #000000; background-color: #00FF00;";
    //private string NEMOZEM_STYLE = "color: #000000; background-color: #FF0000;";
    //private string ZAKAZANE_STYLE = "color: #000000; background-color: black; color: white";

    private string MOZEM_STYLE = "color: #000000; border-left: solid 10px #00FF00; border-right: solid 10px #FFFF00;";
    private string NEMOZEM_STYLE = "color: #000000; border-left: solid 10px #FF0000; border-right: solid 10px #FF0000";
    private string ZAKAZANE_STYLE = "color: #000000; background-color: black; color: white";

    private string MOZEM_TEXT = "môžem";
    private string NEMOZEM_TEXT = "nemôžem";
    private string ZAKAZANE_TEXT = "zakázané";

    /*
     * vote_type 0 = mozem
     * vote_type 1 = nemozem
     * vote_type 2 = zakazene hlasovanie
     */

    private vote vote = null;
    private int _button_id = 0; //identifikator v tabulke
    private int _button_state_id = 0;
    private int _class_id;

    public int button_id {
        get { return _button_id; }
        set { _button_id = value; }
    }

    public int state_id {
        get { return _button_state_id; }
        set { _button_state_id = value; }
    }

    public int class_id {
        get { return _class_id; }
        set { _class_id = value; }
    }

    private string _state_text;

    protected void Page_Load(object sender, EventArgs e) {
        //TODO info, ak profak zrazu povoli termin, dostavas "mozem"
        Control obsah = Page.Master.FindControl("obsah");
        this.class_id = int.Parse(((DropDownList)obsah.FindControl("ddl_class")).SelectedValue);
        Table<vote> tbl_hlasy = db.votes;
        Table<ClassVoteRelation> tbl_cvrel = db.ClassVoteRelations;
        //najpr teachers
        this.vote =
            (from h in tbl_hlasy
             where h.button_id == this.button_id
             where h.ClassVoteRelation.class_id == this.class_id
             where h.teachers == true
             where h.vote_type == 2
             select h).SingleOrDefault();
        if (this.vote != null) {
            //je zakazane!
            vote_button.Enabled = false;
            vote_button.Text = ZAKAZANE_TEXT;
            vote_button.Attributes["style"] = ZAKAZANE_STYLE;
        }
        else {
            this.vote =
                (from v in tbl_hlasy
                where v.button_id == this.button_id
                where v.ClassVoteRelation.class_id == this.class_id
                where v.teachers == false
                where v.user_name == Page.User.Identity.Name
                select v).SingleOrDefault();
            if(this.vote == null){
                this.vote = new vote();
                this.vote.button_id = this.button_id;
                this.vote.comment = null;
                this.vote.teachers = false;
                this.vote.user_name = Page.User.Identity.Name;
                this.vote.vote_type = 0;
                tbl_hlasy.InsertOnSubmit(this.vote);
                db.SubmitChanges();
                ClassVoteRelation cvrel = new ClassVoteRelation();
                cvrel.class_id = this.class_id;
                cvrel.vote_id = this.vote.vote_id;
                tbl_cvrel.InsertOnSubmit(cvrel);
                db.SubmitChanges();

            }
            else{
                this.state_id = this.vote.vote_type;
            }
            setNewStyle(this.state_id);
        }
    }

    private void doVote() {
        this.state_id += 1;
        this.state_id = this.state_id % 2;
        setNewStyle(this.state_id);
    }

    private void setNewStyle(int _state) {
        string style = "";
        string text = "";
        switch (_state) {
            case 0:
                text = MOZEM_TEXT;
                style = MOZEM_STYLE;
                break;
            default:
                text = NEMOZEM_TEXT;
                style = NEMOZEM_STYLE;
                break;
        }
        vote_button.Text = text;
        vote_button.Attributes["style"] = style;
    }

    protected void vote_button_Click(object sender, EventArgs e) {
        doVote();
        this.vote.vote_type = this.state_id;
        db.SubmitChanges();
    }

}
