using System;
using System.Data;
using System.Data.Linq;
using System.Data.SqlClient;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Linq;

public partial class main_clanky : System.Web.UI.Page {

    private NorthwindDataContext db = new NorthwindDataContext();
    private Table<article> clanky = null;
    private Table<CategoryArticleRelation> kat_clanky_relacie = null;
    private Table<category> kategorie = null;
    private Table<aspnet_User> uzivatelia = null;

    protected void Page_Init(object sender, EventArgs e) {
        //adding CSS style file
        HtmlLink newCSS = new HtmlLink();
        newCSS.Href = "~/css/clanky_style.css";
        newCSS.Attributes.Add("type", "text/css");
        newCSS.Attributes.Add("rel", "Stylesheet");
        Page.Header.Controls.Add(newCSS);
        HtmlLink newCSS2 = new HtmlLink();
        newCSS2.Href = "~/css/filters_style.css";
        newCSS2.Attributes.Add("type", "text/css");
        newCSS2.Attributes.Add("rel", "Stylesheet");
        Page.Header.Controls.Add(newCSS2);
        //add tables 
        this.clanky = db.articles;
        this.kategorie = db.GetTable<category>();
        this.kat_clanky_relacie = db.GetTable<CategoryArticleRelation>();
        this.uzivatelia = db.GetTable<aspnet_User>();
    }

    protected void Page_Load(object sender, EventArgs e) {
        if (!Page.IsPostBack) {
            Load_All_Checkboxes();
            Load_ArticlesCheckboxlists();
            //vypln clanky
            var out_list =
                from a in db.articles
                let url = "~/main/clanok.aspx?id=" + a.article_id
                select new ArticleUkazka(url, a.link, a.title, a.user_name,
                    a.description, a.photo.path);
            lw_clanky.DataSource = out_list;
            lw_clanky.DataBind();
            
        }
    }

    protected void lw_clanky_pager_changing(object sender, PagePropertiesChangingEventArgs e) {
        this.DataPager1.SetPageProperties(e.StartRowIndex, e.MaximumRows, false);
        applyArticleFilters();
    }

    private void Load_All_Checkboxes() {
        chb_user_all.Text = "vetci";
        chb_user_all.Checked = true;
        chb_user_all.EnableViewState = true;
        chb_cat_all.Text = "vetky";
        chb_cat_all.EnableViewState = true;
        chb_cat_all.Checked = true;
    }

    private void Load_ArticlesCheckboxlists() {
        var users =
            (from u in db.articles
             select new {
                 user_name = u.user_name
             }).Distinct();
        chb_user.DataSource = users;
        chb_user.DataTextField = "user_name";
        chb_user.DataValueField = "user_name";
        chb_user.DataBind();
        var cats =
            (from a in db.articles
             from rel in db.CategoryArticleRelations
             where a.article_id == rel.article_id
             select new {
                 cat_title = rel.category.title,
                 cat_id = rel.category_id
             }).Distinct();
        chb_cat.DataSource = cats;
        chb_cat.DataTextField = "cat_title";
        chb_cat.DataValueField = "cat_id";
        chb_cat.DataBind();
        //zaskrtni vsetky
        for (int i = 0; i < chb_user.Items.Count; i++) {
            chb_user.Items[i].Selected = true;
        }
        for (int i = 0; i < chb_cat.Items.Count; i++) {
            chb_cat.Items[i].Selected = true;
        }
    }

    private void setCheckedAll(CheckBoxList _list, bool _checked) {
        for (int i = 0; i < _list.Items.Count; i++) {
            _list.Items[i].Selected = _checked;
        }
    }

    protected void chb_user_all_Changed(object sender, EventArgs e) {
        if (chb_user_all.Checked) {
            setCheckedAll(this.chb_user, true);
        }
        else {
            setCheckedAll(this.chb_user, false);
        }
        applyArticleFilters();
    }

    protected void chb_cat_all_CheckedChanged(object sender, EventArgs e) {
        if (chb_cat_all.Checked) {
            setCheckedAll(this.chb_cat, true);
        }
        else {
            setCheckedAll(this.chb_cat, false);
        }
        applyArticleFilters();
    }

    protected void chb_user_SelectedIndexChanged(object sender, EventArgs e) {
        bool vsetky = true;
        foreach (ListItem c in chb_user.Items) {
            if (c.Selected) {
                //este neviem co
            }
            else {
                vsetky = false;
            }
        }
        chb_user_all.Checked = vsetky;
        applyArticleFilters();
    }

    protected void chb_cat_SelectedIndexChanged(object sender, EventArgs e) {
        bool vsetky = true;
        foreach (ListItem c in chb_cat.Items) {
            if (c.Selected) {
                //nieco
            }
            else {
                vsetky = false;
            }
        }
        chb_cat_all.Checked = vsetky;
        applyArticleFilters();
    }

    private void applyArticleFilters() {
        List<string> user_list = new List<string>();
        foreach (ListItem item in chb_user.Items) {
            if (item.Selected) {
                user_list.Add(item.Value);
            }
        }
        List<string> cat_list = new List<string>();
        foreach (ListItem item in chb_cat.Items) {
            if (item.Selected) {
                cat_list.Add(item.Value);
            }
        }
        List<article> pom =
            (from c in db.articles
             select c).ToList();
        List<article> pom_out = new List<article>();
        foreach (article a in pom) {
            if (userListContainsIt(user_list, a.user_name) &&
                atLeastOneCategory(cat_list, a.article_id)) {
                pom_out.Add(a);
            }
        }
        List<ArticleUkazka> final_list =
            (from a in pom_out
            let url = "~/main/clanok.aspx?id=" + a.article_id
            select new ArticleUkazka(url, a.link, a.title, a.user_name, 
                a.description, a.photo.path)).ToList();
        lw_clanky.DataSource = final_list;
        lw_clanky.DataBind();
    }

    private bool userListContainsIt(List<string> list, string s) {
        if (!chb_user_all.Checked && !list.Contains(s)) {
            return false;
        }
        return true;
    }

    private bool atLeastOneCategory(List<string> list, int article_id) {
        if (chb_cat_all.Checked) {
            return true;
        }
        List<category> all =
            (from rel in db.CategoryArticleRelations
             where rel.article_id == article_id
             select rel.category).ToList();
        List<category> list_out = new List<category>();
        foreach (category c in all) {
            if (catListContainsIt(list, c.category_id)) {
                list_out.Add(c);
            }
        }
        if (list_out.Count > 0) {
            return true;
        }
        return false;
    }

    private bool catListContainsIt(List<string> list, int id) {
        if (!chb_cat_all.Checked && !list.Contains(id.ToString())) {
            return false;
        }
        return true;
    }
}

public class ArticleUkazka {

    private string _url;
    private string _zdroj_url;
    private string _zdroj_url_text;
    private string _title;
    private string _pridal;
    private string _description;
    private string _path;

    public string url {
        get { return _url; }
        set { _url = value; }
    }

    public string zdroj_url {
        get { return _zdroj_url; }
        set { _zdroj_url = value; }
    }

    public string zdroj_url_text {
        get { return _zdroj_url_text; }
        set { _zdroj_url_text = value; }
    }

    public string title {
        get { return _title; }
        set { _title = value; }
    }

    public string pridal {
        get { return _pridal; }
        set { _pridal = value; }
    }

    public string description {
        get { return _description; }
        set { _description = value; }
    }

    public string path {
        get { return _path; }
        set { _path = value; }
    }
    
    public ArticleUkazka(string _u, string _z_url, string _t, string _p,
        string _d, string _pth) {
        this._url = _u;
        this._zdroj_url = _z_url;
        this._zdroj_url_text = uprav_zdroj(_z_url);
        this._title = _t;
        this._pridal = _p;
        this._description = _d;
        this._path = _pth;
    }

    private string uprav_zdroj(string _z) {
        if (_z.Length > 60) {
            string s = _z.Substring(0, 60);
            s += "...";
            return s;
        }
        return _z;

    }

}
