﻿using System;
using System.Data;
using System.Data.Linq;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class main_comment : System.Web.UI.Page {

    private NorthwindDataContext db = new NorthwindDataContext();
    private Table<comment> komenty = null;
    private int content_id;
    private int komentujem_id;
    private string komentujem_type;
    private const int OFF_SET = 31;

    protected void Page_Init(object sender, EventArgs e) {
        komenty = db.GetTable<comment>();
    }

    protected void Page_Load(object sender, EventArgs e) {
        if (!Page.IsPostBack) {
            try {
                komentujem_id = Int16.Parse(Request.QueryString["id"]);
                komentujem_type = Request.QueryString["type"].ToString();
                content_id = Int16.Parse(Request.QueryString["content"]);
                ViewState["id"] = komentujem_id;
                ViewState["type"] = komentujem_type;
                ViewState["content"] = content_id;
            }
            catch (InvalidOperationException ex) {
                //nebol si presmerovany ! nieje povolene vola priamo
            }
            catch (Exception ex) {
                //log
                //nieco zle s posielanymi parametrami
                //presmeruj domov
            }
        }

    }

    protected void Button1_Click(object sender, EventArgs e) {
        try {
            if (ViewState["id"] != null && ViewState["type"] != null
                    && ViewState["content"] != null) {
                komentujem_id = (int)ViewState["id"];
                komentujem_type = ViewState["type"].ToString();
                content_id = (int)ViewState["content"];
            }
        }
        catch (InvalidCastException ex) {
            //log
            //presmeruj prec
        }
        catch (Exception ex) {
            //log
            //presmeruj prec
        }
        comment novy_koment = new comment();
        try {
            novy_koment.title = edit_title_input.Text;
            novy_koment.text = edit_text_input.Value;
            novy_koment.parrent_id = komentujem_id;
            novy_koment.user_name = User.Identity.Name;
            novy_koment.parrent_type = komentujem_type;
            if (komentujem_type == "article") {
                novy_koment.off_set = 0;
            }
            else {
                int parrent_off_set =
                    (from c in this.komenty
                    where c.comment_id == komentujem_id
                    select c.off_set).SingleOrDefault<int>();
                novy_koment.off_set = parrent_off_set + OFF_SET;
            }
            this.komenty.InsertOnSubmit(novy_koment);
            this.db.SubmitChanges();
        }
        catch(Exception ex){
            //log
            //presmeruj alebo vypis
        }
        string new_request = @"~/main/clanok.aspx?id=" + content_id.ToString();
        Response.Redirect(new_request);
    }
}