﻿<%@ WebHandler Language="C#" Class="RSSHandler" %>

using System;
using System.Collections.Generic;
using System.Web;
using System.IO;
using System.Xml;
using System.Data.Linq;
using System.Linq;

public class RSSHandler : IHttpHandler {
    
    private NorthwindDataContext db = new NorthwindDataContext();
    private string TITLE = "News Channel >> Hodina francúzštiny";
    private string LINK = "http://localhost:1381/franc_tia/rss/rss.ashx";
    private string DESCRIPTION = "Kanál sumarizuje novinky portály za posledný týždeň";
    private string CONTACT = "lukasdojcak@gmail.com";
    private DateTime time_now;
    
    public void ProcessRequest (HttpContext context) {
        
        time_now = DateTime.Now;
        HttpResponse response = context.Response;
        response.ContentType = "text/xml";
        response.Clear();
        
        XmlTextWriter writer = new XmlTextWriter(response.OutputStream, 
            System.Text.Encoding.UTF8);
        writer.Formatting = Formatting.Indented;
        writer.Indentation = 3;
        writer.WriteStartDocument();
        writer.WriteComment("Created @" + DateTime.Now.ToString());
        writer.WriteStartElement("rss");
        writer.WriteAttributeString("version", "2.0");
        writer.WriteStartElement("channel");

        writeChannelInfo(writer);
        writeChannelInfoItems(writer);

        writer.WriteEndElement();
        writer.WriteEndElement();
        writer.Flush();
        writer.Close();

    }
 
    public bool IsReusable {
        get {
            return false;
        }
    }

    private void writeChannelInfo(XmlTextWriter w) {
        w.WriteElementString("title", TITLE);
        w.WriteElementString("link", LINK);
        w.WriteElementString("description", DESCRIPTION);
        w.WriteElementString("managingEditor", CONTACT);
        w.WriteElementString("webMaster", CONTACT);
        w.WriteElementString("lastBuildData", DateTime.Now.ToString());
        //TODO add image
        //w.WriteElementString("image", "?");
    }

    private void writeChannelInfoItems(XmlTextWriter w) {
        //writeChannelNews(w);
        //writeChannelArticles(w);
         writeChannelTests(w);
    }

    private void writeChannelNews(XmlTextWriter w) {
        Table<@new> novinky = db.news;
        List<@new> news_out = new List<@new>();
        news_out = 
            (from n in novinky
            let span = time_now - n.date_created
            where (span.Value.Days <= 7)
            select n).ToList();
        foreach(@new novinka in news_out){
            // add novinku "novinka"
        }
    }

    private void writeChannelArticles(XmlTextWriter w) {
    }

    private void writeChannelTests(XmlTextWriter w) {
        Table<test> testy = db.tests;
        List<test> tests_out = new List<test>();
        tests_out =
            (from t in testy
             let span = time_now - t.data_created
             where (span.TotalDays <= 7)
             select t).ToList();
        foreach (test t in tests_out) {
            w.WriteStartElement("item");
            w.WriteElementString("title", t.title);
            w.WriteElementString("description", t.description);
            w.WriteElementString("link", "http://localhost:1381/franc_tia/main/test.aspx?id=" + t.test_id);
            w.WriteEndElement();
        }
    }

}