<? 
/* Form.php
 * sluzi na zjednodusenie ukladania chyb vo formularoch */
 
class Form
{
   var $values = array();  //pole v ktorom su pamatane hodnoty z formov
   var $errors = array();  //pole v ktorom su pamatane chyby z formov
   var $num_errors;   //pocet chyb

   /* konstruktor */
   function Form(){
      /* nahod premenne z pola */
      if(isset($_SESSION['value_array']) && isset($_SESSION['error_array'])){
         $this->values = $_SESSION['value_array'];
         $this->errors = $_SESSION['error_array'];
         $this->num_errors = count($this->errors);

         unset($_SESSION['value_array']);
         unset($_SESSION['error_array']);
      }
      else{
         $this->num_errors = 0;
      }
   }

   /* setError - nahra novy error (hodnote, text) */
   function setError($field, $errmsg){
      $this->errors[$field] = $errmsg;
      $this->num_errors = count($this->errors);
   }

   /* error - vrati chybu prisluchajucu k polozke */
   function error($field){
      if(array_key_exists($field,$this->errors)){
         return "<span class='error'>".$this->errors[$field]."</span>";
      }
      else{
         return "";
      }
   }

   /* setValue - nahra hodnotu z polozky
    */
   function setValue($field, $value){
      $this->values[$field] = $value;
   }

   /* value - vrati hodnotu prisluchajucu k polozke */
   function value($field){
      if(array_key_exists($field,$this->values)){
         return htmlspecialchars(stripslashes($this->values[$field]));
      }else{
         return "";
      }
   }

   /* getErrorArray - vrati pole chyb */
   function getErrorArray(){
      return $this->errors;
   }
};
 
?>
