<?
/* Process.php
 *
 * spracovanie submitnutych formularov, presmerovanie
 * uzivatela na prislusne stranky, logout
 */
include("include/session.php");

class Process
{
   /* konsturktor */
   function Process(){
      global $session;
      /* submitnuty login formular z index.php*/
      if(isset($_POST['sublogin'])){
         $this->procLogin();
      }
      /* submitnuta registraciam z register.php*/
      else if(isset($_POST['subjoin'])){
         $this->procRegister();
      }
      /* submitnuta zmena accountu z useredit.php*/
      else if(isset($_POST['subedit'])){
         $this->procEditAccount();
      }
      /* ak je prihlaseny, odhlas */
      else if($session->logged_in){
         $this->procLogout();
      }
      /* v inom pripade presmeruj domov */
       else{
          header("Location: index.php");
       }
   }

   /* procLogin - spracuje submitnuty login formular,
    * v pripade chyby si uzivatel moze chybu opravit,
    * inak je prihlaseny do systemu
    */
   function procLogin(){
      global $session, $form;
      /* pokus o login */
      $retval = $session->login($session->checkVar($_POST['user'],true), $session->checkVar($_POST['pass'],true), isset($_POST['remember']));
      /* uspesny login */
      if($retval){
         header("Location: index.php");
      }
      /* login sa pokazil */
      else{
         $_SESSION['value_array'] = $_POST;
         $_SESSION['error_array'] = $form->getErrorArray();
         header("Location: index.php");
      }
   }
   
   /* procLogout - odhlasenie pouzivatela */
   function procLogout(){
      global $session;
      $retval = $session->logout();
      header("Location: index.php");
   }
   
   /* procRegister - spracuje submitnuty registracny
    * formular, v pripade chyby si uzivatel moze chybu opravit,
    * inak je registrovany do systemu
    */
   function procRegister(){
      global $session, $form;

      /* pokus o registraciu */
      $retval = $session->register($session->checkVar($_POST['user'],true), $session->checkVar($_POST['pass'],true), $session->checkVar($_POST['email'],true));
      
      /* uspesna registracia */
      if($retval == 0){
         $_SESSION['reguname'] = $_POST['user'];
         $_SESSION['regsuccess'] = true;
         header("Location: register.php");
      }
      /* chyba vo formulari */
      else if($retval == 1){
         $_SESSION['value_array'] = $_POST;
         $_SESSION['error_array'] = $form->getErrorArray();
         header("Location: register.php");
      }
      /* zlyhanie registracie */
      else if($retval == 2){
         $_SESSION['reguname'] = $_POST['user'];
         $_SESSION['regsuccess'] = false;
         header("Location: register.php");
      }
   }
   
   /* procEditAccount - editovanie uctu uzivatela,
    * heslo musi byt spravne zadane pred zmenou
    */
   function procEditAccount(){
      global $session, $form;
      /* pokus o zmenu uctu */
      $retval = $session->editAccount($session->checkVar($_POST['curpass'],true), $session->checkVar($_POST['newpass'],true), $session->checkVar($_POST['email'],true));

      /* uspesna zmena */
      if($retval){
         $_SESSION['useredit'] = true;
         header("Location: useredit.php");
      }
      /* chyba vo formulari */
      else{
         $_SESSION['value_array'] = $_POST;
         $_SESSION['error_array'] = $form->getErrorArray();
         header("Location: useredit.php");
      }
   }
};

/* inicializacia */
$process = new Process;

?>
