<?php
class ClankyController extends Zend_Controller_Action {	
	private $logged = false;
	public function init(){
		$this->logged = Zend_Auth::getInstance()->hasIdentity();		
	}
	
	public function postDispatch(){
		$this->view->online = $this->logged;
	}
	
	public function indexAction(){
		$page = $this->_request->getParam('strana');
		if(Empty($page)){
			$page = 1;		
		}
		$clanky = new Model_DbTable_Clanky();
		$statement = $clanky->select()->limitPage($page, 5)->order('id DESC');
		$this->view->clanky = $clanky->fetchAll($statement);
    	$paginator = Zend_Paginator::factory($clanky->fetchAll());
    	$paginator->setItemCountPerPage(5);
    	$paginator->setCurrentPageNumber($page);
    	$this->view->paginator=$paginator;					
	}
	
	public function zobrazAction(){		
		$clanky = new Model_DbTable_Clanky();
		$id = $this->_request->getParam('id');
		if(empty($id)){
			$this->_redirect('/clanky');
		}
		$statement = $clanky->select()->where('id = ?', $id);
		$this->view->clanok = $clanky->fetchRow($statement);
		
		$komentare = new Model_DbTable_Komentare();
		$statement = $komentare->select('user')->setIntegrityCheck(false)->where('clanok_id = ?', $id)->joinLeft('user', 'klipy_komentare.user_id = user.id', array('login'));
		$this->view->komentare = $komentare->fetchAll($statement);
	}
	
	public function pridajKomentarAction(){
		$auth = Zend_Auth::getInstance();
		$id = $this->_request->getParam('id');
		if(!$auth->hasIdentity()){
			$this->_redirect('/');
		}
		$data = $auth->getStorage()->read();		
		$this->_helper->layout()->disableLayout();
		$this->_helper->viewRenderer->setNoRender(true);
		$komentar = $this->_request->getParam('comment');
		$user_id = $data->id;
		$data = array('content' => $komentar, 'user_id' => $user_id, 'date'=> new Zend_Db_Expr('NOW()'), 'clanok_id' => $id);
		$komentar_i = new Model_DbTable_Komentare();
		$komentar_i->insert($data);	
		$this->_redirect('/clanky/zobraz/id/'.$id);	
	}
}
?>