<?php
include('sites/galery/cGalerySiteActionDefault.php');
include('sites/galery/cGalerySiteViewDefault.php');
include('sites/galery/cGalerySiteActionNew.php');
include('sites/galery/cGalerySiteViewNew.php');

include('sites/galery/cGalerySiteViewEdit.php');
include('sites/galery/cGalerySiteActionEdit.php');

include('sites/galery/cGalerySiteViewBrowse.php');
include('sites/galery/cGalerySiteActionBrowse.php');

include('sites/galery/cGalerySiteViewDisplay.php');
include('sites/galery/cGalerySiteActionDisplay.php');
include('sites/galery/cGalerySiteActionAddComment.php');
include('sites/galery/cGalerySiteActionTag.php');
include('sites/galery/cGalerySiteViewComments.php');
include('sites/galery/cGalerySiteViewTags.php');
include('sites/galery/type/types.php');
 
/**
 *
 * Description of cGalerySite
 *
 * @author camper
 */
class cGalerySite {
    private $actions;
    private $views;
    function __construct() {
        $this->actions = array(
            "default"=>"cGalerySiteActionDefault",
            "new"=>"cGalerySiteActionNew",
            "edit"=>"cGalerySiteActionEdit",
			"display"=>"cGalerySiteActionDisplay",
			"browse"=>"cGalerySiteActionBrowse",			
			"comment"=>"cGalerySiteActionAddComment",
			"addtag"=>"cGalerySiteActionTag"
        );
        $this->views = array(
            "default"=>"cGalerySiteViewDefault",
            "new"=>"cGalerySiteViewNew",
            "edit"=>"cGalerySiteViewEdit",
			"display"=>"cGalerySiteViewDisplay",
			"browse"=>"cGalerySiteViewBrowse",			
			"comments"=>"cGalerySiteViewComments",
			"tags"=>"cGalerySiteViewTags",
        );
    }
    function isAction($action){
        if(isset($this->actions[$action])){
            return true;
        }
        return false;
    }
    function getDefaultAction(){
       $clases = array_values($this->actions);
       $classname=$clases[0];
       return new $classname;
    }
    function getAction($action){
       if($this->isAction($action)){
           $classname= $this->actions[$action];
           return new $classname;
       }
       return $this->getDefaultAction();
    }

    function isView($view){
        if(isset($this->views[$view])){
            return true;
        }
        return false;
    }
    function getDefaultView(){
       $clases = array_values($this->views);
       $classname=$clases[0];
       return new $classname;
    }
    function getView($view){
       if($this->isView($view)){
           $classname= $this->views[$view];
           return new $classname;
       }
       return $this->getDefaultView();
    }

}
?>
