<?
/*
		GPS Share v.1
    Copyright (C) 2010  Filip Vojtko

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

function edit_placemark($id,$name,$type,$state,$country,$longitude,$latitude,$altitude)
{
	if (!auth_islogged())
		return false;
		
	$author_check = db_query("SELECT id,author FROM placemarks WHERE id = '".db_safe_string($id)."' LIMIT 1");
	if (!$author_check)
		return false;
	if ($check = db_fetch_array($author_check))
	{
		if ((auth_userid() != $check['author']) AND (auth_usertype() != '1'))
			return false;
	}
	else
	{
		return false;
	}
	
	$id = htmlspecialchars($id);
	$name = htmlspecialchars($name);
	$type = htmlspecialchars($type);
	$state = htmlspecialchars($state);
	$country = htmlspecialchars($country);
	$longitude = htmlspecialchars($longitude);
	$latitude = htmlspecialchars($latitude);
	$altitude = htmlspecialchars($altitude);
	
	if ((!is_numeric($id)) OR (strlen($name) < 1) OR (!is_numeric($type)) OR (!is_numeric($state)) OR (!is_numeric($longitude)) OR (!is_numeric($latitude)))
		return false;
		
	if ((!is_numeric($altitude)) AND (strlen($altitude) != 0))
		return false;
	
	$type = db_safe_string($type);
			
	if (!($type_check = db_query("SELECT id FROM placemark_type_enumerator WHERE id = '$type'")))
		return false;
	
	if (db_num_rows($type_check) < 1)
		return false;	
		
	$state = db_safe_string($state);
	
	if (!($state_check = db_query("SELECT id FROM country_enumerator WHERE id = '$state'")))
		return false;
	
	if (db_num_rows($state_check) < 1)
		return false;	
	
	$id = db_safe_string($id);
	$name = db_safe_string($name);
	$country = db_safe_string($country);
	$longitude = db_safe_string($longitude);
	$latitude = db_safe_string($latitude);
	$altitude = db_safe_string($altitude);
	
	if (strlen($altitude) == 0)
		unset($altitude);
	
	$edit_query = "UPDATE placemarks SET name = '$name', type = '$type', place_state = '$state', place_country = '$country', gps_longitude = '$longitude', gps_latitude = '$latitude', gps_altitude = ".(isset($altitude)?"'".$altitude."'":"NULL")." WHERE id = '$id'";
	if (!db_query($edit_query))
		return false;
	
	return true;
}

include_once("lang/".$language."/placemarklist_lang.php");
?>

<form action="" enctype="multipart/form-data" method="post" id="placemark_edit_form">
	<fieldset>
			<legend><? echo $placemarklist_lang['32'];?></legend>
			
<?		if (isset($_POST['placemark_edit_submition']))
			{
				$_POST['placemark_edit'] = $_POST['placemark_edit_id'];
				if ((isset($_POST['placemark_edit_name'])) AND (isset($_POST['placemark_edit_type'])) AND (isset($_POST['placemark_edit_state'])) AND (isset($_POST['placemark_edit_country'])) AND (isset($_POST['placemark_edit_longitude'])) AND (isset($_POST['placemark_edit_latitude'])) AND (isset($_POST['placemark_edit_altitude'])))
				{
					if (strlen($_POST['placemark_edit_name']) < 1)
					{ ?>
						<span class="form_error"><? echo $placemarklist_lang['26']; ?></span>
			<?	}
					else if (!is_numeric($_POST['placemark_edit_longitude']))
					{ ?>
						<span class="form_error"><? echo $placemarklist_lang['27']; ?></span>
			<?	}
					else if (!is_numeric($_POST['placemark_edit_latitude']))
					{ ?>
						<span class="form_error"><? echo $placemarklist_lang['28']; ?></span>
			<?	}
					else if (!edit_placemark($_POST['placemark_edit_id'],$_POST['placemark_edit_name'],$_POST['placemark_edit_type'],$_POST['placemark_edit_state'],$_POST['placemark_edit_country'],$_POST['placemark_edit_longitude'],$_POST['placemark_edit_latitude'],$_POST['placemark_edit_altitude']))
					{ ?>
						<span class="form_error"><? echo $placemarklist_lang['35']; ?></span>
			<?	}
					else
					{ ?>
						<span class="form_ok"><? echo $placemarklist_lang['34']; ?></span>
			<?		unset($_POST);
					}
				}				
			}
			
			if (isset($_POST['placemark_edit']))
			{ 
				$edit_data_query = db_query("SELECT id,name,type,author,place_state,place_country,gps_longitude,gps_latitude,gps_altitude FROM placemarks WHERE id = '".db_safe_string($_POST['placemark_edit'])."' LIMIT 1");
				$edit_data = db_fetch_array($edit_data_query);
			?>
				<label for="placemark_edit_name"><? echo $placemarklist_lang['4'];?></label>
				<input type="text" id="placemark_edit_name" name="placemark_edit_name" maxlength="255" title=<? echo "\"".$placemarklist_lang['4']."\"";?> value=<? echo "\"".htmlspecialchars($edit_data['name'])."\"";?> />
										
				<label for="placemark_edit_type"><? echo $placemarklist_lang['5'];?></label>
				<select name="placemark_edit_type" id="placemark_edit_type">
					<?
					$req = db_query("SELECT id, name FROM placemark_type_enumerator ORDER BY name ASC");
					if (!$req)
					{
						die("Error connecting database: ".db_error());
					}
					
					while ($type = db_fetch_array($req))
					{
					?>
						<option value=<? echo "\"".htmlspecialchars($type["id"])."\"";?> <? if (htmlspecialchars($type["id"])==htmlspecialchars($edit_data['type'])) echo "selected=\"selected\""?>><? echo htmlspecialchars($type["name"]);?></option>
					<?
					}
					?>			
				</select>					
					
				<br/>				
				<label for="placemark_edit_state"><? echo $placemarklist_lang['7'];?></label>
				<select name="placemark_edit_state" id="placemark_edit_state">
					<?
					$req = db_query("SELECT id,name FROM country_enumerator ORDER BY name ASC");
					if (!$req)
					{
						die("Error connecting database: ".db_error());
					}
					
					while ($state = db_fetch_array($req))
					{
					?>
						<option value=<? echo "\"".htmlspecialchars($state["id"])."\"";?> <? if (htmlspecialchars($state["id"])==htmlspecialchars($edit_data['place_state'])) echo "selected=\"selected\""?>><? echo htmlspecialchars($state["name"]);?></option>
					<?
					}
					?>			
				</select>					
				
				<label for="placemark_edit_country"><? echo $placemarklist_lang['6'];?></label>
				<input type="text" id="placemark_edit_country" name="placemark_edit_country" maxlength="255" title=<? echo "\"".$placemarklist_lang['6']."\"";?> value=<? echo "\"".htmlspecialchars($edit_data['place_country'])."\"";?>/>
				
				<br/>
				<label for="placemark_edit_longitude"><? echo $placemarklist_lang['23'];?></label>
				<input type="text" id="placemark_edit_longitude" size="8" name="placemark_edit_longitude" maxlength="20" title=<? echo "\"".$placemarklist_lang['23']."\"";?> value=<? echo "\"".htmlspecialchars($edit_data['gps_longitude'])."\"";?>/>
				
				<label for="placemark_edit_latitude"><? echo $placemarklist_lang['24'];?></label>
				<input type="text" id="placemark_edit_latitude" size="8" name="placemark_edit_latitude" maxlength="20" title=<? echo "\"".$placemarklist_lang['24']."\"";?> value=<? echo "\"".htmlspecialchars($edit_data['gps_latitude'])."\"";?>/>			
				
				<label for="placemark_edit_altitude"><? echo $placemarklist_lang['25'];?></label>
				<input type="text" id="placemark_edit_altitude" size="8" name="placemark_edit_altitude" maxlength="20" title=<? echo "\"".$placemarklist_lang['25']."\"";?> value=<? echo "\"".htmlspecialchars($edit_data['gps_altitude'])."\"";?>/>
				
				<input type="hidden" id="placemark_edit_id" name="placemark_edit_id" value=<? echo "\"".htmlspecialchars($edit_data['id'])."\"";?> />
							
				<input type="submit" name="placemark_edit_submition" title=<? echo "\"".$placemarklist_lang['33']."\"";?> value=<? echo "\"".$placemarklist_lang['33']."\"";?>	/>									
			<?
			}			
			?>
			
	</fieldset>
</form>