image {
  aa 4 25 0.0005
  show-aa true
  output cognac-caustic01.png
}

lightserver {
  shadows true
  direct-samples 8
  max-depth 9
  gi false 200000 100 0.05 0.1 315
  caustics true 0.95
}

camera {
  type pinhole
  eye    19.2985 -33.3347 14.9675
  target 0 0 5
  up     0 0 1
  fov    45
  resolution 1024 768
}

shader {
  name Glass
  type glass
  ior 1.6
  color 1 1 1
}

shader {
  name Cognac
  type glass
  ior 1.333
  color 0.84 0.24 0
}

shader {
  name GlassCognac
  type glass
  ior 1.2
  color 0.84 0.24 0
}

shader {
  name Ground
  type diffuse
  texture data/textures/stonetile.jpg
}

object {
  shader Glass
  type mesh
  name GlassAir	
  2688 5120
  v 3.14717e-007 0.00970721 0.953961    0.0268067 -0.817566 -0.575211    0 0
  v 3.14717e-007 0.0976532 0.828961    0.000390791 -0.830404 -0.557162    0 0
  v 3.14717e-007 0.177564 0.703961    -0.00419555 -0.728726 -0.684793    0 0
  v 3.14717e-007 0.348546 0.578961    -0.00435893 -0.463682 -0.885991    0 0
  v 3.14717e-007 0.709707 0.453961    -0.00242227 -0.254182 -0.967153    0 0
  v 3.14717e-007 1.1883 0.366461    -0.000737675 -0.157418 -0.987532    0 0
  v 3.14717e-007 1.83096 0.278961    -1.87239e-005 -0.134339 -0.990935    0 0
  v 3.14717e-007 2.47549 0.191961    0.000739323 -0.156327 -0.987705    0 0
  v 3.14717e-007 2.95971 0.103961    0.00299277 -0.270808 -0.962629    0 0
  v 3.14717e-007 2.99141 0.0917106    0.00583989 -0.546736 -0.837285    0 0
  v 3.14717e-007 3.00358 0.0794606    -0.00135407 -0.66903 -0.743235    0 0
  v 3.14717e-007 3.01882 0.0672107    -0.0056698 -0.465325 -0.885122    0 0
  v 3.14717e-007 3.05971 0.0549607    -0.00442328 -0.154842 -0.987929    0 0
  v 3.14717e-007 3.07225 0.0547109    -0.00048545 -0.00513809 -0.999987    0 0
  v 3.14717e-007 3.09814 0.0549607    0.000803564 -0.0148258 -0.99989    0 0
  v 3.14717e-007 3.12357 0.0539608    -0.000645083 -0.0196489 -0.999807    0 0
  v 3.14717e-007 3.13471 0.0539608    -0.00795806 0.242399 -0.970144    0 0
  v 3.14717e-007 3.22846 0.103961    -0.0063855 0.682177 -0.731159    0 0
  v 3.14717e-007 3.25971 0.153961    0.0278293 0.847668 -0.529796    0 0
  v 3.14717e-007 3.22846 0.203961    0.00638564 0.682178 0.731159    0 0
  v 3.14717e-007 3.13471 0.253961    0.00362024 0.363424 0.931617    0 0
  v 3.14717e-007 2.50689 0.416961    0.00106823 0.218883 0.975751    0 0
  v 3.14717e-007 1.65221 0.578961    -0.000397479 0.198353 0.98013    0 0
  v 3.14717e-007 0.89502 0.741961    -0.00370876 0.324992 0.945709    0 0
  v 3.14717e-007 0.559707 0.903961    0.0142807 0.434976 0.900329    0 0
  v 3.14717e-007 0.549785 0.940961    0.00085995 0.942476 0.334273    0 0
  v 3.14717e-007 0.532832 0.978961    -7.23355e-005 0.915489 0.402342    0 0
  v 3.14717e-007 0.516816 1.01596    -0.00106752 0.956289 0.292423    0 0
  v 3.14717e-007 0.509707 1.05396    -0.000277824 0.995727 0.0923451    0 0
  v 3.14717e-007 0.509707 1.35396    6.13904e-007 1 0    0 0
  v 3.14717e-007 0.509707 1.65396    6.13904e-007 1 0    0 0
  v 3.14717e-007 0.509707 1.95396    6.13904e-007 1 0    0 0
  v 3.14717e-007 0.509707 2.25396    0.00031915 0.995113 -0.0987442    0 0
  v 3.14717e-007 0.524738 2.32896    0.00175692 0.938412 -0.345514    0 0
  v 3.14717e-007 0.566457 2.40396    0.00180156 0.822768 -0.568375    0 0
  v 3.14717e-007 0.629801 2.47896    0.00130279 0.725375 -0.688353    0 0
  v 3.14717e-007 0.709707 2.55396    0.00185734 0.629391 -0.777086    0 0
  v 3.14717e-007 1.1596 2.86696    0.001386 0.529476 -0.848324    0 0
  v 3.14717e-007 1.71983 3.17896    6.06946e-005 0.484697 -0.874682    0 0
  v 3.14717e-007 2.2875 3.49196    -0.00112107 0.51746 -0.855706    0 0
  v 3.14717e-007 2.75971 3.80396    -0.00177055 0.606643 -0.794972    0 0
  v 3.14717e-007 3.05853 4.06596    -0.00117856 0.696147 -0.717898    0 0
  v 3.14717e-007 3.30382 4.32896    -0.00108136 0.765384 -0.643573    0 0
  v 3.14717e-007 3.50205 4.59096    -0.000983901 0.828777 -0.559579    0 0
  v 3.14717e-007 3.65971 4.85396    -0.0010082 0.890624 -0.454739    0 0
  v 3.14717e-007 3.84146 5.27896    -0.000828048 0.947809 -0.318838    0 0
  v 3.14717e-007 3.94765 5.70396    -0.000375795 0.983724 -0.179684    0 0
  v 3.14717e-007 3.99737 6.12896    -0.000103572 0.997356 -0.0726733    0 0
  v 3.14717e-007 4.00971 6.55396    0.000138338 0.998633 0.0522612    0 0
  v 3.14717e-007 3.92572 7.17896    0.000680297 0.974467 0.224531    0 0
  v 3.14717e-007 3.71908 7.80396    0.000437336 0.936713 0.350099    0 0
  v 3.14717e-007 3.45775 8.42896    -0.000111968 0.926075 0.377339    0 0
  v 3.14717e-007 3.20971 9.05396    -0.000224244 0.936542 0.350555    0 0
  v 3.14717e-007 3.07346 9.44096    -4.27281e-005 0.944569 0.328314    0 0
  v 3.14717e-007 2.94033 9.82896    -0.000115076 0.949466 0.31387    0 0
  v 3.14717e-007 2.8169 10.217    -0.000175439 0.958499 0.285095    0 0
  v 3.14717e-007 2.70971 10.604    -0.000257291 0.972175 0.234258    0 0
  v 3.14717e-007 2.70498 10.627    -0.000175453 0.985413 0.170178    0 0
  v 3.14717e-007 2.7019 10.649    -0.000114342 0.994375 0.105919    0 0
  v 3.14717e-007 2.70022 10.672    -3.88971e-005 0.998848 0.0479822    0 0
  v 3.14717e-007 2.69971 10.694    4.79459e-006 0.999987 -0.00520284    0 0
  v 3.14717e-007 2.70018 10.708    0.000131678 0.9988 0.0489763    0 0
  v 3.14717e-007 2.69846 10.721    0.00231594 0.942371 0.334561    0 0
  v 3.14717e-007 2.68986 10.735    0.00470267 0.726661 0.68698    0 0
  v 3.14717e-007 2.66971 10.749    0.00786523 0.348821 0.937156    0 0
  v 3.14717e-007 2.6603 10.75    -0.000144208 0.110155 0.993914    0 0
  v 3.14717e-007 2.64296 10.752    0.00088527 0.0876211 0.996153    0 0
  v 3.14717e-007 2.62649 10.753    -0.00139942 0.103316 0.994648    0 0
  v 3.14717e-007 2.61971 10.754    0.00478712 0.145812 0.989301    0 0
  v 3.14717e-007 2.60264 10.717    0.00151078 -0.98295 0.183865    0 0
  v 3.14717e-007 2.60502 10.679    -0.00075564 -0.98257 -0.185891    0 0
  v 3.14717e-007 2.61725 10.641    -6.91742e-005 -0.949843 -0.312729    0 0
  v 3.14717e-007 2.62971 10.604    0.000292992 -0.957159 -0.289564    0 0
  v 3.14717e-007 2.73377 10.217    -0.000129855 -0.961809 -0.273723    0 0
  v 3.14717e-007 2.85033 9.82896    -0.000110502 -0.954383 -0.298586    0 0
  v 3.14717e-007 2.97658 9.44096    -8.64018e-005 -0.948304 -0.317363    0 0
  v 3.14717e-007 3.10971 9.05396    -0.000135589 -0.941524 -0.336946    0 0
  v 3.14717e-007 3.34213 8.42896    4.32471e-005 -0.938625 -0.344939    0 0
  v 3.14717e-007 3.56908 7.80396    0.000392608 -0.952748 -0.303761    0 0
  v 3.14717e-007 3.74135 7.17896    0.000489879 -0.982201 -0.187833    0 0
  v 3.14717e-007 3.80971 6.55396    -0.0326184 -0.993543 -0.108668    0 0
  v -0.00189346 0.00952077 0.953961    0.185816 -0.79662 -0.575212    0 0
  v -0.0190509 0.0957768 0.828961    0.162394 -0.81437 -0.557162    0 0
  v -0.0346407 0.174152 0.703961    0.138055 -0.715541 -0.684793    0 0
  v -0.0679977 0.341849 0.578961    0.0861849 -0.455623 -0.885991    0 0
  v -0.138457 0.696071 0.453961    0.0472127 -0.24977 -0.967153    0 0
  v -0.231826 1.16547 0.366461    0.0299872 -0.154537 -0.987532    0 0
  v -0.357202 1.79578 0.278961    0.0261899 -0.131761 -0.990935    0 0
  v -0.482943 2.42792 0.191961    0.0312231 -0.153179 -0.987705    0 0
  v -0.57741 2.90284 0.103961    0.0557672 -0.26502 -0.962629    0 0
  v -0.583595 2.93393 0.0917106    0.112391 -0.535091 -0.837285    0 0
  v -0.58597 2.94587 0.0794606    0.129193 -0.656438 -0.743235    0 0
  v -0.588942 2.96081 0.0672107    0.0852193 -0.457489 -0.885122    0 0
  v -0.596919 3.00092 0.0549607    0.0258699 -0.15273 -0.987929    0 0
  v -0.599365 3.01321 0.0547109    0.00052628 -0.00513415 -0.999987    0 0
  v -0.604418 3.03861 0.0549607    0.0036805 -0.0143841 -0.99989    0 0
  v -0.609379 3.06356 0.0539608    0.00320062 -0.0193972 -0.999807    0 0
  v -0.611551 3.07447 0.0539608    -0.0550948 0.236189 -0.970144    0 0
  v -0.62984 3.16642 0.103961    -0.139349 0.667823 -0.731159    0 0
  v -0.635937 3.19707 0.153961    -0.138077 0.836809 -0.529797    0 0
  v -0.62984 3.16642 0.203961    -0.126823 0.670315 0.731159    0 0
  v -0.611551 3.07447 0.253961    -0.0673499 0.357148 0.931617    0 0
  v -0.48907 2.45872 0.416961    -0.0416542 0.214886 0.975751    0 0
  v -0.322329 1.62046 0.578961    -0.0390867 0.194465 0.98013    0 0
  v -0.174609 0.877823 0.741961    -0.0670405 0.318024 0.94571    0 0
  v -0.109193 0.548953 0.903961    -0.0708535 0.429404 0.900329    0 0
  v -0.107257 0.539221 0.940961    -0.183025 0.924534 0.334273    0 0
  v -0.10395 0.522594 0.978961    -0.178675 0.897884 0.402342    0 0
  v -0.100826 0.506886 1.01596    -0.187611 0.937705 0.292422    0 0
  v -0.0994386 0.499913 1.05396    -0.19453 0.97654 0.092345    0 0
  v -0.0994386 0.499913 1.35396    -0.19509 0.980785 0    0 0
  v -0.0994386 0.499913 1.65396    -0.19509 0.980785 0    0 0
  v -0.0994386 0.499913 1.95396    -0.19509 0.980785 0    0 0
  v -0.0994386 0.499913 2.25396    -0.193824 0.976054 -0.0987442    0 0
  v -0.102371 0.514656 2.32896    -0.181352 0.920723 -0.345514    0 0
  v -0.11051 0.555573 2.40396    -0.158748 0.80731 -0.568375    0 0
  v -0.122868 0.6177 2.47896    -0.140236 0.711691 -0.688353    0 0
  v -0.138457 0.696071 2.55396    -0.120967 0.61766 -0.777086    0 0
  v -0.226225 1.13731 2.86696    -0.101936 0.519573 -0.848324    0 0
  v -0.335521 1.68678 3.17896    -0.0945002 0.475396 -0.874682    0 0
  v -0.446268 2.24354 3.49196    -0.102051 0.507299 -0.855706    0 0
  v -0.538392 2.70668 3.80396    -0.120087 0.594641 -0.794972    0 0
  v -0.59669 2.99976 4.06596    -0.136967 0.682541 -0.717898    0 0
  v -0.644543 3.24034 4.32896    -0.15038 0.750467 -0.643573    0 0
  v -0.683217 3.43476 4.59096    -0.162651 0.81266 -0.559579    0 0
  v -0.713973 3.58939 4.85396    -0.174741 0.873314 -0.454739    0 0
  v -0.749431 3.76765 5.27896    -0.185721 0.929435 -0.318838    0 0
  v -0.770149 3.8718 5.70396    -0.192284 0.964749 -0.179684    0 0
  v -0.779849 3.92057 6.12896    -0.194676 0.978172 -0.0726731    0 0
  v -0.782255 3.93266 6.55396    -0.194688 0.979472 0.0522611    0 0
  v -0.76587 3.85029 7.17896    -0.189442 0.955875 0.22453    0 0
  v -0.725557 3.64762 7.80396    -0.182315 0.918799 0.350099    0 0
  v -0.674574 3.39131 8.42896    -0.180778 0.908259 0.377339    0 0
  v -0.626182 3.14803 9.05396    -0.18293 0.918503 0.350555    0 0
  v -0.599601 3.0144 9.44096    -0.184318 0.926411 0.328314    0 0
  v -0.57363 2.88383 9.82896    -0.185344 0.9312 0.31387    0 0
  v -0.549549 2.76277 10.217    -0.187166 0.940048 0.285095    0 0
  v -0.528637 2.65764 10.604    -0.189914 0.953444 0.234258    0 0
  v -0.527715 2.653 10.627    -0.192417 0.966445 0.170177    0 0
  v -0.527113 2.64998 10.649    -0.194105 0.975246 0.105919    0 0
  v -0.526786 2.64833 10.672    -0.194904 0.979648 0.0479815    0 0
  v -0.526686 2.64783 10.694    -0.195083 0.980773 -0.00520178    0 0
  v -0.526778 2.64829 10.708    -0.194727 0.979634 0.0489753    0 0
  v -0.526443 2.64661 10.721    -0.181576 0.924716 0.33456    0 0
  v -0.524766 2.63818 10.735    -0.137153 0.713617 0.686979    0 0
  v -0.520834 2.61841 10.749    -0.0603374 0.343653 0.937156    0 0
  v -0.518999 2.60918 10.75    -0.0216315 0.10801 0.993915    0 0
  v -0.515615 2.59217 10.752    -0.0162258 0.0861102 0.996153    0 0
  v -0.512402 2.57602 10.753    -0.0215285 0.101058 0.994648    0 0
  v -0.511079 2.56937 10.754    -0.0237516 0.143945 0.989301    0 0
  v -0.507749 2.55263 10.717    0.193246 -0.963769 0.183864    0 0
  v -0.508214 2.55497 10.679    0.190949 -0.963838 -0.18589    0 0
  v -0.510599 2.56696 10.641    0.185237 -0.931605 -0.31273    0 0
  v -0.51303 2.57918 10.604    0.18702 -0.93871 -0.289564    0 0
  v -0.533332 2.68124 10.217    0.187512 -0.943353 -0.273723    0 0
  v -0.556072 2.79556 9.82896    0.186083 -0.936066 -0.298586    0 0
  v -0.580702 2.91939 9.44096    0.18492 -0.9301 -0.317363    0 0
  v -0.606673 3.04995 9.05396    0.183549 -0.923459 -0.336946    0 0
  v -0.652017 3.27791 8.42896    0.183159 -0.920581 -0.344939    0 0
  v -0.696293 3.5005 7.80396    0.186257 -0.934365 -0.303761    0 0
  v -0.729901 3.66946 7.17896    0.192098 -0.963232 -0.187833    0 0
  v -0.743237 3.7365 6.55396    0.161839 -0.980816 -0.108668    0 0
  v -0.00371447 0.00896835 0.953961    0.337683 -0.745051 -0.575213    0 0
  v -0.0373699 0.0902197 0.828961    0.318155 -0.767039 -0.557162    0 0
  v -0.0679505 0.164048 0.703961    0.274997 -0.67486 -0.684793    0 0
  v -0.133383 0.322015 0.578961    0.173417 -0.430054 -0.885991    0 0
  v -0.271593 0.655684 0.453961    0.0950333 -0.23576 -0.967153    0 0
  v -0.454743 1.09785 0.366461    0.0595596 -0.145717 -0.987532    0 0
  v -0.700677 1.69158 0.278961    0.051392 -0.12412 -0.990935    0 0
  v -0.947328 2.28705 0.191961    0.060507 -0.144145 -0.987705    0 0
  v -1.13263 2.73441 0.103961    0.106399 -0.249048 -0.962629    0 0
  v -1.14476 2.7637 0.0917106    0.214622 -0.502883 -0.837285    0 0
  v -1.14942 2.77495 0.0794606    0.254776 -0.618622 -0.743233    0 0
  v -1.15525 2.78902 0.0672107    0.172834 -0.432074 -0.885122    0 0
  v -1.1709 2.8268 0.0549607    0.0551688 -0.144748 -0.987929    0 0
  v -1.1757 2.83839 0.0547109    0.0015178 -0.00493286 -0.999987    0 0
  v -1.18561 2.86231 0.0549607    0.006416 -0.0133898 -0.99989    0 0
  v -1.19534 2.88581 0.0539608    0.00692334 -0.0184001 -0.999807    0 0
  v -1.1996 2.89609 0.0539608    -0.100114 0.220902 -0.970144    0 0
  v -1.23548 2.98271 0.103961    -0.266958 0.627806 -0.731158    0 0
  v -1.24744 3.01158 0.153961    -0.298678 0.793793 -0.529797    0 0
  v -1.23548 2.98271 0.203961    -0.255158 0.632693 0.731159    0 0
  v -1.1996 2.89609 0.253961    -0.135732 0.337146 0.931617    0 0
  v -0.959347 2.31607 0.416961    -0.0827759 0.20263 0.975751    0 0
  v -0.632272 1.52644 0.578961    -0.0762737 0.183103 0.98013    0 0
  v -0.342509 0.826891 0.741961    -0.127795 0.298834 0.945709    0 0
  v -0.21419 0.517102 0.903961    -0.153265 0.40733 0.900329    0 0
  v -0.210393 0.507935 0.940961    -0.359876 0.871063 0.334273    0 0
  v -0.203906 0.492273 0.978961    -0.35041 0.845774 0.402343    0 0
  v -0.197777 0.477476 1.01596    -0.366943 0.883087 0.292422    0 0
  v -0.195056 0.470908 1.05396    -0.381306 0.919825 0.0923445    0 0
  v -0.195056 0.470908 1.35396    -0.382684 0.923879 0    0 0
  v -0.195056 0.470908 1.65396    -0.382684 0.923879 0    0 0
  v -0.195056 0.470908 1.95396    -0.382684 0.923879 0    0 0
  v -0.195056 0.470908 2.25396    -0.380519 0.919486 -0.0987443    0 0
  v -0.200808 0.484795 2.32896    -0.357492 0.867652 -0.345514    0 0
  v -0.216774 0.523338 2.40396    -0.313196 0.760828 -0.568374    0 0
  v -0.241014 0.58186 2.47896    -0.276386 0.670657 -0.688353    0 0
  v -0.271593 0.655684 2.55396    -0.239142 0.582192 -0.777087    0 0
  v -0.443758 1.07133 2.86696    -0.201341 0.489703 -0.848324    0 0
  v -0.658149 1.58891 3.17896    -0.18543 0.447825 -0.874682    0 0
  v -0.875387 2.11337 3.49196    -0.199059 0.477642 -0.855706    0 0
  v -1.05609 2.54964 3.80396    -0.233788 0.559788 -0.794972    0 0
  v -1.17045 2.82571 4.06596    -0.267493 0.642705 -0.717898    0 0
  v -1.26432 3.05233 4.32896    -0.293899 0.706709 -0.643573    0 0
  v -1.34018 3.23548 4.59096    -0.318068 0.765313 -0.559579    0 0
  v -1.40051 3.38113 4.85396    -0.341759 0.822443 -0.454739    0 0
  v -1.47006 3.54905 5.27896    -0.363476 0.875344 -0.318838    0 0
  v -1.5107 3.64716 5.70396    -0.376802 0.908699 -0.179684    0 0
  v -1.52973 3.69309 6.12896    -0.381767 0.921397 -0.0726732    0 0
  v -1.53445 3.70449 6.55396    -0.382033 0.92267 0.0522612    0 0
  v -1.50231 3.6269 7.17896    -0.372284 0.90055 0.22453    0 0
  v -1.42323 3.43598 7.80396    -0.35806 0.865577 0.350099    0 0
  v -1.32322 3.19455 8.42896    -0.354497 0.855539 0.377339    0 0
  v -1.2283 2.96538 9.05396    -0.358606 0.865166 0.350555    0 0
  v -1.17616 2.8395 9.44096    -0.36151 0.872651 0.328314    0 0
  v -1.12522 2.71651 9.82896    -0.363451 0.877148 0.31387    0 0
  v -1.07798 2.60247 10.217    -0.366964 0.885471 0.285095    0 0
  v -1.03696 2.50344 10.604    -0.372272 0.898073 0.234259    0 0
  v -1.03515 2.49908 10.627    -0.377263 0.910336 0.170179    0 0
  v -1.03397 2.49623 10.649    -0.380636 0.918639 0.105919    0 0
  v -1.03333 2.49467 10.672    -0.382279 0.9228 0.0479809    0 0
  v -1.03313 2.4942 10.694    -0.382674 0.923869 -0.00520635    0 0
  v -1.03331 2.49464 10.708    -0.382102 0.922821 0.0489785    0 0
  v -1.03265 2.49305 10.721    -0.35849 0.871523 0.334564    0 0
  v -1.02937 2.48511 10.735    -0.273736 0.673146 0.686981    0 0
  v -1.02165 2.46649 10.749    -0.126222 0.32528 0.937156    0 0
  v -1.01805 2.4578 10.75    -0.0422874 0.101714 0.993915    0 0
  v -1.01142 2.44177 10.752    -0.0327131 0.0812898 0.996154    0 0
  v -1.00511 2.42656 10.753    -0.0408301 0.0949158 0.994648    0 0
  v -1.00252 2.42029 10.754    -0.0513768 0.136544 0.989301    0 0
  v -0.995986 2.40452 10.717    0.377555 -0.90755 0.183863    0 0
  v -0.996898 2.40672 10.679    0.375315 -0.908065 -0.185891    0 0
  v -1.00158 2.41802 10.641    0.363425 -0.877567 -0.312728    0 0
  v -1.00635 2.42953 10.604    0.366559 -0.884187 -0.289565    0 0
  v -1.04617 2.52567 10.217    0.367948 -0.888645 -0.273723    0 0
  v -1.09077 2.63336 9.82896    0.365124 -0.881777 -0.298586    0 0
  v -1.13909 2.75 9.44096    0.36282 -0.876152 -0.317363    0 0
  v -1.19003 2.87299 9.05396    0.36018 -0.869907 -0.336946    0 0
  v -1.27898 3.08772 8.42896    0.359236 -0.86716 -0.344939    0 0
  v -1.36583 3.2974 7.80396    0.364964 -0.880074 -0.303761    0 0
  v -1.43175 3.45655 7.17896    0.376324 -0.907248 -0.187833    0 0
  v -1.45791 3.51971 6.55396    0.350077 -0.930396 -0.108668    0 0
  v -0.00539272 0.00807118 0.953961    0.476535 -0.664866 -0.575211    0 0
  v -0.0542529 0.0811956 0.828961    0.461689 -0.690227 -0.557162    0 0
  v -0.098649 0.147639 0.703961    0.401371 -0.608243 -0.684793    0 0
  v -0.193642 0.289806 0.578961    0.253983 -0.387959 -0.885991    0 0
  v -0.394292 0.5901 0.453961    0.139202 -0.21269 -0.967153    0 0
  v -0.660185 0.988036 0.366461    0.0868432 -0.131298 -0.987532    0 0
  v -1.01722 1.52239 0.278961    0.0746192 -0.111709 -0.990935    0 0
  v -1.37531 2.05829 0.191961    0.0874656 -0.129571 -0.987705    0 0
  v -1.64432 2.46091 0.103961    0.152941 -0.223505 -0.962629    0 0
  v -1.66194 2.48727 0.0917106    0.308607 -0.451351 -0.837284    0 0
  v -1.6687 2.49739 0.0794606    0.370568 -0.557031 -0.743234    0 0
  v -1.67716 2.51005 0.0672107    0.253807 -0.390055 -0.885121    0 0
  v -1.69988 2.54405 0.0549607    0.0823475 -0.131203 -0.987929    0 0
  v -1.70685 2.55448 0.0547109    0.002451 -0.00454199 -0.999987    0 0
  v -1.72124 2.57601 0.0549607    0.008905 -0.0118809 -0.99989    0 0
  v -1.73536 2.59716 0.0539608    0.01038 -0.0166959 -0.999807    0 0
  v -1.74155 2.60641 0.0539608    -0.141286 0.197126 -0.970144    0 0
  v -1.79363 2.68436 0.103961    -0.384307 0.563663 -0.731158    0 0
  v -1.811 2.71035 0.153961    -0.4478 0.720272 -0.529795    0 0
  v -1.79363 2.68436 0.203961    -0.373688 0.570758 0.731158    0 0
  v -1.74155 2.60641 0.253961    -0.198898 0.304188 0.931617    0 0
  v -1.39276 2.08441 0.416961    -0.120717 0.182588 0.975751    0 0
  v -0.917917 1.37376 0.578961    -0.11053 0.164704 0.98013    0 0
  v -0.497246 0.744182 0.741961    -0.18364 0.26816 0.94571    0 0
  v -0.310956 0.46538 0.903961    -0.229786 0.369603 0.900329    0 0
  v -0.305444 0.45713 0.940961    -0.522897 0.784118 0.334273    0 0
  v -0.296025 0.443034 0.978961    -0.508679 0.761161 0.402343    0 0
  v -0.287127 0.429717 1.01596    -0.532173 0.794531 0.292424    0 0
  v -0.283178 0.423806 1.05396    -0.553428 0.827762 0.0923451    0 0
  v -0.283178 0.423806 1.35396    -0.55557 0.83147 0    0 0
  v -0.283178 0.423806 1.65396    -0.55557 0.83147 0    0 0
  v -0.283178 0.423806 1.95396    -0.55557 0.83147 0    0 0
  v -0.283178 0.423806 2.25396    -0.55259 0.827583 -0.0987444    0 0
  v -0.291529 0.436304 2.32896    -0.519893 0.781237 -0.345514    0 0
  v -0.314706 0.470992 2.40396    -0.455608 0.685107 -0.568375    0 0
  v -0.349899 0.523661 2.47896    -0.401914 0.603851 -0.688353    0 0
  v -0.394292 0.5901 2.55396    -0.348127 0.524351 -0.777086    0 0
  v -0.644236 0.964168 2.86696    -0.293009 0.441013 -0.848324    0 0
  v -0.955484 1.42998 3.17896    -0.269233 0.403045 -0.874682    0 0
  v -1.27087 1.90198 3.49196    -0.288418 0.42963 -0.855706    0 0
  v -1.53321 2.29461 3.80396    -0.338505 0.503422 -0.794972    0 0
  v -1.69923 2.54308 4.06596    -0.387738 0.57817 -0.717898    0 0
  v -1.8355 2.74703 4.32896    -0.426124 0.635793 -0.643573    0 0
  v -1.94564 2.91185 4.59096    -0.461262 0.688556 -0.559579    0 0
  v -2.03322 3.04294 4.85396    -0.495642 0.739967 -0.454739    0 0
  v -2.1342 3.19406 5.27896    -0.527263 0.787614 -0.318838    0 0
  v -2.1932 3.28235 5.70396    -0.54684 0.817728 -0.179684    0 0
  v -2.22082 3.3237 6.12896    -0.554187 0.829214 -0.0726729    0 0
  v -2.22767 3.33395 6.55396    -0.554696 0.83041 0.0522613    0 0
  v -2.18101 3.26412 7.17896    -0.540819 0.810618 0.22453    0 0
  v -2.06621 3.0923 7.80396    -0.520046 0.779091 0.350099    0 0
  v -1.92102 2.87502 8.42896    -0.514593 0.769941 0.377339    0 0
  v -1.78322 2.66877 9.05396    -0.520501 0.778582 0.350555    0 0
  v -1.70752 2.55549 9.44096    -0.52481 0.785356 0.328314    0 0
  v -1.63356 2.4448 9.82896    -0.527591 0.789388 0.31387    0 0
  v -1.56498 2.34216 10.217    -0.53266 0.796866 0.285095    0 0
  v -1.50543 2.25304 10.604    -0.540325 0.80819 0.23426    0 0
  v -1.50281 2.24911 10.627    -0.547612 0.819244 0.170179    0 0
  v -1.50109 2.24654 10.649    -0.55254 0.826729 0.105919    0 0
  v -1.50016 2.24515 10.672    -0.554962 0.83049 0.0479834    0 0
  v -1.49988 2.24472 10.694    -0.555559 0.831461 -0.00520674    0 0
  v -1.50014 2.24511 10.708    -0.554794 0.830545 0.0489747    0 0
  v -1.49918 2.24369 10.721    -0.521627 0.784839 0.334563    0 0
  v -1.49441 2.23654 10.735    -0.399801 0.606808 0.686981    0 0
  v -1.48321 2.21978 10.749    -0.187255 0.294404 0.937156    0 0
  v -1.47798 2.21196 10.75    -0.0613185 0.0915101 0.993914    0 0
  v -1.46835 2.19754 10.752    -0.0479435 0.0733459 0.996154    0 0
  v -1.4592 2.18385 10.753    -0.0585633 0.0851273 0.994648    0 0
  v -1.45543 2.17821 10.754    -0.0770288 0.123898 0.989301    0 0
  v -1.44595 2.16401 10.717    0.547354 -0.816454 0.183866    0 0
  v -1.44727 2.166 10.679    0.545259 -0.817397 -0.185891    0 0
  v -1.45406 2.17616 10.641    0.527647 -0.789804 -0.312728    0 0
  v -1.46099 2.18652 10.604    0.532012 -0.795685 -0.289564    0 0
  v -1.5188 2.27305 10.217    0.534244 -0.799787 -0.273723    0 0
  v -1.58356 2.36996 9.82896    0.530135 -0.793602 -0.298587    0 0
  v -1.6537 2.47494 9.44096    0.526778 -0.788534 -0.317363    0 0
  v -1.72766 2.58563 9.05396    0.52297 -0.782924 -0.336946    0 0
  v -1.85679 2.77888 8.42896    0.521508 -0.780414 -0.344939    0 0
  v -1.98288 2.96758 7.80396    0.529645 -0.791963 -0.303761    0 0
  v -2.07858 3.11082 7.17896    0.546089 -0.816398 -0.187833    0 0
  v -2.11656 3.16766 6.55396    0.524861 -0.844223 -0.108668    0 0
  v -0.00686371 0.00686407 0.953961    0.597078 -0.559133 -0.575212    0 0
  v -0.0690509 0.0690513 0.828961    0.587465 -0.586904 -0.557162    0 0
  v -0.125556 0.125557 0.703961    0.512321 -0.518252 -0.684793    0 0
  v -0.246459 0.246459 0.578961    0.324791 -0.330954 -0.885991    0 0
  v -0.501839 0.501839 0.453961    0.178021 -0.181446 -0.967153    0 0
  v -0.840255 0.840256 0.366461    0.11079 -0.111833 -0.987532    0 0
  v -1.29468 1.29468 0.278961    0.0949788 -0.0950052 -0.990935    0 0
  v -1.75043 1.75043 0.191961    0.111063 -0.110017 -0.987705    0 0
  v -2.09283 2.09283 0.103961    0.193606 -0.189373 -0.962629    0 0
  v -2.11525 2.11525 0.0917106    0.390733 -0.382474 -0.837283    0 0
  v -2.12385 2.12385 0.0794606    0.472119 -0.474034 -0.743233    0 0
  v -2.13463 2.13463 0.0672107    0.325025 -0.333043 -0.885122    0 0
  v -2.16354 2.16354 0.0549607    0.106362 -0.112617 -0.987929    0 0
  v -2.17241 2.17241 0.0547109    0.00328994 -0.00397648 -0.999987    0 0
  v -2.19072 2.19072 0.0549607    0.0110518 -0.00991537 -0.99989    0 0
  v -2.2087 2.2087 0.0539608    0.0134379 -0.0143502 -0.999807    0 0
  v -2.21657 2.21657 0.0539608    -0.177029 0.165775 -0.970144    0 0
  v -2.28286 2.28286 0.103961    -0.486888 0.477857 -0.731158    0 0
  v -2.30496 2.30496 0.153961    -0.579714 0.619071 -0.529796    0 0
  v -2.28286 2.28286 0.203961    -0.477857 0.486888 0.731158    0 0
  v -2.21657 2.21657 0.253961    -0.25442 0.25954 0.931617    0 0
  v -1.77264 1.77264 0.416961    -0.154018 0.155529 0.975751    0 0
  v -1.16829 1.16829 0.578961    -0.140538 0.139976 0.98013    0 0
  v -0.632875 0.632875 0.741961    -0.232427 0.227182 0.945709    0 0
  v -0.395772 0.395773 0.903961    -0.297477 0.317672 0.900329    0 0
  v -0.388756 0.388757 0.940961    -0.665823 0.667039 0.334273    0 0
  v -0.376769 0.376769 0.978961    -0.6474 0.647297 0.402342    0 0
  v -0.365444 0.365444 1.01596    -0.676953 0.675443 0.292424    0 0
  v -0.360417 0.360417 1.05396    -0.704282 0.703888 0.0923455    0 0
  v -0.360417 0.360417 1.35396    -0.707107 0.707107 0    0 0
  v -0.360417 0.360417 1.65396    -0.707107 0.707107 0    0 0
  v -0.360417 0.360417 1.95396    -0.707107 0.707107 0    0 0
  v -0.360417 0.360417 2.25396    -0.703426 0.703876 -0.0987446    0 0
  v -0.371046 0.371046 2.32896    -0.662315 0.6648 -0.345514    0 0
  v -0.400545 0.400546 2.40396    -0.580511 0.583058 -0.568375    0 0
  v -0.445336 0.445337 2.47896    -0.511997 0.513838 -0.688353    0 0
  v -0.501839 0.501839 2.55396    -0.443734 0.44636 -0.777087    0 0
  v -0.819957 0.819958 2.86696    -0.373416 0.375376 -0.848324    0 0
  v -1.2161 1.2161 3.17896    -0.34269 0.342776 -0.874682    0 0
  v -1.6175 1.6175 3.49196    -0.366692 0.365107 -0.855706    0 0
  v -1.95141 1.95141 3.80396    -0.430214 0.42771 -0.794972    0 0
  v -2.16271 2.16271 4.06596    -0.493084 0.491417 -0.717898    0 0
  v -2.33615 2.33615 4.32896    -0.541973 0.540444 -0.643573    0 0
  v -2.47633 2.47633 4.59096    -0.586729 0.585338 -0.559579    0 0
  v -2.5878 2.5878 4.85396    -0.630479 0.629053 -0.454739    0 0
  v -2.71632 2.71632 5.27896    -0.670788 0.669617 -0.318838    0 0
  v -2.79141 2.79141 5.70396    -0.695864 0.695333 -0.179684    0 0
  v -2.82657 2.82657 6.12896    -0.70531 0.705164 -0.0726731    0 0
  v -2.83529 2.83529 6.55396    -0.706043 0.706238 0.0522614    0 0
  v -2.77591 2.77591 7.17896    -0.688571 0.689533 0.22453    0 0
  v -2.62979 2.62979 7.80396    -0.662046 0.662665 0.350099    0 0
  v -2.445 2.445 8.42896    -0.654913 0.654755 0.377339    0 0
  v -2.26961 2.26961 9.05396    -0.662394 0.662077 0.350555    0 0
  v -2.17326 2.17326 9.44096    -0.667941 0.667881 0.328314    0 0
  v -2.07913 2.07913 9.82896    -0.671455 0.671293 0.31387    0 0
  v -1.99185 1.99185 10.217    -0.677885 0.677637 0.285095    0 0
  v -1.91605 1.91605 10.604    -0.687613 0.687249 0.234258    0 0
  v -1.91271 1.91271 10.627    -0.696916 0.696668 0.17018    0 0
  v -1.91053 1.91053 10.649    -0.70321 0.703048 0.105916    0 0
  v -1.90934 1.90934 10.672    -0.70632 0.706265 0.0479812    0 0
  v -1.90898 1.90898 10.694    -0.707094 0.707101 -0.00520122    0 0
  v -1.90931 1.90931 10.708    -0.706165 0.706351 0.0489768    0 0
  v -1.9081 1.9081 10.721    -0.664719 0.667994 0.334564    0 0
  v -1.90202 1.90202 10.735    -0.510502 0.517152 0.68698    0 0
  v -1.88777 1.88777 10.749    -0.241092 0.252216 0.937156    0 0
  v -1.88112 1.88112 10.75    -0.077993 0.0777891 0.993914    0 0
  v -1.86885 1.86885 10.752    -0.0613314 0.0625833 0.996153    0 0
  v -1.85721 1.85721 10.753    -0.0740451 0.072066 0.994648    0 0
  v -1.85241 1.85241 10.754    -0.0997203 0.10649 0.989301    0 0
  v -1.84034 1.84034 10.717    0.696119 -0.693983 0.183864    0 0
  v -1.84203 1.84203 10.679    0.694248 -0.695317 -0.185889    0 0
  v -1.85067 1.85067 10.641    0.671591 -0.671689 -0.31273    0 0
  v -1.85948 1.85948 10.604    0.67702 -0.676606 -0.289564    0 0
  v -1.93307 1.93307 10.217    0.680009 -0.680193 -0.273723    0 0
  v -2.01549 2.01549 9.82896    0.674772 -0.674929 -0.298587    0 0
  v -2.10476 2.10476 9.44096    0.670491 -0.670613 -0.317363    0 0
  v -2.19889 2.19889 9.05396    0.665662 -0.665854 -0.336946    0 0
  v -2.36324 2.36324 8.42896    0.663739 -0.663678 -0.344939    0 0
  v -2.52372 2.52372 7.80396    0.673972 -0.673417 -0.303761    0 0
  v -2.64553 2.64553 7.17896    0.694867 -0.694174 -0.187833    0 0
  v -2.69387 2.69387 6.55396    0.679476 -0.725605 -0.108668    0 0
  v -0.00807096 0.00539303 0.953961    0.694696 -0.43189 -0.575212    0 0
  v -0.0811953 0.0542531 0.828961    0.69068 -0.461011 -0.557162    0 0
  v -0.147639 0.0986493 0.703961    0.603583 -0.408345 -0.684793    0 0
  v -0.289805 0.193642 0.578961    0.383116 -0.261231 -0.885991    0 0
  v -0.5901 0.394292 0.453961    0.209999 -0.14323 -0.967153    0 0
  v -0.988036 0.660185 0.366461    0.130478 -0.0880699 -0.987532    0 0
  v -1.52239 1.01723 0.278961    0.111688 -0.0746503 -0.990935    0 0
  v -2.05829 1.37531 0.191961    0.130392 -0.0862361 -0.987705    0 0
  v -2.46091 1.64433 0.103961    0.226831 -0.147964 -0.962629    0 0
  v -2.48727 1.66194 0.0917106    0.457839 -0.298895 -0.837285    0 0
  v -2.49739 1.6687 0.0794606    0.555527 -0.37282 -0.743232    0 0
  v -2.51005 1.67716 0.0672107    0.383752 -0.263234 -0.885123    0 0
  v -2.54405 1.69988 0.0549607    0.126289 -0.0897033 -0.987929    0 0
  v -2.55448 1.70685 0.0547109    0.00400251 -0.00325824 -0.999987    0 0
  v -2.57601 1.72124 0.0549607    0.0127738 -0.00756873 -0.99989    0 0
  v -2.59716 1.73536 0.0539608    0.0159792 -0.0114528 -0.999807    0 0
  v -2.60641 1.74155 0.0539608    -0.205968 0.128052 -0.970144    0 0
  v -2.68436 1.79363 0.103961    -0.570758 0.373688 -0.731158    0 0
  v -2.71035 1.811 0.153961    -0.68935 0.494079 -0.529795    0 0
  v -2.68436 1.79363 0.203961    -0.563662 0.384307 0.731158    0 0
  v -2.60641 1.74155 0.253961    -0.300165 0.204918 0.931617    0 0
  v -2.08441 1.39276 0.416961    -0.181401 0.122493 0.975751    0 0
  v -1.37376 0.917917 0.578961    -0.165146 0.109869 0.98013    0 0
  v -0.744182 0.497247 0.741961    -0.272281 0.177472 0.94571    0 0
  v -0.465379 0.310957 0.903961    -0.353735 0.253533 0.900329    0 0
  v -0.457129 0.305444 0.940961    -0.783162 0.524326 0.334273    0 0
  v -0.443033 0.296026 0.978961    -0.761242 0.508558 0.402342    0 0
  v -0.429717 0.287128 1.01596    -0.795718 0.530397 0.292424    0 0
  v -0.423806 0.283178 1.05396    -0.828071 0.552965 0.092346    0 0
  v -0.423806 0.283178 1.35396    -0.83147 0.55557 0    0 0
  v -0.423806 0.283178 1.65396    -0.83147 0.55557 0    0 0
  v -0.423806 0.283178 1.95396    -0.83147 0.55557 0    0 0
  v -0.423806 0.283178 2.25396    -0.827229 0.55312 -0.0987445    0 0
  v -0.436304 0.291529 2.32896    -0.779285 0.522814 -0.345515    0 0
  v -0.470992 0.314707 2.40396    -0.683106 0.458603 -0.568375    0 0
  v -0.52366 0.349899 2.47896    -0.602404 0.40408 -0.688353    0 0
  v -0.5901 0.394292 2.55396    -0.522288 0.351215 -0.777087    0 0
  v -0.964168 0.644237 2.86696    -0.439473 0.295314 -0.848324    0 0
  v -1.42998 0.955484 3.17896    -0.402977 0.269334 -0.874682    0 0
  v -1.90198 1.27087 3.49196    -0.430875 0.286553 -0.855706    0 0
  v -2.29461 1.53321 3.80396    -0.505389 0.335561 -0.794972    0 0
  v -2.54308 1.69923 4.06596    -0.57948 0.385778 -0.717898    0 0
  v -2.74703 1.8355 4.32896    -0.636994 0.424325 -0.643573    0 0
  v -2.91185 1.94564 4.59096    -0.689649 0.459626 -0.559579    0 0
  v -3.04294 2.03322 4.85396    -0.741087 0.493966 -0.454739    0 0
  v -3.19406 2.1342 5.27896    -0.788534 0.525886 -0.318838    0 0
  v -3.28235 2.1932 5.70396    -0.818146 0.546216 -0.179684    0 0
  v -3.3237 2.22082 6.12896    -0.829329 0.554015 -0.0726732    0 0
  v -3.33395 2.22767 6.55396    -0.830257 0.554926 0.0522614    0 0
  v -3.26412 2.18101 7.17896    -0.809862 0.54195 0.22453    0 0
  v -3.0923 2.06621 7.80396    -0.778605 0.520773 0.350099    0 0
  v -2.87502 1.92103 8.42896    -0.770065 0.514407 0.377339    0 0
  v -2.66877 1.78322 9.05396    -0.778831 0.520128 0.350555    0 0
  v -2.55549 1.70752 9.44096    -0.785404 0.524739 0.328314    0 0
  v -2.4448 1.63356 9.82896    -0.789516 0.527399 0.31387    0 0
  v -2.34216 1.56498 10.217    -0.79706 0.532368 0.285095    0 0
  v -2.25304 1.50543 10.604    -0.808477 0.539897 0.234256    0 0
  v -2.24911 1.50281 10.627    -0.819438 0.54732 0.17018    0 0
  v -2.24654 1.50109 10.649    -0.826856 0.55235 0.105919    0 0
  v -2.24515 1.50016 10.672    -0.830534 0.554898 0.0479781    0 0
  v -2.24472 1.49988 10.694    -0.831456 0.555567 -0.00520016    0 0
  v -2.24511 1.50014 10.708    -0.830398 0.555013 0.0489804    0 0
  v -2.24369 1.49918 10.721    -0.782265 0.525478 0.334564    0 0
  v -2.23654 1.49441 10.735    -0.601585 0.407622 0.686979    0 0
  v -2.21978 1.48321 10.749    -0.285665 0.200335 0.937156    0 0
  v -2.21196 1.47798 10.75    -0.0916703 0.0610787 0.993914    0 0
  v -2.19754 1.46835 10.752    -0.0723623 0.0494156 0.996154    0 0
  v -2.18385 1.4592 10.753    -0.0866811 0.0562354 0.994648    0 0
  v -2.17821 1.45543 10.754    -0.118578 0.0849888 0.989301    0 0
  v -2.16401 1.44595 10.717    0.818133 -0.544842 0.183863    0 0
  v -2.166 1.44727 10.679    0.816557 -0.546515 -0.18589    0 0
  v -2.17616 1.45406 10.641    0.789727 -0.527762 -0.312729    0 0
  v -2.18652 1.46099 10.604    0.796011 -0.531525 -0.289564    0 0
  v -2.27305 1.5188 10.217    0.799642 -0.53446 -0.273723    0 0
  v -2.36996 1.58356 9.82896    0.793479 -0.530318 -0.298586    0 0
  v -2.47494 1.6537 9.44096    0.788438 -0.526921 -0.317363    0 0
  v -2.58563 1.72766 9.05396    0.782773 -0.523195 -0.336946    0 0
  v -2.77888 1.85679 8.42896    0.780462 -0.521436 -0.344939    0 0
  v -2.96758 1.98288 7.80396    0.792399 -0.528992 -0.303761    0 0
  v -3.11082 2.07858 7.17896    0.816942 -0.545274 -0.187833    0 0
  v -3.16766 2.11656 6.55396    0.807979 -0.579104 -0.108668    0 0
  v -0.00896794 0.0037148 0.953961    0.765606 -0.28806 -0.575212    0 0
  v -0.0902194 0.0373702 0.828961    0.767349 -0.317405 -0.557162    0 0
  v -0.164048 0.067951 0.703961    0.67165 -0.282745 -0.684793    0 0
  v -0.322014 0.133383 0.578961    0.426718 -0.18147 -0.885991    0 0
  v -0.655684 0.271593 0.453961    0.233906 -0.0995088 -0.967153    0 0
  v -1.09785 0.454743 0.366461    0.145153 -0.0609226 -0.987532    0 0
  v -1.69158 0.700677 0.278961    0.124106 -0.0514266 -0.990935    0 0
  v -2.28705 0.947328 0.191961    0.144711 -0.0591408 -0.987705    0 0
  v -2.73441 1.13263 0.103961    0.251339 -0.100869 -0.962629    0 0
  v -2.7637 1.14476 0.0917106    0.507353 -0.203831 -0.837285    0 0
  v -2.77495 1.14942 0.0794606    0.617585 -0.257278 -0.743234    0 0
  v -2.78902 1.15525 0.0672107    0.427735 -0.183311 -0.885121    0 0
  v -2.8268 1.1709 0.0549607    0.141363 -0.063342 -0.987929    0 0
  v -2.83839 1.1757 0.0547109    0.0045612 -0.00241476 -0.999987    0 0
  v -2.86231 1.18561 0.0549607    0.0140049 -0.00493124 -0.99989    0 0
  v -2.88581 1.19534 0.0539608    0.0179065 -0.00811536 -0.999807    0 0
  v -2.89609 1.1996 0.0539608    -0.226993 0.0854097 -0.970144    0 0
  v -2.98271 1.23548 0.103961    -0.632693 0.255158 -0.731159    0 0
  v -3.01158 1.24744 0.153961    -0.772494 0.3501 -0.529796    0 0
  v -2.98271 1.23548 0.203961    -0.627806 0.266958 0.731158    0 0
  v -2.89609 1.1996 0.253961    -0.334375 0.142421 0.931617    0 0
  v -2.31607 0.959347 0.416961    -0.201813 0.0847499 0.975751    0 0
  v -1.52644 0.632272 0.578961    -0.183407 0.0755393 0.98013    0 0
  v -0.826891 0.34251 0.741961    -0.301673 0.120942 0.945709    0 0
  v -0.517102 0.214191 0.903961    -0.3964 0.179651 0.900329    0 0
  v -0.507935 0.210394 0.940961    -0.870405 0.361463 0.334274    0 0
  v -0.492272 0.203906 0.978961    -0.84583 0.350275 0.402342    0 0
  v -0.477475 0.197777 1.01596    -0.883904 0.364968 0.292424    0 0
  v -0.470908 0.195056 1.05396    -0.920038 0.380791 0.0923458    0 0
  v -0.470908 0.195056 1.35396    -0.92388 0.382683 0    0 0
  v -0.470908 0.195056 1.65396    -0.92388 0.382683 0    0 0
  v -0.470908 0.195056 1.95396    -0.92388 0.382683 0    0 0
  v -0.470908 0.195056 2.25396    -0.919243 0.381107 -0.0987443    0 0
  v -0.484794 0.200809 2.32896    -0.866307 0.360737 -0.345514    0 0
  v -0.523338 0.216774 2.40396    -0.759449 0.316523 -0.568375    0 0
  v -0.58186 0.241014 2.47896    -0.669661 0.278792 -0.688353    0 0
  v -0.655684 0.271593 2.55396    -0.580771 0.242573 -0.777086    0 0
  v -1.07133 0.443758 2.86696    -0.488642 0.203902 -0.848324    0 0
  v -1.58891 0.658149 3.17896    -0.447779 0.185542 -0.874682    0 0
  v -2.11337 0.875387 3.49196    -0.4785 0.196988 -0.855706    0 0
  v -2.54964 1.05609 3.80396    -0.561143 0.230517 -0.794972    0 0
  v -2.82571 1.17045 4.06596    -0.643607 0.265315 -0.717898    0 0
  v -3.05233 1.26432 4.32896    -0.707537 0.291901 -0.643573    0 0
  v -3.23548 1.34018 4.59096    -0.766066 0.31625 -0.559579    0 0
  v -3.38113 1.40051 4.85396    -0.823215 0.339896 -0.454739    0 0
  v -3.54905 1.47006 5.27896    -0.875978 0.361946 -0.318838    0 0
  v -3.64716 1.5107 5.70396    -0.908987 0.376108 -0.179684    0 0
  v -3.69309 1.52973 6.12896    -0.921476 0.381576 -0.0726731    0 0
  v -3.70449 1.53445 6.55396    -0.922564 0.382288 0.0522613    0 0
  v -3.62689 1.50231 7.17896    -0.90003 0.373541 0.22453    0 0
  v -3.43598 1.42323 7.80396    -0.865242 0.358868 0.350099    0 0
  v -3.19455 1.32323 8.42896    -0.855625 0.35429 0.377339    0 0
  v -2.96538 1.2283 9.05396    -0.865338 0.358192 0.350555    0 0
  v -2.8395 1.17616 9.44096    -0.872684 0.361431 0.328314    0 0
  v -2.71651 1.12522 9.82896    -0.877236 0.363239 0.31387    0 0
  v -2.60247 1.07798 10.217    -0.885605 0.36664 0.285095    0 0
  v -2.50344 1.03696 10.604    -0.898271 0.371797 0.234258    0 0
  v -2.49908 1.03515 10.627    -0.91047 0.376939 0.170178    0 0
  v -2.49623 1.03397 10.649    -0.918726 0.380425 0.105921    0 0
  v -2.49467 1.03333 10.672    -0.922831 0.382207 0.0479787    0 0
  v -2.4942 1.03313 10.694    -0.923865 0.382682 -0.00520402    0 0
  v -2.49464 1.03331 10.708    -0.92272 0.382346 0.048978    0 0
  v -2.49305 1.03265 10.721    -0.86975 0.362769 0.334564    0 0
  v -2.48511 1.02937 10.735    -0.669546 0.282425 0.686982    0 0
  v -2.46649 1.02165 10.749    -0.319261 0.140755 0.937155    0 0
  v -2.4578 1.01805 10.75    -0.101825 0.042021 0.993915    0 0
  v -2.44177 1.01142 10.752    -0.0806123 0.0343489 0.996154    0 0
  v -2.42656 1.00511 10.753    -0.0959871 0.0382444 0.994648    0 0
  v -2.42029 1.00252 10.754    -0.13288 0.0602221 0.989301    0 0
  v -2.40452 0.995986 10.717    0.908706 -0.374763 0.183863    0 0
  v -2.40672 0.996898 10.679    0.907487 -0.376711 -0.185892    0 0
  v -2.41802 1.00158 10.641    0.877514 -0.363553 -0.312728    0 0
  v -2.42953 1.00635 10.604    0.884411 -0.366018 -0.289564    0 0
  v -2.52567 1.04617 10.217    0.888546 -0.368188 -0.273723    0 0
  v -2.63336 1.09077 9.82896    0.881692 -0.365328 -0.298586    0 0
  v -2.75 1.13909 9.44096    0.876086 -0.36298 -0.317363    0 0
  v -2.87299 1.19003 9.05396    0.869803 -0.360431 -0.336946    0 0
  v -3.08772 1.27898 8.42896    0.867193 -0.359156 -0.344939    0 0
  v -3.2974 1.36583 7.80396    0.880375 -0.364238 -0.303761    0 0
  v -3.45655 1.43175 7.17896    0.907623 -0.375419 -0.187833    0 0
  v -3.51971 1.45791 6.55396    0.905431 -0.410348 -0.108668    0 0
  v -0.00952032 0.00189376 0.953961    0.807091 -0.133179 -0.575211    0 0
  v -0.0957764 0.0190511 0.828961    0.814527 -0.161607 -0.557162    0 0
  v -0.174152 0.034641 0.703961    0.713905 -0.146281 -0.684793    0 0
  v -0.341849 0.0679979 0.578961    0.453922 -0.0947345 -0.885991    0 0
  v -0.69607 0.138457 0.453961    0.248825 -0.0519641 -0.967153    0 0
  v -1.16547 0.231826 0.366461    0.154249 -0.0314342 -0.987532    0 0
  v -1.79578 0.357202 0.278961    0.131754 -0.0262266 -0.990935    0 0
  v -2.42792 0.482943 0.191961    0.153468 -0.0297729 -0.987705    0 0
  v -2.90284 0.57741 0.103961    0.266188 -0.0498967 -0.962629    0 0
  v -2.93393 0.583595 0.0917106    0.53737 -0.100935 -0.837285    0 0
  v -2.94587 0.58597 0.0794606    0.655909 -0.131849 -0.743235    0 0
  v -2.96081 0.588942 0.0672107    0.455277 -0.0963412 -0.885122    0 0
  v -3.00092 0.596919 0.0549607    0.151004 -0.0345465 -0.987929    0 0
  v -3.01321 0.599365 0.0547109    0.00494457 -0.0014785 -0.999987    0 0
  v -3.03861 0.604418 0.0549607    0.0146977 -0.00210424 -0.99989    0 0
  v -3.06356 0.609379 0.0539608    0.0191456 -0.00446602 -0.999807    0 0
  v -3.07447 0.611551 0.0539608    -0.239294 0.0394845 -0.970144    0 0
  v -3.16642 0.62984 0.103961    -0.670315 0.126823 -0.731159    0 0
  v -3.19707 0.635937 0.153961    -0.825951 0.192666 -0.529797    0 0
  v -3.16642 0.62984 0.203961    -0.667824 0.139349 0.731159    0 0
  v -3.07447 0.611551 0.253961    -0.355735 0.0744513 0.931617    0 0
  v -2.45872 0.489071 0.416961    -0.214469 0.0437497 0.975751    0 0
  v -1.62046 0.32233 0.578961    -0.19462 0.038307 0.98013    0 0
  v -0.877822 0.17461 0.741961    -0.319471 0.0597652 0.94571    0 0
  v -0.548952 0.109193 0.903961    -0.423832 0.0988656 0.900329    0 0
  v -0.539221 0.107258 0.940961    -0.924199 0.184711 0.334274    0 0
  v -0.522594 0.10395 0.978961    -0.897913 0.178532 0.402342    0 0
  v -0.506885 0.100826 1.01596    -0.938122 0.185515 0.292423    0 0
  v -0.499913 0.0994389 1.05396    -0.976649 0.193984 0.0923459    0 0
  v -0.499913 0.0994389 1.35396    -0.980785 0.195091 0    0 0
  v -0.499913 0.0994389 1.65396    -0.980785 0.195091 0    0 0
  v -0.499913 0.0994389 1.95396    -0.980785 0.195091 0    0 0
  v -0.499913 0.0994389 2.25396    -0.97593 0.19445 -0.0987445    0 0
  v -0.514655 0.102371 2.32896    -0.920038 0.184798 -0.345514    0 0
  v -0.555573 0.11051 2.40396    -0.806607 0.162281 -0.568375    0 0
  v -0.6177 0.122868 2.47896    -0.711183 0.142791 -0.688353    0 0
  v -0.69607 0.138457 2.55396    -0.616935 0.12461 -0.777086    0 0
  v -1.13731 0.226226 2.86696    -0.519032 0.104655 -0.848324    0 0
  v -1.68678 0.335521 3.17896    -0.475372 0.0946193 -0.874682    0 0
  v -2.24354 0.446268 3.49196    -0.507736 0.0998519 -0.855706    0 0
  v -2.70668 0.538392 3.80396    -0.595332 0.116614 -0.794972    0 0
  v -2.99976 0.59669 4.06596    -0.683001 0.134656 -0.717898    0 0
  v -3.24034 0.644543 4.32896    -0.750888 0.148258 -0.643573    0 0
  v -3.43476 0.683217 4.59096    -0.813044 0.160721 -0.559579    0 0
  v -3.58939 0.713973 4.85396    -0.873708 0.172763 -0.454739    0 0
  v -3.76765 0.749431 5.27896    -0.929759 0.184096 -0.318838    0 0
  v -3.8718 0.770149 5.70396    -0.964896 0.191547 -0.179684    0 0
  v -3.92057 0.779849 6.12896    -0.978212 0.194473 -0.072673    0 0
  v -3.93266 0.782255 6.55396    -0.979418 0.19496 0.0522612    0 0
  v -3.85029 0.76587 7.17896    -0.95561 0.190776 0.22453    0 0
  v -3.64762 0.725557 7.80396    -0.918629 0.183173 0.350099    0 0
  v -3.39131 0.674574 8.42896    -0.908303 0.180559 0.377339    0 0
  v -3.14803 0.626183 9.05396    -0.91859 0.18249 0.350555    0 0
  v -3.0144 0.599602 9.44096    -0.926427 0.184234 0.328314    0 0
  v -2.88383 0.57363 9.82896    -0.931245 0.185119 0.31387    0 0
  v -2.76277 0.549549 10.217    -0.940116 0.186822 0.285095    0 0
  v -2.65764 0.528637 10.604    -0.953545 0.18941 0.234258    0 0
  v -2.653 0.527715 10.627    -0.966513 0.192073 0.170178    0 0
  v -2.64998 0.527113 10.649    -0.97529 0.193881 0.105919    0 0
  v -2.64833 0.526786 10.672    -0.979663 0.194828 0.047983    0 0
  v -2.64783 0.526687 10.694    -0.980771 0.195092 -0.00520376    0 0
  v -2.64829 0.526778 10.708    -0.979583 0.194985 0.0489767    0 0
  v -2.64661 0.526443 10.721    -0.923813 0.186119 0.334558    0 0
  v -2.63818 0.524766 10.735    -0.71178 0.146377 0.686981    0 0
  v -2.61841 0.520834 10.749    -0.340585 0.075766 0.937156    0 0
  v -2.60918 0.518999 10.75    -0.108066 0.0213486 0.993915    0 0
  v -2.59217 0.515615 10.752    -0.0857647 0.0179623 0.996153    0 0
  v -2.57602 0.512402 10.753    -0.101604 0.0187835 0.994648    0 0
  v -2.56937 0.511079 10.754    -0.142077 0.0331417 0.989301    0 0
  v -2.55263 0.507749 10.717    0.964358 -0.190283 0.183865    0 0
  v -2.55497 0.508214 10.679    0.963543 -0.192431 -0.185892    0 0
  v -2.56696 0.510599 10.641    0.931578 -0.185373 -0.312729    0 0
  v -2.57918 0.51303 10.604    0.938824 -0.186445 -0.289565    0 0
  v -2.68124 0.533332 10.217    0.943302 -0.187767 -0.273723    0 0
  v -2.79556 0.556072 9.82896    0.936023 -0.186299 -0.298586    0 0
  v -2.91939 0.580702 9.44096    0.930066 -0.18509 -0.317363    0 0
  v -3.04995 0.606673 9.05396    0.923407 -0.183815 -0.336946    0 0
  v -3.27791 0.652017 8.42896    0.920598 -0.183074 -0.344939    0 0
  v -3.5005 0.696293 7.80396    0.934518 -0.185487 -0.303761    0 0
  v -3.66946 0.7299 7.17896    0.963424 -0.191137 -0.187833    0 0
  v -3.7365 0.743237 6.55396    0.968089 -0.225822 -0.108668    0 0
  v -0.0097069 0 0.953961    0.817565 0.0268197 -0.575211    0 0
  v -0.0976528 0 0.828961    0.830404 0.000395669 -0.557162    0 0
  v -0.177564 0 0.703961    0.728726 -0.00419551 -0.684793    0 0
  v -0.348546 0 0.578961    0.463682 -0.00435888 -0.885991    0 0
  v -0.709707 0 0.453961    0.254182 -0.00242235 -0.967153    0 0
  v -1.1883 0 0.366461    0.157418 -0.000737684 -0.987532    0 0
  v -1.83096 0 0.278961    0.134339 -1.87239e-005 -0.990935    0 0
  v -2.47549 0 0.191961    0.156327 0.000739324 -0.987705    0 0
  v -2.95971 0 0.103961    0.270808 0.00299277 -0.962629    0 0
  v -2.99141 0 0.0917106    0.546736 0.00583989 -0.837285    0 0
  v -3.00358 0 0.0794606    0.669031 -0.00135393 -0.743234    0 0
  v -3.01882 0 0.0672107    0.465325 -0.00566976 -0.885122    0 0
  v -3.05971 0 0.0549607    0.154842 -0.00442328 -0.987929    0 0
  v -3.07225 0 0.0547109    0.00513809 -0.00048545 -0.999987    0 0
  v -3.09814 0 0.0549607    0.0148258 0.000803565 -0.99989    0 0
  v -3.12357 0 0.0539608    0.0196489 -0.000645083 -0.999807    0 0
  v -3.13471 0 0.0539608    -0.242399 -0.00795808 -0.970144    0 0
  v -3.22846 0 0.103961    -0.682178 -0.00638558 -0.731158    0 0
  v -3.25971 0 0.153961    -0.847668 0.0278292 -0.529796    0 0
  v -3.22846 0 0.203961    -0.682177 0.00638563 0.731159    0 0
  v -3.13471 0 0.253961    -0.363424 0.00362019 0.931617    0 0
  v -2.50689 0 0.416961    -0.218883 0.00106825 0.975751    0 0
  v -1.65221 0 0.578961    -0.198353 -0.000397451 0.98013    0 0
  v -0.89502 0 0.741961    -0.324992 -0.0037087 0.945709    0 0
  v -0.559707 0 0.903961    -0.434976 0.0142807 0.900329    0 0
  v -0.549785 0 0.940961    -0.942476 0.000859921 0.334274    0 0
  v -0.532832 0 0.978961    -0.915489 -7.22582e-005 0.402342    0 0
  v -0.516816 0 1.01596    -0.956289 -0.00106785 0.292423    0 0
  v -0.509707 0 1.05396    -0.995727 -0.000277998 0.0923455    0 0
  v -0.509707 0 1.35396    -1 5.91444e-007 0    0 0
  v -0.509707 0 1.65396    -1 5.91444e-007 0    0 0
  v -0.509707 0 1.95396    -1 5.91444e-007 0    0 0
  v -0.509707 0 2.25396    -0.995113 0.000319307 -0.0987445    0 0
  v -0.524738 0 2.32896    -0.938412 0.00175721 -0.345514    0 0
  v -0.566457 0 2.40396    -0.822768 0.00180153 -0.568375    0 0
  v -0.629801 0 2.47896    -0.725375 0.00130254 -0.688353    0 0
  v -0.709707 0 2.55396    -0.629391 0.00185729 -0.777086    0 0
  v -1.15959 0 2.86696    -0.529476 0.00138605 -0.848324    0 0
  v -1.71983 0 3.17896    -0.484697 6.07008e-005 -0.874682    0 0
  v -2.2875 0 3.49196    -0.51746 -0.00112107 -0.855706    0 0
  v -2.75971 0 3.80396    -0.606643 -0.00177055 -0.794972    0 0
  v -3.05853 0 4.06596    -0.696147 -0.00117856 -0.717898    0 0
  v -3.30382 0 4.32896    -0.765384 -0.00108136 -0.643573    0 0
  v -3.50205 0 4.59096    -0.828777 -0.0009838 -0.559579    0 0
  v -3.65971 0 4.85396    -0.890624 -0.00100826 -0.454739    0 0
  v -3.84146 0 5.27896    -0.947809 -0.000828098 -0.318838    0 0
  v -3.94765 0 5.70396    -0.983724 -0.000375695 -0.179684    0 0
  v -3.99737 0 6.12896    -0.997356 -0.000103365 -0.0726731    0 0
  v -4.00971 0 6.55396    -0.998633 0.000138451 0.0522613    0 0
  v -3.92572 0 7.17896    -0.974467 0.000680192 0.22453    0 0
  v -3.71908 0 7.80396    -0.936713 0.00043728 0.350099    0 0
  v -3.45775 0 8.42896    -0.926075 -0.000112073 0.377339    0 0
  v -3.20971 0 9.05396    -0.936542 -0.000224237 0.350555    0 0
  v -3.07346 0 9.44096    -0.944569 -4.26745e-005 0.328314    0 0
  v -2.94033 0 9.82896    -0.949466 -0.000114941 0.31387    0 0
  v -2.8169 0 10.217    -0.958499 -0.00017543 0.285095    0 0
  v -2.70971 0 10.604    -0.972175 -0.000257287 0.234258    0 0
  v -2.70498 0 10.627    -0.985413 -0.000175452 0.170178    0 0
  v -2.70189 0 10.649    -0.994375 -0.000114341 0.105919    0 0
  v -2.70021 0 10.672    -0.998848 -3.88996e-005 0.0479822    0 0
  v -2.69971 0 10.694    -0.999987 4.79085e-006 -0.00520295    0 0
  v -2.70018 0 10.708    -0.9988 0.000131674 0.0489762    0 0
  v -2.69846 0 10.721    -0.942371 0.00231595 0.334561    0 0
  v -2.68986 0 10.735    -0.726661 0.00470266 0.68698    0 0
  v -2.66971 0 10.749    -0.348821 0.00786523 0.937156    0 0
  v -2.6603 0 10.75    -0.110155 -0.000144209 0.993914    0 0
  v -2.64296 0 10.752    -0.0876211 0.000885272 0.996153    0 0
  v -2.62649 0 10.753    -0.103316 -0.00139941 0.994648    0 0
  v -2.61971 0 10.754    -0.145812 0.00478713 0.989301    0 0
  v -2.60264 0 10.717    0.98295 0.00151078 0.183865    0 0
  v -2.60502 0 10.679    0.98257 -0.000755641 -0.185891    0 0
  v -2.61725 0 10.641    0.949842 -6.91805e-005 -0.312729    0 0
  v -2.62971 0 10.604    0.957159 0.000292984 -0.289564    0 0
  v -2.73377 0 10.217    0.961809 -0.000129851 -0.273723    0 0
  v -2.85033 0 9.82896    0.954383 -0.000110499 -0.298586    0 0
  v -2.97658 0 9.44096    0.948304 -8.63993e-005 -0.317363    0 0
  v -3.10971 0 9.05396    0.941524 -0.000135589 -0.336946    0 0
  v -3.34213 0 8.42896    0.938625 4.32508e-005 -0.344939    0 0
  v -3.56908 0 7.80396    0.952748 0.000392506 -0.303761    0 0
  v -3.74135 0 7.17896    0.982201 0.000489773 -0.187833    0 0
  v -3.80971 0 6.55396    0.993543 -0.0326185 -0.108668    0 0
  v -0.00952046 -0.00189376 0.953961    0.796616 0.18583 -0.575213    0 0
  v -0.0957765 -0.0190513 0.828961    0.81437 0.162394 -0.557162    0 0
  v -0.174152 -0.034641 0.703961    0.715542 0.138053 -0.684793    0 0
  v -0.341849 -0.0679979 0.578961    0.455622 0.0861849 -0.885991    0 0
  v -0.69607 -0.138457 0.453961    0.24977 0.0472126 -0.967153    0 0
  v -1.16547 -0.231826 0.366461    0.154537 0.0299872 -0.987532    0 0
  v -1.79578 -0.357202 0.278961    0.131761 0.0261899 -0.990935    0 0
  v -2.42792 -0.482944 0.191961    0.153179 0.0312231 -0.987705    0 0
  v -2.90284 -0.57741 0.103961    0.26502 0.0557672 -0.962629    0 0
  v -2.93393 -0.583595 0.0917106    0.535091 0.11239 -0.837285    0 0
  v -2.94587 -0.58597 0.0794606    0.65644 0.129194 -0.743233    0 0
  v -2.96081 -0.588942 0.0672107    0.457491 0.0852198 -0.885121    0 0
  v -3.00092 -0.596919 0.0549607    0.152729 0.0258698 -0.987929    0 0
  v -3.01321 -0.599365 0.0547109    0.00513418 0.000526289 -0.999987    0 0
  v -3.03861 -0.604418 0.0549607    0.0143842 0.00368052 -0.99989    0 0
  v -3.06356 -0.609379 0.0539608    0.0193972 0.00320063 -0.999807    0 0
  v -3.07447 -0.611551 0.0539608    -0.236188 -0.0550947 -0.970144    0 0
  v -3.16642 -0.629841 0.103961    -0.667824 -0.139349 -0.731159    0 0
  v -3.19707 -0.635937 0.153961    -0.836811 -0.138077 -0.529795    0 0
  v -3.16642 -0.629841 0.203961    -0.670316 -0.126823 0.731158    0 0
  v -3.07447 -0.611551 0.253961    -0.357147 -0.0673499 0.931617    0 0
  v -2.45872 -0.489071 0.416961    -0.214886 -0.0416543 0.975751    0 0
  v -1.62046 -0.32233 0.578961    -0.194465 -0.0390867 0.98013    0 0
  v -0.877822 -0.17461 0.741961    -0.318024 -0.0670405 0.945709    0 0
  v -0.548952 -0.109194 0.903961    -0.429404 -0.0708535 0.900329    0 0
  v -0.539221 -0.107258 0.940961    -0.924534 -0.183025 0.334274    0 0
  v -0.522594 -0.103951 0.978961    -0.897884 -0.178675 0.402342    0 0
  v -0.506885 -0.100826 1.01596    -0.937705 -0.18761 0.292423    0 0
  v -0.499913 -0.0994389 1.05396    -0.97654 -0.19453 0.0923453    0 0
  v -0.499913 -0.0994389 1.35396    -0.980785 -0.19509 0    0 0
  v -0.499913 -0.0994389 1.65396    -0.980785 -0.19509 0    0 0
  v -0.499913 -0.0994389 1.95396    -0.980785 -0.19509 0    0 0
  v -0.499913 -0.0994389 2.25396    -0.976054 -0.193825 -0.0987447    0 0
  v -0.514655 -0.102371 2.32896    -0.920723 -0.181353 -0.345515    0 0
  v -0.555573 -0.11051 2.40396    -0.80731 -0.158748 -0.568374    0 0
  v -0.6177 -0.122868 2.47896    -0.711691 -0.140236 -0.688353    0 0
  v -0.69607 -0.138457 2.55396    -0.61766 -0.120967 -0.777086    0 0
  v -1.13731 -0.226226 2.86696    -0.519573 -0.101936 -0.848324    0 0
  v -1.68678 -0.335521 3.17896    -0.475396 -0.0945002 -0.874682    0 0
  v -2.24354 -0.446269 3.49196    -0.507299 -0.102051 -0.855706    0 0
  v -2.70668 -0.538392 3.80396    -0.594641 -0.120087 -0.794972    0 0
  v -2.99976 -0.59669 4.06596    -0.682541 -0.136967 -0.717898    0 0
  v -3.24034 -0.644544 4.32896    -0.750467 -0.15038 -0.643573    0 0
  v -3.43476 -0.683217 4.59096    -0.81266 -0.162651 -0.559579    0 0
  v -3.58939 -0.713974 4.85396    -0.873314 -0.174741 -0.454739    0 0
  v -3.76765 -0.749432 5.27896    -0.929435 -0.185721 -0.318838    0 0
  v -3.8718 -0.770149 5.70396    -0.964749 -0.192284 -0.179684    0 0
  v -3.92057 -0.779849 6.12896    -0.978172 -0.194676 -0.0726731    0 0
  v -3.93266 -0.782255 6.55396    -0.979472 -0.194688 0.0522614    0 0
  v -3.85029 -0.765871 7.17896    -0.955875 -0.189442 0.22453    0 0
  v -3.64762 -0.725557 7.80396    -0.918799 -0.182315 0.350099    0 0
  v -3.39131 -0.674574 8.42896    -0.908259 -0.180778 0.377339    0 0
  v -3.14803 -0.626183 9.05396    -0.918503 -0.18293 0.350555    0 0
  v -3.0144 -0.599602 9.44096    -0.926411 -0.184318 0.328314    0 0
  v -2.88383 -0.57363 9.82896    -0.9312 -0.185344 0.31387    0 0
  v -2.76277 -0.549549 10.217    -0.940048 -0.187166 0.285095    0 0
  v -2.65764 -0.528638 10.604    -0.953444 -0.189914 0.234258    0 0
  v -2.653 -0.527715 10.627    -0.966445 -0.192417 0.170177    0 0
  v -2.64998 -0.527114 10.649    -0.975246 -0.194105 0.105919    0 0
  v -2.64833 -0.526786 10.672    -0.979648 -0.194904 0.0479816    0 0
  v -2.64783 -0.526687 10.694    -0.980773 -0.195083 -0.00520188    0 0
  v -2.64829 -0.526778 10.708    -0.979634 -0.194727 0.048974    0 0
  v -2.64661 -0.526443 10.721    -0.924716 -0.181576 0.334561    0 0
  v -2.63818 -0.524766 10.735    -0.713616 -0.137153 0.68698    0 0
  v -2.61841 -0.520834 10.749    -0.343653 -0.0603375 0.937156    0 0
  v -2.60918 -0.518999 10.75    -0.10801 -0.0216315 0.993914    0 0
  v -2.59217 -0.515615 10.752    -0.0861102 -0.0162258 0.996153    0 0
  v -2.57602 -0.512403 10.753    -0.101058 -0.0215284 0.994648    0 0
  v -2.56937 -0.51108 10.754    -0.143944 -0.0237515 0.989301    0 0
  v -2.55263 -0.507749 10.717    0.963769 0.193246 0.183864    0 0
  v -2.55497 -0.508214 10.679    0.963838 0.190949 -0.18589    0 0
  v -2.56696 -0.510599 10.641    0.931605 0.185237 -0.31273    0 0
  v -2.57918 -0.513031 10.604    0.93871 0.18702 -0.289564    0 0
  v -2.68124 -0.533332 10.217    0.943353 0.187512 -0.273723    0 0
  v -2.79556 -0.556072 9.82896    0.936066 0.186082 -0.298586    0 0
  v -2.91939 -0.580702 9.44096    0.9301 0.18492 -0.317363    0 0
  v -3.04995 -0.606674 9.05396    0.923459 0.183549 -0.336946    0 0
  v -3.27791 -0.652017 8.42896    0.920581 0.183159 -0.344939    0 0
  v -3.5005 -0.696293 7.80396    0.934365 0.186257 -0.303761    0 0
  v -3.66946 -0.729901 7.17896    0.963232 0.192098 -0.187833    0 0
  v -3.7365 -0.743237 6.55396    0.980816 0.161839 -0.108668    0 0
  v -0.00896794 -0.0037148 0.953961    0.745052 0.337681 -0.575212    0 0
  v -0.0902194 -0.0373702 0.828961    0.767036 0.318162 -0.557162    0 0
  v -0.164048 -0.067951 0.703961    0.674859 0.274998 -0.684793    0 0
  v -0.322014 -0.133383 0.578961    0.430054 0.173417 -0.885991    0 0
  v -0.655684 -0.271593 0.453961    0.23576 0.0950333 -0.967153    0 0
  v -1.09785 -0.454743 0.366461    0.145717 0.0595596 -0.987532    0 0
  v -1.69158 -0.700677 0.278961    0.12412 0.051392 -0.990935    0 0
  v -2.28705 -0.947328 0.191961    0.144145 0.060507 -0.987705    0 0
  v -2.73441 -1.13263 0.103961    0.249048 0.106398 -0.962629    0 0
  v -2.7637 -1.14476 0.0917106    0.502883 0.214622 -0.837285    0 0
  v -2.77495 -1.14942 0.0794606    0.618622 0.254776 -0.743233    0 0
  v -2.78902 -1.15525 0.0672107    0.432075 0.172834 -0.885121    0 0
  v -2.8268 -1.1709 0.0549607    0.144748 0.0551689 -0.987929    0 0
  v -2.83839 -1.1757 0.0547109    0.00493282 0.00151779 -0.999987    0 0
  v -2.86231 -1.18561 0.0549607    0.01339 0.00641609 -0.99989    0 0
  v -2.88581 -1.19534 0.0539608    0.0184002 0.00692339 -0.999807    0 0
  v -2.89609 -1.1996 0.0539608    -0.220902 -0.100114 -0.970144    0 0
  v -2.98271 -1.23548 0.103961    -0.627806 -0.266958 -0.731159    0 0
  v -3.01158 -1.24744 0.153961    -0.793793 -0.298678 -0.529796    0 0
  v -2.98271 -1.23548 0.203961    -0.632694 -0.255159 0.731158    0 0
  v -2.89609 -1.1996 0.253961    -0.337146 -0.135732 0.931617    0 0
  v -2.31607 -0.959347 0.416961    -0.20263 -0.0827759 0.975751    0 0
  v -1.52644 -0.632272 0.578961    -0.183103 -0.0762738 0.98013    0 0
  v -0.826891 -0.34251 0.741961    -0.298834 -0.127796 0.945709    0 0
  v -0.517102 -0.214191 0.903961    -0.40733 -0.153265 0.900329    0 0
  v -0.507935 -0.210394 0.940961    -0.871062 -0.359876 0.334274    0 0
  v -0.492272 -0.203906 0.978961    -0.845774 -0.350411 0.402342    0 0
  v -0.477475 -0.197777 1.01596    -0.883086 -0.366943 0.292423    0 0
  v -0.470908 -0.195057 1.05396    -0.919825 -0.381306 0.0923447    0 0
  v -0.470908 -0.195057 1.35396    -0.923879 -0.382684 0    0 0
  v -0.470908 -0.195057 1.65396    -0.923879 -0.382684 0    0 0
  v -0.470908 -0.195057 1.95396    -0.923879 -0.382684 0    0 0
  v -0.470908 -0.195057 2.25396    -0.919486 -0.380519 -0.0987443    0 0
  v -0.484794 -0.200809 2.32896    -0.867651 -0.357492 -0.345514    0 0
  v -0.523338 -0.216774 2.40396    -0.760828 -0.313196 -0.568375    0 0
  v -0.58186 -0.241014 2.47896    -0.670658 -0.276386 -0.688353    0 0
  v -0.655684 -0.271593 2.55396    -0.582192 -0.239142 -0.777087    0 0
  v -1.07133 -0.443758 2.86696    -0.489703 -0.201341 -0.848324    0 0
  v -1.58891 -0.658149 3.17896    -0.447825 -0.18543 -0.874682    0 0
  v -2.11337 -0.875387 3.49196    -0.477642 -0.199059 -0.855706    0 0
  v -2.54964 -1.05609 3.80396    -0.559788 -0.233788 -0.794972    0 0
  v -2.82571 -1.17045 4.06596    -0.642705 -0.267493 -0.717898    0 0
  v -3.05233 -1.26432 4.32896    -0.706709 -0.293899 -0.643573    0 0
  v -3.23548 -1.34018 4.59096    -0.765313 -0.318068 -0.559578    0 0
  v -3.38113 -1.40051 4.85396    -0.822443 -0.341759 -0.454739    0 0
  v -3.54905 -1.47006 5.27896    -0.875344 -0.363476 -0.318838    0 0
  v -3.64716 -1.5107 5.70396    -0.908699 -0.376802 -0.179684    0 0
  v -3.69309 -1.52973 6.12896    -0.921397 -0.381767 -0.0726731    0 0
  v -3.70449 -1.53445 6.55396    -0.92267 -0.382033 0.0522613    0 0
  v -3.62689 -1.50231 7.17896    -0.90055 -0.372284 0.22453    0 0
  v -3.43598 -1.42323 7.80396    -0.865577 -0.35806 0.350099    0 0
  v -3.19455 -1.32323 8.42896    -0.855539 -0.354497 0.377339    0 0
  v -2.96538 -1.2283 9.05396    -0.865166 -0.358606 0.350555    0 0
  v -2.8395 -1.17616 9.44096    -0.872651 -0.36151 0.328314    0 0
  v -2.71651 -1.12522 9.82896    -0.877148 -0.363451 0.31387    0 0
  v -2.60247 -1.07798 10.217    -0.885471 -0.366964 0.285095    0 0
  v -2.50344 -1.03696 10.604    -0.898074 -0.372273 0.234258    0 0
  v -2.49908 -1.03515 10.627    -0.910336 -0.377263 0.170179    0 0
  v -2.49623 -1.03397 10.649    -0.918639 -0.380636 0.105919    0 0
  v -2.49467 -1.03333 10.672    -0.9228 -0.382279 0.0479806    0 0
  v -2.4942 -1.03313 10.694    -0.923869 -0.382674 -0.00520691    0 0
  v -2.49464 -1.03331 10.708    -0.922821 -0.382102 0.0489778    0 0
  v -2.49305 -1.03266 10.721    -0.871523 -0.35849 0.334564    0 0
  v -2.48511 -1.02937 10.735    -0.673145 -0.273736 0.686983    0 0
  v -2.46649 -1.02165 10.749    -0.32528 -0.126222 0.937156    0 0
  v -2.4578 -1.01805 10.75    -0.101714 -0.0422875 0.993915    0 0
  v -2.44177 -1.01142 10.752    -0.0812899 -0.0327132 0.996154    0 0
  v -2.42656 -1.00511 10.753    -0.0949154 -0.0408299 0.994648    0 0
  v -2.42029 -1.00252 10.754    -0.136543 -0.0513765 0.989301    0 0
  v -2.40452 -0.995986 10.717    0.90755 0.377555 0.183863    0 0
  v -2.40672 -0.996898 10.679    0.908066 0.375315 -0.18589    0 0
  v -2.41802 -1.00158 10.641    0.877567 0.363425 -0.312728    0 0
  v -2.42953 -1.00635 10.604    0.884187 0.366559 -0.289565    0 0
  v -2.52567 -1.04617 10.217    0.888645 0.367948 -0.273723    0 0
  v -2.63336 -1.09078 9.82896    0.881777 0.365124 -0.298587    0 0
  v -2.75 -1.13909 9.44096    0.876152 0.36282 -0.317363    0 0
  v -2.87299 -1.19003 9.05396    0.869907 0.36018 -0.336946    0 0
  v -3.08772 -1.27898 8.42896    0.86716 0.359236 -0.344939    0 0
  v -3.2974 -1.36583 7.80396    0.880074 0.364964 -0.303761    0 0
  v -3.45655 -1.43175 7.17896    0.907248 0.376325 -0.187833    0 0
  v -3.51971 -1.45791 6.55396    0.930396 0.350077 -0.108668    0 0
  v -0.00807089 -0.00539303 0.953961    0.664871 0.476527 -0.575211    0 0
  v -0.0811953 -0.0542533 0.828961    0.690231 0.461683 -0.557162    0 0
  v -0.147639 -0.0986495 0.703961    0.608244 0.401371 -0.684793    0 0
  v -0.289805 -0.193642 0.578961    0.387959 0.253984 -0.885991    0 0
  v -0.5901 -0.394292 0.453961    0.21269 0.139202 -0.967153    0 0
  v -0.988036 -0.660185 0.366461    0.131298 0.0868432 -0.987532    0 0
  v -1.52238 -1.01723 0.278961    0.111709 0.0746192 -0.990935    0 0
  v -2.05829 -1.37531 0.191961    0.129571 0.0874656 -0.987705    0 0
  v -2.46091 -1.64433 0.103961    0.223505 0.15294 -0.962629    0 0
  v -2.48727 -1.66194 0.0917106    0.451349 0.308606 -0.837285    0 0
  v -2.49739 -1.6687 0.0794606    0.557031 0.370568 -0.743234    0 0
  v -2.51005 -1.67716 0.0672107    0.390056 0.253808 -0.88512    0 0
  v -2.54405 -1.69988 0.0549607    0.131203 0.0823475 -0.987929    0 0
  v -2.55448 -1.70685 0.0547109    0.00454202 0.00245103 -0.999987    0 0
  v -2.57601 -1.72124 0.0549607    0.011881 0.00890509 -0.99989    0 0
  v -2.59716 -1.73537 0.0539608    0.0166961 0.0103801 -0.999807    0 0
  v -2.60641 -1.74155 0.0539608    -0.197126 -0.141287 -0.970144    0 0
  v -2.68436 -1.79364 0.103961    -0.563662 -0.384307 -0.731158    0 0
  v -2.71035 -1.811 0.153961    -0.720272 -0.4478 -0.529796    0 0
  v -2.68436 -1.79364 0.203961    -0.570758 -0.373689 0.731158    0 0
  v -2.60641 -1.74155 0.253961    -0.304188 -0.198898 0.931617    0 0
  v -2.08441 -1.39276 0.416961    -0.182588 -0.120717 0.975751    0 0
  v -1.37376 -0.917917 0.578961    -0.164704 -0.11053 0.98013    0 0
  v -0.744182 -0.497247 0.741961    -0.268161 -0.18364 0.945709    0 0
  v -0.465379 -0.310957 0.903961    -0.369603 -0.229786 0.900329    0 0
  v -0.457129 -0.305444 0.940961    -0.784117 -0.522897 0.334274    0 0
  v -0.443033 -0.296026 0.978961    -0.761161 -0.508679 0.402343    0 0
  v -0.429716 -0.287128 1.01596    -0.794532 -0.532174 0.292422    0 0
  v -0.423806 -0.283178 1.05396    -0.827762 -0.553428 0.0923443    0 0
  v -0.423806 -0.283178 1.35396    -0.83147 -0.55557 0    0 0
  v -0.423806 -0.283178 1.65396    -0.83147 -0.55557 0    0 0
  v -0.423806 -0.283178 1.95396    -0.83147 -0.55557 0    0 0
  v -0.423806 -0.283178 2.25396    -0.827583 -0.55259 -0.0987444    0 0
  v -0.436303 -0.291529 2.32896    -0.781237 -0.519893 -0.345514    0 0
  v -0.470992 -0.314707 2.40396    -0.685107 -0.455608 -0.568375    0 0
  v -0.52366 -0.349899 2.47896    -0.603851 -0.401914 -0.688353    0 0
  v -0.5901 -0.394292 2.55396    -0.524352 -0.348127 -0.777086    0 0
  v -0.964168 -0.644237 2.86696    -0.441013 -0.293009 -0.848324    0 0
  v -1.42998 -0.955485 3.17896    -0.403045 -0.269233 -0.874682    0 0
  v -1.90198 -1.27087 3.49196    -0.42963 -0.288418 -0.855706    0 0
  v -2.29461 -1.53321 3.80396    -0.503422 -0.338505 -0.794972    0 0
  v -2.54308 -1.69923 4.06596    -0.57817 -0.387738 -0.717898    0 0
  v -2.74703 -1.83551 4.32896    -0.635793 -0.426124 -0.643573    0 0
  v -2.91185 -1.94564 4.59096    -0.688556 -0.461262 -0.559579    0 0
  v -3.04293 -2.03322 4.85396    -0.739967 -0.495642 -0.454739    0 0
  v -3.19406 -2.1342 5.27896    -0.787614 -0.527263 -0.318838    0 0
  v -3.28235 -2.1932 5.70396    -0.817728 -0.54684 -0.179684    0 0
  v -3.32369 -2.22082 6.12896    -0.829214 -0.554187 -0.072673    0 0
  v -3.33395 -2.22767 6.55396    -0.83041 -0.554696 0.0522611    0 0
  v -3.26412 -2.18102 7.17896    -0.810617 -0.540819 0.22453    0 0
  v -3.0923 -2.06621 7.80396    -0.779091 -0.520046 0.350099    0 0
  v -2.87502 -1.92103 8.42896    -0.769941 -0.514593 0.377339    0 0
  v -2.66877 -1.78322 9.05396    -0.778582 -0.520501 0.350555    0 0
  v -2.55549 -1.70752 9.44096    -0.785356 -0.52481 0.328313    0 0
  v -2.4448 -1.63356 9.82896    -0.789388 -0.527591 0.31387    0 0
  v -2.34216 -1.56498 10.217    -0.796865 -0.53266 0.285095    0 0
  v -2.25304 -1.50543 10.604    -0.808191 -0.540325 0.234256    0 0
  v -2.24911 -1.50281 10.627    -0.819244 -0.547612 0.170178    0 0
  v -2.24654 -1.50109 10.649    -0.826729 -0.55254 0.105918    0 0
  v -2.24515 -1.50016 10.672    -0.83049 -0.554963 0.0479828    0 0
  v -2.24472 -1.49988 10.694    -0.831461 -0.555559 -0.00520616    0 0
  v -2.24511 -1.50014 10.708    -0.830545 -0.554794 0.0489752    0 0
  v -2.24368 -1.49918 10.721    -0.784839 -0.521628 0.334563    0 0
  v -2.23654 -1.49441 10.735    -0.606807 -0.3998 0.686982    0 0
  v -2.21978 -1.48321 10.749    -0.294404 -0.187255 0.937156    0 0
  v -2.21196 -1.47798 10.75    -0.0915102 -0.0613186 0.993914    0 0
  v -2.19754 -1.46835 10.752    -0.0733458 -0.0479435 0.996154    0 0
  v -2.18384 -1.4592 10.753    -0.0851273 -0.0585634 0.994648    0 0
  v -2.17821 -1.45543 10.754    -0.123897 -0.0770281 0.989301    0 0
  v -2.16401 -1.44595 10.717    0.816454 0.547354 0.183866    0 0
  v -2.16599 -1.44727 10.679    0.817397 0.545259 -0.185891    0 0
  v -2.17616 -1.45406 10.641    0.789804 0.527647 -0.312729    0 0
  v -2.18652 -1.46099 10.604    0.795685 0.532012 -0.289565    0 0
  v -2.27305 -1.5188 10.217    0.799787 0.534244 -0.273723    0 0
  v -2.36996 -1.58356 9.82896    0.793601 0.530135 -0.298586    0 0
  v -2.47494 -1.6537 9.44096    0.788534 0.526778 -0.317363    0 0
  v -2.58563 -1.72766 9.05396    0.782924 0.52297 -0.336946    0 0
  v -2.77888 -1.85679 8.42896    0.780414 0.521508 -0.344939    0 0
  v -2.96758 -1.98288 7.80396    0.791963 0.529645 -0.303761    0 0
  v -3.11082 -2.07858 7.17896    0.816398 0.546089 -0.187833    0 0
  v -3.16766 -2.11656 6.55396    0.844222 0.524862 -0.108668    0 0
  v -0.00686371 -0.00686407 0.953961    0.559125 0.597085 -0.575212    0 0
  v -0.0690509 -0.0690513 0.828961    0.586902 0.587466 -0.557162    0 0
  v -0.125556 -0.125557 0.703961    0.518252 0.512321 -0.684793    0 0
  v -0.246459 -0.246459 0.578961    0.330954 0.324791 -0.885991    0 0
  v -0.501839 -0.501839 0.453961    0.181446 0.178021 -0.967153    0 0
  v -0.840255 -0.840256 0.366461    0.111833 0.11079 -0.987532    0 0
  v -1.29468 -1.29468 0.278961    0.0950053 0.0949788 -0.990935    0 0
  v -1.75043 -1.75043 0.191961    0.110017 0.111063 -0.987705    0 0
  v -2.09283 -2.09283 0.103961    0.189373 0.193606 -0.962629    0 0
  v -2.11525 -2.11525 0.0917106    0.382471 0.39073 -0.837285    0 0
  v -2.12385 -2.12385 0.0794606    0.474033 0.472118 -0.743235    0 0
  v -2.13463 -2.13463 0.0672107    0.333044 0.325025 -0.885122    0 0
  v -2.16354 -2.16354 0.0549607    0.112617 0.106362 -0.987929    0 0
  v -2.17241 -2.17241 0.0547109    0.00397642 0.00328987 -0.999987    0 0
  v -2.19072 -2.19072 0.0549607    0.00991531 0.0110517 -0.99989    0 0
  v -2.2087 -2.2087 0.0539608    0.0143502 0.0134379 -0.999807    0 0
  v -2.21657 -2.21657 0.0539608    -0.165775 -0.177029 -0.970144    0 0
  v -2.28286 -2.28286 0.103961    -0.477857 -0.486888 -0.731159    0 0
  v -2.30496 -2.30496 0.153961    -0.61907 -0.579714 -0.529796    0 0
  v -2.28286 -2.28286 0.203961    -0.486888 -0.477858 0.731158    0 0
  v -2.21657 -2.21657 0.253961    -0.25954 -0.25442 0.931616    0 0
  v -1.77264 -1.77264 0.416961    -0.155529 -0.154018 0.975751    0 0
  v -1.16829 -1.16829 0.578961    -0.139976 -0.140538 0.98013    0 0
  v -0.632875 -0.632875 0.741961    -0.227181 -0.232427 0.94571    0 0
  v -0.395772 -0.395773 0.903961    -0.317672 -0.297476 0.900329    0 0
  v -0.388756 -0.388757 0.940961    -0.667039 -0.665823 0.334274    0 0
  v -0.376769 -0.376769 0.978961    -0.647297 -0.6474 0.402343    0 0
  v -0.365444 -0.365444 1.01596    -0.675443 -0.676953 0.292423    0 0
  v -0.360417 -0.360418 1.05396    -0.703889 -0.704282 0.0923436    0 0
  v -0.360417 -0.360418 1.35396    -0.707107 -0.707107 0    0 0
  v -0.360417 -0.360418 1.65396    -0.707107 -0.707107 0    0 0
  v -0.360417 -0.360418 1.95396    -0.707107 -0.707107 0    0 0
  v -0.360417 -0.360418 2.25396    -0.703876 -0.703426 -0.0987439    0 0
  v -0.371046 -0.371046 2.32896    -0.664799 -0.662315 -0.345514    0 0
  v -0.400545 -0.400546 2.40396    -0.583058 -0.580511 -0.568374    0 0
  v -0.445336 -0.445337 2.47896    -0.513838 -0.511997 -0.688353    0 0
  v -0.501839 -0.501839 2.55396    -0.44636 -0.443734 -0.777086    0 0
  v -0.819957 -0.819958 2.86696    -0.375376 -0.373416 -0.848324    0 0
  v -1.2161 -1.2161 3.17896    -0.342776 -0.34269 -0.874682    0 0
  v -1.6175 -1.6175 3.49196    -0.365107 -0.366692 -0.855706    0 0
  v -1.95141 -1.95141 3.80396    -0.427709 -0.430214 -0.794972    0 0
  v -2.16271 -2.16271 4.06596    -0.491417 -0.493084 -0.717899    0 0
  v -2.33615 -2.33615 4.32896    -0.540444 -0.541973 -0.643573    0 0
  v -2.47633 -2.47633 4.59096    -0.585338 -0.586729 -0.559579    0 0
  v -2.5878 -2.5878 4.85396    -0.629053 -0.630479 -0.454739    0 0
  v -2.71632 -2.71632 5.27896    -0.669617 -0.670788 -0.318838    0 0
  v -2.79141 -2.79141 5.70396    -0.695333 -0.695864 -0.179684    0 0
  v -2.82657 -2.82657 6.12896    -0.705164 -0.70531 -0.0726729    0 0
  v -2.83529 -2.83529 6.55396    -0.706238 -0.706043 0.0522613    0 0
  v -2.77591 -2.77591 7.17896    -0.689533 -0.688571 0.22453    0 0
  v -2.62979 -2.62979 7.80396    -0.662665 -0.662046 0.350099    0 0
  v -2.445 -2.445 8.42896    -0.654755 -0.654913 0.377339    0 0
  v -2.26961 -2.26961 9.05396    -0.662077 -0.662394 0.350555    0 0
  v -2.17326 -2.17326 9.44096    -0.667881 -0.667941 0.328314    0 0
  v -2.07913 -2.07913 9.82896    -0.671292 -0.671455 0.31387    0 0
  v -1.99185 -1.99185 10.217    -0.677637 -0.677885 0.285095    0 0
  v -1.91605 -1.91605 10.604    -0.687249 -0.687613 0.234259    0 0
  v -1.91271 -1.91271 10.627    -0.696668 -0.696916 0.170179    0 0
  v -1.91053 -1.91053 10.649    -0.703048 -0.70321 0.105918    0 0
  v -1.90934 -1.90934 10.672    -0.706265 -0.70632 0.0479808    0 0
  v -1.90898 -1.90898 10.694    -0.7071 -0.707094 -0.00520089    0 0
  v -1.90931 -1.90931 10.708    -0.706351 -0.706165 0.0489763    0 0
  v -1.9081 -1.9081 10.721    -0.667994 -0.664719 0.334563    0 0
  v -1.90202 -1.90202 10.735    -0.517152 -0.510502 0.68698    0 0
  v -1.88777 -1.88777 10.749    -0.252215 -0.241092 0.937157    0 0
  v -1.88112 -1.88112 10.75    -0.0777892 -0.0779932 0.993914    0 0
  v -1.86885 -1.86885 10.752    -0.0625832 -0.0613313 0.996154    0 0
  v -1.85721 -1.85721 10.753    -0.0720671 -0.0740463 0.994647    0 0
  v -1.85241 -1.85241 10.754    -0.106492 -0.0997217 0.9893    0 0
  v -1.84034 -1.84034 10.717    0.693982 0.696119 0.183867    0 0
  v -1.84203 -1.84203 10.679    0.695317 0.694248 -0.185888    0 0
  v -1.85067 -1.85067 10.641    0.671688 0.671591 -0.312731    0 0
  v -1.85948 -1.85948 10.604    0.676606 0.67702 -0.289565    0 0
  v -1.93307 -1.93307 10.217    0.680193 0.68001 -0.273723    0 0
  v -2.01549 -2.01549 9.82896    0.674928 0.674772 -0.298586    0 0
  v -2.10476 -2.10476 9.44096    0.670613 0.670491 -0.317363    0 0
  v -2.19889 -2.1989 9.05396    0.665854 0.665662 -0.336946    0 0
  v -2.36324 -2.36324 8.42896    0.663677 0.663739 -0.344939    0 0
  v -2.52372 -2.52372 7.80396    0.673417 0.673972 -0.303761    0 0
  v -2.64553 -2.64553 7.17896    0.694174 0.694867 -0.187833    0 0
  v -2.69387 -2.69387 6.55396    0.725605 0.679476 -0.108668    0 0
  v -0.00539274 -0.00807118 0.953961    0.431905 0.694688 -0.575211    0 0
  v -0.0542529 -0.0811956 0.828961    0.461011 0.69068 -0.557162    0 0
  v -0.0986491 -0.147639 0.703961    0.408345 0.603583 -0.684793    0 0
  v -0.193642 -0.289806 0.578961    0.261232 0.383116 -0.885991    0 0
  v -0.394292 -0.5901 0.453961    0.14323 0.209998 -0.967153    0 0
  v -0.660184 -0.988036 0.366461    0.0880699 0.130478 -0.987532    0 0
  v -1.01722 -1.52239 0.278961    0.0746503 0.111688 -0.990935    0 0
  v -1.37531 -2.05829 0.191961    0.0862362 0.130392 -0.987705    0 0
  v -1.64432 -2.46091 0.103961    0.147964 0.226831 -0.962629    0 0
  v -1.66194 -2.48727 0.0917106    0.298893 0.457837 -0.837286    0 0
  v -1.6687 -2.49739 0.0794606    0.372818 0.555524 -0.743237    0 0
  v -1.67716 -2.51005 0.0672107    0.263235 0.383753 -0.885122    0 0
  v -1.69988 -2.54405 0.0549607    0.0897035 0.126289 -0.987929    0 0
  v -1.70685 -2.55448 0.0547109    0.00325814 0.00400237 -0.999987    0 0
  v -1.72124 -2.57601 0.0549607    0.00756857 0.0127735 -0.99989    0 0
  v -1.73536 -2.59716 0.0539608    0.0114527 0.0159791 -0.999807    0 0
  v -1.74155 -2.60641 0.0539608    -0.128053 -0.205969 -0.970144    0 0
  v -1.79363 -2.68436 0.103961    -0.373688 -0.570756 -0.73116    0 0
  v -1.811 -2.71035 0.153961    -0.494078 -0.689348 -0.529799    0 0
  v -1.79363 -2.68436 0.203961    -0.384307 -0.563661 0.73116    0 0
  v -1.74155 -2.60641 0.253961    -0.204918 -0.300166 0.931616    0 0
  v -1.39276 -2.08441 0.416961    -0.122493 -0.181401 0.975751    0 0
  v -0.917917 -1.37376 0.578961    -0.109869 -0.165146 0.98013    0 0
  v -0.497246 -0.744182 0.741961    -0.177472 -0.272281 0.945709    0 0
  v -0.310956 -0.465379 0.903961    -0.253533 -0.353735 0.900329    0 0
  v -0.305444 -0.45713 0.940961    -0.524326 -0.783162 0.334274    0 0
  v -0.296025 -0.443034 0.978961    -0.508558 -0.761242 0.402342    0 0
  v -0.287127 -0.429717 1.01596    -0.530398 -0.795718 0.292423    0 0
  v -0.283178 -0.423806 1.05396    -0.552965 -0.828072 0.0923447    0 0
  v -0.283178 -0.423806 1.35396    -0.55557 -0.83147 0    0 0
  v -0.283178 -0.423806 1.65396    -0.55557 -0.83147 0    0 0
  v -0.283178 -0.423806 1.95396    -0.55557 -0.83147 0    0 0
  v -0.283178 -0.423806 2.25396    -0.55312 -0.827229 -0.098744    0 0
  v -0.291529 -0.436304 2.32896    -0.522815 -0.779285 -0.345514    0 0
  v -0.314706 -0.470992 2.40396    -0.458603 -0.683106 -0.568375    0 0
  v -0.349899 -0.523661 2.47896    -0.40408 -0.602404 -0.688353    0 0
  v -0.394292 -0.5901 2.55396    -0.351215 -0.522288 -0.777086    0 0
  v -0.644236 -0.964168 2.86696    -0.295314 -0.439473 -0.848324    0 0
  v -0.955484 -1.42998 3.17896    -0.269334 -0.402977 -0.874682    0 0
  v -1.27086 -1.90198 3.49196    -0.286553 -0.430875 -0.855706    0 0
  v -1.53321 -2.29461 3.80396    -0.335561 -0.505389 -0.794972    0 0
  v -1.69923 -2.54308 4.06596    -0.385778 -0.57948 -0.717899    0 0
  v -1.8355 -2.74703 4.32896    -0.424325 -0.636994 -0.643573    0 0
  v -1.94564 -2.91185 4.59096    -0.459626 -0.689649 -0.559578    0 0
  v -2.03322 -3.04294 4.85396    -0.493966 -0.741087 -0.45474    0 0
  v -2.1342 -3.19406 5.27896    -0.525886 -0.788534 -0.318838    0 0
  v -2.1932 -3.28235 5.70396    -0.546215 -0.818146 -0.179684    0 0
  v -2.22082 -3.3237 6.12896    -0.554015 -0.829329 -0.0726731    0 0
  v -2.22767 -3.33395 6.55396    -0.554926 -0.830256 0.0522615    0 0
  v -2.18101 -3.26412 7.17896    -0.54195 -0.809862 0.22453    0 0
  v -2.06621 -3.0923 7.80396    -0.520773 -0.778605 0.350099    0 0
  v -1.92102 -2.87502 8.42896    -0.514407 -0.770065 0.377339    0 0
  v -1.78322 -2.66877 9.05396    -0.520128 -0.778831 0.350555    0 0
  v -1.70752 -2.55549 9.44096    -0.524739 -0.785404 0.328314    0 0
  v -1.63356 -2.4448 9.82896    -0.527399 -0.789516 0.31387    0 0
  v -1.56498 -2.34216 10.217    -0.532368 -0.797061 0.285095    0 0
  v -1.50543 -2.25304 10.604    -0.539897 -0.808476 0.234259    0 0
  v -1.50281 -2.24911 10.627    -0.54732 -0.819439 0.170179    0 0
  v -1.50109 -2.24654 10.649    -0.55235 -0.826856 0.105919    0 0
  v -1.50016 -2.24515 10.672    -0.554898 -0.830533 0.0479856    0 0
  v -1.49988 -2.24472 10.694    -0.555567 -0.831456 -0.00520061    0 0
  v -1.50014 -2.24511 10.708    -0.555013 -0.830399 0.0489692    0 0
  v -1.49918 -2.24369 10.721    -0.525479 -0.782266 0.334561    0 0
  v -1.49441 -2.23654 10.735    -0.40762 -0.601582 0.686983    0 0
  v -1.48321 -2.21978 10.749    -0.200335 -0.285665 0.937156    0 0
  v -1.47798 -2.21196 10.75    -0.0610785 -0.0916699 0.993915    0 0
  v -1.46835 -2.19754 10.752    -0.0494158 -0.0723625 0.996153    0 0
  v -1.4592 -2.18385 10.753    -0.0562357 -0.0866813 0.994648    0 0
  v -1.45543 -2.17821 10.754    -0.0849907 -0.118581 0.9893    0 0
  v -1.44595 -2.16401 10.717    0.544842 0.818133 0.183866    0 0
  v -1.44727 -2.166 10.679    0.546515 0.816558 -0.185887    0 0
  v -1.45406 -2.17616 10.641    0.527762 0.789727 -0.312729    0 0
  v -1.46099 -2.18652 10.604    0.531525 0.796011 -0.289567    0 0
  v -1.5188 -2.27305 10.217    0.53446 0.799642 -0.273723    0 0
  v -1.58356 -2.36996 9.82896    0.530318 0.793479 -0.298587    0 0
  v -1.6537 -2.47494 9.44096    0.526922 0.788438 -0.317363    0 0
  v -1.72766 -2.58563 9.05396    0.523195 0.782773 -0.336946    0 0
  v -1.85679 -2.77888 8.42896    0.521436 0.780462 -0.344939    0 0
  v -1.98288 -2.96758 7.80396    0.528992 0.792399 -0.303761    0 0
  v -2.07858 -3.11082 7.17896    0.545274 0.816942 -0.187833    0 0
  v -2.11656 -3.16766 6.55396    0.579104 0.807979 -0.108668    0 0
  v -0.00371447 -0.00896835 0.953961    0.288087 0.765596 -0.575212    0 0
  v -0.0373699 -0.09022 0.828961    0.31742 0.767343 -0.557162    0 0
  v -0.0679505 -0.164048 0.703961    0.282747 0.671649 -0.684793    0 0
  v -0.133383 -0.322015 0.578961    0.18147 0.426718 -0.885991    0 0
  v -0.271593 -0.655684 0.453961    0.0995092 0.233906 -0.967153    0 0
  v -0.454743 -1.09785 0.366461    0.0609227 0.145153 -0.987532    0 0
  v -0.700676 -1.69158 0.278961    0.0514266 0.124106 -0.990935    0 0
  v -0.947327 -2.28705 0.191961    0.0591409 0.144711 -0.987705    0 0
  v -1.13263 -2.73441 0.103961    0.100869 0.251339 -0.962629    0 0
  v -1.14476 -2.7637 0.0917106    0.203832 0.507355 -0.837284    0 0
  v -1.14942 -2.77495 0.0794606    0.257277 0.617583 -0.743236    0 0
  v -1.15525 -2.78902 0.0672107    0.183309 0.427732 -0.885123    0 0
  v -1.1709 -2.8268 0.0549607    0.0633423 0.141363 -0.987929    0 0
  v -1.1757 -2.83839 0.0547109    0.00241474 0.00456116 -0.999987    0 0
  v -1.18561 -2.86231 0.0549607    0.00493118 0.0140047 -0.99989    0 0
  v -1.19534 -2.88581 0.0539608    0.00811529 0.0179063 -0.999807    0 0
  v -1.1996 -2.89609 0.0539608    -0.0854097 -0.226993 -0.970144    0 0
  v -1.23548 -2.98271 0.103961    -0.255158 -0.632693 -0.73116    0 0
  v -1.24744 -3.01158 0.153961    -0.350099 -0.772492 -0.5298    0 0
  v -1.23548 -2.98271 0.203961    -0.266957 -0.627805 0.73116    0 0
  v -1.1996 -2.89609 0.253961    -0.142421 -0.334375 0.931617    0 0
  v -0.959346 -2.31607 0.416961    -0.0847499 -0.201813 0.975751    0 0
  v -0.632272 -1.52644 0.578961    -0.0755393 -0.183407 0.98013    0 0
  v -0.342509 -0.826891 0.741961    -0.120943 -0.301673 0.94571    0 0
  v -0.21419 -0.517102 0.903961    -0.179652 -0.3964 0.900329    0 0
  v -0.210393 -0.507936 0.940961    -0.361464 -0.870405 0.334273    0 0
  v -0.203906 -0.492273 0.978961    -0.350276 -0.845829 0.402343    0 0
  v -0.197777 -0.477476 1.01596    -0.364969 -0.883904 0.292423    0 0
  v -0.195056 -0.470908 1.05396    -0.380791 -0.920038 0.0923466    0 0
  v -0.195056 -0.470908 1.35396    -0.382683 -0.92388 0    0 0
  v -0.195056 -0.470908 1.65396    -0.382683 -0.92388 0    0 0
  v -0.195056 -0.470908 1.95396    -0.382683 -0.92388 0    0 0
  v -0.195056 -0.470908 2.25396    -0.381107 -0.919242 -0.0987447    0 0
  v -0.200808 -0.484795 2.32896    -0.360738 -0.866307 -0.345515    0 0
  v -0.216773 -0.523339 2.40396    -0.316524 -0.759449 -0.568375    0 0
  v -0.241014 -0.581861 2.47896    -0.278793 -0.669661 -0.688353    0 0
  v -0.271593 -0.655684 2.55396    -0.242574 -0.580771 -0.777086    0 0
  v -0.443757 -1.07133 2.86696    -0.203902 -0.488642 -0.848324    0 0
  v -0.658148 -1.58891 3.17896    -0.185542 -0.447779 -0.874682    0 0
  v -0.875387 -2.11337 3.49196    -0.196988 -0.4785 -0.855706    0 0
  v -1.05609 -2.54964 3.80396    -0.230517 -0.561143 -0.794972    0 0
  v -1.17045 -2.82571 4.06596    -0.265315 -0.643607 -0.717898    0 0
  v -1.26432 -3.05233 4.32896    -0.291901 -0.707536 -0.643573    0 0
  v -1.34018 -3.23548 4.59096    -0.31625 -0.766066 -0.559578    0 0
  v -1.40051 -3.38113 4.85396    -0.339895 -0.823215 -0.454739    0 0
  v -1.47006 -3.54905 5.27896    -0.361946 -0.875978 -0.318838    0 0
  v -1.5107 -3.64716 5.70396    -0.376108 -0.908987 -0.179683    0 0
  v -1.52973 -3.69309 6.12896    -0.381576 -0.921476 -0.0726732    0 0
  v -1.53445 -3.70449 6.55396    -0.382288 -0.922564 0.0522611    0 0
  v -1.50231 -3.6269 7.17896    -0.373541 -0.90003 0.22453    0 0
  v -1.42323 -3.43598 7.80396    -0.358868 -0.865242 0.350099    0 0
  v -1.32322 -3.19455 8.42896    -0.35429 -0.855625 0.377339    0 0
  v -1.2283 -2.96538 9.05396    -0.358192 -0.865338 0.350555    0 0
  v -1.17616 -2.8395 9.44096    -0.361431 -0.872684 0.328314    0 0
  v -1.12522 -2.71651 9.82896    -0.363239 -0.877236 0.31387    0 0
  v -1.07798 -2.60247 10.217    -0.36664 -0.885605 0.285095    0 0
  v -1.03696 -2.50344 10.604    -0.371797 -0.898271 0.234258    0 0
  v -1.03515 -2.49908 10.627    -0.376939 -0.91047 0.170179    0 0
  v -1.03397 -2.49623 10.649    -0.380425 -0.918727 0.105916    0 0
  v -1.03333 -2.49467 10.672    -0.382207 -0.92283 0.0479794    0 0
  v -1.03313 -2.4942 10.694    -0.382683 -0.923865 -0.0051913    0 0
  v -1.03331 -2.49464 10.708    -0.382346 -0.922721 0.0489719    0 0
  v -1.03265 -2.49305 10.721    -0.36277 -0.869753 0.334555    0 0
  v -1.02937 -2.48511 10.735    -0.282425 -0.669545 0.686983    0 0
  v -1.02165 -2.46649 10.749    -0.140755 -0.319259 0.937156    0 0
  v -1.01805 -2.4578 10.75    -0.0420213 -0.101825 0.993914    0 0
  v -1.01142 -2.44177 10.752    -0.0343491 -0.0806128 0.996153    0 0
  v -1.00511 -2.42656 10.753    -0.0382436 -0.0959847 0.994648    0 0
  v -1.00252 -2.42029 10.754    -0.0602212 -0.132877 0.989301    0 0
  v -0.995985 -2.40452 10.717    0.374763 0.908706 0.183865    0 0
  v -0.996897 -2.40673 10.679    0.376711 0.907487 -0.18589    0 0
  v -1.00158 -2.41802 10.641    0.363553 0.877514 -0.312726    0 0
  v -1.00634 -2.42953 10.604    0.366018 0.884411 -0.289564    0 0
  v -1.04617 -2.52567 10.217    0.368188 0.888545 -0.273723    0 0
  v -1.09077 -2.63336 9.82896    0.365329 0.881692 -0.298587    0 0
  v -1.13909 -2.75 9.44096    0.36298 0.876086 -0.317363    0 0
  v -1.19003 -2.873 9.05396    0.360431 0.869803 -0.336946    0 0
  v -1.27898 -3.08773 8.42896    0.359156 0.867193 -0.344939    0 0
  v -1.36583 -3.2974 7.80396    0.364239 0.880375 -0.303761    0 0
  v -1.43175 -3.45656 7.17896    0.375419 0.907623 -0.187833    0 0
  v -1.45791 -3.51971 6.55396    0.410348 0.905431 -0.108668    0 0
  v -0.00189347 -0.00952077 0.953961    0.133161 0.807092 -0.575213    0 0
  v -0.0190509 -0.095777 0.828961    0.161607 0.814527 -0.557162    0 0
  v -0.0346407 -0.174152 0.703961    0.14628 0.713905 -0.684793    0 0
  v -0.0679977 -0.341849 0.578961    0.0947337 0.453922 -0.885991    0 0
  v -0.138457 -0.696071 0.453961    0.0519639 0.248825 -0.967153    0 0
  v -0.231826 -1.16547 0.366461    0.0314341 0.154249 -0.987532    0 0
  v -0.357202 -1.79578 0.278961    0.0262265 0.131754 -0.990935    0 0
  v -0.482943 -2.42792 0.191961    0.0297728 0.153468 -0.987705    0 0
  v -0.57741 -2.90284 0.103961    0.0498965 0.266187 -0.962629    0 0
  v -0.583595 -2.93393 0.0917106    0.100935 0.537371 -0.837284    0 0
  v -0.58597 -2.94587 0.0794606    0.13185 0.655912 -0.743233    0 0
  v -0.588942 -2.96081 0.0672107    0.0963409 0.455277 -0.885122    0 0
  v -0.596919 -3.00092 0.0549607    0.0345464 0.151004 -0.987929    0 0
  v -0.599365 -3.01321 0.0547109    0.00147852 0.00494469 -0.999987    0 0
  v -0.604418 -3.03861 0.0549607    0.00210423 0.0146976 -0.99989    0 0
  v -0.609379 -3.06356 0.0539608    0.00446599 0.0191455 -0.999807    0 0
  v -0.611551 -3.07448 0.0539608    -0.0394844 -0.239294 -0.970144    0 0
  v -0.62984 -3.16642 0.103961    -0.126823 -0.670315 -0.731159    0 0
  v -0.635937 -3.19707 0.153961    -0.192666 -0.82595 -0.529798    0 0
  v -0.62984 -3.16642 0.203961    -0.139349 -0.667823 0.731159    0 0
  v -0.611551 -3.07448 0.253961    -0.0744512 -0.355735 0.931617    0 0
  v -0.48907 -2.45873 0.416961    -0.0437497 -0.214469 0.975751    0 0
  v -0.322329 -1.62046 0.578961    -0.0383069 -0.19462 0.98013    0 0
  v -0.174609 -0.877823 0.741961    -0.0597648 -0.319471 0.945709    0 0
  v -0.109193 -0.548953 0.903961    -0.0988653 -0.423832 0.900329    0 0
  v -0.107257 -0.539221 0.940961    -0.18471 -0.924199 0.334273    0 0
  v -0.10395 -0.522594 0.978961    -0.178531 -0.897913 0.402343    0 0
  v -0.100826 -0.506886 1.01596    -0.185514 -0.938122 0.292424    0 0
  v -0.0994386 -0.499913 1.05396    -0.193983 -0.976649 0.0923457    0 0
  v -0.0994386 -0.499913 1.35396    -0.19509 -0.980785 0    0 0
  v -0.0994386 -0.499913 1.65396    -0.19509 -0.980785 0    0 0
  v -0.0994386 -0.499913 1.95396    -0.19509 -0.980785 0    0 0
  v -0.0994386 -0.499913 2.25396    -0.194449 -0.97593 -0.098744    0 0
  v -0.102371 -0.514656 2.32896    -0.184797 -0.920038 -0.345515    0 0
  v -0.11051 -0.555573 2.40396    -0.162279 -0.806607 -0.568375    0 0
  v -0.122868 -0.6177 2.47896    -0.14279 -0.711183 -0.688353    0 0
  v -0.138457 -0.696071 2.55396    -0.124609 -0.616935 -0.777086    0 0
  v -0.226225 -1.13731 2.86696    -0.104655 -0.519032 -0.848324    0 0
  v -0.335521 -1.68678 3.17896    -0.094619 -0.475372 -0.874682    0 0
  v -0.446268 -2.24354 3.49196    -0.0998519 -0.507736 -0.855706    0 0
  v -0.538392 -2.70668 3.80396    -0.116613 -0.595332 -0.794972    0 0
  v -0.59669 -2.99976 4.06596    -0.134655 -0.683001 -0.717898    0 0
  v -0.644543 -3.24034 4.32896    -0.148258 -0.750888 -0.643573    0 0
  v -0.683217 -3.43476 4.59096    -0.160721 -0.813044 -0.559578    0 0
  v -0.713973 -3.58939 4.85396    -0.172763 -0.873708 -0.454739    0 0
  v -0.749431 -3.76765 5.27896    -0.184096 -0.929759 -0.318838    0 0
  v -0.770149 -3.8718 5.70396    -0.191546 -0.964896 -0.179684    0 0
  v -0.779849 -3.92057 6.12896    -0.194473 -0.978212 -0.0726731    0 0
  v -0.782255 -3.93266 6.55396    -0.194959 -0.979418 0.0522613    0 0
  v -0.76587 -3.85029 7.17896    -0.190776 -0.95561 0.22453    0 0
  v -0.725557 -3.64762 7.80396    -0.183172 -0.918629 0.350099    0 0
  v -0.674574 -3.39131 8.42896    -0.180558 -0.908303 0.377339    0 0
  v -0.626182 -3.14803 9.05396    -0.18249 -0.91859 0.350555    0 0
  v -0.599601 -3.0144 9.44096    -0.184234 -0.926427 0.328314    0 0
  v -0.57363 -2.88383 9.82896    -0.185119 -0.931245 0.31387    0 0
  v -0.549549 -2.76277 10.217    -0.186822 -0.940116 0.285095    0 0
  v -0.528637 -2.65764 10.604    -0.189409 -0.953544 0.234259    0 0
  v -0.527715 -2.653 10.627    -0.192072 -0.966513 0.17018    0 0
  v -0.527113 -2.64998 10.649    -0.19388 -0.975291 0.105917    0 0
  v -0.526785 -2.64833 10.672    -0.194827 -0.979663 0.047978    0 0
  v -0.526686 -2.64783 10.694    -0.195092 -0.980771 -0.00520285    0 0
  v -0.526778 -2.64829 10.708    -0.194985 -0.979582 0.0489847    0 0
  v -0.526443 -2.64661 10.721    -0.186119 -0.923816 0.334551    0 0
  v -0.524766 -2.63818 10.735    -0.146376 -0.711779 0.686982    0 0
  v -0.520834 -2.61841 10.749    -0.0757655 -0.340583 0.937157    0 0
  v -0.518999 -2.60918 10.75    -0.0213487 -0.108066 0.993915    0 0
  v -0.515615 -2.59217 10.752    -0.0179623 -0.0857652 0.996153    0 0
  v -0.512402 -2.57602 10.753    -0.0187834 -0.101604 0.994648    0 0
  v -0.511079 -2.56937 10.754    -0.0331405 -0.142072 0.989301    0 0
  v -0.507749 -2.55263 10.717    0.190282 0.964358 0.183866    0 0
  v -0.508214 -2.55497 10.679    0.192431 0.963543 -0.185888    0 0
  v -0.510599 -2.56696 10.641    0.185373 0.931578 -0.312728    0 0
  v -0.51303 -2.57918 10.604    0.186445 0.938825 -0.289562    0 0
  v -0.533332 -2.68124 10.217    0.187767 0.943302 -0.273724    0 0
  v -0.556072 -2.79556 9.82896    0.186299 0.936023 -0.298587    0 0
  v -0.580702 -2.91939 9.44096    0.185089 0.930066 -0.317363    0 0
  v -0.606673 -3.04996 9.05396    0.183815 0.923407 -0.336945    0 0
  v -0.652017 -3.27791 8.42896    0.183074 0.920598 -0.344939    0 0
  v -0.696293 -3.5005 7.80396    0.185487 0.934518 -0.303761    0 0
  v -0.7299 -3.66946 7.17896    0.191137 0.963424 -0.187833    0 0
  v -0.743237 -3.7365 6.55396    0.225822 0.968089 -0.108668    0 0
  v 3.15566e-007 -0.00970721 0.953961    -0.0268035 0.817568 -0.575208    0 0
  v 3.23254e-007 -0.0976532 0.828961    -0.000406931 0.830404 -0.557162    0 0
  v 3.3024e-007 -0.177564 0.703961    0.00419409 0.728726 -0.684793    0 0
  v 3.45188e-007 -0.348546 0.578961    0.00435828 0.463682 -0.885991    0 0
  v 3.76762e-007 -0.709707 0.453961    0.00242204 0.254182 -0.967153    0 0
  v 4.18602e-007 -1.1883 0.366461    0.000737689 0.157418 -0.987532    0 0
  v 4.74784e-007 -1.83096 0.278961    1.8731e-005 0.134339 -0.990935    0 0
  v 5.31131e-007 -2.47549 0.191961    -0.000739338 0.156327 -0.987705    0 0
  v 5.73463e-007 -2.95971 0.103961    -0.00299273 0.270807 -0.962629    0 0
  v 5.76234e-007 -2.99141 0.0917106    -0.00583985 0.546738 -0.837283    0 0
  v 5.77298e-007 -3.00358 0.0794606    0.00135395 0.669033 -0.743231    0 0
  v 5.7863e-007 -3.01882 0.0672107    0.00566979 0.465327 -0.885121    0 0
  v 5.82205e-007 -3.05971 0.0549607    0.0044232 0.154842 -0.987929    0 0
  v 5.83301e-007 -3.07225 0.0547109    0.000485453 0.00513801 -0.999987    0 0
  v 5.85565e-007 -3.09814 0.0549607    -0.000803564 0.0148257 -0.99989    0 0
  v 5.87788e-007 -3.12357 0.0539608    0.000645079 0.0196488 -0.999807    0 0
  v 5.88762e-007 -3.13471 0.0539608    0.00795803 -0.242399 -0.970144    0 0
  v 5.96958e-007 -3.22846 0.103961    0.0063855 -0.682177 -0.731159    0 0
  v 5.9969e-007 -3.25971 0.153961    -0.0278292 -0.847668 -0.529796    0 0
  v 5.96958e-007 -3.22846 0.203961    -0.0063856 -0.682177 0.731159    0 0
  v 5.88762e-007 -3.13471 0.253961    -0.00362021 -0.363424 0.931617    0 0
  v 5.33877e-007 -2.50689 0.416961    -0.00106828 -0.218883 0.975751    0 0
  v 4.59157e-007 -1.65221 0.578961    0.000397458 -0.198353 0.98013    0 0
  v 3.92962e-007 -0.89502 0.741961    0.00370872 -0.324992 0.945709    0 0
  v 3.63648e-007 -0.559707 0.903961    -0.0142803 -0.434976 0.900329    0 0
  v 3.62781e-007 -0.549785 0.940961    -0.000860076 -0.942475 0.334274    0 0
  v 3.61299e-007 -0.532832 0.978961    7.24752e-005 -0.91549 0.402341    0 0
  v 3.59898e-007 -0.516816 1.01596    0.00106733 -0.956288 0.292424    0 0
  v 3.59277e-007 -0.509707 1.05396    0.000277244 -0.995727 0.0923451    0 0
  v 3.59277e-007 -0.509707 1.35396    -1.19537e-006 -1 0    0 0
  v 3.59277e-007 -0.509707 1.65396    -1.19536e-006 -1 0    0 0
  v 3.59277e-007 -0.509707 1.95396    -1.19037e-006 -1 0    0 0
  v 3.59277e-007 -0.509707 2.25396    -0.000319901 -0.995113 -0.0987437    0 0
  v 3.60591e-007 -0.524738 2.32896    -0.00175739 -0.938412 -0.345514    0 0
  v 3.64238e-007 -0.566457 2.40396    -0.00180113 -0.822768 -0.568375    0 0
  v 3.69776e-007 -0.629801 2.47896    -0.00130221 -0.725375 -0.688353    0 0
  v 3.76762e-007 -0.709707 2.55396    -0.00185699 -0.629391 -0.777086    0 0
  v 4.16092e-007 -1.1596 2.86696    -0.00138619 -0.529476 -0.848324    0 0
  v 4.65069e-007 -1.71983 3.17896    -6.0679e-005 -0.484697 -0.874682    0 0
  v 5.14696e-007 -2.2875 3.49196    0.00112121 -0.51746 -0.855706    0 0
  v 5.55978e-007 -2.75971 3.80396    0.00177053 -0.606643 -0.794972    0 0
  v 5.82102e-007 -3.05853 4.06596    0.00117858 -0.696147 -0.717898    0 0
  v 6.03546e-007 -3.30382 4.32896    0.00108142 -0.765384 -0.643573    0 0
  v 6.20876e-007 -3.50205 4.59096    0.000983829 -0.828777 -0.559579    0 0
  v 6.34659e-007 -3.65971 4.85396    0.00100823 -0.890624 -0.454739    0 0
  v 6.50548e-007 -3.84146 5.27896    0.000827982 -0.947809 -0.318838    0 0
  v 6.59832e-007 -3.94765 5.70396    0.000375723 -0.983724 -0.179683    0 0
  v 6.64179e-007 -3.99737 6.12896    0.000103693 -0.997356 -0.0726736    0 0
  v 6.65257e-007 -4.00971 6.55396    -0.000138422 -0.998633 0.0522613    0 0
  v 6.57915e-007 -3.92572 7.17896    -0.00068033 -0.974467 0.22453    0 0
  v 6.39849e-007 -3.71908 7.80396    -0.000437375 -0.936713 0.350099    0 0
  v 6.17003e-007 -3.45775 8.42896    0.000112038 -0.926075 0.377339    0 0
  v 5.95319e-007 -3.20971 9.05396    0.0002242 -0.936542 0.350555    0 0
  v 5.83407e-007 -3.07346 9.44096    4.26994e-005 -0.944569 0.328314    0 0
  v 5.71769e-007 -2.94033 9.82896    0.000115038 -0.949466 0.31387    0 0
  v 5.60978e-007 -2.8169 10.217    0.000175467 -0.958499 0.285095    0 0
  v 5.51607e-007 -2.70971 10.604    0.000257237 -0.972174 0.234261    0 0
  v 5.51194e-007 -2.70498 10.627    0.000175329 -0.985412 0.170185    0 0
  v 5.50924e-007 -2.70189 10.649    0.000114365 -0.994375 0.105919    0 0
  v 5.50777e-007 -2.70022 10.672    3.89233e-005 -0.998848 0.0479769    0 0
  v 5.50733e-007 -2.69971 10.694    -4.69223e-006 -0.999986 -0.00520752    0 0
  v 5.50774e-007 -2.70018 10.708    -0.000131623 -0.998799 0.0489886    0 0
  v 5.50624e-007 -2.69846 10.721    -0.00231555 -0.942372 0.33456    0 0
  v 5.49872e-007 -2.68986 10.735    -0.00470236 -0.726666 0.686975    0 0
  v 5.4811e-007 -2.66971 10.749    -0.00786522 -0.348821 0.937156    0 0
  v 5.47288e-007 -2.6603 10.75    0.000144194 -0.110154 0.993915    0 0
  v 5.45772e-007 -2.64296 10.752    -0.000885268 -0.0876202 0.996154    0 0
  v 5.44332e-007 -2.62649 10.753    0.00139933 -0.103319 0.994647    0 0
  v 5.43739e-007 -2.61971 10.754    -0.00478688 -0.145817 0.9893    0 0
  v 5.42247e-007 -2.60264 10.717    -0.00151069 0.98295 0.183867    0 0
  v 5.42455e-007 -2.60502 10.679    0.000755689 0.982571 -0.185886    0 0
  v 5.43524e-007 -2.61725 10.641    6.9042e-005 0.949843 -0.312728    0 0
  v 5.44613e-007 -2.62971 10.604    -0.000293059 0.957158 -0.289565    0 0
  v 5.53711e-007 -2.73377 10.217    0.000129759 0.961808 -0.273723    0 0
  v 5.63901e-007 -2.85033 9.82896    0.000110278 0.954382 -0.298587    0 0
  v 5.74938e-007 -2.97658 9.44096    8.63731e-005 0.948304 -0.317363    0 0
  v 5.86576e-007 -3.10971 9.05396    0.000135555 0.941524 -0.336945    0 0
  v 6.06895e-007 -3.34213 8.42896    -4.32832e-005 0.938625 -0.344939    0 0
  v 6.26736e-007 -3.56908 7.80396    -0.000392641 0.952748 -0.303761    0 0
  v 6.41796e-007 -3.74135 7.17896    -0.000489803 0.982201 -0.187833    0 0
  v 6.47772e-007 -3.80971 6.55396    0.0326184 0.993543 -0.108667    0 0
  v 0.00189409 -0.00952101 0.953961    -0.185817 0.796618 -0.575215    0 0
  v 0.0190515 -0.095777 0.828961    -0.162378 0.814373 -0.557162    0 0
  v 0.0346414 -0.174153 0.703961    -0.138053 0.715541 -0.684793    0 0
  v 0.0679984 -0.341849 0.578961    -0.0861843 0.455623 -0.885991    0 0
  v 0.138457 -0.696071 0.453961    -0.0472125 0.24977 -0.967153    0 0
  v 0.231827 -1.16547 0.366461    -0.0299872 0.154537 -0.987532    0 0
  v 0.357203 -1.79578 0.278961    -0.0261899 0.131761 -0.990935    0 0
  v 0.482944 -2.42792 0.191961    -0.0312231 0.153179 -0.987705    0 0
  v 0.577411 -2.90284 0.103961    -0.0557672 0.265019 -0.962629    0 0
  v 0.583596 -2.93393 0.0917106    -0.112391 0.535092 -0.837285    0 0
  v 0.585971 -2.94587 0.0794606    -0.129194 0.656441 -0.743232    0 0
  v 0.588943 -2.96081 0.0672107    -0.0852199 0.457492 -0.885121    0 0
  v 0.59692 -3.00092 0.0549607    -0.02587 0.15273 -0.987929    0 0
  v 0.599366 -3.01321 0.0547109    -0.000526224 0.00513383 -0.999987    0 0
  v 0.604419 -3.03861 0.0549607    -0.00368049 0.0143841 -0.99989    0 0
  v 0.60938 -3.06356 0.0539608    -0.00320062 0.0193971 -0.999807    0 0
  v 0.611552 -3.07448 0.0539608    0.0550949 -0.236189 -0.970144    0 0
  v 0.629842 -3.16642 0.103961    0.139349 -0.667824 -0.731159    0 0
  v 0.635938 -3.19707 0.153961    0.138077 -0.836809 -0.529797    0 0
  v 0.629842 -3.16642 0.203961    0.126823 -0.670315 0.731159    0 0
  v 0.611552 -3.07448 0.253961    0.06735 -0.357148 0.931617    0 0
  v 0.489072 -2.45873 0.416961    0.0416543 -0.214886 0.975751    0 0
  v 0.32233 -1.62046 0.578961    0.0390867 -0.194465 0.98013    0 0
  v 0.17461 -0.877823 0.741961    0.0670407 -0.318024 0.945709    0 0
  v 0.109194 -0.548953 0.903961    0.0708533 -0.429404 0.900329    0 0
  v 0.107258 -0.539222 0.940961    0.183025 -0.924534 0.334274    0 0
  v 0.103951 -0.522594 0.978961    0.178675 -0.897884 0.402342    0 0
  v 0.100826 -0.506886 1.01596    0.187611 -0.937705 0.292423    0 0
  v 0.0994393 -0.499914 1.05396    0.194531 -0.97654 0.0923451    0 0
  v 0.0994393 -0.499914 1.35396    0.195091 -0.980785 0    0 0
  v 0.0994393 -0.499914 1.65396    0.195091 -0.980785 0    0 0
  v 0.0994393 -0.499914 1.95396    0.195091 -0.980785 0    0 0
  v 0.0994393 -0.499914 2.25396    0.193825 -0.976054 -0.0987445    0 0
  v 0.102372 -0.514656 2.32896    0.181352 -0.920723 -0.345514    0 0
  v 0.110511 -0.555573 2.40396    0.158747 -0.80731 -0.568375    0 0
  v 0.122869 -0.6177 2.47896    0.140236 -0.711691 -0.688353    0 0
  v 0.138457 -0.696071 2.55396    0.120967 -0.61766 -0.777086    0 0
  v 0.226226 -1.13731 2.86696    0.101936 -0.519573 -0.848324    0 0
  v 0.335522 -1.68678 3.17896    0.0945001 -0.475396 -0.874682    0 0
  v 0.446269 -2.24354 3.49196    0.102051 -0.507299 -0.855706    0 0
  v 0.538393 -2.70668 3.80396    0.120087 -0.594641 -0.794972    0 0
  v 0.596691 -2.99976 4.06596    0.136967 -0.682541 -0.717898    0 0
  v 0.644544 -3.24034 4.32896    0.15038 -0.750466 -0.643573    0 0
  v 0.683218 -3.43476 4.59096    0.162651 -0.81266 -0.559579    0 0
  v 0.713974 -3.58939 4.85396    0.174741 -0.873314 -0.454739    0 0
  v 0.749432 -3.76765 5.27896    0.185721 -0.929435 -0.318838    0 0
  v 0.77015 -3.8718 5.70396    0.192284 -0.964749 -0.179683    0 0
  v 0.77985 -3.92057 6.12896    0.194676 -0.978172 -0.0726731    0 0
  v 0.782256 -3.93266 6.55396    0.194688 -0.979472 0.0522609    0 0
  v 0.765872 -3.85029 7.17896    0.189442 -0.955875 0.22453    0 0
  v 0.725558 -3.64762 7.80396    0.182315 -0.918799 0.350099    0 0
  v 0.674575 -3.39131 8.42896    0.180778 -0.908259 0.377339    0 0
  v 0.626184 -3.14803 9.05396    0.18293 -0.918503 0.350555    0 0
  v 0.599603 -3.0144 9.44096    0.184318 -0.926411 0.328314    0 0
  v 0.573631 -2.88383 9.82896    0.185345 -0.9312 0.31387    0 0
  v 0.54955 -2.76277 10.217    0.187166 -0.940048 0.285095    0 0
  v 0.528638 -2.65764 10.604    0.189915 -0.953444 0.234258    0 0
  v 0.527716 -2.653 10.627    0.192417 -0.966444 0.170179    0 0
  v 0.527114 -2.64998 10.649    0.194105 -0.975246 0.105919    0 0
  v 0.526787 -2.64833 10.672    0.194904 -0.979648 0.0479775    0 0
  v 0.526688 -2.64783 10.694    0.195083 -0.980773 -0.0051968    0 0
  v 0.526779 -2.64829 10.708    0.194727 -0.979634 0.0489808    0 0
  v 0.526444 -2.64661 10.721    0.181576 -0.924714 0.334566    0 0
  v 0.524767 -2.63818 10.735    0.137153 -0.713621 0.686974    0 0
  v 0.520835 -2.61841 10.749    0.0603377 -0.343653 0.937156    0 0
  v 0.519 -2.60918 10.75    0.0216316 -0.10801 0.993914    0 0
  v 0.515616 -2.59217 10.752    0.0162258 -0.0861099 0.996154    0 0
  v 0.512403 -2.57602 10.753    0.021528 -0.101056 0.994648    0 0
  v 0.51108 -2.56937 10.754    0.0237512 -0.143945 0.989301    0 0
  v 0.50775 -2.55263 10.717    -0.193246 0.963768 0.183866    0 0
  v 0.508215 -2.55497 10.679    -0.190949 0.963838 -0.185888    0 0
  v 0.5106 -2.56696 10.641    -0.185237 0.931606 -0.312726    0 0
  v 0.513031 -2.57918 10.604    -0.18702 0.93871 -0.289564    0 0
  v 0.533333 -2.68124 10.217    -0.187512 0.943353 -0.273723    0 0
  v 0.556073 -2.79556 9.82896    -0.186083 0.936066 -0.298587    0 0
  v 0.580703 -2.91939 9.44096    -0.184921 0.930099 -0.317363    0 0
  v 0.606675 -3.04996 9.05396    -0.183549 0.92346 -0.336945    0 0
  v 0.652018 -3.27791 8.42896    -0.183159 0.920581 -0.344939    0 0
  v 0.696294 -3.5005 7.80396    -0.186257 0.934365 -0.303761    0 0
  v 0.729902 -3.66946 7.17896    -0.192098 0.963232 -0.187833    0 0
  v 0.743238 -3.7365 6.55396    -0.161839 0.980816 -0.108668    0 0
  v 0.00371511 -0.00896835 0.953961    -0.337717 0.745036 -0.575212    0 0
  v 0.0373706 -0.0902197 0.828961    -0.318177 0.76703 -0.557162    0 0
  v 0.0679512 -0.164048 0.703961    -0.275002 0.674858 -0.684793    0 0
  v 0.133383 -0.322015 0.578961    -0.173419 0.430053 -0.885991    0 0
  v 0.271594 -0.655684 0.453961    -0.0950336 0.23576 -0.967153    0 0
  v 0.454744 -1.09785 0.366461    -0.0595598 0.145717 -0.987532    0 0
  v 0.700677 -1.69158 0.278961    -0.0513921 0.12412 -0.990935    0 0
  v 0.947328 -2.28705 0.191961    -0.060507 0.144145 -0.987705    0 0
  v 1.13263 -2.73441 0.103961    -0.106399 0.249049 -0.962629    0 0
  v 1.14476 -2.7637 0.0917106    -0.214623 0.502884 -0.837284    0 0
  v 1.14942 -2.77495 0.0794606    -0.254778 0.618625 -0.743231    0 0
  v 1.15525 -2.78902 0.0672107    -0.172835 0.432075 -0.885121    0 0
  v 1.1709 -2.8268 0.0549607    -0.0551689 0.144748 -0.987929    0 0
  v 1.1757 -2.83839 0.0547109    -0.00151774 0.00493266 -0.999987    0 0
  v 1.18561 -2.86231 0.0549607    -0.00641599 0.0133897 -0.99989    0 0
  v 1.19534 -2.88581 0.0539608    -0.00692334 0.0184001 -0.999807    0 0
  v 1.1996 -2.89609 0.0539608    0.100114 -0.220902 -0.970144    0 0
  v 1.23548 -2.98271 0.103961    0.266958 -0.627807 -0.731158    0 0
  v 1.24744 -3.01158 0.153961    0.298679 -0.793794 -0.529795    0 0
  v 1.23548 -2.98271 0.203961    0.255159 -0.632694 0.731158    0 0
  v 1.1996 -2.89609 0.253961    0.135732 -0.337146 0.931617    0 0
  v 0.959347 -2.31607 0.416961    0.0827761 -0.20263 0.975751    0 0
  v 0.632273 -1.52644 0.578961    0.076274 -0.183102 0.98013    0 0
  v 0.34251 -0.826891 0.741961    0.127796 -0.298834 0.945709    0 0
  v 0.214191 -0.517102 0.903961    0.153266 -0.40733 0.900329    0 0
  v 0.210394 -0.507935 0.940961    0.359878 -0.871062 0.334274    0 0
  v 0.203906 -0.492273 0.978961    0.350412 -0.845773 0.402343    0 0
  v 0.197777 -0.477476 1.01596    0.366945 -0.883086 0.292422    0 0
  v 0.195057 -0.470908 1.05396    0.381307 -0.919824 0.0923463    0 0
  v 0.195057 -0.470908 1.35396    0.382686 -0.923879 0    0 0
  v 0.195057 -0.470908 1.65396    0.382686 -0.923879 0    0 0
  v 0.195057 -0.470908 1.95396    0.382686 -0.923879 0    0 0
  v 0.195057 -0.470908 2.25396    0.380521 -0.919485 -0.0987445    0 0
  v 0.200809 -0.484795 2.32896    0.357494 -0.86765 -0.345515    0 0
  v 0.216774 -0.523338 2.40396    0.313197 -0.760827 -0.568375    0 0
  v 0.241015 -0.581861 2.47896    0.276387 -0.670657 -0.688353    0 0
  v 0.271594 -0.655684 2.55396    0.239143 -0.582192 -0.777086    0 0
  v 0.443758 -1.07133 2.86696    0.201342 -0.489702 -0.848324    0 0
  v 0.658149 -1.58891 3.17896    0.18543 -0.447825 -0.874682    0 0
  v 0.875388 -2.11337 3.49196    0.19906 -0.477642 -0.855706    0 0
  v 1.05609 -2.54964 3.80396    0.233789 -0.559788 -0.794972    0 0
  v 1.17045 -2.82571 4.06596    0.267493 -0.642705 -0.717898    0 0
  v 1.26432 -3.05233 4.32896    0.293899 -0.706709 -0.643573    0 0
  v 1.34018 -3.23548 4.59096    0.318068 -0.765313 -0.559579    0 0
  v 1.40051 -3.38113 4.85396    0.341759 -0.822444 -0.454739    0 0
  v 1.47006 -3.54905 5.27896    0.363476 -0.875344 -0.318838    0 0
  v 1.5107 -3.64716 5.70396    0.376803 -0.908699 -0.179684    0 0
  v 1.52973 -3.69309 6.12896    0.381767 -0.921397 -0.0726727    0 0
  v 1.53445 -3.70449 6.55396    0.382033 -0.92267 0.0522612    0 0
  v 1.50231 -3.6269 7.17896    0.372284 -0.90055 0.22453    0 0
  v 1.42323 -3.43598 7.80396    0.358061 -0.865577 0.350099    0 0
  v 1.32323 -3.19455 8.42896    0.354498 -0.855539 0.377339    0 0
  v 1.2283 -2.96538 9.05396    0.358607 -0.865166 0.350555    0 0
  v 1.17616 -2.8395 9.44096    0.361511 -0.872651 0.328314    0 0
  v 1.12522 -2.71651 9.82896    0.363452 -0.877148 0.31387    0 0
  v 1.07798 -2.60247 10.217    0.366964 -0.885471 0.285095    0 0
  v 1.03696 -2.50344 10.604    0.372274 -0.898074 0.234255    0 0
  v 1.03515 -2.49908 10.627    0.377264 -0.910336 0.170179    0 0
  v 1.03397 -2.49623 10.649    0.380637 -0.918639 0.105917    0 0
  v 1.03333 -2.49467 10.672    0.382279 -0.9228 0.0479816    0 0
  v 1.03313 -2.4942 10.694    0.382674 -0.923869 -0.00519858    0 0
  v 1.03331 -2.49464 10.708    0.382103 -0.922821 0.0489781    0 0
  v 1.03266 -2.49305 10.721    0.358491 -0.871524 0.33456    0 0
  v 1.02937 -2.48511 10.735    0.273737 -0.673148 0.686979    0 0
  v 1.02165 -2.46649 10.749    0.126221 -0.325277 0.937157    0 0
  v 1.01805 -2.4578 10.75    0.042288 -0.101715 0.993914    0 0
  v 1.01142 -2.44177 10.752    0.0327135 -0.0812904 0.996153    0 0
  v 1.00511 -2.42656 10.753    0.0408298 -0.0949147 0.994648    0 0
  v 1.00252 -2.42029 10.754    0.0513755 -0.13654 0.989301    0 0
  v 0.995986 -2.40452 10.717    -0.377555 0.907549 0.183865    0 0
  v 0.996898 -2.40672 10.679    -0.375316 0.908066 -0.185889    0 0
  v 1.00158 -2.41802 10.641    -0.363426 0.877566 -0.312729    0 0
  v 1.00635 -2.42953 10.604    -0.36656 0.884188 -0.289562    0 0
  v 1.04617 -2.52567 10.217    -0.367949 0.888645 -0.273724    0 0
  v 1.09078 -2.63336 9.82896    -0.365125 0.881777 -0.298586    0 0
  v 1.13909 -2.75 9.44096    -0.362821 0.876152 -0.317363    0 0
  v 1.19003 -2.87299 9.05396    -0.360181 0.869907 -0.336946    0 0
  v 1.27898 -3.08772 8.42896    -0.359237 0.86716 -0.344939    0 0
  v 1.36583 -3.2974 7.80396    -0.364964 0.880074 -0.303761    0 0
  v 1.43175 -3.45656 7.17896    -0.376325 0.907248 -0.187833    0 0
  v 1.45791 -3.51971 6.55396    -0.350077 0.930396 -0.108668    0 0
  v 0.00539333 -0.00807118 0.953961    -0.476559 0.664847 -0.575212    0 0
  v 0.0542535 -0.0811954 0.828961    -0.461692 0.690226 -0.557162    0 0
  v 0.0986497 -0.147639 0.703961    -0.401372 0.608242 -0.684793    0 0
  v 0.193642 -0.289805 0.578961    -0.253984 0.387958 -0.885991    0 0
  v 0.394293 -0.5901 0.453961    -0.139202 0.21269 -0.967153    0 0
  v 0.660185 -0.988036 0.366461    -0.0868433 0.131298 -0.987532    0 0
  v 1.01723 -1.52238 0.278961    -0.0746192 0.111709 -0.990935    0 0
  v 1.37531 -2.05829 0.191961    -0.0874656 0.129571 -0.987705    0 0
  v 1.64433 -2.46091 0.103961    -0.152941 0.223505 -0.962629    0 0
  v 1.66194 -2.48727 0.0917106    -0.308605 0.451348 -0.837286    0 0
  v 1.6687 -2.49739 0.0794606    -0.370569 0.557033 -0.743232    0 0
  v 1.67717 -2.51005 0.0672107    -0.253808 0.390056 -0.88512    0 0
  v 1.69988 -2.54405 0.0549607    -0.0823474 0.131203 -0.987929    0 0
  v 1.70685 -2.55448 0.0547109    -0.00245104 0.00454203 -0.999987    0 0
  v 1.72124 -2.57601 0.0549607    -0.00890493 0.0118808 -0.99989    0 0
  v 1.73537 -2.59716 0.0539608    -0.01038 0.0166958 -0.999807    0 0
  v 1.74155 -2.60641 0.0539608    0.141287 -0.197126 -0.970144    0 0
  v 1.79364 -2.68436 0.103961    0.384307 -0.563663 -0.731158    0 0
  v 1.811 -2.71035 0.153961    0.447801 -0.720272 -0.529795    0 0
  v 1.79364 -2.68436 0.203961    0.373689 -0.570758 0.731158    0 0
  v 1.74155 -2.60641 0.253961    0.198898 -0.304188 0.931616    0 0
  v 1.39276 -2.08441 0.416961    0.120717 -0.182588 0.975751    0 0
  v 0.917918 -1.37376 0.578961    0.11053 -0.164704 0.98013    0 0
  v 0.497247 -0.744182 0.741961    0.18364 -0.26816 0.94571    0 0
  v 0.310957 -0.465379 0.903961    0.229786 -0.369603 0.900329    0 0
  v 0.305445 -0.457129 0.940961    0.522897 -0.784117 0.334274    0 0
  v 0.296026 -0.443033 0.978961    0.508679 -0.76116 0.402344    0 0
  v 0.287128 -0.429717 1.01596    0.532175 -0.794531 0.292421    0 0
  v 0.283179 -0.423806 1.05396    0.553428 -0.827762 0.0923441    0 0
  v 0.283179 -0.423806 1.35396    0.55557 -0.83147 0    0 0
  v 0.283179 -0.423806 1.65396    0.55557 -0.83147 0    0 0
  v 0.283179 -0.423806 1.95396    0.55557 -0.83147 0    0 0
  v 0.283179 -0.423806 2.25396    0.55259 -0.827583 -0.0987438    0 0
  v 0.291529 -0.436304 2.32896    0.519893 -0.781237 -0.345514    0 0
  v 0.314707 -0.470992 2.40396    0.455608 -0.685107 -0.568375    0 0
  v 0.349899 -0.52366 2.47896    0.401914 -0.60385 -0.688353    0 0
  v 0.394293 -0.5901 2.55396    0.348127 -0.524351 -0.777086    0 0
  v 0.644237 -0.964168 2.86696    0.293009 -0.441013 -0.848324    0 0
  v 0.955485 -1.42998 3.17896    0.269233 -0.403045 -0.874682    0 0
  v 1.27087 -1.90198 3.49196    0.288418 -0.42963 -0.855706    0 0
  v 1.53321 -2.29461 3.80396    0.338505 -0.503422 -0.794972    0 0
  v 1.69923 -2.54308 4.06596    0.387739 -0.57817 -0.717898    0 0
  v 1.83551 -2.74703 4.32896    0.426124 -0.635793 -0.643573    0 0
  v 1.94564 -2.91185 4.59096    0.461262 -0.688556 -0.559579    0 0
  v 2.03322 -3.04294 4.85396    0.495643 -0.739967 -0.454739    0 0
  v 2.1342 -3.19406 5.27896    0.527263 -0.787614 -0.318838    0 0
  v 2.1932 -3.28235 5.70396    0.546841 -0.817728 -0.179684    0 0
  v 2.22082 -3.32369 6.12896    0.554187 -0.829214 -0.0726733    0 0
  v 2.22767 -3.33395 6.55396    0.554696 -0.83041 0.0522614    0 0
  v 2.18102 -3.26412 7.17896    0.540819 -0.810617 0.22453    0 0
  v 2.06621 -3.0923 7.80396    0.520046 -0.779091 0.350099    0 0
  v 1.92103 -2.87502 8.42896    0.514593 -0.769941 0.377339    0 0
  v 1.78322 -2.66877 9.05396    0.520502 -0.778582 0.350555    0 0
  v 1.70752 -2.55549 9.44096    0.52481 -0.785356 0.328314    0 0
  v 1.63356 -2.4448 9.82896    0.527591 -0.789388 0.31387    0 0
  v 1.56498 -2.34216 10.217    0.532659 -0.796866 0.285095    0 0
  v 1.50543 -2.25304 10.604    0.540326 -0.808192 0.234253    0 0
  v 1.50281 -2.24911 10.627    0.547613 -0.819244 0.170174    0 0
  v 1.50109 -2.24654 10.649    0.55254 -0.826729 0.105919    0 0
  v 1.50016 -2.24515 10.672    0.554963 -0.83049 0.0479849    0 0
  v 1.49988 -2.24472 10.694    0.555559 -0.831461 -0.00520069    0 0
  v 1.50014 -2.24511 10.708    0.554794 -0.830545 0.0489742    0 0
  v 1.49918 -2.24369 10.721    0.521629 -0.784841 0.334557    0 0
  v 1.49441 -2.23654 10.735    0.3998 -0.606808 0.686982    0 0
  v 1.48321 -2.21978 10.749    0.187255 -0.294404 0.937156    0 0
  v 1.47798 -2.21196 10.75    0.0613182 -0.0915097 0.993915    0 0
  v 1.46835 -2.19754 10.752    0.0479438 -0.0733464 0.996153    0 0
  v 1.4592 -2.18384 10.753    0.0585638 -0.0851279 0.994647    0 0
  v 1.45543 -2.17821 10.754    0.0770283 -0.123897 0.989301    0 0
  v 1.44595 -2.16401 10.717    -0.547354 0.816454 0.183866    0 0
  v 1.44727 -2.16599 10.679    -0.545259 0.817397 -0.185888    0 0
  v 1.45406 -2.17616 10.641    -0.527647 0.789803 -0.31273    0 0
  v 1.46099 -2.18652 10.604    -0.532012 0.795685 -0.289565    0 0
  v 1.5188 -2.27305 10.217    -0.534244 0.799787 -0.273723    0 0
  v 1.58356 -2.36996 9.82896    -0.530135 0.793601 -0.298586    0 0
  v 1.6537 -2.47494 9.44096    -0.526778 0.788534 -0.317363    0 0
  v 1.72766 -2.58563 9.05396    -0.52297 0.782924 -0.336946    0 0
  v 1.85679 -2.77888 8.42896    -0.521508 0.780414 -0.344939    0 0
  v 1.98288 -2.96758 7.80396    -0.529645 0.791963 -0.303761    0 0
  v 2.07858 -3.11082 7.17896    -0.546089 0.816398 -0.187833    0 0
  v 2.11656 -3.16766 6.55396    -0.524862 0.844222 -0.108668    0 0
  v 0.0068643 -0.00686383 0.953961    -0.597082 0.55913 -0.57521    0 0
  v 0.0690515 -0.069051 0.828961    -0.587473 0.586895 -0.557162    0 0
  v 0.125557 -0.125557 0.703961    -0.51232 0.518253 -0.684793    0 0
  v 0.24646 -0.246459 0.578961    -0.32479 0.330955 -0.885991    0 0
  v 0.501839 -0.501839 0.453961    -0.178021 0.181446 -0.967153    0 0
  v 0.840256 -0.840255 0.366461    -0.11079 0.111833 -0.987532    0 0
  v 1.29468 -1.29468 0.278961    -0.0949788 0.0950052 -0.990935    0 0
  v 1.75043 -1.75043 0.191961    -0.111063 0.110017 -0.987705    0 0
  v 2.09283 -2.09283 0.103961    -0.193606 0.189373 -0.962629    0 0
  v 2.11525 -2.11525 0.0917106    -0.390731 0.382472 -0.837284    0 0
  v 2.12385 -2.12385 0.0794606    -0.472119 0.474034 -0.743233    0 0
  v 2.13463 -2.13462 0.0672107    -0.325028 0.333047 -0.885119    0 0
  v 2.16354 -2.16354 0.0549607    -0.106362 0.112617 -0.987929    0 0
  v 2.17241 -2.17241 0.0547109    -0.00329005 0.0039766 -0.999987    0 0
  v 2.19072 -2.19072 0.0549607    -0.0110517 0.0099153 -0.99989    0 0
  v 2.2087 -2.2087 0.0539608    -0.0134378 0.0143501 -0.999807    0 0
  v 2.21657 -2.21657 0.0539608    0.177029 -0.165774 -0.970144    0 0
  v 2.28286 -2.28286 0.103961    0.486888 -0.477857 -0.731158    0 0
  v 2.30496 -2.30496 0.153961    0.579714 -0.61907 -0.529796    0 0
  v 2.28286 -2.28286 0.203961    0.477857 -0.486888 0.731159    0 0
  v 2.21657 -2.21657 0.253961    0.25442 -0.25954 0.931617    0 0
  v 1.77264 -1.77264 0.416961    0.154018 -0.155529 0.975751    0 0
  v 1.16829 -1.16829 0.578961    0.140538 -0.139976 0.98013    0 0
  v 0.632875 -0.632875 0.741961    0.232427 -0.227182 0.945709    0 0
  v 0.395773 -0.395772 0.903961    0.297476 -0.317672 0.900329    0 0
  v 0.388757 -0.388757 0.940961    0.665824 -0.667039 0.334272    0 0
  v 0.37677 -0.376769 0.978961    0.647399 -0.647297 0.402344    0 0
  v 0.365445 -0.365444 1.01596    0.676953 -0.675443 0.292422    0 0
  v 0.360418 -0.360417 1.05396    0.704282 -0.703889 0.0923434    0 0
  v 0.360418 -0.360417 1.35396    0.707107 -0.707107 0    0 0
  v 0.360418 -0.360417 1.65396    0.707107 -0.707107 0    0 0
  v 0.360418 -0.360417 1.95396    0.707107 -0.707107 0    0 0
  v 0.360418 -0.360417 2.25396    0.703426 -0.703876 -0.098744    0 0
  v 0.371046 -0.371046 2.32896    0.662315 -0.6648 -0.345514    0 0
  v 0.400546 -0.400546 2.40396    0.580511 -0.583058 -0.568375    0 0
  v 0.445337 -0.445337 2.47896    0.511997 -0.513838 -0.688353    0 0
  v 0.501839 -0.501839 2.55396    0.443733 -0.44636 -0.777086    0 0
  v 0.819958 -0.819957 2.86696    0.373416 -0.375376 -0.848324    0 0
  v 1.2161 -1.2161 3.17896    0.34269 -0.342776 -0.874682    0 0
  v 1.61751 -1.6175 3.49196    0.366692 -0.365107 -0.855706    0 0
  v 1.95141 -1.95141 3.80396    0.430214 -0.42771 -0.794972    0 0
  v 2.16271 -2.16271 4.06596    0.493084 -0.491417 -0.717898    0 0
  v 2.33615 -2.33615 4.32896    0.541973 -0.540443 -0.643573    0 0
  v 2.47633 -2.47633 4.59096    0.586729 -0.585338 -0.559579    0 0
  v 2.5878 -2.5878 4.85396    0.630479 -0.629053 -0.454739    0 0
  v 2.71632 -2.71632 5.27896    0.670788 -0.669617 -0.318838    0 0
  v 2.79141 -2.79141 5.70396    0.695864 -0.695333 -0.179684    0 0
  v 2.82657 -2.82657 6.12896    0.70531 -0.705164 -0.0726733    0 0
  v 2.83529 -2.83529 6.55396    0.706043 -0.706238 0.0522611    0 0
  v 2.77591 -2.7759 7.17896    0.688571 -0.689533 0.22453    0 0
  v 2.62979 -2.62979 7.80396    0.662047 -0.662665 0.350099    0 0
  v 2.445 -2.445 8.42896    0.654913 -0.654755 0.377339    0 0
  v 2.26961 -2.26961 9.05396    0.662394 -0.662077 0.350555    0 0
  v 2.17326 -2.17326 9.44096    0.667941 -0.667881 0.328314    0 0
  v 2.07913 -2.07913 9.82896    0.671455 -0.671293 0.31387    0 0
  v 1.99185 -1.99185 10.217    0.677885 -0.677637 0.285095    0 0
  v 1.91605 -1.91605 10.604    0.687613 -0.687249 0.234257    0 0
  v 1.91271 -1.91271 10.627    0.696916 -0.696668 0.170179    0 0
  v 1.91053 -1.91053 10.649    0.70321 -0.703048 0.105918    0 0
  v 1.90934 -1.90934 10.672    0.70632 -0.706265 0.0479805    0 0
  v 1.90898 -1.90898 10.694    0.707094 -0.707101 -0.00519929    0 0
  v 1.90931 -1.90931 10.708    0.706165 -0.706351 0.0489764    0 0
  v 1.9081 -1.9081 10.721    0.664719 -0.667994 0.334563    0 0
  v 1.90202 -1.90202 10.735    0.510501 -0.517152 0.686981    0 0
  v 1.88777 -1.88777 10.749    0.241092 -0.252215 0.937156    0 0
  v 1.88112 -1.88112 10.75    0.0779929 -0.0777889 0.993915    0 0
  v 1.86885 -1.86885 10.752    0.0613313 -0.0625833 0.996154    0 0
  v 1.85721 -1.85721 10.753    0.0740461 -0.072067 0.994647    0 0
  v 1.85241 -1.85241 10.754    0.099722 -0.106492 0.9893    0 0
  v 1.84034 -1.84034 10.717    -0.696119 0.693982 0.183867    0 0
  v 1.84203 -1.84203 10.679    -0.694248 0.695317 -0.185888    0 0
  v 1.85067 -1.85067 10.641    -0.671591 0.671689 -0.312729    0 0
  v 1.85948 -1.85948 10.604    -0.67702 0.676606 -0.289566    0 0
  v 1.93307 -1.93307 10.217    -0.680009 0.680193 -0.273723    0 0
  v 2.01549 -2.01549 9.82896    -0.674772 0.674928 -0.298586    0 0
  v 2.10476 -2.10476 9.44096    -0.670491 0.670613 -0.317363    0 0
  v 2.1989 -2.19889 9.05396    -0.665662 0.665854 -0.336946    0 0
  v 2.36324 -2.36324 8.42896    -0.663739 0.663677 -0.344939    0 0
  v 2.52372 -2.52372 7.80396    -0.673972 0.673417 -0.303761    0 0
  v 2.64553 -2.64553 7.17896    -0.694867 0.694174 -0.187833    0 0
  v 2.69387 -2.69387 6.55396    -0.679476 0.725606 -0.108668    0 0
  v 0.00807155 -0.00539303 0.953961    -0.694677 0.431921 -0.575211    0 0
  v 0.0811959 -0.0542531 0.828961    -0.690672 0.461023 -0.557162    0 0
  v 0.14764 -0.0986493 0.703961    -0.603583 0.408346 -0.684793    0 0
  v 0.289806 -0.193642 0.578961    -0.383116 0.261232 -0.885991    0 0
  v 0.5901 -0.394292 0.453961    -0.209998 0.14323 -0.967153    0 0
  v 0.988037 -0.660184 0.366461    -0.130478 0.08807 -0.987532    0 0
  v 1.52239 -1.01722 0.278961    -0.111688 0.0746503 -0.990935    0 0
  v 2.05829 -1.37531 0.191961    -0.130392 0.0862361 -0.987705    0 0
  v 2.46091 -1.64432 0.103961    -0.226831 0.147964 -0.962629    0 0
  v 2.48727 -1.66194 0.0917106    -0.45784 0.298895 -0.837284    0 0
  v 2.49739 -1.6687 0.0794606    -0.555528 0.37282 -0.743232    0 0
  v 2.51005 -1.67716 0.0672107    -0.383755 0.263236 -0.885121    0 0
  v 2.54405 -1.69988 0.0549607    -0.126289 0.0897033 -0.987929    0 0
  v 2.55448 -1.70685 0.0547109    -0.00400249 0.00325824 -0.999987    0 0
  v 2.57601 -1.72124 0.0549607    -0.0127737 0.00756866 -0.99989    0 0
  v 2.59716 -1.73536 0.0539608    -0.0159791 0.0114528 -0.999807    0 0
  v 2.60641 -1.74155 0.0539608    0.205968 -0.128053 -0.970144    0 0
  v 2.68436 -1.79363 0.103961    0.570758 -0.373689 -0.731158    0 0
  v 2.71035 -1.811 0.153961    0.689351 -0.49408 -0.529794    0 0
  v 2.68436 -1.79363 0.203961    0.563663 -0.384308 0.731158    0 0
  v 2.60641 -1.74155 0.253961    0.300165 -0.204918 0.931617    0 0
  v 2.08441 -1.39276 0.416961    0.181401 -0.122493 0.975751    0 0
  v 1.37376 -0.917917 0.578961    0.165146 -0.109869 0.98013    0 0
  v 0.744183 -0.497246 0.741961    0.272282 -0.177472 0.945709    0 0
  v 0.46538 -0.310956 0.903961    0.353735 -0.253533 0.900329    0 0
  v 0.45713 -0.305444 0.940961    0.783163 -0.524326 0.334273    0 0
  v 0.443034 -0.296026 0.978961    0.761242 -0.508558 0.402342    0 0
  v 0.429717 -0.287127 1.01596    0.795718 -0.530398 0.292423    0 0
  v 0.423806 -0.283178 1.05396    0.828071 -0.552965 0.0923441    0 0
  v 0.423806 -0.283178 1.35396    0.831469 -0.555571 0    0 0
  v 0.423806 -0.283178 1.65396    0.831469 -0.555571 0    0 0
  v 0.423806 -0.283178 1.95396    0.831469 -0.555571 0    0 0
  v 0.423806 -0.283178 2.25396    0.827229 -0.55312 -0.098744    0 0
  v 0.436304 -0.291529 2.32896    0.779285 -0.522815 -0.345514    0 0
  v 0.470992 -0.314707 2.40396    0.683106 -0.458603 -0.568374    0 0
  v 0.523661 -0.349899 2.47896    0.602404 -0.40408 -0.688353    0 0
  v 0.5901 -0.394292 2.55396    0.522288 -0.351215 -0.777087    0 0
  v 0.964169 -0.644236 2.86696    0.439473 -0.295314 -0.848324    0 0
  v 1.42998 -0.955484 3.17896    0.402977 -0.269334 -0.874682    0 0
  v 1.90199 -1.27086 3.49196    0.430875 -0.286553 -0.855706    0 0
  v 2.29461 -1.53321 3.80396    0.505389 -0.335561 -0.794972    0 0
  v 2.54308 -1.69923 4.06596    0.57948 -0.385779 -0.717898    0 0
  v 2.74703 -1.8355 4.32896    0.636994 -0.424325 -0.643573    0 0
  v 2.91185 -1.94564 4.59096    0.689649 -0.459626 -0.559579    0 0
  v 3.04294 -2.03322 4.85396    0.741087 -0.493966 -0.454739    0 0
  v 3.19406 -2.1342 5.27896    0.788534 -0.525886 -0.318838    0 0
  v 3.28235 -2.1932 5.70396    0.818146 -0.546216 -0.179684    0 0
  v 3.3237 -2.22082 6.12896    0.829329 -0.554015 -0.0726729    0 0
  v 3.33395 -2.22767 6.55396    0.830257 -0.554926 0.0522611    0 0
  v 3.26412 -2.18101 7.17896    0.809862 -0.54195 0.22453    0 0
  v 3.0923 -2.06621 7.80396    0.778605 -0.520773 0.350099    0 0
  v 2.87502 -1.92102 8.42896    0.770065 -0.514407 0.377339    0 0
  v 2.66877 -1.78322 9.05396    0.778831 -0.520128 0.350555    0 0
  v 2.55549 -1.70752 9.44096    0.785404 -0.524739 0.328314    0 0
  v 2.4448 -1.63356 9.82896    0.789516 -0.527399 0.31387    0 0
  v 2.34216 -1.56498 10.217    0.79706 -0.532368 0.285095    0 0
  v 2.25304 -1.50543 10.604    0.808477 -0.539897 0.234257    0 0
  v 2.24911 -1.50281 10.627    0.819439 -0.54732 0.170179    0 0
  v 2.24654 -1.50109 10.649    0.826856 -0.55235 0.105918    0 0
  v 2.24515 -1.50016 10.672    0.830534 -0.554898 0.0479814    0 0
  v 2.24473 -1.49988 10.694    0.831456 -0.555566 -0.00520041    0 0
  v 2.24512 -1.50014 10.708    0.830399 -0.555013 0.0489729    0 0
  v 2.24369 -1.49918 10.721    0.782266 -0.525479 0.334561    0 0
  v 2.23654 -1.49441 10.735    0.601582 -0.40762 0.686982    0 0
  v 2.21978 -1.48321 10.749    0.285666 -0.200335 0.937156    0 0
  v 2.21196 -1.47798 10.75    0.0916706 -0.0610788 0.993914    0 0
  v 2.19754 -1.46835 10.752    0.0723623 -0.0494156 0.996153    0 0
  v 2.18385 -1.4592 10.753    0.0866811 -0.0562355 0.994648    0 0
  v 2.17821 -1.45543 10.754    0.118579 -0.0849895 0.989301    0 0
  v 2.16401 -1.44595 10.717    -0.818133 0.544842 0.183864    0 0
  v 2.166 -1.44727 10.679    -0.816558 0.546515 -0.185888    0 0
  v 2.17616 -1.45406 10.641    -0.789727 0.527761 -0.312729    0 0
  v 2.18652 -1.46099 10.604    -0.796011 0.531525 -0.289565    0 0
  v 2.27305 -1.5188 10.217    -0.799643 0.53446 -0.273723    0 0
  v 2.36997 -1.58356 9.82896    -0.793479 0.530318 -0.298586    0 0
  v 2.47494 -1.6537 9.44096    -0.788438 0.526921 -0.317363    0 0
  v 2.58563 -1.72766 9.05396    -0.782773 0.523195 -0.336946    0 0
  v 2.77888 -1.85679 8.42896    -0.780462 0.521436 -0.344939    0 0
  v 2.96758 -1.98288 7.80396    -0.792399 0.528992 -0.303761    0 0
  v 3.11082 -2.07858 7.17896    -0.816942 0.545274 -0.187833    0 0
  v 3.16766 -2.11656 6.55396    -0.807979 0.579104 -0.108668    0 0
  v 0.00896863 -0.0037148 0.953961    -0.765598 0.288083 -0.575211    0 0
  v 0.0902201 -0.0373702 0.828961    -0.767345 0.317414 -0.557162    0 0
  v 0.164048 -0.0679507 0.703961    -0.671649 0.282747 -0.684793    0 0
  v 0.322015 -0.133383 0.578961    -0.426718 0.18147 -0.885991    0 0
  v 0.655684 -0.271593 0.453961    -0.233906 0.0995089 -0.967153    0 0
  v 1.09785 -0.454743 0.366461    -0.145153 0.0609227 -0.987532    0 0
  v 1.69158 -0.700676 0.278961    -0.124106 0.0514266 -0.990935    0 0
  v 2.28705 -0.947327 0.191961    -0.144711 0.0591408 -0.987705    0 0
  v 2.73441 -1.13263 0.103961    -0.251339 0.100869 -0.962629    0 0
  v 2.7637 -1.14476 0.0917106    -0.507353 0.203831 -0.837285    0 0
  v 2.77495 -1.14942 0.0794606    -0.617587 0.257278 -0.743233    0 0
  v 2.78902 -1.15525 0.0672107    -0.427735 0.183311 -0.885121    0 0
  v 2.8268 -1.1709 0.0549607    -0.141362 0.0633419 -0.987929    0 0
  v 2.83839 -1.1757 0.0547109    -0.00456115 0.00241474 -0.999987    0 0
  v 2.86231 -1.18561 0.0549607    -0.0140047 0.00493117 -0.99989    0 0
  v 2.88581 -1.19534 0.0539608    -0.0179064 0.0081153 -0.999807    0 0
  v 2.89609 -1.1996 0.0539608    0.226993 -0.0854096 -0.970144    0 0
  v 2.98271 -1.23548 0.103961    0.632694 -0.255158 -0.731159    0 0
  v 3.01158 -1.24743 0.153961    0.772494 -0.3501 -0.529795    0 0
  v 2.98271 -1.23548 0.203961    0.627807 -0.266958 0.731158    0 0
  v 2.89609 -1.1996 0.253961    0.334375 -0.142421 0.931617    0 0
  v 2.31607 -0.959346 0.416961    0.201813 -0.0847498 0.975751    0 0
  v 1.52644 -0.632272 0.578961    0.183407 -0.0755393 0.98013    0 0
  v 0.826891 -0.342509 0.741961    0.301673 -0.120942 0.945709    0 0
  v 0.517102 -0.21419 0.903961    0.3964 -0.179651 0.900329    0 0
  v 0.507936 -0.210393 0.940961    0.870405 -0.361464 0.334274    0 0
  v 0.492273 -0.203906 0.978961    0.84583 -0.350275 0.402342    0 0
  v 0.477476 -0.197777 1.01596    0.883904 -0.364969 0.292423    0 0
  v 0.470908 -0.195056 1.05396    0.920038 -0.380791 0.0923444    0 0
  v 0.470908 -0.195056 1.35396    0.92388 -0.382683 0    0 0
  v 0.470908 -0.195056 1.65396    0.92388 -0.382683 0    0 0
  v 0.470908 -0.195056 1.95396    0.92388 -0.382683 0    0 0
  v 0.470908 -0.195056 2.25396    0.919242 -0.381107 -0.0987442    0 0
  v 0.484795 -0.200809 2.32896    0.866307 -0.360738 -0.345514    0 0
  v 0.523339 -0.216774 2.40396    0.759449 -0.316524 -0.568374    0 0
  v 0.581861 -0.241014 2.47896    0.669661 -0.278792 -0.688353    0 0
  v 0.655684 -0.271593 2.55396    0.580771 -0.242573 -0.777087    0 0
  v 1.07133 -0.443758 2.86696    0.488642 -0.203902 -0.848324    0 0
  v 1.58891 -0.658149 3.17896    0.447779 -0.185542 -0.874682    0 0
  v 2.11337 -0.875387 3.49196    0.4785 -0.196988 -0.855706    0 0
  v 2.54964 -1.05609 3.80396    0.561143 -0.230517 -0.794972    0 0
  v 2.82572 -1.17045 4.06596    0.643607 -0.265315 -0.717898    0 0
  v 3.05233 -1.26432 4.32896    0.707536 -0.291901 -0.643573    0 0
  v 3.23548 -1.34018 4.59096    0.766066 -0.31625 -0.559579    0 0
  v 3.38113 -1.40051 4.85396    0.823215 -0.339895 -0.454739    0 0
  v 3.54905 -1.47006 5.27896    0.875978 -0.361946 -0.318838    0 0
  v 3.64716 -1.5107 5.70396    0.908987 -0.376108 -0.179684    0 0
  v 3.69309 -1.52973 6.12896    0.921476 -0.381576 -0.072673    0 0
  v 3.70449 -1.53445 6.55396    0.922564 -0.382288 0.0522612    0 0
  v 3.6269 -1.50231 7.17896    0.90003 -0.373541 0.22453    0 0
  v 3.43598 -1.42323 7.80396    0.865242 -0.358868 0.350099    0 0
  v 3.19455 -1.32322 8.42896    0.855625 -0.35429 0.377339    0 0
  v 2.96538 -1.2283 9.05396    0.865338 -0.358192 0.350555    0 0
  v 2.8395 -1.17616 9.44096    0.872684 -0.361431 0.328314    0 0
  v 2.71651 -1.12522 9.82896    0.877236 -0.363239 0.31387    0 0
  v 2.60247 -1.07798 10.217    0.885605 -0.366639 0.285095    0 0
  v 2.50344 -1.03696 10.604    0.898271 -0.371797 0.234258    0 0
  v 2.49908 -1.03515 10.627    0.91047 -0.376939 0.170178    0 0
  v 2.49623 -1.03397 10.649    0.918727 -0.380425 0.105917    0 0
  v 2.49467 -1.03333 10.672    0.922831 -0.382206 0.0479793    0 0
  v 2.4942 -1.03313 10.694    0.923865 -0.382682 -0.00519912    0 0
  v 2.49464 -1.03331 10.708    0.922721 -0.382346 0.0489759    0 0
  v 2.49305 -1.03265 10.721    0.869752 -0.36277 0.334558    0 0
  v 2.48511 -1.02937 10.735    0.669546 -0.282425 0.686981    0 0
  v 2.46649 -1.02165 10.749    0.319259 -0.140755 0.937156    0 0
  v 2.4578 -1.01805 10.75    0.101825 -0.0420211 0.993914    0 0
  v 2.44177 -1.01142 10.752    0.0806129 -0.0343491 0.996153    0 0
  v 2.42656 -1.00511 10.753    0.0959869 -0.0382443 0.994648    0 0
  v 2.42029 -1.00252 10.754    0.13288 -0.0602221 0.989301    0 0
  v 2.40452 -0.995985 10.717    -0.908706 0.374763 0.183864    0 0
  v 2.40673 -0.996897 10.679    -0.907488 0.376711 -0.185889    0 0
  v 2.41802 -1.00158 10.641    -0.877514 0.363553 -0.312729    0 0
  v 2.42953 -1.00634 10.604    -0.884411 0.366018 -0.289565    0 0
  v 2.52568 -1.04617 10.217    -0.888546 0.368188 -0.273723    0 0
  v 2.63336 -1.09077 9.82896    -0.881692 0.365328 -0.298586    0 0
  v 2.75 -1.13909 9.44096    -0.876086 0.36298 -0.317363    0 0
  v 2.873 -1.19003 9.05396    -0.869803 0.360431 -0.336946    0 0
  v 3.08773 -1.27898 8.42896    -0.867193 0.359156 -0.344939    0 0
  v 3.2974 -1.36583 7.80396    -0.880375 0.364238 -0.303761    0 0
  v 3.45656 -1.43175 7.17896    -0.907623 0.375419 -0.187833    0 0
  v 3.51971 -1.45791 6.55396    -0.905431 0.410348 -0.108668    0 0
  v 0.00952109 -0.00189376 0.953961    -0.807092 0.133168 -0.575212    0 0
  v 0.0957772 -0.0190511 0.828961    -0.814526 0.161611 -0.557162    0 0
  v 0.174153 -0.034641 0.703961    -0.713905 0.146281 -0.684793    0 0
  v 0.341849 -0.0679979 0.578961    -0.453922 0.0947345 -0.885991    0 0
  v 0.696071 -0.138457 0.453961    -0.248825 0.051964 -0.967153    0 0
  v 1.16547 -0.231826 0.366461    -0.154249 0.0314341 -0.987532    0 0
  v 1.79578 -0.357202 0.278961    -0.131754 0.0262266 -0.990935    0 0
  v 2.42792 -0.482944 0.191961    -0.153468 0.0297728 -0.987705    0 0
  v 2.90284 -0.57741 0.103961    -0.266188 0.0498966 -0.962629    0 0
  v 2.93393 -0.583595 0.0917106    -0.53737 0.100935 -0.837285    0 0
  v 2.94587 -0.58597 0.0794606    -0.655912 0.131849 -0.743233    0 0
  v 2.96081 -0.588942 0.0672107    -0.455279 0.0963416 -0.885121    0 0
  v 3.00092 -0.596919 0.0549607    -0.151003 0.0345463 -0.987929    0 0
  v 3.01321 -0.599365 0.0547109    -0.00494472 0.00147853 -0.999987    0 0
  v 3.03861 -0.604418 0.0549607    -0.0146977 0.00210423 -0.99989    0 0
  v 3.06356 -0.609379 0.0539608    -0.0191455 0.00446599 -0.999807    0 0
  v 3.07447 -0.611551 0.0539608    0.239293 -0.0394844 -0.970144    0 0
  v 3.16642 -0.629841 0.103961    0.670316 -0.126823 -0.731158    0 0
  v 3.19707 -0.635937 0.153961    0.825952 -0.192666 -0.529795    0 0
  v 3.16642 -0.629841 0.203961    0.667824 -0.139349 0.731158    0 0
  v 3.07447 -0.611551 0.253961    0.355735 -0.0744512 0.931617    0 0
  v 2.45872 -0.489071 0.416961    0.214469 -0.0437497 0.975751    0 0
  v 1.62046 -0.32233 0.578961    0.19462 -0.0383069 0.98013    0 0
  v 0.877823 -0.17461 0.741961    0.319471 -0.0597651 0.94571    0 0
  v 0.548953 -0.109193 0.903961    0.423832 -0.0988655 0.900329    0 0
  v 0.539222 -0.107258 0.940961    0.924199 -0.18471 0.334274    0 0
  v 0.522594 -0.10395 0.978961    0.897913 -0.178531 0.402342    0 0
  v 0.506886 -0.100826 1.01596    0.938122 -0.185514 0.292423    0 0
  v 0.499914 -0.0994389 1.05396    0.976649 -0.193983 0.0923446    0 0
  v 0.499914 -0.0994389 1.35396    0.980785 -0.19509 0    0 0
  v 0.499914 -0.0994389 1.65396    0.980785 -0.19509 0    0 0
  v 0.499914 -0.0994389 1.95396    0.980785 -0.19509 0    0 0
  v 0.499914 -0.0994389 2.25396    0.97593 -0.194449 -0.0987443    0 0
  v 0.514656 -0.102371 2.32896    0.920038 -0.184797 -0.345514    0 0
  v 0.555573 -0.11051 2.40396    0.806607 -0.16228 -0.568375    0 0
  v 0.6177 -0.122868 2.47896    0.711183 -0.142791 -0.688353    0 0
  v 0.696071 -0.138457 2.55396    0.616935 -0.124609 -0.777087    0 0
  v 1.13731 -0.226226 2.86696    0.519032 -0.104655 -0.848324    0 0
  v 1.68678 -0.335521 3.17896    0.475372 -0.0946192 -0.874682    0 0
  v 2.24354 -0.446269 3.49196    0.507736 -0.0998518 -0.855706    0 0
  v 2.70668 -0.538392 3.80396    0.595332 -0.116614 -0.794972    0 0
  v 2.99976 -0.59669 4.06596    0.683001 -0.134656 -0.717898    0 0
  v 3.24034 -0.644544 4.32896    0.750888 -0.148258 -0.643573    0 0
  v 3.43476 -0.683217 4.59096    0.813044 -0.160721 -0.559579    0 0
  v 3.58939 -0.713974 4.85396    0.873708 -0.172763 -0.454739    0 0
  v 3.76765 -0.749432 5.27896    0.929759 -0.184096 -0.318838    0 0
  v 3.8718 -0.770149 5.70396    0.964896 -0.191546 -0.179684    0 0
  v 3.92057 -0.779849 6.12896    0.978212 -0.194473 -0.0726733    0 0
  v 3.93266 -0.782255 6.55396    0.979418 -0.19496 0.0522614    0 0
  v 3.85029 -0.765871 7.17896    0.95561 -0.190776 0.22453    0 0
  v 3.64762 -0.725557 7.80396    0.918629 -0.183172 0.350099    0 0
  v 3.39131 -0.674574 8.42896    0.908303 -0.180558 0.377339    0 0
  v 3.14803 -0.626183 9.05396    0.918591 -0.18249 0.350555    0 0
  v 3.0144 -0.599602 9.44096    0.926428 -0.184234 0.328314    0 0
  v 2.88383 -0.57363 9.82896    0.931245 -0.185119 0.31387    0 0
  v 2.76277 -0.549549 10.217    0.940116 -0.186822 0.285095    0 0
  v 2.65764 -0.528638 10.604    0.953545 -0.189409 0.234258    0 0
  v 2.653 -0.527715 10.627    0.966513 -0.192072 0.170177    0 0
  v 2.64998 -0.527114 10.649    0.975291 -0.193881 0.105919    0 0
  v 2.64833 -0.526786 10.672    0.979663 -0.194827 0.0479811    0 0
  v 2.64783 -0.526687 10.694    0.980771 -0.195092 -0.0052013    0 0
  v 2.64829 -0.526778 10.708    0.979583 -0.194985 0.0489762    0 0
  v 2.64661 -0.526443 10.721    0.923813 -0.186119 0.334558    0 0
  v 2.63818 -0.524766 10.735    0.711782 -0.146377 0.686979    0 0
  v 2.61841 -0.520834 10.749    0.340584 -0.0757657 0.937156    0 0
  v 2.60918 -0.518999 10.75    0.108066 -0.0213486 0.993915    0 0
  v 2.59217 -0.515615 10.752    0.085765 -0.0179623 0.996153    0 0
  v 2.57602 -0.512403 10.753    0.101604 -0.0187835 0.994648    0 0
  v 2.56937 -0.51108 10.754    0.142077 -0.0331416 0.989301    0 0
  v 2.55263 -0.507749 10.717    -0.964358 0.190282 0.183865    0 0
  v 2.55497 -0.508214 10.679    -0.963543 0.192431 -0.185891    0 0
  v 2.56696 -0.510599 10.641    -0.931578 0.185373 -0.312729    0 0
  v 2.57918 -0.513031 10.604    -0.938824 0.186445 -0.289565    0 0
  v 2.68124 -0.533332 10.217    -0.943302 0.187767 -0.273723    0 0
  v 2.79556 -0.556072 9.82896    -0.936023 0.186299 -0.298586    0 0
  v 2.91939 -0.580703 9.44096    -0.930066 0.18509 -0.317363    0 0
  v 3.04996 -0.606674 9.05396    -0.923407 0.183815 -0.336946    0 0
  v 3.27791 -0.652017 8.42896    -0.920598 0.183074 -0.344939    0 0
  v 3.5005 -0.696294 7.80396    -0.934518 0.185487 -0.303761    0 0
  v 3.66946 -0.729901 7.17896    -0.963424 0.191137 -0.187833    0 0
  v 3.73651 -0.743237 6.55396    -0.968089 0.225822 -0.108668    0 0
  v 0.00970753 0 0.953961    -0.817565 -0.0268398 -0.575211    0 0
  v 0.0976535 0 0.828961    -0.830404 -0.000407658 -0.557162    0 0
  v 0.177564 0 0.703961    -0.728726 0.00419362 -0.684793    0 0
  v 0.348547 0 0.578961    -0.463682 0.00435828 -0.885991    0 0
  v 0.709708 0 0.453961    -0.254182 0.00242218 -0.967153    0 0
  v 1.1883 0 0.366461    -0.157418 0.000737665 -0.987532    0 0
  v 1.83096 0 0.278961    -0.134339 1.87239e-005 -0.990935    0 0
  v 2.47549 0 0.191961    -0.156327 -0.000739321 -0.987705    0 0
  v 2.95971 0 0.103961    -0.270808 -0.00299277 -0.962629    0 0
  v 2.99141 0 0.0917106    -0.546736 -0.00583989 -0.837285    0 0
  v 3.00358 0 0.0794606    -0.669031 0.00135393 -0.743234    0 0
  v 3.01882 0 0.0672107    -0.465326 0.00566993 -0.885121    0 0
  v 3.05971 0 0.0549607    -0.154842 0.00442327 -0.987929    0 0
  v 3.07225 0 0.0547109    -0.00513815 0.000485457 -0.999987    0 0
  v 3.09814 0 0.0549607    -0.0148258 -0.000803563 -0.99989    0 0
  v 3.12357 0 0.0539608    -0.0196489 0.000645082 -0.999807    0 0
  v 3.13471 0 0.0539608    0.242398 0.00795804 -0.970144    0 0
  v 3.22846 0 0.103961    0.682178 0.00638557 -0.731159    0 0
  v 3.25971 0 0.153961    0.847669 -0.0278294 -0.529795    0 0
  v 3.22846 0 0.203961    0.682178 -0.0063857 0.731158    0 0
  v 3.13471 0 0.253961    0.363424 -0.00362022 0.931617    0 0
  v 2.50689 0 0.416961    0.218883 -0.00106829 0.975751    0 0
  v 1.65221 0 0.578961    0.198353 0.00039746 0.98013    0 0
  v 0.895021 0 0.741961    0.324992 0.00370879 0.94571    0 0
  v 0.559707 0 0.903961    0.434976 -0.0142804 0.900329    0 0
  v 0.549785 0 0.940961    0.942476 -0.000859401 0.334273    0 0
  v 0.532832 0 0.978961    0.915489 7.27395e-005 0.402342    0 0
  v 0.516816 0 1.01596    0.956289 0.00106802 0.292423    0 0
  v 0.509708 0 1.05396    0.995727 0.000278259 0.092345    0 0
  v 0.509708 0 1.35396    1 -1.22282e-007 0    0 0
  v 0.509708 0 1.65396    1 -1.19786e-007 0    0 0
  v 0.509708 0 1.95396    1 -1.22282e-007 0    0 0
  v 0.509708 0 2.25396    0.995113 -0.00031869 -0.0987443    0 0
  v 0.524738 0 2.32896    0.938412 -0.00175656 -0.345514    0 0
  v 0.566458 0 2.40396    0.822768 -0.00180109 -0.568375    0 0
  v 0.629802 0 2.47896    0.725375 -0.00130233 -0.688353    0 0
  v 0.709708 0 2.55396    0.629391 -0.00185706 -0.777086    0 0
  v 1.1596 0 2.86696    0.529476 -0.00138596 -0.848324    0 0
  v 1.71983 0 3.17896    0.484697 -6.06958e-005 -0.874682    0 0
  v 2.2875 0 3.49196    0.51746 0.00112107 -0.855706    0 0
  v 2.75971 0 3.80396    0.606643 0.00177056 -0.794972    0 0
  v 3.05853 0 4.06596    0.696147 0.00117857 -0.717898    0 0
  v 3.30382 0 4.32896    0.765384 0.00108136 -0.643573    0 0
  v 3.50205 0 4.59096    0.828777 0.000983805 -0.559579    0 0
  v 3.65971 0 4.85396    0.890624 0.00100816 -0.454739    0 0
  v 3.84146 0 5.27896    0.947809 0.000828053 -0.318838    0 0
  v 3.94765 0 5.70396    0.983724 0.000375698 -0.179684    0 0
  v 3.99737 0 6.12896    0.997356 0.000103467 -0.0726735    0 0
  v 4.00971 0 6.55396    0.998633 -0.000138446 0.0522612    0 0
  v 3.92572 0 7.17896    0.974467 -0.000680394 0.224531    0 0
  v 3.71908 0 7.80396    0.936713 -0.000437435 0.350099    0 0
  v 3.45775 0 8.42896    0.926075 0.000111917 0.377339    0 0
  v 3.20971 0 9.05396    0.936542 0.000224174 0.350555    0 0
  v 3.07346 0 9.44096    0.944569 4.2662e-005 0.328314    0 0
  v 2.94033 0 9.82896    0.949466 0.000114936 0.31387    0 0
  v 2.8169 0 10.217    0.958499 0.000175433 0.285095    0 0
  v 2.70971 0 10.604    0.972175 0.000257281 0.234258    0 0
  v 2.70498 0 10.627    0.985413 0.000175452 0.170178    0 0
  v 2.7019 0 10.649    0.994375 0.000114341 0.105919    0 0
  v 2.70022 0 10.672    0.998848 3.88983e-005 0.0479822    0 0
  v 2.69971 0 10.694    0.999987 -4.78835e-006 -0.00520304    0 0
  v 2.70018 0 10.708    0.9988 -0.000131683 0.0489765    0 0
  v 2.69846 0 10.721    0.942371 -0.00231594 0.334561    0 0
  v 2.68986 0 10.735    0.726661 -0.00470266 0.68698    0 0
  v 2.66971 0 10.749    0.348821 -0.00786524 0.937156    0 0
  v 2.6603 0 10.75    0.110155 0.00014421 0.993914    0 0
  v 2.64296 0 10.752    0.0876211 -0.000885271 0.996153    0 0
  v 2.62649 0 10.753    0.103316 0.00139942 0.994648    0 0
  v 2.61971 0 10.754    0.145812 -0.00478712 0.989301    0 0
  v 2.60264 0 10.717    -0.98295 -0.00151077 0.183865    0 0
  v 2.60502 0 10.679    -0.98257 0.000755646 -0.185891    0 0
  v 2.61725 0 10.641    -0.949843 6.91792e-005 -0.312729    0 0
  v 2.62971 0 10.604    -0.957159 -0.000293004 -0.289564    0 0
  v 2.73377 0 10.217    -0.961809 0.000129851 -0.273723    0 0
  v 2.85033 0 9.82896    -0.954383 0.000110506 -0.298586    0 0
  v 2.97658 0 9.44096    -0.948304 8.63981e-005 -0.317363    0 0
  v 3.10971 0 9.05396    -0.941524 0.000135593 -0.336946    0 0
  v 3.34213 0 8.42896    -0.938625 -4.32471e-005 -0.344939    0 0
  v 3.56908 0 7.80396    -0.952748 -0.000392504 -0.303761    0 0
  v 3.74135 0 7.17896    -0.982201 -0.000489779 -0.187833    0 0
  v 3.80971 0 6.55396    -0.993543 0.0326185 -0.108668    0 0
  v 0.00952109 0.00189376 0.953961    -0.796622 -0.185809 -0.575212    0 0
  v 0.0957772 0.0190513 0.828961    -0.814371 -0.162392 -0.557162    0 0
  v 0.174153 0.034641 0.703961    -0.715542 -0.138052 -0.684793    0 0
  v 0.341849 0.0679982 0.578961    -0.455622 -0.0861847 -0.885991    0 0
  v 0.696071 0.138457 0.453961    -0.24977 -0.0472126 -0.967153    0 0
  v 1.16547 0.231826 0.366461    -0.154537 -0.0299872 -0.987532    0 0
  v 1.79578 0.357202 0.278961    -0.131761 -0.0261899 -0.990935    0 0
  v 2.42792 0.482944 0.191961    -0.153179 -0.0312231 -0.987705    0 0
  v 2.90284 0.577411 0.103961    -0.26502 -0.0557672 -0.962629    0 0
  v 2.93393 0.583596 0.0917106    -0.535092 -0.112391 -0.837284    0 0
  v 2.94587 0.58597 0.0794606    -0.656439 -0.129193 -0.743234    0 0
  v 2.96081 0.588942 0.0672107    -0.457491 -0.0852197 -0.885121    0 0
  v 3.00092 0.59692 0.0549607    -0.152729 -0.0258698 -0.987929    0 0
  v 3.01321 0.599366 0.0547109    -0.00513415 -0.00052628 -0.999987    0 0
  v 3.03861 0.604418 0.0549607    -0.0143841 -0.00368049 -0.99989    0 0
  v 3.06356 0.609379 0.0539608    -0.0193972 -0.00320062 -0.999807    0 0
  v 3.07447 0.611551 0.0539608    0.236188 0.0550948 -0.970144    0 0
  v 3.16642 0.629841 0.103961    0.667824 0.139349 -0.731158    0 0
  v 3.19707 0.635938 0.153961    0.836811 0.138077 -0.529795    0 0
  v 3.16642 0.629841 0.203961    0.670316 0.126823 0.731158    0 0
  v 3.07447 0.611551 0.253961    0.357147 0.0673499 0.931617    0 0
  v 2.45872 0.489071 0.416961    0.214886 0.0416543 0.975751    0 0
  v 1.62046 0.32233 0.578961    0.194465 0.0390867 0.98013    0 0
  v 0.877823 0.17461 0.741961    0.318024 0.0670404 0.94571    0 0
  v 0.548953 0.109194 0.903961    0.429404 0.0708533 0.900329    0 0
  v 0.539222 0.107258 0.940961    0.924534 0.183024 0.334274    0 0
  v 0.522594 0.103951 0.978961    0.897884 0.178674 0.402342    0 0
  v 0.506886 0.100826 1.01596    0.937705 0.18761 0.292423    0 0
  v 0.499914 0.0994391 1.05396    0.97654 0.19453 0.0923448    0 0
  v 0.499914 0.0994391 1.35396    0.980785 0.19509 0    0 0
  v 0.499914 0.0994391 1.65396    0.980785 0.19509 0    0 0
  v 0.499914 0.0994391 1.95396    0.980785 0.19509 0    0 0
  v 0.499914 0.0994391 2.25396    0.976054 0.193824 -0.0987443    0 0
  v 0.514656 0.102371 2.32896    0.920723 0.181352 -0.345514    0 0
  v 0.555573 0.11051 2.40396    0.80731 0.158747 -0.568375    0 0
  v 0.6177 0.122868 2.47896    0.711691 0.140236 -0.688353    0 0
  v 0.696071 0.138457 2.55396    0.61766 0.120967 -0.777086    0 0
  v 1.13731 0.226226 2.86696    0.519573 0.101936 -0.848324    0 0
  v 1.68678 0.335522 3.17896    0.475396 0.0945002 -0.874682    0 0
  v 2.24354 0.446269 3.49196    0.507299 0.102051 -0.855706    0 0
  v 2.70668 0.538392 3.80396    0.594641 0.120087 -0.794972    0 0
  v 2.99976 0.59669 4.06596    0.682541 0.136967 -0.717898    0 0
  v 3.24034 0.644544 4.32896    0.750466 0.15038 -0.643573    0 0
  v 3.43476 0.683217 4.59096    0.81266 0.162651 -0.559579    0 0
  v 3.58939 0.713974 4.85396    0.873314 0.174741 -0.454739    0 0
  v 3.76765 0.749432 5.27896    0.929435 0.185721 -0.318838    0 0
  v 3.8718 0.770149 5.70396    0.964749 0.192284 -0.179684    0 0
  v 3.92057 0.779849 6.12896    0.978172 0.194676 -0.0726731    0 0
  v 3.93266 0.782256 6.55396    0.979472 0.194688 0.0522612    0 0
  v 3.85029 0.765871 7.17896    0.955875 0.189442 0.22453    0 0
  v 3.64762 0.725557 7.80396    0.918799 0.182315 0.350099    0 0
  v 3.39131 0.674575 8.42896    0.908259 0.180778 0.377339    0 0
  v 3.14803 0.626183 9.05396    0.918503 0.18293 0.350555    0 0
  v 3.0144 0.599602 9.44096    0.926411 0.184318 0.328314    0 0
  v 2.88383 0.573631 9.82896    0.9312 0.185344 0.31387    0 0
  v 2.76277 0.549549 10.217    0.940048 0.187166 0.285095    0 0
  v 2.65764 0.528638 10.604    0.953444 0.189914 0.234258    0 0
  v 2.653 0.527716 10.627    0.966445 0.192417 0.170177    0 0
  v 2.64998 0.527114 10.649    0.975246 0.194105 0.105919    0 0
  v 2.64833 0.526786 10.672    0.979648 0.194904 0.047983    0 0
  v 2.64783 0.526687 10.694    0.980773 0.195083 -0.00520496    0 0
  v 2.64829 0.526779 10.708    0.979634 0.194727 0.048975    0 0
  v 2.64661 0.526443 10.721    0.924716 0.181576 0.334561    0 0
  v 2.63818 0.524767 10.735    0.713617 0.137153 0.686979    0 0
  v 2.61841 0.520834 10.749    0.343653 0.0603374 0.937156    0 0
  v 2.60918 0.518999 10.75    0.10801 0.0216315 0.993915    0 0
  v 2.59217 0.515616 10.752    0.0861102 0.0162258 0.996153    0 0
  v 2.57602 0.512403 10.753    0.101058 0.0215285 0.994648    0 0
  v 2.56937 0.51108 10.754    0.143944 0.0237515 0.989301    0 0
  v 2.55263 0.50775 10.717    -0.963768 -0.193246 0.183865    0 0
  v 2.55497 0.508214 10.679    -0.963838 -0.190949 -0.185891    0 0
  v 2.56696 0.5106 10.641    -0.931605 -0.185237 -0.31273    0 0
  v 2.57918 0.513031 10.604    -0.93871 -0.18702 -0.289564    0 0
  v 2.68124 0.533332 10.217    -0.943353 -0.187512 -0.273723    0 0
  v 2.79556 0.556073 9.82896    -0.936066 -0.186082 -0.298586    0 0
  v 2.91939 0.580703 9.44096    -0.9301 -0.18492 -0.317363    0 0
  v 3.04996 0.606674 9.05396    -0.923459 -0.183549 -0.336946    0 0
  v 3.27791 0.652017 8.42896    -0.920581 -0.183159 -0.344939    0 0
  v 3.5005 0.696294 7.80396    -0.934365 -0.186257 -0.303761    0 0
  v 3.66946 0.729901 7.17896    -0.963232 -0.192098 -0.187833    0 0
  v 3.73651 0.743237 6.55396    -0.980816 -0.161839 -0.108668    0 0
  v 0.00896871 0.0037148 0.953961    -0.745052 -0.337679 -0.575213    0 0
  v 0.0902202 0.0373702 0.828961    -0.767039 -0.318153 -0.557162    0 0
  v 0.164048 0.067951 0.703961    -0.674859 -0.274997 -0.684793    0 0
  v 0.322015 0.133383 0.578961    -0.430054 -0.173417 -0.885991    0 0
  v 0.655684 0.271593 0.453961    -0.23576 -0.0950333 -0.967153    0 0
  v 1.09785 0.454744 0.366461    -0.145717 -0.0595597 -0.987532    0 0
  v 1.69158 0.700677 0.278961    -0.12412 -0.051392 -0.990935    0 0
  v 2.28705 0.947328 0.191961    -0.144145 -0.060507 -0.987705    0 0
  v 2.73441 1.13263 0.103961    -0.249048 -0.106399 -0.962629    0 0
  v 2.7637 1.14476 0.0917106    -0.502885 -0.214623 -0.837283    0 0
  v 2.77495 1.14942 0.0794606    -0.618622 -0.254776 -0.743234    0 0
  v 2.78902 1.15525 0.0672107    -0.432074 -0.172834 -0.885122    0 0
  v 2.8268 1.1709 0.0549607    -0.144748 -0.0551689 -0.987929    0 0
  v 2.83839 1.1757 0.0547109    -0.00493274 -0.00151775 -0.999987    0 0
  v 2.86231 1.18561 0.0549607    -0.0133898 -0.00641601 -0.99989    0 0
  v 2.88581 1.19534 0.0539608    -0.0184001 -0.00692334 -0.999807    0 0
  v 2.89609 1.1996 0.0539608    0.220902 0.100114 -0.970144    0 0
  v 2.98271 1.23548 0.103961    0.627806 0.266958 -0.731159    0 0
  v 3.01158 1.24744 0.153961    0.793793 0.298678 -0.529796    0 0
  v 2.98271 1.23548 0.203961    0.632694 0.255159 0.731158    0 0
  v 2.89609 1.1996 0.253961    0.337146 0.135732 0.931617    0 0
  v 2.31607 0.959347 0.416961    0.20263 0.082776 0.975751    0 0
  v 1.52644 0.632273 0.578961    0.183103 0.0762739 0.98013    0 0
  v 0.826891 0.34251 0.741961    0.298834 0.127796 0.94571    0 0
  v 0.517102 0.214191 0.903961    0.40733 0.153265 0.900329    0 0
  v 0.507936 0.210394 0.940961    0.871063 0.359877 0.334273    0 0
  v 0.492273 0.203906 0.978961    0.845774 0.35041 0.402342    0 0
  v 0.477476 0.197777 1.01596    0.883086 0.366943 0.292423    0 0
  v 0.470908 0.195057 1.05396    0.919825 0.381306 0.0923447    0 0
  v 0.470908 0.195057 1.35396    0.923879 0.382684 0    0 0
  v 0.470908 0.195057 1.65396    0.923879 0.382684 0    0 0
  v 0.470908 0.195057 1.95396    0.923879 0.382684 0    0 0
  v 0.470908 0.195057 2.25396    0.919486 0.38052 -0.0987445    0 0
  v 0.484795 0.200809 2.32896    0.867652 0.357492 -0.345514    0 0
  v 0.523339 0.216774 2.40396    0.760828 0.313196 -0.568374    0 0
  v 0.581861 0.241015 2.47896    0.670657 0.276386 -0.688353    0 0
  v 0.655684 0.271593 2.55396    0.582192 0.239142 -0.777086    0 0
  v 1.07133 0.443758 2.86696    0.489703 0.201341 -0.848324    0 0
  v 1.58891 0.658149 3.17896    0.447825 0.18543 -0.874682    0 0
  v 2.11337 0.875388 3.49196    0.477642 0.199059 -0.855706    0 0
  v 2.54964 1.05609 3.80396    0.559788 0.233788 -0.794972    0 0
  v 2.82571 1.17045 4.06596    0.642705 0.267493 -0.717898    0 0
  v 3.05233 1.26432 4.32896    0.706709 0.293899 -0.643573    0 0
  v 3.23548 1.34018 4.59096    0.765313 0.318068 -0.559579    0 0
  v 3.38113 1.40051 4.85396    0.822443 0.341759 -0.454739    0 0
  v 3.54905 1.47006 5.27896    0.875344 0.363476 -0.318838    0 0
  v 3.64716 1.5107 5.70396    0.908699 0.376802 -0.179684    0 0
  v 3.69309 1.52973 6.12896    0.921397 0.381767 -0.0726731    0 0
  v 3.70449 1.53445 6.55396    0.92267 0.382033 0.0522613    0 0
  v 3.6269 1.50231 7.17896    0.90055 0.372284 0.22453    0 0
  v 3.43598 1.42323 7.80396    0.865577 0.35806 0.350099    0 0
  v 3.19455 1.32323 8.42896    0.855539 0.354497 0.377339    0 0
  v 2.96538 1.2283 9.05396    0.865166 0.358606 0.350555    0 0
  v 2.8395 1.17616 9.44096    0.872651 0.361511 0.328314    0 0
  v 2.71651 1.12522 9.82896    0.877148 0.363452 0.31387    0 0
  v 2.60247 1.07798 10.217    0.885471 0.366964 0.285095    0 0
  v 2.50344 1.03696 10.604    0.898073 0.372273 0.234259    0 0
  v 2.49908 1.03515 10.627    0.910336 0.377264 0.170179    0 0
  v 2.49623 1.03397 10.649    0.918639 0.380637 0.105918    0 0
  v 2.49467 1.03333 10.672    0.9228 0.382279 0.0479843    0 0
  v 2.4942 1.03313 10.694    0.923869 0.382674 -0.00520589    0 0
  v 2.49464 1.03331 10.708    0.922821 0.382103 0.048973    0 0
  v 2.49305 1.03266 10.721    0.871523 0.35849 0.334564    0 0
  v 2.48511 1.02937 10.735    0.673146 0.273737 0.686981    0 0
  v 2.46649 1.02165 10.749    0.32528 0.126222 0.937156    0 0
  v 2.4578 1.01805 10.75    0.101714 0.0422875 0.993915    0 0
  v 2.44177 1.01142 10.752    0.0812899 0.0327132 0.996154    0 0
  v 2.42656 1.00511 10.753    0.0949152 0.0408298 0.994648    0 0
  v 2.42029 1.00252 10.754    0.136544 0.0513768 0.989301    0 0
  v 2.40452 0.995987 10.717    -0.90755 -0.377555 0.183864    0 0
  v 2.40672 0.996899 10.679    -0.908065 -0.375315 -0.185891    0 0
  v 2.41802 1.00158 10.641    -0.877566 -0.363425 -0.312729    0 0
  v 2.42953 1.00635 10.604    -0.884187 -0.36656 -0.289565    0 0
  v 2.52567 1.04617 10.217    -0.888645 -0.367948 -0.273723    0 0
  v 2.63336 1.09078 9.82896    -0.881777 -0.365125 -0.298586    0 0
  v 2.75 1.13909 9.44096    -0.876152 -0.362821 -0.317363    0 0
  v 2.87299 1.19003 9.05396    -0.869907 -0.360181 -0.336945    0 0
  v 3.08772 1.27898 8.42896    -0.86716 -0.359236 -0.344939    0 0
  v 3.2974 1.36583 7.80396    -0.880074 -0.364964 -0.303761    0 0
  v 3.45656 1.43175 7.17896    -0.907248 -0.376325 -0.187833    0 0
  v 3.51971 1.45791 6.55396    -0.930396 -0.350077 -0.108668    0 0
  v 0.00807154 0.00539303 0.953961    -0.664858 -0.476545 -0.575211    0 0
  v 0.0811959 0.0542533 0.828961    -0.690226 -0.461691 -0.557162    0 0
  v 0.147639 0.0986495 0.703961    -0.608242 -0.401372 -0.684793    0 0
  v 0.289806 0.193642 0.578961    -0.387958 -0.253985 -0.885991    0 0
  v 0.5901 0.394292 0.453961    -0.21269 -0.139202 -0.967153    0 0
  v 0.988036 0.660185 0.366461    -0.131298 -0.0868433 -0.987532    0 0
  v 1.52239 1.01723 0.278961    -0.111709 -0.0746192 -0.990935    0 0
  v 2.05829 1.37531 0.191961    -0.129571 -0.0874656 -0.987705    0 0
  v 2.46091 1.64433 0.103961    -0.223506 -0.152941 -0.962629    0 0
  v 2.48727 1.66194 0.0917106    -0.45135 -0.308606 -0.837285    0 0
  v 2.49739 1.6687 0.0794606    -0.557031 -0.370568 -0.743234    0 0
  v 2.51005 1.67717 0.0672107    -0.390053 -0.253806 -0.885122    0 0
  v 2.54405 1.69988 0.0549607    -0.131204 -0.0823478 -0.987929    0 0
  v 2.55448 1.70685 0.0547109    -0.00454182 -0.0024509 -0.999987    0 0
  v 2.57601 1.72124 0.0549607    -0.0118808 -0.00890494 -0.99989    0 0
  v 2.59716 1.73537 0.0539608    -0.0166959 -0.01038 -0.999807    0 0
  v 2.60641 1.74155 0.0539608    0.197126 0.141286 -0.970144    0 0
  v 2.68436 1.79364 0.103961    0.563662 0.384307 -0.731158    0 0
  v 2.71035 1.811 0.153961    0.720272 0.4478 -0.529796    0 0
  v 2.68436 1.79364 0.203961    0.570758 0.373688 0.731159    0 0
  v 2.60641 1.74155 0.253961    0.304188 0.198898 0.931617    0 0
  v 2.08441 1.39276 0.416961    0.182588 0.120717 0.975751    0 0
  v 1.37376 0.917917 0.578961    0.164704 0.11053 0.98013    0 0
  v 0.744182 0.497247 0.741961    0.26816 0.18364 0.945709    0 0
  v 0.46538 0.310957 0.903961    0.369603 0.229786 0.900329    0 0
  v 0.45713 0.305444 0.940961    0.784117 0.522898 0.334273    0 0
  v 0.443034 0.296026 0.978961    0.76116 0.50868 0.402343    0 0
  v 0.429717 0.287128 1.01596    0.794531 0.532174 0.292423    0 0
  v 0.423806 0.283178 1.05396    0.827762 0.553429 0.0923446    0 0
  v 0.423806 0.283178 1.35396    0.831469 0.555571 0    0 0
  v 0.423806 0.283178 1.65396    0.831469 0.555571 0    0 0
  v 0.423806 0.283178 1.95396    0.831469 0.555571 0    0 0
  v 0.423806 0.283178 2.25396    0.827582 0.552591 -0.0987445    0 0
  v 0.436304 0.291529 2.32896    0.781236 0.519894 -0.345514    0 0
  v 0.470992 0.314707 2.40396    0.685107 0.455608 -0.568374    0 0
  v 0.523661 0.349899 2.47896    0.603851 0.401914 -0.688353    0 0
  v 0.5901 0.394292 2.55396    0.524351 0.348127 -0.777086    0 0
  v 0.964168 0.644237 2.86696    0.441013 0.293009 -0.848324    0 0
  v 1.42998 0.955485 3.17896    0.403045 0.269233 -0.874682    0 0
  v 1.90198 1.27087 3.49196    0.42963 0.288418 -0.855706    0 0
  v 2.29461 1.53321 3.80396    0.503422 0.338505 -0.794972    0 0
  v 2.54308 1.69923 4.06596    0.57817 0.387739 -0.717898    0 0
  v 2.74703 1.83551 4.32896    0.635793 0.426124 -0.643573    0 0
  v 2.91185 1.94564 4.59096    0.688556 0.461262 -0.559579    0 0
  v 3.04294 2.03323 4.85396    0.739967 0.495643 -0.454739    0 0
  v 3.19406 2.1342 5.27896    0.787614 0.527263 -0.318838    0 0
  v 3.28235 2.1932 5.70396    0.817728 0.546841 -0.179684    0 0
  v 3.32369 2.22082 6.12896    0.829213 0.554187 -0.0726731    0 0
  v 3.33395 2.22767 6.55396    0.83041 0.554696 0.0522614    0 0
  v 3.26412 2.18102 7.17896    0.810617 0.540819 0.22453    0 0
  v 3.0923 2.06621 7.80396    0.779091 0.520046 0.350099    0 0
  v 2.87502 1.92103 8.42896    0.769941 0.514593 0.377339    0 0
  v 2.66877 1.78322 9.05396    0.778582 0.520502 0.350555    0 0
  v 2.55549 1.70752 9.44096    0.785356 0.52481 0.328314    0 0
  v 2.4448 1.63356 9.82896    0.789388 0.527591 0.31387    0 0
  v 2.34216 1.56498 10.217    0.796865 0.53266 0.285095    0 0
  v 2.25304 1.50543 10.604    0.80819 0.540325 0.234259    0 0
  v 2.24911 1.50281 10.627    0.819243 0.547612 0.17018    0 0
  v 2.24654 1.50109 10.649    0.826729 0.552541 0.105916    0 0
  v 2.24515 1.50016 10.672    0.83049 0.554963 0.0479816    0 0
  v 2.24472 1.49988 10.694    0.831461 0.555559 -0.00520018    0 0
  v 2.24511 1.50014 10.708    0.830545 0.554794 0.0489794    0 0
  v 2.24369 1.49918 10.721    0.784839 0.521628 0.334562    0 0
  v 2.23654 1.49441 10.735    0.606809 0.399801 0.68698    0 0
  v 2.21978 1.48321 10.749    0.294405 0.187255 0.937156    0 0
  v 2.21196 1.47798 10.75    0.0915096 0.0613183 0.993915    0 0
  v 2.19754 1.46835 10.752    0.0733462 0.0479437 0.996153    0 0
  v 2.18385 1.4592 10.753    0.085126 0.0585624 0.994648    0 0
  v 2.17821 1.45543 10.754    0.123896 0.0770273 0.989301    0 0
  v 2.16401 1.44595 10.717    -0.816454 -0.547354 0.183863    0 0
  v 2.166 1.44727 10.679    -0.817397 -0.545259 -0.185891    0 0
  v 2.17616 1.45406 10.641    -0.789804 -0.527647 -0.312727    0 0
  v 2.18652 1.46099 10.604    -0.795685 -0.532013 -0.289563    0 0
  v 2.27305 1.5188 10.217    -0.799787 -0.534244 -0.273723    0 0
  v 2.36996 1.58356 9.82896    -0.793601 -0.530135 -0.298586    0 0
  v 2.47494 1.6537 9.44096    -0.788534 -0.526778 -0.317363    0 0
  v 2.58563 1.72766 9.05396    -0.782924 -0.52297 -0.336946    0 0
  v 2.77888 1.85679 8.42896    -0.780414 -0.521508 -0.344939    0 0
  v 2.96758 1.98288 7.80396    -0.791963 -0.529645 -0.303761    0 0
  v 3.11082 2.07858 7.17896    -0.816398 -0.546089 -0.187833    0 0
  v 3.16766 2.11656 6.55396    -0.844222 -0.524862 -0.108668    0 0
  v 0.00686431 0.00686407 0.953961    -0.55912 -0.597089 -0.575212    0 0
  v 0.0690515 0.0690513 0.828961    -0.586899 -0.587469 -0.557162    0 0
  v 0.125557 0.125557 0.703961    -0.518252 -0.512322 -0.684793    0 0
  v 0.24646 0.246459 0.578961    -0.330954 -0.324791 -0.885991    0 0
  v 0.501839 0.501839 0.453961    -0.181446 -0.178021 -0.967153    0 0
  v 0.840256 0.840256 0.366461    -0.111833 -0.11079 -0.987532    0 0
  v 1.29468 1.29468 0.278961    -0.0950052 -0.0949788 -0.990935    0 0
  v 1.75043 1.75043 0.191961    -0.110017 -0.111063 -0.987705    0 0
  v 2.09283 2.09283 0.103961    -0.189374 -0.193606 -0.962629    0 0
  v 2.11525 2.11525 0.0917106    -0.382471 -0.39073 -0.837285    0 0
  v 2.12385 2.12385 0.0794606    -0.474033 -0.472118 -0.743234    0 0
  v 2.13462 2.13463 0.0672107    -0.333043 -0.325025 -0.885122    0 0
  v 2.16354 2.16354 0.0549607    -0.112618 -0.106362 -0.987929    0 0
  v 2.17241 2.17241 0.0547109    -0.00397643 -0.0032899 -0.999987    0 0
  v 2.19072 2.19072 0.0549607    -0.00991521 -0.0110516 -0.99989    0 0
  v 2.2087 2.2087 0.0539608    -0.01435 -0.0134377 -0.999807    0 0
  v 2.21657 2.21657 0.0539608    0.165774 0.177029 -0.970144    0 0
  v 2.28286 2.28286 0.103961    0.477857 0.486888 -0.731159    0 0
  v 2.30496 2.30496 0.153961    0.61907 0.579714 -0.529796    0 0
  v 2.28286 2.28286 0.203961    0.486888 0.477857 0.731159    0 0
  v 2.21657 2.21657 0.253961    0.25954 0.25442 0.931617    0 0
  v 1.77264 1.77264 0.416961    0.155529 0.154018 0.975751    0 0
  v 1.16829 1.16829 0.578961    0.139976 0.140538 0.98013    0 0
  v 0.632875 0.632875 0.741961    0.227182 0.232427 0.945709    0 0
  v 0.395773 0.395773 0.903961    0.317672 0.297476 0.900329    0 0
  v 0.388757 0.388757 0.940961    0.667039 0.665823 0.334273    0 0
  v 0.376769 0.376769 0.978961    0.647297 0.6474 0.402343    0 0
  v 0.365444 0.365444 1.01596    0.675443 0.676953 0.292423    0 0
  v 0.360418 0.360418 1.05396    0.703888 0.704282 0.0923446    0 0
  v 0.360418 0.360418 1.35396    0.707107 0.707107 0    0 0
  v 0.360418 0.360418 1.65396    0.707107 0.707107 0    0 0
  v 0.360418 0.360418 1.95396    0.707107 0.707107 0    0 0
  v 0.360418 0.360418 2.25396    0.703876 0.703426 -0.0987442    0 0
  v 0.371046 0.371046 2.32896    0.664799 0.662316 -0.345514    0 0
  v 0.400546 0.400546 2.40396    0.583058 0.580511 -0.568375    0 0
  v 0.445337 0.445337 2.47896    0.513838 0.511997 -0.688353    0 0
  v 0.501839 0.501839 2.55396    0.44636 0.443734 -0.777086    0 0
  v 0.819958 0.819958 2.86696    0.375376 0.373416 -0.848324    0 0
  v 1.2161 1.2161 3.17896    0.342776 0.34269 -0.874682    0 0
  v 1.6175 1.61751 3.49196    0.365107 0.366693 -0.855706    0 0
  v 1.95141 1.95141 3.80396    0.42771 0.430214 -0.794972    0 0
  v 2.16271 2.16271 4.06596    0.491417 0.493084 -0.717898    0 0
  v 2.33615 2.33616 4.32896    0.540444 0.541973 -0.643573    0 0
  v 2.47633 2.47633 4.59096    0.585338 0.586729 -0.559579    0 0
  v 2.5878 2.5878 4.85396    0.629053 0.630479 -0.454739    0 0
  v 2.71632 2.71632 5.27896    0.669617 0.670788 -0.318838    0 0
  v 2.79141 2.79141 5.70396    0.695333 0.695864 -0.179683    0 0
  v 2.82657 2.82657 6.12896    0.705164 0.70531 -0.0726732    0 0
  v 2.83529 2.83529 6.55396    0.706238 0.706043 0.0522612    0 0
  v 2.7759 2.77591 7.17896    0.689533 0.688571 0.22453    0 0
  v 2.62979 2.62979 7.80396    0.662665 0.662047 0.350099    0 0
  v 2.445 2.445 8.42896    0.654755 0.654913 0.377339    0 0
  v 2.26961 2.26961 9.05396    0.662077 0.662394 0.350555    0 0
  v 2.17326 2.17326 9.44096    0.667881 0.667941 0.328314    0 0
  v 2.07913 2.07913 9.82896    0.671293 0.671455 0.31387    0 0
  v 1.99185 1.99185 10.217    0.677637 0.677885 0.285095    0 0
  v 1.91605 1.91605 10.604    0.687249 0.687613 0.234258    0 0
  v 1.91271 1.91271 10.627    0.696668 0.696916 0.170179    0 0
  v 1.91053 1.91053 10.649    0.703048 0.70321 0.105919    0 0
  v 1.90934 1.90934 10.672    0.706265 0.70632 0.0479812    0 0
  v 1.90898 1.90898 10.694    0.707101 0.707094 -0.00520415    0 0
  v 1.90931 1.90931 10.708    0.706351 0.706165 0.04898    0 0
  v 1.9081 1.9081 10.721    0.667994 0.664719 0.334564    0 0
  v 1.90202 1.90202 10.735    0.517153 0.510502 0.68698    0 0
  v 1.88777 1.88777 10.749    0.252216 0.241093 0.937156    0 0
  v 1.88112 1.88112 10.75    0.0777887 0.0779927 0.993915    0 0
  v 1.86885 1.86885 10.752    0.0625836 0.0613317 0.996153    0 0
  v 1.85721 1.85721 10.753    0.072066 0.0740451 0.994648    0 0
  v 1.85241 1.85241 10.754    0.106489 0.0997187 0.989301    0 0
  v 1.84034 1.84034 10.717    -0.693983 -0.696119 0.183865    0 0
  v 1.84203 1.84203 10.679    -0.695316 -0.694248 -0.185891    0 0
  v 1.85067 1.85067 10.641    -0.671689 -0.671591 -0.312728    0 0
  v 1.85948 1.85948 10.604    -0.676606 -0.677021 -0.289563    0 0
  v 1.93307 1.93307 10.217    -0.680193 -0.68001 -0.273723    0 0
  v 2.01549 2.01549 9.82896    -0.674928 -0.674772 -0.298586    0 0
  v 2.10476 2.10476 9.44096    -0.670613 -0.670491 -0.317363    0 0
  v 2.19889 2.1989 9.05396    -0.665854 -0.665662 -0.336946    0 0
  v 2.36324 2.36324 8.42896    -0.663678 -0.663739 -0.344939    0 0
  v 2.52372 2.52372 7.80396    -0.673417 -0.673972 -0.303761    0 0
  v 2.64553 2.64553 7.17896    -0.694174 -0.694867 -0.187833    0 0
  v 2.69387 2.69387 6.55396    -0.725605 -0.679476 -0.108668    0 0
  v 0.00539333 0.00807118 0.953961    -0.431905 -0.694688 -0.57521    0 0
  v 0.0542535 0.0811956 0.828961    -0.461009 -0.690682 -0.557162    0 0
  v 0.0986497 0.147639 0.703961    -0.408345 -0.603583 -0.684793    0 0
  v 0.193642 0.289806 0.578961    -0.261232 -0.383116 -0.885991    0 0
  v 0.394293 0.5901 0.453961    -0.14323 -0.209998 -0.967153    0 0
  v 0.660185 0.988036 0.366461    -0.08807 -0.130478 -0.987532    0 0
  v 1.01723 1.52239 0.278961    -0.0746503 -0.111688 -0.990935    0 0
  v 1.37531 2.05829 0.191961    -0.0862361 -0.130392 -0.987705    0 0
  v 1.64433 2.46091 0.103961    -0.147964 -0.226831 -0.962629    0 0
  v 1.66194 2.48727 0.0917106    -0.298895 -0.457839 -0.837285    0 0
  v 1.6687 2.49739 0.0794606    -0.37282 -0.555527 -0.743233    0 0
  v 1.67717 2.51005 0.0672107    -0.263236 -0.383754 -0.885121    0 0
  v 1.69988 2.54405 0.0549607    -0.0897033 -0.126289 -0.987929    0 0
  v 1.70685 2.55448 0.0547109    -0.00325826 -0.00400254 -0.999987    0 0
  v 1.72124 2.57601 0.0549607    -0.00756868 -0.0127737 -0.99989    0 0
  v 1.73537 2.59716 0.0539608    -0.0114528 -0.0159791 -0.999807    0 0
  v 1.74155 2.60641 0.0539608    0.128053 0.205968 -0.970144    0 0
  v 1.79364 2.68436 0.103961    0.373688 0.570758 -0.731159    0 0
  v 1.811 2.71035 0.153961    0.494079 0.689349 -0.529796    0 0
  v 1.79364 2.68436 0.203961    0.384307 0.563662 0.731158    0 0
  v 1.74155 2.60641 0.253961    0.204918 0.300165 0.931617    0 0
  v 1.39276 2.08441 0.416961    0.122493 0.181401 0.975751    0 0
  v 0.917918 1.37376 0.578961    0.109869 0.165146 0.98013    0 0
  v 0.497247 0.744182 0.741961    0.177472 0.272281 0.94571    0 0
  v 0.310957 0.46538 0.903961    0.253533 0.353735 0.900329    0 0
  v 0.305445 0.45713 0.940961    0.524326 0.783162 0.334274    0 0
  v 0.296026 0.443034 0.978961    0.508558 0.761242 0.402343    0 0
  v 0.287128 0.429717 1.01596    0.530397 0.795718 0.292423    0 0
  v 0.283179 0.423806 1.05396    0.552965 0.828071 0.092345    0 0
  v 0.283179 0.423806 1.35396    0.555571 0.831469 0    0 0
  v 0.283179 0.423806 1.65396    0.555571 0.831469 0    0 0
  v 0.283179 0.423806 1.95396    0.555571 0.831469 0    0 0
  v 0.283179 0.423806 2.25396    0.55312 0.827229 -0.0987442    0 0
  v 0.291529 0.436304 2.32896    0.522814 0.779285 -0.345514    0 0
  v 0.314707 0.470992 2.40396    0.458603 0.683106 -0.568375    0 0
  v 0.349899 0.523661 2.47896    0.40408 0.602404 -0.688353    0 0
  v 0.394293 0.5901 2.55396    0.351215 0.522288 -0.777086    0 0
  v 0.644237 0.964168 2.86696    0.295314 0.439473 -0.848324    0 0
  v 0.955485 1.42998 3.17896    0.269334 0.402977 -0.874682    0 0
  v 1.27087 1.90198 3.49196    0.286553 0.430875 -0.855706    0 0
  v 1.53321 2.29461 3.80396    0.335561 0.505389 -0.794972    0 0
  v 1.69923 2.54308 4.06596    0.385779 0.57948 -0.717898    0 0
  v 1.83551 2.74703 4.32896    0.424326 0.636994 -0.643573    0 0
  v 1.94564 2.91185 4.59096    0.459626 0.689649 -0.559579    0 0
  v 2.03322 3.04294 4.85396    0.493966 0.741087 -0.454739    0 0
  v 2.1342 3.19406 5.27896    0.525886 0.788534 -0.318838    0 0
  v 2.1932 3.28235 5.70396    0.546216 0.818146 -0.179684    0 0
  v 2.22082 3.3237 6.12896    0.554015 0.829328 -0.072673    0 0
  v 2.22767 3.33395 6.55396    0.554926 0.830256 0.0522613    0 0
  v 2.18102 3.26412 7.17896    0.54195 0.809862 0.22453    0 0
  v 2.06621 3.0923 7.80396    0.520773 0.778605 0.350099    0 0
  v 1.92103 2.87502 8.42896    0.514407 0.770065 0.377339    0 0
  v 1.78322 2.66877 9.05396    0.520129 0.778831 0.350555    0 0
  v 1.70752 2.55549 9.44096    0.524739 0.785404 0.328314    0 0
  v 1.63356 2.4448 9.82896    0.5274 0.789516 0.31387    0 0
  v 1.56498 2.34216 10.217    0.532368 0.79706 0.285095    0 0
  v 1.50543 2.25304 10.604    0.539897 0.808476 0.234258    0 0
  v 1.50281 2.24911 10.627    0.54732 0.819439 0.170178    0 0
  v 1.50109 2.24654 10.649    0.55235 0.826856 0.105919    0 0
  v 1.50016 2.24515 10.672    0.554898 0.830533 0.0479835    0 0
  v 1.49988 2.24472 10.694    0.555567 0.831456 -0.00520418    0 0
  v 1.50014 2.24511 10.708    0.555013 0.830399 0.0489746    0 0
  v 1.49918 2.24369 10.721    0.525479 0.782266 0.334563    0 0
  v 1.49441 2.23654 10.735    0.407621 0.601584 0.68698    0 0
  v 1.48321 2.21978 10.749    0.200334 0.285664 0.937156    0 0
  v 1.47798 2.21196 10.75    0.0610786 0.0916701 0.993915    0 0
  v 1.46835 2.19754 10.752    0.0494157 0.0723624 0.996153    0 0
  v 1.4592 2.18385 10.753    0.056236 0.086682 0.994648    0 0
  v 1.45543 2.17821 10.754    0.0849895 0.118579 0.989301    0 0
  v 1.44595 2.16401 10.717    -0.544842 -0.818133 0.183864    0 0
  v 1.44727 2.166 10.679    -0.546515 -0.816558 -0.185889    0 0
  v 1.45406 2.17616 10.641    -0.527762 -0.789727 -0.312729    0 0
  v 1.46099 2.18652 10.604    -0.531525 -0.796011 -0.289564    0 0
  v 1.5188 2.27305 10.217    -0.53446 -0.799642 -0.273723    0 0
  v 1.58356 2.36996 9.82896    -0.530318 -0.793479 -0.298587    0 0
  v 1.6537 2.47494 9.44096    -0.526921 -0.788438 -0.317363    0 0
  v 1.72766 2.58563 9.05396    -0.523196 -0.782773 -0.336946    0 0
  v 1.85679 2.77888 8.42896    -0.521436 -0.780462 -0.344939    0 0
  v 1.98288 2.96758 7.80396    -0.528992 -0.792399 -0.303761    0 0
  v 2.07858 3.11082 7.17896    -0.545274 -0.816942 -0.187833    0 0
  v 2.11656 3.16766 6.55396    -0.579104 -0.807979 -0.108668    0 0
  v 0.00371511 0.00896835 0.953961    -0.288058 -0.765605 -0.575214    0 0
  v 0.0373706 0.0902197 0.828961    -0.317418 -0.767344 -0.557162    0 0
  v 0.0679512 0.164048 0.703961    -0.282744 -0.67165 -0.684793    0 0
  v 0.133383 0.322015 0.578961    -0.18147 -0.426718 -0.885991    0 0
  v 0.271594 0.655684 0.453961    -0.0995089 -0.233906 -0.967153    0 0
  v 0.454744 1.09785 0.366461    -0.0609226 -0.145153 -0.987532    0 0
  v 0.700677 1.69158 0.278961    -0.0514266 -0.124106 -0.990935    0 0
  v 0.947328 2.28705 0.191961    -0.0591408 -0.144711 -0.987705    0 0
  v 1.13263 2.73441 0.103961    -0.100869 -0.251339 -0.962629    0 0
  v 1.14476 2.7637 0.0917106    -0.203831 -0.507353 -0.837285    0 0
  v 1.14942 2.77495 0.0794606    -0.257277 -0.617585 -0.743234    0 0
  v 1.15525 2.78902 0.0672107    -0.183311 -0.427736 -0.885121    0 0
  v 1.1709 2.8268 0.0549607    -0.0633418 -0.141362 -0.987929    0 0
  v 1.1757 2.83839 0.0547109    -0.00241482 -0.00456132 -0.999987    0 0
  v 1.18561 2.86231 0.0549607    -0.00493119 -0.0140048 -0.99989    0 0
  v 1.19534 2.88581 0.0539608    -0.00811532 -0.0179064 -0.999807    0 0
  v 1.1996 2.89609 0.0539608    0.0854096 0.226993 -0.970144    0 0
  v 1.23548 2.98271 0.103961    0.255158 0.632693 -0.731159    0 0
  v 1.24744 3.01158 0.153961    0.3501 0.772494 -0.529796    0 0
  v 1.23548 2.98271 0.203961    0.266958 0.627806 0.731159    0 0
  v 1.1996 2.89609 0.253961    0.142421 0.334375 0.931617    0 0
  v 0.959347 2.31607 0.416961    0.0847498 0.201813 0.975751    0 0
  v 0.632273 1.52644 0.578961    0.0755393 0.183407 0.98013    0 0
  v 0.34251 0.826891 0.741961    0.120942 0.301673 0.94571    0 0
  v 0.214191 0.517102 0.903961    0.179651 0.3964 0.900329    0 0
  v 0.210394 0.507935 0.940961    0.361463 0.870405 0.334274    0 0
  v 0.203906 0.492273 0.978961    0.350275 0.84583 0.402342    0 0
  v 0.197777 0.477476 1.01596    0.364968 0.883904 0.292423    0 0
  v 0.195057 0.470908 1.05396    0.380791 0.920039 0.0923446    0 0
  v 0.195057 0.470908 1.35396    0.382683 0.92388 0    0 0
  v 0.195057 0.470908 1.65396    0.382683 0.92388 0    0 0
  v 0.195057 0.470908 1.95396    0.382683 0.92388 0    0 0
  v 0.195057 0.470908 2.25396    0.381107 0.919243 -0.0987442    0 0
  v 0.200809 0.484795 2.32896    0.360737 0.866308 -0.345514    0 0
  v 0.216774 0.523338 2.40396    0.316523 0.759449 -0.568375    0 0
  v 0.241015 0.581861 2.47896    0.278792 0.669661 -0.688353    0 0
  v 0.271594 0.655684 2.55396    0.242573 0.580771 -0.777086    0 0
  v 0.443758 1.07133 2.86696    0.203902 0.488642 -0.848324    0 0
  v 0.658149 1.58891 3.17896    0.185542 0.447779 -0.874682    0 0
  v 0.875388 2.11337 3.49196    0.196988 0.4785 -0.855706    0 0
  v 1.05609 2.54964 3.80396    0.230517 0.561143 -0.794972    0 0
  v 1.17045 2.82571 4.06596    0.265315 0.643607 -0.717898    0 0
  v 1.26432 3.05233 4.32896    0.291901 0.707536 -0.643573    0 0
  v 1.34018 3.23548 4.59096    0.31625 0.766066 -0.559578    0 0
  v 1.40051 3.38113 4.85396    0.339896 0.823215 -0.454739    0 0
  v 1.47006 3.54905 5.27896    0.361946 0.875978 -0.318838    0 0
  v 1.5107 3.64716 5.70396    0.376108 0.908987 -0.179684    0 0
  v 1.52973 3.69309 6.12896    0.381576 0.921476 -0.072673    0 0
  v 1.53445 3.70449 6.55396    0.382288 0.922564 0.0522613    0 0
  v 1.50231 3.6269 7.17896    0.373541 0.90003 0.22453    0 0
  v 1.42323 3.43598 7.80396    0.358868 0.865242 0.350099    0 0
  v 1.32323 3.19455 8.42896    0.35429 0.855625 0.377339    0 0
  v 1.2283 2.96538 9.05396    0.358192 0.865338 0.350555    0 0
  v 1.17616 2.8395 9.44096    0.361431 0.872684 0.328314    0 0
  v 1.12522 2.71651 9.82896    0.363239 0.877236 0.31387    0 0
  v 1.07798 2.60247 10.217    0.36664 0.885605 0.285095    0 0
  v 1.03696 2.50344 10.604    0.371797 0.898271 0.234258    0 0
  v 1.03515 2.49908 10.627    0.376939 0.91047 0.170179    0 0
  v 1.03397 2.49623 10.649    0.380425 0.918727 0.105917    0 0
  v 1.03333 2.49467 10.672    0.382206 0.92283 0.0479809    0 0
  v 1.03313 2.4942 10.694    0.382683 0.923865 -0.0052009    0 0
  v 1.03331 2.49464 10.708    0.382346 0.922721 0.0489755    0 0
  v 1.03266 2.49305 10.721    0.362769 0.869751 0.334561    0 0
  v 1.02937 2.48511 10.735    0.282426 0.669547 0.68698    0 0
  v 1.02165 2.46649 10.749    0.140754 0.319259 0.937156    0 0
  v 1.01805 2.4578 10.75    0.042021 0.101825 0.993915    0 0
  v 1.01142 2.44177 10.752    0.0343489 0.0806123 0.996154    0 0
  v 1.00511 2.42656 10.753    0.0382444 0.0959871 0.994648    0 0
  v 1.00252 2.42029 10.754    0.0602226 0.132881 0.989301    0 0
  v 0.995986 2.40452 10.717    -0.374763 -0.908706 0.183863    0 0
  v 0.996898 2.40673 10.679    -0.376711 -0.907487 -0.185891    0 0
  v 1.00158 2.41802 10.641    -0.363553 -0.877514 -0.312728    0 0
  v 1.00635 2.42953 10.604    -0.366018 -0.884411 -0.289564    0 0
  v 1.04617 2.52567 10.217    -0.368188 -0.888546 -0.273723    0 0
  v 1.09078 2.63336 9.82896    -0.365328 -0.881692 -0.298586    0 0
  v 1.13909 2.75 9.44096    -0.36298 -0.876086 -0.317363    0 0
  v 1.19003 2.87299 9.05396    -0.360431 -0.869803 -0.336946    0 0
  v 1.27898 3.08772 8.42896    -0.359156 -0.867193 -0.344939    0 0
  v 1.36583 3.2974 7.80396    -0.364238 -0.880375 -0.303761    0 0
  v 1.43175 3.45656 7.17896    -0.375419 -0.907623 -0.187833    0 0
  v 1.45791 3.51971 6.55396    -0.410348 -0.905431 -0.108668    0 0
  v 0.00189409 0.00952053 0.953961    -0.133166 -0.807094 -0.57521    0 0
  v 0.0190515 0.0957768 0.828961    -0.161595 -0.814529 -0.557162    0 0
  v 0.0346413 0.174152 0.703961    -0.14628 -0.713905 -0.684793    0 0
  v 0.0679983 0.341849 0.578961    -0.0947337 -0.453922 -0.885991    0 0
  v 0.138457 0.69607 0.453961    -0.051964 -0.248825 -0.967153    0 0
  v 0.231826 1.16547 0.366461    -0.0314341 -0.154249 -0.987532    0 0
  v 0.357202 1.79578 0.278961    -0.0262266 -0.131754 -0.990935    0 0
  v 0.482944 2.42792 0.191961    -0.0297728 -0.153468 -0.987705    0 0
  v 0.57741 2.90284 0.103961    -0.0498966 -0.266188 -0.962629    0 0
  v 0.583595 2.93393 0.0917106    -0.100935 -0.53737 -0.837285    0 0
  v 0.58597 2.94587 0.0794606    -0.131849 -0.655909 -0.743235    0 0
  v 0.588942 2.96081 0.0672107    -0.0963411 -0.455277 -0.885122    0 0
  v 0.596919 3.00092 0.0549607    -0.0345464 -0.151004 -0.987929    0 0
  v 0.599366 3.01321 0.0547109    -0.00147851 -0.00494463 -0.999987    0 0
  v 0.604418 3.03861 0.0549607    -0.00210423 -0.0146977 -0.99989    0 0
  v 0.609379 3.06356 0.0539608    -0.00446599 -0.0191455 -0.999807    0 0
  v 0.611551 3.07447 0.0539608    0.0394845 0.239294 -0.970144    0 0
  v 0.629841 3.16642 0.103961    0.126823 0.670315 -0.731159    0 0
  v 0.635937 3.19707 0.153961    0.192666 0.825951 -0.529797    0 0
  v 0.629841 3.16642 0.203961    0.139349 0.667824 0.731159    0 0
  v 0.611551 3.07447 0.253961    0.0744512 0.355735 0.931617    0 0
  v 0.489071 2.45872 0.416961    0.0437497 0.214469 0.975751    0 0
  v 0.32233 1.62046 0.578961    0.0383069 0.19462 0.98013    0 0
  v 0.17461 0.877823 0.741961    0.0597652 0.319471 0.945709    0 0
  v 0.109194 0.548952 0.903961    0.0988653 0.423832 0.900329    0 0
  v 0.107258 0.539221 0.940961    0.18471 0.924199 0.334273    0 0
  v 0.103951 0.522594 0.978961    0.178532 0.897913 0.402342    0 0
  v 0.100826 0.506886 1.01596    0.185515 0.938122 0.292423    0 0
  v 0.0994392 0.499913 1.05396    0.193983 0.976649 0.0923447    0 0
  v 0.0994392 0.499913 1.35396    0.19509 0.980785 0    0 0
  v 0.0994392 0.499913 1.65396    0.19509 0.980785 0    0 0
  v 0.0994392 0.499913 1.95396    0.19509 0.980785 0    0 0
  v 0.0994392 0.499913 2.25396    0.194449 0.97593 -0.0987442    0 0
  v 0.102372 0.514655 2.32896    0.184798 0.920038 -0.345514    0 0
  v 0.110511 0.555573 2.40396    0.16228 0.806607 -0.568374    0 0
  v 0.122868 0.6177 2.47896    0.142791 0.711183 -0.688353    0 0
  v 0.138457 0.69607 2.55396    0.124609 0.616935 -0.777087    0 0
  v 0.226226 1.13731 2.86696    0.104655 0.519032 -0.848324    0 0
  v 0.335522 1.68678 3.17896    0.0946192 0.475372 -0.874682    0 0
  v 0.446269 2.24354 3.49196    0.0998518 0.507736 -0.855706    0 0
  v 0.538392 2.70668 3.80396    0.116614 0.595332 -0.794972    0 0
  v 0.59669 2.99976 4.06596    0.134656 0.683001 -0.717898    0 0
  v 0.644544 3.24034 4.32896    0.148258 0.750888 -0.643573    0 0
  v 0.683217 3.43476 4.59096    0.160721 0.813044 -0.559579    0 0
  v 0.713973 3.58939 4.85396    0.172763 0.873708 -0.454739    0 0
  v 0.749431 3.76765 5.27896    0.184096 0.929759 -0.318838    0 0
  v 0.770149 3.8718 5.70396    0.191546 0.964896 -0.179684    0 0
  v 0.779849 3.92057 6.12896    0.194473 0.978212 -0.0726731    0 0
  v 0.782255 3.93266 6.55396    0.194959 0.979418 0.0522614    0 0
  v 0.765871 3.85029 7.17896    0.190776 0.95561 0.22453    0 0
  v 0.725557 3.64762 7.80396    0.183172 0.918629 0.350099    0 0
  v 0.674574 3.39131 8.42896    0.180558 0.908303 0.377339    0 0
  v 0.626183 3.14803 9.05396    0.18249 0.918591 0.350555    0 0
  v 0.599602 3.0144 9.44096    0.184234 0.926428 0.328314    0 0
  v 0.57363 2.88383 9.82896    0.185119 0.931245 0.31387    0 0
  v 0.549549 2.76277 10.217    0.186822 0.940116 0.285095    0 0
  v 0.528638 2.65764 10.604    0.189409 0.953545 0.234258    0 0
  v 0.527716 2.653 10.627    0.192072 0.966513 0.170177    0 0
  v 0.527114 2.64998 10.649    0.193881 0.975291 0.105919    0 0
  v 0.526786 2.64833 10.672    0.194827 0.979663 0.0479817    0 0
  v 0.526687 2.64783 10.694    0.195092 0.980771 -0.00520213    0 0
  v 0.526778 2.64829 10.708    0.194985 0.979583 0.0489764    0 0
  v 0.526443 2.64661 10.721    0.186119 0.923813 0.334558    0 0
  v 0.524766 2.63818 10.735    0.146377 0.711782 0.686979    0 0
  v 0.520834 2.61841 10.749    0.0757656 0.340584 0.937156    0 0
  v 0.518999 2.60918 10.75    0.0213486 0.108066 0.993914    0 0
  v 0.515615 2.59217 10.752    0.0179622 0.0857647 0.996153    0 0
  v 0.512402 2.57602 10.753    0.0187835 0.101604 0.994648    0 0
  v 0.51108 2.56937 10.754    0.0331417 0.142077 0.989301    0 0
  v 0.507749 2.55263 10.717    -0.190282 -0.964358 0.183865    0 0
  v 0.508214 2.55497 10.679    -0.192431 -0.963543 -0.185892    0 0
  v 0.510599 2.56696 10.641    -0.185373 -0.931578 -0.312729    0 0
  v 0.51303 2.57918 10.604    -0.186445 -0.938824 -0.289565    0 0
  v 0.533332 2.68124 10.217    -0.187767 -0.943302 -0.273723    0 0
  v 0.556072 2.79556 9.82896    -0.186299 -0.936023 -0.298586    0 0
  v 0.580702 2.91939 9.44096    -0.18509 -0.930066 -0.317363    0 0
  v 0.606674 3.04995 9.05396    -0.183815 -0.923407 -0.336946    0 0
  v 0.652017 3.27791 8.42896    -0.183074 -0.920598 -0.344939    0 0
  v 0.696293 3.5005 7.80396    -0.185487 -0.934518 -0.303761    0 0
  v 0.729901 3.66946 7.17896    -0.191137 -0.963424 -0.187833    0 0
  v 0.743237 3.7365 6.55396    -0.225822 -0.968089 -0.108668    0 0
  v 3.14717e-007 3.25971 0.153961    -0.0278294 0.84767 0.529793    0 0
  v 3.14717e-007 0.559707 0.903961    -0.0316935 0.965389 0.25888    0 0
  v 3.14717e-007 2.61971 10.754    0.0297976 -0.907621 0.418732    0 0
  v -0.635937 3.19707 0.153961    -0.192667 0.825953 0.529793    0 0
  v -0.109193 0.548953 0.903961    -0.219424 0.940657 0.258879    0 0
  v -0.511079 2.56937 10.754    0.206293 -0.884367 0.418733    0 0
  v -1.24744 3.01158 0.153961    -0.350101 0.772496 0.529792    0 0
  v -0.21419 0.517102 0.903961    -0.39872 0.879775 0.25888    0 0
  v -1.00252 2.42029 10.754    0.374861 -0.82713 0.418731    0 0
  v -1.811 2.71035 0.153961    -0.49408 0.689352 0.529792    0 0
  v -0.310956 0.46538 0.903961    -0.562694 0.785083 0.258881    0 0
  v -1.45543 2.17821 10.754    0.529023 -0.738105 0.418731    0 0
  v -2.30496 2.30496 0.153961    -0.619072 0.579716 0.529792    0 0
  v -0.395772 0.395773 0.903961    -0.705044 0.660222 0.258881    0 0
  v -1.85241 1.85241 10.754    0.662855 -0.620715 0.418732    0 0
  v -2.71035 1.811 0.153961    -0.720274 0.447801 0.529792    0 0
  v -0.465379 0.310957 0.903961    -0.8203 0.509989 0.258881    0 0
  v -2.17821 1.45543 10.754    0.771214 -0.479471 0.418732    0 0
  v -3.01158 1.24744 0.153961    -0.793795 0.298678 0.529793    0 0
  v -0.517102 0.214191 0.903961    -0.904032 0.340156 0.258881    0 0
  v -2.42029 1.00252 10.754    0.849935 -0.319802 0.418733    0 0
  v -3.19707 0.635937 0.153961    -0.836812 0.138078 0.529793    0 0
  v -0.548952 0.109193 0.903961    -0.953023 0.157253 0.258881    0 0
  v -2.56937 0.511079 10.754    0.895994 -0.147843 0.418734    0 0
  v -3.25971 0 0.153961    -0.847671 -0.0278295 0.529792    0 0
  v -0.559707 0 0.903961    -0.965389 -0.0316936 0.258881    0 0
  v -2.61971 0 10.754    0.907621 0.0297976 0.418732    0 0
  v -3.19707 -0.635937 0.153961    -0.825954 -0.192667 0.529791    0 0
  v -0.548952 -0.109194 0.903961    -0.940656 -0.219424 0.258881    0 0
  v -2.56937 -0.51108 10.754    0.884367 0.206293 0.418733    0 0
  v -3.01158 -1.24744 0.153961    -0.772496 -0.350101 0.529792    0 0
  v -0.517102 -0.214191 0.903961    -0.879774 -0.39872 0.258881    0 0
  v -2.42029 -1.00252 10.754    0.82713 0.374861 0.418731    0 0
  v -2.71035 -1.811 0.153961    -0.689351 -0.49408 0.529792    0 0
  v -0.465379 -0.310957 0.903961    -0.785084 -0.562694 0.258879    0 0
  v -2.17821 -1.45543 10.754    0.738105 0.529023 0.418732    0 0
  v -2.30496 -2.30496 0.153961    -0.579715 -0.619071 0.529794    0 0
  v -0.395772 -0.395773 0.903961    -0.660222 -0.705045 0.25888    0 0
  v -1.85241 -1.85241 10.754    0.620715 0.662855 0.418732    0 0
  v -1.811 -2.71035 0.153961    -0.4478 -0.720271 0.529796    0 0
  v -0.310956 -0.465379 0.903961    -0.50999 -0.8203 0.258879    0 0
  v -1.45543 -2.17821 10.754    0.479471 0.771214 0.418732    0 0
  v -1.24744 -3.01158 0.153961    -0.298678 -0.793794 0.529795    0 0
  v -0.21419 -0.517102 0.903961    -0.340157 -0.904032 0.258881    0 0
  v -1.00252 -2.42029 10.754    0.319803 0.849936 0.41873    0 0
  v -0.635937 -3.19707 0.153961    -0.138077 -0.836812 0.529793    0 0
  v -0.109193 -0.548953 0.903961    -0.157252 -0.953022 0.258883    0 0
  v -0.511079 -2.56937 10.754    0.147843 0.895995 0.41873    0 0
  v 5.9969e-007 -3.25971 0.153961    0.0278293 -0.84767 0.529793    0 0
  v 3.63648e-007 -0.559707 0.903961    0.0316931 -0.965389 0.25888    0 0
  v 5.43739e-007 -2.61971 10.754    -0.0297975 0.907622 0.418731    0 0
  v 0.635938 -3.19707 0.153961    0.192667 -0.825953 0.529792    0 0
  v 0.109194 -0.548953 0.903961    0.219424 -0.940656 0.258879    0 0
  v 0.51108 -2.56937 10.754    -0.206294 0.884369 0.41873    0 0
  v 1.24744 -3.01158 0.153961    0.350101 -0.772497 0.529791    0 0
  v 0.214191 -0.517102 0.903961    0.398722 -0.879774 0.258879    0 0
  v 1.00252 -2.42029 10.754    -0.374861 0.827129 0.418731    0 0
  v 1.811 -2.71035 0.153961    0.49408 -0.689351 0.529792    0 0
  v 0.310957 -0.465379 0.903961    0.562695 -0.785084 0.258878    0 0
  v 1.45543 -2.17821 10.754    -0.529023 0.738105 0.418731    0 0
  v 2.30496 -2.30496 0.153961    0.619073 -0.579716 0.529791    0 0
  v 0.395773 -0.395772 0.903961    0.705045 -0.660223 0.258878    0 0
  v 1.85241 -1.85241 10.754    -0.662856 0.620715 0.41873    0 0
  v 2.71035 -1.811 0.153961    0.720275 -0.447802 0.52979    0 0
  v 0.46538 -0.310956 0.903961    0.8203 -0.509989 0.258881    0 0
  v 2.17821 -1.45543 10.754    -0.771215 0.479472 0.41873    0 0
  v 3.01158 -1.24743 0.153961    0.793796 -0.298678 0.529792    0 0
  v 0.517102 -0.21419 0.903961    0.904032 -0.340157 0.258881    0 0
  v 2.42029 -1.00252 10.754    -0.849935 0.319802 0.418733    0 0
  v 3.19707 -0.635937 0.153961    0.836813 -0.138078 0.529791    0 0
  v 0.548953 -0.109193 0.903961    0.953023 -0.157252 0.258881    0 0
  v 2.56937 -0.51108 10.754    -0.895994 0.147843 0.418734    0 0
  v 3.25971 0 0.153961    0.847671 0.0278294 0.529792    0 0
  v 0.559707 0 0.903961    0.965389 0.0316939 0.258881    0 0
  v 2.61971 0 10.754    -0.907621 -0.0297976 0.418732    0 0
  v 3.19707 0.635938 0.153961    0.825954 0.192667 0.529791    0 0
  v 0.548953 0.109194 0.903961    0.940656 0.219423 0.258881    0 0
  v 2.56937 0.51108 10.754    -0.884367 -0.206293 0.418733    0 0
  v 3.01158 1.24744 0.153961    0.772496 0.350101 0.529792    0 0
  v 0.517102 0.214191 0.903961    0.879775 0.398721 0.258879    0 0
  v 2.42029 1.00252 10.754    -0.82713 -0.374861 0.418731    0 0
  v 2.71035 1.811 0.153961    0.689351 0.49408 0.529792    0 0
  v 0.46538 0.310957 0.903961    0.785084 0.562695 0.258879    0 0
  v 2.17821 1.45543 10.754    -0.738105 -0.529023 0.418731    0 0
  v 2.30496 2.30496 0.153961    0.579715 0.619072 0.529792    0 0
  v 0.395773 0.395773 0.903961    0.660222 0.705044 0.25888    0 0
  v 1.85241 1.85241 10.754    -0.620715 -0.662855 0.418731    0 0
  v 1.811 2.71035 0.153961    0.447801 0.720274 0.529792    0 0
  v 0.310957 0.46538 0.903961    0.509989 0.8203 0.258881    0 0
  v 1.45543 2.17821 10.754    -0.479471 -0.771214 0.418731    0 0
  v 1.24744 3.01158 0.153961    0.298678 0.793795 0.529793    0 0
  v 0.214191 0.517102 0.903961    0.340156 0.904032 0.258881    0 0
  v 1.00252 2.42029 10.754    -0.319802 -0.849935 0.418732    0 0
  v 0.635937 3.19707 0.153961    0.138077 0.836812 0.529793    0 0
  v 0.109194 0.548952 0.903961    0.157253 0.953023 0.258879    0 0
  v 0.51108 2.56937 10.754    -0.147843 -0.895994 0.418733    0 0
  t 0 82 1
  t 0 81 82
  t 1 83 2
  t 1 82 83
  t 2 84 3
  t 2 83 84
  t 3 85 4
  t 3 84 85
  t 4 86 5
  t 4 85 86
  t 5 87 6
  t 5 86 87
  t 6 88 7
  t 6 87 88
  t 7 89 8
  t 7 88 89
  t 8 90 9
  t 8 89 90
  t 9 91 10
  t 9 90 91
  t 10 92 11
  t 10 91 92
  t 11 93 12
  t 11 92 93
  t 12 94 13
  t 12 93 94
  t 13 95 14
  t 13 94 95
  t 14 96 15
  t 14 95 96
  t 15 97 16
  t 15 96 97
  t 16 98 17
  t 16 97 98
  t 17 99 18
  t 17 98 99
  t 2592 100 19
  t 2592 2595 100
  t 19 101 20
  t 19 100 101
  t 20 102 21
  t 20 101 102
  t 21 103 22
  t 21 102 103
  t 22 104 23
  t 22 103 104
  t 23 105 24
  t 23 104 105
  t 2593 106 25
  t 2593 2596 106
  t 25 107 26
  t 25 106 107
  t 26 108 27
  t 26 107 108
  t 27 109 28
  t 27 108 109
  t 28 110 29
  t 28 109 110
  t 29 111 30
  t 29 110 111
  t 30 112 31
  t 30 111 112
  t 31 113 32
  t 31 112 113
  t 32 114 33
  t 32 113 114
  t 33 115 34
  t 33 114 115
  t 34 116 35
  t 34 115 116
  t 35 117 36
  t 35 116 117
  t 36 118 37
  t 36 117 118
  t 37 119 38
  t 37 118 119
  t 38 120 39
  t 38 119 120
  t 39 121 40
  t 39 120 121
  t 40 122 41
  t 40 121 122
  t 41 123 42
  t 41 122 123
  t 42 124 43
  t 42 123 124
  t 43 125 44
  t 43 124 125
  t 44 126 45
  t 44 125 126
  t 45 127 46
  t 45 126 127
  t 46 128 47
  t 46 127 128
  t 47 129 48
  t 47 128 129
  t 48 130 49
  t 48 129 130
  t 49 131 50
  t 49 130 131
  t 50 132 51
  t 50 131 132
  t 51 133 52
  t 51 132 133
  t 52 134 53
  t 52 133 134
  t 53 135 54
  t 53 134 135
  t 54 136 55
  t 54 135 136
  t 55 137 56
  t 55 136 137
  t 56 138 57
  t 56 137 138
  t 57 139 58
  t 57 138 139
  t 58 140 59
  t 58 139 140
  t 59 141 60
  t 59 140 141
  t 60 142 61
  t 60 141 142
  t 61 143 62
  t 61 142 143
  t 62 144 63
  t 62 143 144
  t 63 145 64
  t 63 144 145
  t 64 146 65
  t 64 145 146
  t 65 147 66
  t 65 146 147
  t 66 148 67
  t 66 147 148
  t 67 149 68
  t 67 148 149
  t 2594 150 69
  t 2594 2597 150
  t 69 151 70
  t 69 150 151
  t 70 152 71
  t 70 151 152
  t 71 153 72
  t 71 152 153
  t 72 154 73
  t 72 153 154
  t 73 155 74
  t 73 154 155
  t 74 156 75
  t 74 155 156
  t 75 157 76
  t 75 156 157
  t 76 158 77
  t 76 157 158
  t 77 159 78
  t 77 158 159
  t 78 160 79
  t 78 159 160
  t 79 161 80
  t 79 160 161
  t 81 163 82
  t 81 162 163
  t 82 164 83
  t 82 163 164
  t 83 165 84
  t 83 164 165
  t 84 166 85
  t 84 165 166
  t 85 167 86
  t 85 166 167
  t 86 168 87
  t 86 167 168
  t 87 169 88
  t 87 168 169
  t 88 170 89
  t 88 169 170
  t 89 171 90
  t 89 170 171
  t 90 172 91
  t 90 171 172
  t 91 173 92
  t 91 172 173
  t 92 174 93
  t 92 173 174
  t 93 175 94
  t 93 174 175
  t 94 176 95
  t 94 175 176
  t 95 177 96
  t 95 176 177
  t 96 178 97
  t 96 177 178
  t 97 179 98
  t 97 178 179
  t 98 180 99
  t 98 179 180
  t 2595 181 100
  t 2595 2598 181
  t 100 182 101
  t 100 181 182
  t 101 183 102
  t 101 182 183
  t 102 184 103
  t 102 183 184
  t 103 185 104
  t 103 184 185
  t 104 186 105
  t 104 185 186
  t 2596 187 106
  t 2596 2599 187
  t 106 188 107
  t 106 187 188
  t 107 189 108
  t 107 188 189
  t 108 190 109
  t 108 189 190
  t 109 191 110
  t 109 190 191
  t 110 192 111
  t 110 191 192
  t 111 193 112
  t 111 192 193
  t 112 194 113
  t 112 193 194
  t 113 195 114
  t 113 194 195
  t 114 196 115
  t 114 195 196
  t 115 197 116
  t 115 196 197
  t 116 198 117
  t 116 197 198
  t 117 199 118
  t 117 198 199
  t 118 200 119
  t 118 199 200
  t 119 201 120
  t 119 200 201
  t 120 202 121
  t 120 201 202
  t 121 203 122
  t 121 202 203
  t 122 204 123
  t 122 203 204
  t 123 205 124
  t 123 204 205
  t 124 206 125
  t 124 205 206
  t 125 207 126
  t 125 206 207
  t 126 208 127
  t 126 207 208
  t 127 209 128
  t 127 208 209
  t 128 210 129
  t 128 209 210
  t 129 211 130
  t 129 210 211
  t 130 212 131
  t 130 211 212
  t 131 213 132
  t 131 212 213
  t 132 214 133
  t 132 213 214
  t 133 215 134
  t 133 214 215
  t 134 216 135
  t 134 215 216
  t 135 217 136
  t 135 216 217
  t 136 218 137
  t 136 217 218
  t 137 219 138
  t 137 218 219
  t 138 220 139
  t 138 219 220
  t 139 221 140
  t 139 220 221
  t 140 222 141
  t 140 221 222
  t 141 223 142
  t 141 222 223
  t 142 224 143
  t 142 223 224
  t 143 225 144
  t 143 224 225
  t 144 226 145
  t 144 225 226
  t 145 227 146
  t 145 226 227
  t 146 228 147
  t 146 227 228
  t 147 229 148
  t 147 228 229
  t 148 230 149
  t 148 229 230
  t 2597 231 150
  t 2597 2600 231
  t 150 232 151
  t 150 231 232
  t 151 233 152
  t 151 232 233
  t 152 234 153
  t 152 233 234
  t 153 235 154
  t 153 234 235
  t 154 236 155
  t 154 235 236
  t 155 237 156
  t 155 236 237
  t 156 238 157
  t 156 237 238
  t 157 239 158
  t 157 238 239
  t 158 240 159
  t 158 239 240
  t 159 241 160
  t 159 240 241
  t 160 242 161
  t 160 241 242
  t 162 244 163
  t 162 243 244
  t 163 245 164
  t 163 244 245
  t 164 246 165
  t 164 245 246
  t 165 247 166
  t 165 246 247
  t 166 248 167
  t 166 247 248
  t 167 249 168
  t 167 248 249
  t 168 250 169
  t 168 249 250
  t 169 251 170
  t 169 250 251
  t 170 252 171
  t 170 251 252
  t 171 253 172
  t 171 252 253
  t 172 254 173
  t 172 253 254
  t 173 255 174
  t 173 254 255
  t 174 256 175
  t 174 255 256
  t 175 257 176
  t 175 256 257
  t 176 258 177
  t 176 257 258
  t 177 259 178
  t 177 258 259
  t 178 260 179
  t 178 259 260
  t 179 261 180
  t 179 260 261
  t 2598 262 181
  t 2598 2601 262
  t 181 263 182
  t 181 262 263
  t 182 264 183
  t 182 263 264
  t 183 265 184
  t 183 264 265
  t 184 266 185
  t 184 265 266
  t 185 267 186
  t 185 266 267
  t 2599 268 187
  t 2599 2602 268
  t 187 269 188
  t 187 268 269
  t 188 270 189
  t 188 269 270
  t 189 271 190
  t 189 270 271
  t 190 272 191
  t 190 271 272
  t 191 273 192
  t 191 272 273
  t 192 274 193
  t 192 273 274
  t 193 275 194
  t 193 274 275
  t 194 276 195
  t 194 275 276
  t 195 277 196
  t 195 276 277
  t 196 278 197
  t 196 277 278
  t 197 279 198
  t 197 278 279
  t 198 280 199
  t 198 279 280
  t 199 281 200
  t 199 280 281
  t 200 282 201
  t 200 281 282
  t 201 283 202
  t 201 282 283
  t 202 284 203
  t 202 283 284
  t 203 285 204
  t 203 284 285
  t 204 286 205
  t 204 285 286
  t 205 287 206
  t 205 286 287
  t 206 288 207
  t 206 287 288
  t 207 289 208
  t 207 288 289
  t 208 290 209
  t 208 289 290
  t 209 291 210
  t 209 290 291
  t 210 292 211
  t 210 291 292
  t 211 293 212
  t 211 292 293
  t 212 294 213
  t 212 293 294
  t 213 295 214
  t 213 294 295
  t 214 296 215
  t 214 295 296
  t 215 297 216
  t 215 296 297
  t 216 298 217
  t 216 297 298
  t 217 299 218
  t 217 298 299
  t 218 300 219
  t 218 299 300
  t 219 301 220
  t 219 300 301
  t 220 302 221
  t 220 301 302
  t 221 303 222
  t 221 302 303
  t 222 304 223
  t 222 303 304
  t 223 305 224
  t 223 304 305
  t 224 306 225
  t 224 305 306
  t 225 307 226
  t 225 306 307
  t 226 308 227
  t 226 307 308
  t 227 309 228
  t 227 308 309
  t 228 310 229
  t 228 309 310
  t 229 311 230
  t 229 310 311
  t 2600 312 231
  t 2600 2603 312
  t 231 313 232
  t 231 312 313
  t 232 314 233
  t 232 313 314
  t 233 315 234
  t 233 314 315
  t 234 316 235
  t 234 315 316
  t 235 317 236
  t 235 316 317
  t 236 318 237
  t 236 317 318
  t 237 319 238
  t 237 318 319
  t 238 320 239
  t 238 319 320
  t 239 321 240
  t 239 320 321
  t 240 322 241
  t 240 321 322
  t 241 323 242
  t 241 322 323
  t 243 325 244
  t 243 324 325
  t 244 326 245
  t 244 325 326
  t 245 327 246
  t 245 326 327
  t 246 328 247
  t 246 327 328
  t 247 329 248
  t 247 328 329
  t 248 330 249
  t 248 329 330
  t 249 331 250
  t 249 330 331
  t 250 332 251
  t 250 331 332
  t 251 333 252
  t 251 332 333
  t 252 334 253
  t 252 333 334
  t 253 335 254
  t 253 334 335
  t 254 336 255
  t 254 335 336
  t 255 337 256
  t 255 336 337
  t 256 338 257
  t 256 337 338
  t 257 339 258
  t 257 338 339
  t 258 340 259
  t 258 339 340
  t 259 341 260
  t 259 340 341
  t 260 342 261
  t 260 341 342
  t 2601 343 262
  t 2601 2604 343
  t 262 344 263
  t 262 343 344
  t 263 345 264
  t 263 344 345
  t 264 346 265
  t 264 345 346
  t 265 347 266
  t 265 346 347
  t 266 348 267
  t 266 347 348
  t 2602 349 268
  t 2602 2605 349
  t 268 350 269
  t 268 349 350
  t 269 351 270
  t 269 350 351
  t 270 352 271
  t 270 351 352
  t 271 353 272
  t 271 352 353
  t 272 354 273
  t 272 353 354
  t 273 355 274
  t 273 354 355
  t 274 356 275
  t 274 355 356
  t 275 357 276
  t 275 356 357
  t 276 358 277
  t 276 357 358
  t 277 359 278
  t 277 358 359
  t 278 360 279
  t 278 359 360
  t 279 361 280
  t 279 360 361
  t 280 362 281
  t 280 361 362
  t 281 363 282
  t 281 362 363
  t 282 364 283
  t 282 363 364
  t 283 365 284
  t 283 364 365
  t 284 366 285
  t 284 365 366
  t 285 367 286
  t 285 366 367
  t 286 368 287
  t 286 367 368
  t 287 369 288
  t 287 368 369
  t 288 370 289
  t 288 369 370
  t 289 371 290
  t 289 370 371
  t 290 372 291
  t 290 371 372
  t 291 373 292
  t 291 372 373
  t 292 374 293
  t 292 373 374
  t 293 375 294
  t 293 374 375
  t 294 376 295
  t 294 375 376
  t 295 377 296
  t 295 376 377
  t 296 378 297
  t 296 377 378
  t 297 379 298
  t 297 378 379
  t 298 380 299
  t 298 379 380
  t 299 381 300
  t 299 380 381
  t 300 382 301
  t 300 381 382
  t 301 383 302
  t 301 382 383
  t 302 384 303
  t 302 383 384
  t 303 385 304
  t 303 384 385
  t 304 386 305
  t 304 385 386
  t 305 387 306
  t 305 386 387
  t 306 388 307
  t 306 387 388
  t 307 389 308
  t 307 388 389
  t 308 390 309
  t 308 389 390
  t 309 391 310
  t 309 390 391
  t 310 392 311
  t 310 391 392
  t 2603 393 312
  t 2603 2606 393
  t 312 394 313
  t 312 393 394
  t 313 395 314
  t 313 394 395
  t 314 396 315
  t 314 395 396
  t 315 397 316
  t 315 396 397
  t 316 398 317
  t 316 397 398
  t 317 399 318
  t 317 398 399
  t 318 400 319
  t 318 399 400
  t 319 401 320
  t 319 400 401
  t 320 402 321
  t 320 401 402
  t 321 403 322
  t 321 402 403
  t 322 404 323
  t 322 403 404
  t 324 406 325
  t 324 405 406
  t 325 407 326
  t 325 406 407
  t 326 408 327
  t 326 407 408
  t 327 409 328
  t 327 408 409
  t 328 410 329
  t 328 409 410
  t 329 411 330
  t 329 410 411
  t 330 412 331
  t 330 411 412
  t 331 413 332
  t 331 412 413
  t 332 414 333
  t 332 413 414
  t 333 415 334
  t 333 414 415
  t 334 416 335
  t 334 415 416
  t 335 417 336
  t 335 416 417
  t 336 418 337
  t 336 417 418
  t 337 419 338
  t 337 418 419
  t 338 420 339
  t 338 419 420
  t 339 421 340
  t 339 420 421
  t 340 422 341
  t 340 421 422
  t 341 423 342
  t 341 422 423
  t 2604 424 343
  t 2604 2607 424
  t 343 425 344
  t 343 424 425
  t 344 426 345
  t 344 425 426
  t 345 427 346
  t 345 426 427
  t 346 428 347
  t 346 427 428
  t 347 429 348
  t 347 428 429
  t 2605 430 349
  t 2605 2608 430
  t 349 431 350
  t 349 430 431
  t 350 432 351
  t 350 431 432
  t 351 433 352
  t 351 432 433
  t 352 434 353
  t 352 433 434
  t 353 435 354
  t 353 434 435
  t 354 436 355
  t 354 435 436
  t 355 437 356
  t 355 436 437
  t 356 438 357
  t 356 437 438
  t 357 439 358
  t 357 438 439
  t 358 440 359
  t 358 439 440
  t 359 441 360
  t 359 440 441
  t 360 442 361
  t 360 441 442
  t 361 443 362
  t 361 442 443
  t 362 444 363
  t 362 443 444
  t 363 445 364
  t 363 444 445
  t 364 446 365
  t 364 445 446
  t 365 447 366
  t 365 446 447
  t 366 448 367
  t 366 447 448
  t 367 449 368
  t 367 448 449
  t 368 450 369
  t 368 449 450
  t 369 451 370
  t 369 450 451
  t 370 452 371
  t 370 451 452
  t 371 453 372
  t 371 452 453
  t 372 454 373
  t 372 453 454
  t 373 455 374
  t 373 454 455
  t 374 456 375
  t 374 455 456
  t 375 457 376
  t 375 456 457
  t 376 458 377
  t 376 457 458
  t 377 459 378
  t 377 458 459
  t 378 460 379
  t 378 459 460
  t 379 461 380
  t 379 460 461
  t 380 462 381
  t 380 461 462
  t 381 463 382
  t 381 462 463
  t 382 464 383
  t 382 463 464
  t 383 465 384
  t 383 464 465
  t 384 466 385
  t 384 465 466
  t 385 467 386
  t 385 466 467
  t 386 468 387
  t 386 467 468
  t 387 469 388
  t 387 468 469
  t 388 470 389
  t 388 469 470
  t 389 471 390
  t 389 470 471
  t 390 472 391
  t 390 471 472
  t 391 473 392
  t 391 472 473
  t 2606 474 393
  t 2606 2609 474
  t 393 475 394
  t 393 474 475
  t 394 476 395
  t 394 475 476
  t 395 477 396
  t 395 476 477
  t 396 478 397
  t 396 477 478
  t 397 479 398
  t 397 478 479
  t 398 480 399
  t 398 479 480
  t 399 481 400
  t 399 480 481
  t 400 482 401
  t 400 481 482
  t 401 483 402
  t 401 482 483
  t 402 484 403
  t 402 483 484
  t 403 485 404
  t 403 484 485
  t 405 487 406
  t 405 486 487
  t 406 488 407
  t 406 487 488
  t 407 489 408
  t 407 488 489
  t 408 490 409
  t 408 489 490
  t 409 491 410
  t 409 490 491
  t 410 492 411
  t 410 491 492
  t 411 493 412
  t 411 492 493
  t 412 494 413
  t 412 493 494
  t 413 495 414
  t 413 494 495
  t 414 496 415
  t 414 495 496
  t 415 497 416
  t 415 496 497
  t 416 498 417
  t 416 497 498
  t 417 499 418
  t 417 498 499
  t 418 500 419
  t 418 499 500
  t 419 501 420
  t 419 500 501
  t 420 502 421
  t 420 501 502
  t 421 503 422
  t 421 502 503
  t 422 504 423
  t 422 503 504
  t 2607 505 424
  t 2607 2610 505
  t 424 506 425
  t 424 505 506
  t 425 507 426
  t 425 506 507
  t 426 508 427
  t 426 507 508
  t 427 509 428
  t 427 508 509
  t 428 510 429
  t 428 509 510
  t 2608 511 430
  t 2608 2611 511
  t 430 512 431
  t 430 511 512
  t 431 513 432
  t 431 512 513
  t 432 514 433
  t 432 513 514
  t 433 515 434
  t 433 514 515
  t 434 516 435
  t 434 515 516
  t 435 517 436
  t 435 516 517
  t 436 518 437
  t 436 517 518
  t 437 519 438
  t 437 518 519
  t 438 520 439
  t 438 519 520
  t 439 521 440
  t 439 520 521
  t 440 522 441
  t 440 521 522
  t 441 523 442
  t 441 522 523
  t 442 524 443
  t 442 523 524
  t 443 525 444
  t 443 524 525
  t 444 526 445
  t 444 525 526
  t 445 527 446
  t 445 526 527
  t 446 528 447
  t 446 527 528
  t 447 529 448
  t 447 528 529
  t 448 530 449
  t 448 529 530
  t 449 531 450
  t 449 530 531
  t 450 532 451
  t 450 531 532
  t 451 533 452
  t 451 532 533
  t 452 534 453
  t 452 533 534
  t 453 535 454
  t 453 534 535
  t 454 536 455
  t 454 535 536
  t 455 537 456
  t 455 536 537
  t 456 538 457
  t 456 537 538
  t 457 539 458
  t 457 538 539
  t 458 540 459
  t 458 539 540
  t 459 541 460
  t 459 540 541
  t 460 542 461
  t 460 541 542
  t 461 543 462
  t 461 542 543
  t 462 544 463
  t 462 543 544
  t 463 545 464
  t 463 544 545
  t 464 546 465
  t 464 545 546
  t 465 547 466
  t 465 546 547
  t 466 548 467
  t 466 547 548
  t 467 549 468
  t 467 548 549
  t 468 550 469
  t 468 549 550
  t 469 551 470
  t 469 550 551
  t 470 552 471
  t 470 551 552
  t 471 553 472
  t 471 552 553
  t 472 554 473
  t 472 553 554
  t 2609 555 474
  t 2609 2612 555
  t 474 556 475
  t 474 555 556
  t 475 557 476
  t 475 556 557
  t 476 558 477
  t 476 557 558
  t 477 559 478
  t 477 558 559
  t 478 560 479
  t 478 559 560
  t 479 561 480
  t 479 560 561
  t 480 562 481
  t 480 561 562
  t 481 563 482
  t 481 562 563
  t 482 564 483
  t 482 563 564
  t 483 565 484
  t 483 564 565
  t 484 566 485
  t 484 565 566
  t 486 568 487
  t 486 567 568
  t 487 569 488
  t 487 568 569
  t 488 570 489
  t 488 569 570
  t 489 571 490
  t 489 570 571
  t 490 572 491
  t 490 571 572
  t 491 573 492
  t 491 572 573
  t 492 574 493
  t 492 573 574
  t 493 575 494
  t 493 574 575
  t 494 576 495
  t 494 575 576
  t 495 577 496
  t 495 576 577
  t 496 578 497
  t 496 577 578
  t 497 579 498
  t 497 578 579
  t 498 580 499
  t 498 579 580
  t 499 581 500
  t 499 580 581
  t 500 582 501
  t 500 581 582
  t 501 583 502
  t 501 582 583
  t 502 584 503
  t 502 583 584
  t 503 585 504
  t 503 584 585
  t 2610 586 505
  t 2610 2613 586
  t 505 587 506
  t 505 586 587
  t 506 588 507
  t 506 587 588
  t 507 589 508
  t 507 588 589
  t 508 590 509
  t 508 589 590
  t 509 591 510
  t 509 590 591
  t 2611 592 511
  t 2611 2614 592
  t 511 593 512
  t 511 592 593
  t 512 594 513
  t 512 593 594
  t 513 595 514
  t 513 594 595
  t 514 596 515
  t 514 595 596
  t 515 597 516
  t 515 596 597
  t 516 598 517
  t 516 597 598
  t 517 599 518
  t 517 598 599
  t 518 600 519
  t 518 599 600
  t 519 601 520
  t 519 600 601
  t 520 602 521
  t 520 601 602
  t 521 603 522
  t 521 602 603
  t 522 604 523
  t 522 603 604
  t 523 605 524
  t 523 604 605
  t 524 606 525
  t 524 605 606
  t 525 607 526
  t 525 606 607
  t 526 608 527
  t 526 607 608
  t 527 609 528
  t 527 608 609
  t 528 610 529
  t 528 609 610
  t 529 611 530
  t 529 610 611
  t 530 612 531
  t 530 611 612
  t 531 613 532
  t 531 612 613
  t 532 614 533
  t 532 613 614
  t 533 615 534
  t 533 614 615
  t 534 616 535
  t 534 615 616
  t 535 617 536
  t 535 616 617
  t 536 618 537
  t 536 617 618
  t 537 619 538
  t 537 618 619
  t 538 620 539
  t 538 619 620
  t 539 621 540
  t 539 620 621
  t 540 622 541
  t 540 621 622
  t 541 623 542
  t 541 622 623
  t 542 624 543
  t 542 623 624
  t 543 625 544
  t 543 624 625
  t 544 626 545
  t 544 625 626
  t 545 627 546
  t 545 626 627
  t 546 628 547
  t 546 627 628
  t 547 629 548
  t 547 628 629
  t 548 630 549
  t 548 629 630
  t 549 631 550
  t 549 630 631
  t 550 632 551
  t 550 631 632
  t 551 633 552
  t 551 632 633
  t 552 634 553
  t 552 633 634
  t 553 635 554
  t 553 634 635
  t 2612 636 555
  t 2612 2615 636
  t 555 637 556
  t 555 636 637
  t 556 638 557
  t 556 637 638
  t 557 639 558
  t 557 638 639
  t 558 640 559
  t 558 639 640
  t 559 641 560
  t 559 640 641
  t 560 642 561
  t 560 641 642
  t 561 643 562
  t 561 642 643
  t 562 644 563
  t 562 643 644
  t 563 645 564
  t 563 644 645
  t 564 646 565
  t 564 645 646
  t 565 647 566
  t 565 646 647
  t 567 649 568
  t 567 648 649
  t 568 650 569
  t 568 649 650
  t 569 651 570
  t 569 650 651
  t 570 652 571
  t 570 651 652
  t 571 653 572
  t 571 652 653
  t 572 654 573
  t 572 653 654
  t 573 655 574
  t 573 654 655
  t 574 656 575
  t 574 655 656
  t 575 657 576
  t 575 656 657
  t 576 658 577
  t 576 657 658
  t 577 659 578
  t 577 658 659
  t 578 660 579
  t 578 659 660
  t 579 661 580
  t 579 660 661
  t 580 662 581
  t 580 661 662
  t 581 663 582
  t 581 662 663
  t 582 664 583
  t 582 663 664
  t 583 665 584
  t 583 664 665
  t 584 666 585
  t 584 665 666
  t 2613 667 586
  t 2613 2616 667
  t 586 668 587
  t 586 667 668
  t 587 669 588
  t 587 668 669
  t 588 670 589
  t 588 669 670
  t 589 671 590
  t 589 670 671
  t 590 672 591
  t 590 671 672
  t 2614 673 592
  t 2614 2617 673
  t 592 674 593
  t 592 673 674
  t 593 675 594
  t 593 674 675
  t 594 676 595
  t 594 675 676
  t 595 677 596
  t 595 676 677
  t 596 678 597
  t 596 677 678
  t 597 679 598
  t 597 678 679
  t 598 680 599
  t 598 679 680
  t 599 681 600
  t 599 680 681
  t 600 682 601
  t 600 681 682
  t 601 683 602
  t 601 682 683
  t 602 684 603
  t 602 683 684
  t 603 685 604
  t 603 684 685
  t 604 686 605
  t 604 685 686
  t 605 687 606
  t 605 686 687
  t 606 688 607
  t 606 687 688
  t 607 689 608
  t 607 688 689
  t 608 690 609
  t 608 689 690
  t 609 691 610
  t 609 690 691
  t 610 692 611
  t 610 691 692
  t 611 693 612
  t 611 692 693
  t 612 694 613
  t 612 693 694
  t 613 695 614
  t 613 694 695
  t 614 696 615
  t 614 695 696
  t 615 697 616
  t 615 696 697
  t 616 698 617
  t 616 697 698
  t 617 699 618
  t 617 698 699
  t 618 700 619
  t 618 699 700
  t 619 701 620
  t 619 700 701
  t 620 702 621
  t 620 701 702
  t 621 703 622
  t 621 702 703
  t 622 704 623
  t 622 703 704
  t 623 705 624
  t 623 704 705
  t 624 706 625
  t 624 705 706
  t 625 707 626
  t 625 706 707
  t 626 708 627
  t 626 707 708
  t 627 709 628
  t 627 708 709
  t 628 710 629
  t 628 709 710
  t 629 711 630
  t 629 710 711
  t 630 712 631
  t 630 711 712
  t 631 713 632
  t 631 712 713
  t 632 714 633
  t 632 713 714
  t 633 715 634
  t 633 714 715
  t 634 716 635
  t 634 715 716
  t 2615 717 636
  t 2615 2618 717
  t 636 718 637
  t 636 717 718
  t 637 719 638
  t 637 718 719
  t 638 720 639
  t 638 719 720
  t 639 721 640
  t 639 720 721
  t 640 722 641
  t 640 721 722
  t 641 723 642
  t 641 722 723
  t 642 724 643
  t 642 723 724
  t 643 725 644
  t 643 724 725
  t 644 726 645
  t 644 725 726
  t 645 727 646
  t 645 726 727
  t 646 728 647
  t 646 727 728
  t 648 730 649
  t 648 729 730
  t 649 731 650
  t 649 730 731
  t 650 732 651
  t 650 731 732
  t 651 733 652
  t 651 732 733
  t 652 734 653
  t 652 733 734
  t 653 735 654
  t 653 734 735
  t 654 736 655
  t 654 735 736
  t 655 737 656
  t 655 736 737
  t 656 738 657
  t 656 737 738
  t 657 739 658
  t 657 738 739
  t 658 740 659
  t 658 739 740
  t 659 741 660
  t 659 740 741
  t 660 742 661
  t 660 741 742
  t 661 743 662
  t 661 742 743
  t 662 744 663
  t 662 743 744
  t 663 745 664
  t 663 744 745
  t 664 746 665
  t 664 745 746
  t 665 747 666
  t 665 746 747
  t 2616 748 667
  t 2616 2619 748
  t 667 749 668
  t 667 748 749
  t 668 750 669
  t 668 749 750
  t 669 751 670
  t 669 750 751
  t 670 752 671
  t 670 751 752
  t 671 753 672
  t 671 752 753
  t 2617 754 673
  t 2617 2620 754
  t 673 755 674
  t 673 754 755
  t 674 756 675
  t 674 755 756
  t 675 757 676
  t 675 756 757
  t 676 758 677
  t 676 757 758
  t 677 759 678
  t 677 758 759
  t 678 760 679
  t 678 759 760
  t 679 761 680
  t 679 760 761
  t 680 762 681
  t 680 761 762
  t 681 763 682
  t 681 762 763
  t 682 764 683
  t 682 763 764
  t 683 765 684
  t 683 764 765
  t 684 766 685
  t 684 765 766
  t 685 767 686
  t 685 766 767
  t 686 768 687
  t 686 767 768
  t 687 769 688
  t 687 768 769
  t 688 770 689
  t 688 769 770
  t 689 771 690
  t 689 770 771
  t 690 772 691
  t 690 771 772
  t 691 773 692
  t 691 772 773
  t 692 774 693
  t 692 773 774
  t 693 775 694
  t 693 774 775
  t 694 776 695
  t 694 775 776
  t 695 777 696
  t 695 776 777
  t 696 778 697
  t 696 777 778
  t 697 779 698
  t 697 778 779
  t 698 780 699
  t 698 779 780
  t 699 781 700
  t 699 780 781
  t 700 782 701
  t 700 781 782
  t 701 783 702
  t 701 782 783
  t 702 784 703
  t 702 783 784
  t 703 785 704
  t 703 784 785
  t 704 786 705
  t 704 785 786
  t 705 787 706
  t 705 786 787
  t 706 788 707
  t 706 787 788
  t 707 789 708
  t 707 788 789
  t 708 790 709
  t 708 789 790
  t 709 791 710
  t 709 790 791
  t 710 792 711
  t 710 791 792
  t 711 793 712
  t 711 792 793
  t 712 794 713
  t 712 793 794
  t 713 795 714
  t 713 794 795
  t 714 796 715
  t 714 795 796
  t 715 797 716
  t 715 796 797
  t 2618 798 717
  t 2618 2621 798
  t 717 799 718
  t 717 798 799
  t 718 800 719
  t 718 799 800
  t 719 801 720
  t 719 800 801
  t 720 802 721
  t 720 801 802
  t 721 803 722
  t 721 802 803
  t 722 804 723
  t 722 803 804
  t 723 805 724
  t 723 804 805
  t 724 806 725
  t 724 805 806
  t 725 807 726
  t 725 806 807
  t 726 808 727
  t 726 807 808
  t 727 809 728
  t 727 808 809
  t 729 811 730
  t 729 810 811
  t 730 812 731
  t 730 811 812
  t 731 813 732
  t 731 812 813
  t 732 814 733
  t 732 813 814
  t 733 815 734
  t 733 814 815
  t 734 816 735
  t 734 815 816
  t 735 817 736
  t 735 816 817
  t 736 818 737
  t 736 817 818
  t 737 819 738
  t 737 818 819
  t 738 820 739
  t 738 819 820
  t 739 821 740
  t 739 820 821
  t 740 822 741
  t 740 821 822
  t 741 823 742
  t 741 822 823
  t 742 824 743
  t 742 823 824
  t 743 825 744
  t 743 824 825
  t 744 826 745
  t 744 825 826
  t 745 827 746
  t 745 826 827
  t 746 828 747
  t 746 827 828
  t 2619 829 748
  t 2619 2622 829
  t 748 830 749
  t 748 829 830
  t 749 831 750
  t 749 830 831
  t 750 832 751
  t 750 831 832
  t 751 833 752
  t 751 832 833
  t 752 834 753
  t 752 833 834
  t 2620 835 754
  t 2620 2623 835
  t 754 836 755
  t 754 835 836
  t 755 837 756
  t 755 836 837
  t 756 838 757
  t 756 837 838
  t 757 839 758
  t 757 838 839
  t 758 840 759
  t 758 839 840
  t 759 841 760
  t 759 840 841
  t 760 842 761
  t 760 841 842
  t 761 843 762
  t 761 842 843
  t 762 844 763
  t 762 843 844
  t 763 845 764
  t 763 844 845
  t 764 846 765
  t 764 845 846
  t 765 847 766
  t 765 846 847
  t 766 848 767
  t 766 847 848
  t 767 849 768
  t 767 848 849
  t 768 850 769
  t 768 849 850
  t 769 851 770
  t 769 850 851
  t 770 852 771
  t 770 851 852
  t 771 853 772
  t 771 852 853
  t 772 854 773
  t 772 853 854
  t 773 855 774
  t 773 854 855
  t 774 856 775
  t 774 855 856
  t 775 857 776
  t 775 856 857
  t 776 858 777
  t 776 857 858
  t 777 859 778
  t 777 858 859
  t 778 860 779
  t 778 859 860
  t 779 861 780
  t 779 860 861
  t 780 862 781
  t 780 861 862
  t 781 863 782
  t 781 862 863
  t 782 864 783
  t 782 863 864
  t 783 865 784
  t 783 864 865
  t 784 866 785
  t 784 865 866
  t 785 867 786
  t 785 866 867
  t 786 868 787
  t 786 867 868
  t 787 869 788
  t 787 868 869
  t 788 870 789
  t 788 869 870
  t 789 871 790
  t 789 870 871
  t 790 872 791
  t 790 871 872
  t 791 873 792
  t 791 872 873
  t 792 874 793
  t 792 873 874
  t 793 875 794
  t 793 874 875
  t 794 876 795
  t 794 875 876
  t 795 877 796
  t 795 876 877
  t 796 878 797
  t 796 877 878
  t 2621 879 798
  t 2621 2624 879
  t 798 880 799
  t 798 879 880
  t 799 881 800
  t 799 880 881
  t 800 882 801
  t 800 881 882
  t 801 883 802
  t 801 882 883
  t 802 884 803
  t 802 883 884
  t 803 885 804
  t 803 884 885
  t 804 886 805
  t 804 885 886
  t 805 887 806
  t 805 886 887
  t 806 888 807
  t 806 887 888
  t 807 889 808
  t 807 888 889
  t 808 890 809
  t 808 889 890
  t 810 892 811
  t 810 891 892
  t 811 893 812
  t 811 892 893
  t 812 894 813
  t 812 893 894
  t 813 895 814
  t 813 894 895
  t 814 896 815
  t 814 895 896
  t 815 897 816
  t 815 896 897
  t 816 898 817
  t 816 897 898
  t 817 899 818
  t 817 898 899
  t 818 900 819
  t 818 899 900
  t 819 901 820
  t 819 900 901
  t 820 902 821
  t 820 901 902
  t 821 903 822
  t 821 902 903
  t 822 904 823
  t 822 903 904
  t 823 905 824
  t 823 904 905
  t 824 906 825
  t 824 905 906
  t 825 907 826
  t 825 906 907
  t 826 908 827
  t 826 907 908
  t 827 909 828
  t 827 908 909
  t 2622 910 829
  t 2622 2625 910
  t 829 911 830
  t 829 910 911
  t 830 912 831
  t 830 911 912
  t 831 913 832
  t 831 912 913
  t 832 914 833
  t 832 913 914
  t 833 915 834
  t 833 914 915
  t 2623 916 835
  t 2623 2626 916
  t 835 917 836
  t 835 916 917
  t 836 918 837
  t 836 917 918
  t 837 919 838
  t 837 918 919
  t 838 920 839
  t 838 919 920
  t 839 921 840
  t 839 920 921
  t 840 922 841
  t 840 921 922
  t 841 923 842
  t 841 922 923
  t 842 924 843
  t 842 923 924
  t 843 925 844
  t 843 924 925
  t 844 926 845
  t 844 925 926
  t 845 927 846
  t 845 926 927
  t 846 928 847
  t 846 927 928
  t 847 929 848
  t 847 928 929
  t 848 930 849
  t 848 929 930
  t 849 931 850
  t 849 930 931
  t 850 932 851
  t 850 931 932
  t 851 933 852
  t 851 932 933
  t 852 934 853
  t 852 933 934
  t 853 935 854
  t 853 934 935
  t 854 936 855
  t 854 935 936
  t 855 937 856
  t 855 936 937
  t 856 938 857
  t 856 937 938
  t 857 939 858
  t 857 938 939
  t 858 940 859
  t 858 939 940
  t 859 941 860
  t 859 940 941
  t 860 942 861
  t 860 941 942
  t 861 943 862
  t 861 942 943
  t 862 944 863
  t 862 943 944
  t 863 945 864
  t 863 944 945
  t 864 946 865
  t 864 945 946
  t 865 947 866
  t 865 946 947
  t 866 948 867
  t 866 947 948
  t 867 949 868
  t 867 948 949
  t 868 950 869
  t 868 949 950
  t 869 951 870
  t 869 950 951
  t 870 952 871
  t 870 951 952
  t 871 953 872
  t 871 952 953
  t 872 954 873
  t 872 953 954
  t 873 955 874
  t 873 954 955
  t 874 956 875
  t 874 955 956
  t 875 957 876
  t 875 956 957
  t 876 958 877
  t 876 957 958
  t 877 959 878
  t 877 958 959
  t 2624 960 879
  t 2624 2627 960
  t 879 961 880
  t 879 960 961
  t 880 962 881
  t 880 961 962
  t 881 963 882
  t 881 962 963
  t 882 964 883
  t 882 963 964
  t 883 965 884
  t 883 964 965
  t 884 966 885
  t 884 965 966
  t 885 967 886
  t 885 966 967
  t 886 968 887
  t 886 967 968
  t 887 969 888
  t 887 968 969
  t 888 970 889
  t 888 969 970
  t 889 971 890
  t 889 970 971
  t 891 973 892
  t 891 972 973
  t 892 974 893
  t 892 973 974
  t 893 975 894
  t 893 974 975
  t 894 976 895
  t 894 975 976
  t 895 977 896
  t 895 976 977
  t 896 978 897
  t 896 977 978
  t 897 979 898
  t 897 978 979
  t 898 980 899
  t 898 979 980
  t 899 981 900
  t 899 980 981
  t 900 982 901
  t 900 981 982
  t 901 983 902
  t 901 982 983
  t 902 984 903
  t 902 983 984
  t 903 985 904
  t 903 984 985
  t 904 986 905
  t 904 985 986
  t 905 987 906
  t 905 986 987
  t 906 988 907
  t 906 987 988
  t 907 989 908
  t 907 988 989
  t 908 990 909
  t 908 989 990
  t 2625 991 910
  t 2625 2628 991
  t 910 992 911
  t 910 991 992
  t 911 993 912
  t 911 992 993
  t 912 994 913
  t 912 993 994
  t 913 995 914
  t 913 994 995
  t 914 996 915
  t 914 995 996
  t 2626 997 916
  t 2626 2629 997
  t 916 998 917
  t 916 997 998
  t 917 999 918
  t 917 998 999
  t 918 1000 919
  t 918 999 1000
  t 919 1001 920
  t 919 1000 1001
  t 920 1002 921
  t 920 1001 1002
  t 921 1003 922
  t 921 1002 1003
  t 922 1004 923
  t 922 1003 1004
  t 923 1005 924
  t 923 1004 1005
  t 924 1006 925
  t 924 1005 1006
  t 925 1007 926
  t 925 1006 1007
  t 926 1008 927
  t 926 1007 1008
  t 927 1009 928
  t 927 1008 1009
  t 928 1010 929
  t 928 1009 1010
  t 929 1011 930
  t 929 1010 1011
  t 930 1012 931
  t 930 1011 1012
  t 931 1013 932
  t 931 1012 1013
  t 932 1014 933
  t 932 1013 1014
  t 933 1015 934
  t 933 1014 1015
  t 934 1016 935
  t 934 1015 1016
  t 935 1017 936
  t 935 1016 1017
  t 936 1018 937
  t 936 1017 1018
  t 937 1019 938
  t 937 1018 1019
  t 938 1020 939
  t 938 1019 1020
  t 939 1021 940
  t 939 1020 1021
  t 940 1022 941
  t 940 1021 1022
  t 941 1023 942
  t 941 1022 1023
  t 942 1024 943
  t 942 1023 1024
  t 943 1025 944
  t 943 1024 1025
  t 944 1026 945
  t 944 1025 1026
  t 945 1027 946
  t 945 1026 1027
  t 946 1028 947
  t 946 1027 1028
  t 947 1029 948
  t 947 1028 1029
  t 948 1030 949
  t 948 1029 1030
  t 949 1031 950
  t 949 1030 1031
  t 950 1032 951
  t 950 1031 1032
  t 951 1033 952
  t 951 1032 1033
  t 952 1034 953
  t 952 1033 1034
  t 953 1035 954
  t 953 1034 1035
  t 954 1036 955
  t 954 1035 1036
  t 955 1037 956
  t 955 1036 1037
  t 956 1038 957
  t 956 1037 1038
  t 957 1039 958
  t 957 1038 1039
  t 958 1040 959
  t 958 1039 1040
  t 2627 1041 960
  t 2627 2630 1041
  t 960 1042 961
  t 960 1041 1042
  t 961 1043 962
  t 961 1042 1043
  t 962 1044 963
  t 962 1043 1044
  t 963 1045 964
  t 963 1044 1045
  t 964 1046 965
  t 964 1045 1046
  t 965 1047 966
  t 965 1046 1047
  t 966 1048 967
  t 966 1047 1048
  t 967 1049 968
  t 967 1048 1049
  t 968 1050 969
  t 968 1049 1050
  t 969 1051 970
  t 969 1050 1051
  t 970 1052 971
  t 970 1051 1052
  t 972 1054 973
  t 972 1053 1054
  t 973 1055 974
  t 973 1054 1055
  t 974 1056 975
  t 974 1055 1056
  t 975 1057 976
  t 975 1056 1057
  t 976 1058 977
  t 976 1057 1058
  t 977 1059 978
  t 977 1058 1059
  t 978 1060 979
  t 978 1059 1060
  t 979 1061 980
  t 979 1060 1061
  t 980 1062 981
  t 980 1061 1062
  t 981 1063 982
  t 981 1062 1063
  t 982 1064 983
  t 982 1063 1064
  t 983 1065 984
  t 983 1064 1065
  t 984 1066 985
  t 984 1065 1066
  t 985 1067 986
  t 985 1066 1067
  t 986 1068 987
  t 986 1067 1068
  t 987 1069 988
  t 987 1068 1069
  t 988 1070 989
  t 988 1069 1070
  t 989 1071 990
  t 989 1070 1071
  t 2628 1072 991
  t 2628 2631 1072
  t 991 1073 992
  t 991 1072 1073
  t 992 1074 993
  t 992 1073 1074
  t 993 1075 994
  t 993 1074 1075
  t 994 1076 995
  t 994 1075 1076
  t 995 1077 996
  t 995 1076 1077
  t 2629 1078 997
  t 2629 2632 1078
  t 997 1079 998
  t 997 1078 1079
  t 998 1080 999
  t 998 1079 1080
  t 999 1081 1000
  t 999 1080 1081
  t 1000 1082 1001
  t 1000 1081 1082
  t 1001 1083 1002
  t 1001 1082 1083
  t 1002 1084 1003
  t 1002 1083 1084
  t 1003 1085 1004
  t 1003 1084 1085
  t 1004 1086 1005
  t 1004 1085 1086
  t 1005 1087 1006
  t 1005 1086 1087
  t 1006 1088 1007
  t 1006 1087 1088
  t 1007 1089 1008
  t 1007 1088 1089
  t 1008 1090 1009
  t 1008 1089 1090
  t 1009 1091 1010
  t 1009 1090 1091
  t 1010 1092 1011
  t 1010 1091 1092
  t 1011 1093 1012
  t 1011 1092 1093
  t 1012 1094 1013
  t 1012 1093 1094
  t 1013 1095 1014
  t 1013 1094 1095
  t 1014 1096 1015
  t 1014 1095 1096
  t 1015 1097 1016
  t 1015 1096 1097
  t 1016 1098 1017
  t 1016 1097 1098
  t 1017 1099 1018
  t 1017 1098 1099
  t 1018 1100 1019
  t 1018 1099 1100
  t 1019 1101 1020
  t 1019 1100 1101
  t 1020 1102 1021
  t 1020 1101 1102
  t 1021 1103 1022
  t 1021 1102 1103
  t 1022 1104 1023
  t 1022 1103 1104
  t 1023 1105 1024
  t 1023 1104 1105
  t 1024 1106 1025
  t 1024 1105 1106
  t 1025 1107 1026
  t 1025 1106 1107
  t 1026 1108 1027
  t 1026 1107 1108
  t 1027 1109 1028
  t 1027 1108 1109
  t 1028 1110 1029
  t 1028 1109 1110
  t 1029 1111 1030
  t 1029 1110 1111
  t 1030 1112 1031
  t 1030 1111 1112
  t 1031 1113 1032
  t 1031 1112 1113
  t 1032 1114 1033
  t 1032 1113 1114
  t 1033 1115 1034
  t 1033 1114 1115
  t 1034 1116 1035
  t 1034 1115 1116
  t 1035 1117 1036
  t 1035 1116 1117
  t 1036 1118 1037
  t 1036 1117 1118
  t 1037 1119 1038
  t 1037 1118 1119
  t 1038 1120 1039
  t 1038 1119 1120
  t 1039 1121 1040
  t 1039 1120 1121
  t 2630 1122 1041
  t 2630 2633 1122
  t 1041 1123 1042
  t 1041 1122 1123
  t 1042 1124 1043
  t 1042 1123 1124
  t 1043 1125 1044
  t 1043 1124 1125
  t 1044 1126 1045
  t 1044 1125 1126
  t 1045 1127 1046
  t 1045 1126 1127
  t 1046 1128 1047
  t 1046 1127 1128
  t 1047 1129 1048
  t 1047 1128 1129
  t 1048 1130 1049
  t 1048 1129 1130
  t 1049 1131 1050
  t 1049 1130 1131
  t 1050 1132 1051
  t 1050 1131 1132
  t 1051 1133 1052
  t 1051 1132 1133
  t 1053 1135 1054
  t 1053 1134 1135
  t 1054 1136 1055
  t 1054 1135 1136
  t 1055 1137 1056
  t 1055 1136 1137
  t 1056 1138 1057
  t 1056 1137 1138
  t 1057 1139 1058
  t 1057 1138 1139
  t 1058 1140 1059
  t 1058 1139 1140
  t 1059 1141 1060
  t 1059 1140 1141
  t 1060 1142 1061
  t 1060 1141 1142
  t 1061 1143 1062
  t 1061 1142 1143
  t 1062 1144 1063
  t 1062 1143 1144
  t 1063 1145 1064
  t 1063 1144 1145
  t 1064 1146 1065
  t 1064 1145 1146
  t 1065 1147 1066
  t 1065 1146 1147
  t 1066 1148 1067
  t 1066 1147 1148
  t 1067 1149 1068
  t 1067 1148 1149
  t 1068 1150 1069
  t 1068 1149 1150
  t 1069 1151 1070
  t 1069 1150 1151
  t 1070 1152 1071
  t 1070 1151 1152
  t 2631 1153 1072
  t 2631 2634 1153
  t 1072 1154 1073
  t 1072 1153 1154
  t 1073 1155 1074
  t 1073 1154 1155
  t 1074 1156 1075
  t 1074 1155 1156
  t 1075 1157 1076
  t 1075 1156 1157
  t 1076 1158 1077
  t 1076 1157 1158
  t 2632 1159 1078
  t 2632 2635 1159
  t 1078 1160 1079
  t 1078 1159 1160
  t 1079 1161 1080
  t 1079 1160 1161
  t 1080 1162 1081
  t 1080 1161 1162
  t 1081 1163 1082
  t 1081 1162 1163
  t 1082 1164 1083
  t 1082 1163 1164
  t 1083 1165 1084
  t 1083 1164 1165
  t 1084 1166 1085
  t 1084 1165 1166
  t 1085 1167 1086
  t 1085 1166 1167
  t 1086 1168 1087
  t 1086 1167 1168
  t 1087 1169 1088
  t 1087 1168 1169
  t 1088 1170 1089
  t 1088 1169 1170
  t 1089 1171 1090
  t 1089 1170 1171
  t 1090 1172 1091
  t 1090 1171 1172
  t 1091 1173 1092
  t 1091 1172 1173
  t 1092 1174 1093
  t 1092 1173 1174
  t 1093 1175 1094
  t 1093 1174 1175
  t 1094 1176 1095
  t 1094 1175 1176
  t 1095 1177 1096
  t 1095 1176 1177
  t 1096 1178 1097
  t 1096 1177 1178
  t 1097 1179 1098
  t 1097 1178 1179
  t 1098 1180 1099
  t 1098 1179 1180
  t 1099 1181 1100
  t 1099 1180 1181
  t 1100 1182 1101
  t 1100 1181 1182
  t 1101 1183 1102
  t 1101 1182 1183
  t 1102 1184 1103
  t 1102 1183 1184
  t 1103 1185 1104
  t 1103 1184 1185
  t 1104 1186 1105
  t 1104 1185 1186
  t 1105 1187 1106
  t 1105 1186 1187
  t 1106 1188 1107
  t 1106 1187 1188
  t 1107 1189 1108
  t 1107 1188 1189
  t 1108 1190 1109
  t 1108 1189 1190
  t 1109 1191 1110
  t 1109 1190 1191
  t 1110 1192 1111
  t 1110 1191 1192
  t 1111 1193 1112
  t 1111 1192 1193
  t 1112 1194 1113
  t 1112 1193 1194
  t 1113 1195 1114
  t 1113 1194 1195
  t 1114 1196 1115
  t 1114 1195 1196
  t 1115 1197 1116
  t 1115 1196 1197
  t 1116 1198 1117
  t 1116 1197 1198
  t 1117 1199 1118
  t 1117 1198 1199
  t 1118 1200 1119
  t 1118 1199 1200
  t 1119 1201 1120
  t 1119 1200 1201
  t 1120 1202 1121
  t 1120 1201 1202
  t 2633 1203 1122
  t 2633 2636 1203
  t 1122 1204 1123
  t 1122 1203 1204
  t 1123 1205 1124
  t 1123 1204 1205
  t 1124 1206 1125
  t 1124 1205 1206
  t 1125 1207 1126
  t 1125 1206 1207
  t 1126 1208 1127
  t 1126 1207 1208
  t 1127 1209 1128
  t 1127 1208 1209
  t 1128 1210 1129
  t 1128 1209 1210
  t 1129 1211 1130
  t 1129 1210 1211
  t 1130 1212 1131
  t 1130 1211 1212
  t 1131 1213 1132
  t 1131 1212 1213
  t 1132 1214 1133
  t 1132 1213 1214
  t 1134 1216 1135
  t 1134 1215 1216
  t 1135 1217 1136
  t 1135 1216 1217
  t 1136 1218 1137
  t 1136 1217 1218
  t 1137 1219 1138
  t 1137 1218 1219
  t 1138 1220 1139
  t 1138 1219 1220
  t 1139 1221 1140
  t 1139 1220 1221
  t 1140 1222 1141
  t 1140 1221 1222
  t 1141 1223 1142
  t 1141 1222 1223
  t 1142 1224 1143
  t 1142 1223 1224
  t 1143 1225 1144
  t 1143 1224 1225
  t 1144 1226 1145
  t 1144 1225 1226
  t 1145 1227 1146
  t 1145 1226 1227
  t 1146 1228 1147
  t 1146 1227 1228
  t 1147 1229 1148
  t 1147 1228 1229
  t 1148 1230 1149
  t 1148 1229 1230
  t 1149 1231 1150
  t 1149 1230 1231
  t 1150 1232 1151
  t 1150 1231 1232
  t 1151 1233 1152
  t 1151 1232 1233
  t 2634 1234 1153
  t 2634 2637 1234
  t 1153 1235 1154
  t 1153 1234 1235
  t 1154 1236 1155
  t 1154 1235 1236
  t 1155 1237 1156
  t 1155 1236 1237
  t 1156 1238 1157
  t 1156 1237 1238
  t 1157 1239 1158
  t 1157 1238 1239
  t 2635 1240 1159
  t 2635 2638 1240
  t 1159 1241 1160
  t 1159 1240 1241
  t 1160 1242 1161
  t 1160 1241 1242
  t 1161 1243 1162
  t 1161 1242 1243
  t 1162 1244 1163
  t 1162 1243 1244
  t 1163 1245 1164
  t 1163 1244 1245
  t 1164 1246 1165
  t 1164 1245 1246
  t 1165 1247 1166
  t 1165 1246 1247
  t 1166 1248 1167
  t 1166 1247 1248
  t 1167 1249 1168
  t 1167 1248 1249
  t 1168 1250 1169
  t 1168 1249 1250
  t 1169 1251 1170
  t 1169 1250 1251
  t 1170 1252 1171
  t 1170 1251 1252
  t 1171 1253 1172
  t 1171 1252 1253
  t 1172 1254 1173
  t 1172 1253 1254
  t 1173 1255 1174
  t 1173 1254 1255
  t 1174 1256 1175
  t 1174 1255 1256
  t 1175 1257 1176
  t 1175 1256 1257
  t 1176 1258 1177
  t 1176 1257 1258
  t 1177 1259 1178
  t 1177 1258 1259
  t 1178 1260 1179
  t 1178 1259 1260
  t 1179 1261 1180
  t 1179 1260 1261
  t 1180 1262 1181
  t 1180 1261 1262
  t 1181 1263 1182
  t 1181 1262 1263
  t 1182 1264 1183
  t 1182 1263 1264
  t 1183 1265 1184
  t 1183 1264 1265
  t 1184 1266 1185
  t 1184 1265 1266
  t 1185 1267 1186
  t 1185 1266 1267
  t 1186 1268 1187
  t 1186 1267 1268
  t 1187 1269 1188
  t 1187 1268 1269
  t 1188 1270 1189
  t 1188 1269 1270
  t 1189 1271 1190
  t 1189 1270 1271
  t 1190 1272 1191
  t 1190 1271 1272
  t 1191 1273 1192
  t 1191 1272 1273
  t 1192 1274 1193
  t 1192 1273 1274
  t 1193 1275 1194
  t 1193 1274 1275
  t 1194 1276 1195
  t 1194 1275 1276
  t 1195 1277 1196
  t 1195 1276 1277
  t 1196 1278 1197
  t 1196 1277 1278
  t 1197 1279 1198
  t 1197 1278 1279
  t 1198 1280 1199
  t 1198 1279 1280
  t 1199 1281 1200
  t 1199 1280 1281
  t 1200 1282 1201
  t 1200 1281 1282
  t 1201 1283 1202
  t 1201 1282 1283
  t 2636 1284 1203
  t 2636 2639 1284
  t 1203 1285 1204
  t 1203 1284 1285
  t 1204 1286 1205
  t 1204 1285 1286
  t 1205 1287 1206
  t 1205 1286 1287
  t 1206 1288 1207
  t 1206 1287 1288
  t 1207 1289 1208
  t 1207 1288 1289
  t 1208 1290 1209
  t 1208 1289 1290
  t 1209 1291 1210
  t 1209 1290 1291
  t 1210 1292 1211
  t 1210 1291 1292
  t 1211 1293 1212
  t 1211 1292 1293
  t 1212 1294 1213
  t 1212 1293 1294
  t 1213 1295 1214
  t 1213 1294 1295
  t 1215 1297 1216
  t 1215 1296 1297
  t 1216 1298 1217
  t 1216 1297 1298
  t 1217 1299 1218
  t 1217 1298 1299
  t 1218 1300 1219
  t 1218 1299 1300
  t 1219 1301 1220
  t 1219 1300 1301
  t 1220 1302 1221
  t 1220 1301 1302
  t 1221 1303 1222
  t 1221 1302 1303
  t 1222 1304 1223
  t 1222 1303 1304
  t 1223 1305 1224
  t 1223 1304 1305
  t 1224 1306 1225
  t 1224 1305 1306
  t 1225 1307 1226
  t 1225 1306 1307
  t 1226 1308 1227
  t 1226 1307 1308
  t 1227 1309 1228
  t 1227 1308 1309
  t 1228 1310 1229
  t 1228 1309 1310
  t 1229 1311 1230
  t 1229 1310 1311
  t 1230 1312 1231
  t 1230 1311 1312
  t 1231 1313 1232
  t 1231 1312 1313
  t 1232 1314 1233
  t 1232 1313 1314
  t 2637 1315 1234
  t 2637 2640 1315
  t 1234 1316 1235
  t 1234 1315 1316
  t 1235 1317 1236
  t 1235 1316 1317
  t 1236 1318 1237
  t 1236 1317 1318
  t 1237 1319 1238
  t 1237 1318 1319
  t 1238 1320 1239
  t 1238 1319 1320
  t 2638 1321 1240
  t 2638 2641 1321
  t 1240 1322 1241
  t 1240 1321 1322
  t 1241 1323 1242
  t 1241 1322 1323
  t 1242 1324 1243
  t 1242 1323 1324
  t 1243 1325 1244
  t 1243 1324 1325
  t 1244 1326 1245
  t 1244 1325 1326
  t 1245 1327 1246
  t 1245 1326 1327
  t 1246 1328 1247
  t 1246 1327 1328
  t 1247 1329 1248
  t 1247 1328 1329
  t 1248 1330 1249
  t 1248 1329 1330
  t 1249 1331 1250
  t 1249 1330 1331
  t 1250 1332 1251
  t 1250 1331 1332
  t 1251 1333 1252
  t 1251 1332 1333
  t 1252 1334 1253
  t 1252 1333 1334
  t 1253 1335 1254
  t 1253 1334 1335
  t 1254 1336 1255
  t 1254 1335 1336
  t 1255 1337 1256
  t 1255 1336 1337
  t 1256 1338 1257
  t 1256 1337 1338
  t 1257 1339 1258
  t 1257 1338 1339
  t 1258 1340 1259
  t 1258 1339 1340
  t 1259 1341 1260
  t 1259 1340 1341
  t 1260 1342 1261
  t 1260 1341 1342
  t 1261 1343 1262
  t 1261 1342 1343
  t 1262 1344 1263
  t 1262 1343 1344
  t 1263 1345 1264
  t 1263 1344 1345
  t 1264 1346 1265
  t 1264 1345 1346
  t 1265 1347 1266
  t 1265 1346 1347
  t 1266 1348 1267
  t 1266 1347 1348
  t 1267 1349 1268
  t 1267 1348 1349
  t 1268 1350 1269
  t 1268 1349 1350
  t 1269 1351 1270
  t 1269 1350 1351
  t 1270 1352 1271
  t 1270 1351 1352
  t 1271 1353 1272
  t 1271 1352 1353
  t 1272 1354 1273
  t 1272 1353 1354
  t 1273 1355 1274
  t 1273 1354 1355
  t 1274 1356 1275
  t 1274 1355 1356
  t 1275 1357 1276
  t 1275 1356 1357
  t 1276 1358 1277
  t 1276 1357 1358
  t 1277 1359 1278
  t 1277 1358 1359
  t 1278 1360 1279
  t 1278 1359 1360
  t 1279 1361 1280
  t 1279 1360 1361
  t 1280 1362 1281
  t 1280 1361 1362
  t 1281 1363 1282
  t 1281 1362 1363
  t 1282 1364 1283
  t 1282 1363 1364
  t 2639 1365 1284
  t 2639 2642 1365
  t 1284 1366 1285
  t 1284 1365 1366
  t 1285 1367 1286
  t 1285 1366 1367
  t 1286 1368 1287
  t 1286 1367 1368
  t 1287 1369 1288
  t 1287 1368 1369
  t 1288 1370 1289
  t 1288 1369 1370
  t 1289 1371 1290
  t 1289 1370 1371
  t 1290 1372 1291
  t 1290 1371 1372
  t 1291 1373 1292
  t 1291 1372 1373
  t 1292 1374 1293
  t 1292 1373 1374
  t 1293 1375 1294
  t 1293 1374 1375
  t 1294 1376 1295
  t 1294 1375 1376
  t 1296 1378 1297
  t 1296 1377 1378
  t 1297 1379 1298
  t 1297 1378 1379
  t 1298 1380 1299
  t 1298 1379 1380
  t 1299 1381 1300
  t 1299 1380 1381
  t 1300 1382 1301
  t 1300 1381 1382
  t 1301 1383 1302
  t 1301 1382 1383
  t 1302 1384 1303
  t 1302 1383 1384
  t 1303 1385 1304
  t 1303 1384 1385
  t 1304 1386 1305
  t 1304 1385 1386
  t 1305 1387 1306
  t 1305 1386 1387
  t 1306 1388 1307
  t 1306 1387 1388
  t 1307 1389 1308
  t 1307 1388 1389
  t 1308 1390 1309
  t 1308 1389 1390
  t 1309 1391 1310
  t 1309 1390 1391
  t 1310 1392 1311
  t 1310 1391 1392
  t 1311 1393 1312
  t 1311 1392 1393
  t 1312 1394 1313
  t 1312 1393 1394
  t 1313 1395 1314
  t 1313 1394 1395
  t 2640 1396 1315
  t 2640 2643 1396
  t 1315 1397 1316
  t 1315 1396 1397
  t 1316 1398 1317
  t 1316 1397 1398
  t 1317 1399 1318
  t 1317 1398 1399
  t 1318 1400 1319
  t 1318 1399 1400
  t 1319 1401 1320
  t 1319 1400 1401
  t 2641 1402 1321
  t 2641 2644 1402
  t 1321 1403 1322
  t 1321 1402 1403
  t 1322 1404 1323
  t 1322 1403 1404
  t 1323 1405 1324
  t 1323 1404 1405
  t 1324 1406 1325
  t 1324 1405 1406
  t 1325 1407 1326
  t 1325 1406 1407
  t 1326 1408 1327
  t 1326 1407 1408
  t 1327 1409 1328
  t 1327 1408 1409
  t 1328 1410 1329
  t 1328 1409 1410
  t 1329 1411 1330
  t 1329 1410 1411
  t 1330 1412 1331
  t 1330 1411 1412
  t 1331 1413 1332
  t 1331 1412 1413
  t 1332 1414 1333
  t 1332 1413 1414
  t 1333 1415 1334
  t 1333 1414 1415
  t 1334 1416 1335
  t 1334 1415 1416
  t 1335 1417 1336
  t 1335 1416 1417
  t 1336 1418 1337
  t 1336 1417 1418
  t 1337 1419 1338
  t 1337 1418 1419
  t 1338 1420 1339
  t 1338 1419 1420
  t 1339 1421 1340
  t 1339 1420 1421
  t 1340 1422 1341
  t 1340 1421 1422
  t 1341 1423 1342
  t 1341 1422 1423
  t 1342 1424 1343
  t 1342 1423 1424
  t 1343 1425 1344
  t 1343 1424 1425
  t 1344 1426 1345
  t 1344 1425 1426
  t 1345 1427 1346
  t 1345 1426 1427
  t 1346 1428 1347
  t 1346 1427 1428
  t 1347 1429 1348
  t 1347 1428 1429
  t 1348 1430 1349
  t 1348 1429 1430
  t 1349 1431 1350
  t 1349 1430 1431
  t 1350 1432 1351
  t 1350 1431 1432
  t 1351 1433 1352
  t 1351 1432 1433
  t 1352 1434 1353
  t 1352 1433 1434
  t 1353 1435 1354
  t 1353 1434 1435
  t 1354 1436 1355
  t 1354 1435 1436
  t 1355 1437 1356
  t 1355 1436 1437
  t 1356 1438 1357
  t 1356 1437 1438
  t 1357 1439 1358
  t 1357 1438 1439
  t 1358 1440 1359
  t 1358 1439 1440
  t 1359 1441 1360
  t 1359 1440 1441
  t 1360 1442 1361
  t 1360 1441 1442
  t 1361 1443 1362
  t 1361 1442 1443
  t 1362 1444 1363
  t 1362 1443 1444
  t 1363 1445 1364
  t 1363 1444 1445
  t 2642 1446 1365
  t 2642 2645 1446
  t 1365 1447 1366
  t 1365 1446 1447
  t 1366 1448 1367
  t 1366 1447 1448
  t 1367 1449 1368
  t 1367 1448 1449
  t 1368 1450 1369
  t 1368 1449 1450
  t 1369 1451 1370
  t 1369 1450 1451
  t 1370 1452 1371
  t 1370 1451 1452
  t 1371 1453 1372
  t 1371 1452 1453
  t 1372 1454 1373
  t 1372 1453 1454
  t 1373 1455 1374
  t 1373 1454 1455
  t 1374 1456 1375
  t 1374 1455 1456
  t 1375 1457 1376
  t 1375 1456 1457
  t 1377 1459 1378
  t 1377 1458 1459
  t 1378 1460 1379
  t 1378 1459 1460
  t 1379 1461 1380
  t 1379 1460 1461
  t 1380 1462 1381
  t 1380 1461 1462
  t 1381 1463 1382
  t 1381 1462 1463
  t 1382 1464 1383
  t 1382 1463 1464
  t 1383 1465 1384
  t 1383 1464 1465
  t 1384 1466 1385
  t 1384 1465 1466
  t 1385 1467 1386
  t 1385 1466 1467
  t 1386 1468 1387
  t 1386 1467 1468
  t 1387 1469 1388
  t 1387 1468 1469
  t 1388 1470 1389
  t 1388 1469 1470
  t 1389 1471 1390
  t 1389 1470 1471
  t 1390 1472 1391
  t 1390 1471 1472
  t 1391 1473 1392
  t 1391 1472 1473
  t 1392 1474 1393
  t 1392 1473 1474
  t 1393 1475 1394
  t 1393 1474 1475
  t 1394 1476 1395
  t 1394 1475 1476
  t 2643 1477 1396
  t 2643 2646 1477
  t 1396 1478 1397
  t 1396 1477 1478
  t 1397 1479 1398
  t 1397 1478 1479
  t 1398 1480 1399
  t 1398 1479 1480
  t 1399 1481 1400
  t 1399 1480 1481
  t 1400 1482 1401
  t 1400 1481 1482
  t 2644 1483 1402
  t 2644 2647 1483
  t 1402 1484 1403
  t 1402 1483 1484
  t 1403 1485 1404
  t 1403 1484 1485
  t 1404 1486 1405
  t 1404 1485 1486
  t 1405 1487 1406
  t 1405 1486 1487
  t 1406 1488 1407
  t 1406 1487 1488
  t 1407 1489 1408
  t 1407 1488 1489
  t 1408 1490 1409
  t 1408 1489 1490
  t 1409 1491 1410
  t 1409 1490 1491
  t 1410 1492 1411
  t 1410 1491 1492
  t 1411 1493 1412
  t 1411 1492 1493
  t 1412 1494 1413
  t 1412 1493 1494
  t 1413 1495 1414
  t 1413 1494 1495
  t 1414 1496 1415
  t 1414 1495 1496
  t 1415 1497 1416
  t 1415 1496 1497
  t 1416 1498 1417
  t 1416 1497 1498
  t 1417 1499 1418
  t 1417 1498 1499
  t 1418 1500 1419
  t 1418 1499 1500
  t 1419 1501 1420
  t 1419 1500 1501
  t 1420 1502 1421
  t 1420 1501 1502
  t 1421 1503 1422
  t 1421 1502 1503
  t 1422 1504 1423
  t 1422 1503 1504
  t 1423 1505 1424
  t 1423 1504 1505
  t 1424 1506 1425
  t 1424 1505 1506
  t 1425 1507 1426
  t 1425 1506 1507
  t 1426 1508 1427
  t 1426 1507 1508
  t 1427 1509 1428
  t 1427 1508 1509
  t 1428 1510 1429
  t 1428 1509 1510
  t 1429 1511 1430
  t 1429 1510 1511
  t 1430 1512 1431
  t 1430 1511 1512
  t 1431 1513 1432
  t 1431 1512 1513
  t 1432 1514 1433
  t 1432 1513 1514
  t 1433 1515 1434
  t 1433 1514 1515
  t 1434 1516 1435
  t 1434 1515 1516
  t 1435 1517 1436
  t 1435 1516 1517
  t 1436 1518 1437
  t 1436 1517 1518
  t 1437 1519 1438
  t 1437 1518 1519
  t 1438 1520 1439
  t 1438 1519 1520
  t 1439 1521 1440
  t 1439 1520 1521
  t 1440 1522 1441
  t 1440 1521 1522
  t 1441 1523 1442
  t 1441 1522 1523
  t 1442 1524 1443
  t 1442 1523 1524
  t 1443 1525 1444
  t 1443 1524 1525
  t 1444 1526 1445
  t 1444 1525 1526
  t 2645 1527 1446
  t 2645 2648 1527
  t 1446 1528 1447
  t 1446 1527 1528
  t 1447 1529 1448
  t 1447 1528 1529
  t 1448 1530 1449
  t 1448 1529 1530
  t 1449 1531 1450
  t 1449 1530 1531
  t 1450 1532 1451
  t 1450 1531 1532
  t 1451 1533 1452
  t 1451 1532 1533
  t 1452 1534 1453
  t 1452 1533 1534
  t 1453 1535 1454
  t 1453 1534 1535
  t 1454 1536 1455
  t 1454 1535 1536
  t 1455 1537 1456
  t 1455 1536 1537
  t 1456 1538 1457
  t 1456 1537 1538
  t 1458 1540 1459
  t 1458 1539 1540
  t 1459 1541 1460
  t 1459 1540 1541
  t 1460 1542 1461
  t 1460 1541 1542
  t 1461 1543 1462
  t 1461 1542 1543
  t 1462 1544 1463
  t 1462 1543 1544
  t 1463 1545 1464
  t 1463 1544 1545
  t 1464 1546 1465
  t 1464 1545 1546
  t 1465 1547 1466
  t 1465 1546 1547
  t 1466 1548 1467
  t 1466 1547 1548
  t 1467 1549 1468
  t 1467 1548 1549
  t 1468 1550 1469
  t 1468 1549 1550
  t 1469 1551 1470
  t 1469 1550 1551
  t 1470 1552 1471
  t 1470 1551 1552
  t 1471 1553 1472
  t 1471 1552 1553
  t 1472 1554 1473
  t 1472 1553 1554
  t 1473 1555 1474
  t 1473 1554 1555
  t 1474 1556 1475
  t 1474 1555 1556
  t 1475 1557 1476
  t 1475 1556 1557
  t 2646 1558 1477
  t 2646 2649 1558
  t 1477 1559 1478
  t 1477 1558 1559
  t 1478 1560 1479
  t 1478 1559 1560
  t 1479 1561 1480
  t 1479 1560 1561
  t 1480 1562 1481
  t 1480 1561 1562
  t 1481 1563 1482
  t 1481 1562 1563
  t 2647 1564 1483
  t 2647 2650 1564
  t 1483 1565 1484
  t 1483 1564 1565
  t 1484 1566 1485
  t 1484 1565 1566
  t 1485 1567 1486
  t 1485 1566 1567
  t 1486 1568 1487
  t 1486 1567 1568
  t 1487 1569 1488
  t 1487 1568 1569
  t 1488 1570 1489
  t 1488 1569 1570
  t 1489 1571 1490
  t 1489 1570 1571
  t 1490 1572 1491
  t 1490 1571 1572
  t 1491 1573 1492
  t 1491 1572 1573
  t 1492 1574 1493
  t 1492 1573 1574
  t 1493 1575 1494
  t 1493 1574 1575
  t 1494 1576 1495
  t 1494 1575 1576
  t 1495 1577 1496
  t 1495 1576 1577
  t 1496 1578 1497
  t 1496 1577 1578
  t 1497 1579 1498
  t 1497 1578 1579
  t 1498 1580 1499
  t 1498 1579 1580
  t 1499 1581 1500
  t 1499 1580 1581
  t 1500 1582 1501
  t 1500 1581 1582
  t 1501 1583 1502
  t 1501 1582 1583
  t 1502 1584 1503
  t 1502 1583 1584
  t 1503 1585 1504
  t 1503 1584 1585
  t 1504 1586 1505
  t 1504 1585 1586
  t 1505 1587 1506
  t 1505 1586 1587
  t 1506 1588 1507
  t 1506 1587 1588
  t 1507 1589 1508
  t 1507 1588 1589
  t 1508 1590 1509
  t 1508 1589 1590
  t 1509 1591 1510
  t 1509 1590 1591
  t 1510 1592 1511
  t 1510 1591 1592
  t 1511 1593 1512
  t 1511 1592 1593
  t 1512 1594 1513
  t 1512 1593 1594
  t 1513 1595 1514
  t 1513 1594 1595
  t 1514 1596 1515
  t 1514 1595 1596
  t 1515 1597 1516
  t 1515 1596 1597
  t 1516 1598 1517
  t 1516 1597 1598
  t 1517 1599 1518
  t 1517 1598 1599
  t 1518 1600 1519
  t 1518 1599 1600
  t 1519 1601 1520
  t 1519 1600 1601
  t 1520 1602 1521
  t 1520 1601 1602
  t 1521 1603 1522
  t 1521 1602 1603
  t 1522 1604 1523
  t 1522 1603 1604
  t 1523 1605 1524
  t 1523 1604 1605
  t 1524 1606 1525
  t 1524 1605 1606
  t 1525 1607 1526
  t 1525 1606 1607
  t 2648 1608 1527
  t 2648 2651 1608
  t 1527 1609 1528
  t 1527 1608 1609
  t 1528 1610 1529
  t 1528 1609 1610
  t 1529 1611 1530
  t 1529 1610 1611
  t 1530 1612 1531
  t 1530 1611 1612
  t 1531 1613 1532
  t 1531 1612 1613
  t 1532 1614 1533
  t 1532 1613 1614
  t 1533 1615 1534
  t 1533 1614 1615
  t 1534 1616 1535
  t 1534 1615 1616
  t 1535 1617 1536
  t 1535 1616 1617
  t 1536 1618 1537
  t 1536 1617 1618
  t 1537 1619 1538
  t 1537 1618 1619
  t 1539 1621 1540
  t 1539 1620 1621
  t 1540 1622 1541
  t 1540 1621 1622
  t 1541 1623 1542
  t 1541 1622 1623
  t 1542 1624 1543
  t 1542 1623 1624
  t 1543 1625 1544
  t 1543 1624 1625
  t 1544 1626 1545
  t 1544 1625 1626
  t 1545 1627 1546
  t 1545 1626 1627
  t 1546 1628 1547
  t 1546 1627 1628
  t 1547 1629 1548
  t 1547 1628 1629
  t 1548 1630 1549
  t 1548 1629 1630
  t 1549 1631 1550
  t 1549 1630 1631
  t 1550 1632 1551
  t 1550 1631 1632
  t 1551 1633 1552
  t 1551 1632 1633
  t 1552 1634 1553
  t 1552 1633 1634
  t 1553 1635 1554
  t 1553 1634 1635
  t 1554 1636 1555
  t 1554 1635 1636
  t 1555 1637 1556
  t 1555 1636 1637
  t 1556 1638 1557
  t 1556 1637 1638
  t 2649 1639 1558
  t 2649 2652 1639
  t 1558 1640 1559
  t 1558 1639 1640
  t 1559 1641 1560
  t 1559 1640 1641
  t 1560 1642 1561
  t 1560 1641 1642
  t 1561 1643 1562
  t 1561 1642 1643
  t 1562 1644 1563
  t 1562 1643 1644
  t 2650 1645 1564
  t 2650 2653 1645
  t 1564 1646 1565
  t 1564 1645 1646
  t 1565 1647 1566
  t 1565 1646 1647
  t 1566 1648 1567
  t 1566 1647 1648
  t 1567 1649 1568
  t 1567 1648 1649
  t 1568 1650 1569
  t 1568 1649 1650
  t 1569 1651 1570
  t 1569 1650 1651
  t 1570 1652 1571
  t 1570 1651 1652
  t 1571 1653 1572
  t 1571 1652 1653
  t 1572 1654 1573
  t 1572 1653 1654
  t 1573 1655 1574
  t 1573 1654 1655
  t 1574 1656 1575
  t 1574 1655 1656
  t 1575 1657 1576
  t 1575 1656 1657
  t 1576 1658 1577
  t 1576 1657 1658
  t 1577 1659 1578
  t 1577 1658 1659
  t 1578 1660 1579
  t 1578 1659 1660
  t 1579 1661 1580
  t 1579 1660 1661
  t 1580 1662 1581
  t 1580 1661 1662
  t 1581 1663 1582
  t 1581 1662 1663
  t 1582 1664 1583
  t 1582 1663 1664
  t 1583 1665 1584
  t 1583 1664 1665
  t 1584 1666 1585
  t 1584 1665 1666
  t 1585 1667 1586
  t 1585 1666 1667
  t 1586 1668 1587
  t 1586 1667 1668
  t 1587 1669 1588
  t 1587 1668 1669
  t 1588 1670 1589
  t 1588 1669 1670
  t 1589 1671 1590
  t 1589 1670 1671
  t 1590 1672 1591
  t 1590 1671 1672
  t 1591 1673 1592
  t 1591 1672 1673
  t 1592 1674 1593
  t 1592 1673 1674
  t 1593 1675 1594
  t 1593 1674 1675
  t 1594 1676 1595
  t 1594 1675 1676
  t 1595 1677 1596
  t 1595 1676 1677
  t 1596 1678 1597
  t 1596 1677 1678
  t 1597 1679 1598
  t 1597 1678 1679
  t 1598 1680 1599
  t 1598 1679 1680
  t 1599 1681 1600
  t 1599 1680 1681
  t 1600 1682 1601
  t 1600 1681 1682
  t 1601 1683 1602
  t 1601 1682 1683
  t 1602 1684 1603
  t 1602 1683 1684
  t 1603 1685 1604
  t 1603 1684 1685
  t 1604 1686 1605
  t 1604 1685 1686
  t 1605 1687 1606
  t 1605 1686 1687
  t 1606 1688 1607
  t 1606 1687 1688
  t 2651 1689 1608
  t 2651 2654 1689
  t 1608 1690 1609
  t 1608 1689 1690
  t 1609 1691 1610
  t 1609 1690 1691
  t 1610 1692 1611
  t 1610 1691 1692
  t 1611 1693 1612
  t 1611 1692 1693
  t 1612 1694 1613
  t 1612 1693 1694
  t 1613 1695 1614
  t 1613 1694 1695
  t 1614 1696 1615
  t 1614 1695 1696
  t 1615 1697 1616
  t 1615 1696 1697
  t 1616 1698 1617
  t 1616 1697 1698
  t 1617 1699 1618
  t 1617 1698 1699
  t 1618 1700 1619
  t 1618 1699 1700
  t 1620 1702 1621
  t 1620 1701 1702
  t 1621 1703 1622
  t 1621 1702 1703
  t 1622 1704 1623
  t 1622 1703 1704
  t 1623 1705 1624
  t 1623 1704 1705
  t 1624 1706 1625
  t 1624 1705 1706
  t 1625 1707 1626
  t 1625 1706 1707
  t 1626 1708 1627
  t 1626 1707 1708
  t 1627 1709 1628
  t 1627 1708 1709
  t 1628 1710 1629
  t 1628 1709 1710
  t 1629 1711 1630
  t 1629 1710 1711
  t 1630 1712 1631
  t 1630 1711 1712
  t 1631 1713 1632
  t 1631 1712 1713
  t 1632 1714 1633
  t 1632 1713 1714
  t 1633 1715 1634
  t 1633 1714 1715
  t 1634 1716 1635
  t 1634 1715 1716
  t 1635 1717 1636
  t 1635 1716 1717
  t 1636 1718 1637
  t 1636 1717 1718
  t 1637 1719 1638
  t 1637 1718 1719
  t 2652 1720 1639
  t 2652 2655 1720
  t 1639 1721 1640
  t 1639 1720 1721
  t 1640 1722 1641
  t 1640 1721 1722
  t 1641 1723 1642
  t 1641 1722 1723
  t 1642 1724 1643
  t 1642 1723 1724
  t 1643 1725 1644
  t 1643 1724 1725
  t 2653 1726 1645
  t 2653 2656 1726
  t 1645 1727 1646
  t 1645 1726 1727
  t 1646 1728 1647
  t 1646 1727 1728
  t 1647 1729 1648
  t 1647 1728 1729
  t 1648 1730 1649
  t 1648 1729 1730
  t 1649 1731 1650
  t 1649 1730 1731
  t 1650 1732 1651
  t 1650 1731 1732
  t 1651 1733 1652
  t 1651 1732 1733
  t 1652 1734 1653
  t 1652 1733 1734
  t 1653 1735 1654
  t 1653 1734 1735
  t 1654 1736 1655
  t 1654 1735 1736
  t 1655 1737 1656
  t 1655 1736 1737
  t 1656 1738 1657
  t 1656 1737 1738
  t 1657 1739 1658
  t 1657 1738 1739
  t 1658 1740 1659
  t 1658 1739 1740
  t 1659 1741 1660
  t 1659 1740 1741
  t 1660 1742 1661
  t 1660 1741 1742
  t 1661 1743 1662
  t 1661 1742 1743
  t 1662 1744 1663
  t 1662 1743 1744
  t 1663 1745 1664
  t 1663 1744 1745
  t 1664 1746 1665
  t 1664 1745 1746
  t 1665 1747 1666
  t 1665 1746 1747
  t 1666 1748 1667
  t 1666 1747 1748
  t 1667 1749 1668
  t 1667 1748 1749
  t 1668 1750 1669
  t 1668 1749 1750
  t 1669 1751 1670
  t 1669 1750 1751
  t 1670 1752 1671
  t 1670 1751 1752
  t 1671 1753 1672
  t 1671 1752 1753
  t 1672 1754 1673
  t 1672 1753 1754
  t 1673 1755 1674
  t 1673 1754 1755
  t 1674 1756 1675
  t 1674 1755 1756
  t 1675 1757 1676
  t 1675 1756 1757
  t 1676 1758 1677
  t 1676 1757 1758
  t 1677 1759 1678
  t 1677 1758 1759
  t 1678 1760 1679
  t 1678 1759 1760
  t 1679 1761 1680
  t 1679 1760 1761
  t 1680 1762 1681
  t 1680 1761 1762
  t 1681 1763 1682
  t 1681 1762 1763
  t 1682 1764 1683
  t 1682 1763 1764
  t 1683 1765 1684
  t 1683 1764 1765
  t 1684 1766 1685
  t 1684 1765 1766
  t 1685 1767 1686
  t 1685 1766 1767
  t 1686 1768 1687
  t 1686 1767 1768
  t 1687 1769 1688
  t 1687 1768 1769
  t 2654 1770 1689
  t 2654 2657 1770
  t 1689 1771 1690
  t 1689 1770 1771
  t 1690 1772 1691
  t 1690 1771 1772
  t 1691 1773 1692
  t 1691 1772 1773
  t 1692 1774 1693
  t 1692 1773 1774
  t 1693 1775 1694
  t 1693 1774 1775
  t 1694 1776 1695
  t 1694 1775 1776
  t 1695 1777 1696
  t 1695 1776 1777
  t 1696 1778 1697
  t 1696 1777 1778
  t 1697 1779 1698
  t 1697 1778 1779
  t 1698 1780 1699
  t 1698 1779 1780
  t 1699 1781 1700
  t 1699 1780 1781
  t 1701 1783 1702
  t 1701 1782 1783
  t 1702 1784 1703
  t 1702 1783 1784
  t 1703 1785 1704
  t 1703 1784 1785
  t 1704 1786 1705
  t 1704 1785 1786
  t 1705 1787 1706
  t 1705 1786 1787
  t 1706 1788 1707
  t 1706 1787 1788
  t 1707 1789 1708
  t 1707 1788 1789
  t 1708 1790 1709
  t 1708 1789 1790
  t 1709 1791 1710
  t 1709 1790 1791
  t 1710 1792 1711
  t 1710 1791 1792
  t 1711 1793 1712
  t 1711 1792 1793
  t 1712 1794 1713
  t 1712 1793 1794
  t 1713 1795 1714
  t 1713 1794 1795
  t 1714 1796 1715
  t 1714 1795 1796
  t 1715 1797 1716
  t 1715 1796 1797
  t 1716 1798 1717
  t 1716 1797 1798
  t 1717 1799 1718
  t 1717 1798 1799
  t 1718 1800 1719
  t 1718 1799 1800
  t 2655 1801 1720
  t 2655 2658 1801
  t 1720 1802 1721
  t 1720 1801 1802
  t 1721 1803 1722
  t 1721 1802 1803
  t 1722 1804 1723
  t 1722 1803 1804
  t 1723 1805 1724
  t 1723 1804 1805
  t 1724 1806 1725
  t 1724 1805 1806
  t 2656 1807 1726
  t 2656 2659 1807
  t 1726 1808 1727
  t 1726 1807 1808
  t 1727 1809 1728
  t 1727 1808 1809
  t 1728 1810 1729
  t 1728 1809 1810
  t 1729 1811 1730
  t 1729 1810 1811
  t 1730 1812 1731
  t 1730 1811 1812
  t 1731 1813 1732
  t 1731 1812 1813
  t 1732 1814 1733
  t 1732 1813 1814
  t 1733 1815 1734
  t 1733 1814 1815
  t 1734 1816 1735
  t 1734 1815 1816
  t 1735 1817 1736
  t 1735 1816 1817
  t 1736 1818 1737
  t 1736 1817 1818
  t 1737 1819 1738
  t 1737 1818 1819
  t 1738 1820 1739
  t 1738 1819 1820
  t 1739 1821 1740
  t 1739 1820 1821
  t 1740 1822 1741
  t 1740 1821 1822
  t 1741 1823 1742
  t 1741 1822 1823
  t 1742 1824 1743
  t 1742 1823 1824
  t 1743 1825 1744
  t 1743 1824 1825
  t 1744 1826 1745
  t 1744 1825 1826
  t 1745 1827 1746
  t 1745 1826 1827
  t 1746 1828 1747
  t 1746 1827 1828
  t 1747 1829 1748
  t 1747 1828 1829
  t 1748 1830 1749
  t 1748 1829 1830
  t 1749 1831 1750
  t 1749 1830 1831
  t 1750 1832 1751
  t 1750 1831 1832
  t 1751 1833 1752
  t 1751 1832 1833
  t 1752 1834 1753
  t 1752 1833 1834
  t 1753 1835 1754
  t 1753 1834 1835
  t 1754 1836 1755
  t 1754 1835 1836
  t 1755 1837 1756
  t 1755 1836 1837
  t 1756 1838 1757
  t 1756 1837 1838
  t 1757 1839 1758
  t 1757 1838 1839
  t 1758 1840 1759
  t 1758 1839 1840
  t 1759 1841 1760
  t 1759 1840 1841
  t 1760 1842 1761
  t 1760 1841 1842
  t 1761 1843 1762
  t 1761 1842 1843
  t 1762 1844 1763
  t 1762 1843 1844
  t 1763 1845 1764
  t 1763 1844 1845
  t 1764 1846 1765
  t 1764 1845 1846
  t 1765 1847 1766
  t 1765 1846 1847
  t 1766 1848 1767
  t 1766 1847 1848
  t 1767 1849 1768
  t 1767 1848 1849
  t 1768 1850 1769
  t 1768 1849 1850
  t 2657 1851 1770
  t 2657 2660 1851
  t 1770 1852 1771
  t 1770 1851 1852
  t 1771 1853 1772
  t 1771 1852 1853
  t 1772 1854 1773
  t 1772 1853 1854
  t 1773 1855 1774
  t 1773 1854 1855
  t 1774 1856 1775
  t 1774 1855 1856
  t 1775 1857 1776
  t 1775 1856 1857
  t 1776 1858 1777
  t 1776 1857 1858
  t 1777 1859 1778
  t 1777 1858 1859
  t 1778 1860 1779
  t 1778 1859 1860
  t 1779 1861 1780
  t 1779 1860 1861
  t 1780 1862 1781
  t 1780 1861 1862
  t 1782 1864 1783
  t 1782 1863 1864
  t 1783 1865 1784
  t 1783 1864 1865
  t 1784 1866 1785
  t 1784 1865 1866
  t 1785 1867 1786
  t 1785 1866 1867
  t 1786 1868 1787
  t 1786 1867 1868
  t 1787 1869 1788
  t 1787 1868 1869
  t 1788 1870 1789
  t 1788 1869 1870
  t 1789 1871 1790
  t 1789 1870 1871
  t 1790 1872 1791
  t 1790 1871 1872
  t 1791 1873 1792
  t 1791 1872 1873
  t 1792 1874 1793
  t 1792 1873 1874
  t 1793 1875 1794
  t 1793 1874 1875
  t 1794 1876 1795
  t 1794 1875 1876
  t 1795 1877 1796
  t 1795 1876 1877
  t 1796 1878 1797
  t 1796 1877 1878
  t 1797 1879 1798
  t 1797 1878 1879
  t 1798 1880 1799
  t 1798 1879 1880
  t 1799 1881 1800
  t 1799 1880 1881
  t 2658 1882 1801
  t 2658 2661 1882
  t 1801 1883 1802
  t 1801 1882 1883
  t 1802 1884 1803
  t 1802 1883 1884
  t 1803 1885 1804
  t 1803 1884 1885
  t 1804 1886 1805
  t 1804 1885 1886
  t 1805 1887 1806
  t 1805 1886 1887
  t 2659 1888 1807
  t 2659 2662 1888
  t 1807 1889 1808
  t 1807 1888 1889
  t 1808 1890 1809
  t 1808 1889 1890
  t 1809 1891 1810
  t 1809 1890 1891
  t 1810 1892 1811
  t 1810 1891 1892
  t 1811 1893 1812
  t 1811 1892 1893
  t 1812 1894 1813
  t 1812 1893 1894
  t 1813 1895 1814
  t 1813 1894 1895
  t 1814 1896 1815
  t 1814 1895 1896
  t 1815 1897 1816
  t 1815 1896 1897
  t 1816 1898 1817
  t 1816 1897 1898
  t 1817 1899 1818
  t 1817 1898 1899
  t 1818 1900 1819
  t 1818 1899 1900
  t 1819 1901 1820
  t 1819 1900 1901
  t 1820 1902 1821
  t 1820 1901 1902
  t 1821 1903 1822
  t 1821 1902 1903
  t 1822 1904 1823
  t 1822 1903 1904
  t 1823 1905 1824
  t 1823 1904 1905
  t 1824 1906 1825
  t 1824 1905 1906
  t 1825 1907 1826
  t 1825 1906 1907
  t 1826 1908 1827
  t 1826 1907 1908
  t 1827 1909 1828
  t 1827 1908 1909
  t 1828 1910 1829
  t 1828 1909 1910
  t 1829 1911 1830
  t 1829 1910 1911
  t 1830 1912 1831
  t 1830 1911 1912
  t 1831 1913 1832
  t 1831 1912 1913
  t 1832 1914 1833
  t 1832 1913 1914
  t 1833 1915 1834
  t 1833 1914 1915
  t 1834 1916 1835
  t 1834 1915 1916
  t 1835 1917 1836
  t 1835 1916 1917
  t 1836 1918 1837
  t 1836 1917 1918
  t 1837 1919 1838
  t 1837 1918 1919
  t 1838 1920 1839
  t 1838 1919 1920
  t 1839 1921 1840
  t 1839 1920 1921
  t 1840 1922 1841
  t 1840 1921 1922
  t 1841 1923 1842
  t 1841 1922 1923
  t 1842 1924 1843
  t 1842 1923 1924
  t 1843 1925 1844
  t 1843 1924 1925
  t 1844 1926 1845
  t 1844 1925 1926
  t 1845 1927 1846
  t 1845 1926 1927
  t 1846 1928 1847
  t 1846 1927 1928
  t 1847 1929 1848
  t 1847 1928 1929
  t 1848 1930 1849
  t 1848 1929 1930
  t 1849 1931 1850
  t 1849 1930 1931
  t 2660 1932 1851
  t 2660 2663 1932
  t 1851 1933 1852
  t 1851 1932 1933
  t 1852 1934 1853
  t 1852 1933 1934
  t 1853 1935 1854
  t 1853 1934 1935
  t 1854 1936 1855
  t 1854 1935 1936
  t 1855 1937 1856
  t 1855 1936 1937
  t 1856 1938 1857
  t 1856 1937 1938
  t 1857 1939 1858
  t 1857 1938 1939
  t 1858 1940 1859
  t 1858 1939 1940
  t 1859 1941 1860
  t 1859 1940 1941
  t 1860 1942 1861
  t 1860 1941 1942
  t 1861 1943 1862
  t 1861 1942 1943
  t 1863 1945 1864
  t 1863 1944 1945
  t 1864 1946 1865
  t 1864 1945 1946
  t 1865 1947 1866
  t 1865 1946 1947
  t 1866 1948 1867
  t 1866 1947 1948
  t 1867 1949 1868
  t 1867 1948 1949
  t 1868 1950 1869
  t 1868 1949 1950
  t 1869 1951 1870
  t 1869 1950 1951
  t 1870 1952 1871
  t 1870 1951 1952
  t 1871 1953 1872
  t 1871 1952 1953
  t 1872 1954 1873
  t 1872 1953 1954
  t 1873 1955 1874
  t 1873 1954 1955
  t 1874 1956 1875
  t 1874 1955 1956
  t 1875 1957 1876
  t 1875 1956 1957
  t 1876 1958 1877
  t 1876 1957 1958
  t 1877 1959 1878
  t 1877 1958 1959
  t 1878 1960 1879
  t 1878 1959 1960
  t 1879 1961 1880
  t 1879 1960 1961
  t 1880 1962 1881
  t 1880 1961 1962
  t 2661 1963 1882
  t 2661 2664 1963
  t 1882 1964 1883
  t 1882 1963 1964
  t 1883 1965 1884
  t 1883 1964 1965
  t 1884 1966 1885
  t 1884 1965 1966
  t 1885 1967 1886
  t 1885 1966 1967
  t 1886 1968 1887
  t 1886 1967 1968
  t 2662 1969 1888
  t 2662 2665 1969
  t 1888 1970 1889
  t 1888 1969 1970
  t 1889 1971 1890
  t 1889 1970 1971
  t 1890 1972 1891
  t 1890 1971 1972
  t 1891 1973 1892
  t 1891 1972 1973
  t 1892 1974 1893
  t 1892 1973 1974
  t 1893 1975 1894
  t 1893 1974 1975
  t 1894 1976 1895
  t 1894 1975 1976
  t 1895 1977 1896
  t 1895 1976 1977
  t 1896 1978 1897
  t 1896 1977 1978
  t 1897 1979 1898
  t 1897 1978 1979
  t 1898 1980 1899
  t 1898 1979 1980
  t 1899 1981 1900
  t 1899 1980 1981
  t 1900 1982 1901
  t 1900 1981 1982
  t 1901 1983 1902
  t 1901 1982 1983
  t 1902 1984 1903
  t 1902 1983 1984
  t 1903 1985 1904
  t 1903 1984 1985
  t 1904 1986 1905
  t 1904 1985 1986
  t 1905 1987 1906
  t 1905 1986 1987
  t 1906 1988 1907
  t 1906 1987 1988
  t 1907 1989 1908
  t 1907 1988 1989
  t 1908 1990 1909
  t 1908 1989 1990
  t 1909 1991 1910
  t 1909 1990 1991
  t 1910 1992 1911
  t 1910 1991 1992
  t 1911 1993 1912
  t 1911 1992 1993
  t 1912 1994 1913
  t 1912 1993 1994
  t 1913 1995 1914
  t 1913 1994 1995
  t 1914 1996 1915
  t 1914 1995 1996
  t 1915 1997 1916
  t 1915 1996 1997
  t 1916 1998 1917
  t 1916 1997 1998
  t 1917 1999 1918
  t 1917 1998 1999
  t 1918 2000 1919
  t 1918 1999 2000
  t 1919 2001 1920
  t 1919 2000 2001
  t 1920 2002 1921
  t 1920 2001 2002
  t 1921 2003 1922
  t 1921 2002 2003
  t 1922 2004 1923
  t 1922 2003 2004
  t 1923 2005 1924
  t 1923 2004 2005
  t 1924 2006 1925
  t 1924 2005 2006
  t 1925 2007 1926
  t 1925 2006 2007
  t 1926 2008 1927
  t 1926 2007 2008
  t 1927 2009 1928
  t 1927 2008 2009
  t 1928 2010 1929
  t 1928 2009 2010
  t 1929 2011 1930
  t 1929 2010 2011
  t 1930 2012 1931
  t 1930 2011 2012
  t 2663 2013 1932
  t 2663 2666 2013
  t 1932 2014 1933
  t 1932 2013 2014
  t 1933 2015 1934
  t 1933 2014 2015
  t 1934 2016 1935
  t 1934 2015 2016
  t 1935 2017 1936
  t 1935 2016 2017
  t 1936 2018 1937
  t 1936 2017 2018
  t 1937 2019 1938
  t 1937 2018 2019
  t 1938 2020 1939
  t 1938 2019 2020
  t 1939 2021 1940
  t 1939 2020 2021
  t 1940 2022 1941
  t 1940 2021 2022
  t 1941 2023 1942
  t 1941 2022 2023
  t 1942 2024 1943
  t 1942 2023 2024
  t 1944 2026 1945
  t 1944 2025 2026
  t 1945 2027 1946
  t 1945 2026 2027
  t 1946 2028 1947
  t 1946 2027 2028
  t 1947 2029 1948
  t 1947 2028 2029
  t 1948 2030 1949
  t 1948 2029 2030
  t 1949 2031 1950
  t 1949 2030 2031
  t 1950 2032 1951
  t 1950 2031 2032
  t 1951 2033 1952
  t 1951 2032 2033
  t 1952 2034 1953
  t 1952 2033 2034
  t 1953 2035 1954
  t 1953 2034 2035
  t 1954 2036 1955
  t 1954 2035 2036
  t 1955 2037 1956
  t 1955 2036 2037
  t 1956 2038 1957
  t 1956 2037 2038
  t 1957 2039 1958
  t 1957 2038 2039
  t 1958 2040 1959
  t 1958 2039 2040
  t 1959 2041 1960
  t 1959 2040 2041
  t 1960 2042 1961
  t 1960 2041 2042
  t 1961 2043 1962
  t 1961 2042 2043
  t 2664 2044 1963
  t 2664 2667 2044
  t 1963 2045 1964
  t 1963 2044 2045
  t 1964 2046 1965
  t 1964 2045 2046
  t 1965 2047 1966
  t 1965 2046 2047
  t 1966 2048 1967
  t 1966 2047 2048
  t 1967 2049 1968
  t 1967 2048 2049
  t 2665 2050 1969
  t 2665 2668 2050
  t 1969 2051 1970
  t 1969 2050 2051
  t 1970 2052 1971
  t 1970 2051 2052
  t 1971 2053 1972
  t 1971 2052 2053
  t 1972 2054 1973
  t 1972 2053 2054
  t 1973 2055 1974
  t 1973 2054 2055
  t 1974 2056 1975
  t 1974 2055 2056
  t 1975 2057 1976
  t 1975 2056 2057
  t 1976 2058 1977
  t 1976 2057 2058
  t 1977 2059 1978
  t 1977 2058 2059
  t 1978 2060 1979
  t 1978 2059 2060
  t 1979 2061 1980
  t 1979 2060 2061
  t 1980 2062 1981
  t 1980 2061 2062
  t 1981 2063 1982
  t 1981 2062 2063
  t 1982 2064 1983
  t 1982 2063 2064
  t 1983 2065 1984
  t 1983 2064 2065
  t 1984 2066 1985
  t 1984 2065 2066
  t 1985 2067 1986
  t 1985 2066 2067
  t 1986 2068 1987
  t 1986 2067 2068
  t 1987 2069 1988
  t 1987 2068 2069
  t 1988 2070 1989
  t 1988 2069 2070
  t 1989 2071 1990
  t 1989 2070 2071
  t 1990 2072 1991
  t 1990 2071 2072
  t 1991 2073 1992
  t 1991 2072 2073
  t 1992 2074 1993
  t 1992 2073 2074
  t 1993 2075 1994
  t 1993 2074 2075
  t 1994 2076 1995
  t 1994 2075 2076
  t 1995 2077 1996
  t 1995 2076 2077
  t 1996 2078 1997
  t 1996 2077 2078
  t 1997 2079 1998
  t 1997 2078 2079
  t 1998 2080 1999
  t 1998 2079 2080
  t 1999 2081 2000
  t 1999 2080 2081
  t 2000 2082 2001
  t 2000 2081 2082
  t 2001 2083 2002
  t 2001 2082 2083
  t 2002 2084 2003
  t 2002 2083 2084
  t 2003 2085 2004
  t 2003 2084 2085
  t 2004 2086 2005
  t 2004 2085 2086
  t 2005 2087 2006
  t 2005 2086 2087
  t 2006 2088 2007
  t 2006 2087 2088
  t 2007 2089 2008
  t 2007 2088 2089
  t 2008 2090 2009
  t 2008 2089 2090
  t 2009 2091 2010
  t 2009 2090 2091
  t 2010 2092 2011
  t 2010 2091 2092
  t 2011 2093 2012
  t 2011 2092 2093
  t 2666 2094 2013
  t 2666 2669 2094
  t 2013 2095 2014
  t 2013 2094 2095
  t 2014 2096 2015
  t 2014 2095 2096
  t 2015 2097 2016
  t 2015 2096 2097
  t 2016 2098 2017
  t 2016 2097 2098
  t 2017 2099 2018
  t 2017 2098 2099
  t 2018 2100 2019
  t 2018 2099 2100
  t 2019 2101 2020
  t 2019 2100 2101
  t 2020 2102 2021
  t 2020 2101 2102
  t 2021 2103 2022
  t 2021 2102 2103
  t 2022 2104 2023
  t 2022 2103 2104
  t 2023 2105 2024
  t 2023 2104 2105
  t 2025 2107 2026
  t 2025 2106 2107
  t 2026 2108 2027
  t 2026 2107 2108
  t 2027 2109 2028
  t 2027 2108 2109
  t 2028 2110 2029
  t 2028 2109 2110
  t 2029 2111 2030
  t 2029 2110 2111
  t 2030 2112 2031
  t 2030 2111 2112
  t 2031 2113 2032
  t 2031 2112 2113
  t 2032 2114 2033
  t 2032 2113 2114
  t 2033 2115 2034
  t 2033 2114 2115
  t 2034 2116 2035
  t 2034 2115 2116
  t 2035 2117 2036
  t 2035 2116 2117
  t 2036 2118 2037
  t 2036 2117 2118
  t 2037 2119 2038
  t 2037 2118 2119
  t 2038 2120 2039
  t 2038 2119 2120
  t 2039 2121 2040
  t 2039 2120 2121
  t 2040 2122 2041
  t 2040 2121 2122
  t 2041 2123 2042
  t 2041 2122 2123
  t 2042 2124 2043
  t 2042 2123 2124
  t 2667 2125 2044
  t 2667 2670 2125
  t 2044 2126 2045
  t 2044 2125 2126
  t 2045 2127 2046
  t 2045 2126 2127
  t 2046 2128 2047
  t 2046 2127 2128
  t 2047 2129 2048
  t 2047 2128 2129
  t 2048 2130 2049
  t 2048 2129 2130
  t 2668 2131 2050
  t 2668 2671 2131
  t 2050 2132 2051
  t 2050 2131 2132
  t 2051 2133 2052
  t 2051 2132 2133
  t 2052 2134 2053
  t 2052 2133 2134
  t 2053 2135 2054
  t 2053 2134 2135
  t 2054 2136 2055
  t 2054 2135 2136
  t 2055 2137 2056
  t 2055 2136 2137
  t 2056 2138 2057
  t 2056 2137 2138
  t 2057 2139 2058
  t 2057 2138 2139
  t 2058 2140 2059
  t 2058 2139 2140
  t 2059 2141 2060
  t 2059 2140 2141
  t 2060 2142 2061
  t 2060 2141 2142
  t 2061 2143 2062
  t 2061 2142 2143
  t 2062 2144 2063
  t 2062 2143 2144
  t 2063 2145 2064
  t 2063 2144 2145
  t 2064 2146 2065
  t 2064 2145 2146
  t 2065 2147 2066
  t 2065 2146 2147
  t 2066 2148 2067
  t 2066 2147 2148
  t 2067 2149 2068
  t 2067 2148 2149
  t 2068 2150 2069
  t 2068 2149 2150
  t 2069 2151 2070
  t 2069 2150 2151
  t 2070 2152 2071
  t 2070 2151 2152
  t 2071 2153 2072
  t 2071 2152 2153
  t 2072 2154 2073
  t 2072 2153 2154
  t 2073 2155 2074
  t 2073 2154 2155
  t 2074 2156 2075
  t 2074 2155 2156
  t 2075 2157 2076
  t 2075 2156 2157
  t 2076 2158 2077
  t 2076 2157 2158
  t 2077 2159 2078
  t 2077 2158 2159
  t 2078 2160 2079
  t 2078 2159 2160
  t 2079 2161 2080
  t 2079 2160 2161
  t 2080 2162 2081
  t 2080 2161 2162
  t 2081 2163 2082
  t 2081 2162 2163
  t 2082 2164 2083
  t 2082 2163 2164
  t 2083 2165 2084
  t 2083 2164 2165
  t 2084 2166 2085
  t 2084 2165 2166
  t 2085 2167 2086
  t 2085 2166 2167
  t 2086 2168 2087
  t 2086 2167 2168
  t 2087 2169 2088
  t 2087 2168 2169
  t 2088 2170 2089
  t 2088 2169 2170
  t 2089 2171 2090
  t 2089 2170 2171
  t 2090 2172 2091
  t 2090 2171 2172
  t 2091 2173 2092
  t 2091 2172 2173
  t 2092 2174 2093
  t 2092 2173 2174
  t 2669 2175 2094
  t 2669 2672 2175
  t 2094 2176 2095
  t 2094 2175 2176
  t 2095 2177 2096
  t 2095 2176 2177
  t 2096 2178 2097
  t 2096 2177 2178
  t 2097 2179 2098
  t 2097 2178 2179
  t 2098 2180 2099
  t 2098 2179 2180
  t 2099 2181 2100
  t 2099 2180 2181
  t 2100 2182 2101
  t 2100 2181 2182
  t 2101 2183 2102
  t 2101 2182 2183
  t 2102 2184 2103
  t 2102 2183 2184
  t 2103 2185 2104
  t 2103 2184 2185
  t 2104 2186 2105
  t 2104 2185 2186
  t 2106 2188 2107
  t 2106 2187 2188
  t 2107 2189 2108
  t 2107 2188 2189
  t 2108 2190 2109
  t 2108 2189 2190
  t 2109 2191 2110
  t 2109 2190 2191
  t 2110 2192 2111
  t 2110 2191 2192
  t 2111 2193 2112
  t 2111 2192 2193
  t 2112 2194 2113
  t 2112 2193 2194
  t 2113 2195 2114
  t 2113 2194 2195
  t 2114 2196 2115
  t 2114 2195 2196
  t 2115 2197 2116
  t 2115 2196 2197
  t 2116 2198 2117
  t 2116 2197 2198
  t 2117 2199 2118
  t 2117 2198 2199
  t 2118 2200 2119
  t 2118 2199 2200
  t 2119 2201 2120
  t 2119 2200 2201
  t 2120 2202 2121
  t 2120 2201 2202
  t 2121 2203 2122
  t 2121 2202 2203
  t 2122 2204 2123
  t 2122 2203 2204
  t 2123 2205 2124
  t 2123 2204 2205
  t 2670 2206 2125
  t 2670 2673 2206
  t 2125 2207 2126
  t 2125 2206 2207
  t 2126 2208 2127
  t 2126 2207 2208
  t 2127 2209 2128
  t 2127 2208 2209
  t 2128 2210 2129
  t 2128 2209 2210
  t 2129 2211 2130
  t 2129 2210 2211
  t 2671 2212 2131
  t 2671 2674 2212
  t 2131 2213 2132
  t 2131 2212 2213
  t 2132 2214 2133
  t 2132 2213 2214
  t 2133 2215 2134
  t 2133 2214 2215
  t 2134 2216 2135
  t 2134 2215 2216
  t 2135 2217 2136
  t 2135 2216 2217
  t 2136 2218 2137
  t 2136 2217 2218
  t 2137 2219 2138
  t 2137 2218 2219
  t 2138 2220 2139
  t 2138 2219 2220
  t 2139 2221 2140
  t 2139 2220 2221
  t 2140 2222 2141
  t 2140 2221 2222
  t 2141 2223 2142
  t 2141 2222 2223
  t 2142 2224 2143
  t 2142 2223 2224
  t 2143 2225 2144
  t 2143 2224 2225
  t 2144 2226 2145
  t 2144 2225 2226
  t 2145 2227 2146
  t 2145 2226 2227
  t 2146 2228 2147
  t 2146 2227 2228
  t 2147 2229 2148
  t 2147 2228 2229
  t 2148 2230 2149
  t 2148 2229 2230
  t 2149 2231 2150
  t 2149 2230 2231
  t 2150 2232 2151
  t 2150 2231 2232
  t 2151 2233 2152
  t 2151 2232 2233
  t 2152 2234 2153
  t 2152 2233 2234
  t 2153 2235 2154
  t 2153 2234 2235
  t 2154 2236 2155
  t 2154 2235 2236
  t 2155 2237 2156
  t 2155 2236 2237
  t 2156 2238 2157
  t 2156 2237 2238
  t 2157 2239 2158
  t 2157 2238 2239
  t 2158 2240 2159
  t 2158 2239 2240
  t 2159 2241 2160
  t 2159 2240 2241
  t 2160 2242 2161
  t 2160 2241 2242
  t 2161 2243 2162
  t 2161 2242 2243
  t 2162 2244 2163
  t 2162 2243 2244
  t 2163 2245 2164
  t 2163 2244 2245
  t 2164 2246 2165
  t 2164 2245 2246
  t 2165 2247 2166
  t 2165 2246 2247
  t 2166 2248 2167
  t 2166 2247 2248
  t 2167 2249 2168
  t 2167 2248 2249
  t 2168 2250 2169
  t 2168 2249 2250
  t 2169 2251 2170
  t 2169 2250 2251
  t 2170 2252 2171
  t 2170 2251 2252
  t 2171 2253 2172
  t 2171 2252 2253
  t 2172 2254 2173
  t 2172 2253 2254
  t 2173 2255 2174
  t 2173 2254 2255
  t 2672 2256 2175
  t 2672 2675 2256
  t 2175 2257 2176
  t 2175 2256 2257
  t 2176 2258 2177
  t 2176 2257 2258
  t 2177 2259 2178
  t 2177 2258 2259
  t 2178 2260 2179
  t 2178 2259 2260
  t 2179 2261 2180
  t 2179 2260 2261
  t 2180 2262 2181
  t 2180 2261 2262
  t 2181 2263 2182
  t 2181 2262 2263
  t 2182 2264 2183
  t 2182 2263 2264
  t 2183 2265 2184
  t 2183 2264 2265
  t 2184 2266 2185
  t 2184 2265 2266
  t 2185 2267 2186
  t 2185 2266 2267
  t 2187 2269 2188
  t 2187 2268 2269
  t 2188 2270 2189
  t 2188 2269 2270
  t 2189 2271 2190
  t 2189 2270 2271
  t 2190 2272 2191
  t 2190 2271 2272
  t 2191 2273 2192
  t 2191 2272 2273
  t 2192 2274 2193
  t 2192 2273 2274
  t 2193 2275 2194
  t 2193 2274 2275
  t 2194 2276 2195
  t 2194 2275 2276
  t 2195 2277 2196
  t 2195 2276 2277
  t 2196 2278 2197
  t 2196 2277 2278
  t 2197 2279 2198
  t 2197 2278 2279
  t 2198 2280 2199
  t 2198 2279 2280
  t 2199 2281 2200
  t 2199 2280 2281
  t 2200 2282 2201
  t 2200 2281 2282
  t 2201 2283 2202
  t 2201 2282 2283
  t 2202 2284 2203
  t 2202 2283 2284
  t 2203 2285 2204
  t 2203 2284 2285
  t 2204 2286 2205
  t 2204 2285 2286
  t 2673 2287 2206
  t 2673 2676 2287
  t 2206 2288 2207
  t 2206 2287 2288
  t 2207 2289 2208
  t 2207 2288 2289
  t 2208 2290 2209
  t 2208 2289 2290
  t 2209 2291 2210
  t 2209 2290 2291
  t 2210 2292 2211
  t 2210 2291 2292
  t 2674 2293 2212
  t 2674 2677 2293
  t 2212 2294 2213
  t 2212 2293 2294
  t 2213 2295 2214
  t 2213 2294 2295
  t 2214 2296 2215
  t 2214 2295 2296
  t 2215 2297 2216
  t 2215 2296 2297
  t 2216 2298 2217
  t 2216 2297 2298
  t 2217 2299 2218
  t 2217 2298 2299
  t 2218 2300 2219
  t 2218 2299 2300
  t 2219 2301 2220
  t 2219 2300 2301
  t 2220 2302 2221
  t 2220 2301 2302
  t 2221 2303 2222
  t 2221 2302 2303
  t 2222 2304 2223
  t 2222 2303 2304
  t 2223 2305 2224
  t 2223 2304 2305
  t 2224 2306 2225
  t 2224 2305 2306
  t 2225 2307 2226
  t 2225 2306 2307
  t 2226 2308 2227
  t 2226 2307 2308
  t 2227 2309 2228
  t 2227 2308 2309
  t 2228 2310 2229
  t 2228 2309 2310
  t 2229 2311 2230
  t 2229 2310 2311
  t 2230 2312 2231
  t 2230 2311 2312
  t 2231 2313 2232
  t 2231 2312 2313
  t 2232 2314 2233
  t 2232 2313 2314
  t 2233 2315 2234
  t 2233 2314 2315
  t 2234 2316 2235
  t 2234 2315 2316
  t 2235 2317 2236
  t 2235 2316 2317
  t 2236 2318 2237
  t 2236 2317 2318
  t 2237 2319 2238
  t 2237 2318 2319
  t 2238 2320 2239
  t 2238 2319 2320
  t 2239 2321 2240
  t 2239 2320 2321
  t 2240 2322 2241
  t 2240 2321 2322
  t 2241 2323 2242
  t 2241 2322 2323
  t 2242 2324 2243
  t 2242 2323 2324
  t 2243 2325 2244
  t 2243 2324 2325
  t 2244 2326 2245
  t 2244 2325 2326
  t 2245 2327 2246
  t 2245 2326 2327
  t 2246 2328 2247
  t 2246 2327 2328
  t 2247 2329 2248
  t 2247 2328 2329
  t 2248 2330 2249
  t 2248 2329 2330
  t 2249 2331 2250
  t 2249 2330 2331
  t 2250 2332 2251
  t 2250 2331 2332
  t 2251 2333 2252
  t 2251 2332 2333
  t 2252 2334 2253
  t 2252 2333 2334
  t 2253 2335 2254
  t 2253 2334 2335
  t 2254 2336 2255
  t 2254 2335 2336
  t 2675 2337 2256
  t 2675 2678 2337
  t 2256 2338 2257
  t 2256 2337 2338
  t 2257 2339 2258
  t 2257 2338 2339
  t 2258 2340 2259
  t 2258 2339 2340
  t 2259 2341 2260
  t 2259 2340 2341
  t 2260 2342 2261
  t 2260 2341 2342
  t 2261 2343 2262
  t 2261 2342 2343
  t 2262 2344 2263
  t 2262 2343 2344
  t 2263 2345 2264
  t 2263 2344 2345
  t 2264 2346 2265
  t 2264 2345 2346
  t 2265 2347 2266
  t 2265 2346 2347
  t 2266 2348 2267
  t 2266 2347 2348
  t 2268 2350 2269
  t 2268 2349 2350
  t 2269 2351 2270
  t 2269 2350 2351
  t 2270 2352 2271
  t 2270 2351 2352
  t 2271 2353 2272
  t 2271 2352 2353
  t 2272 2354 2273
  t 2272 2353 2354
  t 2273 2355 2274
  t 2273 2354 2355
  t 2274 2356 2275
  t 2274 2355 2356
  t 2275 2357 2276
  t 2275 2356 2357
  t 2276 2358 2277
  t 2276 2357 2358
  t 2277 2359 2278
  t 2277 2358 2359
  t 2278 2360 2279
  t 2278 2359 2360
  t 2279 2361 2280
  t 2279 2360 2361
  t 2280 2362 2281
  t 2280 2361 2362
  t 2281 2363 2282
  t 2281 2362 2363
  t 2282 2364 2283
  t 2282 2363 2364
  t 2283 2365 2284
  t 2283 2364 2365
  t 2284 2366 2285
  t 2284 2365 2366
  t 2285 2367 2286
  t 2285 2366 2367
  t 2676 2368 2287
  t 2676 2679 2368
  t 2287 2369 2288
  t 2287 2368 2369
  t 2288 2370 2289
  t 2288 2369 2370
  t 2289 2371 2290
  t 2289 2370 2371
  t 2290 2372 2291
  t 2290 2371 2372
  t 2291 2373 2292
  t 2291 2372 2373
  t 2677 2374 2293
  t 2677 2680 2374
  t 2293 2375 2294
  t 2293 2374 2375
  t 2294 2376 2295
  t 2294 2375 2376
  t 2295 2377 2296
  t 2295 2376 2377
  t 2296 2378 2297
  t 2296 2377 2378
  t 2297 2379 2298
  t 2297 2378 2379
  t 2298 2380 2299
  t 2298 2379 2380
  t 2299 2381 2300
  t 2299 2380 2381
  t 2300 2382 2301
  t 2300 2381 2382
  t 2301 2383 2302
  t 2301 2382 2383
  t 2302 2384 2303
  t 2302 2383 2384
  t 2303 2385 2304
  t 2303 2384 2385
  t 2304 2386 2305
  t 2304 2385 2386
  t 2305 2387 2306
  t 2305 2386 2387
  t 2306 2388 2307
  t 2306 2387 2388
  t 2307 2389 2308
  t 2307 2388 2389
  t 2308 2390 2309
  t 2308 2389 2390
  t 2309 2391 2310
  t 2309 2390 2391
  t 2310 2392 2311
  t 2310 2391 2392
  t 2311 2393 2312
  t 2311 2392 2393
  t 2312 2394 2313
  t 2312 2393 2394
  t 2313 2395 2314
  t 2313 2394 2395
  t 2314 2396 2315
  t 2314 2395 2396
  t 2315 2397 2316
  t 2315 2396 2397
  t 2316 2398 2317
  t 2316 2397 2398
  t 2317 2399 2318
  t 2317 2398 2399
  t 2318 2400 2319
  t 2318 2399 2400
  t 2319 2401 2320
  t 2319 2400 2401
  t 2320 2402 2321
  t 2320 2401 2402
  t 2321 2403 2322
  t 2321 2402 2403
  t 2322 2404 2323
  t 2322 2403 2404
  t 2323 2405 2324
  t 2323 2404 2405
  t 2324 2406 2325
  t 2324 2405 2406
  t 2325 2407 2326
  t 2325 2406 2407
  t 2326 2408 2327
  t 2326 2407 2408
  t 2327 2409 2328
  t 2327 2408 2409
  t 2328 2410 2329
  t 2328 2409 2410
  t 2329 2411 2330
  t 2329 2410 2411
  t 2330 2412 2331
  t 2330 2411 2412
  t 2331 2413 2332
  t 2331 2412 2413
  t 2332 2414 2333
  t 2332 2413 2414
  t 2333 2415 2334
  t 2333 2414 2415
  t 2334 2416 2335
  t 2334 2415 2416
  t 2335 2417 2336
  t 2335 2416 2417
  t 2678 2418 2337
  t 2678 2681 2418
  t 2337 2419 2338
  t 2337 2418 2419
  t 2338 2420 2339
  t 2338 2419 2420
  t 2339 2421 2340
  t 2339 2420 2421
  t 2340 2422 2341
  t 2340 2421 2422
  t 2341 2423 2342
  t 2341 2422 2423
  t 2342 2424 2343
  t 2342 2423 2424
  t 2343 2425 2344
  t 2343 2424 2425
  t 2344 2426 2345
  t 2344 2425 2426
  t 2345 2427 2346
  t 2345 2426 2427
  t 2346 2428 2347
  t 2346 2427 2428
  t 2347 2429 2348
  t 2347 2428 2429
  t 2349 2431 2350
  t 2349 2430 2431
  t 2350 2432 2351
  t 2350 2431 2432
  t 2351 2433 2352
  t 2351 2432 2433
  t 2352 2434 2353
  t 2352 2433 2434
  t 2353 2435 2354
  t 2353 2434 2435
  t 2354 2436 2355
  t 2354 2435 2436
  t 2355 2437 2356
  t 2355 2436 2437
  t 2356 2438 2357
  t 2356 2437 2438
  t 2357 2439 2358
  t 2357 2438 2439
  t 2358 2440 2359
  t 2358 2439 2440
  t 2359 2441 2360
  t 2359 2440 2441
  t 2360 2442 2361
  t 2360 2441 2442
  t 2361 2443 2362
  t 2361 2442 2443
  t 2362 2444 2363
  t 2362 2443 2444
  t 2363 2445 2364
  t 2363 2444 2445
  t 2364 2446 2365
  t 2364 2445 2446
  t 2365 2447 2366
  t 2365 2446 2447
  t 2366 2448 2367
  t 2366 2447 2448
  t 2679 2449 2368
  t 2679 2682 2449
  t 2368 2450 2369
  t 2368 2449 2450
  t 2369 2451 2370
  t 2369 2450 2451
  t 2370 2452 2371
  t 2370 2451 2452
  t 2371 2453 2372
  t 2371 2452 2453
  t 2372 2454 2373
  t 2372 2453 2454
  t 2680 2455 2374
  t 2680 2683 2455
  t 2374 2456 2375
  t 2374 2455 2456
  t 2375 2457 2376
  t 2375 2456 2457
  t 2376 2458 2377
  t 2376 2457 2458
  t 2377 2459 2378
  t 2377 2458 2459
  t 2378 2460 2379
  t 2378 2459 2460
  t 2379 2461 2380
  t 2379 2460 2461
  t 2380 2462 2381
  t 2380 2461 2462
  t 2381 2463 2382
  t 2381 2462 2463
  t 2382 2464 2383
  t 2382 2463 2464
  t 2383 2465 2384
  t 2383 2464 2465
  t 2384 2466 2385
  t 2384 2465 2466
  t 2385 2467 2386
  t 2385 2466 2467
  t 2386 2468 2387
  t 2386 2467 2468
  t 2387 2469 2388
  t 2387 2468 2469
  t 2388 2470 2389
  t 2388 2469 2470
  t 2389 2471 2390
  t 2389 2470 2471
  t 2390 2472 2391
  t 2390 2471 2472
  t 2391 2473 2392
  t 2391 2472 2473
  t 2392 2474 2393
  t 2392 2473 2474
  t 2393 2475 2394
  t 2393 2474 2475
  t 2394 2476 2395
  t 2394 2475 2476
  t 2395 2477 2396
  t 2395 2476 2477
  t 2396 2478 2397
  t 2396 2477 2478
  t 2397 2479 2398
  t 2397 2478 2479
  t 2398 2480 2399
  t 2398 2479 2480
  t 2399 2481 2400
  t 2399 2480 2481
  t 2400 2482 2401
  t 2400 2481 2482
  t 2401 2483 2402
  t 2401 2482 2483
  t 2402 2484 2403
  t 2402 2483 2484
  t 2403 2485 2404
  t 2403 2484 2485
  t 2404 2486 2405
  t 2404 2485 2486
  t 2405 2487 2406
  t 2405 2486 2487
  t 2406 2488 2407
  t 2406 2487 2488
  t 2407 2489 2408
  t 2407 2488 2489
  t 2408 2490 2409
  t 2408 2489 2490
  t 2409 2491 2410
  t 2409 2490 2491
  t 2410 2492 2411
  t 2410 2491 2492
  t 2411 2493 2412
  t 2411 2492 2493
  t 2412 2494 2413
  t 2412 2493 2494
  t 2413 2495 2414
  t 2413 2494 2495
  t 2414 2496 2415
  t 2414 2495 2496
  t 2415 2497 2416
  t 2415 2496 2497
  t 2416 2498 2417
  t 2416 2497 2498
  t 2681 2499 2418
  t 2681 2684 2499
  t 2418 2500 2419
  t 2418 2499 2500
  t 2419 2501 2420
  t 2419 2500 2501
  t 2420 2502 2421
  t 2420 2501 2502
  t 2421 2503 2422
  t 2421 2502 2503
  t 2422 2504 2423
  t 2422 2503 2504
  t 2423 2505 2424
  t 2423 2504 2505
  t 2424 2506 2425
  t 2424 2505 2506
  t 2425 2507 2426
  t 2425 2506 2507
  t 2426 2508 2427
  t 2426 2507 2508
  t 2427 2509 2428
  t 2427 2508 2509
  t 2428 2510 2429
  t 2428 2509 2510
  t 2430 2512 2431
  t 2430 2511 2512
  t 2431 2513 2432
  t 2431 2512 2513
  t 2432 2514 2433
  t 2432 2513 2514
  t 2433 2515 2434
  t 2433 2514 2515
  t 2434 2516 2435
  t 2434 2515 2516
  t 2435 2517 2436
  t 2435 2516 2517
  t 2436 2518 2437
  t 2436 2517 2518
  t 2437 2519 2438
  t 2437 2518 2519
  t 2438 2520 2439
  t 2438 2519 2520
  t 2439 2521 2440
  t 2439 2520 2521
  t 2440 2522 2441
  t 2440 2521 2522
  t 2441 2523 2442
  t 2441 2522 2523
  t 2442 2524 2443
  t 2442 2523 2524
  t 2443 2525 2444
  t 2443 2524 2525
  t 2444 2526 2445
  t 2444 2525 2526
  t 2445 2527 2446
  t 2445 2526 2527
  t 2446 2528 2447
  t 2446 2527 2528
  t 2447 2529 2448
  t 2447 2528 2529
  t 2682 2530 2449
  t 2682 2685 2530
  t 2449 2531 2450
  t 2449 2530 2531
  t 2450 2532 2451
  t 2450 2531 2532
  t 2451 2533 2452
  t 2451 2532 2533
  t 2452 2534 2453
  t 2452 2533 2534
  t 2453 2535 2454
  t 2453 2534 2535
  t 2683 2536 2455
  t 2683 2686 2536
  t 2455 2537 2456
  t 2455 2536 2537
  t 2456 2538 2457
  t 2456 2537 2538
  t 2457 2539 2458
  t 2457 2538 2539
  t 2458 2540 2459
  t 2458 2539 2540
  t 2459 2541 2460
  t 2459 2540 2541
  t 2460 2542 2461
  t 2460 2541 2542
  t 2461 2543 2462
  t 2461 2542 2543
  t 2462 2544 2463
  t 2462 2543 2544
  t 2463 2545 2464
  t 2463 2544 2545
  t 2464 2546 2465
  t 2464 2545 2546
  t 2465 2547 2466
  t 2465 2546 2547
  t 2466 2548 2467
  t 2466 2547 2548
  t 2467 2549 2468
  t 2467 2548 2549
  t 2468 2550 2469
  t 2468 2549 2550
  t 2469 2551 2470
  t 2469 2550 2551
  t 2470 2552 2471
  t 2470 2551 2552
  t 2471 2553 2472
  t 2471 2552 2553
  t 2472 2554 2473
  t 2472 2553 2554
  t 2473 2555 2474
  t 2473 2554 2555
  t 2474 2556 2475
  t 2474 2555 2556
  t 2475 2557 2476
  t 2475 2556 2557
  t 2476 2558 2477
  t 2476 2557 2558
  t 2477 2559 2478
  t 2477 2558 2559
  t 2478 2560 2479
  t 2478 2559 2560
  t 2479 2561 2480
  t 2479 2560 2561
  t 2480 2562 2481
  t 2480 2561 2562
  t 2481 2563 2482
  t 2481 2562 2563
  t 2482 2564 2483
  t 2482 2563 2564
  t 2483 2565 2484
  t 2483 2564 2565
  t 2484 2566 2485
  t 2484 2565 2566
  t 2485 2567 2486
  t 2485 2566 2567
  t 2486 2568 2487
  t 2486 2567 2568
  t 2487 2569 2488
  t 2487 2568 2569
  t 2488 2570 2489
  t 2488 2569 2570
  t 2489 2571 2490
  t 2489 2570 2571
  t 2490 2572 2491
  t 2490 2571 2572
  t 2491 2573 2492
  t 2491 2572 2573
  t 2492 2574 2493
  t 2492 2573 2574
  t 2493 2575 2494
  t 2493 2574 2575
  t 2494 2576 2495
  t 2494 2575 2576
  t 2495 2577 2496
  t 2495 2576 2577
  t 2496 2578 2497
  t 2496 2577 2578
  t 2497 2579 2498
  t 2497 2578 2579
  t 2684 2580 2499
  t 2684 2687 2580
  t 2499 2581 2500
  t 2499 2580 2581
  t 2500 2582 2501
  t 2500 2581 2582
  t 2501 2583 2502
  t 2501 2582 2583
  t 2502 2584 2503
  t 2502 2583 2584
  t 2503 2585 2504
  t 2503 2584 2585
  t 2504 2586 2505
  t 2504 2585 2586
  t 2505 2587 2506
  t 2505 2586 2587
  t 2506 2588 2507
  t 2506 2587 2588
  t 2507 2589 2508
  t 2507 2588 2589
  t 2508 2590 2509
  t 2508 2589 2590
  t 2509 2591 2510
  t 2509 2590 2591
  t 2511 1 2512
  t 2511 0 1
  t 2512 2 2513
  t 2512 1 2
  t 2513 3 2514
  t 2513 2 3
  t 2514 4 2515
  t 2514 3 4
  t 2515 5 2516
  t 2515 4 5
  t 2516 6 2517
  t 2516 5 6
  t 2517 7 2518
  t 2517 6 7
  t 2518 8 2519
  t 2518 7 8
  t 2519 9 2520
  t 2519 8 9
  t 2520 10 2521
  t 2520 9 10
  t 2521 11 2522
  t 2521 10 11
  t 2522 12 2523
  t 2522 11 12
  t 2523 13 2524
  t 2523 12 13
  t 2524 14 2525
  t 2524 13 14
  t 2525 15 2526
  t 2525 14 15
  t 2526 16 2527
  t 2526 15 16
  t 2527 17 2528
  t 2527 16 17
  t 2528 18 2529
  t 2528 17 18
  t 2685 19 2530
  t 2685 2592 19
  t 2530 20 2531
  t 2530 19 20
  t 2531 21 2532
  t 2531 20 21
  t 2532 22 2533
  t 2532 21 22
  t 2533 23 2534
  t 2533 22 23
  t 2534 24 2535
  t 2534 23 24
  t 2686 25 2536
  t 2686 2593 25
  t 2536 26 2537
  t 2536 25 26
  t 2537 27 2538
  t 2537 26 27
  t 2538 28 2539
  t 2538 27 28
  t 2539 29 2540
  t 2539 28 29
  t 2540 30 2541
  t 2540 29 30
  t 2541 31 2542
  t 2541 30 31
  t 2542 32 2543
  t 2542 31 32
  t 2543 33 2544
  t 2543 32 33
  t 2544 34 2545
  t 2544 33 34
  t 2545 35 2546
  t 2545 34 35
  t 2546 36 2547
  t 2546 35 36
  t 2547 37 2548
  t 2547 36 37
  t 2548 38 2549
  t 2548 37 38
  t 2549 39 2550
  t 2549 38 39
  t 2550 40 2551
  t 2550 39 40
  t 2551 41 2552
  t 2551 40 41
  t 2552 42 2553
  t 2552 41 42
  t 2553 43 2554
  t 2553 42 43
  t 2554 44 2555
  t 2554 43 44
  t 2555 45 2556
  t 2555 44 45
  t 2556 46 2557
  t 2556 45 46
  t 2557 47 2558
  t 2557 46 47
  t 2558 48 2559
  t 2558 47 48
  t 2559 49 2560
  t 2559 48 49
  t 2560 50 2561
  t 2560 49 50
  t 2561 51 2562
  t 2561 50 51
  t 2562 52 2563
  t 2562 51 52
  t 2563 53 2564
  t 2563 52 53
  t 2564 54 2565
  t 2564 53 54
  t 2565 55 2566
  t 2565 54 55
  t 2566 56 2567
  t 2566 55 56
  t 2567 57 2568
  t 2567 56 57
  t 2568 58 2569
  t 2568 57 58
  t 2569 59 2570
  t 2569 58 59
  t 2570 60 2571
  t 2570 59 60
  t 2571 61 2572
  t 2571 60 61
  t 2572 62 2573
  t 2572 61 62
  t 2573 63 2574
  t 2573 62 63
  t 2574 64 2575
  t 2574 63 64
  t 2575 65 2576
  t 2575 64 65
  t 2576 66 2577
  t 2576 65 66
  t 2577 67 2578
  t 2577 66 67
  t 2578 68 2579
  t 2578 67 68
  t 2687 69 2580
  t 2687 2594 69
  t 2580 70 2581
  t 2580 69 70
  t 2581 71 2582
  t 2581 70 71
  t 2582 72 2583
  t 2582 71 72
  t 2583 73 2584
  t 2583 72 73
  t 2584 74 2585
  t 2584 73 74
  t 2585 75 2586
  t 2585 74 75
  t 2586 76 2587
  t 2586 75 76
  t 2587 77 2588
  t 2587 76 77
  t 2588 78 2589
  t 2588 77 78
  t 2589 79 2590
  t 2589 78 79
  t 2590 80 2591
  t 2590 79 80
}

object {
  shader GlassCognac
  type mesh
  name GlassCognac
  1470 2880
  v 0 3.8 6.5    0.0355378 -0.999126 0.0220227    0 0
  v 0 3.79 6.05    -0.000200915 -0.997055 0.076692    0 0
  v 0 3.73 5.6    -0.00125962 -0.967752 0.251901    0 0
  v 0 3.55 5.15    -0.00280517 -0.869057 0.494704    0 0
  v 0 3.2 4.7    -0.00400958 -0.701311 0.712845    0 0
  v 0 2.7 4.33    -0.00303743 -0.535395 0.844597    0 0
  v 0 1.98 3.95    -0.00278433 -0.423327 0.905973    0 0
  v 0 1.06 3.58    -0.00278745 -0.357917 0.933749    0 0
  v 0 0 3.2    0.923105 0.000725678 -0.384548    0 0
  v -3.61401 1.17426 6.5    0.961207 -0.274948 0.0220212    0 0
  v -3.6045 1.17117 6.05    0.948193 -0.308298 0.0766928    0 0
  v -3.54744 1.15263 5.6    0.919997 -0.30025 0.251903    0 0
  v -3.37625 1.09701 5.15    0.825655 -0.271221 0.494705    0 0
  v -3.04338 0.988854 4.7    0.665747 -0.22053 0.712844    0 0
  v -2.56785 0.834346 4.33    0.508252 -0.168335 0.844597    0 0
  v -1.88309 0.611854 3.95    0.401747 -0.133463 0.905973    0 0
  v -1.00812 0.327558 3.58    0.339538 -0.113254 0.933749    0 0
  v 1.0655e-007 0 3.2    0.255577 -0.319964 0.912307    0 0
  v -2.23358 -3.07427 6.5    0.558521 0.829198 0.0220246    0 0
  v -2.22771 -3.06617 6.05    0.586217 0.806516 0.0766962    0 0
  v -2.19244 -3.01763 5.6    0.569849 0.782187 0.251904    0 0
  v -2.08664 -2.87201 5.15    0.513088 0.701433 0.494705    0 0
  v -1.88091 -2.58885 4.7    0.415464 0.565015 0.712844    0 0
  v -1.58702 -2.18435 4.33    0.317154 0.431358 0.844597    0 0
  v -1.16381 -1.60185 3.95    0.251078 0.340842 0.905973    0 0
  v -0.623052 -0.857558 3.58    0.212634 0.287923 0.933749    0 0
  v 1.93612e-008 -2.38419e-007 3.2    0.620344 -0.148488 0.770145    0 0
  v 2.23358 -3.07426 6.5    -0.616022 0.787421 0.0220248    0 0
  v 2.22771 -3.06617 6.05    -0.585891 0.806752 0.0766966    0 0
  v 2.19244 -3.01763 5.6    -0.567811 0.783669 0.2519    0 0
  v 2.08664 -2.87201 5.15    -0.508549 0.704731 0.494704    0 0
  v 1.88091 -2.58885 4.7    -0.408975 0.569728 0.712846    0 0
  v 1.58702 -2.18435 4.33    -0.312239 0.434928 0.844597    0 0
  v 1.16382 -1.60185 3.95    -0.246572 0.344115 0.905973    0 0
  v 0.623052 -0.857558 3.58    -0.208123 0.2912 0.933749    0 0
  v -1.55862e-008 0 3.2    0.352223 0.528149 0.772656    0 0
  v 3.61401 1.17427 6.5    -0.939243 -0.342545 0.0220234    0 0
  v 3.6045 1.17117 6.05    -0.948317 -0.307916 0.076693    0 0
  v 3.54744 1.15263 5.6    -0.920776 -0.297854 0.251902    0 0
  v 3.37625 1.09701 5.15    -0.827388 -0.265885 0.494705    0 0
  v 3.04338 0.988855 4.7    -0.668225 -0.212904 0.712844    0 0
  v 2.56785 0.834346 4.33    -0.510129 -0.162557 0.844597    0 0
  v 1.88309 0.611854 3.95    -0.403468 -0.128167 0.905973    0 0
  v 1.00812 0.327558 3.58    -0.341261 -0.107951 0.933749    0 0
  v 5.11372e-008 0 3.2    -0.0033161 -0.749141 0.662403    0 0
  v -0.8038 3.71419 6.5    0.244765 -0.969352 0.0211574    0 0
  v -1.55536 3.46706 6.5    0.440436 -0.897557 0.020183    0 0
  v -2.23343 3.07405 6.5    0.61519 -0.788126 0.0199674    0 0
  v -2.81673 2.55062 6.5    0.764093 -0.644775 0.0206741    0 0
  v -3.28402 1.91221 6.5    0.881737 -0.471241 0.0217309    0 0
  v -3.61243 1.17375 6.425    0.950821 -0.308948 0.022147    0 0
  v -3.61084 1.17323 6.35    0.950822 -0.308932 0.0223069    0 0
  v -3.60926 1.17272 6.275    0.950823 -0.308927 0.0223588    0 0
  v -3.60767 1.1722 6.2    0.950822 -0.308932 0.0223066    0 0
  v -3.60609 1.17169 6.125    0.950821 -0.308947 0.0221453    0 0
  v -3.27537 1.90718 6.05    0.862212 -0.500905 0.0753962    0 0
  v -2.80932 2.54391 6.05    0.73944 -0.669383 0.0717978    0 0
  v -2.22755 3.06596 6.05    0.586295 -0.807102 0.0696021    0 0
  v -1.55127 3.45793 6.05    0.407973 -0.910261 0.0705951    0 0
  v -0.801685 3.70442 6.05    0.20967 -0.974967 0.0740053    0 0
  v 0 3.79167 6.125    -6.24036e-006 -0.999755 0.0221437    0 0
  v 0 3.79333 6.2    8.44452e-006 -0.999751 0.0223085    0 0
  v 0 3.795 6.275    1.33074e-005 -0.99975 0.0223608    0 0
  v 0 3.79667 6.35    8.33207e-006 -0.999751 0.0223051    0 0
  v 0 3.79833 6.425    -6.81851e-006 -0.999755 0.0221457    0 0
  v -3.59499 1.16808 5.975    0.942752 -0.30637 0.131741    0 0
  v -3.58548 1.16499 5.9    0.942661 -0.306242 0.132685    0 0
  v -3.57597 1.1619 5.825    0.942632 -0.306196 0.133002    0 0
  v -3.56646 1.15881 5.75    0.942664 -0.306232 0.132691    0 0
  v -3.55695 1.15572 5.675    0.942757 -0.306353 0.131746    0 0
  v -3.22352 1.87698 5.6    0.837339 -0.487598 0.247208    0 0
  v -2.76485 2.50363 5.6    0.719812 -0.652697 0.236343    0 0
  v -2.19229 3.01742 5.6    0.571364 -0.787734 0.23026    0 0
  v -1.52671 3.40319 5.6    0.396974 -0.887506 0.233976    0 0
  v -0.788994 3.64577 5.6    0.202998 -0.948159 0.244514    0 0
  v 0 3.74 5.675    -3.11521e-005 -0.991284 0.131746    0 0
  v 0 3.75 5.75    5.47216e-005 -0.991158 0.132691    0 0
  v 0 3.76 5.825    7.9748e-005 -0.991115 0.133004    0 0
  v 0 3.77 5.9    4.51219e-005 -0.991158 0.132685    0 0
  v 0 3.78 5.975    -4.84246e-005 -0.991284 0.131742    0 0
  v -3.51891 1.14336 5.525    0.88338 -0.287216 0.370334    0 0
  v -3.49038 1.13409 5.45    0.882584 -0.286654 0.37266    0 0
  v -3.46185 1.12482 5.375    0.882317 -0.286439 0.373456    0 0
  v -3.43331 1.11555 5.3    0.88259 -0.28658 0.372702    0 0
  v -3.40478 1.10628 5.225    0.883406 -0.28709 0.370369    0 0
  v -3.06796 1.7864 5.15    0.754376 -0.441296 0.485978    0 0
  v -2.63142 2.38282 5.15    0.65342 -0.594444 0.468699    0 0
  v -2.08649 2.87181 5.15    0.520441 -0.719462 0.459908    0 0
  v -1.45304 3.23896 5.15    0.360089 -0.807548 0.467122    0 0
  v -0.750919 3.46984 5.15    0.181966 -0.855775 0.484291    0 0
  v 0 3.58 5.225    -5.10224e-005 -0.928885 0.370369    0 0
  v 0 3.61 5.3    0.000181065 -0.927951 0.372703    0 0
  v 0 3.64 5.375    0.000231686 -0.927648 0.373456    0 0
  v 0 3.67 5.45    0.00010931 -0.927967 0.372662    0 0
  v 0 3.7 5.525    -0.000179188 -0.928899 0.370332    0 0
  v -3.32077 1.07898 5.075    0.751568 -0.24457 0.612643    0 0
  v -3.26529 1.06096 5    0.74967 -0.2434 0.615428    0 0
  v -3.20982 1.04293 4.925    0.749026 -0.242938 0.616393    0 0
  v -3.15434 1.02491 4.85    0.74965 -0.24321 0.615527    0 0
  v -3.09886 1.00688 4.775    0.751592 -0.244265 0.612735    0 0
  v -2.76549 1.61028 4.7    0.612243 -0.360417 0.703746    0 0
  v -2.37199 2.14789 4.7    0.536357 -0.49023 0.687019    0 0
  v -1.88078 2.58868 4.7    0.429267 -0.595573 0.678986    0 0
  v -1.30978 2.91963 4.7    0.295069 -0.664177 0.686879    0 0
  v -0.676885 3.12774 4.7    0.146639 -0.695193 0.703707    0 0
  v 0 3.25833 4.775    -5.46152e-005 -0.790288 0.612735    0 0
  v 0 3.31667 4.85    0.000347869 -0.788115 0.615527    0 0
  v 0 3.375 4.925    0.000414477 -0.787438 0.616394    0 0
  v 0 3.43333 5    0.000173786 -0.788193 0.615429    0 0
  v 0 3.49167 5.075    -0.000352205 -0.790359 0.612643    0 0
  v -2.96413 0.963103 4.63833    0.566867 -0.184648 0.80285    0 0
  v -2.88487 0.937352 4.57667    0.564405 -0.183171 0.80492    0 0
  v -2.80562 0.9116 4.515    0.563548 -0.182569 0.805656    0 0
  v -2.72636 0.885849 4.45333    0.564323 -0.182893 0.80504    0 0
  v -2.64711 0.860097 4.39167    0.566841 -0.184238 0.802962    0 0
  v -2.33338 1.35867 4.33    0.47049 -0.276902 0.837833    0 0
  v -2.00136 1.81228 4.33    0.416673 -0.380453 0.825615    0 0
  v -1.58691 2.18419 4.33    0.335197 -0.464183 0.819864    0 0
  v -1.10513 2.46344 4.33    0.229394 -0.514917 0.825978    0 0
  v -0.571121 2.63903 4.33    0.112918 -0.533403 0.83829    0 0
  v 0 2.78333 4.39167    -5.68911e-005 -0.596031 0.802962    0 0
  v 0 2.86667 4.45333    0.00044423 -0.593219 0.805041    0 0
  v 0 2.95 4.515    0.000512572 -0.592384 0.805656    0 0
  v 0 3.03333 4.57667    0.000204772 -0.593383 0.80492    0 0
  v 0 3.11667 4.63833    -0.000439394 -0.596182 0.802849    0 0
  v -2.45373 0.797264 4.26667    0.445014 -0.145142 0.883684    0 0
  v -2.3396 0.760182 4.20333    0.442751 -0.143523 0.885083    0 0
  v -2.22547 0.7231 4.14    0.441926 -0.142819 0.885609    0 0
  v -2.11135 0.686018 4.07667    0.442575 -0.143151 0.885232    0 0
  v -1.99722 0.648936 4.01333    0.444867 -0.144739 0.883823    0 0
  v -1.71115 0.996361 3.95    0.373214 -0.219779 0.901337    0 0
  v -1.46767 1.32901 3.95    0.332613 -0.303311 0.892956    0 0
  v -1.16373 1.60174 3.95    0.268474 -0.370946 0.889    0 0
  v -0.810426 1.80652 3.95    0.183279 -0.410447 0.893276    0 0
  v -0.418822 1.93529 3.95    0.0895568 -0.422911 0.901735    0 0
  v 0 2.1 4.01333    -0.000184005 -0.467821 0.883823    0 0
  v 0 2.22 4.07667    0.000618155 -0.46515 0.885232    0 0
  v 0 2.34 4.14    0.000733448 -0.46443 0.885609    0 0
  v 0 2.46 4.20333    0.000319264 -0.465433 0.885083    0 0
  v 0 2.58 4.26667    -0.000521303 -0.468084 0.883684    0 0
  v -1.73726 0.564471 3.88833    0.355851 -0.116315 0.927276    0 0
  v -1.59143 0.517089 3.82667    0.35401 -0.114493 0.928207    0 0
  v -1.44561 0.469706 3.765    0.353284 -0.113559 0.928598    0 0
  v -1.29978 0.422323 3.70333    0.353703 -0.113836 0.928405    0 0
  v -1.15395 0.374941 3.64167    0.355458 -0.115979 0.927469    0 0
  v -0.916068 0.533406 3.58    0.316247 -0.185436 0.930377    0 0
  v -0.78572 0.711489 3.58    0.283451 -0.25618 0.924136    0 0
  v -0.623009 0.857498 3.58    0.229714 -0.314401 0.921078    0 0
  v -0.433865 0.967127 3.58    0.156591 -0.348278 0.92422    0 0
  v -0.224218 1.03606 3.58    0.0759208 -0.358202 0.930552    0 0
  v 0 1.21333 3.64167    -0.000459809 -0.373901 0.927469    0 0
  v 0 1.36667 3.70333    0.00103615 -0.371568 0.928405    0 0
  v 0 1.52 3.765    0.00116922 -0.371084 0.928599    0 0
  v 0 1.67333 3.82667    0.000506291 -0.372064 0.928207    0 0
  v 0 1.82667 3.88833    -0.000657993 -0.374379 0.927276    0 0
  v -0.8401 0.272965 3.51667    0.321852 -0.105962 0.940842    0 0
  v -0.67208 0.218372 3.45333    0.320663 -0.102988 0.941578    0 0
  v -0.50406 0.163779 3.39    0.320437 -0.0996775 0.942011    0 0
  v -0.33604 0.109186 3.32667    0.321745 -0.0936874 0.94218    0 0
  v -0.16802 0.0545931 3.26333    0.274231 -0.230634 0.933598    0 0
  v 6.1661e-008 2.38419e-007 3.2    0.0106912 -0.47533 0.879743    0 0
  v 3.15704e-008 2.38419e-007 3.2    0.00380004 -0.915573 0.402134    0 0
  v 1.33188e-008 0 3.2    0.543316 0.614188 -0.572346    0 0
  v 3.9463e-009 0 3.2    0.168505 0.398246 -0.901668    0 0
  v 4.93288e-010 0 3.2    0.0961495 0.34767 -0.932674    0 0
  v 0 0.176667 3.26333    -0.0126409 -0.33411 0.942449    0 0
  v 0 0.353333 3.32667    0.0103245 -0.334949 0.94218    0 0
  v 0 0.53 3.39    0.00422147 -0.335556 0.942011    0 0
  v 0 0.706667 3.45333    0.00114283 -0.336794 0.941578    0 0
  v 0 0.883333 3.51667    -0.0013178 -0.338844 0.940842    0 0
  v -3.78079 0.383288 6.5    0.997545 -0.0667608 0.0211562    0 0
  v -3.778 -0.407859 6.5    0.98973 0.14152 0.0201777    0 0
  v -3.61376 -1.17418 6.5    0.939656 0.341536 0.0199649    0 0
  v -3.2962 -1.89069 6.5    0.849335 0.527449 0.0206715    0 0
  v -2.83343 -2.53238 6.5    0.720648 0.69296 0.0217304    0 0
  v -2.2326 -3.07292 6.425    0.587647 0.808814 0.0221467    0 0
  v -2.23162 -3.07157 6.35    0.587632 0.808821 0.0223049    0 0
  v -2.23064 -3.07022 6.275    0.587628 0.808823 0.0223586    0 0
  v -2.22967 -3.06887 6.2    0.587632 0.808821 0.0223059    0 0
  v -2.22869 -3.06752 6.125    0.587646 0.808815 0.022145    0 0
  v -2.82598 -2.52572 6.05    0.742827 0.665224 0.0753963    0 0
  v -3.28753 -1.88571 6.05    0.865121 0.496398 0.0717973    0 0
  v -3.60425 -1.17109 6.05    0.948775 0.308191 0.0696021    0 0
  v -3.76806 -0.406786 6.05    0.99178 0.106719 0.0705955    0 0
  v -3.77084 0.382279 6.05    0.992041 -0.101873 0.0740061    0 0
  v -2.22183 -3.05808 5.975    0.582701 0.801937 0.131743    0 0
  v -2.21595 -3.04999 5.9    0.582552 0.801891 0.132683    0 0
  v -2.21007 -3.0419 5.825    0.582499 0.801877 0.132999    0 0
  v -2.20419 -3.03381 5.75    0.582544 0.801895 0.13269    0 0
  v -2.19832 -3.02572 5.675    0.582687 0.801947 0.131747    0 0
  v -2.78124 -2.48573 5.6    0.722485 0.64568 0.247208    0 0
  v -3.23548 -1.85586 5.6    0.843186 0.482888 0.236341    0 0
  v -3.54719 -1.15255 5.6    0.92574 0.299976 0.230259    0 0
  v -3.70841 -0.400346 5.6    0.96674 0.103291 0.233974    0 0
  v -3.71115 0.376227 5.6    0.964483 -0.0999348 0.244512    0 0
  v -2.17481 -2.99336 5.525    0.546138 0.751389 0.370334    0 0
  v -2.15717 -2.96909 5.45    0.545357 0.750806 0.372661    0 0
  v -2.13954 -2.94482 5.375    0.545071 0.75062 0.373453    0 0
  v -2.1219 -2.92055 5.3    0.545289 0.750834 0.372703    0 0
  v -2.10427 -2.89628 5.225    0.546026 0.751453 0.370369    0 0
  v -2.64702 -2.36578 5.15    0.652813 0.581087 0.485978    0 0
  v -3.07935 -1.7663 5.15    0.767268 0.437746 0.468698    0 0
  v -3.37602 -1.09693 5.15    0.845074 0.272644 0.459907    0 0
  v -3.52945 -0.381027 5.15    0.879297 0.092919 0.467121    0 0
  v -3.53206 0.358072 5.15    0.870121 -0.0913885 0.484292    0 0
  v -2.05235 -2.82482 5.075    0.464847 0.639207 0.612643    0 0
  v -2.01806 -2.77763 5    0.463147 0.637764 0.615428    0 0
  v -1.98377 -2.73043 4.925    0.462509 0.637295 0.616393    0 0
  v -1.94949 -2.68324 4.85    0.462961 0.637803 0.615528    0 0
  v -1.9152 -2.63605 4.775    0.464563 0.639324 0.612737    0 0
  v -2.38605 -2.13253 4.7    0.53197 0.470902 0.703746    0 0
  v -2.77575 -1.59216 4.7    0.631981 0.358617 0.687018    0 0
  v -3.04317 -0.988786 4.7    0.699075 0.224216 0.678986    0 0
  v -3.18148 -0.343461 4.7    0.722851 0.0753852 0.686879    0 0
  v -3.18383 0.322769 4.7    0.706482 -0.0753639 0.703707    0 0
  v -1.83193 -2.52144 4.63833    0.350783 0.482063 0.802849    0 0
  v -1.78295 -2.45402 4.57667    0.348616 0.480178 0.80492    0 0
  v -1.73397 -2.3866 4.515    0.34778 0.479549 0.805656    0 0
  v -1.68498 -2.31918 4.45333    0.348327 0.480186 0.80504    0 0
  v -1.636 -2.25176 4.39167    0.350384 0.482165 0.802962    0 0
  v -2.01323 -1.79932 4.33    0.408739 0.361895 0.837833    0 0
  v -2.34204 -1.34338 4.33    0.490591 0.278713 0.825614    0 0
  v -2.56767 -0.834289 4.33    0.545047 0.175351 0.819864    0 0
  v -2.68437 -0.289795 4.33    0.560602 0.0590483 0.825977    0 0
  v -2.68635 0.272336 4.33    0.54219 -0.0574396 0.83829    0 0
  v -1.51649 -2.08726 4.26667    0.275555 0.378381 0.883684    0 0
  v -1.44595 -1.99018 4.20333    0.273317 0.376731 0.885083    0 0
  v -1.37542 -1.8931 4.14    0.272392 0.376164 0.885609    0 0
  v -1.30488 -1.79602 4.07667    0.272908 0.376677 0.885232    0 0
  v -1.23435 -1.69894 4.01333    0.275127 0.378367 0.883823    0 0
  v -1.47637 -1.3195 3.95    0.324352 0.287032 0.901337    0 0
  v -1.71749 -0.985148 3.95    0.39125 0.222606 0.892956    0 0
  v -1.88296 -0.611812 3.95    0.435754 0.140705 0.889    0 0
  v -1.96854 -0.212516 3.95    0.446995 0.0474736 0.893276    0 0
  v -1.96999 0.199713 3.95    0.429887 -0.0455132 0.901735    0 0
  v -1.07369 -1.4778 3.88833    0.220587 0.302492 0.927276    0 0
  v -0.98356 -1.35376 3.82667    0.218284 0.301303 0.928207    0 0
  v -0.893433 -1.22971 3.765    0.217172 0.300901 0.928598    0 0
  v -0.803306 -1.10566 3.70333    0.217564 0.301214 0.928405    0 0
  v -0.713179 -0.981608 3.64167    0.220145 0.302222 0.927469    0 0
  v -0.790379 -0.706401 3.58    0.274085 0.243465 0.930377    0 0
  v -0.919466 -0.527402 3.58    0.331233 0.190414 0.924136    0 0
  v -1.00805 -0.327535 3.58    0.369998 0.121316 0.921078    0 0
  v -1.05386 -0.113771 3.58    0.379621 0.0413028 0.92422    0 0
  v -1.05464 0.106917 3.58    0.364131 -0.0384856 0.930552    0 0
  v -0.51921 -0.714632 3.51667    0.200234 0.273356 0.940842    0 0
  v -0.415368 -0.571705 3.45333    0.197038 0.273144 0.941578    0 0
  v -0.311526 -0.428779 3.39    0.19382 0.273952 0.942011    0 0
  v -0.207684 -0.285853 3.32667    0.188526 0.277047 0.94218    0 0
  v -0.103842 -0.142927 3.26333    0.253971 0.227458 0.940086    0 0
  v 1.16977e-008 0 3.2    0.569942 -0.278594 0.773015    0 0
  v 9.68296e-009 0 3.2    0.527079 0.219652 0.820939    0 0
  v 1.57389e-008 0 3.2    0.0564459 0.0693685 0.995993    0 0
  v 3.22875e-008 0 3.2    0.160239 -0.813941 0.558412    0 0
  v 6.17506e-008 0 3.2    0.132112 -0.632172 0.763482    0 0
  v -1.53286 -3.4773 6.5    0.371751 0.928091 0.0211543    0 0
  v -0.779569 -3.71913 6.5    0.17125 0.985021 0.0201805    0 0
  v 4.17233e-007 -3.79974 6.5    -0.0344508 0.999207 0.0199622    0 0
  v 0.77957 -3.71913 6.5    -0.239175 0.970756 0.0206725    0 0
  v 1.53286 -3.4773 6.5    -0.436351 0.899514 0.0217281    0 0
  v 2.2326 -3.07292 6.425    -0.587636 0.808823 0.0221478    0 0
  v 2.23162 -3.07157 6.35    -0.587646 0.808811 0.0223061    0 0
  v 2.23065 -3.07022 6.275    -0.587649 0.808807 0.0223569    0 0
  v 2.22967 -3.06887 6.2    -0.587646 0.808811 0.0223064    0 0
  v 2.22869 -3.06752 6.125    -0.587636 0.808822 0.0221437    0 0
  v 1.52882 -3.46815 6.05    -0.403119 0.912036 0.0753967    0 0
  v 0.777518 -3.70934 6.05    -0.204766 0.976174 0.0717932    0 0
  v 4.17233e-007 -3.78974 6.05    8.02999e-005 0.997575 0.069601    0 0
  v -0.777518 -3.70934 6.05    0.204981 0.976217 0.0705958    0 0
  v -1.52882 -3.46815 6.05    0.403444 0.912006 0.0740064    0 0
  v 2.22183 -3.05808 5.975    -0.582623 0.801994 0.131743    0 0
  v 2.21595 -3.04999 5.9    -0.582625 0.801837 0.132684    0 0
  v 2.21007 -3.0419 5.825    -0.582628 0.801783 0.133003    0 0
  v 2.2042 -3.03381 5.75    -0.582632 0.801831 0.132692    0 0
  v 2.19832 -3.02572 5.675    -0.582637 0.801984 0.131744    0 0
  v 1.50462 -3.41325 5.6    -0.390818 0.886651 0.247206    0 0
  v 0.765209 -3.65062 5.6    -0.198695 0.951138 0.236341    0 0
  v 3.8743e-007 -3.72974 5.6    0.000775057 0.973129 0.230258    0 0
  v -0.765209 -3.65062 5.6    0.200504 0.951343 0.233976    0 0
  v -1.50462 -3.41325 5.6    0.393085 0.886395 0.244515    0 0
  v 2.17481 -2.99336 5.525    -0.545848 0.7516 0.370335    0 0
  v 2.15717 -2.96909 5.45    -0.545534 0.750677 0.372661    0 0
  v 2.13954 -2.94482 5.375    -0.545446 0.750347 0.373455    0 0
  v 2.12191 -2.92055 5.3    -0.545583 0.750622 0.372702    0 0
  v 2.10427 -2.89628 5.225    -0.545944 0.751513 0.370369    0 0
  v 1.43201 -3.24853 5.15    -0.350916 0.800427 0.485978    0 0
  v 0.728282 -3.47445 5.15    -0.179223 0.864987 0.468697    0 0
  v 3.8743e-007 -3.54975 5.15    0.00184245 0.887966 0.459906    0 0
  v -0.728282 -3.47445 5.15    0.183347 0.864974 0.467122    0 0
  v -1.43201 -3.24854 5.15    0.355798 0.799294 0.484291    0 0
  v 2.05235 -2.82482 5.075    -0.464276 0.639621 0.612644    0 0
  v 2.01806 -2.77762 5    -0.463429 0.637559 0.615428    0 0
  v 1.98378 -2.73043 4.925    -0.463181 0.636808 0.616392    0 0
  v 1.94949 -2.68324 4.85    -0.463524 0.637394 0.615527    0 0
  v 1.9152 -2.63605 4.775    -0.464475 0.639388 0.612737    0 0
  v 1.29083 -2.92826 4.7    -0.283467 0.65145 0.703747    0 0
  v 0.65648 -3.1319 4.7    -0.145772 0.711868 0.687018    0 0
  v 3.42727e-007 -3.19978 4.7    0.00278423 0.734147 0.678985    0 0
  v -0.656479 -3.1319 4.7    0.151678 0.710768 0.686879    0 0
  v -1.29083 -2.92826 4.7    0.28999 0.648615 0.703708    0 0
  v 1.83193 -2.52144 4.63833    -0.350071 0.482579 0.80285    0 0
  v 1.78295 -2.45402 4.57667    -0.348949 0.479938 0.804919    0 0
  v 1.73397 -2.3866 4.515    -0.34861 0.478948 0.805655    0 0
  v 1.68498 -2.31918 4.45333    -0.349045 0.479663 0.805041    0 0
  v 1.636 -2.25176 4.39167    -0.350292 0.482232 0.802962    0 0
  v 1.08914 -2.47072 4.33    -0.217876 0.500566 0.837833    0 0
  v 0.553905 -2.64254 4.33    -0.113471 0.552707 0.825614    0 0
  v 3.12924e-007 -2.69981 4.33    0.00166023 0.572556 0.819864    0 0
  v -0.553904 -2.64254 4.33    0.117077 0.551411 0.825978    0 0
  v -1.08914 -2.47072 4.33    0.222174 0.497903 0.83829    0 0
  v 1.51649 -2.08726 4.26667    -0.274711 0.378994 0.883684    0 0
  v 1.44595 -1.99018 4.20333    -0.273833 0.376356 0.885083    0 0
  v 1.37542 -1.8931 4.14    -0.273579 0.375301 0.885609    0 0
  v 1.30488 -1.79602 4.07667    -0.273908 0.375951 0.885232    0 0
  v 1.23435 -1.69894 4.01333    -0.274829 0.378583 0.883823    0 0
  v 0.7987 -1.81186 3.95    -0.172754 0.397175 0.901337    0 0
  v 0.406197 -1.93786 3.95    -0.0908081 0.44089 0.892956    0 0
  v 2.23517e-007 -1.97986 3.95    0.000836775 0.457907 0.888999    0 0
  v -0.406197 -1.93786 3.95    0.092979 0.439788 0.893276    0 0
  v -0.798699 -1.81186 3.95    0.176128 0.394783 0.901735    0 0
  v 1.07369 -1.4778 3.88833    -0.219521 0.303265 0.927276    0 0
  v 0.983561 -1.35375 3.82667    -0.219103 0.300708 0.928207    0 0
  v 0.893434 -1.22971 3.765    -0.219064 0.299526 0.928598    0 0
  v 0.803307 -1.10566 3.70333    -0.219241 0.299996 0.928405    0 0
  v 0.713179 -0.981607 3.64167    -0.219401 0.302762 0.927469    0 0
  v 0.427587 -0.969985 3.58    -0.146852 0.335905 0.930377    0 0
  v 0.217459 -1.03744 3.58    -0.0787382 0.373862 0.924136    0 0
  v 1.11759e-007 -1.05993 3.58    -0.00104275 0.389378 0.921078    0 0
  v -0.217459 -1.03744 3.58    0.0780279 0.373804 0.92422    0 0
  v -0.427587 -0.969985 3.58    0.149125 0.334417 0.930552    0 0
  v 0.51921 -0.714632 3.51667    -0.198101 0.274905 0.940842    0 0
  v 0.415368 -0.571705 3.45333    -0.198887 0.271801 0.941578    0 0
  v 0.311526 -0.428779 3.39    -0.200651 0.268989 0.942011    0 0
  v 0.207684 -0.285853 3.32667    -0.205229 0.264912 0.94218    0 0
  v 0.103842 -0.142926 3.26333    -0.15765 0.299352 0.941029    0 0
  v -8.93018e-009 2.38419e-007 3.2    0.925549 0.372805 0.0661533    0 0
  v -3.90106e-009 2.38419e-007 3.2    -0.045075 0.574967 0.816934    0 0
  v 4.71871e-010 0 3.2    -0.999889 -0.00882205 -0.0119763    0 0
  v 5.15939e-009 0 3.2    -0.567854 -0.0282382 -0.822645    0 0
  v 1.11322e-008 -2.38419e-007 3.2    -0.522788 -0.0994549 -0.846641    0 0
  v 2.83343 -2.53238 6.5    -0.76779 0.640353 0.0211594    0 0
  v 3.2962 -1.89069 6.5    -0.883891 0.467256 0.0201793    0 0
  v 3.61376 -1.17418 6.5    -0.960948 0.276007 0.0199659    0 0
  v 3.778 -0.407859 6.5    -0.997153 0.0725109 0.020674    0 0
  v 3.78079 0.383289 6.5    -0.990329 -0.13703 0.0217315    0 0
  v 3.61243 1.17375 6.425    -0.950825 -0.308935 0.0221467    0 0
  v 3.61084 1.17324 6.35    -0.950817 -0.308948 0.0223069    0 0
  v 3.60926 1.17272 6.275    -0.950815 -0.308952 0.0223585    0 0
  v 3.60767 1.1722 6.2    -0.950817 -0.308948 0.0223057    0 0
  v 3.60609 1.17169 6.125    -0.950825 -0.308935 0.0221457    0 0
  v 3.77084 0.38228 6.05    -0.991969 -0.101555 0.0753954    0 0
  v 3.76806 -0.406785 6.05    -0.991673 0.10691 0.0717963    0 0
  v 3.60425 -1.17109 6.05    -0.948725 0.308344 0.0696005    0 0
  v 3.28753 -1.88571 6.05    -0.865095 0.496616 0.0705954    0 0
  v 2.82598 -2.52572 6.05    -0.742698 0.665524 0.0740068    0 0
  v 3.59499 1.16808 5.975    -0.942782 -0.306278 0.131741    0 0
  v 3.58548 1.16499 5.9    -0.942634 -0.306328 0.132685    0 0
  v 3.57597 1.1619 5.825    -0.942582 -0.306348 0.133002    0 0
  v 3.56646 1.15881 5.75    -0.94263 -0.306337 0.132691    0 0
  v 3.55695 1.15572 5.675    -0.942776 -0.306294 0.131746    0 0
  v 3.71115 0.376228 5.6    -0.964024 -0.0977005 0.247207    0 0
  v 3.70841 -0.400345 5.6    -0.965986 0.104948 0.236342    0 0
  v 3.5472 -1.15255 5.6    -0.925261 0.301451 0.230259    0 0
  v 3.23548 -1.85586 5.6    -0.842822 0.484672 0.233975    0 0
  v 2.78124 -2.48573 5.6    -0.721543 0.647757 0.244513    0 0
  v 3.51891 1.14336 5.525    -0.883491 -0.286875 0.370333    0 0
  v 3.49038 1.13409 5.45    -0.882516 -0.286862 0.372661    0 0
  v 3.46185 1.12482 5.375    -0.882174 -0.28688 0.373455    0 0
  v 3.43331 1.11555 5.3    -0.882478 -0.286925 0.372702    0 0
  v 3.40478 1.10628 5.225    -0.883438 -0.286993 0.370369    0 0
  v 3.53206 0.358072 5.15    -0.86969 -0.0863954 0.485978    0 0
  v 3.52945 -0.381026 5.15    -0.878034 0.0968445 0.468698    0 0
  v 3.37602 -1.09693 5.15    -0.843936 0.276149 0.459906    0 0
  v 3.07935 -1.7663 5.15    -0.765983 0.441665 0.467121    0 0
  v 2.64702 -2.36578 5.15    -0.650226 0.585379 0.48429    0 0
  v 3.32077 1.07898 5.075    -0.751786 -0.2439 0.612643    0 0
  v 3.26529 1.06096 5    -0.749562 -0.24373 0.615428    0 0
  v 3.20982 1.04293 4.925    -0.74877 -0.243726 0.616393    0 0
  v 3.15434 1.02491 4.85    -0.749434 -0.243872 0.615528    0 0
  v 3.09886 1.00688 4.775    -0.751625 -0.24416 0.612736    0 0
  v 3.18383 0.32277 4.7    -0.707162 -0.0682841 0.703746    0 0
  v 3.18148 -0.34346 4.7    -0.722073 0.0813414 0.687018    0 0
  v 3.04317 -0.988786 4.7    -0.697354 0.229512 0.678985    0 0
  v 2.77575 -1.59216 4.7    -0.62911 0.363894 0.686879    0 0
  v 2.38605 -2.13253 4.7    -0.527257 0.47623 0.703708    0 0
  v 2.96413 0.963103 4.63833    -0.567139 -0.183812 0.802849    0 0
  v 2.88487 0.937352 4.57667    -0.564278 -0.18356 0.80492    0 0
  v 2.80562 0.9116 4.515    -0.563232 -0.183544 0.805656    0 0
  v 2.72636 0.885849 4.45333    -0.564048 -0.183737 0.80504    0 0
  v 2.64711 0.860098 4.39167    -0.566876 -0.184129 0.802962    0 0
  v 2.68635 0.272337 4.33    -0.543394 -0.0525287 0.837833    0 0
  v 2.68437 -0.289794 4.33    -0.560721 0.0628786 0.825614    0 0
  v 2.56767 -0.834288 4.33    -0.544021 0.178509 0.819863    0 0
  v 2.34204 -1.34338 4.33    -0.488244 0.281742 0.825977    0 0
  v 2.01323 -1.79932 4.33    -0.404879 0.365161 0.83829    0 0
  v 2.45373 0.797264 4.26667    -0.445336 -0.14415 0.883684    0 0
  v 2.3396 0.760182 4.20333    -0.442554 -0.14413 0.885083    0 0
  v 2.22547 0.7231 4.14    -0.441473 -0.144214 0.885609    0 0
  v 2.11135 0.686018 4.07667    -0.442192 -0.144327 0.885232    0 0
  v 1.99722 0.648936 4.01333    -0.444981 -0.144389 0.883823    0 0
  v 1.96999 0.199714 3.95    -0.43112 -0.0415646 0.901337    0 0
  v 1.96854 -0.212516 3.95    -0.447372 0.0498788 0.892956    0 0
  v 1.88296 -0.611811 3.95    -0.435237 0.142297 0.889    0 0
  v 1.71749 -0.985148 3.95    -0.389531 0.22433 0.893276    0 0
  v 1.47637 -1.3195 3.95    -0.321034 0.289502 0.901735    0 0
  v 1.73726 0.564471 3.88833    -0.356258 -0.115063 0.927276    0 0
  v 1.59143 0.517089 3.82667    -0.353697 -0.115456 0.928207    0 0
  v 1.44561 0.469706 3.765    -0.352561 -0.115783 0.928598    0 0
  v 1.29978 0.422323 3.70333    -0.353062 -0.115806 0.928405    0 0
  v 1.15395 0.374941 3.64167    -0.355743 -0.115104 0.927469    0 0
  v 1.05464 0.106917 3.58    -0.364845 -0.0358646 0.930377    0 0
  v 1.05386 -0.113771 3.58    -0.379895 0.0406454 0.924136    0 0
  v 1.00805 -0.327535 3.58    -0.370643 0.119333 0.921078    0 0
  v 0.919467 -0.527403 3.58    -0.331397 0.189721 0.92422    0 0
  v 0.790379 -0.706401 3.58    -0.271967 0.245167 0.930552    0 0
  v 0.8401 0.272965 3.51667    -0.322667 -0.103455 0.940842    0 0
  v 0.67208 0.218372 3.45333    -0.319957 -0.105162 0.941578    0 0
  v 0.50406 0.163779 3.39    -0.317828 -0.107708 0.942011    0 0
  v 0.33604 0.109186 3.32667    -0.315365 -0.113323 0.94218    0 0
  v 0.16802 0.0545931 3.26333    -0.280284 -0.21439 0.93567    0 0
  v 2.95212e-008 2.38419e-007 3.2    0.022639 0.999734 -0.00438771    0 0
  v 1.45745e-008 2.38419e-007 3.2    -0.432638 0.267196 0.861064    0 0
  v 4.44388e-009 0 3.2    -0.324445 0.0352619 0.945247    0 0
  v -2.72417e-009 0 3.2    -0.113394 0.408643 0.905623    0 0
  v -8.78307e-009 0 3.2    -0.0932949 0.363752 0.926812    0 0
  v 3.28402 1.91221 6.5    -0.846272 -0.532331 0.0211592    0 0
  v 2.81673 2.55062 6.5    -0.717525 -0.69624 0.0201844    0 0
  v 2.23343 3.07405 6.5    -0.559448 -0.828625 0.0199687    0 0
  v 1.55536 3.46706 6.5    -0.377099 -0.925942 0.0206763    0 0
  v 0.8038 3.71419 6.5    -0.175705 -0.984203 0.0217306    0 0
  v 0.801685 3.70442 6.05    -0.209951 -0.9748 0.0753967    0 0
  v 1.55127 3.45793 6.05    -0.408122 -0.9101 0.0717983    0 0
  v 2.22755 3.06596 6.05    -0.586425 -0.807008 0.069603    0 0
  v 2.80932 2.54391 6.05    -0.739639 -0.669291 0.0705968    0 0
  v 3.27537 1.90718 6.05    -0.862457 -0.50069 0.0740067    0 0
  v 0.788993 3.64577 5.6    -0.204981 -0.947033 0.247208    0 0
  v 1.52671 3.40319 5.6    -0.398317 -0.886276 0.236343    0 0
  v 2.19229 3.01742 5.6    -0.572618 -0.786822 0.230261    0 0
  v 2.76485 2.50363 5.6    -0.721396 -0.6518 0.233976    0 0
  v 3.22352 1.87698 5.6    -0.839023 -0.48606 0.244514    0 0
  v 0.750918 3.46984 5.15    -0.186582 -0.853823 0.485978    0 0
  v 1.45304 3.23896 5.15    -0.363432 -0.805132 0.468699    0 0
  v 2.08649 2.87181 5.15    -0.523423 -0.717295 0.459908    0 0
  v 2.63142 2.38282 5.15    -0.65675 -0.592011 0.467122    0 0
  v 3.06796 1.7864 5.15    -0.757659 -0.437509 0.484292    0 0
  v 0.676884 3.12774 4.7    -0.153583 -0.693652 0.703746    0 0
  v 1.30978 2.91963 4.7    -0.300493 -0.661596 0.687018    0 0
  v 1.88078 2.58868 4.7    -0.433773 -0.5923 0.678986    0 0
  v 2.37199 2.14789 4.7    -0.540489 -0.485869 0.686879    0 0
  v 2.76549 1.61028 4.7    -0.615853 -0.354289 0.703707    0 0
  v 0.571121 2.63903 4.33    -0.11796 -0.53303 0.837833    0 0
  v 1.10513 2.46344 4.33    -0.233073 -0.513846 0.825614    0 0
  v 1.58691 2.18419 4.33    -0.337883 -0.462232 0.819864    0 0
  v 2.00136 1.81228 4.33    -0.418828 -0.377284 0.825978    0 0
  v 2.33338 1.35867 4.33    -0.472403 -0.272222 0.83829    0 0
  v 0.418822 1.93529 3.95    -0.093693 -0.422864 0.901337    0 0
  v 0.810426 1.80652 3.95    -0.185683 -0.410062 0.892956    0 0
  v 1.16373 1.60174 3.95    -0.269828 -0.369962 0.889    0 0
  v 1.46767 1.32901 3.95    -0.333722 -0.301144 0.893276    0 0
  v 1.71115 0.996361 3.95    -0.374538 -0.21586 0.901735    0 0
  v 0.224218 1.03606 3.58    -0.078634 -0.358071 0.930377    0 0
  v 0.433865 0.967127 3.58    -0.15605 -0.348742 0.924136    0 0
  v 0.623009 0.857499 3.58    -0.228027 -0.315626 0.921078    0 0
  v 0.78572 0.711488 3.58    -0.282843 -0.25655 0.92422    0 0
  v 0.916068 0.533405 3.58    -0.31721 -0.182896 0.930552    0 0
  v 2.36747e-010 2.38419e-007 3.2    -0.282624 0.0340596 0.958626    0 0
  v 1.89397e-009 2.38419e-007 3.2    -0.389283 -0.326673 0.861245    0 0
  v 6.39216e-009 0 3.2    0.0719567 -0.515554 0.85383    0 0
  v 1.51518e-008 0 3.2    -0.0863763 -0.492252 0.866156    0 0
  v 2.95933e-008 0 3.2    -0.101203 -0.559223 0.822817    0 0
  v -0.803578 3.71259 6.425    0.210332 -0.977381 0.0220853    0 0
  v -1.55483 3.46562 6.425    0.408982 -0.912286 0.0216529    0 0
  v -2.23255 3.07285 6.425    0.587655 -0.808831 0.0213204    0 0
  v -2.81553 2.54967 6.425    0.741261 -0.670877 0.0213592    0 0
  v -3.28256 1.9115 6.425    0.864552 -0.502072 0.0217447    0 0
  v -0.8032 3.71095 6.35    0.210339 -0.977365 0.0226828    0 0
  v -1.55412 3.46408 6.35    0.408966 -0.912255 0.0231784    0 0
  v -2.23155 3.07147 6.35    0.58762 -0.8088 0.0233331    0 0
  v -2.81429 2.54852 6.35    0.741226 -0.670861 0.0230302    0 0
  v -3.28112 1.91064 6.35    0.864537 -0.502064 0.0225116    0 0
  v -0.802743 3.7093 6.275    0.210383 -0.977353 0.0228233    0 0
  v -1.55332 3.4625 6.275    0.408996 -0.91223 0.0236346    0 0
  v -2.23049 3.07001 6.275    0.587608 -0.808789 0.024003    0 0
  v -2.81303 2.54726 6.275    0.741188 -0.670882 0.0236355    0 0
  v -3.2797 1.90969 6.275    0.86451 -0.502098 0.0228244    0 0
  v -0.802286 3.70765 6.2    0.210427 -0.97735 0.0225137    0 0
  v -1.55251 3.46091 6.2    0.40904 -0.912226 0.0230302    0 0
  v -2.22943 3.06854 6.2    0.587621 -0.8088 0.0233324    0 0
  v -2.81177 2.54601 6.2    0.741171 -0.670916 0.0231769    0 0
  v -3.27827 1.90875 6.2    0.864489 -0.502139 0.0226826    0 0
  v -0.801907 3.70602 6.125    0.210434 -0.977366 0.0217433    0 0
  v -1.5518 3.45937 6.125    0.409068 -0.912254 0.0213608    0 0
  v -2.22843 3.06717 6.125    0.587656 -0.80883 0.0213223    0 0
  v -2.81052 2.54486 6.125    0.741197 -0.670939 0.0216558    0 0
  v -3.27683 1.90788 6.125    0.864495 -0.502156 0.0220854    0 0
  v -0.800354 3.6948 5.975    0.2083 -0.969199 0.131393    0 0
  v -1.54808 3.44932 5.975    0.405462 -0.904983 0.128867    0 0
  v -2.2223 3.05873 5.975    0.58303 -0.802477 0.126915    0 0
  v -2.80211 2.53821 5.975    0.73555 -0.665433 0.12714    0 0
  v -3.26664 1.90294 5.975    0.857598 -0.497779 0.12939    0 0
  v -0.798082 3.68499 5.9    0.20824 -0.968732 0.134883    0 0
  v -1.54381 3.44009 5.9    0.404955 -0.903897 0.137772    0 0
  v -2.2163 3.05047 5.9    0.582065 -0.80123 0.138679    0 0
  v -2.79466 2.5313 5.9    0.734561 -0.664587 0.136914    0 0
  v -3.25802 1.89775 5.9    0.857093 -0.497459 0.133886    0 0
  v -0.795339 3.67509 5.825    0.208483 -0.968564 0.135717    0 0
  v -1.53899 3.43056 5.825    0.405008 -0.903462 0.140447    0 0
  v -2.20992 3.04169 5.825    0.581735 -0.800783 0.142587    0 0
  v -2.78708 2.52377 5.825    0.734042 -0.664422 0.140447    0 0
  v -3.24945 1.89208 5.825    0.856757 -0.497543 0.135716    0 0
  v -0.792597 3.66519 5.75    0.208808 -0.968748 0.13389    0 0
  v -1.53418 3.42103 5.75    0.405459 -0.903802 0.136915    0 0
  v -2.20354 3.03292 5.75    0.582091 -0.80121 0.138678    0 0
  v -2.77951 2.51624 5.75    0.734173 -0.664837 0.137772    0 0
  v -3.24088 1.88641 5.75    0.856714 -0.497843 0.134888    0 0
  v -0.790325 3.65539 5.675    0.208982 -0.969322 0.12939    0 0
  v -1.5299 3.41181 5.675    0.406092 -0.904945 0.127138    0 0
  v -2.19754 3.02466 5.675    0.58308 -0.802441 0.126912    0 0
  v -2.77206 2.50933 5.675    0.735057 -0.665647 0.128865    0 0
  v -3.23225 1.88122 5.675    0.857075 -0.498154 0.131395    0 0
  v -0.784999 3.61692 5.525    0.194647 -0.908628 0.36947    0 0
  v -1.51715 3.37734 5.525    0.380422 -0.850527 0.363157    0 0
  v -2.17653 2.99573 5.525    0.548654 -0.755414 0.358229    0 0
  v -2.74322 2.48655 5.525    0.692402 -0.62596 0.358822    0 0
  v -3.19732 1.86427 5.525    0.805571 -0.467118 0.364494    0 0
  v -0.778183 3.58751 5.45    0.193932 -0.905246 0.378048    0 0
  v -1.50432 3.34967 5.45    0.376708 -0.842501 0.385075    0 0
  v -2.15852 2.97095 5.45    0.541738 -0.746012 0.38728    0 0
  v -2.72086 2.4658 5.45    0.68528 -0.619433 0.383007    0 0
  v -3.17145 1.8487 5.45    0.801855 -0.464695 0.375616    0 0
  v -0.769956 3.5578 5.375    0.194513 -0.904263 0.380096    0 0
  v -1.48988 3.32108 5.375    0.376205 -0.839729 0.391567    0 0
  v -2.13939 2.94462 5.375    0.539425 -0.742724 0.396714    0 0
  v -2.69813 2.44322 5.375    0.68224 -0.617431 0.39157    0 0
  v -3.14574 1.83169 5.375    0.799963 -0.464314 0.380094    0 0
  v -0.761729 3.5281 5.3    0.195763 -0.905854 0.375639    0 0
  v -1.47543 3.29248 5.3    0.378485 -0.842649 0.383004    0 0
  v -2.12026 2.91829 5.3    0.541936 -0.745878 0.38726    0 0
  v -2.67541 2.42065 5.3    0.683857 -0.619725 0.385072    0 0
  v -3.12003 1.81469 5.3    0.800264 -0.465445 0.378072    0 0
  v -0.754913 3.49868 5.225    0.197003 -0.910129 0.364492    0 0
  v -1.4626 3.26481 5.225    0.382891 -0.851268 0.3588    0 0
  v -2.10226 2.89351 5.225    0.549035 -0.755152 0.358198    0 0
  v -2.65305 2.3999 5.225    0.690365 -0.625727 0.363128    0 0
  v -3.09416 1.79912 5.225    0.803076 -0.467499 0.369478    0 0
  v -0.743152 3.41375 5.075    0.164908 -0.773789 0.611601    0 0
  v -1.43444 3.18871 5.075    0.32471 -0.727977 0.603832    0 0
  v -2.05584 2.82963 5.075    0.470929 -0.648874 0.597652    0 0
  v -2.58937 2.34959 5.075    0.594523 -0.537018 0.59846    0 0
  v -3.01702 1.76168 5.075    0.688673 -0.398791 0.605554    0 0
  v -0.729898 3.35654 5    0.163166 -0.766005 0.621782    0 0
  v -1.4095 3.13489 5    0.316131 -0.70937 0.629965    0 0
  v -2.02083 2.78144 5    0.454904 -0.626878 0.632523    0 0
  v -2.5459 2.30925 5    0.577937 -0.52164 0.6276    0 0
  v -2.96671 1.7314 5    0.679988 -0.393099 0.618942    0 0
  v -0.713902 3.29879 4.925    0.164081 -0.763831 0.624211    0 0
  v -1.38141 3.07929 4.925    0.314712 -0.70326 0.637481    0 0
  v -1.98364 2.73024 4.925    0.449771 -0.619529 0.643343    0 0
  v -2.5017 2.26535 4.925    0.571344 -0.516889 0.637489    0 0
  v -2.91673 1.69834 4.925    0.675862 -0.391893 0.624204    0 0
  v -0.697905 3.24103 4.85    0.16657 -0.767527 0.618997    0 0
  v -1.35331 3.0237 4.85    0.319525 -0.709952 0.627592    0 0
  v -1.94644 2.67905 4.85    0.455361 -0.626598 0.632473    0 0
  v -2.45751 2.22145 4.85    0.575195 -0.521834 0.629953    0 0
  v -2.86674 1.66528 4.85    0.676741 -0.394128 0.62184    0 0
  v -0.684652 3.18383 4.775    0.169483 -0.777553 0.605547    0 0
  v -1.32838 2.96988 4.775    0.32978 -0.730181 0.598399    0 0
  v -1.91143 2.63086 4.775    0.471859 -0.648273 0.597571    0 0
  v -2.41403 2.18111 4.775    0.590285 -0.535766 0.603753    0 0
  v -2.81643 1.635 4.775    0.683288 -0.398803 0.611615    0 0
  v -0.665789 3.04761 4.63833    0.123769 -0.584271 0.802065    0 0
  v -1.28321 2.84783 4.63833    0.245873 -0.552987 0.796085    0 0
  v -1.837 2.52841 4.63833    0.358995 -0.495069 0.79122    0 0
  v -2.31192 2.10043 4.63833    0.453337 -0.409102 0.79191    0 0
  v -2.69271 1.57497 4.63833    0.522333 -0.301995 0.797475    0 0
  v -0.646855 2.9659 4.57667    0.121517 -0.574295 0.809579    0 0
  v -1.24759 2.77095 4.57667    0.234834 -0.528979 0.815496    0 0
  v -1.78698 2.45957 4.57667    0.338213 -0.466441 0.81734    0 0
  v -2.24981 2.0428 4.57667    0.431722 -0.38899 0.81382    0 0
  v -2.62084 1.53171 4.57667    0.511022 -0.294565 0.80752    0 0
  v -0.624003 2.88338 4.515    0.122598 -0.571525 0.811374    0 0
  v -1.20745 2.69153 4.515    0.233028 -0.521367 0.820898    0 0
  v -1.73385 2.38643 4.515    0.331874 -0.457356 0.825036    0 0
  v -2.18668 1.98009 4.515    0.423537 -0.383048 0.820908    0 0
  v -2.54943 1.48448 4.515    0.505815 -0.292976 0.811367    0 0
  v -0.601151 2.80087 4.45333    0.125714 -0.576197 0.807585    0 0
  v -1.16732 2.61211 4.45333    0.239002 -0.529705 0.813812    0 0
  v -1.68071 2.3133 4.45333    0.338795 -0.46612 0.817282    0 0
  v -2.12354 1.91737 4.45333    0.428365 -0.389219 0.815483    0 0
  v -2.47802 1.43725 4.45333    0.506945 -0.295765 0.809648    0 0
  v -0.582217 2.71916 4.39167    0.12956 -0.589289 0.797467    0 0
  v -1.1317 2.53523 4.39167    0.252443 -0.556123 0.791833    0 0
  v -1.63069 2.24446 4.39167    0.36027 -0.494307 0.791117    0 0
  v -2.06143 1.85974 4.39167    0.447855 -0.40723 0.795983    0 0
  v -2.40616 1.39399 4.39167    0.515357 -0.301785 0.80208    0 0
  v -0.555143 2.52365 4.26667    0.0961011 -0.459115 0.883164    0 0
  v -1.06686 2.36005 4.26667    0.1928 -0.435981 0.879061    0 0
  v -1.52386 2.09742 4.26667    0.283474 -0.390961 0.875667    0 0
  v -1.91486 1.74394 4.26667    0.358445 -0.322275 0.87616    0 0
  v -2.22858 1.30782 4.26667    0.411625 -0.236901 0.880024    0 0
  v -0.527879 2.40597 4.20333    0.0941205 -0.449661 0.888227    0 0
  v -1.01557 2.24935 4.20333    0.18232 -0.413214 0.892196    0 0
  v -1.45184 1.99828 4.20333    0.263543 -0.363757 0.893435    0 0
  v -1.82543 1.66095 4.20333    0.337691 -0.303201 0.891086    0 0
  v -2.12509 1.24553 4.20333    0.400846 -0.229831 0.886848    0 0
  v -0.494972 2.28716 4.14    0.0958867 -0.446852 0.889454    0 0
  v -0.957777 2.13498 4.14    0.181201 -0.405864 0.895791    0 0
  v -1.37532 1.89297 4.14    0.257609 -0.355375 0.898524    0 0
  v -1.73452 1.57064 4.14    0.329571 -0.298196 0.895802    0 0
  v -2.02226 1.17752 4.14    0.395561 -0.228953 0.889445    0 0
  v -0.462065 2.16834 4.07667    0.0996775 -0.451024 0.886928    0 0
  v -0.899981 2.02061 4.07667    0.187512 -0.413306 0.891077    0 0
  v -1.29881 1.78766 4.07667    0.264093 -0.363528 0.893366    0 0
  v -1.64361 1.48034 4.07667    0.333584 -0.30453 0.892179    0 0
  v -1.91943 1.1095 4.07667    0.396133 -0.232346 0.88831    0 0
  v -0.4348 2.05067 4.01333    0.103517 -0.463531 0.880013    0 0
  v -0.848694 1.9099 4.01333    0.200715 -0.438437 0.876063    0 0
  v -1.22678 1.68852 4.01333    0.284781 -0.390303 0.875536    0 0
  v -1.55417 1.39735 4.01333    0.352098 -0.321726 0.878931    0 0
  v -1.81594 1.04721 4.01333    0.403969 -0.238333 0.88318    0 0
  v -0.398406 1.78785 3.88833    0.0751849 -0.367584 0.926946    0 0
  v -0.761529 1.67442 3.88833    0.153163 -0.349845 0.924202    0 0
  v -1.08317 1.49086 3.88833    0.227528 -0.313608 0.92189    0 0
  v -1.35714 1.24168 3.88833    0.288563 -0.257373 0.92222    0 0
  v -1.57724 0.931384 3.88833    0.330439 -0.188395 0.924834    0 0
  v -0.363568 1.6375 3.82667    0.0736826 -0.359275 0.930318    0 0
  v -0.695996 1.53296 3.82667    0.143898 -0.329899 0.932985    0 0
  v -0.99114 1.36419 3.82667    0.209712 -0.289812 0.933825    0 0
  v -1.24286 1.13564 3.82667    0.270062 -0.240786 0.932249    0 0
  v -1.445 0.851788 3.82667    0.320986 -0.18216 0.929401    0 0
  v -0.32152 1.48568 3.765    0.0767155 -0.356423 0.93117    0 0
  v -0.622146 1.38682 3.765    0.144012 -0.323027 0.935368    0 0
  v -0.893372 1.22962 3.765    0.204448 -0.282667 0.937177    0 0
  v -1.12669 1.02025 3.765    0.262026 -0.237486 0.935384    0 0
  v -1.31361 0.764883 3.765    0.315602 -0.182594 0.931158    0 0
  v -0.279472 1.33386 3.70333    0.0819722 -0.35959 0.929503    0 0
  v -0.548295 1.24069 3.70333    0.1511 -0.328794 0.932236    0 0
  v -0.795603 1.09505 3.70333    0.210154 -0.289784 0.933735    0 0
  v -1.01053 0.904853 3.70333    0.264407 -0.244285 0.93296    0 0
  v -1.18221 0.677978 3.70333    0.315016 -0.187281 0.930425    0 0
  v -0.244634 1.1835 3.64167    0.085874 -0.370606 0.924812    0 0
  v -0.482762 1.09923 3.64167    0.163663 -0.350682 0.922083    0 0
  v -0.703571 0.968382 3.64167    0.228856 -0.313166 0.921711    0 0
  v -0.896247 0.798815 3.64167    0.280631 -0.259689 0.924017    0 0
  v -1.04998 0.598382 3.64167    0.321527 -0.193306 0.926959    0 0
  v -0.200695 0.866193 3.51667    0.063181 -0.333582 0.940602    0 0
  v -0.377526 0.814922 3.51667    0.13484 -0.318093 0.938421    0 0
  v -0.530188 0.729741 3.51667    0.206372 -0.283452 0.936518    0 0
  v -0.658375 0.610873 3.51667    0.264367 -0.229412 0.936739    0 0
  v -0.761781 0.458541 3.51667    0.301281 -0.166624 0.938865    0 0
  v -0.160556 0.692955 3.45333    0.0621499 -0.325932 0.943348    0 0
  v -0.302021 0.651938 3.45333    0.125639 -0.299966 0.94564    0 0
  v -0.42415 0.583793 3.45333    0.1889 -0.261972 0.946408    0 0
  v -0.5267 0.488699 3.45333    0.24681 -0.21448 0.945031    0 0
  v -0.609425 0.366832 3.45333    0.292936 -0.160381 0.942585    0 0
  v -0.112109 0.518032 3.39    0.0715505 -0.321541 0.944188    0 0
  v -0.216932 0.483563 3.39    0.130002 -0.29174 0.947622    0 0
  v -0.311505 0.428749 3.39    0.183173 -0.256185 0.949114    0 0
  v -0.39286 0.355744 3.39    0.234954 -0.216163 0.947666    0 0
  v -0.458034 0.266703 3.39    0.284635 -0.165968 0.94416    0 0
  v -0.0636621 0.343109 3.32667    0.0932359 -0.320425 0.942674    0 0
  v -0.131844 0.315189 3.32667    0.147118 -0.292401 0.944912    0 0
  v -0.198859 0.273705 3.32667    0.187599 -0.263886 0.946135    0 0
  v -0.25902 0.22279 3.32667    0.227556 -0.23328 0.945409    0 0
  v -0.306643 0.166573 3.32667    0.274363 -0.186014 0.943464    0 0
  v -0.0235231 0.16987 3.26333    0.146213 -0.320251 0.935981    0 0
  v -0.0563385 0.152205 3.26333    0.213567 -0.283646 0.934844    0 0
  v -0.092821 0.127757 3.26333    0.326678 -0.183524 0.927146    0 0
  v -0.127346 0.100615 3.26333    0.0969734 -0.409083 0.90733    0 0
  v -0.154287 0.0748646 3.26333    0.289158 -0.173516 0.941424    0 0
  v -3.7792 0.383004 6.425    0.99454 -0.10199 0.0220847    0 0
  v -3.77647 -0.407798 6.425    0.994018 0.107053 0.0216506    0 0
  v -3.61235 -1.17372 6.425    0.950839 0.30895 0.021319    0 0
  v -3.29493 -1.88984 6.425    0.867104 0.497668 0.021359    0 0
  v -2.83231 -2.53122 6.425    0.74466 0.66709 0.0217437    0 0
  v -3.77753 0.382859 6.35    0.994528 -0.101979 0.0226843    0 0
  v -3.77479 -0.407596 6.35    0.993984 0.107048 0.0231781    0 0
  v -3.61073 -1.1732 6.35    0.950799 0.308927 0.0233329    0 0
  v -3.29345 -1.88901 6.35    0.867078 0.49764 0.0230309    0 0
  v -2.83105 -2.53012 6.35    0.744648 0.667077 0.0225124    0 0
  v -3.77582 0.382784 6.275    0.994529 -0.101933 0.0228236    0 0
  v -3.77303 -0.407323 6.275    0.993969 0.107084 0.0236348    0 0
  v -3.60901 -1.17264 6.275    0.950785 0.308919 0.0240021    0 0
  v -3.29186 -1.8882 6.275    0.867086 0.497598 0.0236355    0 0
  v -2.82971 -2.52905 6.275    0.744672 0.667041 0.022824    0 0
  v -3.77411 0.382709 6.2    0.994541 -0.10189 0.022512    0 0
  v -3.77127 -0.40705 6.2    0.993979 0.107127 0.0230311    0 0
  v -3.60729 -1.17208 6.2    0.950799 0.308928 0.0233327    0 0
  v -3.29028 -1.88739 6.2    0.867114 0.497571 0.0231779    0 0
  v -2.82837 -2.52798 6.2    0.744705 0.667008 0.0226831    0 0
  v -3.77244 0.382564 6.125    0.994558 -0.101888 0.0217428    0 0
  v -3.76959 -0.406848 6.125    0.994014 0.107144 0.0213603    0 0
  v -3.60567 -1.17155 6.125    0.950839 0.308952 0.0213239    0 0
  v -3.2888 -1.88656 6.125    0.867143 0.497588 0.0216561    0 0
  v -2.8271 -2.52688 6.125    0.744722 0.667009 0.0220872    0 0
  v -3.76129 0.380574 5.975    0.986131 -0.101394 0.131392    0 0
  v -3.75888 -0.406416 5.975    0.985984 0.105962 0.128867    0 0
  v -3.59575 -1.16833 5.975    0.943367 0.306515 0.126915    0 0
  v -3.27988 -1.88062 5.975    0.860162 0.49392 0.12714    0 0
  v -2.81925 -2.51872 5.975    0.738428 0.661802 0.12939    0 0
  v -3.75126 0.379705 5.9    0.985669 -0.101307 0.134884    0 0
  v -3.74879 -0.405202 5.9    0.984795 0.105815 0.137772    0 0
  v -3.58604 -1.16518 5.9    0.941882 0.305983 0.138679    0 0
  v -3.271 -1.87567 5.9    0.859051 0.49324 0.136914    0 0
  v -2.81165 -2.51212 5.9    0.737968 0.661421 0.133886    0 0
  v -3.74099 0.379254 5.825    0.985584 -0.101023 0.135717    0 0
  v -3.73823 -0.403566 5.825    0.984397 0.106001 0.140448    0 0
  v -3.57572 -1.16182 5.825    0.941356 0.305807 0.142588    0 0
  v -3.2615 -1.87079 5.825    0.858735 0.492797 0.140448    0 0
  v -2.80361 -2.50572 5.825    0.737944 0.661075 0.135715    0 0
  v -3.73073 0.378802 5.75    0.985859 -0.100772 0.133891    0 0
  v -3.72768 -0.401931 5.75    0.98486 0.106324 0.136915    0 0
  v -3.56541 -1.15847 5.75    0.941873 0.306014 0.138678    0 0
  v -3.25201 -1.86591 5.75    0.859169 0.492794 0.137773    0 0
  v -2.79557 -2.49933 5.75    0.738216 0.660941 0.134888    0 0
  v -3.7207 0.377933 5.675    0.986459 -0.100783 0.12939    0 0
  v -3.71759 -0.400717 5.675    0.986143 0.106573 0.127139    0 0
  v -3.5557 -1.15532 5.675    0.943348 0.306574 0.126912    0 0
  v -3.24313 -1.86096 5.675    0.860213 0.493384 0.128866    0 0
  v -2.78797 -2.49273 5.675    0.738623 0.661189 0.131395    0 0
  v -3.68248 0.371113 5.525    0.924305 -0.0956618 0.36947    0 0
  v -3.68087 -0.399235 5.525    0.926457 0.0989752 0.363156    0 0
  v -3.52169 -1.14427 5.525    0.887985 0.288365 0.358228    0 0
  v -3.21255 -1.84057 5.525    0.809287 0.465081 0.358822    0 0
  v -2.76105 -2.46474 5.525    0.693191 0.621797 0.364494    0 0
  v -3.65239 0.368505 5.45    0.920868 -0.0952962 0.378048    0 0
  v -3.65059 -0.395593 5.45    0.917675 0.0979233 0.385075    0 0
  v -3.49256 -1.1348 5.45    0.876905 0.284694 0.387281    0 0
  v -3.18591 -1.82572 5.45    0.800879 0.460324 0.383007    0 0
  v -2.73825 -2.44495 5.45    0.689738 0.619011 0.375616    0 0
  v -3.6216 0.36715 5.375    0.920113 -0.0944402 0.380096    0 0
  v -3.61893 -0.390687 5.375    0.914884 0.0983015 0.391567    0 0
  v -3.46161 -1.12474 5.375    0.873064 0.283509 0.396713    0 0
  v -3.15741 -1.81108 5.375    0.798036 0.458052 0.39157    0 0
  v -2.71413 -2.42575 5.375    0.688791 0.61733 0.380094    0 0
  v -3.59081 0.365795 5.3    0.922012 -0.0937425 0.37564    0 0
  v -3.58727 -0.38578 5.3    0.918364 0.0995682 0.383005    0 0
  v -3.43066 -1.11469 5.3    0.87684 0.284923 0.387261    0 0
  v -3.12892 -1.79644 5.3    0.800717 0.458881 0.385072    0 0
  v -2.69002 -2.40656 5.3    0.68996 0.617265 0.378073    0 0
  v -3.56072 0.363187 5.225    0.926462 -0.093884 0.364492    0 0
  v -3.55699 -0.382138 5.225    0.927924 0.101095 0.3588    0 0
  v -3.40152 -1.10522 5.225    0.887853 0.288808 0.358199    0 0
  v -3.10228 -1.78159 5.225    0.808435 0.463216 0.36313    0 0
  v -2.66721 -2.38677 5.225    0.692782 0.619306 0.369478    0 0
  v -3.47631 0.348126 5.075    0.786876 -0.0822771 0.611601    0 0
  v -3.4759 -0.378865 5.075    0.792688 0.08386 0.603832    0 0
  v -3.32643 -1.08082 5.075    0.762641 0.247367 0.597652    0 0
  v -3.03476 -1.73658 5.075    0.694453 0.399478 0.598459    0 0
  v -2.60777 -2.32497 5.075    0.592085 0.531734 0.605553    0 0
  v -3.41781 0.343055 5    0.778935 -0.0815286 0.621782    0 0
  v -3.41702 -0.371784 5    0.77234 0.0814509 0.629965    0 0
  v -3.26978 -1.06241 5    0.736769 0.238924 0.632524    0 0
  v -2.98295 -1.70769 5    0.674701 0.388455 0.6276    0 0
  v -2.56343 -2.28648 5    0.583987 0.525233 0.618943    0 0
  v -3.35794 0.34042 4.925    0.77715 -0.0799863 0.624211    0 0
  v -3.35546 -0.362244 4.925    0.766091 0.0819901 0.637481    0 0
  v -3.20959 -1.04286 4.925    0.728194 0.236313 0.643343    0 0
  v -2.92755 -1.67923 4.925    0.668146 0.383653 0.637488    0 0
  v -2.51654 -2.24915 4.925    0.581566 0.521681 0.624203    0 0
  v -3.29807 0.337786 4.85    0.781435 -0.0787615 0.618996    0 0
  v -3.29391 -0.352704 4.85    0.773943 0.0844994 0.627592    0 0
  v -3.14941 -1.02331 4.85    0.736643 0.239444 0.632474    0 0
  v -2.87214 -1.65077 4.85    0.674038 0.385787 0.629954    0 0
  v -2.46965 -2.21183 4.85    0.583962 0.521827 0.62184    0 0
  v -3.23957 0.332715 4.775    0.79187 -0.0790886 0.605547    0 0
  v -3.23502 -0.345623 4.775    0.796351 0.088001 0.598398    0 0
  v -3.09276 -1.0049 4.775    0.762356 0.248437 0.597572    0 0
  v -2.82034 -1.62188 4.775    0.691951 0.395833 0.603754    0 0
  v -2.4253 -2.17334 4.775    0.590431 0.526608 0.611617    0 0
  v -3.10419 0.308561 4.63833    0.593922 -0.0628387 0.802065    0 0
  v -3.10498 -0.340372 4.63833    0.601901 0.0629566 0.796085    0 0
  v -2.97233 -0.965768 4.63833    0.581774 0.18844 0.79122    0 0
  v -2.71205 -1.5497 4.63833    0.529169 0.30473 0.791909    0 0
  v -2.32998 -2.07423 4.63833    0.448625 0.403448 0.797474    0 0
  v -3.02062 0.301316 4.57667    0.583738 -0.0618974 0.809579    0 0
  v -3.02086 -0.330257 4.57667    0.575657 0.0598771 0.815496    0 0
  v -2.8914 -0.939472 4.57667    0.548126 0.177521 0.81734    0 0
  v -2.63805 -1.50843 4.57667    0.503361 0.290388 0.81382    0 0
  v -2.26663 -2.01925 4.57667    0.438062 0.394985 0.80752    0 0
  v -2.93509 0.297553 4.515    0.581438 -0.0600138 0.811374    0 0
  v -2.93292 -0.316628 4.515    0.567859 0.0605111 0.820898    0 0
  v -2.80542 -0.911537 4.515    0.537527 0.1743 0.825036    0 0
  v -2.55889 -1.46777 4.515    0.495181 0.28444 0.820908    0 0
  v -2.19964 -1.96593 4.515    0.434943 0.390524 0.811366    0 0
  v -2.84955 0.293789 4.45333    0.586843 -0.058493 0.807585    0 0
  v -2.84499 -0.302999 4.45333    0.577635 0.0636166 0.813813    0 0
  v -2.71945 -0.883603 4.45333    0.547999 0.178174 0.817282    0 0
  v -2.47974 -1.42711 4.45333    0.502541 0.287124 0.815483    0 0
  v -2.13265 -1.91261 4.45333    0.437944 0.390737 0.809648    0 0
  v -2.76599 0.286544 4.39167    0.600483 -0.0588812 0.797467    0 0
  v -2.76086 -0.292883 4.39167    0.606914 0.0682357 0.791833    0 0
  v -2.63852 -0.857307 4.39167    0.581443 0.189888 0.791117    0 0
  v -2.40574 -1.38585 4.39167    0.525693 0.300094 0.795984    0 0
  v -2.0693 -1.85763 4.39167    0.446269 0.396877 0.802081    0 0
  v -2.57168 0.251877 4.26667    0.466341 -0.0504767 0.883163    0 0
  v -2.57422 -0.285348 4.26667    0.474221 0.0486379 0.879061    0 0
  v -2.46566 -0.801142 4.26667    0.459424 0.148786 0.875667    0 0
  v -2.25031 -1.28224 4.26667    0.417267 0.241313 0.87616    0 0
  v -1.93248 -1.71537 4.26667    0.352506 0.318273 0.880024    0 0
  v -2.45134 0.241444 4.20333    0.456738 -0.049439 0.888226    0 0
  v -2.45308 -0.270782 4.20333    0.44933 0.0457066 0.892196    0 0
  v -2.34912 -0.763276 4.20333    0.427392 0.138237 0.893435    0 0
  v -2.14375 -1.22282 4.20333    0.392713 0.227468 0.891086    0 0
  v -1.84126 -1.6362 4.20333    0.34245 0.310206 0.886848    0 0
  v -2.32817 0.236025 4.14    0.454612 -0.0468914 0.889454    0 0
  v -2.32645 -0.251156 4.14    0.441994 0.0469139 0.895791    0 0
  v -2.22532 -0.72305 4.14    0.417588 0.135184 0.898524    0 0
  v -2.02977 -1.16427 4.14    0.385445 0.221293 0.895802    0 0
  v -1.7448 -1.55941 4.14    0.339982 0.30545 0.889445    0 0
  v -2.205 0.230605 4.07667    0.459752 -0.0445752 0.886928    0 0
  v -2.19982 -0.23153 4.07667    0.451021 0.0506156 0.891077    0 0
  v -2.10152 -0.682824 4.07667    0.427344 0.138831 0.893366    0 0
  v -1.91578 -1.10571 4.07667    0.392709 0.223152 0.892179    0 0
  v -1.64834 -1.48263 4.07667    0.343386 0.304945 0.88831    0 0
  v -2.08467 0.220173 4.01333    0.472833 -0.0447888 0.880013    0 0
  v -2.07869 -0.216964 4.01333    0.479003 0.0554072 0.876063    0 0
  v -1.98498 -0.644958 4.01333    0.459202 0.150233 0.875536    0 0
  v -1.80922 -1.04629 4.01333    0.414783 0.235447 0.878931    0 0
  v -1.55712 -1.40346 4.01333    0.351501 0.310548 0.88318    0 0
  v -1.82346 0.173571 3.88833    0.372827 -0.0420847 0.926946    0 0
  v -1.82779 -0.206834 3.88833    0.380053 0.0375589 0.924202    0 0
  v -1.75261 -0.569458 3.88833    0.368569 0.119482 0.92189    0 0
  v -1.60029 -0.907017 3.88833    0.333947 0.194907 0.92222    0 0
  v -1.37319 -1.21223 3.88833    0.281286 0.256049 0.924834    0 0
  v -1.6697 0.16024 3.82667    0.36446 -0.0409461 0.930318    0 0
  v -1.67301 -0.188221 3.82667    0.358219 0.0349108 0.932985    0 0
  v -1.6037 -0.521073 3.82667    0.340432 0.109891 0.933825    0 0
  v -1.46412 -0.831094 3.82667    0.312454 0.182438 0.932249    0 0
  v -1.25663 -1.11106 3.82667    0.272435 0.248986 0.929401    0 0
  v -1.51232 0.153315 3.765    0.362685 -0.0371802 0.93117    0 0
  v -1.5112 -0.163144 3.765    0.35172 0.0371429 0.935368    0 0
  v -1.44551 -0.469673 3.765    0.332011 0.107093 0.937177    0 0
  v -1.31848 -0.756276 3.765    0.306833 0.175814 0.935384    0 0
  v -1.13337 -1.01295 3.765    0.271184 0.243731 0.931158    0 0
  v -1.35493 0.14639 3.70333    0.367321 -0.0331591 0.929503    0 0
  v -1.3494 -0.138067 3.70333    0.359394 0.0421013 0.932236    0 0
  v -1.28731 -0.418274 3.70333    0.340542 0.11032 0.933735    0 0
  v -1.17284 -0.681457 3.70333    0.314035 0.175978 0.93296    0 0
  v -1.01012 -0.914843 3.70333    0.27546 0.241725 0.930425    0 0
  v -1.20117 0.13306 3.64167    0.379004 -0.0328525 0.924812    0 0
  v -1.19461 -0.119454 3.64167    0.384093 0.0472864 0.922083    0 0
  v -1.1384 -0.369889 3.64167    0.368559 0.120882 0.921711    0 0
  v -1.03667 -0.605534 3.64167    0.333698 0.186647 0.924018    0 0
  v -0.893556 -0.813677 3.64167    0.283202 0.246055 0.926959    0 0
  v -0.885817 0.0767963 3.51667    0.336779 -0.0429938 0.940602    0 0
  v -0.891699 -0.107224 3.51667    0.344193 0.0299445 0.938421    0 0
  v -0.857862 -0.278737 3.51667    0.333351 0.10868 0.936518    0 0
  v -0.784424 -0.437382 3.51667    0.299878 0.180536 0.936739    0 0
  v -0.671501 -0.5828 3.51667    0.251569 0.235045 0.938864    0 0
  v -0.708654 0.0614371 3.45333    0.329185 -0.0416104 0.943348    0 0
  v -0.713359 -0.0857792 3.45333    0.324109 0.0267951 0.94564    0 0
  v -0.68629 -0.222989 3.45333    0.307524 0.0987012 0.946408    0 0
  v -0.627539 -0.349905 3.45333    0.280251 0.168453 0.945031    0 0
  v -0.537201 -0.46624 3.45333    0.243054 0.229038 0.942585    0 0
  v -0.527321 0.0534587 3.39    0.327914 -0.0313133 0.944189    0 0
  v -0.526932 -0.0568857 3.39    0.317634 0.0334866 0.947622    0 0
  v -0.504025 -0.163768 3.39    0.30025 0.0950419 0.949114    0 0
  v -0.459733 -0.263701 3.39    0.278188 0.156656 0.947666    0 0
  v -0.395189 -0.3532 3.39    0.245802 0.219417 0.94416    0 0
  v -0.345988 0.04548 3.32667    0.333554 -0.0103435 0.942674    0 0
  v -0.340504 -0.0279922 3.32667    0.323552 0.0495605 0.944912    0 0
  v -0.32176 -0.104546 3.32667    0.308942 0.0968722 0.946135    0 0
  v -0.291927 -0.177498 3.32667    0.292181 0.144331 0.945409    0 0
  v -0.253178 -0.240161 3.32667    0.261693 0.203453 0.943464    0 0
  v -0.168825 0.0301208 3.26333    0.316971 -0.155613 0.935582    0 0
  v -0.162165 -0.00654745 3.26333    0.347746 -0.131638 0.928302    0 0
  v -0.150188 -0.0487988 3.26333    0.266126 0.288158 0.91986    0 0
  v -0.135042 -0.0900211 3.26333    0.417533 -0.0306073 0.908146    0 0
  v -0.118878 -0.123601 3.26333    0.321177 0.15364 0.934473    0 0
  v -1.5321 -3.47588 6.425    0.404328 0.914347 0.0220841    0 0
  v -0.779155 -3.71765 6.425    0.205355 0.978448 0.0216518    0 0
  v 4.26956e-007 -3.79825 6.425    -3.8313e-006 0.999773 0.0213181    0 0
  v 0.779156 -3.71765 6.425    -0.205361 0.978453 0.0213584    0 0
  v 1.5321 -3.47588 6.425    -0.404327 0.914356 0.0217443    0 0
  v -1.53144 -3.47433 6.35    0.404314 0.914339 0.0226822    0 0
  v -0.778828 -3.71599 6.35    0.205349 0.978414 0.0231774    0 0
  v 4.20677e-007 -3.79655 6.35    6.26814e-006 0.999728 0.0233329    0 0
  v 0.778829 -3.71599 6.35    -0.205342 0.978419 0.0230291    0 0
  v 1.53144 -3.47433 6.35    -0.404319 0.914341 0.0225106    0 0
  v -1.53084 -3.47273 6.275    0.40427 0.914355 0.0228228    0 0
  v -0.778543 -3.71424 6.275    0.20531 0.978411 0.023633    0 0
  v 4.24683e-007 -3.79474 6.275    9.1731e-006 0.999712 0.0240026    0 0
  v 0.778544 -3.71424 6.275    -0.205299 0.978414 0.023636    0 0
  v 1.53084 -3.47273 6.275    -0.404277 0.914352 0.022824    0 0
  v -1.53024 -3.47113 6.2    0.404233 0.914379 0.0225128    0 0
  v -0.778259 -3.71248 6.2    0.205272 0.978434 0.0230291    0 0
  v 4.24529e-007 -3.79293 6.2    4.92984e-006 0.999728 0.0233307    0 0
  v 0.77826 -3.71248 6.2    -0.205265 0.978432 0.0231785    0 0
  v 1.53024 -3.47113 6.2    -0.404236 0.914373 0.022683    0 0
  v -1.52959 -3.46958 6.125    0.404237 0.914396 0.021742    0 0
  v -0.777932 -3.71082 6.125    0.205267 0.978473 0.0213592    0 0
  v 4.2462e-007 -3.79123 6.125    -5.90233e-006 0.999773 0.0213212    0 0
  v 0.777933 -3.71082 6.125    -0.205273 0.978465 0.0216573    0 0
  v 1.52959 -3.46958 6.125    -0.404231 0.91439 0.0220892    0 0
  v -1.52425 -3.45959 5.975    0.401163 0.906534 0.131395    0 0
  v -0.775034 -3.7005 5.975    0.20391 0.970471 0.128869    0 0
  v 4.33021e-007 -3.7808 5.975    3.15205e-006 0.991913 0.126918    0 0
  v 0.775035 -3.7005 5.975    -0.203941 0.970692 0.12714    0 0
  v 1.52425 -3.45959 5.975    -0.401225 0.906795 0.129387    0 0
  v -1.52032 -3.45032 5.9    0.400937 0.906121 0.134884    0 0
  v -0.773069 -3.69052 5.9    0.203682 0.969295 0.137773    0 0
  v 4.39452e-007 -3.77059 5.9    5.05793e-005 0.990337 0.138681    0 0
  v 0.77307 -3.69052 5.9    -0.203638 0.969425 0.136917    0 0
  v 1.52032 -3.45032 5.9    -0.401004 0.906239 0.133888    0 0
  v -1.51672 -3.4407 5.825    0.400641 0.906128 0.135715    0 0
  v -0.771363 -3.67998 5.825    0.203382 0.968974 0.140447    0 0
  v 4.54485e-007 -3.75974 5.825    5.48269e-005 0.989782 0.142586    0 0
  v 0.771364 -3.67998 5.825    -0.203315 0.968988 0.140446    0 0
  v 1.51672 -3.4407 5.825    -0.400682 0.90611 0.135718    0 0
  v -1.51312 -3.43108 5.75    0.400487 0.906468 0.13389    0 0
  v -0.769658 -3.66944 5.75    0.203218 0.969514 0.136916    0 0
  v 4.55436e-007 -3.74889 5.75    1.79573e-005 0.990337 0.13868    0 0
  v 0.769659 -3.66944 5.75    -0.203178 0.969401 0.137772    0 0
  v 1.51312 -3.43108 5.75    -0.400472 0.906327 0.134886    0 0
  v -1.5092 -3.42181 5.675    0.400683 0.907034 0.129391    0 0
  v -0.767693 -3.65946 5.675    0.203378 0.970811 0.127138    0 0
  v 4.38418e-007 -3.73868 5.675    -5.86661e-005 0.991914 0.126913    0 0
  v 0.767694 -3.65946 5.675    -0.203416 0.970575 0.128867    0 0
  v 1.5092 -3.42181 5.675    -0.400581 0.906791 0.131393    0 0
  v -1.4909 -3.38756 5.525    0.376606 0.849506 0.36947    0 0
  v -0.757757 -3.62409 5.525    0.19216 0.911697 0.363157    0 0
  v 3.8773e-007 -3.70293 5.525    0.000150818 0.933634 0.358229    0 0
  v 0.757757 -3.62409 5.525    -0.192235 0.913396 0.358821    0 0
  v 1.4909 -3.38756 5.525    -0.377156 0.851409 0.364495    0 0
  v -1.47912 -3.35976 5.45    0.375196 0.84635 0.378047    0 0
  v -0.751862 -3.59416 5.45    0.190447 0.903022 0.385073    0 0
  v 3.60594e-007 -3.67229 5.45    0.000219066 0.921962 0.38728    0 0
  v 0.751862 -3.59416 5.45    -0.190309 0.903929 0.383008    0 0
  v 1.47912 -3.35976 5.45    -0.375574 0.847264 0.375616    0 0
  v -1.46832 -3.33089 5.375    0.374149 0.845896 0.380096    0 0
  v -0.746745 -3.56253 5.375    0.189224 0.900483 0.391567    0 0
  v 3.42727e-007 -3.63975 5.375    0.000158221 0.917943 0.396712    0 0
  v 0.746746 -3.56253 5.375    -0.189027 0.900524 0.391569    0 0
  v 1.46832 -3.33089 5.375    -0.374268 0.845844 0.380094    0 0
  v -1.45751 -3.30203 5.3    0.374072 0.847918 0.375639    0 0
  v -0.741629 -3.53091 5.3    0.189095 0.904185 0.383004    0 0
  v 3.3071e-007 -3.6072 5.3    -1.9638e-005 0.92197 0.387262    0 0
  v 0.74163 -3.53091 5.3    -0.188987 0.903329 0.385072    0 0
  v 1.45751 -3.30203 5.3    -0.373845 0.846937 0.378072    0 0
  v -1.44574 -3.27422 5.225    0.375581 0.852106 0.364492    0 0
  v -0.735734 -3.50098 5.225    0.190597 0.913748 0.358799    0 0
  v 3.3963e-007 -3.57657 5.225    -0.000311698 0.933646 0.358196    0 0
  v 0.735735 -3.50098 5.225    -0.190724 0.912009 0.36313    0 0
  v 1.44574 -3.27422 5.225    -0.374913 0.85025 0.369478    0 0
  v -1.40533 -3.19859 5.075    0.321408 0.722939 0.611601    0 0
  v -0.713791 -3.42286 5.075    0.165198 0.779805 0.603832    0 0
  v 3.79343e-007 -3.49761 5.075    0.000409092 0.801754 0.597653    0 0
  v 0.713792 -3.42286 5.075    -0.165328 0.783909 0.598459    0 0
  v 1.40533 -3.19859 5.075    -0.322744 0.727421 0.605553    0 0
  v -1.38243 -3.14453 5    0.318242 0.715618 0.621782    0 0
  v -0.702329 -3.36467 5    0.161202 0.759709 0.629965    0 0
  v 3.66579e-007 -3.43805 5    0.000443956 0.774541 0.632524    0 0
  v 0.70233 -3.36467 5    -0.160948 0.761717 0.627601    0 0
  v 1.38243 -3.14453 5    -0.319065 0.71771 0.618942    0 0
  v -1.36142 -3.0884 4.925    0.316224 0.714397 0.624211    0 0
  v -0.69238 -3.30317 4.925    0.158758 0.753933 0.63748    0 0
  v 3.61353e-007 -3.37477 4.925    0.00027723 0.765579 0.643342    0 0
  v 0.692381 -3.30317 4.925    -0.158408 0.753999 0.637489    0 0
  v 1.36142 -3.0884 4.925    -0.316434 0.71431 0.624204    0 0
  v -1.34041 -3.03227 4.85    0.316383 0.71885 0.618996    0 0
  v -0.682432 -3.24168 4.85    0.158798 0.762174 0.627594    0 0
  v 3.52241e-007 -3.31149 4.85    -9.0037e-005 0.774581 0.632474    0 0
  v 0.682433 -3.24168 4.85    -0.158616 0.760263 0.629953    0 0
  v 1.34041 -3.03227 4.85    -0.315832 0.716634 0.621841    0 0
  v -1.31751 -2.9782 4.775    0.319919 0.728673 0.605548    0 0
  v -0.670969 -3.18349 4.775    0.162392 0.784568 0.598399    0 0
  v 3.45428e-007 -3.25192 4.775    -0.000696824 0.801814 0.597574    0 0
  v 0.67097 -3.18349 4.775    -0.162635 0.780404 0.603755    0 0
  v 1.31751 -2.9782 4.775    -0.31838 0.724264 0.611617    0 0
  v -1.25271 -2.85691 4.63833    0.243295 0.545435 0.802065    0 0
  v -0.635779 -3.05819 4.63833    0.126122 0.591896 0.796086    0 0
  v 3.41881e-007 -3.12529 4.63833    0.000561124 0.611531 0.79122    0 0
  v 0.63578 -3.05819 4.63833    -0.126293 0.597436 0.791909    0 0
  v 1.25271 -2.85691 4.63833    -0.245069 0.55134 0.797474    0 0
  v -1.21999 -2.77967 4.57667    0.239253 0.536041 0.809579    0 0
  v -0.619404 -2.97506 4.57667    0.120941 0.565985 0.815496    0 0
  v 3.29695e-007 -3.04019 4.57667    0.000547215 0.576156 0.81734    0 0
  v 0.619405 -2.97506 4.57667    -0.120628 0.568459 0.81382    0 0
  v 1.21999 -2.77967 4.57667    -0.240285 0.53868 0.807519    0 0
  v -1.18998 -2.69949 4.515    0.236751 0.534435 0.811374    0 0
  v -0.605192 -2.88722 4.515    0.117929 0.558766 0.820898    0 0
  v 3.241e-007 -2.9498 4.515    0.00033549 0.565081 0.825036    0 0
  v 0.605193 -2.88722 4.515    -0.117499 0.558842 0.820908    0 0
  v 1.18998 -2.69949 4.515    -0.237006 0.534334 0.811366    0 0
  v -1.15997 -2.6193 4.45333    0.236975 0.540046 0.807585    0 0
  v -0.59098 -2.79937 4.45333    0.117996 0.569022 0.813812    0 0
  v 3.15002e-007 -2.8594 4.45333    -0.000112572 0.576238 0.817282    0 0
  v 0.59098 -2.79937 4.45333    -0.117778 0.566671 0.815483    0 0
  v 1.15997 -2.6193 4.45333    -0.236281 0.537254 0.809648    0 0
  v -1.12726 -2.54206 4.39167    0.241559 0.552898 0.797467    0 0
  v -0.574605 -2.71624 4.39167    0.122651 0.598295 0.791833    0 0
  v 3.08181e-007 -2.7743 4.39167    -0.000918652 0.611663 0.791118    0 0
  v 0.574605 -2.71624 4.39167    -0.122958 0.592698 0.795984    0 0
  v 1.12726 -2.54206 4.39167    -0.239548 0.547069 0.80208    0 0
  v -1.03424 -2.36798 4.26667    0.192114 0.427919 0.883163    0 0
  v -0.524096 -2.53641 4.26667    0.100285 0.466041 0.879061    0 0
  v 2.99414e-007 -2.59255 4.26667    0.000465952 0.482916 0.875667    0 0
  v 0.524097 -2.53641 4.26667    -0.10056 0.471415 0.87616    0 0
  v 1.03424 -2.36798 4.26667    -0.193766 0.433604 0.880024    0 0
  v -0.987133 -2.25675 4.20333    0.188159 0.419106 0.888226    0 0
  v -0.500516 -2.4167 4.20333    0.095381 0.441462 0.892196    0 0
  v 2.75998e-007 -2.47001 4.20333    0.000600517 0.449191 0.893435    0 0
  v 0.500517 -2.4167 4.20333    -0.0949805 0.443784 0.891086    0 0
  v 0.987134 -2.25675 4.20333    -0.189201 0.421549 0.886848    0 0
  v -0.943918 -2.14129 4.14    0.185079 0.417872 0.889454    0 0
  v -0.48005 -2.2902 4.14    0.0919657 0.434858 0.895791    0 0
  v 2.54717e-007 -2.33984 4.14    0.000474029 0.438923 0.898524    0 0
  v 0.480051 -2.2902 4.14    -0.0913534 0.434963 0.895802    0 0
  v 0.943918 -2.14129 4.14    -0.18544 0.417731 0.889445    0 0
  v -0.900702 -2.02582 4.07667    0.184465 0.423475 0.886928    0 0
  v -0.459585 -2.1637 4.07667    0.0912348 0.444588 0.891077    0 0
  v 2.3141e-007 -2.20966 4.07667    2.03e-005 0.44933 0.893366    0 0
  v 0.459585 -2.1637 4.07667    -0.0908762 0.442446 0.892179    0 0
  v 0.900702 -2.02582 4.07667    -0.183908 0.420813 0.88831    0 0
  v -0.853594 -1.9146 4.01333    0.18871 0.43585 0.880013    0 0
  v -0.436005 -2.04399 4.01333    0.0953245 0.47268 0.876063    0 0
  v 2.15315e-007 -2.08713 4.01333    -0.000978915 0.483152 0.875536    0 0
  v 0.436006 -2.04399 4.01333    -0.095748 0.46724 0.878931    0 0
  v 0.853594 -1.9146 4.01333    -0.186729 0.430263 0.88318    0 0
  v -0.728557 -1.68058 3.88833    0.155235 0.341575 0.926946    0 0
  v -0.368108 -1.80225 3.88833    0.081722 0.373058 0.924202    0 0
  v 1.97797e-007 -1.8428 3.88833    0.000260333 0.387451 0.92189    0 0
  v 0.368108 -1.80225 3.88833    -0.0821721 0.377832 0.922221    0 0
  v 0.728557 -1.68058 3.88833    -0.156595 0.346642 0.924834    0 0
  v -0.668363 -1.53846 3.82667    0.151567 0.333969 0.930318    0 0
  v -0.337978 -1.64929 3.82667    0.0774936 0.351475 0.932984    0 0
  v 1.77554e-007 -1.68623 3.82667    0.000686683 0.357729 0.933825    0 0
  v 0.337978 -1.64929 3.82667    -0.0769547 0.353538 0.932249    0 0
  v 0.668363 -1.53846 3.82667    -0.152612 0.336042 0.929401    0 0
  v -0.613143 -1.39092 3.765    0.147436 0.333445 0.93117    0 0
  v -0.311828 -1.48765 3.765    0.0733622 0.345983 0.935368    0 0
  v 1.6205e-007 -1.51989 3.765    0.000745133 0.348855 0.937177    0 0
  v 0.311828 -1.48765 3.765    -0.0723929 0.346146 0.935383    0 0
  v 0.613143 -1.39092 3.765    -0.148001 0.333228 0.931158    0 0
  v -0.557923 -1.24338 3.70333    0.145045 0.339096 0.929503    0 0
  v -0.285677 -1.32602 3.70333    0.0710179 0.354814 0.932236    0 0
  v 1.44378e-007 -1.35356 3.70333    0.000312519 0.357966 0.933735    0 0
  v 0.285678 -1.32602 3.70333    -0.0703233 0.353045 0.93296    0 0
  v 0.557923 -1.24338 3.70333    -0.144772 0.336675 0.930425    0 0
  v -0.497729 -1.10126 3.64167    0.148363 0.350302 0.924812    0 0
  v -0.255547 -1.17306 3.64167    0.0737192 0.379906 0.922083    0 0
  v 1.27455e-007 -1.19699 3.64167    -0.00107444 0.387875 0.921711    0 0
  v 0.255548 -1.17306 3.64167    -0.0743935 0.375042 0.924018    0 0
  v 0.497729 -1.10126 3.64167    -0.146499 0.345376 0.926959    0 0
  v -0.34677 -0.818731 3.51667    0.14496 0.30701 0.940602    0 0
  v -0.173574 -0.88119 3.51667    0.0778823 0.3366 0.938421    0 0
  v 9.5838e-008 -0.90201 3.51667    -0.000350048 0.35062 0.936518    0 0
  v 0.173574 -0.88119 3.51667    -0.0790328 0.34099 0.936739    0 0
  v 0.34677 -0.818731 3.51667    -0.145803 0.31189 0.938864    0 0
  v -0.277416 -0.654985 3.45333    0.141297 0.300215 0.943348    0 0
  v -0.138859 -0.704952 3.45333    0.0746713 0.316526 0.94564    0 0
  v 7.50614e-008 -0.721608 3.45333    0.00115957 0.322973 0.946408    0 0
  v 0.138859 -0.704952 3.45333    -0.0736056 0.318589 0.945031    0 0
  v 0.277416 -0.654984 3.45333    -0.142721 0.301935 0.942585    0 0
  v -0.213793 -0.484993 3.39    0.131112 0.302188 0.944188    0 0
  v -0.108729 -0.518721 3.39    0.0663064 0.312436 0.947622    0 0
  v 5.59383e-008 -0.529963 3.39    0.00239194 0.314924 0.949114    0 0
  v 0.108729 -0.518721 3.39    -0.0630241 0.312982 0.947666    0 0
  v 0.213793 -0.484993 3.39    -0.132721 0.301575 0.94416    0 0
  v -0.15017 -0.315001 3.32667    0.112911 0.314033 0.942674    0 0
  v -0.0785995 -0.332489 3.32667    0.0528479 0.323031 0.944912    0 0
  v 3.5694e-008 -0.338319 3.32667    0.00333671 0.323756 0.946135    0 0
  v 0.0785996 -0.332489 3.32667    -0.0469781 0.322482 0.945409    0 0
  v 0.15017 -0.315 3.32667    -0.112628 0.311755 0.943464    0 0
  v -0.0808164 -0.151254 3.26333    -0.0269682 0.390669 0.920136    0 0
  v -0.0438847 -0.156251 3.26333    0.0503758 0.340643 0.938842    0 0
  v 1.68125e-008 -0.157917 3.26333    -0.192011 0.342107 0.919834    0 0
  v 0.0438848 -0.156251 3.26333    0.159407 0.38776 0.907872    0 0
  v 0.0808164 -0.151254 3.26333    0.0448331 0.390238 0.919622    0 0
  v 2.83231 -2.53121 6.425    -0.744652 0.667088 0.0220856    0 0
  v 3.29493 -1.88984 6.425    -0.867101 0.497661 0.0216524    0 0
  v 3.61235 -1.17372 6.425    -0.950842 0.308943 0.02132    0 0
  v 3.77647 -0.407797 6.425    -0.994024 0.107049 0.0213592    0 0
  v 3.7792 0.383004 6.425    -0.994548 -0.101986 0.0217448    0 0
  v 2.83105 -2.53011 6.35    -0.744648 0.667071 0.0226842    0 0
  v 3.29345 -1.88901 6.35    -0.867071 0.497645 0.0231781    0 0
  v 3.61073 -1.1732 6.35    -0.950796 0.308938 0.0233334    0 0
  v 3.77479 -0.407595 6.35    -0.993986 0.107056 0.0230308    0 0
  v 3.77753 0.38286 6.35    -0.994531 -0.101984 0.0225124    0 0
  v 2.82971 -2.52905 6.275    -0.744677 0.667035 0.0228222    0 0
  v 3.29186 -1.8882 6.275    -0.86708 0.497608 0.0236355    0 0
  v 3.60901 -1.17264 6.275    -0.95078 0.308936 0.0240016    0 0
  v 3.77303 -0.407322 6.275    -0.993968 0.107095 0.0236347    0 0
  v 3.77582 0.382784 6.275    -0.994529 -0.10194 0.0228231    0 0
  v 2.82837 -2.52798 6.2    -0.744711 0.667007 0.0225128    0 0
  v 3.29028 -1.88739 6.2    -0.867113 0.497578 0.0230303    0 0
  v 3.60729 -1.17208 6.2    -0.950796 0.308938 0.0233325    0 0
  v 3.77127 -0.407049 6.2    -0.993975 0.107133 0.0231766    0 0
  v 3.77411 0.382709 6.2    -0.994537 -0.101895 0.0226823    0 0
  v 2.8271 -2.52688 6.125    -0.744726 0.667016 0.0217411    0 0
  v 3.2888 -1.88656 6.125    -0.867152 0.497585 0.0213585    0 0
  v 3.60567 -1.17155 6.125    -0.950842 0.308941 0.0213221    0 0
  v 3.76959 -0.406847 6.125    -0.994008 0.107136 0.021656    0 0
  v 3.77244 0.382564 6.125    -0.994551 -0.101885 0.0220856    0 0
  v 2.81925 -2.51872 5.975    -0.738199 0.661663 0.131395    0 0
  v 3.27988 -1.88062 5.975    -0.859961 0.493822 0.12887    0 0
  v 3.59575 -1.16833 5.975    -0.943365 0.306521 0.126916    0 0
  v 3.75888 -0.406415 5.975    -0.986205 0.106001 0.127139    0 0
  v 3.76129 0.380575 5.975    -0.986398 -0.101372 0.12939    0 0
  v 2.81165 -2.51212 5.9    -0.737876 0.66132 0.134884    0 0
  v 3.271 -1.87567 5.9    -0.858913 0.493242 0.137772    0 0
  v 3.58604 -1.16517 5.9    -0.941851 0.306079 0.13868    0 0
  v 3.74879 -0.405201 5.9    -0.984906 0.105898 0.136914    0 0
  v 3.75126 0.379706 5.9    -0.985802 -0.101334 0.133887    0 0
  v 2.80361 -2.50572 5.825    -0.737974 0.661041 0.135715    0 0
  v 3.2615 -1.87079 5.825    -0.8587 0.492858 0.140446    0 0
  v 3.57573 -1.16182 5.825    -0.941322 0.305912 0.142586    0 0
  v 3.73823 -0.403565 5.825    -0.98439 0.10607 0.140448    0 0
  v 3.74099 0.379254 5.825    -0.985579 -0.101068 0.135716    0 0
  v 2.79557 -2.49933 5.75    -0.738345 0.660999 0.133892    0 0
  v 3.25201 -1.86591 5.75    -0.859264 0.492868 0.136916    0 0
  v 3.56541 -1.15847 5.75    -0.941861 0.306048 0.138679    0 0
  v 3.72768 -0.40193 5.75    -0.98474 0.106328 0.137772    0 0
  v 3.73073 0.378803 5.75    -0.98572 -0.100801 0.134888    0 0
  v 2.78797 -2.49273 5.675    -0.738823 0.661362 0.129389    0 0
  v 3.24313 -1.86096 5.675    -0.860448 0.493421 0.127138    0 0
  v 3.5557 -1.15532 5.675    -0.943384 0.306463 0.126913    0 0
  v 3.71759 -0.400716 5.675    -0.985931 0.106464 0.128866    0 0
  v 3.7207 0.377933 5.675    -0.986196 -0.100761 0.131394    0 0
  v 2.76105 -2.46474 5.525    -0.69155 0.620685 0.369471    0 0
  v 3.21255 -1.84057 5.525    -0.807695 0.464485 0.363157    0 0
  v 3.52169 -1.14427 5.525    -0.887892 0.288652 0.358229    0 0
  v 3.68087 -0.399234 5.525    -0.928095 0.0994284 0.358823    0 0
  v 3.68248 0.371113 5.525    -0.926285 -0.0955968 0.364495    0 0
  v 2.73825 -2.44495 5.45    -0.688985 0.618369 0.378048    0 0
  v 3.18591 -1.82572 5.45    -0.799973 0.460174 0.385075    0 0
  v 3.49256 -1.1348 5.45    -0.87677 0.28511 0.387281    0 0
  v 3.65059 -0.395592 5.45    -0.918497 0.0983346 0.383007    0 0
  v 3.65239 0.368505 5.45    -0.921855 -0.0953728 0.375616    0 0
  v 2.71413 -2.42575 5.375    -0.688877 0.617233 0.380096    0 0
  v 3.15741 -1.81108 5.375    -0.797937 0.458228 0.391566    0 0
  v 3.46161 -1.12474 5.375    -0.872966 0.28381 0.396714    0 0
  v 3.61893 -0.390686 5.375    -0.914861 0.0985015 0.39157    0 0
  v 3.6216 0.36715 5.375    -0.920101 -0.0945692 0.380094    0 0
  v 2.69002 -2.40656 5.3    -0.690823 0.617784 0.375641    0 0
  v 3.12892 -1.79644 5.3    -0.801497 0.459248 0.383006    0 0
  v 3.43066 -1.11469 5.3    -0.876852 0.284886 0.387261    0 0
  v 3.58727 -0.385779 5.3    -0.917517 0.0994069 0.385071    0 0
  v 3.59081 0.365795 5.3    -0.921009 -0.0938299 0.378072    0 0
  v 2.66721 -2.38677 5.225    -0.69434 0.620514 0.364491    0 0
  v 3.10228 -1.78159 5.225    -0.810128 0.463632 0.3588    0 0
  v 3.40152 -1.10522 5.225    -0.888046 0.288216 0.358199    0 0
  v 3.55699 -0.382138 5.225    -0.92631 0.100437 0.363129    0 0
  v 3.56072 0.363187 5.225    -0.924491 -0.093822 0.369478    0 0
  v 2.60777 -2.32497 5.075    -0.588235 0.529078 0.611602    0 0
  v 3.03476 -1.73658 5.075    -0.69059 0.398086 0.603832    0 0
  v 3.32643 -1.08082 5.075    -0.762388 0.248145 0.597652    0 0
  v 3.4759 -0.378864 5.075    -0.796631 0.085005 0.598458    0 0
  v 3.47631 0.348127 5.075    -0.791552 -0.0821627 0.605553    0 0
  v 2.56343 -2.28648 5    -0.58225 0.523804 0.621783    0 0
  v 2.98296 -1.70769 5    -0.672712 0.388075 0.629965    0 0
  v 3.26978 -1.06241 5    -0.736495 0.239769 0.632524    0 0
  v 3.41702 -0.371783 5    -0.774172 0.0823124 0.6276    0 0
  v 3.41781 0.343055 5    -0.78118 -0.0816637 0.618942    0 0
  v 2.51654 -2.24915 4.925    -0.581714 0.521508 0.62421    0 0
  v 2.92755 -1.67923 4.925    -0.667974 0.383966 0.63748    0 0
  v 3.20959 -1.04286 4.925    -0.728023 0.236841 0.643342    0 0
  v 3.35546 -0.362243 4.925    -0.766046 0.0823441 0.637489    0 0
  v 3.35794 0.340421 4.925    -0.777132 -0.080213 0.624205    0 0
  v 2.46965 -2.21183 4.85    -0.5859 0.523035 0.618996    0 0
  v 2.87214 -1.65077 4.85    -0.6758 0.386551 0.627593    0 0
  v 3.14941 -1.02331 4.85    -0.736699 0.239273 0.632473    0 0
  v 3.29391 -0.352703 4.85    -0.772069 0.0840812 0.629953    0 0
  v 3.29807 0.337786 4.85    -0.779157 -0.0789224 0.62184    0 0
  v 2.4253 -2.17334 4.775    -0.594149 0.529433 0.605547    0 0
  v 2.82034 -1.62188 4.775    -0.695988 0.396889 0.598398    0 0
  v 3.09276 -1.0049 4.775    -0.762787 0.247112 0.597572    0 0
  v 3.23502 -0.345622 4.775    -0.792466 0.0864828 0.603754    0 0
  v 3.23957 0.332715 4.775    -0.787202 -0.078988 0.611616    0 0
  v 2.32998 -2.07423 4.63833    -0.443557 0.399936 0.802065    0 0
  v 2.71205 -1.5497 4.63833    -0.523952 0.302855 0.796086    0 0
  v 2.97233 -0.965767 4.63833    -0.581427 0.189507 0.79122    0 0
  v 3.10498 -0.340372 4.63833    -0.607222 0.0645059 0.791909    0 0
  v 3.10419 0.308561 4.63833    -0.600085 -0.0627004 0.797475    0 0
  v 2.26663 -2.01925 4.57667    -0.435872 0.393189 0.809579    0 0
  v 2.63805 -1.50843 4.57667    -0.500911 0.289921 0.815496    0 0
  v 2.8914 -0.939471 4.57667    -0.547788 0.178562 0.81734    0 0
  v 3.02086 -0.330256 4.57667    -0.577913 0.0609392 0.81382    0 0
  v 3.02062 0.301316 4.57667    -0.586567 -0.0620633 0.807519    0 0
  v 2.19964 -1.96593 4.515    -0.435118 0.390313 0.811374    0 0
  v 2.55889 -1.46777 4.515    -0.494975 0.284825 0.820898    0 0
  v 2.80542 -0.911537 4.515    -0.537319 0.174938 0.825036    0 0
  v 2.93292 -0.316627 4.515    -0.567799 0.0609435 0.820908    0 0
  v 2.93509 0.297553 4.515    -0.58142 -0.060288 0.811367    0 0
  v 2.13265 -1.91261 4.45333    -0.440385 0.392259 0.807585    0 0
  v 2.47974 -1.42711 4.45333    -0.504709 0.288058 0.813812    0 0
  v 2.71945 -0.883602 4.45333    -0.548069 0.17796 0.817283    0 0
  v 2.84499 -0.302998 4.45333    -0.575332 0.0630978 0.815483    0 0
  v 2.84955 0.29379 4.45333    -0.583973 -0.0586958 0.809648    0 0
  v 2.0693 -1.85763 4.39167    -0.451192 0.400591 0.797467    0 0
  v 2.40574 -1.38585 4.39167    -0.531112 0.301531 0.791833    0 0
  v 2.63852 -0.857306 4.39167    -0.582011 0.188141 0.791117    0 0
  v 2.76086 -0.292883 4.39167    -0.601685 0.0662135 0.795984    0 0
  v 2.76599 0.286545 4.39167    -0.594317 -0.0587701 0.80208    0 0
  v 1.93248 -1.71537 4.26667    -0.347608 0.314945 0.883164    0 0
  v 2.25031 -1.28224 4.26667    -0.412241 0.239391 0.879061    0 0
  v 2.46566 -0.801141 4.26667    -0.459136 0.149672 0.875667    0 0
  v 2.57422 -0.285347 4.26667    -0.479416 0.0500373 0.87616    0 0
  v 2.57168 0.251877 4.26667    -0.472259 -0.0502908 0.880024    0 0
  v 1.84126 -1.63619 4.20333    -0.340449 0.308461 0.888226    0 0
  v 2.14375 -1.22282 4.20333    -0.390381 0.227132 0.892196    0 0
  v 2.34912 -0.763275 4.20333    -0.427021 0.139379 0.893435    0 0
  v 2.45308 -0.270781 4.20333    -0.451414 0.0468049 0.891086    0 0
  v 2.45134 0.241445 4.20333    -0.459383 -0.0496747 0.886848    0 0
  v 1.7448 -1.55941 4.14    -0.340227 0.30515 0.889454    0 0
  v 2.02977 -1.16427 4.14    -0.385156 0.221843 0.895791    0 0
  v 2.22532 -0.723049 4.14    -0.417295 0.136086 0.898524    0 0
  v 2.32645 -0.251155 4.14    -0.441904 0.0475285 0.895802    0 0
  v 2.32817 0.236025 4.14    -0.454591 -0.0472781 0.889445    0 0
  v 1.64834 -1.48263 4.07667    -0.345746 0.306297 0.886928    0 0
  v 1.91578 -1.10571 4.07667    -0.394635 0.224155 0.891077    0 0
  v 2.10152 -0.682824 4.07667    -0.427332 0.13887 0.893366    0 0
  v 2.19982 -0.231529 4.07667    -0.448873 0.0502948 0.892179    0 0
  v 2.205 0.230606 4.07667    -0.457048 -0.044869 0.88831    0 0
  v 1.55712 -1.40346 4.01333    -0.356204 0.314159 0.880013    0 0
  v 1.80922 -1.04629 4.01333    -0.420089 0.236725 0.876063    0 0
  v 1.98498 -0.644957 4.01333    -0.459807 0.148371 0.875536    0 0
  v 2.07869 -0.216963 4.01333    -0.473959 0.0533232 0.878931    0 0
  v 2.08467 0.220173 4.01333    -0.466906 -0.0446316 0.88318    0 0
  v 1.37319 -1.21223 3.88833    -0.276886 0.253189 0.926946    0 0
  v 1.60029 -0.907017 3.88833    -0.329546 0.193003 0.924202    0 0
  v 1.75261 -0.569457 3.88833    -0.368408 0.119977 0.92189    0 0
  v 1.82779 -0.206833 3.88833    -0.384732 0.0386062 0.92222    0 0
  v 1.82346 0.173571 3.88833    -0.378066 -0.0418121 0.924834    0 0
  v 1.25663 -1.11106 3.82667    -0.270787 0.24735 0.930318    0 0
  v 1.46412 -0.831094 3.82667    -0.310326 0.182313 0.932985    0 0
  v 1.6037 -0.521073 3.82667    -0.340008 0.111197 0.933825    0 0
  v 1.67301 -0.188221 3.82667    -0.360015 0.036061 0.932249    0 0
  v 1.6697 0.16024 3.82667    -0.366755 -0.0413004 0.929401    0 0
  v 1.13337 -1.01295 3.765    -0.271564 0.24326 0.93117    0 0
  v 1.31848 -0.756275 3.765    -0.306379 0.176686 0.935368    0 0
  v 1.44551 -0.469673 3.765    -0.33155 0.108511 0.937177    0 0
  v 1.5112 -0.163143 3.765    -0.351575 0.0381153 0.935384    0 0
  v 1.51232 0.153316 3.765    -0.362653 -0.0377845 0.931158    0 0
  v 1.01012 -0.914843 3.70333    -0.277678 0.242732 0.929503    0 0
  v 1.17284 -0.681457 3.70333    -0.315502 0.177186 0.932236    0 0
  v 1.28731 -0.418273 3.70333    -0.340349 0.110915 0.933735    0 0
  v 1.3494 -0.138066 3.70333    -0.357497 0.0422155 0.93296    0 0
  v 1.35493 0.146391 3.70333    -0.364934 -0.0336484 0.930425    0 0
  v 0.893556 -0.813677 3.64167    -0.28731 0.249351 0.924812    0 0
  v 1.03667 -0.605534 3.64167    -0.338532 0.187509 0.922083    0 0
  v 1.1384 -0.369889 3.64167    -0.369223 0.118838 0.921711    0 0
  v 1.19461 -0.119454 3.64167    -0.379676 0.045142 0.924018    0 0
  v 1.20117 0.13306 3.64167    -0.373743 -0.0326012 0.926959    0 0
  v 0.671501 -0.5828 3.51667    -0.247189 0.232737 0.940602    0 0
  v 0.784424 -0.437382 3.51667    -0.296059 0.178086 0.938421    0 0
  v 0.857862 -0.278736 3.51667    -0.333567 0.108014 0.936518    0 0
  v 0.891699 -0.107224 3.51667    -0.348722 0.0302071 0.936739    0 0
  v 0.885817 0.0767965 3.51667    -0.34168 -0.0422871 0.938864    0 0
  v 0.537201 -0.46624 3.45333    -0.241858 0.227154 0.943348    0 0
  v 0.627539 -0.349905 3.45333    -0.277959 0.168829 0.94564    0 0
  v 0.68629 -0.222989 3.45333    -0.306807 0.100907 0.946408    0 0
  v 0.713359 -0.0857792 3.45333    -0.325742 0.0284464 0.945031    0 0
  v 0.708654 0.0614371 3.45333    -0.33126 -0.0424323 0.942585    0 0
  v 0.395189 -0.3532 3.39    -0.246883 0.218076 0.944188    0 0
  v 0.459733 -0.263701 3.39    -0.276655 0.15961 0.947622    0 0
  v 0.504025 -0.163768 3.39    -0.298772 0.0995918 0.949114    0 0
  v 0.526932 -0.0568857 3.39    -0.317139 0.0367773 0.947666    0 0
  v 0.527321 0.0534587 3.39    -0.327828 -0.0330335 0.94416    0 0
  v 0.253178 -0.240161 3.32667    -0.263771 0.204426 0.942674    0 0
  v 0.291927 -0.177497 3.32667    -0.29089 0.150084 0.944912    0 0
  v 0.32176 -0.104546 3.32667    -0.306879 0.10322 0.946135    0 0
  v 0.340504 -0.0279922 3.32667    -0.321215 0.0549736 0.945409    0 0
  v 0.345988 0.0454803 3.32667    -0.331301 -0.0107778 0.943464    0 0
  v 0.118878 -0.123601 3.26333    -0.241538 0.24143 0.939878    0 0
  v 0.135042 -0.0900211 3.26333    -0.270915 0.222108 0.936629    0 0
  v 0.150188 -0.0487988 3.26333    -0.369797 -0.00925414 0.929067    0 0
  v 0.162165 -0.00654721 3.26333    -0.319775 0.270297 0.908121    0 0
  v 0.168825 0.0301211 3.26333    -0.341562 0.0397976 0.939016    0 0
  v 3.28256 1.9115 6.425    -0.864548 -0.502065 0.0220846    0 0
  v 2.81553 2.54967 6.425    -0.741253 -0.670877 0.0216526    0 0
  v 2.23255 3.07285 6.425    -0.587649 -0.808835 0.0213206    0 0
  v 1.55483 3.46562 6.425    -0.40898 -0.912293 0.02136    0 0
  v 0.803578 3.71259 6.425    -0.210337 -0.977387 0.0217438    0 0
  v 3.28112 1.91064 6.35    -0.864532 -0.502066 0.0226831    0 0
  v 2.81429 2.54852 6.35    -0.741229 -0.670853 0.0231774    0 0
  v 2.23155 3.07147 6.35    -0.58763 -0.808793 0.0233327    0 0
  v 1.55412 3.46408 6.35    -0.408975 -0.912255 0.02303    0 0
  v 0.8032 3.71095 6.35    -0.210335 -0.97737 0.022511    0 0
  v 3.2797 1.90969 6.275    -0.864506 -0.502105 0.0228242    0 0
  v 2.81303 2.54726 6.275    -0.741195 -0.670873 0.0236359    0 0
  v 2.23049 3.07001 6.275    -0.587623 -0.808779 0.0240032    0 0
  v 1.55332 3.4625 6.275    -0.409007 -0.912225 0.0236364    0 0
  v 0.802742 3.7093 6.275    -0.210375 -0.977354 0.022826    0 0
  v 3.27827 1.90875 6.2    -0.86449 -0.502146 0.0225114    0 0
  v 2.81176 2.54601 6.2    -0.741178 -0.670914 0.0230296    0 0
  v 2.22943 3.06854 6.2    -0.587629 -0.808794 0.0233327    0 0
  v 1.55251 3.46091 6.2    -0.409045 -0.91222 0.0231767    0 0
  v 0.802285 3.70765 6.2    -0.210421 -0.977348 0.0226829    0 0
  v 3.27683 1.90788 6.125    -0.864503 -0.502157 0.0217443    0 0
  v 2.81052 2.54486 6.125    -0.741196 -0.670948 0.0213592    0 0
  v 2.22843 3.06717 6.125    -0.587647 -0.808836 0.0213215    0 0
  v 1.5518 3.45937 6.125    -0.409058 -0.912251 0.021655    0 0
  v 0.801907 3.70602 6.125    -0.210435 -0.977358 0.0220844    0 0
  v 3.26664 1.90294 5.975    -0.857395 -0.497604 0.131392    0 0
  v 2.80211 2.53821 5.975    -0.735395 -0.665272 0.128868    0 0
  v 2.2223 3.05873 5.975    -0.583035 -0.802473 0.126916    0 0
  v 1.54808 3.44932 5.975    -0.405567 -0.90518 0.127141    0 0
  v 0.800353 3.6948 5.975    -0.208404 -0.969446 0.129391    0 0
  v 3.25802 1.89775 5.9    -0.856969 -0.497403 0.134884    0 0
  v 2.79466 2.5313 5.9    -0.73452 -0.664455 0.137771    0 0
  v 2.2163 3.05047 5.9    -0.582147 -0.80117 0.138679    0 0
  v 1.54381 3.44009 5.9    -0.405068 -0.903977 0.136913    0 0
  v 0.798081 3.68499 5.9    -0.208255 -0.968867 0.133886    0 0
  v 3.24945 1.89208 5.825    -0.856734 -0.497582 0.135717    0 0
  v 2.78708 2.52377 5.825    -0.734088 -0.664371 0.140447    0 0
  v 2.20992 3.04169 5.825    -0.581824 -0.800718 0.142587    0 0
  v 1.53899 3.43056 5.825    -0.405072 -0.903433 0.140448    0 0
  v 0.795339 3.67509 5.825    -0.208439 -0.968573 0.135716    0 0
  v 3.24088 1.88641 5.75    -0.856809 -0.497948 0.13389    0 0
  v 2.77951 2.51624 5.75    -0.734273 -0.664905 0.136914    0 0
  v 2.20354 3.03292 5.75    -0.58212 -0.801189 0.138677    0 0
  v 1.53418 3.42103 5.75    -0.405425 -0.903686 0.137772    0 0
  v 0.792597 3.66519 5.75    -0.208737 -0.968625 0.134888    0 0
  v 3.23225 1.88122 5.675    -0.857301 -0.498291 0.12939    0 0
  v 2.77205 2.50933 5.675    -0.735165 -0.66586 0.127138    0 0
  v 2.19754 3.02466 5.675    -0.582985 -0.80251 0.126912    0 0
  v 1.5299 3.41181 5.675    -0.405923 -0.904777 0.128864    0 0
  v 0.790325 3.65539 5.675    -0.208922 -0.969065 0.131393    0 0
  v 3.19732 1.86427 5.525    -0.804007 -0.465901 0.36947    0 0
  v 2.74322 2.48655 5.525    -0.691343 -0.62463 0.363157    0 0
  v 2.17652 2.99573 5.525    -0.548898 -0.755237 0.358229    0 0
  v 1.51715 3.37735 5.525    -0.381359 -0.851945 0.358824    0 0
  v 0.784999 3.61692 5.525    -0.19532 -0.910491 0.364495    0 0
  v 3.17145 1.8487 5.45    -0.801012 -0.464177 0.378048    0 0
  v 2.72086 2.4658 5.45    -0.684857 -0.618618 0.385075    0 0
  v 2.15852 2.97095 5.45    -0.542093 -0.745754 0.38728    0 0
  v 1.50432 3.34967 5.45    -0.377353 -0.843155 0.383007    0 0
  v 0.778183 3.58751 5.45    -0.194164 -0.906208 0.375617    0 0
  v 3.14574 1.83169 5.375    -0.799898 -0.464425 0.380096    0 0
  v 2.69813 2.44322 5.375    -0.682376 -0.617283 0.391567    0 0
  v 2.13939 2.94462 5.375    -0.539681 -0.742538 0.396714    0 0
  v 1.48987 3.32108 5.375    -0.376388 -0.839646 0.39157    0 0
  v 0.769956 3.5578 5.375    -0.194386 -0.904291 0.380094    0 0
  v 3.12003 1.81469 5.3    -0.801024 -0.466106 0.375639    0 0
  v 2.67541 2.42065 5.3    -0.684448 -0.620354 0.383004    0 0
  v 2.12026 2.91829 5.3    -0.541905 -0.745901 0.38726    0 0
  v 1.47543 3.29248 5.3    -0.37807 -0.841893 0.385071    0 0
  v 0.761729 3.5281 5.3    -0.19537 -0.904927 0.378072    0 0
  v 3.09416 1.79912 5.225    -0.804707 -0.468607 0.364491    0 0
  v 2.65305 2.3999 5.225    -0.691284 -0.627207 0.3588    0 0
  v 2.10225 2.89351 5.225    -0.548531 -0.755518 0.358198    0 0
  v 1.4626 3.26481 5.225    -0.381767 -0.849937 0.363127    0 0
  v 0.754913 3.49868 5.225    -0.196453 -0.908236 0.369476    0 0
  v 3.01702 1.76169 5.075    -0.684957 -0.395951 0.611601    0 0
  v 2.58937 2.34959 5.075    -0.592006 -0.533775 0.603832    0 0
  v 2.05584 2.82963 5.075    -0.471591 -0.648393 0.597653    0 0
  v 1.43443 3.18871 5.075    -0.327017 -0.731373 0.59846    0 0
  v 0.743151 3.41375 5.075    -0.166462 -0.7782 0.605554    0 0
  v 2.96671 1.7314 5    -0.678093 -0.391889 0.621782    0 0
  v 2.5459 2.30925 5    -0.576961 -0.519866 0.629965    0 0
  v 2.02083 2.78144 5    -0.455623 -0.626356 0.632523    0 0
  v 1.4095 3.13489 5    -0.317516 -0.710846 0.6276    0 0
  v 0.729898 3.35654 5    -0.163731 -0.768181 0.618942    0 0
  v 2.91673 1.69834 4.925    -0.675743 -0.392087 0.624211    0 0
  v 2.5017 2.26535 4.925    -0.571588 -0.516628 0.637481    0 0
  v 1.98364 2.73024 4.925    -0.45022 -0.619203 0.643342    0 0
  v 1.38141 3.07929 4.925    -0.315035 -0.703108 0.637489    0 0
  v 0.713901 3.29879 4.925    -0.16386 -0.763884 0.624205    0 0
  v 2.86674 1.66528 4.85    -0.678489 -0.395596 0.618997    0 0
  v 2.45751 2.22145 4.85    -0.576466 -0.523274 0.627592    0 0
  v 1.94644 2.67905 4.85    -0.455215 -0.626703 0.632473    0 0
  v 1.35331 3.0237 4.85    -0.318548 -0.708298 0.629953    0 0
  v 0.697905 3.24103 4.85    -0.165713 -0.765411 0.621839    0 0
  v 2.81643 1.635 4.775    -0.687123 -0.401465 0.605547    0 0
  v 2.41403 2.18111 4.775    -0.592536 -0.539278 0.598398    0 0
  v 1.91143 2.63086 4.775    -0.470732 -0.649092 0.597571    0 0
  v 1.32838 2.96988 4.775    -0.327136 -0.726956 0.603753    0 0
  v 0.684651 3.18383 4.775    -0.168137 -0.773082 0.611616    0 0
  v 2.69271 1.57497 4.63833    -0.517429 -0.298261 0.802064    0 0
  v 2.31192 2.10043 4.63833    -0.449943 -0.404721 0.796085    0 0
  v 1.837 2.52841 4.63833    -0.359903 -0.494409 0.79122    0 0
  v 1.28321 2.84783 4.63833    -0.248991 -0.557569 0.791909    0 0
  v 0.665789 3.04761 4.63833    -0.125805 -0.59009 0.797475    0 0
  v 2.62084 1.53171 4.57667    -0.508636 -0.293037 0.809579    0 0
  v 2.24981 2.0428 4.57667    -0.430521 -0.386804 0.815496    0 0
  v 1.78698 2.45957 4.57667    -0.339099 -0.465798 0.81734    0 0
  v 1.24759 2.77095 4.57667    -0.236542 -0.530796 0.81382    0 0
  v 0.646855 2.9659 4.57667    -0.122233 -0.577037 0.807519    0 0
  v 2.54943 1.48448 4.515    -0.505668 -0.293208 0.811374    0 0
  v 2.18667 1.98009 4.515    -0.42384 -0.382734 0.820898    0 0
  v 1.73385 2.38644 4.515    -0.332417 -0.456962 0.825036    0 0
  v 1.20745 2.69153 4.515    -0.23342 -0.521176 0.820908    0 0
  v 0.624003 2.88338 4.515    -0.122332 -0.571594 0.811367    0 0
  v 2.47802 1.43725 4.45333    -0.509148 -0.297616 0.807585    0 0
  v 2.12354 1.91737 4.45333    -0.429924 -0.390993 0.813812    0 0
  v 1.68071 2.3133 4.45333    -0.338613 -0.466252 0.817282    0 0
  v 1.16732 2.61211 4.45333    -0.237797 -0.527675 0.815483    0 0
  v 0.60115 2.80087 4.45333    -0.124635 -0.573529 0.809648    0 0
  v 2.40616 1.39399 4.39167    -0.52041 -0.305319 0.797467    0 0
  v 2.06143 1.85974 4.39167    -0.450896 -0.411939 0.791833    0 0
  v 1.63069 2.24446 4.39167    -0.358784 -0.495387 0.791117    0 0
  v 1.1317 2.53523 4.39167    -0.248904 -0.551776 0.795983    0 0
  v 0.582217 2.71916 4.39167    -0.127761 -0.583391 0.80208    0 0
  v 2.22858 1.30782 4.26667    -0.406947 -0.233272 0.883164    0 0
  v 1.91486 1.74394 4.26667    -0.355064 -0.318089 0.879061    0 0
  v 1.52386 2.09742 4.26667    -0.284228 -0.390413 0.875667    0 0
  v 1.06686 2.36005 4.26667    -0.195736 -0.440489 0.87616    0 0
  v 0.555143 2.52365 4.26667    -0.0981066 -0.464685 0.880024    0 0
  v 2.12509 1.24553 4.20333    -0.398568 -0.228467 0.888226    0 0
  v 1.82543 1.66095 4.20333    -0.33665 -0.301087 0.892196    0 0
  v 1.45184 1.99828 4.20333    -0.264514 -0.363051 0.893435    0 0
  v 1.01557 2.24935 4.20333    -0.184009 -0.414857 0.891086    0 0
  v 0.527879 2.40597 4.20333    -0.0947137 -0.452249 0.886848    0 0
  v 2.02226 1.17752 4.14    -0.395351 -0.229279 0.889454    0 0
  v 1.73452 1.57064 4.14    -0.330005 -0.297752 0.895791    0 0
  v 1.37532 1.89297 4.14    -0.258376 -0.354818 0.898524    0 0
  v 0.957777 2.13498 4.14    -0.181758 -0.405589 0.895802    0 0
  v 0.494972 2.28716 4.14    -0.0955121 -0.446951 0.889445    0 0
  v 1.91943 1.1095 4.07667    -0.398147 -0.234173 0.886928    0 0
  v 1.6436 1.48034 4.07667    -0.335133 -0.306053 0.891077    0 0
  v 1.29881 1.78766 4.07667    -0.264126 -0.363504 0.893366    0 0
  v 0.899981 2.02061 4.07667    -0.186543 -0.411362 0.892179    0 0
  v 0.462064 2.16834 4.07667    -0.0985626 -0.448544 0.88831    0 0
  v 1.81594 1.04721 4.01333    -0.408856 -0.241689 0.880013    0 0
  v 1.55417 1.39735 4.01333    -0.354954 -0.326376 0.876063    0 0
  v 1.22678 1.68852 4.01333    -0.283198 -0.391453 0.875536    0 0
  v 0.848694 1.9099 4.01333    -0.197175 -0.434284 0.878931    0 0
  v 0.4348 2.05067 4.01333    -0.101835 -0.457846 0.88318    0 0
  v 1.57724 0.931384 3.88833    -0.32636 -0.185095 0.926946    0 0
  v 1.35714 1.24168 3.88833    -0.285392 -0.253775 0.924202    0 0
  v 1.08317 1.49086 3.88833    -0.227949 -0.313302 0.92189    0 0
  v 0.761529 1.67442 3.88833    -0.155606 -0.353972 0.92222    0 0
  v 0.398406 1.78785 3.88833    -0.0770634 -0.372483 0.924834    0 0
  v 1.445 0.851788 3.82667    -0.318922 -0.181098 0.930318    0 0
  v 1.24286 1.13564 3.82667    -0.269286 -0.2388 0.932985    0 0
  v 0.99114 1.36419 3.82667    -0.210823 -0.289005 0.933825    0 0
  v 0.695996 1.53296 3.82667    -0.145547 -0.331251 0.932249    0 0
  v 0.363568 1.6375 3.82667    -0.0740546 -0.361567 0.929401    0 0
  v 1.31361 0.764883 3.765    -0.315272 -0.183102 0.93117    0 0
  v 1.12669 1.02025 3.765    -0.262715 -0.236785 0.935368    0 0
  v 0.893372 1.22962 3.765    -0.205654 -0.281791 0.937177    0 0
  v 0.622145 1.38682 3.765    -0.144892 -0.322589 0.935384    0 0
  v 0.32152 1.48568 3.765    -0.0761309 -0.35658 0.931158    0 0
  v 1.18221 0.677978 3.70333    -0.316659 -0.18908 0.929503    0 0
  v 1.01053 0.904853 3.70333    -0.266009 -0.245307 0.932236    0 0
  v 0.795603 1.09505 3.70333    -0.21066 -0.289417 0.933735    0 0
  v 0.548295 1.24069 3.70333    -0.150622 -0.326955 0.93296    0 0
  v 0.279472 1.33386 3.70333    -0.0807693 -0.357471 0.930425    0 0
  v 1.04998 0.598382 3.64167    -0.32593 -0.196194 0.924812    0 0
  v 0.896247 0.798815 3.64167    -0.282944 -0.26402 0.922083    0 0
  v 0.703571 0.968382 3.64167    -0.227118 -0.314429 0.921711    0 0
  v 0.482762 1.09923 3.64167    -0.160259 -0.347144 0.924017    0 0
  v 0.244634 1.1835 3.64167    -0.0844874 -0.365525 0.926959    0 0
  v 0.761781 0.458541 3.51667    -0.297731 -0.163171 0.940602    0 0
  v 0.658375 0.610873 3.51667    -0.260857 -0.226537 0.938421    0 0
  v 0.530188 0.729741 3.51667    -0.205806 -0.283863 0.936518    0 0
  v 0.377526 0.814922 3.51667    -0.13649 -0.32232 0.936739    0 0
  v 0.200695 0.866194 3.51667    -0.0653675 -0.338024 0.938864    0 0
  v 0.609425 0.366832 3.45333    -0.290774 -0.159827 0.943348    0 0
  v 0.5267 0.488699 3.45333    -0.24646 -0.212184 0.94564    0 0
  v 0.42415 0.583793 3.45333    -0.190777 -0.260609 0.946408    0 0
  v 0.302021 0.651938 3.45333    -0.127714 -0.301008 0.945031    0 0
  v 0.160556 0.692955 3.45333    -0.0620095 -0.32816 0.942585    0 0
  v 0.458034 0.266703 3.39    -0.283693 -0.16741 0.944189    0 0
  v 0.39286 0.355744 3.39    -0.237289 -0.213792 0.947622    0 0
  v 0.311505 0.428749 3.39    -0.187043 -0.253373 0.949114    0 0
  v 0.216932 0.483563 3.39    -0.132979 -0.290252 0.947666    0 0
  v 0.112109 0.518032 3.39    -0.0698874 -0.321991 0.94416    0 0
  v 0.306643 0.166573 3.32667    -0.275931 -0.18769 0.942674    0 0
  v 0.25902 0.22279 3.32667    -0.232628 -0.230274 0.944912    0 0
  v 0.198859 0.273705 3.32667    -0.192999 -0.259963 0.946135    0 0
  v 0.131844 0.315189 3.32667    -0.151544 -0.288506 0.945409    0 0
  v 0.0636621 0.343109 3.32667    -0.0921276 -0.318417 0.943464    0 0
  v 0.154287 0.0748646 3.26333    -0.233475 -0.290703 0.927891    0 0
  v 0.127346 0.100615 3.26333    -0.199448 -0.306503 0.93074    0 0
  v 0.092821 0.127757 3.26333    -0.106528 -0.353888 0.929201    0 0
  v 0.0563385 0.152205 3.26333    -0.355698 -0.220707 0.908167    0 0
  v 0.0235231 0.16987 3.26333    0.0620349 -0.34281 0.937354    0 0
  t 470 471 476
  t 476 475 470
  t 471 472 477
  t 477 476 471
  t 472 473 478
  t 478 477 472
  t 473 474 479
  t 479 478 473
  t 475 476 481
  t 481 480 475
  t 476 477 482
  t 482 481 476
  t 477 478 483
  t 483 482 477
  t 478 479 484
  t 484 483 478
  t 480 481 486
  t 486 485 480
  t 481 482 487
  t 487 486 481
  t 482 483 488
  t 488 487 482
  t 483 484 489
  t 489 488 483
  t 485 486 491
  t 491 490 485
  t 486 487 492
  t 492 491 486
  t 487 488 493
  t 493 492 487
  t 488 489 494
  t 494 493 488
  t 0 45 470
  t 470 64 0
  t 50 474 49
  t 49 9 50
  t 10 55 494
  t 494 54 10
  t 60 490 59
  t 59 1 60
  t 45 46 471
  t 471 470 45
  t 51 479 474
  t 474 50 51
  t 55 56 493
  t 493 494 55
  t 61 485 490
  t 490 60 61
  t 46 47 472
  t 472 471 46
  t 52 484 479
  t 479 51 52
  t 56 57 492
  t 492 493 56
  t 62 480 485
  t 485 61 62
  t 47 48 473
  t 473 472 47
  t 53 489 484
  t 484 52 53
  t 57 58 491
  t 491 492 57
  t 63 475 480
  t 480 62 63
  t 48 49 474
  t 474 473 48
  t 54 494 489
  t 489 53 54
  t 58 59 490
  t 490 491 58
  t 64 470 475
  t 475 63 64
  t 495 496 501
  t 501 500 495
  t 496 497 502
  t 502 501 496
  t 497 498 503
  t 503 502 497
  t 498 499 504
  t 504 503 498
  t 500 501 506
  t 506 505 500
  t 501 502 507
  t 507 506 501
  t 502 503 508
  t 508 507 502
  t 503 504 509
  t 509 508 503
  t 505 506 511
  t 511 510 505
  t 506 507 512
  t 512 511 506
  t 507 508 513
  t 513 512 507
  t 508 509 514
  t 514 513 508
  t 510 511 516
  t 516 515 510
  t 511 512 517
  t 517 516 511
  t 512 513 518
  t 518 517 512
  t 513 514 519
  t 519 518 513
  t 1 59 495
  t 495 79 1
  t 65 499 55
  t 55 10 65
  t 11 70 519
  t 519 69 11
  t 75 515 74
  t 74 2 75
  t 59 58 496
  t 496 495 59
  t 66 504 499
  t 499 65 66
  t 70 71 518
  t 518 519 70
  t 76 510 515
  t 515 75 76
  t 58 57 497
  t 497 496 58
  t 67 509 504
  t 504 66 67
  t 71 72 517
  t 517 518 71
  t 77 505 510
  t 510 76 77
  t 57 56 498
  t 498 497 57
  t 68 514 509
  t 509 67 68
  t 72 73 516
  t 516 517 72
  t 78 500 505
  t 505 77 78
  t 56 55 499
  t 499 498 56
  t 69 519 514
  t 514 68 69
  t 73 74 515
  t 515 516 73
  t 79 495 500
  t 500 78 79
  t 520 521 526
  t 526 525 520
  t 521 522 527
  t 527 526 521
  t 522 523 528
  t 528 527 522
  t 523 524 529
  t 529 528 523
  t 525 526 531
  t 531 530 525
  t 526 527 532
  t 532 531 526
  t 527 528 533
  t 533 532 527
  t 528 529 534
  t 534 533 528
  t 530 531 536
  t 536 535 530
  t 531 532 537
  t 537 536 531
  t 532 533 538
  t 538 537 532
  t 533 534 539
  t 539 538 533
  t 535 536 541
  t 541 540 535
  t 536 537 542
  t 542 541 536
  t 537 538 543
  t 543 542 537
  t 538 539 544
  t 544 543 538
  t 2 74 520
  t 520 94 2
  t 80 524 70
  t 70 11 80
  t 12 85 544
  t 544 84 12
  t 90 540 89
  t 89 3 90
  t 74 73 521
  t 521 520 74
  t 81 529 524
  t 524 80 81
  t 85 86 543
  t 543 544 85
  t 91 535 540
  t 540 90 91
  t 73 72 522
  t 522 521 73
  t 82 534 529
  t 529 81 82
  t 86 87 542
  t 542 543 86
  t 92 530 535
  t 535 91 92
  t 72 71 523
  t 523 522 72
  t 83 539 534
  t 534 82 83
  t 87 88 541
  t 541 542 87
  t 93 525 530
  t 530 92 93
  t 71 70 524
  t 524 523 71
  t 84 544 539
  t 539 83 84
  t 88 89 540
  t 540 541 88
  t 94 520 525
  t 525 93 94
  t 545 546 551
  t 551 550 545
  t 546 547 552
  t 552 551 546
  t 547 548 553
  t 553 552 547
  t 548 549 554
  t 554 553 548
  t 550 551 556
  t 556 555 550
  t 551 552 557
  t 557 556 551
  t 552 553 558
  t 558 557 552
  t 553 554 559
  t 559 558 553
  t 555 556 561
  t 561 560 555
  t 556 557 562
  t 562 561 556
  t 557 558 563
  t 563 562 557
  t 558 559 564
  t 564 563 558
  t 560 561 566
  t 566 565 560
  t 561 562 567
  t 567 566 561
  t 562 563 568
  t 568 567 562
  t 563 564 569
  t 569 568 563
  t 3 89 545
  t 545 109 3
  t 95 549 85
  t 85 12 95
  t 13 100 569
  t 569 99 13
  t 105 565 104
  t 104 4 105
  t 89 88 546
  t 546 545 89
  t 96 554 549
  t 549 95 96
  t 100 101 568
  t 568 569 100
  t 106 560 565
  t 565 105 106
  t 88 87 547
  t 547 546 88
  t 97 559 554
  t 554 96 97
  t 101 102 567
  t 567 568 101
  t 107 555 560
  t 560 106 107
  t 87 86 548
  t 548 547 87
  t 98 564 559
  t 559 97 98
  t 102 103 566
  t 566 567 102
  t 108 550 555
  t 555 107 108
  t 86 85 549
  t 549 548 86
  t 99 569 564
  t 564 98 99
  t 103 104 565
  t 565 566 103
  t 109 545 550
  t 550 108 109
  t 570 571 576
  t 576 575 570
  t 571 572 577
  t 577 576 571
  t 572 573 578
  t 578 577 572
  t 573 574 579
  t 579 578 573
  t 575 576 581
  t 581 580 575
  t 576 577 582
  t 582 581 576
  t 577 578 583
  t 583 582 577
  t 578 579 584
  t 584 583 578
  t 580 581 586
  t 586 585 580
  t 581 582 587
  t 587 586 581
  t 582 583 588
  t 588 587 582
  t 583 584 589
  t 589 588 583
  t 585 586 591
  t 591 590 585
  t 586 587 592
  t 592 591 586
  t 587 588 593
  t 593 592 587
  t 588 589 594
  t 594 593 588
  t 4 104 570
  t 570 124 4
  t 110 574 100
  t 100 13 110
  t 14 115 594
  t 594 114 14
  t 120 590 119
  t 119 5 120
  t 104 103 571
  t 571 570 104
  t 111 579 574
  t 574 110 111
  t 115 116 593
  t 593 594 115
  t 121 585 590
  t 590 120 121
  t 103 102 572
  t 572 571 103
  t 112 584 579
  t 579 111 112
  t 116 117 592
  t 592 593 116
  t 122 580 585
  t 585 121 122
  t 102 101 573
  t 573 572 102
  t 113 589 584
  t 584 112 113
  t 117 118 591
  t 591 592 117
  t 123 575 580
  t 580 122 123
  t 101 100 574
  t 574 573 101
  t 114 594 589
  t 589 113 114
  t 118 119 590
  t 590 591 118
  t 124 570 575
  t 575 123 124
  t 595 596 601
  t 601 600 595
  t 596 597 602
  t 602 601 596
  t 597 598 603
  t 603 602 597
  t 598 599 604
  t 604 603 598
  t 600 601 606
  t 606 605 600
  t 601 602 607
  t 607 606 601
  t 602 603 608
  t 608 607 602
  t 603 604 609
  t 609 608 603
  t 605 606 611
  t 611 610 605
  t 606 607 612
  t 612 611 606
  t 607 608 613
  t 613 612 607
  t 608 609 614
  t 614 613 608
  t 610 611 616
  t 616 615 610
  t 611 612 617
  t 617 616 611
  t 612 613 618
  t 618 617 612
  t 613 614 619
  t 619 618 613
  t 5 119 595
  t 595 139 5
  t 125 599 115
  t 115 14 125
  t 15 130 619
  t 619 129 15
  t 135 615 134
  t 134 6 135
  t 119 118 596
  t 596 595 119
  t 126 604 599
  t 599 125 126
  t 130 131 618
  t 618 619 130
  t 136 610 615
  t 615 135 136
  t 118 117 597
  t 597 596 118
  t 127 609 604
  t 604 126 127
  t 131 132 617
  t 617 618 131
  t 137 605 610
  t 610 136 137
  t 117 116 598
  t 598 597 117
  t 128 614 609
  t 609 127 128
  t 132 133 616
  t 616 617 132
  t 138 600 605
  t 605 137 138
  t 116 115 599
  t 599 598 116
  t 129 619 614
  t 614 128 129
  t 133 134 615
  t 615 616 133
  t 139 595 600
  t 600 138 139
  t 620 621 626
  t 626 625 620
  t 621 622 627
  t 627 626 621
  t 622 623 628
  t 628 627 622
  t 623 624 629
  t 629 628 623
  t 625 626 631
  t 631 630 625
  t 626 627 632
  t 632 631 626
  t 627 628 633
  t 633 632 627
  t 628 629 634
  t 634 633 628
  t 630 631 636
  t 636 635 630
  t 631 632 637
  t 637 636 631
  t 632 633 638
  t 638 637 632
  t 633 634 639
  t 639 638 633
  t 635 636 641
  t 641 640 635
  t 636 637 642
  t 642 641 636
  t 637 638 643
  t 643 642 637
  t 638 639 644
  t 644 643 638
  t 6 134 620
  t 620 154 6
  t 140 624 130
  t 130 15 140
  t 16 145 644
  t 644 144 16
  t 150 640 149
  t 149 7 150
  t 134 133 621
  t 621 620 134
  t 141 629 624
  t 624 140 141
  t 145 146 643
  t 643 644 145
  t 151 635 640
  t 640 150 151
  t 133 132 622
  t 622 621 133
  t 142 634 629
  t 629 141 142
  t 146 147 642
  t 642 643 146
  t 152 630 635
  t 635 151 152
  t 132 131 623
  t 623 622 132
  t 143 639 634
  t 634 142 143
  t 147 148 641
  t 641 642 147
  t 153 625 630
  t 630 152 153
  t 131 130 624
  t 624 623 131
  t 144 644 639
  t 639 143 144
  t 148 149 640
  t 640 641 148
  t 154 620 625
  t 625 153 154
  t 645 646 651
  t 651 650 645
  t 646 647 652
  t 652 651 646
  t 647 648 653
  t 653 652 647
  t 648 649 654
  t 654 653 648
  t 650 651 656
  t 656 655 650
  t 651 652 657
  t 657 656 651
  t 652 653 658
  t 658 657 652
  t 653 654 659
  t 659 658 653
  t 655 656 661
  t 661 660 655
  t 656 657 662
  t 662 661 656
  t 657 658 663
  t 663 662 657
  t 658 659 664
  t 664 663 658
  t 660 661 666
  t 666 665 660
  t 661 662 667
  t 667 666 661
  t 662 663 668
  t 668 667 662
  t 663 664 669
  t 669 668 663
  t 7 149 645
  t 645 169 7
  t 155 649 145
  t 145 16 155
  t 17 160 669
  t 669 159 17
  t 165 665 164
  t 164 8 165
  t 149 148 646
  t 646 645 149
  t 156 654 649
  t 649 155 156
  t 160 161 668
  t 668 669 160
  t 166 660 665
  t 665 165 166
  t 148 147 647
  t 647 646 148
  t 157 659 654
  t 654 156 157
  t 161 162 667
  t 667 668 161
  t 167 655 660
  t 660 166 167
  t 147 146 648
  t 648 647 147
  t 158 664 659
  t 659 157 158
  t 162 163 666
  t 666 667 162
  t 168 650 655
  t 655 167 168
  t 146 145 649
  t 649 648 146
  t 159 669 664
  t 664 158 159
  t 163 164 665
  t 665 666 163
  t 169 645 650
  t 650 168 169
  t 670 671 676
  t 676 675 670
  t 671 672 677
  t 677 676 671
  t 672 673 678
  t 678 677 672
  t 673 674 679
  t 679 678 673
  t 675 676 681
  t 681 680 675
  t 676 677 682
  t 682 681 676
  t 677 678 683
  t 683 682 677
  t 678 679 684
  t 684 683 678
  t 680 681 686
  t 686 685 680
  t 681 682 687
  t 687 686 681
  t 682 683 688
  t 688 687 682
  t 683 684 689
  t 689 688 683
  t 685 686 691
  t 691 690 685
  t 686 687 692
  t 692 691 686
  t 687 688 693
  t 693 692 687
  t 688 689 694
  t 694 693 688
  t 9 170 670
  t 670 50 9
  t 175 674 174
  t 174 18 175
  t 19 180 694
  t 694 179 19
  t 54 690 184
  t 184 10 54
  t 170 171 671
  t 671 670 170
  t 176 679 674
  t 674 175 176
  t 180 181 693
  t 693 694 180
  t 53 685 690
  t 690 54 53
  t 171 172 672
  t 672 671 171
  t 177 684 679
  t 679 176 177
  t 181 182 692
  t 692 693 181
  t 52 680 685
  t 685 53 52
  t 172 173 673
  t 673 672 172
  t 178 689 684
  t 684 177 178
  t 182 183 691
  t 691 692 182
  t 51 675 680
  t 680 52 51
  t 173 174 674
  t 674 673 173
  t 179 694 689
  t 689 178 179
  t 183 184 690
  t 690 691 183
  t 50 670 675
  t 675 51 50
  t 695 696 701
  t 701 700 695
  t 696 697 702
  t 702 701 696
  t 697 698 703
  t 703 702 697
  t 698 699 704
  t 704 703 698
  t 700 701 706
  t 706 705 700
  t 701 702 707
  t 707 706 701
  t 702 703 708
  t 708 707 702
  t 703 704 709
  t 709 708 703
  t 705 706 711
  t 711 710 705
  t 706 707 712
  t 712 711 706
  t 707 708 713
  t 713 712 707
  t 708 709 714
  t 714 713 708
  t 710 711 716
  t 716 715 710
  t 711 712 717
  t 717 716 711
  t 712 713 718
  t 718 717 712
  t 713 714 719
  t 719 718 713
  t 10 184 695
  t 695 65 10
  t 185 699 180
  t 180 19 185
  t 20 190 719
  t 719 189 20
  t 69 715 194
  t 194 11 69
  t 184 183 696
  t 696 695 184
  t 186 704 699
  t 699 185 186
  t 190 191 718
  t 718 719 190
  t 68 710 715
  t 715 69 68
  t 183 182 697
  t 697 696 183
  t 187 709 704
  t 704 186 187
  t 191 192 717
  t 717 718 191
  t 67 705 710
  t 710 68 67
  t 182 181 698
  t 698 697 182
  t 188 714 709
  t 709 187 188
  t 192 193 716
  t 716 717 192
  t 66 700 705
  t 705 67 66
  t 181 180 699
  t 699 698 181
  t 189 719 714
  t 714 188 189
  t 193 194 715
  t 715 716 193
  t 65 695 700
  t 700 66 65
  t 720 721 726
  t 726 725 720
  t 721 722 727
  t 727 726 721
  t 722 723 728
  t 728 727 722
  t 723 724 729
  t 729 728 723
  t 725 726 731
  t 731 730 725
  t 726 727 732
  t 732 731 726
  t 727 728 733
  t 733 732 727
  t 728 729 734
  t 734 733 728
  t 730 731 736
  t 736 735 730
  t 731 732 737
  t 737 736 731
  t 732 733 738
  t 738 737 732
  t 733 734 739
  t 739 738 733
  t 735 736 741
  t 741 740 735
  t 736 737 742
  t 742 741 736
  t 737 738 743
  t 743 742 737
  t 738 739 744
  t 744 743 738
  t 11 194 720
  t 720 80 11
  t 195 724 190
  t 190 20 195
  t 21 200 744
  t 744 199 21
  t 84 740 204
  t 204 12 84
  t 194 193 721
  t 721 720 194
  t 196 729 724
  t 724 195 196
  t 200 201 743
  t 743 744 200
  t 83 735 740
  t 740 84 83
  t 193 192 722
  t 722 721 193
  t 197 734 729
  t 729 196 197
  t 201 202 742
  t 742 743 201
  t 82 730 735
  t 735 83 82
  t 192 191 723
  t 723 722 192
  t 198 739 734
  t 734 197 198
  t 202 203 741
  t 741 742 202
  t 81 725 730
  t 730 82 81
  t 191 190 724
  t 724 723 191
  t 199 744 739
  t 739 198 199
  t 203 204 740
  t 740 741 203
  t 80 720 725
  t 725 81 80
  t 745 746 751
  t 751 750 745
  t 746 747 752
  t 752 751 746
  t 747 748 753
  t 753 752 747
  t 748 749 754
  t 754 753 748
  t 750 751 756
  t 756 755 750
  t 751 752 757
  t 757 756 751
  t 752 753 758
  t 758 757 752
  t 753 754 759
  t 759 758 753
  t 755 756 761
  t 761 760 755
  t 756 757 762
  t 762 761 756
  t 757 758 763
  t 763 762 757
  t 758 759 764
  t 764 763 758
  t 760 761 766
  t 766 765 760
  t 761 762 767
  t 767 766 761
  t 762 763 768
  t 768 767 762
  t 763 764 769
  t 769 768 763
  t 12 204 745
  t 745 95 12
  t 205 749 200
  t 200 21 205
  t 22 210 769
  t 769 209 22
  t 99 765 214
  t 214 13 99
  t 204 203 746
  t 746 745 204
  t 206 754 749
  t 749 205 206
  t 210 211 768
  t 768 769 210
  t 98 760 765
  t 765 99 98
  t 203 202 747
  t 747 746 203
  t 207 759 754
  t 754 206 207
  t 211 212 767
  t 767 768 211
  t 97 755 760
  t 760 98 97
  t 202 201 748
  t 748 747 202
  t 208 764 759
  t 759 207 208
  t 212 213 766
  t 766 767 212
  t 96 750 755
  t 755 97 96
  t 201 200 749
  t 749 748 201
  t 209 769 764
  t 764 208 209
  t 213 214 765
  t 765 766 213
  t 95 745 750
  t 750 96 95
  t 770 771 776
  t 776 775 770
  t 771 772 777
  t 777 776 771
  t 772 773 778
  t 778 777 772
  t 773 774 779
  t 779 778 773
  t 775 776 781
  t 781 780 775
  t 776 777 782
  t 782 781 776
  t 777 778 783
  t 783 782 777
  t 778 779 784
  t 784 783 778
  t 780 781 786
  t 786 785 780
  t 781 782 787
  t 787 786 781
  t 782 783 788
  t 788 787 782
  t 783 784 789
  t 789 788 783
  t 785 786 791
  t 791 790 785
  t 786 787 792
  t 792 791 786
  t 787 788 793
  t 793 792 787
  t 788 789 794
  t 794 793 788
  t 13 214 770
  t 770 110 13
  t 215 774 210
  t 210 22 215
  t 23 220 794
  t 794 219 23
  t 114 790 224
  t 224 14 114
  t 214 213 771
  t 771 770 214
  t 216 779 774
  t 774 215 216
  t 220 221 793
  t 793 794 220
  t 113 785 790
  t 790 114 113
  t 213 212 772
  t 772 771 213
  t 217 784 779
  t 779 216 217
  t 221 222 792
  t 792 793 221
  t 112 780 785
  t 785 113 112
  t 212 211 773
  t 773 772 212
  t 218 789 784
  t 784 217 218
  t 222 223 791
  t 791 792 222
  t 111 775 780
  t 780 112 111
  t 211 210 774
  t 774 773 211
  t 219 794 789
  t 789 218 219
  t 223 224 790
  t 790 791 223
  t 110 770 775
  t 775 111 110
  t 795 796 801
  t 801 800 795
  t 796 797 802
  t 802 801 796
  t 797 798 803
  t 803 802 797
  t 798 799 804
  t 804 803 798
  t 800 801 806
  t 806 805 800
  t 801 802 807
  t 807 806 801
  t 802 803 808
  t 808 807 802
  t 803 804 809
  t 809 808 803
  t 805 806 811
  t 811 810 805
  t 806 807 812
  t 812 811 806
  t 807 808 813
  t 813 812 807
  t 808 809 814
  t 814 813 808
  t 810 811 816
  t 816 815 810
  t 811 812 817
  t 817 816 811
  t 812 813 818
  t 818 817 812
  t 813 814 819
  t 819 818 813
  t 14 224 795
  t 795 125 14
  t 225 799 220
  t 220 23 225
  t 24 230 819
  t 819 229 24
  t 129 815 234
  t 234 15 129
  t 224 223 796
  t 796 795 224
  t 226 804 799
  t 799 225 226
  t 230 231 818
  t 818 819 230
  t 128 810 815
  t 815 129 128
  t 223 222 797
  t 797 796 223
  t 227 809 804
  t 804 226 227
  t 231 232 817
  t 817 818 231
  t 127 805 810
  t 810 128 127
  t 222 221 798
  t 798 797 222
  t 228 814 809
  t 809 227 228
  t 232 233 816
  t 816 817 232
  t 126 800 805
  t 805 127 126
  t 221 220 799
  t 799 798 221
  t 229 819 814
  t 814 228 229
  t 233 234 815
  t 815 816 233
  t 125 795 800
  t 800 126 125
  t 820 821 826
  t 826 825 820
  t 821 822 827
  t 827 826 821
  t 822 823 828
  t 828 827 822
  t 823 824 829
  t 829 828 823
  t 825 826 831
  t 831 830 825
  t 826 827 832
  t 832 831 826
  t 827 828 833
  t 833 832 827
  t 828 829 834
  t 834 833 828
  t 830 831 836
  t 836 835 830
  t 831 832 837
  t 837 836 831
  t 832 833 838
  t 838 837 832
  t 833 834 839
  t 839 838 833
  t 835 836 841
  t 841 840 835
  t 836 837 842
  t 842 841 836
  t 837 838 843
  t 843 842 837
  t 838 839 844
  t 844 843 838
  t 15 234 820
  t 820 140 15
  t 235 824 230
  t 230 24 235
  t 25 240 844
  t 844 239 25
  t 144 840 244
  t 244 16 144
  t 234 233 821
  t 821 820 234
  t 236 829 824
  t 824 235 236
  t 240 241 843
  t 843 844 240
  t 143 835 840
  t 840 144 143
  t 233 232 822
  t 822 821 233
  t 237 834 829
  t 829 236 237
  t 241 242 842
  t 842 843 241
  t 142 830 835
  t 835 143 142
  t 232 231 823
  t 823 822 232
  t 238 839 834
  t 834 237 238
  t 242 243 841
  t 841 842 242
  t 141 825 830
  t 830 142 141
  t 231 230 824
  t 824 823 231
  t 239 844 839
  t 839 238 239
  t 243 244 840
  t 840 841 243
  t 140 820 825
  t 825 141 140
  t 845 846 851
  t 851 850 845
  t 846 847 852
  t 852 851 846
  t 847 848 853
  t 853 852 847
  t 848 849 854
  t 854 853 848
  t 850 851 856
  t 856 855 850
  t 851 852 857
  t 857 856 851
  t 852 853 858
  t 858 857 852
  t 853 854 859
  t 859 858 853
  t 855 856 861
  t 861 860 855
  t 856 857 862
  t 862 861 856
  t 857 858 863
  t 863 862 857
  t 858 859 864
  t 864 863 858
  t 860 861 866
  t 866 865 860
  t 861 862 867
  t 867 866 861
  t 862 863 868
  t 868 867 862
  t 863 864 869
  t 869 868 863
  t 16 244 845
  t 845 155 16
  t 245 849 240
  t 240 25 245
  t 26 250 869
  t 869 249 26
  t 159 865 254
  t 254 17 159
  t 244 243 846
  t 846 845 244
  t 246 854 849
  t 849 245 246
  t 250 251 868
  t 868 869 250
  t 158 860 865
  t 865 159 158
  t 243 242 847
  t 847 846 243
  t 247 859 854
  t 854 246 247
  t 251 252 867
  t 867 868 251
  t 157 855 860
  t 860 158 157
  t 242 241 848
  t 848 847 242
  t 248 864 859
  t 859 247 248
  t 252 253 866
  t 866 867 252
  t 156 850 855
  t 855 157 156
  t 241 240 849
  t 849 848 241
  t 249 869 864
  t 864 248 249
  t 253 254 865
  t 865 866 253
  t 155 845 850
  t 850 156 155
  t 870 871 876
  t 876 875 870
  t 871 872 877
  t 877 876 871
  t 872 873 878
  t 878 877 872
  t 873 874 879
  t 879 878 873
  t 875 876 881
  t 881 880 875
  t 876 877 882
  t 882 881 876
  t 877 878 883
  t 883 882 877
  t 878 879 884
  t 884 883 878
  t 880 881 886
  t 886 885 880
  t 881 882 887
  t 887 886 881
  t 882 883 888
  t 888 887 882
  t 883 884 889
  t 889 888 883
  t 885 886 891
  t 891 890 885
  t 886 887 892
  t 892 891 886
  t 887 888 893
  t 893 892 887
  t 888 889 894
  t 894 893 888
  t 18 255 870
  t 870 175 18
  t 260 874 259
  t 259 27 260
  t 28 265 894
  t 894 264 28
  t 179 890 269
  t 269 19 179
  t 255 256 871
  t 871 870 255
  t 261 879 874
  t 874 260 261
  t 265 266 893
  t 893 894 265
  t 178 885 890
  t 890 179 178
  t 256 257 872
  t 872 871 256
  t 262 884 879
  t 879 261 262
  t 266 267 892
  t 892 893 266
  t 177 880 885
  t 885 178 177
  t 257 258 873
  t 873 872 257
  t 263 889 884
  t 884 262 263
  t 267 268 891
  t 891 892 267
  t 176 875 880
  t 880 177 176
  t 258 259 874
  t 874 873 258
  t 264 894 889
  t 889 263 264
  t 268 269 890
  t 890 891 268
  t 175 870 875
  t 875 176 175
  t 895 896 901
  t 901 900 895
  t 896 897 902
  t 902 901 896
  t 897 898 903
  t 903 902 897
  t 898 899 904
  t 904 903 898
  t 900 901 906
  t 906 905 900
  t 901 902 907
  t 907 906 901
  t 902 903 908
  t 908 907 902
  t 903 904 909
  t 909 908 903
  t 905 906 911
  t 911 910 905
  t 906 907 912
  t 912 911 906
  t 907 908 913
  t 913 912 907
  t 908 909 914
  t 914 913 908
  t 910 911 916
  t 916 915 910
  t 911 912 917
  t 917 916 911
  t 912 913 918
  t 918 917 912
  t 913 914 919
  t 919 918 913
  t 19 269 895
  t 895 185 19
  t 270 899 265
  t 265 28 270
  t 29 275 919
  t 919 274 29
  t 189 915 279
  t 279 20 189
  t 269 268 896
  t 896 895 269
  t 271 904 899
  t 899 270 271
  t 275 276 918
  t 918 919 275
  t 188 910 915
  t 915 189 188
  t 268 267 897
  t 897 896 268
  t 272 909 904
  t 904 271 272
  t 276 277 917
  t 917 918 276
  t 187 905 910
  t 910 188 187
  t 267 266 898
  t 898 897 267
  t 273 914 909
  t 909 272 273
  t 277 278 916
  t 916 917 277
  t 186 900 905
  t 905 187 186
  t 266 265 899
  t 899 898 266
  t 274 919 914
  t 914 273 274
  t 278 279 915
  t 915 916 278
  t 185 895 900
  t 900 186 185
  t 920 921 926
  t 926 925 920
  t 921 922 927
  t 927 926 921
  t 922 923 928
  t 928 927 922
  t 923 924 929
  t 929 928 923
  t 925 926 931
  t 931 930 925
  t 926 927 932
  t 932 931 926
  t 927 928 933
  t 933 932 927
  t 928 929 934
  t 934 933 928
  t 930 931 936
  t 936 935 930
  t 931 932 937
  t 937 936 931
  t 932 933 938
  t 938 937 932
  t 933 934 939
  t 939 938 933
  t 935 936 941
  t 941 940 935
  t 936 937 942
  t 942 941 936
  t 937 938 943
  t 943 942 937
  t 938 939 944
  t 944 943 938
  t 20 279 920
  t 920 195 20
  t 280 924 275
  t 275 29 280
  t 30 285 944
  t 944 284 30
  t 199 940 289
  t 289 21 199
  t 279 278 921
  t 921 920 279
  t 281 929 924
  t 924 280 281
  t 285 286 943
  t 943 944 285
  t 198 935 940
  t 940 199 198
  t 278 277 922
  t 922 921 278
  t 282 934 929
  t 929 281 282
  t 286 287 942
  t 942 943 286
  t 197 930 935
  t 935 198 197
  t 277 276 923
  t 923 922 277
  t 283 939 934
  t 934 282 283
  t 287 288 941
  t 941 942 287
  t 196 925 930
  t 930 197 196
  t 276 275 924
  t 924 923 276
  t 284 944 939
  t 939 283 284
  t 288 289 940
  t 940 941 288
  t 195 920 925
  t 925 196 195
  t 945 946 951
  t 951 950 945
  t 946 947 952
  t 952 951 946
  t 947 948 953
  t 953 952 947
  t 948 949 954
  t 954 953 948
  t 950 951 956
  t 956 955 950
  t 951 952 957
  t 957 956 951
  t 952 953 958
  t 958 957 952
  t 953 954 959
  t 959 958 953
  t 955 956 961
  t 961 960 955
  t 956 957 962
  t 962 961 956
  t 957 958 963
  t 963 962 957
  t 958 959 964
  t 964 963 958
  t 960 961 966
  t 966 965 960
  t 961 962 967
  t 967 966 961
  t 962 963 968
  t 968 967 962
  t 963 964 969
  t 969 968 963
  t 21 289 945
  t 945 205 21
  t 290 949 285
  t 285 30 290
  t 31 295 969
  t 969 294 31
  t 209 965 299
  t 299 22 209
  t 289 288 946
  t 946 945 289
  t 291 954 949
  t 949 290 291
  t 295 296 968
  t 968 969 295
  t 208 960 965
  t 965 209 208
  t 288 287 947
  t 947 946 288
  t 292 959 954
  t 954 291 292
  t 296 297 967
  t 967 968 296
  t 207 955 960
  t 960 208 207
  t 287 286 948
  t 948 947 287
  t 293 964 959
  t 959 292 293
  t 297 298 966
  t 966 967 297
  t 206 950 955
  t 955 207 206
  t 286 285 949
  t 949 948 286
  t 294 969 964
  t 964 293 294
  t 298 299 965
  t 965 966 298
  t 205 945 950
  t 950 206 205
  t 970 971 976
  t 976 975 970
  t 971 972 977
  t 977 976 971
  t 972 973 978
  t 978 977 972
  t 973 974 979
  t 979 978 973
  t 975 976 981
  t 981 980 975
  t 976 977 982
  t 982 981 976
  t 977 978 983
  t 983 982 977
  t 978 979 984
  t 984 983 978
  t 980 981 986
  t 986 985 980
  t 981 982 987
  t 987 986 981
  t 982 983 988
  t 988 987 982
  t 983 984 989
  t 989 988 983
  t 985 986 991
  t 991 990 985
  t 986 987 992
  t 992 991 986
  t 987 988 993
  t 993 992 987
  t 988 989 994
  t 994 993 988
  t 22 299 970
  t 970 215 22
  t 300 974 295
  t 295 31 300
  t 32 305 994
  t 994 304 32
  t 219 990 309
  t 309 23 219
  t 299 298 971
  t 971 970 299
  t 301 979 974
  t 974 300 301
  t 305 306 993
  t 993 994 305
  t 218 985 990
  t 990 219 218
  t 298 297 972
  t 972 971 298
  t 302 984 979
  t 979 301 302
  t 306 307 992
  t 992 993 306
  t 217 980 985
  t 985 218 217
  t 297 296 973
  t 973 972 297
  t 303 989 984
  t 984 302 303
  t 307 308 991
  t 991 992 307
  t 216 975 980
  t 980 217 216
  t 296 295 974
  t 974 973 296
  t 304 994 989
  t 989 303 304
  t 308 309 990
  t 990 991 308
  t 215 970 975
  t 975 216 215
  t 995 996 1001
  t 1001 1000 995
  t 996 997 1002
  t 1002 1001 996
  t 997 998 1003
  t 1003 1002 997
  t 998 999 1004
  t 1004 1003 998
  t 1000 1001 1006
  t 1006 1005 1000
  t 1001 1002 1007
  t 1007 1006 1001
  t 1002 1003 1008
  t 1008 1007 1002
  t 1003 1004 1009
  t 1009 1008 1003
  t 1005 1006 1011
  t 1011 1010 1005
  t 1006 1007 1012
  t 1012 1011 1006
  t 1007 1008 1013
  t 1013 1012 1007
  t 1008 1009 1014
  t 1014 1013 1008
  t 1010 1011 1016
  t 1016 1015 1010
  t 1011 1012 1017
  t 1017 1016 1011
  t 1012 1013 1018
  t 1018 1017 1012
  t 1013 1014 1019
  t 1019 1018 1013
  t 23 309 995
  t 995 225 23
  t 310 999 305
  t 305 32 310
  t 33 315 1019
  t 1019 314 33
  t 229 1015 319
  t 319 24 229
  t 309 308 996
  t 996 995 309
  t 311 1004 999
  t 999 310 311
  t 315 316 1018
  t 1018 1019 315
  t 228 1010 1015
  t 1015 229 228
  t 308 307 997
  t 997 996 308
  t 312 1009 1004
  t 1004 311 312
  t 316 317 1017
  t 1017 1018 316
  t 227 1005 1010
  t 1010 228 227
  t 307 306 998
  t 998 997 307
  t 313 1014 1009
  t 1009 312 313
  t 317 318 1016
  t 1016 1017 317
  t 226 1000 1005
  t 1005 227 226
  t 306 305 999
  t 999 998 306
  t 314 1019 1014
  t 1014 313 314
  t 318 319 1015
  t 1015 1016 318
  t 225 995 1000
  t 1000 226 225
  t 1020 1021 1026
  t 1026 1025 1020
  t 1021 1022 1027
  t 1027 1026 1021
  t 1022 1023 1028
  t 1028 1027 1022
  t 1023 1024 1029
  t 1029 1028 1023
  t 1025 1026 1031
  t 1031 1030 1025
  t 1026 1027 1032
  t 1032 1031 1026
  t 1027 1028 1033
  t 1033 1032 1027
  t 1028 1029 1034
  t 1034 1033 1028
  t 1030 1031 1036
  t 1036 1035 1030
  t 1031 1032 1037
  t 1037 1036 1031
  t 1032 1033 1038
  t 1038 1037 1032
  t 1033 1034 1039
  t 1039 1038 1033
  t 1035 1036 1041
  t 1041 1040 1035
  t 1036 1037 1042
  t 1042 1041 1036
  t 1037 1038 1043
  t 1043 1042 1037
  t 1038 1039 1044
  t 1044 1043 1038
  t 24 319 1020
  t 1020 235 24
  t 320 1024 315
  t 315 33 320
  t 34 325 1044
  t 1044 324 34
  t 239 1040 329
  t 329 25 239
  t 319 318 1021
  t 1021 1020 319
  t 321 1029 1024
  t 1024 320 321
  t 325 326 1043
  t 1043 1044 325
  t 238 1035 1040
  t 1040 239 238
  t 318 317 1022
  t 1022 1021 318
  t 322 1034 1029
  t 1029 321 322
  t 326 327 1042
  t 1042 1043 326
  t 237 1030 1035
  t 1035 238 237
  t 317 316 1023
  t 1023 1022 317
  t 323 1039 1034
  t 1034 322 323
  t 327 328 1041
  t 1041 1042 327
  t 236 1025 1030
  t 1030 237 236
  t 316 315 1024
  t 1024 1023 316
  t 324 1044 1039
  t 1039 323 324
  t 328 329 1040
  t 1040 1041 328
  t 235 1020 1025
  t 1025 236 235
  t 1045 1046 1051
  t 1051 1050 1045
  t 1046 1047 1052
  t 1052 1051 1046
  t 1047 1048 1053
  t 1053 1052 1047
  t 1048 1049 1054
  t 1054 1053 1048
  t 1050 1051 1056
  t 1056 1055 1050
  t 1051 1052 1057
  t 1057 1056 1051
  t 1052 1053 1058
  t 1058 1057 1052
  t 1053 1054 1059
  t 1059 1058 1053
  t 1055 1056 1061
  t 1061 1060 1055
  t 1056 1057 1062
  t 1062 1061 1056
  t 1057 1058 1063
  t 1063 1062 1057
  t 1058 1059 1064
  t 1064 1063 1058
  t 1060 1061 1066
  t 1066 1065 1060
  t 1061 1062 1067
  t 1067 1066 1061
  t 1062 1063 1068
  t 1068 1067 1062
  t 1063 1064 1069
  t 1069 1068 1063
  t 25 329 1045
  t 1045 245 25
  t 330 1049 325
  t 325 34 330
  t 35 335 1069
  t 1069 334 35
  t 249 1065 339
  t 339 26 249
  t 329 328 1046
  t 1046 1045 329
  t 331 1054 1049
  t 1049 330 331
  t 335 336 1068
  t 1068 1069 335
  t 248 1060 1065
  t 1065 249 248
  t 328 327 1047
  t 1047 1046 328
  t 332 1059 1054
  t 1054 331 332
  t 336 337 1067
  t 1067 1068 336
  t 247 1055 1060
  t 1060 248 247
  t 327 326 1048
  t 1048 1047 327
  t 333 1064 1059
  t 1059 332 333
  t 337 338 1066
  t 1066 1067 337
  t 246 1050 1055
  t 1055 247 246
  t 326 325 1049
  t 1049 1048 326
  t 334 1069 1064
  t 1064 333 334
  t 338 339 1065
  t 1065 1066 338
  t 245 1045 1050
  t 1050 246 245
  t 1070 1071 1076
  t 1076 1075 1070
  t 1071 1072 1077
  t 1077 1076 1071
  t 1072 1073 1078
  t 1078 1077 1072
  t 1073 1074 1079
  t 1079 1078 1073
  t 1075 1076 1081
  t 1081 1080 1075
  t 1076 1077 1082
  t 1082 1081 1076
  t 1077 1078 1083
  t 1083 1082 1077
  t 1078 1079 1084
  t 1084 1083 1078
  t 1080 1081 1086
  t 1086 1085 1080
  t 1081 1082 1087
  t 1087 1086 1081
  t 1082 1083 1088
  t 1088 1087 1082
  t 1083 1084 1089
  t 1089 1088 1083
  t 1085 1086 1091
  t 1091 1090 1085
  t 1086 1087 1092
  t 1092 1091 1086
  t 1087 1088 1093
  t 1093 1092 1087
  t 1088 1089 1094
  t 1094 1093 1088
  t 27 340 1070
  t 1070 260 27
  t 345 1074 344
  t 344 36 345
  t 37 350 1094
  t 1094 349 37
  t 264 1090 354
  t 354 28 264
  t 340 341 1071
  t 1071 1070 340
  t 346 1079 1074
  t 1074 345 346
  t 350 351 1093
  t 1093 1094 350
  t 263 1085 1090
  t 1090 264 263
  t 341 342 1072
  t 1072 1071 341
  t 347 1084 1079
  t 1079 346 347
  t 351 352 1092
  t 1092 1093 351
  t 262 1080 1085
  t 1085 263 262
  t 342 343 1073
  t 1073 1072 342
  t 348 1089 1084
  t 1084 347 348
  t 352 353 1091
  t 1091 1092 352
  t 261 1075 1080
  t 1080 262 261
  t 343 344 1074
  t 1074 1073 343
  t 349 1094 1089
  t 1089 348 349
  t 353 354 1090
  t 1090 1091 353
  t 260 1070 1075
  t 1075 261 260
  t 1095 1096 1101
  t 1101 1100 1095
  t 1096 1097 1102
  t 1102 1101 1096
  t 1097 1098 1103
  t 1103 1102 1097
  t 1098 1099 1104
  t 1104 1103 1098
  t 1100 1101 1106
  t 1106 1105 1100
  t 1101 1102 1107
  t 1107 1106 1101
  t 1102 1103 1108
  t 1108 1107 1102
  t 1103 1104 1109
  t 1109 1108 1103
  t 1105 1106 1111
  t 1111 1110 1105
  t 1106 1107 1112
  t 1112 1111 1106
  t 1107 1108 1113
  t 1113 1112 1107
  t 1108 1109 1114
  t 1114 1113 1108
  t 1110 1111 1116
  t 1116 1115 1110
  t 1111 1112 1117
  t 1117 1116 1111
  t 1112 1113 1118
  t 1118 1117 1112
  t 1113 1114 1119
  t 1119 1118 1113
  t 28 354 1095
  t 1095 270 28
  t 355 1099 350
  t 350 37 355
  t 38 360 1119
  t 1119 359 38
  t 274 1115 364
  t 364 29 274
  t 354 353 1096
  t 1096 1095 354
  t 356 1104 1099
  t 1099 355 356
  t 360 361 1118
  t 1118 1119 360
  t 273 1110 1115
  t 1115 274 273
  t 353 352 1097
  t 1097 1096 353
  t 357 1109 1104
  t 1104 356 357
  t 361 362 1117
  t 1117 1118 361
  t 272 1105 1110
  t 1110 273 272
  t 352 351 1098
  t 1098 1097 352
  t 358 1114 1109
  t 1109 357 358
  t 362 363 1116
  t 1116 1117 362
  t 271 1100 1105
  t 1105 272 271
  t 351 350 1099
  t 1099 1098 351
  t 359 1119 1114
  t 1114 358 359
  t 363 364 1115
  t 1115 1116 363
  t 270 1095 1100
  t 1100 271 270
  t 1120 1121 1126
  t 1126 1125 1120
  t 1121 1122 1127
  t 1127 1126 1121
  t 1122 1123 1128
  t 1128 1127 1122
  t 1123 1124 1129
  t 1129 1128 1123
  t 1125 1126 1131
  t 1131 1130 1125
  t 1126 1127 1132
  t 1132 1131 1126
  t 1127 1128 1133
  t 1133 1132 1127
  t 1128 1129 1134
  t 1134 1133 1128
  t 1130 1131 1136
  t 1136 1135 1130
  t 1131 1132 1137
  t 1137 1136 1131
  t 1132 1133 1138
  t 1138 1137 1132
  t 1133 1134 1139
  t 1139 1138 1133
  t 1135 1136 1141
  t 1141 1140 1135
  t 1136 1137 1142
  t 1142 1141 1136
  t 1137 1138 1143
  t 1143 1142 1137
  t 1138 1139 1144
  t 1144 1143 1138
  t 29 364 1120
  t 1120 280 29
  t 365 1124 360
  t 360 38 365
  t 39 370 1144
  t 1144 369 39
  t 284 1140 374
  t 374 30 284
  t 364 363 1121
  t 1121 1120 364
  t 366 1129 1124
  t 1124 365 366
  t 370 371 1143
  t 1143 1144 370
  t 283 1135 1140
  t 1140 284 283
  t 363 362 1122
  t 1122 1121 363
  t 367 1134 1129
  t 1129 366 367
  t 371 372 1142
  t 1142 1143 371
  t 282 1130 1135
  t 1135 283 282
  t 362 361 1123
  t 1123 1122 362
  t 368 1139 1134
  t 1134 367 368
  t 372 373 1141
  t 1141 1142 372
  t 281 1125 1130
  t 1130 282 281
  t 361 360 1124
  t 1124 1123 361
  t 369 1144 1139
  t 1139 368 369
  t 373 374 1140
  t 1140 1141 373
  t 280 1120 1125
  t 1125 281 280
  t 1145 1146 1151
  t 1151 1150 1145
  t 1146 1147 1152
  t 1152 1151 1146
  t 1147 1148 1153
  t 1153 1152 1147
  t 1148 1149 1154
  t 1154 1153 1148
  t 1150 1151 1156
  t 1156 1155 1150
  t 1151 1152 1157
  t 1157 1156 1151
  t 1152 1153 1158
  t 1158 1157 1152
  t 1153 1154 1159
  t 1159 1158 1153
  t 1155 1156 1161
  t 1161 1160 1155
  t 1156 1157 1162
  t 1162 1161 1156
  t 1157 1158 1163
  t 1163 1162 1157
  t 1158 1159 1164
  t 1164 1163 1158
  t 1160 1161 1166
  t 1166 1165 1160
  t 1161 1162 1167
  t 1167 1166 1161
  t 1162 1163 1168
  t 1168 1167 1162
  t 1163 1164 1169
  t 1169 1168 1163
  t 30 374 1145
  t 1145 290 30
  t 375 1149 370
  t 370 39 375
  t 40 380 1169
  t 1169 379 40
  t 294 1165 384
  t 384 31 294
  t 374 373 1146
  t 1146 1145 374
  t 376 1154 1149
  t 1149 375 376
  t 380 381 1168
  t 1168 1169 380
  t 293 1160 1165
  t 1165 294 293
  t 373 372 1147
  t 1147 1146 373
  t 377 1159 1154
  t 1154 376 377
  t 381 382 1167
  t 1167 1168 381
  t 292 1155 1160
  t 1160 293 292
  t 372 371 1148
  t 1148 1147 372
  t 378 1164 1159
  t 1159 377 378
  t 382 383 1166
  t 1166 1167 382
  t 291 1150 1155
  t 1155 292 291
  t 371 370 1149
  t 1149 1148 371
  t 379 1169 1164
  t 1164 378 379
  t 383 384 1165
  t 1165 1166 383
  t 290 1145 1150
  t 1150 291 290
  t 1170 1171 1176
  t 1176 1175 1170
  t 1171 1172 1177
  t 1177 1176 1171
  t 1172 1173 1178
  t 1178 1177 1172
  t 1173 1174 1179
  t 1179 1178 1173
  t 1175 1176 1181
  t 1181 1180 1175
  t 1176 1177 1182
  t 1182 1181 1176
  t 1177 1178 1183
  t 1183 1182 1177
  t 1178 1179 1184
  t 1184 1183 1178
  t 1180 1181 1186
  t 1186 1185 1180
  t 1181 1182 1187
  t 1187 1186 1181
  t 1182 1183 1188
  t 1188 1187 1182
  t 1183 1184 1189
  t 1189 1188 1183
  t 1185 1186 1191
  t 1191 1190 1185
  t 1186 1187 1192
  t 1192 1191 1186
  t 1187 1188 1193
  t 1193 1192 1187
  t 1188 1189 1194
  t 1194 1193 1188
  t 31 384 1170
  t 1170 300 31
  t 385 1174 380
  t 380 40 385
  t 41 390 1194
  t 1194 389 41
  t 304 1190 394
  t 394 32 304
  t 384 383 1171
  t 1171 1170 384
  t 386 1179 1174
  t 1174 385 386
  t 390 391 1193
  t 1193 1194 390
  t 303 1185 1190
  t 1190 304 303
  t 383 382 1172
  t 1172 1171 383
  t 387 1184 1179
  t 1179 386 387
  t 391 392 1192
  t 1192 1193 391
  t 302 1180 1185
  t 1185 303 302
  t 382 381 1173
  t 1173 1172 382
  t 388 1189 1184
  t 1184 387 388
  t 392 393 1191
  t 1191 1192 392
  t 301 1175 1180
  t 1180 302 301
  t 381 380 1174
  t 1174 1173 381
  t 389 1194 1189
  t 1189 388 389
  t 393 394 1190
  t 1190 1191 393
  t 300 1170 1175
  t 1175 301 300
  t 1195 1196 1201
  t 1201 1200 1195
  t 1196 1197 1202
  t 1202 1201 1196
  t 1197 1198 1203
  t 1203 1202 1197
  t 1198 1199 1204
  t 1204 1203 1198
  t 1200 1201 1206
  t 1206 1205 1200
  t 1201 1202 1207
  t 1207 1206 1201
  t 1202 1203 1208
  t 1208 1207 1202
  t 1203 1204 1209
  t 1209 1208 1203
  t 1205 1206 1211
  t 1211 1210 1205
  t 1206 1207 1212
  t 1212 1211 1206
  t 1207 1208 1213
  t 1213 1212 1207
  t 1208 1209 1214
  t 1214 1213 1208
  t 1210 1211 1216
  t 1216 1215 1210
  t 1211 1212 1217
  t 1217 1216 1211
  t 1212 1213 1218
  t 1218 1217 1212
  t 1213 1214 1219
  t 1219 1218 1213
  t 32 394 1195
  t 1195 310 32
  t 395 1199 390
  t 390 41 395
  t 42 400 1219
  t 1219 399 42
  t 314 1215 404
  t 404 33 314
  t 394 393 1196
  t 1196 1195 394
  t 396 1204 1199
  t 1199 395 396
  t 400 401 1218
  t 1218 1219 400
  t 313 1210 1215
  t 1215 314 313
  t 393 392 1197
  t 1197 1196 393
  t 397 1209 1204
  t 1204 396 397
  t 401 402 1217
  t 1217 1218 401
  t 312 1205 1210
  t 1210 313 312
  t 392 391 1198
  t 1198 1197 392
  t 398 1214 1209
  t 1209 397 398
  t 402 403 1216
  t 1216 1217 402
  t 311 1200 1205
  t 1205 312 311
  t 391 390 1199
  t 1199 1198 391
  t 399 1219 1214
  t 1214 398 399
  t 403 404 1215
  t 1215 1216 403
  t 310 1195 1200
  t 1200 311 310
  t 1220 1221 1226
  t 1226 1225 1220
  t 1221 1222 1227
  t 1227 1226 1221
  t 1222 1223 1228
  t 1228 1227 1222
  t 1223 1224 1229
  t 1229 1228 1223
  t 1225 1226 1231
  t 1231 1230 1225
  t 1226 1227 1232
  t 1232 1231 1226
  t 1227 1228 1233
  t 1233 1232 1227
  t 1228 1229 1234
  t 1234 1233 1228
  t 1230 1231 1236
  t 1236 1235 1230
  t 1231 1232 1237
  t 1237 1236 1231
  t 1232 1233 1238
  t 1238 1237 1232
  t 1233 1234 1239
  t 1239 1238 1233
  t 1235 1236 1241
  t 1241 1240 1235
  t 1236 1237 1242
  t 1242 1241 1236
  t 1237 1238 1243
  t 1243 1242 1237
  t 1238 1239 1244
  t 1244 1243 1238
  t 33 404 1220
  t 1220 320 33
  t 405 1224 400
  t 400 42 405
  t 43 410 1244
  t 1244 409 43
  t 324 1240 414
  t 414 34 324
  t 404 403 1221
  t 1221 1220 404
  t 406 1229 1224
  t 1224 405 406
  t 410 411 1243
  t 1243 1244 410
  t 323 1235 1240
  t 1240 324 323
  t 403 402 1222
  t 1222 1221 403
  t 407 1234 1229
  t 1229 406 407
  t 411 412 1242
  t 1242 1243 411
  t 322 1230 1235
  t 1235 323 322
  t 402 401 1223
  t 1223 1222 402
  t 408 1239 1234
  t 1234 407 408
  t 412 413 1241
  t 1241 1242 412
  t 321 1225 1230
  t 1230 322 321
  t 401 400 1224
  t 1224 1223 401
  t 409 1244 1239
  t 1239 408 409
  t 413 414 1240
  t 1240 1241 413
  t 320 1220 1225
  t 1225 321 320
  t 1245 1246 1251
  t 1251 1250 1245
  t 1246 1247 1252
  t 1252 1251 1246
  t 1247 1248 1253
  t 1253 1252 1247
  t 1248 1249 1254
  t 1254 1253 1248
  t 1250 1251 1256
  t 1256 1255 1250
  t 1251 1252 1257
  t 1257 1256 1251
  t 1252 1253 1258
  t 1258 1257 1252
  t 1253 1254 1259
  t 1259 1258 1253
  t 1255 1256 1261
  t 1261 1260 1255
  t 1256 1257 1262
  t 1262 1261 1256
  t 1257 1258 1263
  t 1263 1262 1257
  t 1258 1259 1264
  t 1264 1263 1258
  t 1260 1261 1266
  t 1266 1265 1260
  t 1261 1262 1267
  t 1267 1266 1261
  t 1262 1263 1268
  t 1268 1267 1262
  t 1263 1264 1269
  t 1269 1268 1263
  t 34 414 1245
  t 1245 330 34
  t 415 1249 410
  t 410 43 415
  t 44 420 1269
  t 1269 419 44
  t 334 1265 424
  t 424 35 334
  t 414 413 1246
  t 1246 1245 414
  t 416 1254 1249
  t 1249 415 416
  t 420 421 1268
  t 1268 1269 420
  t 333 1260 1265
  t 1265 334 333
  t 413 412 1247
  t 1247 1246 413
  t 417 1259 1254
  t 1254 416 417
  t 421 422 1267
  t 1267 1268 421
  t 332 1255 1260
  t 1260 333 332
  t 412 411 1248
  t 1248 1247 412
  t 418 1264 1259
  t 1259 417 418
  t 422 423 1266
  t 1266 1267 422
  t 331 1250 1255
  t 1255 332 331
  t 411 410 1249
  t 1249 1248 411
  t 419 1269 1264
  t 1264 418 419
  t 423 424 1265
  t 1265 1266 423
  t 330 1245 1250
  t 1250 331 330
  t 1270 1271 1276
  t 1276 1275 1270
  t 1271 1272 1277
  t 1277 1276 1271
  t 1272 1273 1278
  t 1278 1277 1272
  t 1273 1274 1279
  t 1279 1278 1273
  t 1275 1276 1281
  t 1281 1280 1275
  t 1276 1277 1282
  t 1282 1281 1276
  t 1277 1278 1283
  t 1283 1282 1277
  t 1278 1279 1284
  t 1284 1283 1278
  t 1280 1281 1286
  t 1286 1285 1280
  t 1281 1282 1287
  t 1287 1286 1281
  t 1282 1283 1288
  t 1288 1287 1282
  t 1283 1284 1289
  t 1289 1288 1283
  t 1285 1286 1291
  t 1291 1290 1285
  t 1286 1287 1292
  t 1292 1291 1286
  t 1287 1288 1293
  t 1293 1292 1287
  t 1288 1289 1294
  t 1294 1293 1288
  t 36 425 1270
  t 1270 345 36
  t 64 1274 429
  t 429 0 64
  t 1 430 1294
  t 1294 60 1
  t 349 1290 434
  t 434 37 349
  t 425 426 1271
  t 1271 1270 425
  t 63 1279 1274
  t 1274 64 63
  t 430 431 1293
  t 1293 1294 430
  t 348 1285 1290
  t 1290 349 348
  t 426 427 1272
  t 1272 1271 426
  t 62 1284 1279
  t 1279 63 62
  t 431 432 1292
  t 1292 1293 431
  t 347 1280 1285
  t 1285 348 347
  t 427 428 1273
  t 1273 1272 427
  t 61 1289 1284
  t 1284 62 61
  t 432 433 1291
  t 1291 1292 432
  t 346 1275 1280
  t 1280 347 346
  t 428 429 1274
  t 1274 1273 428
  t 60 1294 1289
  t 1289 61 60
  t 433 434 1290
  t 1290 1291 433
  t 345 1270 1275
  t 1275 346 345
  t 1295 1296 1301
  t 1301 1300 1295
  t 1296 1297 1302
  t 1302 1301 1296
  t 1297 1298 1303
  t 1303 1302 1297
  t 1298 1299 1304
  t 1304 1303 1298
  t 1300 1301 1306
  t 1306 1305 1300
  t 1301 1302 1307
  t 1307 1306 1301
  t 1302 1303 1308
  t 1308 1307 1302
  t 1303 1304 1309
  t 1309 1308 1303
  t 1305 1306 1311
  t 1311 1310 1305
  t 1306 1307 1312
  t 1312 1311 1306
  t 1307 1308 1313
  t 1313 1312 1307
  t 1308 1309 1314
  t 1314 1313 1308
  t 1310 1311 1316
  t 1316 1315 1310
  t 1311 1312 1317
  t 1317 1316 1311
  t 1312 1313 1318
  t 1318 1317 1312
  t 1313 1314 1319
  t 1319 1318 1313
  t 37 434 1295
  t 1295 355 37
  t 79 1299 430
  t 430 1 79
  t 2 435 1319
  t 1319 75 2
  t 359 1315 439
  t 439 38 359
  t 434 433 1296
  t 1296 1295 434
  t 78 1304 1299
  t 1299 79 78
  t 435 436 1318
  t 1318 1319 435
  t 358 1310 1315
  t 1315 359 358
  t 433 432 1297
  t 1297 1296 433
  t 77 1309 1304
  t 1304 78 77
  t 436 437 1317
  t 1317 1318 436
  t 357 1305 1310
  t 1310 358 357
  t 432 431 1298
  t 1298 1297 432
  t 76 1314 1309
  t 1309 77 76
  t 437 438 1316
  t 1316 1317 437
  t 356 1300 1305
  t 1305 357 356
  t 431 430 1299
  t 1299 1298 431
  t 75 1319 1314
  t 1314 76 75
  t 438 439 1315
  t 1315 1316 438
  t 355 1295 1300
  t 1300 356 355
  t 1320 1321 1326
  t 1326 1325 1320
  t 1321 1322 1327
  t 1327 1326 1321
  t 1322 1323 1328
  t 1328 1327 1322
  t 1323 1324 1329
  t 1329 1328 1323
  t 1325 1326 1331
  t 1331 1330 1325
  t 1326 1327 1332
  t 1332 1331 1326
  t 1327 1328 1333
  t 1333 1332 1327
  t 1328 1329 1334
  t 1334 1333 1328
  t 1330 1331 1336
  t 1336 1335 1330
  t 1331 1332 1337
  t 1337 1336 1331
  t 1332 1333 1338
  t 1338 1337 1332
  t 1333 1334 1339
  t 1339 1338 1333
  t 1335 1336 1341
  t 1341 1340 1335
  t 1336 1337 1342
  t 1342 1341 1336
  t 1337 1338 1343
  t 1343 1342 1337
  t 1338 1339 1344
  t 1344 1343 1338
  t 38 439 1320
  t 1320 365 38
  t 94 1324 435
  t 435 2 94
  t 3 440 1344
  t 1344 90 3
  t 369 1340 444
  t 444 39 369
  t 439 438 1321
  t 1321 1320 439
  t 93 1329 1324
  t 1324 94 93
  t 440 441 1343
  t 1343 1344 440
  t 368 1335 1340
  t 1340 369 368
  t 438 437 1322
  t 1322 1321 438
  t 92 1334 1329
  t 1329 93 92
  t 441 442 1342
  t 1342 1343 441
  t 367 1330 1335
  t 1335 368 367
  t 437 436 1323
  t 1323 1322 437
  t 91 1339 1334
  t 1334 92 91
  t 442 443 1341
  t 1341 1342 442
  t 366 1325 1330
  t 1330 367 366
  t 436 435 1324
  t 1324 1323 436
  t 90 1344 1339
  t 1339 91 90
  t 443 444 1340
  t 1340 1341 443
  t 365 1320 1325
  t 1325 366 365
  t 1345 1346 1351
  t 1351 1350 1345
  t 1346 1347 1352
  t 1352 1351 1346
  t 1347 1348 1353
  t 1353 1352 1347
  t 1348 1349 1354
  t 1354 1353 1348
  t 1350 1351 1356
  t 1356 1355 1350
  t 1351 1352 1357
  t 1357 1356 1351
  t 1352 1353 1358
  t 1358 1357 1352
  t 1353 1354 1359
  t 1359 1358 1353
  t 1355 1356 1361
  t 1361 1360 1355
  t 1356 1357 1362
  t 1362 1361 1356
  t 1357 1358 1363
  t 1363 1362 1357
  t 1358 1359 1364
  t 1364 1363 1358
  t 1360 1361 1366
  t 1366 1365 1360
  t 1361 1362 1367
  t 1367 1366 1361
  t 1362 1363 1368
  t 1368 1367 1362
  t 1363 1364 1369
  t 1369 1368 1363
  t 39 444 1345
  t 1345 375 39
  t 109 1349 440
  t 440 3 109
  t 4 445 1369
  t 1369 105 4
  t 379 1365 449
  t 449 40 379
  t 444 443 1346
  t 1346 1345 444
  t 108 1354 1349
  t 1349 109 108
  t 445 446 1368
  t 1368 1369 445
  t 378 1360 1365
  t 1365 379 378
  t 443 442 1347
  t 1347 1346 443
  t 107 1359 1354
  t 1354 108 107
  t 446 447 1367
  t 1367 1368 446
  t 377 1355 1360
  t 1360 378 377
  t 442 441 1348
  t 1348 1347 442
  t 106 1364 1359
  t 1359 107 106
  t 447 448 1366
  t 1366 1367 447
  t 376 1350 1355
  t 1355 377 376
  t 441 440 1349
  t 1349 1348 441
  t 105 1369 1364
  t 1364 106 105
  t 448 449 1365
  t 1365 1366 448
  t 375 1345 1350
  t 1350 376 375
  t 1370 1371 1376
  t 1376 1375 1370
  t 1371 1372 1377
  t 1377 1376 1371
  t 1372 1373 1378
  t 1378 1377 1372
  t 1373 1374 1379
  t 1379 1378 1373
  t 1375 1376 1381
  t 1381 1380 1375
  t 1376 1377 1382
  t 1382 1381 1376
  t 1377 1378 1383
  t 1383 1382 1377
  t 1378 1379 1384
  t 1384 1383 1378
  t 1380 1381 1386
  t 1386 1385 1380
  t 1381 1382 1387
  t 1387 1386 1381
  t 1382 1383 1388
  t 1388 1387 1382
  t 1383 1384 1389
  t 1389 1388 1383
  t 1385 1386 1391
  t 1391 1390 1385
  t 1386 1387 1392
  t 1392 1391 1386
  t 1387 1388 1393
  t 1393 1392 1387
  t 1388 1389 1394
  t 1394 1393 1388
  t 40 449 1370
  t 1370 385 40
  t 124 1374 445
  t 445 4 124
  t 5 450 1394
  t 1394 120 5
  t 389 1390 454
  t 454 41 389
  t 449 448 1371
  t 1371 1370 449
  t 123 1379 1374
  t 1374 124 123
  t 450 451 1393
  t 1393 1394 450
  t 388 1385 1390
  t 1390 389 388
  t 448 447 1372
  t 1372 1371 448
  t 122 1384 1379
  t 1379 123 122
  t 451 452 1392
  t 1392 1393 451
  t 387 1380 1385
  t 1385 388 387
  t 447 446 1373
  t 1373 1372 447
  t 121 1389 1384
  t 1384 122 121
  t 452 453 1391
  t 1391 1392 452
  t 386 1375 1380
  t 1380 387 386
  t 446 445 1374
  t 1374 1373 446
  t 120 1394 1389
  t 1389 121 120
  t 453 454 1390
  t 1390 1391 453
  t 385 1370 1375
  t 1375 386 385
  t 1395 1396 1401
  t 1401 1400 1395
  t 1396 1397 1402
  t 1402 1401 1396
  t 1397 1398 1403
  t 1403 1402 1397
  t 1398 1399 1404
  t 1404 1403 1398
  t 1400 1401 1406
  t 1406 1405 1400
  t 1401 1402 1407
  t 1407 1406 1401
  t 1402 1403 1408
  t 1408 1407 1402
  t 1403 1404 1409
  t 1409 1408 1403
  t 1405 1406 1411
  t 1411 1410 1405
  t 1406 1407 1412
  t 1412 1411 1406
  t 1407 1408 1413
  t 1413 1412 1407
  t 1408 1409 1414
  t 1414 1413 1408
  t 1410 1411 1416
  t 1416 1415 1410
  t 1411 1412 1417
  t 1417 1416 1411
  t 1412 1413 1418
  t 1418 1417 1412
  t 1413 1414 1419
  t 1419 1418 1413
  t 41 454 1395
  t 1395 395 41
  t 139 1399 450
  t 450 5 139
  t 6 455 1419
  t 1419 135 6
  t 399 1415 459
  t 459 42 399
  t 454 453 1396
  t 1396 1395 454
  t 138 1404 1399
  t 1399 139 138
  t 455 456 1418
  t 1418 1419 455
  t 398 1410 1415
  t 1415 399 398
  t 453 452 1397
  t 1397 1396 453
  t 137 1409 1404
  t 1404 138 137
  t 456 457 1417
  t 1417 1418 456
  t 397 1405 1410
  t 1410 398 397
  t 452 451 1398
  t 1398 1397 452
  t 136 1414 1409
  t 1409 137 136
  t 457 458 1416
  t 1416 1417 457
  t 396 1400 1405
  t 1405 397 396
  t 451 450 1399
  t 1399 1398 451
  t 135 1419 1414
  t 1414 136 135
  t 458 459 1415
  t 1415 1416 458
  t 395 1395 1400
  t 1400 396 395
  t 1420 1421 1426
  t 1426 1425 1420
  t 1421 1422 1427
  t 1427 1426 1421
  t 1422 1423 1428
  t 1428 1427 1422
  t 1423 1424 1429
  t 1429 1428 1423
  t 1425 1426 1431
  t 1431 1430 1425
  t 1426 1427 1432
  t 1432 1431 1426
  t 1427 1428 1433
  t 1433 1432 1427
  t 1428 1429 1434
  t 1434 1433 1428
  t 1430 1431 1436
  t 1436 1435 1430
  t 1431 1432 1437
  t 1437 1436 1431
  t 1432 1433 1438
  t 1438 1437 1432
  t 1433 1434 1439
  t 1439 1438 1433
  t 1435 1436 1441
  t 1441 1440 1435
  t 1436 1437 1442
  t 1442 1441 1436
  t 1437 1438 1443
  t 1443 1442 1437
  t 1438 1439 1444
  t 1444 1443 1438
  t 42 459 1420
  t 1420 405 42
  t 154 1424 455
  t 455 6 154
  t 7 460 1444
  t 1444 150 7
  t 409 1440 464
  t 464 43 409
  t 459 458 1421
  t 1421 1420 459
  t 153 1429 1424
  t 1424 154 153
  t 460 461 1443
  t 1443 1444 460
  t 408 1435 1440
  t 1440 409 408
  t 458 457 1422
  t 1422 1421 458
  t 152 1434 1429
  t 1429 153 152
  t 461 462 1442
  t 1442 1443 461
  t 407 1430 1435
  t 1435 408 407
  t 457 456 1423
  t 1423 1422 457
  t 151 1439 1434
  t 1434 152 151
  t 462 463 1441
  t 1441 1442 462
  t 406 1425 1430
  t 1430 407 406
  t 456 455 1424
  t 1424 1423 456
  t 150 1444 1439
  t 1439 151 150
  t 463 464 1440
  t 1440 1441 463
  t 405 1420 1425
  t 1425 406 405
  t 1445 1446 1451
  t 1451 1450 1445
  t 1446 1447 1452
  t 1452 1451 1446
  t 1447 1448 1453
  t 1453 1452 1447
  t 1448 1449 1454
  t 1454 1453 1448
  t 1450 1451 1456
  t 1456 1455 1450
  t 1451 1452 1457
  t 1457 1456 1451
  t 1452 1453 1458
  t 1458 1457 1452
  t 1453 1454 1459
  t 1459 1458 1453
  t 1455 1456 1461
  t 1461 1460 1455
  t 1456 1457 1462
  t 1462 1461 1456
  t 1457 1458 1463
  t 1463 1462 1457
  t 1458 1459 1464
  t 1464 1463 1458
  t 1460 1461 1466
  t 1466 1465 1460
  t 1461 1462 1467
  t 1467 1466 1461
  t 1462 1463 1468
  t 1468 1467 1462
  t 1463 1464 1469
  t 1469 1468 1463
  t 43 464 1445
  t 1445 415 43
  t 169 1449 460
  t 460 7 169
  t 8 465 1469
  t 1469 165 8
  t 419 1465 469
  t 469 44 419
  t 464 463 1446
  t 1446 1445 464
  t 168 1454 1449
  t 1449 169 168
  t 465 466 1468
  t 1468 1469 465
  t 418 1460 1465
  t 1465 419 418
  t 463 462 1447
  t 1447 1446 463
  t 167 1459 1454
  t 1454 168 167
  t 466 467 1467
  t 1467 1468 466
  t 417 1455 1460
  t 1460 418 417
  t 462 461 1448
  t 1448 1447 462
  t 166 1464 1459
  t 1459 167 166
  t 467 468 1466
  t 1466 1467 467
  t 416 1450 1455
  t 1455 417 416
  t 461 460 1449
  t 1449 1448 461
  t 165 1469 1464
  t 1464 166 165
  t 468 469 1465
  t 1465 1466 468
  t 415 1445 1450
  t 1450 416 415
}

object {
  shader Cognac
  type flat-mesh
  name AirCognac	
  128 192
  v 0 3.8 6.5    0.0146806 -0.447166 0.894331    0 0
  v 0 3.76 6.48    0.00886772 -0.754966 0.655704    0 0
  v 0 3.75 6.45    -0.0270598 -0.824231 0.565607    0 0
  v 0 0 6.45    0 0 1    0 0
  v -0.741343 3.72698 6.5    0.101636 -0.435709 0.894331    0 0
  v -0.73354 3.68775 6.48    0.155984 -0.738729 0.655705    0 0
  v -0.731589 3.67794 6.45    0.0950192 -0.575859 0.812009    0 0
  v 3.38243e-009 0 6.45    0 0 1    0 0
  v -1.4542 3.51074 6.5    0.184686 -0.407508 0.894331    0 0
  v -1.43889 3.47379 6.48    0.297106 -0.694104 0.655704    0 0
  v -1.43506 3.46455 6.45    0.290419 -0.771844 0.565608    0 0
  v -2.8295e-008 0 6.45    0 0 1    0 0
  v -2.11117 3.15958 6.5    0.260638 -0.363648 0.894331    0 0
  v -2.08894 3.12633 6.48    0.42681 -0.622804 0.655705    0 0
  v -2.08339 3.11801 6.45    0.308158 -0.495662 0.812009    0 0
  v -1.72542e-008 0 6.45    0 0 1    0 0
  v -2.68701 2.68701 6.5    0.326575 -0.305813 0.894331    0 0
  v -2.65872 2.65872 6.48    0.540113 -0.527572 0.655703    0 0
  v -2.65165 2.65165 6.45    0.563684 -0.601953 0.565608    0 0
  v -5.37288e-008 0 6.45    0 0 1    0 0
  v -3.15958 2.11117 6.5    0.379962 -0.236226 0.89433    0 0
  v -3.12633 2.08894 6.48    0.632659 -0.412064 0.655703    0 0
  v -3.11801 2.08339 6.45    0.474384 -0.340006 0.812007    0 0
  v 5.67739e-008 0 6.45    0 0 1    0 0
  v -3.51074 1.4542 6.5    0.418745 -0.15756 0.894331    0 0
  v -3.47379 1.43889 6.48    0.700892 -0.280721 0.655702    0 0
  v -3.46455 1.43506 6.45    0.751135 -0.34042 0.565606    0 0
  v 1.16533e-008 0 6.45    0 0 1    0 0
  v -3.72698 0.741343 6.5    0.441438 -0.0728392 0.894331    0 0
  v -3.68775 0.733539 6.48    0.74219 -0.138589 0.655703    0 0
  v -3.67794 0.731588 6.45    0.568388 -0.132586 0.812007    0 0
  v 1.01062e-007 0 6.45    0 0 1    0 0
  v -3.8 -2.38419e-007 6.5    0.447165 0.0146806 0.894331    0 0
  v -3.76 -2.38419e-007 6.48    0.754967 0.00886787 0.655703    0 0
  v -3.75 -2.38419e-007 6.45    0.824231 -0.0270597 0.565607    0 0
  v 0 0 6.45    0 0 1    0 0
  v -3.72698 -0.741343 6.5    0.435708 0.101636 0.894331    0 0
  v -3.68775 -0.73354 6.48    0.73873 0.155984 0.655704    0 0
  v -3.67794 -0.731589 6.45    0.813672 0.13426 0.565608    0 0
  v -6.747e-008 0 6.45    0 0 -1    0 0
  v -3.51074 -1.4542 6.5    0.407509 0.184686 0.894331    0 0
  v -3.47379 -1.43889 6.48    0.694104 0.297106 0.655704    0 0
  v -3.46455 -1.43506 6.45    0.546258 0.205538 0.812008    0 0
  v 1.16533e-008 2.38419e-007 6.45    0 0 1    0 0
  v -3.15958 -2.11117 6.5    0.363648 0.260638 0.894331    0 0
  v -3.12633 -2.08894 6.48    0.622805 0.42681 0.655704    0 0
  v -3.11801 -2.08339 6.45    0.700355 0.435418 0.565609    0 0
  v -4.18718e-008 0 6.45    0 0 1    0 0
  v -2.68701 -2.68701 6.5    0.305813 0.326574 0.894331    0 0
  v -2.65872 -2.65872 6.48    0.527572 0.540113 0.655702    0 0
  v -2.65165 -2.65165 6.45    0.426021 0.398937 0.812007    0 0
  v -5.37288e-008 0 6.45    0 0 1    0 0
  v -2.11117 -3.15958 6.5    0.236225 0.37996 0.894331    0 0
  v -2.08894 -3.12633 6.48    0.412064 0.632659 0.655703    0 0
  v -2.08339 -3.11801 6.45    0.480418 0.67029 0.565606    0 0
  v 5.26323e-008 0 6.45    0 0 1    0 0
  v -1.4542 -3.51074 6.5    0.15756 0.418745 0.894331    0 0
  v -1.43889 -3.47379 6.48    0.280721 0.700893 0.655702    0 0
  v -1.43506 -3.46455 6.45    0.34042 0.751135 0.565606    0 0
  v -5.70542e-008 0 6.45    0 0 -1    0 0
  v -0.741343 -3.72698 6.5    0.0728386 0.441435 0.894332    0 0
  v -0.73354 -3.68775 6.48    0.13859 0.742192 0.655701    0 0
  v -0.731589 -3.67794 6.45    0.132586 0.56839 0.812006    0 0
  v 2.0854e-008 2.38419e-007 6.45    0 0 1    0 0
  v 3.32207e-007 -3.8 6.5    -0.0146808 0.447166 0.894331    0 0
  v 3.2871e-007 -3.76 6.48    -0.00886795 0.754969 0.655701    0 0
  v 3.27835e-007 -3.75 6.45    0.0191512 0.583336 0.812005    0 0
  v 9.50504e-015 0 6.45    0 0 1    0 0
  v 0.741344 -3.72698 6.5    -0.101637 0.43571 0.89433    0 0
  v 0.73354 -3.68775 6.48    -0.155985 0.738732 0.655701    0 0
  v 0.731589 -3.67794 6.45    -0.13426 0.813676 0.565603    0 0
  v 9.99139e-009 2.38419e-007 6.45    0 0 1    0 0
  v 1.4542 -3.51074 6.5    -0.184686 0.407509 0.894331    0 0
  v 1.43889 -3.47379 6.48    -0.297106 0.694106 0.655702    0 0
  v 1.43506 -3.46455 6.45    -0.29042 0.771847 0.565605    0 0
  v -6.64825e-009 2.38419e-007 6.45    0 0 -1    0 0
  v 2.11117 -3.15958 6.5    -0.260638 0.363648 0.894331    0 0
  v 2.08894 -3.12633 6.48    -0.42681 0.622805 0.655703    0 0
  v 2.08339 -3.11801 6.45    -0.30816 0.495664 0.812007    0 0
  v -3.20686e-008 -2.38419e-007 6.45    0 0 1    0 0
  v 2.68701 -2.68701 6.5    -0.326576 0.305814 0.89433    0 0
  v 2.65872 -2.65872 6.48    -0.540112 0.527571 0.655703    0 0
  v 2.65165 -2.65165 6.45    -0.398936 0.42602 0.812008    0 0
  v -4.49169e-008 0 6.45    0 0 1    0 0
  v 3.15959 -2.11117 6.5    -0.379961 0.236225 0.894331    0 0
  v 3.12633 -2.08894 6.48    -0.63266 0.412064 0.655702    0 0
  v 3.11801 -2.08339 6.45    -0.670289 0.480418 0.565607    0 0
  v 8.2999e-008 0 6.45    0 0 1    0 0
  v 3.51074 -1.4542 6.5    -0.418744 0.157559 0.894331    0 0
  v 3.47379 -1.43889 6.48    -0.700893 0.280721 0.655702    0 0
  v 3.46455 -1.43506 6.45    -0.531602 0.240926 0.812006    0 0
  v -4.04125e-008 0 6.45    0 0 1    0 0
  v 3.72698 -0.741343 6.5    -0.441436 0.0728389 0.894331    0 0
  v 3.68775 -0.73354 6.48    -0.74219 0.138589 0.655703    0 0
  v 3.67794 -0.731589 6.45    -0.803115 0.187339 0.565606    0 0
  v 6.747e-008 0 6.45    0 0 1    0 0
  v 3.8 0 6.5    -0.447165 -0.0146806 0.894331    0 0
  v 3.76 0 6.48    -0.754966 -0.00886783 0.655703    0 0
  v 3.75 0 6.45    -0.693234 0.0227593 0.720353    0 0
  v 0 0 6.45    0 0 0    0 0
  v 3.72698 0.741343 6.5    -0.435708 -0.101636 0.894331    0 0
  v 3.68775 0.73354 6.48    -0.73873 -0.155984 0.655703    0 0
  v 3.67794 0.731589 6.45    -0.575861 -0.0950197 0.812007    0 0
  v 6.747e-008 0 6.45    0 0 1    0 0
  v 3.51074 1.4542 6.5    -0.407509 -0.184686 0.894331    0 0
  v 3.47379 1.43889 6.48    -0.694105 -0.297106 0.655703    0 0
  v 3.46455 1.43506 6.45    -0.771846 -0.29042 0.565606    0 0
  v -8.15398e-008 0 6.45    0 0 1    0 0
  v 3.15958 2.11117 6.5    -0.363648 -0.260639 0.894331    0 0
  v 3.12633 2.08894 6.48    -0.622805 -0.42681 0.655704    0 0
  v 3.11801 2.08339 6.45    -0.700356 -0.435419 0.565608    0 0
  v -2.80147e-008 0 6.45    0 0 -1    0 0
  v 2.687 2.68701 6.5    -0.305813 -0.326575 0.894331    0 0
  v 2.65872 2.65872 6.48    -0.527571 -0.540112 0.655704    0 0
  v 2.65165 2.65165 6.45    -0.42602 -0.398936 0.812008    0 0
  v 1.26015e-008 0 6.45    0 0 1    0 0
  v 2.11117 3.15958 6.5    -0.236225 -0.37996 0.894331    0 0
  v 2.08894 3.12633 6.48    -0.412063 -0.632658 0.655704    0 0
  v 2.08339 3.11801 6.45    -0.480417 -0.670288 0.56561    0 0
  v -3.20686e-008 0 6.45    0 0 1    0 0
  v 1.4542 3.51074 6.5    -0.15756 -0.418745 0.894331    0 0
  v 1.43889 3.47379 6.48    -0.28072 -0.700891 0.655704    0 0
  v 1.43506 3.46455 6.45    -0.340419 -0.751133 0.56561    0 0
  v -6.64825e-009 0 6.45    0 0 -1    0 0
  v 0.741343 3.72698 6.5    -0.0728391 -0.441438 0.894331    0 0
  v 0.733539 3.68775 6.48    -0.138589 -0.74219 0.655703    0 0
  v 0.731588 3.67794 6.45    -0.132585 -0.568388 0.812008    0 0
  v 1.09972e-008 0 6.45    0 0 1    0 0
  t 0 5 1
  t 0 4 5
  t 1 6 2
  t 1 5 6
  t 2 7 3
  t 2 6 7
  t 4 9 5
  t 4 8 9
  t 5 10 6
  t 5 9 10
  t 6 11 7
  t 6 10 11
  t 8 13 9
  t 8 12 13
  t 9 14 10
  t 9 13 14
  t 10 15 11
  t 10 14 15
  t 12 17 13
  t 12 16 17
  t 13 18 14
  t 13 17 18
  t 14 19 15
  t 14 18 19
  t 16 21 17
  t 16 20 21
  t 17 22 18
  t 17 21 22
  t 18 23 19
  t 18 22 23
  t 20 25 21
  t 20 24 25
  t 21 26 22
  t 21 25 26
  t 22 27 23
  t 22 26 27
  t 24 29 25
  t 24 28 29
  t 25 30 26
  t 25 29 30
  t 26 31 27
  t 26 30 31
  t 28 33 29
  t 28 32 33
  t 29 34 30
  t 29 33 34
  t 30 35 31
  t 30 34 35
  t 32 37 33
  t 32 36 37
  t 33 38 34
  t 33 37 38
  t 34 39 35
  t 34 38 39
  t 36 41 37
  t 36 40 41
  t 37 42 38
  t 37 41 42
  t 38 43 39
  t 38 42 43
  t 40 45 41
  t 40 44 45
  t 41 46 42
  t 41 45 46
  t 42 47 43
  t 42 46 47
  t 44 49 45
  t 44 48 49
  t 45 50 46
  t 45 49 50
  t 46 51 47
  t 46 50 51
  t 48 53 49
  t 48 52 53
  t 49 54 50
  t 49 53 54
  t 50 55 51
  t 50 54 55
  t 52 57 53
  t 52 56 57
  t 53 58 54
  t 53 57 58
  t 54 59 55
  t 54 58 59
  t 56 61 57
  t 56 60 61
  t 57 62 58
  t 57 61 62
  t 58 63 59
  t 58 62 63
  t 60 65 61
  t 60 64 65
  t 61 66 62
  t 61 65 66
  t 62 67 63
  t 62 66 67
  t 64 69 65
  t 64 68 69
  t 65 70 66
  t 65 69 70
  t 66 71 67
  t 66 70 71
  t 68 73 69
  t 68 72 73
  t 69 74 70
  t 69 73 74
  t 70 75 71
  t 70 74 75
  t 72 77 73
  t 72 76 77
  t 73 78 74
  t 73 77 78
  t 74 79 75
  t 74 78 79
  t 76 81 77
  t 76 80 81
  t 77 82 78
  t 77 81 82
  t 78 83 79
  t 78 82 83
  t 80 85 81
  t 80 84 85
  t 81 86 82
  t 81 85 86
  t 82 87 83
  t 82 86 87
  t 84 89 85
  t 84 88 89
  t 85 90 86
  t 85 89 90
  t 86 91 87
  t 86 90 91
  t 88 93 89
  t 88 92 93
  t 89 94 90
  t 89 93 94
  t 90 95 91
  t 90 94 95
  t 92 97 93
  t 92 96 97
  t 93 98 94
  t 93 97 98
  t 94 99 95
  t 94 98 99
  t 96 101 97
  t 96 100 101
  t 97 102 98
  t 97 101 102
  t 98 103 99
  t 98 102 103
  t 100 105 101
  t 100 104 105
  t 101 106 102
  t 101 105 106
  t 102 107 103
  t 102 106 107
  t 104 109 105
  t 104 108 109
  t 105 110 106
  t 105 109 110
  t 106 111 107
  t 106 110 111
  t 108 113 109
  t 108 112 113
  t 109 114 110
  t 109 113 114
  t 110 115 111
  t 110 114 115
  t 112 117 113
  t 112 116 117
  t 113 118 114
  t 113 117 118
  t 114 119 115
  t 114 118 119
  t 116 121 117
  t 116 120 121
  t 117 122 118
  t 117 121 122
  t 118 123 119
  t 118 122 123
  t 120 125 121
  t 120 124 125
  t 121 126 122
  t 121 125 126
  t 122 127 123
  t 122 126 127
  t 124 1 125
  t 124 0 1
  t 125 2 126
  t 125 1 2
  t 126 3 127
  t 126 2 3
}

object {
  shader Ground
  type mesh
  name Plane	
  4 2
  v -50.0899 -50.2808 0    0 0 1    0 0
  v 49.9101 -50.2808 0    0 0 1    4 0
  v -50.0899 49.7192 0    0 0 1    0 4
  v 49.9101 49.7192 0    0 0 1    4 4
  t 2 0 3
  t 1 3 0
}

light {
  type mesh
  name Light
  emit 100 100 100
  4 2
  v -45 -35 60    0 0 -1    0 0
  v -35 -35 60    0 0 -1    0 0
  v -45 -45 60    0 0 -1    0 0
  v -35 -45 60    0 0 -1    0 0
  t 2 0 3
  t 1 3 0
}