package org.sunflow.system;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class Parser {
    private BufferedReader bf;
    private String line;
    private StringTokenizer st;

    public Parser(String filename) {
        try {
            bf = new BufferedReader(new FileReader(filename));
            line = bf.readLine();
            st = new StringTokenizer(line);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
            bf = null;
        } catch (IOException e) {
            e.printStackTrace();
            bf = null;
        }
    }

    public String getNextToken() {
        if (bf == null)
            return null;

        // ignore comments and empty lines
        while (line.startsWith("%") || (line.length() == 0) || !st.hasMoreTokens()) {
            try {
                line = bf.readLine();
                if (line == null)
                    return null;
                st = new StringTokenizer(line);
            } catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return st.nextToken();
    }

    public boolean getNextBoolean() {
        return Boolean.valueOf(getNextToken()).booleanValue();
    }

    public int getNextInt() {
        return Integer.parseInt(getNextToken());
    }

    public double getNextDouble() {
        return Double.parseDouble(getNextToken());
    }
}